import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::ACMPCA::Certificate`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html
 */
export interface CfnCertificateProps {
    /**
     * `AWS::ACMPCA::Certificate.CertificateAuthorityArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-certificateauthorityarn
     */
    readonly certificateAuthorityArn: string;
    /**
     * `AWS::ACMPCA::Certificate.CertificateSigningRequest`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-certificatesigningrequest
     */
    readonly certificateSigningRequest: string;
    /**
     * `AWS::ACMPCA::Certificate.SigningAlgorithm`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-signingalgorithm
     */
    readonly signingAlgorithm: string;
    /**
     * `AWS::ACMPCA::Certificate.Validity`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-validity
     */
    readonly validity: CfnCertificate.ValidityProperty | cdk.IResolvable;
    /**
     * `AWS::ACMPCA::Certificate.TemplateArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-templatearn
     */
    readonly templateArn?: string;
}
/**
 * A CloudFormation `AWS::ACMPCA::Certificate`
 *
 * @cloudformationResource AWS::ACMPCA::Certificate
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html
 */
export declare class CfnCertificate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ACMPCA::Certificate";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnCertificate;
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute Certificate
     */
    readonly attrCertificate: string;
    /**
     * `AWS::ACMPCA::Certificate.CertificateAuthorityArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-certificateauthorityarn
     */
    certificateAuthorityArn: string;
    /**
     * `AWS::ACMPCA::Certificate.CertificateSigningRequest`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-certificatesigningrequest
     */
    certificateSigningRequest: string;
    /**
     * `AWS::ACMPCA::Certificate.SigningAlgorithm`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-signingalgorithm
     */
    signingAlgorithm: string;
    /**
     * `AWS::ACMPCA::Certificate.Validity`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-validity
     */
    validity: CfnCertificate.ValidityProperty | cdk.IResolvable;
    /**
     * `AWS::ACMPCA::Certificate.TemplateArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-templatearn
     */
    templateArn: string | undefined;
    /**
     * Create a new `AWS::ACMPCA::Certificate`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCertificateProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnCertificate {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-validity.html
     */
    interface ValidityProperty {
        /**
         * `CfnCertificate.ValidityProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-validity.html#cfn-acmpca-certificate-validity-type
         */
        readonly type: string;
        /**
         * `CfnCertificate.ValidityProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-validity.html#cfn-acmpca-certificate-validity-value
         */
        readonly value: number;
    }
}
/**
 * Properties for defining a `AWS::ACMPCA::CertificateAuthority`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html
 */
export interface CfnCertificateAuthorityProps {
    /**
     * `AWS::ACMPCA::CertificateAuthority.KeyAlgorithm`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-keyalgorithm
     */
    readonly keyAlgorithm: string;
    /**
     * `AWS::ACMPCA::CertificateAuthority.SigningAlgorithm`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-signingalgorithm
     */
    readonly signingAlgorithm: string;
    /**
     * `AWS::ACMPCA::CertificateAuthority.Subject`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-subject
     */
    readonly subject: CfnCertificateAuthority.SubjectProperty | cdk.IResolvable;
    /**
     * `AWS::ACMPCA::CertificateAuthority.Type`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-type
     */
    readonly type: string;
    /**
     * `AWS::ACMPCA::CertificateAuthority.RevocationConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-revocationconfiguration
     */
    readonly revocationConfiguration?: CfnCertificateAuthority.RevocationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ACMPCA::CertificateAuthority.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::ACMPCA::CertificateAuthority`
 *
 * @cloudformationResource AWS::ACMPCA::CertificateAuthority
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html
 */
export declare class CfnCertificateAuthority extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ACMPCA::CertificateAuthority";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnCertificateAuthority;
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute CertificateSigningRequest
     */
    readonly attrCertificateSigningRequest: string;
    /**
     * `AWS::ACMPCA::CertificateAuthority.KeyAlgorithm`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-keyalgorithm
     */
    keyAlgorithm: string;
    /**
     * `AWS::ACMPCA::CertificateAuthority.SigningAlgorithm`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-signingalgorithm
     */
    signingAlgorithm: string;
    /**
     * `AWS::ACMPCA::CertificateAuthority.Subject`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-subject
     */
    subject: CfnCertificateAuthority.SubjectProperty | cdk.IResolvable;
    /**
     * `AWS::ACMPCA::CertificateAuthority.Type`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-type
     */
    type: string;
    /**
     * `AWS::ACMPCA::CertificateAuthority.RevocationConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-revocationconfiguration
     */
    revocationConfiguration: CfnCertificateAuthority.RevocationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ACMPCA::CertificateAuthority.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ACMPCA::CertificateAuthority`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCertificateAuthorityProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnCertificateAuthority {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-crlconfiguration.html
     */
    interface CrlConfigurationProperty {
        /**
         * `CfnCertificateAuthority.CrlConfigurationProperty.CustomCname`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-crlconfiguration.html#cfn-acmpca-certificateauthority-crlconfiguration-customcname
         */
        readonly customCname?: string;
        /**
         * `CfnCertificateAuthority.CrlConfigurationProperty.Enabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-crlconfiguration.html#cfn-acmpca-certificateauthority-crlconfiguration-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnCertificateAuthority.CrlConfigurationProperty.ExpirationInDays`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-crlconfiguration.html#cfn-acmpca-certificateauthority-crlconfiguration-expirationindays
         */
        readonly expirationInDays?: number;
        /**
         * `CfnCertificateAuthority.CrlConfigurationProperty.S3BucketName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-crlconfiguration.html#cfn-acmpca-certificateauthority-crlconfiguration-s3bucketname
         */
        readonly s3BucketName?: string;
    }
}
export declare namespace CfnCertificateAuthority {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-revocationconfiguration.html
     */
    interface RevocationConfigurationProperty {
        /**
         * `CfnCertificateAuthority.RevocationConfigurationProperty.CrlConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-revocationconfiguration.html#cfn-acmpca-certificateauthority-revocationconfiguration-crlconfiguration
         */
        readonly crlConfiguration?: CfnCertificateAuthority.CrlConfigurationProperty | cdk.IResolvable;
    }
}
export declare namespace CfnCertificateAuthority {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html
     */
    interface SubjectProperty {
        /**
         * `CfnCertificateAuthority.SubjectProperty.CommonName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-commonname
         */
        readonly commonName?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.Country`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-country
         */
        readonly country?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.DistinguishedNameQualifier`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-distinguishednamequalifier
         */
        readonly distinguishedNameQualifier?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.GenerationQualifier`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-generationqualifier
         */
        readonly generationQualifier?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.GivenName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-givenname
         */
        readonly givenName?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.Initials`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-initials
         */
        readonly initials?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.Locality`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-locality
         */
        readonly locality?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.Organization`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-organization
         */
        readonly organization?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.OrganizationalUnit`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-organizationalunit
         */
        readonly organizationalUnit?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.Pseudonym`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-pseudonym
         */
        readonly pseudonym?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.SerialNumber`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-serialnumber
         */
        readonly serialNumber?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.State`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-state
         */
        readonly state?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.Surname`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-surname
         */
        readonly surname?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.Title`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-title
         */
        readonly title?: string;
    }
}
/**
 * Properties for defining a `AWS::ACMPCA::CertificateAuthorityActivation`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html
 */
export interface CfnCertificateAuthorityActivationProps {
    /**
     * `AWS::ACMPCA::CertificateAuthorityActivation.Certificate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html#cfn-acmpca-certificateauthorityactivation-certificate
     */
    readonly certificate: string;
    /**
     * `AWS::ACMPCA::CertificateAuthorityActivation.CertificateAuthorityArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html#cfn-acmpca-certificateauthorityactivation-certificateauthorityarn
     */
    readonly certificateAuthorityArn: string;
    /**
     * `AWS::ACMPCA::CertificateAuthorityActivation.CertificateChain`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html#cfn-acmpca-certificateauthorityactivation-certificatechain
     */
    readonly certificateChain?: string;
    /**
     * `AWS::ACMPCA::CertificateAuthorityActivation.Status`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html#cfn-acmpca-certificateauthorityactivation-status
     */
    readonly status?: string;
}
/**
 * A CloudFormation `AWS::ACMPCA::CertificateAuthorityActivation`
 *
 * @cloudformationResource AWS::ACMPCA::CertificateAuthorityActivation
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html
 */
export declare class CfnCertificateAuthorityActivation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ACMPCA::CertificateAuthorityActivation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnCertificateAuthorityActivation;
    /**
     * @cloudformationAttribute CompleteCertificateChain
     */
    readonly attrCompleteCertificateChain: string;
    /**
     * `AWS::ACMPCA::CertificateAuthorityActivation.Certificate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html#cfn-acmpca-certificateauthorityactivation-certificate
     */
    certificate: string;
    /**
     * `AWS::ACMPCA::CertificateAuthorityActivation.CertificateAuthorityArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html#cfn-acmpca-certificateauthorityactivation-certificateauthorityarn
     */
    certificateAuthorityArn: string;
    /**
     * `AWS::ACMPCA::CertificateAuthorityActivation.CertificateChain`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html#cfn-acmpca-certificateauthorityactivation-certificatechain
     */
    certificateChain: string | undefined;
    /**
     * `AWS::ACMPCA::CertificateAuthorityActivation.Status`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html#cfn-acmpca-certificateauthorityactivation-status
     */
    status: string | undefined;
    /**
     * Create a new `AWS::ACMPCA::CertificateAuthorityActivation`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCertificateAuthorityActivationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
