#
# rbfly - a library for RabbitMQ Streams using Python asyncio
#
# Copyright (C) 2021-2024 by Artur Wroblewski <wrobell@riseup.net>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Exception hierarchy for RabbitMQ client.
"""

class RbFlyError(Exception):
    """
    Basic RbFly exception.
    """

class RbFlyBufferError(RbFlyError):
    """
    Buffer access error.

    Raised when

    - encoding of a message leads to buffer overflow
    - and it is possible to recover from the error

    .. seealso::

       - :py:class:`~rbfly.error.AMQPDecoderError`
    """

class AMQPError(RbFlyError):
    """
    AMQP error.
    """

class AMQPDecoderError(AMQPError):
    """
    AMQP binary format decoder error.
    """

# vim: sw=4:et:ai
