"use strict";define(["datetime","events","itemHelper","serverNotifications","dom","globalize","loading","connectionManager","playMethodHelper","cardBuilder","imageLoader","components/activitylog","scripts/imagehelper","indicators","humanedate","listViewStyle","emby-button","flexStyles","emby-button","emby-itemscontainer"],(function(datetime,events,itemHelper,serverNotifications,dom,globalize,loading,connectionManager,playMethodHelper,cardBuilder,imageLoader,ActivityLog,imageHelper,indicators){function showPlaybackInfo(btn,session){require(["alert"],(function(alert){var title,text=[],displayPlayMethod=playMethodHelper.getDisplayPlayMethod(session);"DirectStream"===displayPlayMethod?(title=globalize.translate("DirectStreaming"),text.push(globalize.translate("DirectStreamHelp1")),text.push("<br/>"),text.push(globalize.translate("DirectStreamHelp2"))):"Transcode"===displayPlayMethod&&(title=globalize.translate("Transcoding"),text.push(globalize.translate("MediaIsBeingConverted")),session.TranscodingInfo&&session.TranscodingInfo.TranscodeReasons&&session.TranscodingInfo.TranscodeReasons.length&&(text.push("<br/>"),text.push(globalize.translate("LabelReasonForTranscoding")),session.TranscodingInfo.TranscodeReasons.forEach((function(transcodeReason){text.push(globalize.translate(transcodeReason))})))),alert({text:text.join("<br/>"),title:title})}))}function showSendMessageForm(btn,session){require(["prompt"],(function(prompt){prompt({title:globalize.translate("HeaderSendMessage"),label:globalize.translate("LabelMessageText"),confirmText:globalize.translate("ButtonSend")}).then((function(text){text&&connectionManager.getApiClient(session.ServerId).sendMessageCommand(session.Id,{Text:text,TimeoutMs:5e3})}))}))}function onActiveDevicesClick(evt){var btn=dom.parentWithClass(evt.target,"sessionCardButton");if(btn){var card=dom.parentWithClass(btn,"card");if(card){var sessionId=card.id,session=(DashboardPage.sessionsList||[]).filter((function(dashboardSession){return"session"+dashboardSession.Id===sessionId}))[0];session&&(btn.classList.contains("btnCardOptions")?function showOptionsMenu(btn,session){require(["actionsheet"],(function(actionsheet){var menuItems=[];return session.ServerId&&session.DeviceId!==connectionManager.deviceId()&&menuItems.push({name:globalize.translate("SendMessage"),id:"sendmessage"}),session.TranscodingInfo&&session.TranscodingInfo.TranscodeReasons&&session.TranscodingInfo.TranscodeReasons.length&&menuItems.push({name:globalize.translate("ViewPlaybackInfo"),id:"transcodinginfo"}),actionsheet.show({items:menuItems,positionTo:btn}).then((function(id){switch(id){case"sendmessage":showSendMessageForm(0,session);break;case"transcodinginfo":showPlaybackInfo(0,session)}}))}))}(btn,session):btn.classList.contains("btnSessionInfo")?showPlaybackInfo(0,session):btn.classList.contains("btnSessionSendMessage")?showSendMessageForm(0,session):btn.classList.contains("btnSessionStop")?connectionManager.getApiClient(session.ServerId).sendPlayStateCommand(session.Id,"Stop"):btn.classList.contains("btnSessionPlayPause")&&session.PlayState&&connectionManager.getApiClient(session.ServerId).sendPlayStateCommand(session.Id,"PlayPause"))}}}function reloadSystemInfo(view,apiClient){apiClient.getSystemInfo().then((function(systemInfo){view.querySelector("#serverName").innerHTML=globalize.translate("DashboardServerName",systemInfo.ServerName);var localizedVersion=globalize.translate("DashboardVersionNumber",systemInfo.Version);"Release"!==systemInfo.SystemUpdateLevel&&(localizedVersion+=" "+systemInfo.SystemUpdateLevel),view.querySelector("#versionNumber").innerHTML=localizedVersion,view.querySelector("#operatingSystem").innerHTML=globalize.translate("DashboardOperatingSystem",systemInfo.OperatingSystem),view.querySelector("#architecture").innerHTML=globalize.translate("DashboardArchitecture",systemInfo.SystemArchitecture),systemInfo.CanSelfRestart?view.querySelector("#btnRestartServer").classList.remove("hide"):view.querySelector("#btnRestartServer").classList.add("hide"),view.querySelector("#cachePath").innerHTML=systemInfo.CachePath,view.querySelector("#logPath").innerHTML=systemInfo.LogPath,view.querySelector("#transcodePath").innerHTML=systemInfo.TranscodingTempPath,view.querySelector("#metadataPath").innerHTML=systemInfo.InternalMetadataPath,view.querySelector("#webPath").innerHTML=systemInfo.WebPath}))}function renderInfo(view,sessions,forceUpdate){(function renderActiveConnections(view,sessions){var html="";DashboardPage.sessionsList=sessions;var parentElement=view.querySelector(".activeDevices"),cardElem=parentElement.querySelector(".card");cardElem&&cardElem.classList.add("deadSession");for(var i=0,length=sessions.length;i<length;i++){var session=sessions[i],rowId="session"+session.Id,elem=view.querySelector("#"+rowId);if(elem)DashboardPage.updateSession(elem,session);else{var nowPlayingItem=session.NowPlayingItem;html+='<div class="scalableCard card activeSession backdropCard backdropCard-scalable" id="'+rowId+'">',html+='<div class="cardBox visualCardBox">',html+='<div class="cardScalable visualCardBox-cardScalable">',html+='<div class="cardPadder cardPadder-backdrop"></div>',html+='<div class="cardContent">';var imgUrl=DashboardPage.getNowPlayingImageUrl(nowPlayingItem);imgUrl?(html+='<div class="sessionNowPlayingContent sessionNowPlayingContent-withbackground"',html+=' data-src="'+imgUrl+'" style="display:inline-block;background-image:url(\''+imgUrl+"');\"></div>"):html+='<div class="sessionNowPlayingContent"></div>',html+='<div class="sessionNowPlayingInnerContent">',html+='<div class="sessionAppInfo">';var clientImage=DashboardPage.getClientImage(session);clientImage&&(html+=clientImage),html+='<div class="sessionAppName" style="display:inline-block;">',html+='<div class="sessionDeviceName">'+session.DeviceName+"</div>",html+='<div class="sessionAppSecondaryText">'+DashboardPage.getAppSecondaryText(session)+"</div>",html+="</div>",html+="</div>",session.TranscodingInfo&&session.TranscodingInfo.Framerate?html+='<div class="sessionTranscodingFramerate">'+session.TranscodingInfo.Framerate+" fps</div>":html+='<div class="sessionTranscodingFramerate"></div>',html+='<div class="sessionNowPlayingDetails">';var nowPlayingName=DashboardPage.getNowPlayingName(session);if(html+='<div class="sessionNowPlayingInfo" data-imgsrc="'+nowPlayingName.image+'">',html+=nowPlayingName.html,html+="</div>",html+='<div class="sessionNowPlayingTime">'+DashboardPage.getSessionNowPlayingTime(session)+"</div>",html+="</div>",nowPlayingItem&&nowPlayingItem.RunTimeTicks){var percent=100*(session.PlayState.PositionTicks||0)/nowPlayingItem.RunTimeTicks;html+=indicators.getProgressHtml(percent,{containerClass:"playbackProgress"})}else html+=indicators.getProgressHtml(0,{containerClass:"playbackProgress hide"});if(session.TranscodingInfo&&session.TranscodingInfo.CompletionPercentage){percent=session.TranscodingInfo.CompletionPercentage.toFixed(1);html+=indicators.getProgressHtml(percent,{containerClass:"transcodingProgress"})}else html+=indicators.getProgressHtml(0,{containerClass:"transcodingProgress hide"});html+="</div>",html+="</div>",html+="</div>",html+='<div class="sessionCardFooter cardFooter">',html+='<div class="sessionCardButtons flex align-items-center justify-content-center">';var btnCssClass=session.ServerId&&session.NowPlayingItem&&session.SupportsRemoteControl?"":" hide",playIcon=session.PlayState.IsPaused?"pause":"play";html+='<button is="paper-icon-button-light" class="sessionCardButton btnSessionPlayPause paper-icon-button-light '+btnCssClass+'"><i class="material-icons">'+playIcon+"</i></button>",html+='<button is="paper-icon-button-light" class="sessionCardButton btnSessionStop paper-icon-button-light '+btnCssClass+'"><i class="material-icons">stop</i></button>',btnCssClass=session.TranscodingInfo&&session.TranscodingInfo.TranscodeReasons&&session.TranscodingInfo.TranscodeReasons.length?"":" hide",html+='<button is="paper-icon-button-light" class="sessionCardButton btnSessionInfo paper-icon-button-light '+btnCssClass+'" title="'+globalize.translate("ViewPlaybackInfo")+'"><i class="material-icons">info</i></button>',btnCssClass=session.ServerId&&-1!==session.SupportedCommands.indexOf("DisplayMessage")&&session.DeviceId!==connectionManager.deviceId()?"":" hide",html+='<button is="paper-icon-button-light" class="sessionCardButton btnSessionSendMessage paper-icon-button-light '+btnCssClass+'" title="'+globalize.translate("SendMessage")+'"><i class="material-icons">message</i></button>',html+="</div>",html+='<div class="sessionNowPlayingStreamInfo" style="padding:.5em 0 1em;">',html+=DashboardPage.getSessionNowPlayingStreamInfo(session),html+="</div>",html+='<div class="flex align-items-center justify-content-center">';var userImage=DashboardPage.getUserImage(session);html+=userImage?'<div class="activitylogUserPhoto" style="background-image:url(\''+userImage+"');\"></div>":'<div style="height:1.71em;"></div>',html+='<div class="sessionUserName">',html+=DashboardPage.getUsersHtml(session),html+="</div>",html+="</div>",html+="</div>",html+="</div>",html+="</div>"}}parentElement.insertAdjacentHTML("beforeend",html);var deadSessionElem=parentElement.querySelector(".deadSession");deadSessionElem&&deadSessionElem.parentNode.removeChild(deadSessionElem)})(view,sessions=function filterSessions(sessions){for(var list=[],minActiveDate=(new Date).getTime()-9e5,i=0,length=sessions.length;i<length;i++){var session=sessions[i];(session.NowPlayingItem||session.UserId)&&(datetime.parseISO8601Date(session.LastActivityDate,!0).getTime()>=minActiveDate&&list.push(session))}return list}(sessions)),loading.hide()}function pollForInfo(view,apiClient,forceUpdate){apiClient.getSessions({ActiveWithinSeconds:960}).then((function(sessions){renderInfo(view,sessions)})),apiClient.getScheduledTasks().then((function(tasks){renderRunningTasks(view,tasks)}))}function renderRunningTasks(view,tasks){var html="";(tasks=tasks.filter((function(task){return"Idle"!=task.State&&!task.IsHidden}))).length?view.querySelector(".runningTasksContainer").classList.remove("hide"):view.querySelector(".runningTasksContainer").classList.add("hide");for(var i=0,length=tasks.length;i<length;i++){var task=tasks[i];if(html+="<p>",html+=task.Name+"<br/>","Running"===task.State){var progress=(task.CurrentProgressPercentage||0).toFixed(1);html+='<progress max="100" value="'+progress+'" title="'+progress+'%">',html+=progress+"%",html+="</progress>",html+="<span style='color:#00a4dc;margin-left:5px;margin-right:5px;'>"+progress+"%</span>",html+='<button type="button" is="paper-icon-button-light" title="'+globalize.translate("ButtonStop")+'" onclick="DashboardPage.stopTask(this, \''+task.Id+'\');" class="autoSize"><i class="material-icons">cancel</i></button>'}else"Cancelling"===task.State&&(html+='<span style="color:#cc0000;">'+globalize.translate("LabelStopping")+"</span>");html+="</p>"}view.querySelector("#divRunningTasks").innerHTML=html}return window.DashboardPage={startInterval:function startInterval(apiClient){apiClient.sendMessage("SessionsStart","0,1500"),apiClient.sendMessage("ScheduledTasksInfoStart","0,1000")},stopInterval:function stopInterval(apiClient){apiClient.sendMessage("SessionsStop"),apiClient.sendMessage("ScheduledTasksInfoStop")},getSessionNowPlayingStreamInfo:function getSessionNowPlayingStreamInfo(session){var html="",showTranscodingInfo=!1,displayPlayMethod=playMethodHelper.getDisplayPlayMethod(session);if("DirectStream"===displayPlayMethod?html+=globalize.translate("DirectStreaming"):"Transcode"===displayPlayMethod?(html+=globalize.translate("Transcoding"),session.TranscodingInfo&&session.TranscodingInfo.Framerate&&(html+=" ("+session.TranscodingInfo.Framerate+" fps)"),showTranscodingInfo=!0):"DirectPlay"===displayPlayMethod&&(html+=globalize.translate("DirectPlaying")),showTranscodingInfo){var line=[];session.TranscodingInfo&&(session.TranscodingInfo.Bitrate&&(session.TranscodingInfo.Bitrate>1e6?line.push((session.TranscodingInfo.Bitrate/1e6).toFixed(1)+" Mbps"):line.push(Math.floor(session.TranscodingInfo.Bitrate/1e3)+" Kbps")),session.TranscodingInfo.Container&&line.push(session.TranscodingInfo.Container),session.TranscodingInfo.VideoCodec&&line.push(session.TranscodingInfo.VideoCodec),session.TranscodingInfo.AudioCodec&&session.TranscodingInfo.AudioCodec!=session.TranscodingInfo.Container&&line.push(session.TranscodingInfo.AudioCodec)),line.length&&(html+=" - "+line.join(" "))}return html},getSessionNowPlayingTime:function getSessionNowPlayingTime(session){var nowPlayingItem=session.NowPlayingItem,html="";return nowPlayingItem&&(session.PlayState.PositionTicks?html+=datetime.getDisplayRunningTime(session.PlayState.PositionTicks):html+="0:00",html+=" / ",nowPlayingItem&&nowPlayingItem.RunTimeTicks?html+=datetime.getDisplayRunningTime(nowPlayingItem.RunTimeTicks):html+="0:00"),html},getAppSecondaryText:function getAppSecondaryText(session){return session.Client+" "+session.ApplicationVersion},getNowPlayingName:function getNowPlayingName(session){var imgUrl="",nowPlayingItem=session.NowPlayingItem;if(!nowPlayingItem)return{html:"Last seen "+humaneDate(session.LastActivityDate),image:imgUrl};var topText=itemHelper.getDisplayName(nowPlayingItem),bottomText="";return nowPlayingItem.Artists&&nowPlayingItem.Artists.length?(bottomText=topText,topText=nowPlayingItem.Artists[0]):nowPlayingItem.SeriesName||nowPlayingItem.Album?(bottomText=topText,topText=nowPlayingItem.SeriesName||nowPlayingItem.Album):nowPlayingItem.ProductionYear&&(bottomText=nowPlayingItem.ProductionYear),nowPlayingItem.ImageTags&&nowPlayingItem.ImageTags.Logo?imgUrl=ApiClient.getScaledImageUrl(nowPlayingItem.Id,{tag:nowPlayingItem.ImageTags.Logo,maxHeight:24,maxWidth:130,type:"Logo"}):nowPlayingItem.ParentLogoImageTag&&(imgUrl=ApiClient.getScaledImageUrl(nowPlayingItem.ParentLogoItemId,{tag:nowPlayingItem.ParentLogoImageTag,maxHeight:24,maxWidth:130,type:"Logo"})),imgUrl&&(topText='<img src="'+imgUrl+'" style="max-height:24px;max-width:130px;" />'),{html:bottomText?topText+"<br/>"+bottomText:topText,image:imgUrl}},getUsersHtml:function getUsersHtml(session){var html=[];session.UserId&&html.push(session.UserName);for(var i=0,length=session.AdditionalUsers.length;i<length;i++)html.push(session.AdditionalUsers[i].UserName);return html.join(", ")},getUserImage:function getUserImage(session){return session.UserId&&session.UserPrimaryImageTag?ApiClient.getUserImageUrl(session.UserId,{tag:session.UserPrimaryImageTag,type:"Primary"}):null},updateSession:function updateSession(row,session){row.classList.remove("deadSession");var nowPlayingItem=session.NowPlayingItem;nowPlayingItem?row.classList.add("playingSession"):row.classList.remove("playingSession"),session.ServerId&&-1!==session.SupportedCommands.indexOf("DisplayMessage")&&session.DeviceId!==connectionManager.deviceId()?row.querySelector(".btnSessionSendMessage").classList.remove("hide"):row.querySelector(".btnSessionSendMessage").classList.add("hide"),session.TranscodingInfo&&session.TranscodingInfo.TranscodeReasons&&session.TranscodingInfo&&session.TranscodingInfo.TranscodeReasons.length?row.querySelector(".btnSessionInfo").classList.remove("hide"):row.querySelector(".btnSessionInfo").classList.add("hide");var btnSessionPlayPause=row.querySelector(".btnSessionPlayPause");session.ServerId&&nowPlayingItem&&session.SupportsRemoteControl&&session.DeviceId!==connectionManager.deviceId()?(btnSessionPlayPause.classList.remove("hide"),row.querySelector(".btnSessionStop").classList.remove("hide")):(btnSessionPlayPause.classList.add("hide"),row.querySelector(".btnSessionStop").classList.add("hide")),session.PlayState&&session.PlayState.IsPaused?btnSessionPlayPause.querySelector("i").innerHTML="&#xE037;":btnSessionPlayPause.querySelector("i").innerHTML="pause",row.querySelector(".sessionNowPlayingStreamInfo").innerHTML=DashboardPage.getSessionNowPlayingStreamInfo(session),row.querySelector(".sessionNowPlayingTime").innerHTML=DashboardPage.getSessionNowPlayingTime(session),row.querySelector(".sessionUserName").innerHTML=DashboardPage.getUsersHtml(session),row.querySelector(".sessionAppSecondaryText").innerHTML=DashboardPage.getAppSecondaryText(session),row.querySelector(".sessionTranscodingFramerate").innerHTML=session.TranscodingInfo&&session.TranscodingInfo.Framerate?session.TranscodingInfo.Framerate+" fps":"";var nowPlayingName=DashboardPage.getNowPlayingName(session),nowPlayingInfoElem=row.querySelector(".sessionNowPlayingInfo");nowPlayingName.image&&nowPlayingName.image==nowPlayingInfoElem.getAttribute("data-imgsrc")||(nowPlayingInfoElem.innerHTML=nowPlayingName.html,nowPlayingInfoElem.setAttribute("data-imgsrc",nowPlayingName.image||""));var playbackProgressElem=row.querySelector(".playbackProgress");if(nowPlayingItem&&nowPlayingItem.RunTimeTicks){var percent=100*(session.PlayState.PositionTicks||0)/nowPlayingItem.RunTimeTicks;playbackProgressElem.outerHTML=indicators.getProgressHtml(percent,{containerClass:"playbackProgress"})}else playbackProgressElem.outerHTML=indicators.getProgressHtml(0,{containerClass:"playbackProgress hide"});var transcodingProgress=row.querySelector(".transcodingProgress");if(session.TranscodingInfo&&session.TranscodingInfo.CompletionPercentage){percent=session.TranscodingInfo.CompletionPercentage.toFixed(1);transcodingProgress.outerHTML=indicators.getProgressHtml(percent,{containerClass:"transcodingProgress"})}else transcodingProgress.outerHTML=indicators.getProgressHtml(0,{containerClass:"transcodingProgress hide"});var imgUrl=DashboardPage.getNowPlayingImageUrl(nowPlayingItem)||"",imgElem=row.querySelector(".sessionNowPlayingContent");imgUrl!=imgElem.getAttribute("data-src")&&(imgElem.style.backgroundImage=imgUrl?"url('"+imgUrl+"')":"",imgElem.setAttribute("data-src",imgUrl),imgUrl?imgElem.classList.add("sessionNowPlayingContent-withbackground"):imgElem.classList.remove("sessionNowPlayingContent-withbackground"))},getClientImage:function getClientImage(connection){return"<img src='"+imageHelper.getDeviceIcon(connection)+"' />"},getNowPlayingImageUrl:function getNowPlayingImageUrl(item){if(item&&item.BackdropImageTags&&item.BackdropImageTags.length)return ApiClient.getScaledImageUrl(item.Id,{maxWidth:Math.round(.2*dom.getScreenWidth()),type:"Backdrop",tag:item.BackdropImageTags[0]});if(item&&item.ParentBackdropImageTags&&item.ParentBackdropImageTags.length)return ApiClient.getScaledImageUrl(item.ParentBackdropItemId,{maxWidth:Math.round(.2*dom.getScreenWidth()),type:"Backdrop",tag:item.ParentBackdropImageTags[0]});if(item&&item.BackdropImageTag)return ApiClient.getScaledImageUrl(item.BackdropItemId,{maxWidth:Math.round(.2*dom.getScreenWidth()),type:"Backdrop",tag:item.BackdropImageTag});var imageTags=(item||{}).ImageTags||{};return item&&imageTags.Thumb?ApiClient.getScaledImageUrl(item.Id,{maxWidth:Math.round(.2*dom.getScreenWidth()),type:"Thumb",tag:imageTags.Thumb}):item&&item.ParentThumbImageTag?ApiClient.getScaledImageUrl(item.ParentThumbItemId,{maxWidth:Math.round(.2*dom.getScreenWidth()),type:"Thumb",tag:item.ParentThumbImageTag}):item&&item.ThumbImageTag?ApiClient.getScaledImageUrl(item.ThumbItemId,{maxWidth:Math.round(.2*dom.getScreenWidth()),type:"Thumb",tag:item.ThumbImageTag}):item&&imageTags.Primary?ApiClient.getScaledImageUrl(item.Id,{maxWidth:Math.round(.2*dom.getScreenWidth()),type:"Primary",tag:imageTags.Primary}):item&&item.PrimaryImageTag?ApiClient.getScaledImageUrl(item.PrimaryImageItemId,{maxWidth:Math.round(.2*dom.getScreenWidth()),type:"Primary",tag:item.PrimaryImageTag}):item&&item.AlbumPrimaryImageTag?ApiClient.getScaledImageUrl(item.AlbumId,{maxWidth:Math.round(.2*dom.getScreenWidth()),type:"Primary",tag:item.AlbumPrimaryImageTag}):null},systemUpdateTaskKey:"SystemUpdateTask",stopTask:function stopTask(btn,id){var page=dom.parentWithClass(btn,"page");ApiClient.stopScheduledTask(id).then((function(){pollForInfo(page,ApiClient)}))},restart:function restart(btn){require(["confirm"],(function(confirm){confirm({title:globalize.translate("HeaderRestart"),text:globalize.translate("MessageConfirmRestart"),confirmText:globalize.translate("ButtonRestart"),primary:"delete"}).then((function(){var page=dom.parentWithClass(btn,"page");page.querySelector("#btnRestartServer").disabled=!0,page.querySelector("#btnShutdown").disabled=!0,ApiClient.restartServer()}))}))},shutdown:function shutdown(btn){require(["confirm"],(function(confirm){confirm({title:globalize.translate("HeaderShutdown"),text:globalize.translate("MessageConfirmShutdown"),confirmText:globalize.translate("ButtonShutdown"),primary:"delete"}).then((function(){var page=dom.parentWithClass(btn,"page");page.querySelector("#btnRestartServer").disabled=!0,page.querySelector("#btnShutdown").disabled=!0,ApiClient.shutdownServer()}))}))}},function(view,params){function onRestartRequired(evt,apiClient){console.debug("onRestartRequired not implemented",evt,apiClient)}function onServerShuttingDown(evt,apiClient){console.debug("onServerShuttingDown not implemented",evt,apiClient)}function onServerRestarting(evt,apiClient){console.debug("onServerRestarting not implemented",evt,apiClient)}function onPackageInstalling(evt,apiClient){apiClient.serverId()===serverId&&(pollForInfo(view,apiClient),reloadSystemInfo(view,apiClient))}function onPackageInstallationCompleted(evt,apiClient){apiClient.serverId()===serverId&&(pollForInfo(view,apiClient),reloadSystemInfo(view,apiClient))}function onSessionsUpdate(evt,apiClient,info){apiClient.serverId()===serverId&&renderInfo(view,info)}function onScheduledTasksUpdate(evt,apiClient,info){apiClient.serverId()===serverId&&renderRunningTasks(view,info)}var serverId=ApiClient.serverId();view.querySelector(".activeDevices").addEventListener("click",onActiveDevicesClick),view.addEventListener("viewshow",(function(){var apiClient=ApiClient;apiClient&&(loading.show(),pollForInfo(this,apiClient),DashboardPage.startInterval(apiClient),events.on(serverNotifications,"RestartRequired",onRestartRequired),events.on(serverNotifications,"ServerShuttingDown",onServerShuttingDown),events.on(serverNotifications,"ServerRestarting",onServerRestarting),events.on(serverNotifications,"PackageInstalling",onPackageInstalling),events.on(serverNotifications,"PackageInstallationCompleted",onPackageInstallationCompleted),events.on(serverNotifications,"Sessions",onSessionsUpdate),events.on(serverNotifications,"ScheduledTasksInfo",onScheduledTasksUpdate),DashboardPage.lastAppUpdateCheck=null,reloadSystemInfo(this,ApiClient),this.userActivityLog||(this.userActivityLog=new ActivityLog({serverId:ApiClient.serverId(),element:this.querySelector(".userActivityItems")})),ApiClient.isMinServerVersion("3.4.1.25")&&(this.serverActivityLog||(this.serverActivityLog=new ActivityLog({serverId:ApiClient.serverId(),element:this.querySelector(".serverActivityItems")}))),function refreshActiveRecordings(view,apiClient){apiClient.getLiveTvRecordings({UserId:Dashboard.getCurrentUserId(),IsInProgress:!0,Fields:"CanDelete,PrimaryImageAspectRatio",EnableTotalRecordCount:!1,EnableImageTypes:"Primary,Thumb,Backdrop"}).then((function(result){var itemsContainer=view.querySelector(".activeRecordingItems");if(!result.Items.length)return view.querySelector(".activeRecordingsSection").classList.add("hide"),void(itemsContainer.innerHTML="");view.querySelector(".activeRecordingsSection").classList.remove("hide"),itemsContainer.innerHTML=cardBuilder.getCardsHtml({items:result.Items,shape:"auto",defaultShape:"backdrop",showTitle:!0,showParentTitle:!0,coverImage:!0,cardLayout:!1,centerText:!0,preferThumb:"auto",overlayText:!1,overlayMoreButton:!0,action:"none",centerPlayButton:!0}),imageLoader.lazyChildren(itemsContainer)}))}(view,apiClient),loading.hide())})),view.addEventListener("viewbeforehide",(function(){var apiClient=ApiClient;events.off(serverNotifications,"RestartRequired",onRestartRequired),events.off(serverNotifications,"ServerShuttingDown",onServerShuttingDown),events.off(serverNotifications,"ServerRestarting",onServerRestarting),events.off(serverNotifications,"PackageInstalling",onPackageInstalling),events.off(serverNotifications,"PackageInstallationCompleted",onPackageInstallationCompleted),events.off(serverNotifications,"Sessions",onSessionsUpdate),events.off(serverNotifications,"ScheduledTasksInfo",onScheduledTasksUpdate),apiClient&&DashboardPage.stopInterval(apiClient)})),view.addEventListener("viewdestroy",(function(){var userActivityLog=this.userActivityLog;userActivityLog&&userActivityLog.destroy();var serverActivityLog=this.serverActivityLog;serverActivityLog&&serverActivityLog.destroy()}))}}));
//# sourceMappingURL=dashboard.js.map
