"use strict";define(["playbackManager","events","serverNotifications","connectionManager"],(function(playbackManager,events,serverNotifications,connectionManager){function getActivePlayerId(){var info=playbackManager.getPlayerInfo();return info?info.id:null}function sendPlayCommand(apiClient,options,playType){var sessionId=getActivePlayerId(),remoteOptions={ItemIds:(options.ids||options.items.map((function(i){return i.Id}))).join(","),PlayCommand:playType};return options.startPositionTicks&&(remoteOptions.StartPositionTicks=options.startPositionTicks),options.mediaSourceId&&(remoteOptions.MediaSourceId=options.mediaSourceId),null!=options.audioStreamIndex&&(remoteOptions.AudioStreamIndex=options.audioStreamIndex),null!=options.subtitleStreamIndex&&(remoteOptions.SubtitleStreamIndex=options.subtitleStreamIndex),null!=options.startIndex&&(remoteOptions.StartIndex=options.startIndex),apiClient.sendPlayCommand(sessionId,remoteOptions)}function sendPlayStateCommand(apiClient,command,options){var sessionId=getActivePlayerId();apiClient.sendPlayStateCommand(sessionId,command,options)}function getCurrentApiClient(instance){var currentServerId=instance.currentServerId;return currentServerId?connectionManager.getApiClient(currentServerId):connectionManager.currentApiClient()}function sendCommandByName(instance,name,options){var command={Name:name};options&&(command.Arguments=options),instance.sendCommand(command)}function processUpdatedSessions(instance,sessions,apiClient){var serverId=apiClient.serverId();sessions.map((function(s){s.NowPlayingItem&&(s.NowPlayingItem.ServerId=serverId)}));var currentTargetId=getActivePlayerId(),session=sessions.filter((function(s){return s.Id===currentTargetId}))[0];if(session){!function normalizeImages(state,apiClient){if(state&&state.NowPlayingItem){var item=state.NowPlayingItem;item.ImageTags&&item.ImageTags.Primary||item.PrimaryImageTag&&(item.ImageTags=item.ImageTags||{},item.ImageTags.Primary=item.PrimaryImageTag),item.BackdropImageTag&&item.BackdropItemId===item.Id&&(item.BackdropImageTags=[item.BackdropImageTag]),item.BackdropImageTag&&item.BackdropItemId!==item.Id&&(item.ParentBackdropImageTags=[item.BackdropImageTag],item.ParentBackdropItemId=item.BackdropItemId),item.ServerId||(item.ServerId=apiClient.serverId())}}(session,apiClient);var eventNames=function getChangedEvents(state1,state2){var names=[];if(!state1)return names.push("statechange"),names.push("timeupdate"),names.push("pause"),names;return names.push("statechange"),names.push("timeupdate"),names.push("pause"),names}(instance.lastPlayerData);instance.lastPlayerData=session;for(var i=0,length=eventNames.length;i<length;i++)events.trigger(instance,eventNames[i],[session])}else instance.lastPlayerData=session,playbackManager.setDefaultPlayerActive()}function onPollIntervalFired(){var instance=this,apiClient=getCurrentApiClient(instance);apiClient.isMessageChannelOpen()||apiClient.getSessions().then((function(sessions){processUpdatedSessions(instance,sessions,apiClient)}))}function subscribeToPlayerUpdates(instance){instance.isUpdating=!0,getCurrentApiClient(instance).sendMessage("SessionsStart","100,800"),instance.pollInterval&&(clearInterval(instance.pollInterval),instance.pollInterval=null),instance.pollInterval=setInterval(onPollIntervalFired.bind(instance),5e3)}function SessionPlayer(){var self=this;this.name="Remote Control",this.type="mediaplayer",this.isLocalPlayer=!1,this.id="remoteplayer",events.on(serverNotifications,"Sessions",(function(e,apiClient,data){processUpdatedSessions(self,data,apiClient)}))}return SessionPlayer.prototype.beginPlayerUpdates=function(){this.playerListenerCount=this.playerListenerCount||0,this.playerListenerCount<=0&&(this.playerListenerCount=0,subscribeToPlayerUpdates(this)),this.playerListenerCount++},SessionPlayer.prototype.endPlayerUpdates=function(){this.playerListenerCount=this.playerListenerCount||0,this.playerListenerCount--,this.playerListenerCount<=0&&(!function unsubscribeFromPlayerUpdates(instance){instance.isUpdating=!0,getCurrentApiClient(instance).sendMessage("SessionsStop"),instance.pollInterval&&(clearInterval(instance.pollInterval),instance.pollInterval=null)}(this),this.playerListenerCount=0)},SessionPlayer.prototype.getPlayerState=function(){return this.lastPlayerData||{}},SessionPlayer.prototype.getTargets=function(){var apiClient=getCurrentApiClient(this),sessionQuery={ControllableByUserId:apiClient.getCurrentUserId()};if(apiClient){var name=this.name;return apiClient.getSessions(sessionQuery).then((function(sessions){return sessions.filter((function(s){return s.DeviceId!==apiClient.deviceId()})).map((function(s){return{name:s.DeviceName,deviceName:s.DeviceName,deviceType:s.DeviceType,id:s.Id,playerName:name,appName:s.Client,playableMediaTypes:s.PlayableMediaTypes,isLocalPlayer:!1,supportedCommands:s.SupportedCommands,user:s.UserId?{Id:s.UserId,Name:s.UserName,PrimaryImageTag:s.UserPrimaryImageTag}:null}}))}))}return Promise.resolve([])},SessionPlayer.prototype.sendCommand=function(command){var sessionId=getActivePlayerId();getCurrentApiClient(this).sendCommand(sessionId,command)},SessionPlayer.prototype.play=function(options){return(options=Object.assign({},options)).items&&(options.ids=options.items.map((function(i){return i.Id})),options.items=null),sendPlayCommand(getCurrentApiClient(this),options,"PlayNow")},SessionPlayer.prototype.shuffle=function(item){sendPlayCommand(getCurrentApiClient(this),{ids:[item.Id]},"PlayShuffle")},SessionPlayer.prototype.instantMix=function(item){sendPlayCommand(getCurrentApiClient(this),{ids:[item.Id]},"PlayInstantMix")},SessionPlayer.prototype.queue=function(options){sendPlayCommand(getCurrentApiClient(this),options,"PlayNext")},SessionPlayer.prototype.queueNext=function(options){sendPlayCommand(getCurrentApiClient(this),options,"PlayLast")},SessionPlayer.prototype.canPlayMediaType=function(mediaType){return"audio"===(mediaType=(mediaType||"").toLowerCase())||"video"===mediaType},SessionPlayer.prototype.canQueueMediaType=function(mediaType){return this.canPlayMediaType(mediaType)},SessionPlayer.prototype.stop=function(){sendPlayStateCommand(getCurrentApiClient(this),"stop")},SessionPlayer.prototype.nextTrack=function(){sendPlayStateCommand(getCurrentApiClient(this),"nextTrack")},SessionPlayer.prototype.previousTrack=function(){sendPlayStateCommand(getCurrentApiClient(this),"previousTrack")},SessionPlayer.prototype.seek=function(positionTicks){sendPlayStateCommand(getCurrentApiClient(this),"seek",{SeekPositionTicks:positionTicks})},SessionPlayer.prototype.currentTime=function(val){if(null!=val)return this.seek(val);var state=this.lastPlayerData||{};return(state=state.PlayState||{}).PositionTicks},SessionPlayer.prototype.duration=function(){var state=this.lastPlayerData||{};return(state=state.NowPlayingItem||{}).RunTimeTicks},SessionPlayer.prototype.paused=function(){var state=this.lastPlayerData||{};return(state=state.PlayState||{}).IsPaused},SessionPlayer.prototype.getVolume=function(){var state=this.lastPlayerData||{};return(state=state.PlayState||{}).VolumeLevel},SessionPlayer.prototype.isMuted=function(){var state=this.lastPlayerData||{};return(state=state.PlayState||{}).IsMuted},SessionPlayer.prototype.pause=function(){sendPlayStateCommand(getCurrentApiClient(this),"Pause")},SessionPlayer.prototype.unpause=function(){sendPlayStateCommand(getCurrentApiClient(this),"Unpause")},SessionPlayer.prototype.playPause=function(){sendPlayStateCommand(getCurrentApiClient(this),"PlayPause")},SessionPlayer.prototype.setMute=function(isMuted){sendCommandByName(this,isMuted?"Mute":"Unmute")},SessionPlayer.prototype.toggleMute=function(){sendCommandByName(this,"ToggleMute")},SessionPlayer.prototype.setVolume=function(vol){sendCommandByName(this,"SetVolume",{Volume:vol})},SessionPlayer.prototype.volumeUp=function(){sendCommandByName(this,"VolumeUp")},SessionPlayer.prototype.volumeDown=function(){sendCommandByName(this,"VolumeDown")},SessionPlayer.prototype.toggleFullscreen=function(){sendCommandByName(this,"ToggleFullscreen")},SessionPlayer.prototype.audioTracks=function(){var state=this.lastPlayerData||{};return((state=state.NowPlayingItem||{}).MediaStreams||[]).filter((function(s){return"Audio"===s.Type}))},SessionPlayer.prototype.getAudioStreamIndex=function(){var state=this.lastPlayerData||{};return(state=state.PlayState||{}).AudioStreamIndex},SessionPlayer.prototype.playTrailers=function(item){sendCommandByName(this,"PlayTrailers",{ItemId:item.Id})},SessionPlayer.prototype.setAudioStreamIndex=function(index){sendCommandByName(this,"SetAudioStreamIndex",{Index:index})},SessionPlayer.prototype.subtitleTracks=function(){var state=this.lastPlayerData||{};return((state=state.NowPlayingItem||{}).MediaStreams||[]).filter((function(s){return"Subtitle"===s.Type}))},SessionPlayer.prototype.getSubtitleStreamIndex=function(){var state=this.lastPlayerData||{};return(state=state.PlayState||{}).SubtitleStreamIndex},SessionPlayer.prototype.setSubtitleStreamIndex=function(index){sendCommandByName(this,"SetSubtitleStreamIndex",{Index:index})},SessionPlayer.prototype.getMaxStreamingBitrate=function(){},SessionPlayer.prototype.setMaxStreamingBitrate=function(options){},SessionPlayer.prototype.isFullscreen=function(){},SessionPlayer.prototype.toggleFullscreen=function(){},SessionPlayer.prototype.getRepeatMode=function(){},SessionPlayer.prototype.setRepeatMode=function(mode){sendCommandByName(this,"SetRepeatMode",{RepeatMode:mode})},SessionPlayer.prototype.displayContent=function(options){sendCommandByName(this,"DisplayContent",options)},SessionPlayer.prototype.isPlaying=function(){return null!=(this.lastPlayerData||{}).NowPlayingItem},SessionPlayer.prototype.isPlayingVideo=function(){var state=this.lastPlayerData||{};return"Video"===(state=state.NowPlayingItem||{}).MediaType},SessionPlayer.prototype.isPlayingAudio=function(){var state=this.lastPlayerData||{};return"Audio"===(state=state.NowPlayingItem||{}).MediaType},SessionPlayer.prototype.getPlaylist=function(){return Promise.resolve([])},SessionPlayer.prototype.getCurrentPlaylistItemId=function(){},SessionPlayer.prototype.setCurrentPlaylistItem=function(playlistItemId){return Promise.resolve()},SessionPlayer.prototype.removeFromPlaylist=function(playlistItemIds){return Promise.resolve()},SessionPlayer.prototype.tryPair=function(target){return Promise.resolve()},SessionPlayer}));
//# sourceMappingURL=sessionplayer.js.map
