import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manage a Fastly service domain.
 *
 * @schema CfnDomainProps
 */
export interface CfnDomainProps {
    /**
     * @schema CfnDomainProps#Name
     */
    readonly name: string;
    /**
     * @schema CfnDomainProps#Comment
     */
    readonly comment?: string;
    /**
     * @schema CfnDomainProps#ServiceId
     */
    readonly serviceId: string;
    /**
     * @schema CfnDomainProps#VersionId
     */
    readonly versionId: string;
    /**
     * @schema CfnDomainProps#Version
     */
    readonly version?: string;
    /**
     * @schema CfnDomainProps#DomainName
     */
    readonly domainName?: string;
    /**
     * @schema CfnDomainProps#CreatedAt
     */
    readonly createdAt?: Date;
    /**
     * @schema CfnDomainProps#UpdatedAt
     */
    readonly updatedAt?: Date;
    /**
     * @schema CfnDomainProps#DeletedAt
     */
    readonly deletedAt?: Date;
}
/**
 * Converts an object of type 'CfnDomainProps' to JSON representation.
 */
export declare function toJson_CfnDomainProps(obj: CfnDomainProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Fastly::Services::Domain`
 *
 * @cloudformationResource Fastly::Services::Domain
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-fastly-resource-providers.git
 */
export declare class CfnDomain extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Fastly::Services::Domain";
    /**
     * Resource props.
     */
    readonly props: CfnDomainProps;
    /**
     * Create a new `Fastly::Services::Domain`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnDomainProps);
}
