# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['tusker']

package_data = \
{'': ['*']}

install_requires = \
['migra>=1.0.1596263757,<2.0.0',
 'psycopg2-binary>=2.8.5,<3.0.0',
 'sqlalchemy>=1.3.16,<2.0.0',
 'tomlkit>=0.6.0,<0.7.0']

extras_require = \
{':python_version < "3.8"': ['importlib-metadata>=1.0,<2.0']}

entry_points = \
{'console_scripts': ['tusker = tusker:main']}

setup_kwargs = {
    'name': 'tusker',
    'version': '0.3.4',
    'description': 'A PostgreSQL specific migration tool',
    'long_description': '# Tusker\n\n[![GitHub](https://img.shields.io/github/license/bikeshedder/tusker?label=License&logoColor=white&style=for-the-badge)](https://github.com/bikeshedder/tusker/blob/master/LICENSE)\n&nbsp;\n[![PyPI](https://img.shields.io/pypi/v/tusker?label=PyPI&logo=pypi&logoColor=white&style=for-the-badge)](https://pypi.org/project/tusker)\n\nA PostgreSQL specific migration tool\n\n## Elevator pitch\n\nDo you want to write your database schema directly as SQL\nwhich is understood by PostgreSQL?\n\nDo you want to be able to make changes to this schema and\ngenerate the SQL which is required to migrate between the\nold and new schema version?\n\nTusker does exactly this.\n\n## Installation\n\n```shell\npip3 install tusker\n```\n\nNow you should be able to run tusker. Give it a try:\n\n```shell\ntusker --help\n```\n\n## Getting started\n\nOnce tusker is installed create a new file called `schema.sql`:\n\n```sql\nCREATE TABLE fruit (\n    id BIGINT GENERATED BY DEFAULT AS IDENTITY,\n    name TEXT NOT NULL UNIQUE\n);\n```\n\nTusker also needs an empty `migrations` directory:\n\n```shell\nmkdir migrations\n```\n\nNow you should be able to create your first migration:\n\n```\ntusker diff\n```\n\nThe migration is printed to the console and all you need to do is\ncopy and paste the output into a new file in the migrations directory.\nAlternatively you can also pipe the output of `tusker diff` into the\ntarget file:\n\n```\ntusker diff > migrations/0001_initial.sql\n```\n\nAfter that check that your `schema.sql` and your `migrations` are in sync:\n\n```\ntusker diff\n```\n\nThis should give you an empty output. This means that there is no difference\nbetween applying the migrations in order and the target schema.\n\nAlternatively you can run the check command:\n\n```\ntusker check\n```\n\nIf you want to change the schema in the future simply change the `schema.sql`\nand run `tusker diff` to create the migration for you.\n\nGive it a try and change the `schema.sql`:\n\n```sql\nCREATE TABLE fruit (\n    id BIGINT GENERATED BY DEFAULT AS IDENTITY,\n    name TEXT NOT NULL UNIQUE,\n    color TEXT NOT NULL DEFAULT \'\'\n);\n```\n\nCreate a new migration:\n\n```\ntusker diff > migrations/0002_fruit_color.sql\n```\n\n**Congratulations! You are now using SQL to write your migrations. You are no longer limited by a 3rd party data definition language or an object relational wrapper.**\n\n## Configuration\n\nIn order to run tusker you do not need a configuration file. The following\ndefaults are assumed:\n\n- The file containing your database schema is called `schema.sql`\n- The directory containing the migrations is called `migrations`\n- Your current user can connect to the database using a unix\n  domain socket without a password.\n\nYou can also create a configuration file called `tusker.toml`. The default\nconfiguration looks like that:\n\n```toml\n[schema]\nfilename = "schema.sql"\n\n[migrations]\ndirectory = "migrations"\n\n[database]\n#host = ""\n#port = 5432\n#user = ""\n#password = ""\ndbname = "tusker"\n```\n\nInstead of the exploded form of `host`, `port`, etc. it\nis also possible to pass a connection URL:\n\n```toml\n[schema]\nfilename = "schema.sql"\n\n[migrations]\ndirectory = "migrations"\n\n[database]\nurl = "postgresql:///my_awesome_db"\n```\n\n## How can I use the generated SQL files?\n\nThe resulting SQL files can either be applied to the database by hand\nor by using one of the many great tools and libraries which support\napplying SQL files in order.\n\nSome recommendations are:\n\n- NodeJS: [marv](https://www.npmjs.com/package/marv)\n- Rust: [refinery](https://crates.io/crates/refinery)\n\n## How does it work?\n\nUpon startup `tusker` reads all files from the `migration` directory\nand runs them on an empty database. Another empty database is created\nand the target schema is created. Then those two schemas are\ndiffed using the excellent [migra](https://pypi.org/project/migra/)\ntool and the output printed to the console.\n\n## FAQ\n\n### Is it possible to split the schema into multiple files?\n\nYes. This feature has been added in 0.3. You can now use `glob` patterns as\npart of the `schema.filename` setting. e.g.:\n\n```toml\n[schema]\nfilename = "schema/*.sql"\n```\n\n### Is it possible to diff the schema and/or migrations against an existing database?\n\nYes. This feature has been added in 0.2. You can pass a `from` and `to`\nargument to the `tusker diff` command. Check the output of `tusker diff --help` for\nmore details.\n\n### Tusker printed an error and left the temporary databases behind. How can I remove them?\n\nRun `tusker clean`. This will remove all databases which were created\nby previous runs of tusker. Tusker only removes databases which are\nmarked with a `CREATED BY TUSKER` comment.\n\n### What does the `dbname` setting in `tusker.toml` mean?\n\nWhen diffing against a ready migrated database this database name is used. This\ncommand will print out the difference between the current database schema and\nthe target schema:\n\n```shell\ntusker diff database\n```\n\nTusker also needs to create temporary databases when diffing against the `schema`\nand/or `migrations`. The two databases are called `{dbname}_{timestamp}_schema`\nand `{dbname}_{timestamp}_migrations`.\n',
    'author': 'Michael P. Jung',
    'author_email': 'michael.jung@terreon.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/bikeshedder/tusker',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.5,<4.0',
}


setup(**setup_kwargs)
