# Graphdoc - Generate docs for your GraphQL API

Graphdoc uses you GraphQL schema to generate an HTML page documenting your API.
It works with Graphene and Ariadne and any other framework generating `GraphQLSchema`
instances from the `graphql-core` package.

You can see an example of autogenerated docs using the [SWAPI](https://swapi.dev/)
schema [in this page](https://wallee94.github.io/graphdoc/)

## Installation

Install using pip:

    pip install graphdoc

## Usage

You can use `graphdoc.to_doc` to convert a `GraphQLSchema` or a string to an HTML
with the docs (or the awaitable `graphdoc.to_doc_async` if using asyncio).

### Django and Graphene

```python
# view.py
from django.http import HttpResponse
from graphene_django.views import GraphQLView
import graphdoc

def graphql_docs(request):
    html = graphdoc.to_doc(GraphQLView.schema)
    return HttpResponse(html, content_type='text/html')
    

# urls.py
from graphene_django.views import GraphQLView
from .views import graphql_docs

urlpatterns = [
    path('graphql', GraphQLView.as_view(), name='graphql_endpoint'),
    path('docs', graphql_docs, name='graphql_docs'),
]
```

### FastAPI and Ariadne

```python
# schema.py
from ariadne import load_schema_from_path

schema = load_schema_from_path("schema.graphql")


# main.py
from fastapi import FastAPI, Response
from schema import schema
import graphdoc

app = FastAPI()


@app.get("/docs")
async def graphql_docs():
    html = await graphdoc.to_doc_async(schema)
    return Response(content=html, media_type="text/html")
```
