class WrongMapType(Exception):
    pass

class WrongResName(Exception):
    pass
class WrongAtomName(Exception):
    pass
class WrongAtomRadius(Exception):
    pass

def validate_map(maybe_map):
    if not type(maybe_map) is dict:
        raise WrongMapType(f"Provided Atom map is not a dict => { type(maybe_map) }")
    for resn, data in maybe_map.items():
        if not type(resn) is str:
            raise WrongResName(f"Provided residue is not a string => { type(resn) }")      
        for (name, radius) in data:
            if not type(name) is str:
                raise WrongAtomName(f"Provided atom name is not a string => { type(name) }")  
            if not type(radius) is float:
                raise WrongAtomRadius(f"Provided atom radius is not a float => { type(radius) }")  

    return maybe_map
    
atom_default_radii = {
    "ALA": [
        ("N", 1.64), ("CA", 1.88), ("C", 1.61), ("O", 1.42), ("CB", 1.88)],
    "ARG": [
        ("N", 1.64),
        ("CA", 1.88),
        ("C", 1.61),
        ("O", 1.42),
        ("CB", 1.88),
        ("CG", 1.88),
        ("CD", 1.88),
        ("NE", 1.61),
        ("CZ", 1.61),
        ("NH1", 1.64),
        ("NH2", 1.64)],
    "ASN": [
        ("N", 1.64),
        ("CA", 1.88),
        ("C", 1.61),
        ("O", 1.42),
        ("CB", 1.88),
        ("CG", 1.61),
        ("OD1", 1.42),
        ("ND2", 1.64)],
    "ASP": [
        ("N", 1.64),
        ("CA", 1.88),
        ("C", 1.61),
        ("O", 1.42),
        ("CB", 1.88),
        ("CG", 1.61),
        ("OD1", 1.46),
        ("OD2", 1.42)],
    "CYM|CYX|CYS": [
        ("N", 1.64),
        ("CA", 1.88),
        ("C", 1.61),
        ("O", 1.42),
        ("CB", 1.88),
        ("SG", 1.77)],
    "GLN": [
        ("N", 1.64),
        ("CA", 1.88),
        ("C", 1.61),
        ("O", 1.42),
        ("CB", 1.88),
        ("CG", 1.88),
        ("CD", 1.61),
        ("OE1", 1.42),
        ("NE2", 1.64)],
    "GLU": [
        ("N", 1.64),
        ("CA", 1.88),
        ("C", 1.61),
        ("O", 1.42),
        ("CB", 1.88),
        ("CG", 1.88),
        ("CD", 1.61),
        ("OE1", 1.46),
        ("OE2", 1.42)],
    "GLY": [
        ("N", 1.64), ("CA", 1.88), ("C", 1.61), ("O", 1.42)],
    "HIE|HIP|HIS": [
        ("N", 1.64),
        ("CA", 1.88),
        ("C", 1.61),
        ("O", 1.42),
        ("CB", 1.88),
        ("CG", 1.61),
        ("ND1", 1.64),
        ("CD2", 1.76),
        ("CE1", 1.76),
        ("NE2", 1.64)],
    "ILE": [
        ("N", 1.64),
        ("CA", 1.88),
        ("C", 1.61),
        ("O", 1.42),
        ("CB", 1.88),
        ("CG1", 1.88),
        ("CG2", 1.88),
        ("CD1", 1.88),
        ("CD", 1.88)],
    "LEU": [
        ("N", 1.64),
        ("CA", 1.88),
        ("C", 1.61),
        ("O", 1.42),
        ("CB", 1.88),
        ("CG", 1.88),
        ("CD1", 1.88),
        ("CD2", 1.88)],
    "LYS": [
        ("N", 1.64),
        ("CA", 1.88),
        ("C", 1.61),
        ("O", 1.42),
        ("CB", 1.88),
        ("CG", 1.88),
        ("CD", 1.88),
        ("CE", 1.88),
        ("NZ", 1.64)],
    "MET": [
        ("N", 1.64),
        ("CA", 1.88),
        ("C", 1.61),
        ("O", 1.42),
        ("CB", 1.88),
        ("CG", 1.88),
        ("SD", 1.77),
        ("CE", 1.88)],
    "PHE": [
        ("N", 1.64),
        ("CA", 1.88),
        ("C", 1.61),
        ("O", 1.42),
        ("CB", 1.88),
        ("CG", 1.88),
        ("CD1", 1.61),
        ("CD2", 1.76),
        ("CE1", 1.76),
        ("CE2", 1.76),
        ("CZ", 1.76)],
    "PRO": [
        ("N", 1.64),
        ("CA", 1.88),
        ("C", 1.61),
        ("O", 1.42),
        ("CB", 1.88),
        ("CG", 1.88),
        ("CD", 1.88)],
    "SER": [
        ("N", 1.64),
        ("CA", 1.88),
        ("C", 1.61),
        ("O", 1.42),
        ("CB", 1.88),
        ("OG", 1.46)],
    "THR": [
        ("N", 1.64),
        ("CA", 1.88),
        ("C", 1.61),
        ("O", 1.42),
        ("CB", 1.88),
        ("OG1", 1.46),
        ("CG2", 1.88)],
    "TRP": [
        ("N", 1.64),
        ("CA", 1.88),
        ("C", 1.61),
        ("O", 1.42),
        ("CB", 1.88),
        ("CG", 1.61),
        ("CD1", 1.76),
        ("CD2", 1.61),
        ("NE1", 1.64),
        ("CE2", 1.61),
        ("CE3", 1.76),
        ("CZ2", 1.76),
        ("CZ3", 1.76),
        ("CH2", 1.76)],
    "TYR": [
        ("N", 1.64),
        ("CA", 1.88),
        ("C", 1.61),
        ("O", 1.42),
        ("CB", 1.88),
        ("CG", 1.61),
        ("CD1", 1.76),
        ("CD2", 1.76),
        ("CE1", 1.76),
        ("CE2", 1.76),
        ("CZ", 1.61),
        ("OH", 1.46)],
    "VAL": [
        ("N", 1.64),
        ("CA", 1.88),
        ("C", 1.61),
        ("O", 1.42),
        ("CB", 1.88),
        ("CG1", 1.88),
        ("CG2", 1.88)]
}

martini3_dbg_radii = {
'ALA': [('BB', 2.3), ('SC1', 1.91)],
 'ARG': [('BB', 2.64), ('SC1', 2.3), ('SC2', 2.3)],
 'ASN': [('BB', 2.64), ('SC1', 2.3)],
 'ASP': [('BB', 2.64), ('SC1', 2.3)],
 'CHOL': [('ROH', 2.3),
  ('R1', 2.3),
  ('R2', 2.3),
  ('R3', 2.3),
  ('R4', 2.3),
  ('R5', 2.3),
  ('C1', 2.3),
  ('C2', 2.64)],
 'CYS': [('BB', 2.64), ('SC1', 1.91)],
 'GLN': [('BB', 2.64), ('SC1', 2.64)],
 'GLU': [('BB', 2.64), ('SC1', 2.64)],
 'GLY': [('BB', 2.64)],
 'HIS': [('BB', 2.64), ('SC1', 1.91), ('SC2', 1.91), ('SC3', 1.91)],
 'ILE': [('BB', 2.64), ('SC1', 2.3)],
 'ION': [('NA', 1.91), ('CL', 1.91)],
 'LEU': [('BB', 2.64), ('SC1', 2.3)],
 'LYS': [('BB', 2.64), ('SC1', 2.3), ('SC2', 2.3)],
 'MET': [('BB', 2.64), ('SC1', 2.64)],
 'PHE': [('BB', 2.64), ('SC1', 2.3), ('SC2', 1.91), ('SC3', 1.91)],
 'POPC': [('NC3', 2.64),
  ('PO4', 2.64),
  ('GL1', 2.3),
  ('GL2', 2.64),
  ('C1A', 2.64),
  ('D2A', 2.64),
  ('C3A', 2.64),
  ('C4A', 2.64),
  ('C1B', 2.64),
  ('C2B', 2.64),
  ('C3B', 2.64),
  ('C4B', 2.64)],
 'POPE': [('NH3', 2.64),
  ('PO4', 2.64),
  ('GL1', 2.3),
  ('GL2', 2.64),
  ('C1A', 2.64),
  ('D2A', 2.64),
  ('C3A', 2.64),
  ('C4A', 2.64),
  ('C1B', 2.64),
  ('C2B', 2.64),
  ('C3B', 2.64),
  ('C4B', 2.64)],
 'POPS': [('CNO', 2.64),
  ('PO4', 2.64),
  ('GL1', 2.3),
  ('GL2', 2.64),
  ('C1A', 2.64),
  ('D2A', 2.64),
  ('C3A', 2.64),
  ('C4A', 2.64),
  ('C1B', 2.64),
  ('C2B', 2.64),
  ('C3B', 2.64),
  ('C4B', 2.64)],
 'PRO': [('BB', 2.3), ('SC1', 2.3)],
 'SAP2': [('C1', 2.3),
  ('C2', 2.3),
  ('C3', 2.3),
  ('C4', 1.91),
  ('PO4', 2.64),
  ('P3', 2.64),
  ('P4', 2.64),
  ('GL1', 2.3),
  ('GL2', 2.64),
  ('D1A', 2.64),
  ('D2A', 2.64),
  ('D3A', 2.64),
  ('D4A', 2.64),
  ('C5A', 2.64),
  ('C1B', 2.64),
  ('C2B', 2.64),
  ('C3B', 2.64),
  ('C4B', 2.64)],
 'SER': [('BB', 2.64), ('SC1', 1.91)],
 'THR': [('BB', 2.64), ('SC1', 2.3)],
 'TRP': [('BB', 2.64),
  ('SC1', 1.91),
  ('SC2', 1.91),
  ('SC3', 1.91),
  ('SC4', 1.91),
  ('SC5', 1.91)],
 'TYR': [('BB', 2.64),
  ('SC1', 1.91),
  ('SC2', 1.91),
  ('SC3', 1.91),
  ('SC4', 1.91)],
 'VAL': [('BB', 2.3), ('SC1', 2.3)],
 'W': [('W', 2.64)],
 '*':[('OT1', ), ('OT2', )]}