# Tests

This directory contains the tests for the relay server. We use pytest for
testing. Since the relay server uses gevent with monkeypatching, we provide a
custom pytest script, which monkeypatches before running the tests. This script
is located in the top folder, but is also available in this directory as a
symlink.

## Running the tests

You can run ***all tests*** by running:

    ./pytest

You can run **just the unit tests** by running

    ./pytest -m unit

You can run **just the integration tests** by running

     ./pytest -m integration

## Using tox

You can also use `tox` to run all tests. This will check the source code using mypy and flake8. Please just run:

    tox

or if the relay server's dependencies have changed, run:

    tox -r

The latter will rebuild the virtual environments used by tox.

## The testdata directory

This directory contains test data that has been generated by the
`gen_testdata.py` script in this directory.

You can run all tests that use test cases generated from the testdata by
running:

    ./pytest -m testdata

## Regenerating the testdata

Start a development chain with parity and run the following in this directory:

    ./gen_testdata.py

The data will be written to the testdata directory.
