"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.redirectHandlers = exports.JS_HANDLER = exports.JS_HANDLER_WITH_LAYERS = exports.PYTHON_HANDLER = exports.DD_HANDLER_ENV_VAR = void 0;
const loglevel_1 = require("loglevel");
const index_1 = require("./index");
exports.DD_HANDLER_ENV_VAR = "DD_LAMBDA_HANDLER";
exports.PYTHON_HANDLER = "datadog_lambda.handler.handler";
exports.JS_HANDLER_WITH_LAYERS = "/opt/nodejs/node_modules/datadog-lambda-js/handler.handler";
exports.JS_HANDLER = "node_modules/datadog-lambda-js/dist/handler.handler";
/**
 * To avoid modifying code in the user's lambda handler, redirect the handler to a Datadog
 * handler that initializes the Lambda Layers and then calls the original handler.
 * 'DD_LAMBDA_HANDLER' is set to the original handler in the lambda's environment for the
 * replacement handler to find.
 */
function redirectHandlers(lambdas, addLayers) {
    loglevel_1.default.debug(`Wrapping Lambda function handlers with Datadog handler...`);
    lambdas.forEach((lam) => {
        const cfnFunction = lam.node.defaultChild;
        const originalHandler = cfnFunction.handler;
        lam.addEnvironment(exports.DD_HANDLER_ENV_VAR, originalHandler);
        const handler = getDDHandler(lam, addLayers);
        if (handler === undefined) {
            loglevel_1.default.debug("Unable to get Datadog handler");
            return;
        }
        cfnFunction.handler = handler;
    });
}
exports.redirectHandlers = redirectHandlers;
function getDDHandler(lam, addLayers) {
    const runtime = lam.runtime.name;
    const lambdaRuntime = index_1.runtimeLookup[runtime];
    if (lambdaRuntime === undefined || lambdaRuntime === index_1.RuntimeType.UNSUPPORTED) {
        loglevel_1.default.debug("Unsupported/undefined Lambda runtime");
        return;
    }
    switch (lambdaRuntime) {
        case index_1.RuntimeType.NODE:
            return addLayers ? exports.JS_HANDLER_WITH_LAYERS : exports.JS_HANDLER;
        case index_1.RuntimeType.PYTHON:
            return exports.PYTHON_HANDLER;
    }
}
//# sourceMappingURL=data:application/json;base64,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