"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.applyEnvVariables = exports.defaultEnvVar = exports.injectLogContextEnvVar = exports.enableDDTracingEnvVar = void 0;
const loglevel_1 = require("loglevel");
exports.enableDDTracingEnvVar = "DD_TRACE_ENABLED";
exports.injectLogContextEnvVar = "DD_LOG_INJECTION";
exports.defaultEnvVar = {
    addLayers: true,
    enableDatadogTracing: true,
    injectLogContext: true,
};
function applyEnvVariables(lambdas, enableDatadogTracing, injectLogContext) {
    loglevel_1.default.debug(`Setting tracing environment variables...`);
    lambdas.forEach((lam) => {
        lam.addEnvironment(exports.enableDDTracingEnvVar, enableDatadogTracing.toString().toLowerCase());
        lam.addEnvironment(exports.injectLogContextEnvVar, injectLogContext.toString().toLowerCase());
    });
}
exports.applyEnvVariables = applyEnvVariables;
//# sourceMappingURL=data:application/json;base64,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