"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const resourcegroups = require("aws-cdk-lib/aws-resourcegroups");
class BaseStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.stage = props.stage;
    }
    createResourcesGroup() {
        let cfnGroup = new resourcegroups.CfnGroup(this, `resources-group-${this.stackName}`, {
            name: this.stackName,
            resourceQuery: {
                query: {
                    stackIdentifier: this.stackId,
                },
            },
        });
        return cfnGroup;
    }
}
exports.BaseStack = BaseStack;
_a = JSII_RTTI_SYMBOL_1;
BaseStack[_a] = { fqn: "neulabs-cdk-constructs.stacks.BaseStack", version: "0.1.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmFzZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9zdGFja3MvYmFzZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDZDQUFnRDtBQUNoRCxpRUFBaUU7QUFPakUsTUFBYSxTQUFVLFNBQVEsbUJBQUs7SUFHbEMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFxQjtRQUM3RCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUN4QixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQyxLQUFLLENBQUM7SUFDM0IsQ0FBQztJQUVELG9CQUFvQjtRQUNsQixJQUFJLFFBQVEsR0FBRyxJQUFJLGNBQWMsQ0FBQyxRQUFRLENBQ3hDLElBQUksRUFDSixtQkFBbUIsSUFBSSxDQUFDLFNBQVMsRUFBRSxFQUNuQztZQUNFLElBQUksRUFBRSxJQUFJLENBQUMsU0FBUztZQUNwQixhQUFhLEVBQUU7Z0JBQ2IsS0FBSyxFQUFFO29CQUNMLGVBQWUsRUFBRSxJQUFJLENBQUMsT0FBTztpQkFDOUI7YUFDRjtTQUNGLENBQ0YsQ0FBQztRQUNGLE9BQU8sUUFBUSxDQUFDO0lBQ2xCLENBQUM7O0FBdEJILDhCQXVCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFN0YWNrLCBTdGFja1Byb3BzIH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0ICogYXMgcmVzb3VyY2Vncm91cHMgZnJvbSAnYXdzLWNkay1saWIvYXdzLXJlc291cmNlZ3JvdXBzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG5leHBvcnQgaW50ZXJmYWNlIEJhc2VTdGFja1Byb3BzIGV4dGVuZHMgU3RhY2tQcm9wcyB7XG4gIHJlYWRvbmx5IHN0YWdlOiBzdHJpbmc7XG59XG5cbmV4cG9ydCBjbGFzcyBCYXNlU3RhY2sgZXh0ZW5kcyBTdGFjayB7XG4gIHN0YWdlOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEJhc2VTdGFja1Byb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG4gICAgdGhpcy5zdGFnZSA9IHByb3BzLnN0YWdlO1xuICB9XG5cbiAgY3JlYXRlUmVzb3VyY2VzR3JvdXAoKSB7XG4gICAgbGV0IGNmbkdyb3VwID0gbmV3IHJlc291cmNlZ3JvdXBzLkNmbkdyb3VwKFxuICAgICAgdGhpcyxcbiAgICAgIGByZXNvdXJjZXMtZ3JvdXAtJHt0aGlzLnN0YWNrTmFtZX1gLFxuICAgICAge1xuICAgICAgICBuYW1lOiB0aGlzLnN0YWNrTmFtZSxcbiAgICAgICAgcmVzb3VyY2VRdWVyeToge1xuICAgICAgICAgIHF1ZXJ5OiB7XG4gICAgICAgICAgICBzdGFja0lkZW50aWZpZXI6IHRoaXMuc3RhY2tJZCxcbiAgICAgICAgICB9LFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICApO1xuICAgIHJldHVybiBjZm5Hcm91cDtcbiAgfVxufSJdfQ==