"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addBaseTags = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const env = require("./env");
function addBaseTags(module) {
    aws_cdk_lib_1.Tags.of(module).add('Environment', env.ENVIRONMENT);
    aws_cdk_lib_1.Tags.of(module).add('Date', env.NEULABS_TIMESTAMP_CDK);
    aws_cdk_lib_1.Tags.of(module).add('BusinessUnit', env.NEULABS_BUSINESS_UNIT);
    aws_cdk_lib_1.Tags.of(module).add('Domain', env.NEULABS_DOMAIN);
    aws_cdk_lib_1.Tags.of(module).add('Repository', env.NEULABS_REPOSITORY);
    aws_cdk_lib_1.Tags.of(module).add('Version', env.NEULABS_VERSION);
}
exports.addBaseTags = addBaseTags;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvY29tbW9uL3V0aWxzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDZDQUFtQztBQUNuQyw2QkFBNkI7QUFFN0IsU0FBZ0IsV0FBVyxDQUFDLE1BQVc7SUFDckMsa0JBQUksQ0FBQyxFQUFFLENBQUMsTUFBTSxDQUFDLENBQUMsR0FBRyxDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsV0FBVyxDQUFDLENBQUM7SUFDcEQsa0JBQUksQ0FBQyxFQUFFLENBQUMsTUFBTSxDQUFDLENBQUMsR0FBRyxDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN2RCxrQkFBSSxDQUFDLEVBQUUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxHQUFHLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQy9ELGtCQUFJLENBQUMsRUFBRSxDQUFDLE1BQU0sQ0FBQyxDQUFDLEdBQUcsQ0FBQyxRQUFRLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ2xELGtCQUFJLENBQUMsRUFBRSxDQUFDLE1BQU0sQ0FBQyxDQUFDLEdBQUcsQ0FBQyxZQUFZLEVBQUUsR0FBRyxDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDMUQsa0JBQUksQ0FBQyxFQUFFLENBQUMsTUFBTSxDQUFDLENBQUMsR0FBRyxDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsZUFBZSxDQUFDLENBQUM7QUFDdEQsQ0FBQztBQVBELGtDQU9DIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVGFncyB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCAqIGFzIGVudiBmcm9tICcuL2Vudic7XG5cbmV4cG9ydCBmdW5jdGlvbiBhZGRCYXNlVGFncyhtb2R1bGU6IGFueSkge1xuICBUYWdzLm9mKG1vZHVsZSkuYWRkKCdFbnZpcm9ubWVudCcsIGVudi5FTlZJUk9OTUVOVCk7XG4gIFRhZ3Mub2YobW9kdWxlKS5hZGQoJ0RhdGUnLCBlbnYuTkVVTEFCU19USU1FU1RBTVBfQ0RLKTtcbiAgVGFncy5vZihtb2R1bGUpLmFkZCgnQnVzaW5lc3NVbml0JywgZW52Lk5FVUxBQlNfQlVTSU5FU1NfVU5JVCk7XG4gIFRhZ3Mub2YobW9kdWxlKS5hZGQoJ0RvbWFpbicsIGVudi5ORVVMQUJTX0RPTUFJTik7XG4gIFRhZ3Mub2YobW9kdWxlKS5hZGQoJ1JlcG9zaXRvcnknLCBlbnYuTkVVTEFCU19SRVBPU0lUT1JZKTtcbiAgVGFncy5vZihtb2R1bGUpLmFkZCgnVmVyc2lvbicsIGVudi5ORVVMQUJTX1ZFUlNJT04pO1xufSJdfQ==