/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.util.CharBuffer;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.transforms.TransformInputOutputInterface;

public class StringArrayToStringTransform
implements TransformInputOutputInterface {
    public static StringArrayToStringTransform defaultInstance = new StringArrayToStringTransform();

    @Override
    public Object transform(Object object) {
        return this.transform(object, true);
    }

    public String transform(Object object, boolean includeQuotes) {
        if (object == null) {
            return null;
        }
        String[] array = (String[])object;
        CharBuffer buffer = new CharBuffer();
        char delimiter = Util.getListDelimiterChar();
        if (includeQuotes) {
            for (int i = 0; i < array.length; ++i) {
                buffer.append(Strings.quote(array[i]));
                buffer.append(delimiter);
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                buffer.append(array[i]);
                buffer.append(delimiter);
            }
        }
        if (!buffer.isEmpty()) {
            buffer.remove(buffer.length() - 1, buffer.length());
        }
        return buffer.toString();
    }

    @Override
    public Class getInputClass() {
        return String[].class;
    }

    @Override
    public Class getOutputClass() {
        return String.class;
    }
}

