# Line Profiler Pycharm

Code to create `.pclprof` files which can be read by the PyCharm Line Profiler plugin.

Project heavily relies on the python `line-profiler` plugin.

This package can be used by the PyCharm Line Profiler plugin to profile code and 
visualize the resulting profiles.

The package exposes a decorator `profile` that can be used to create `.pclprof` files. These files
are nothing more than json exports of the line-profiler `.lprof` files. These files can be read
by the Pycharm Line Profiler plugin.
 

## Example
The `.pclprof` files can be generated by decorating any function with the `profile` decorator

For example:
```python
# profile_this.py
from line_profiler_pycharm import profile 

import time

@profile
def profile_this():    
    time.sleep(1)
    time.sleep(2)

if __name__ == "__main__":
    profile_this()
```
 
If you run this code:
```shell script
python profile_this.py
```

A file `profile_this.py.pclprof` will be generated in your current working directory.
