"""Python wrappers around TensorFlow ops.

This file is MACHINE GENERATED! Do not edit.
Original C++ source file: encode_proto_ops.cc
"""

import collections as _collections
import six as _six

from tensorflow.python import pywrap_tensorflow as _pywrap_tensorflow
from tensorflow.python.eager import context as _context
from tensorflow.python.eager import core as _core
from tensorflow.python.eager import execute as _execute
from tensorflow.python.framework import dtypes as _dtypes
from tensorflow.python.framework import errors as _errors
from tensorflow.python.framework import tensor_shape as _tensor_shape

from tensorflow.core.framework import op_def_pb2 as _op_def_pb2
# Needed to trigger the call to _set_call_cpp_shape_fn.
from tensorflow.python.framework import common_shapes as _common_shapes
from tensorflow.python.framework import op_def_registry as _op_def_registry
from tensorflow.python.framework import ops as _ops
from tensorflow.python.framework import op_def_library as _op_def_library
from tensorflow.python.util.deprecation import deprecated_endpoints
from tensorflow.python.util import dispatch as _dispatch
from tensorflow.python.util.tf_export import tf_export
from tensorflow.python.util.tf_export import kwarg_only as _kwarg_only
from tensorflow.tools.docs import doc_controls as _doc_controls


def encode_proto(sizes, values, field_names, message_type, descriptor_source="local://", name=None):
  r"""The op serializes protobuf messages provided in the input tensors.

  The types of the tensors in `values` must match the schema for the
  fields specified in `field_names`. All the tensors in `values` must
  have a common shape prefix, *batch_shape*.

  The `sizes` tensor specifies repeat counts for each field.  The repeat
  count (last dimension) of a each tensor in `values` must be greater
  than or equal to corresponding repeat count in `sizes`.

  A `message_type` name must be provided to give context for the field
  names. The actual message descriptor can be looked up either in the
  linked-in descriptor pool or a filename provided by the caller using
  the `descriptor_source` attribute.

  The `descriptor_source` attribute selects a source of protocol
  descriptors to consult when looking up `message_type`. This may be a
  filename containing a serialized `FileDescriptorSet` message,
  or the special value `local://`, in which case only descriptors linked
  into the code will be searched; the filename can be on any filesystem
  accessible to TensorFlow.

  You can build a `descriptor_source` file using the `--descriptor_set_out`
  and `--include_imports` options to the protocol compiler `protoc`.

  The `local://` database only covers descriptors linked into the
  code via C++ libraries, not Python imports. You can link in a proto descriptor
  by creating a cc_library target with alwayslink=1.

  There are a few special cases in the value mapping:

  Submessage and group fields must be pre-serialized as TensorFlow strings.

  TensorFlow lacks support for unsigned int64s, so they must be
  represented as `tf.int64` with the same twos-complement bit pattern
  (the obvious way).

  Unsigned int32 values can be represented exactly with `tf.int64`, or
  with sign wrapping if the input is of type `tf.int32`.

  Args:
    sizes: A `Tensor` of type `int32`.
      Tensor of int32 with shape `[batch_shape, len(field_names)]`.
    values: A list of `Tensor` objects.
      List of tensors containing values for the corresponding field.
    field_names: A list of `strings`.
      List of strings containing proto field names.
    message_type: A `string`. Name of the proto message type to decode.
    descriptor_source: An optional `string`. Defaults to `"local://"`.
    name: A name for the operation (optional).

  Returns:
    A `Tensor` of type `string`.
  """
  _ctx = _context._context or _context.context()
  if _ctx is not None and _ctx._thread_local_data.is_eager:
    try:
      _result = _pywrap_tensorflow.TFE_Py_FastPathExecute(
        _ctx._context_handle, _ctx._thread_local_data.device_name,
        "EncodeProto", name, _ctx._post_execution_callbacks, sizes, values,
        "field_names", field_names, "message_type", message_type,
        "descriptor_source", descriptor_source)
      return _result
    except _core._FallbackException:
      try:
        return encode_proto_eager_fallback(
            sizes, values, field_names=field_names, message_type=message_type,
            descriptor_source=descriptor_source, name=name, ctx=_ctx)
      except _core._SymbolicException:
        pass  # Add nodes to the TensorFlow graph.
    except _core._NotOkStatusException as e:
      if name is not None:
        message = e.message + " name: " + name
      else:
        message = e.message
      _six.raise_from(_core._status_to_exception(e.code, message), None)
  # Add nodes to the TensorFlow graph.
  if not isinstance(field_names, (list, tuple)):
    raise TypeError(
        "Expected list for 'field_names' argument to "
        "'encode_proto' Op, not %r." % field_names)
  field_names = [_execute.make_str(_s, "field_names") for _s in field_names]
  message_type = _execute.make_str(message_type, "message_type")
  if descriptor_source is None:
    descriptor_source = "local://"
  descriptor_source = _execute.make_str(descriptor_source, "descriptor_source")
  _, _, _op = _op_def_lib._apply_op_helper(
        "EncodeProto", sizes=sizes, values=values, field_names=field_names,
                       message_type=message_type,
                       descriptor_source=descriptor_source, name=name)
  _result = _op.outputs[:]
  _inputs_flat = _op.inputs
  _attrs = ("field_names", _op.get_attr("field_names"), "message_type",
            _op.get_attr("message_type"), "descriptor_source",
            _op.get_attr("descriptor_source"), "Tinput_types",
            _op.get_attr("Tinput_types"))
  _execute.record_gradient(
      "EncodeProto", _inputs_flat, _attrs, _result, name)
  _result, = _result
  return _result

def EncodeProto(sizes, values, field_names, message_type, descriptor_source="local://", name=None):
  return encode_proto(sizes=sizes, values=values, field_names=field_names, message_type=message_type, descriptor_source=descriptor_source, name=name)
EncodeProto.__doc__ = encode_proto.__doc__
EncodeProto = _doc_controls.do_not_generate_docs(_kwarg_only(EncodeProto))
tf_export("raw_ops.EncodeProto")(EncodeProto)


def encode_proto_eager_fallback(sizes, values, field_names, message_type, descriptor_source="local://", name=None, ctx=None):
  r"""This is the slowpath function for Eager mode.
  This is for function encode_proto
  """
  _ctx = ctx if ctx else _context.context()
  if not isinstance(field_names, (list, tuple)):
    raise TypeError(
        "Expected list for 'field_names' argument to "
        "'encode_proto' Op, not %r." % field_names)
  field_names = [_execute.make_str(_s, "field_names") for _s in field_names]
  message_type = _execute.make_str(message_type, "message_type")
  if descriptor_source is None:
    descriptor_source = "local://"
  descriptor_source = _execute.make_str(descriptor_source, "descriptor_source")
  _attr_Tinput_types, values = _execute.convert_to_mixed_eager_tensors(values, _ctx)
  sizes = _ops.convert_to_tensor(sizes, _dtypes.int32)
  _inputs_flat = [sizes] + list(values)
  _attrs = ("field_names", field_names, "message_type", message_type,
  "descriptor_source", descriptor_source, "Tinput_types", _attr_Tinput_types)
  _result = _execute.execute(b"EncodeProto", 1, inputs=_inputs_flat,
                             attrs=_attrs, ctx=_ctx, name=name)
  _execute.record_gradient(
      "EncodeProto", _inputs_flat, _attrs, _result, name)
  _result, = _result
  return _result

def _InitOpDefLibrary(op_list_proto_bytes):
  op_list = _op_def_pb2.OpList()
  op_list.ParseFromString(op_list_proto_bytes)
  _op_def_registry.register_op_list(op_list)
  op_def_lib = _op_def_library.OpDefLibrary()
  op_def_lib.add_op_list(op_list)
  return op_def_lib
# op {
#   name: "EncodeProto"
#   input_arg {
#     name: "sizes"
#     type: DT_INT32
#   }
#   input_arg {
#     name: "values"
#     type_list_attr: "Tinput_types"
#   }
#   output_arg {
#     name: "bytes"
#     type: DT_STRING
#   }
#   attr {
#     name: "field_names"
#     type: "list(string)"
#   }
#   attr {
#     name: "message_type"
#     type: "string"
#   }
#   attr {
#     name: "descriptor_source"
#     type: "string"
#     default_value {
#       s: "local://"
#     }
#   }
#   attr {
#     name: "Tinput_types"
#     type: "list(type)"
#     has_minimum: true
#     minimum: 1
#   }
# }
_op_def_lib = _InitOpDefLibrary(b"\n\271\001\n\013EncodeProto\022\t\n\005sizes\030\003\022\026\n\006values2\014Tinput_types\032\t\n\005bytes\030\007\"\033\n\013field_names\022\014list(string)\"\026\n\014message_type\022\006string\"\'\n\021descriptor_source\022\006string\032\n\022\010local://\"\036\n\014Tinput_types\022\nlist(type)(\0010\001")
