# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class CallChainInfo(TeaModel):
    def __init__(self, additional_info=None, app_name=None, app_type=None, children=None, have_span=None,
                 log_map=None, log_time=None, parent_span_id=None, pid=None, region_id=None, result_code=None, rpc=None,
                 rpc_id=None, rpc_type=None, server_ip=None, span=None, span_id=None, tag_map=None, trace_id=None):
        self.additional_info = additional_info  # type: str
        self.app_name = app_name  # type: str
        self.app_type = app_type  # type: str
        self.children = children  # type: list[CallChainInfo]
        self.have_span = have_span  # type: bool
        self.log_map = log_map  # type: dict[str, dict]
        self.log_time = log_time  # type: long
        self.parent_span_id = parent_span_id  # type: str
        self.pid = pid  # type: str
        self.region_id = region_id  # type: str
        self.result_code = result_code  # type: str
        self.rpc = rpc  # type: str
        self.rpc_id = rpc_id  # type: str
        self.rpc_type = rpc_type  # type: long
        self.server_ip = server_ip  # type: str
        self.span = span  # type: long
        self.span_id = span_id  # type: str
        self.tag_map = tag_map  # type: dict[str, str]
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.children:
            for k in self.children:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CallChainInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.additional_info is not None:
            result['AdditionalInfo'] = self.additional_info
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.app_type is not None:
            result['AppType'] = self.app_type
        result['Children'] = []
        if self.children is not None:
            for k in self.children:
                result['Children'].append(k.to_map() if k else None)
        if self.have_span is not None:
            result['HaveSpan'] = self.have_span
        if self.log_map is not None:
            result['LogMap'] = self.log_map
        if self.log_time is not None:
            result['LogTime'] = self.log_time
        if self.parent_span_id is not None:
            result['ParentSpanId'] = self.parent_span_id
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.result_code is not None:
            result['ResultCode'] = self.result_code
        if self.rpc is not None:
            result['Rpc'] = self.rpc
        if self.rpc_id is not None:
            result['RpcId'] = self.rpc_id
        if self.rpc_type is not None:
            result['RpcType'] = self.rpc_type
        if self.server_ip is not None:
            result['ServerIp'] = self.server_ip
        if self.span is not None:
            result['Span'] = self.span
        if self.span_id is not None:
            result['SpanId'] = self.span_id
        if self.tag_map is not None:
            result['TagMap'] = self.tag_map
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AdditionalInfo') is not None:
            self.additional_info = m.get('AdditionalInfo')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        self.children = []
        if m.get('Children') is not None:
            for k in m.get('Children'):
                temp_model = CallChainInfo()
                self.children.append(temp_model.from_map(k))
        if m.get('HaveSpan') is not None:
            self.have_span = m.get('HaveSpan')
        if m.get('LogMap') is not None:
            self.log_map = m.get('LogMap')
        if m.get('LogTime') is not None:
            self.log_time = m.get('LogTime')
        if m.get('ParentSpanId') is not None:
            self.parent_span_id = m.get('ParentSpanId')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResultCode') is not None:
            self.result_code = m.get('ResultCode')
        if m.get('Rpc') is not None:
            self.rpc = m.get('Rpc')
        if m.get('RpcId') is not None:
            self.rpc_id = m.get('RpcId')
        if m.get('RpcType') is not None:
            self.rpc_type = m.get('RpcType')
        if m.get('ServerIp') is not None:
            self.server_ip = m.get('ServerIp')
        if m.get('Span') is not None:
            self.span = m.get('Span')
        if m.get('SpanId') is not None:
            self.span_id = m.get('SpanId')
        if m.get('TagMap') is not None:
            self.tag_map = m.get('TagMap')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class AddAliClusterIdsToPrometheusGlobalViewRequest(TeaModel):
    def __init__(self, cluster_ids=None, global_view_cluster_id=None, group_name=None, region_id=None):
        # The IDs of clusters. Separate multiple IDs with commas (,).
        self.cluster_ids = cluster_ids  # type: str
        # The ID of the global aggregation instance.
        self.global_view_cluster_id = global_view_cluster_id  # type: str
        # The name of the global aggregation instance.
        self.group_name = group_name  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddAliClusterIdsToPrometheusGlobalViewRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_ids is not None:
            result['ClusterIds'] = self.cluster_ids
        if self.global_view_cluster_id is not None:
            result['GlobalViewClusterId'] = self.global_view_cluster_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterIds') is not None:
            self.cluster_ids = m.get('ClusterIds')
        if m.get('GlobalViewClusterId') is not None:
            self.global_view_cluster_id = m.get('GlobalViewClusterId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class AddAliClusterIdsToPrometheusGlobalViewResponseBodyData(TeaModel):
    def __init__(self, info=None, msg=None, success=None):
        # The Info-level information.
        self.info = info  # type: str
        # The additional information.
        self.msg = msg  # type: str
        # Indicates whether the request was successful.
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddAliClusterIdsToPrometheusGlobalViewResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.info is not None:
            result['Info'] = self.info
        if self.msg is not None:
            result['Msg'] = self.msg
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Info') is not None:
            self.info = m.get('Info')
        if m.get('Msg') is not None:
            self.msg = m.get('Msg')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddAliClusterIdsToPrometheusGlobalViewResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The returned struct.
        self.data = data  # type: AddAliClusterIdsToPrometheusGlobalViewResponseBodyData
        # The ID of the request. You can use the ID to query logs and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(AddAliClusterIdsToPrometheusGlobalViewResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = AddAliClusterIdsToPrometheusGlobalViewResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddAliClusterIdsToPrometheusGlobalViewResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddAliClusterIdsToPrometheusGlobalViewResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddAliClusterIdsToPrometheusGlobalViewResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddAliClusterIdsToPrometheusGlobalViewResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddGrafanaRequest(TeaModel):
    def __init__(self, cluster_id=None, integration=None, region_id=None):
        # The ID of the Container Service for Kubernetes (ACK) cluster.
        self.cluster_id = cluster_id  # type: str
        # The abbreviation of the software that is supported by Application Real-Time Monitoring Service (ARMS). Valid values (case-insensitive): `ASM`, `IoT`, and `Flink`.
        self.integration = integration  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddGrafanaRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.integration is not None:
            result['Integration'] = self.integration
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Integration') is not None:
            self.integration = m.get('Integration')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class AddGrafanaResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # Indicates whether the call was successful.
        self.data = data  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddGrafanaResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddGrafanaResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddGrafanaResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddGrafanaResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddGrafanaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddIntegrationRequest(TeaModel):
    def __init__(self, cluster_id=None, integration=None, region_id=None):
        # The ID of an Alibaba Cloud Container Service for Kubernetes cluster.
        self.cluster_id = cluster_id  # type: str
        # The software abbreviation that is supported by ARMS. Valid values (case-insensitive): `ASM`, `IoT`, and `Flink`.
        self.integration = integration  # type: str
        # The region ID of the instance.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddIntegrationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.integration is not None:
            result['Integration'] = self.integration
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Integration') is not None:
            self.integration = m.get('Integration')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class AddIntegrationResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # Indicates whether the integration was successful.
        self.data = data  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddIntegrationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddIntegrationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddIntegrationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddIntegrationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddIntegrationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPrometheusGlobalViewRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPrometheusGlobalViewRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class AddPrometheusGlobalViewRequest(TeaModel):
    def __init__(self, clusters=None, group_name=None, region_id=None, resource_group_id=None, tag=None):
        self.clusters = clusters  # type: str
        self.group_name = group_name  # type: str
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.tag = tag  # type: list[AddPrometheusGlobalViewRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddPrometheusGlobalViewRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clusters is not None:
            result['Clusters'] = self.clusters
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Clusters') is not None:
            self.clusters = m.get('Clusters')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = AddPrometheusGlobalViewRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class AddPrometheusGlobalViewResponseBodyDataInfo(TeaModel):
    def __init__(self, failed_instances=None, global_view_cluster_id=None, region_id=None):
        self.failed_instances = failed_instances  # type: str
        self.global_view_cluster_id = global_view_cluster_id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPrometheusGlobalViewResponseBodyDataInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed_instances is not None:
            result['FailedInstances'] = self.failed_instances
        if self.global_view_cluster_id is not None:
            result['GlobalViewClusterId'] = self.global_view_cluster_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FailedInstances') is not None:
            self.failed_instances = m.get('FailedInstances')
        if m.get('GlobalViewClusterId') is not None:
            self.global_view_cluster_id = m.get('GlobalViewClusterId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class AddPrometheusGlobalViewResponseBodyData(TeaModel):
    def __init__(self, info=None, msg=None, success=None):
        self.info = info  # type: AddPrometheusGlobalViewResponseBodyDataInfo
        self.msg = msg  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.info:
            self.info.validate()

    def to_map(self):
        _map = super(AddPrometheusGlobalViewResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.info is not None:
            result['Info'] = self.info.to_map()
        if self.msg is not None:
            result['Msg'] = self.msg
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Info') is not None:
            temp_model = AddPrometheusGlobalViewResponseBodyDataInfo()
            self.info = temp_model.from_map(m['Info'])
        if m.get('Msg') is not None:
            self.msg = m.get('Msg')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddPrometheusGlobalViewResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: AddPrometheusGlobalViewResponseBodyData
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(AddPrometheusGlobalViewResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = AddPrometheusGlobalViewResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddPrometheusGlobalViewResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddPrometheusGlobalViewResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddPrometheusGlobalViewResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddPrometheusGlobalViewResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPrometheusGlobalViewByAliClusterIdsRequest(TeaModel):
    def __init__(self, cluster_ids=None, group_name=None, product_code=None, region_id=None):
        # The IDs of clusters. Separate multiple IDs with commas (,).
        self.cluster_ids = cluster_ids  # type: str
        # The name of the global aggregation instance.
        self.group_name = group_name  # type: str
        # The identifier to identify the service if custom dashboards are created for the specified clusters.
        self.product_code = product_code  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPrometheusGlobalViewByAliClusterIdsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_ids is not None:
            result['ClusterIds'] = self.cluster_ids
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterIds') is not None:
            self.cluster_ids = m.get('ClusterIds')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class AddPrometheusGlobalViewByAliClusterIdsResponseBodyData(TeaModel):
    def __init__(self, info=None, msg=None, success=None):
        # The Info-level information.
        self.info = info  # type: str
        # The additional information.
        self.msg = msg  # type: str
        # Indicates whether the call was successful. Valid values:
        # 
        # *   `true`: The call was successful.
        # *   `false`: The call failed.
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPrometheusGlobalViewByAliClusterIdsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.info is not None:
            result['Info'] = self.info
        if self.msg is not None:
            result['Msg'] = self.msg
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Info') is not None:
            self.info = m.get('Info')
        if m.get('Msg') is not None:
            self.msg = m.get('Msg')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddPrometheusGlobalViewByAliClusterIdsResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The returned struct.
        self.data = data  # type: AddPrometheusGlobalViewByAliClusterIdsResponseBodyData
        # The ID of the request. You can use the ID to query logs and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(AddPrometheusGlobalViewByAliClusterIdsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = AddPrometheusGlobalViewByAliClusterIdsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddPrometheusGlobalViewByAliClusterIdsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddPrometheusGlobalViewByAliClusterIdsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddPrometheusGlobalViewByAliClusterIdsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddPrometheusGlobalViewByAliClusterIdsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPrometheusInstanceRequest(TeaModel):
    def __init__(self, name=None, region_id=None, type=None):
        # The name of the Prometheus instance for Remote Write.
        self.name = name  # type: str
        # The ID of the region in which the instance resides.
        self.region_id = region_id  # type: str
        # The type of the Prometheus instance. Only Prometheus instances for Remote Write is supported. Set the value to RW.
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPrometheusInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddPrometheusInstanceResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The struct returned. { "RequestId": the ID of the request. "Data": "{ "clusterType": the type of the cluster. "remoteWriteUrl": the public URL for remote write. "internetGrafanaUrl": the internal URL for Grafana. "authToken": specifies whether to enable the token. "internetPushGatewayUrl": the internal URL for Pushgateway. "ClusterId": the ID of the cluster. "internetRemoteReadUrl": the internal URL for remote read. "remoteReadUrl": the internal URL for remote read. "grafanaUrl": the public URL for Grafana. "pushGatewayUrl": the public URL for Pushgateway. "internetRemoteWriteUrl": the internal network for remote write." }
        self.data = data  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPrometheusInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddPrometheusInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddPrometheusInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddPrometheusInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddPrometheusInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPrometheusIntegrationRequest(TeaModel):
    def __init__(self, cluster_id=None, integration_type=None, param=None, region_id=None):
        self.cluster_id = cluster_id  # type: str
        self.integration_type = integration_type  # type: str
        self.param = param  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPrometheusIntegrationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.integration_type is not None:
            result['IntegrationType'] = self.integration_type
        if self.param is not None:
            result['Param'] = self.param
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('IntegrationType') is not None:
            self.integration_type = m.get('IntegrationType')
        if m.get('Param') is not None:
            self.param = m.get('Param')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class AddPrometheusIntegrationResponseBodyData(TeaModel):
    def __init__(self, instance_id=None, instance_name=None):
        self.instance_id = instance_id  # type: long
        self.instance_name = instance_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPrometheusIntegrationResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        return self


class AddPrometheusIntegrationResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: int
        self.data = data  # type: AddPrometheusIntegrationResponseBodyData
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(AddPrometheusIntegrationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = AddPrometheusIntegrationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddPrometheusIntegrationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddPrometheusIntegrationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddPrometheusIntegrationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddPrometheusIntegrationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPrometheusRemoteWriteRequest(TeaModel):
    def __init__(self, cluster_id=None, region_id=None, remote_write_yaml=None):
        # The ID of the Prometheus instance.
        self.cluster_id = cluster_id  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The details of the Remote Write configuration item. Specify the value in the YAML format.
        self.remote_write_yaml = remote_write_yaml  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPrometheusRemoteWriteRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.remote_write_yaml is not None:
            result['RemoteWriteYaml'] = self.remote_write_yaml
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RemoteWriteYaml') is not None:
            self.remote_write_yaml = m.get('RemoteWriteYaml')
        return self


class AddPrometheusRemoteWriteResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        # The HTTP status code that is returned. The HTTP 200 status code indicates that the call is successful. If a different HTTP status code is returned, the call fails.
        self.code = code  # type: int
        # If the call is successful, the name of the Remote Write configuration item that is added is returned. If the call fails, an error message is returned.
        self.data = data  # type: str
        # The message that is returned.
        self.message = message  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Indicates whether the call was successful. Valid values:
        # 
        # *   `true`
        # *   `false`
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPrometheusRemoteWriteResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddPrometheusRemoteWriteResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddPrometheusRemoteWriteResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddPrometheusRemoteWriteResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddPrometheusRemoteWriteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddRecordingRuleRequest(TeaModel):
    def __init__(self, cluster_id=None, region_id=None, rule_yaml=None):
        # The ID of the cluster.
        self.cluster_id = cluster_id  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The custom recording rule. The value is in the YAML format.
        self.rule_yaml = rule_yaml  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddRecordingRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_yaml is not None:
            result['RuleYaml'] = self.rule_yaml
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleYaml') is not None:
            self.rule_yaml = m.get('RuleYaml')
        return self


class AddRecordingRuleResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The status of the response.
        self.data = data  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddRecordingRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddRecordingRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddRecordingRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddRecordingRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddRecordingRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AppendInstancesToPrometheusGlobalViewRequest(TeaModel):
    def __init__(self, clusters=None, global_view_cluster_id=None, group_name=None, region_id=None):
        self.clusters = clusters  # type: str
        self.global_view_cluster_id = global_view_cluster_id  # type: str
        self.group_name = group_name  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AppendInstancesToPrometheusGlobalViewRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clusters is not None:
            result['Clusters'] = self.clusters
        if self.global_view_cluster_id is not None:
            result['GlobalViewClusterId'] = self.global_view_cluster_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Clusters') is not None:
            self.clusters = m.get('Clusters')
        if m.get('GlobalViewClusterId') is not None:
            self.global_view_cluster_id = m.get('GlobalViewClusterId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class AppendInstancesToPrometheusGlobalViewResponseBodyData(TeaModel):
    def __init__(self, info=None, msg=None, success=None):
        self.info = info  # type: str
        self.msg = msg  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(AppendInstancesToPrometheusGlobalViewResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.info is not None:
            result['Info'] = self.info
        if self.msg is not None:
            result['Msg'] = self.msg
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Info') is not None:
            self.info = m.get('Info')
        if m.get('Msg') is not None:
            self.msg = m.get('Msg')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AppendInstancesToPrometheusGlobalViewResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: AppendInstancesToPrometheusGlobalViewResponseBodyData
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(AppendInstancesToPrometheusGlobalViewResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = AppendInstancesToPrometheusGlobalViewResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AppendInstancesToPrometheusGlobalViewResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AppendInstancesToPrometheusGlobalViewResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AppendInstancesToPrometheusGlobalViewResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AppendInstancesToPrometheusGlobalViewResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyScenarioRequest(TeaModel):
    def __init__(self, app_id=None, config=None, name=None, region_id=None, scenario=None, sign=None, sn_dump=None,
                 sn_force=None, sn_stat=None, sn_transfer=None, update_option=None):
        # The ID of the application.
        self.app_id = app_id  # type: str
        # The configuration of the business monitoring job. The value is a JSON string. For more information about this parameter, see the following additional information about the **Config** parameter.
        self.config = config  # type: dict[str, any]
        # The name of the business monitoring job.
        self.name = name  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The scenario where you want to use the business monitoring job. Valid values:
        # 
        # *   `USER-DEFINED`: user-defined. This is the default value.
        # *   `EDAS-ROLLOUT`: application release in Enterprise Distributed Application Service (EDAS)
        # *   `OAM-ROLLOUT`: application release based on Open Application Model (OAM)
        # *   `MSC-CANARY`: canary release based on Microservice Engine (MSE)
        self.scenario = scenario  # type: str
        # The code of the business monitoring job. This parameter is not required when you create a business monitoring job. However, this parameter is required when you update a business monitoring job.
        self.sign = sign  # type: str
        # Specifies whether to record business parameters to the trace marked with the coloring sign.
        # 
        # *   `true`
        # *   `false`: This is the default value.
        self.sn_dump = sn_dump  # type: bool
        # Specifies whether traffic in the trace marked with the coloring sign is all collected.
        # 
        # *   `true`
        # *   `false`: This is the default value.
        self.sn_force = sn_force  # type: bool
        # Specifies whether to count traffic based on the coloring sign.
        # 
        # *   `true`
        # *   `false`: This is the default value.
        self.sn_stat = sn_stat  # type: bool
        # Specifies whether the coloring sign is transparently passed down to downstream application nodes in the trace.
        # 
        # *   `true`
        # *   `false`: This is the default value.
        self.sn_transfer = sn_transfer  # type: bool
        # Specifies whether the operation is an update operation.
        # 
        # *   `true`: update
        # *   `false`: insert
        self.update_option = update_option  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyScenarioRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.config is not None:
            result['Config'] = self.config
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.scenario is not None:
            result['Scenario'] = self.scenario
        if self.sign is not None:
            result['Sign'] = self.sign
        if self.sn_dump is not None:
            result['SnDump'] = self.sn_dump
        if self.sn_force is not None:
            result['SnForce'] = self.sn_force
        if self.sn_stat is not None:
            result['SnStat'] = self.sn_stat
        if self.sn_transfer is not None:
            result['SnTransfer'] = self.sn_transfer
        if self.update_option is not None:
            result['UpdateOption'] = self.update_option
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Scenario') is not None:
            self.scenario = m.get('Scenario')
        if m.get('Sign') is not None:
            self.sign = m.get('Sign')
        if m.get('SnDump') is not None:
            self.sn_dump = m.get('SnDump')
        if m.get('SnForce') is not None:
            self.sn_force = m.get('SnForce')
        if m.get('SnStat') is not None:
            self.sn_stat = m.get('SnStat')
        if m.get('SnTransfer') is not None:
            self.sn_transfer = m.get('SnTransfer')
        if m.get('UpdateOption') is not None:
            self.update_option = m.get('UpdateOption')
        return self


class ApplyScenarioShrinkRequest(TeaModel):
    def __init__(self, app_id=None, config_shrink=None, name=None, region_id=None, scenario=None, sign=None,
                 sn_dump=None, sn_force=None, sn_stat=None, sn_transfer=None, update_option=None):
        # The ID of the application.
        self.app_id = app_id  # type: str
        # The configuration of the business monitoring job. The value is a JSON string. For more information about this parameter, see the following additional information about the **Config** parameter.
        self.config_shrink = config_shrink  # type: str
        # The name of the business monitoring job.
        self.name = name  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The scenario where you want to use the business monitoring job. Valid values:
        # 
        # *   `USER-DEFINED`: user-defined. This is the default value.
        # *   `EDAS-ROLLOUT`: application release in Enterprise Distributed Application Service (EDAS)
        # *   `OAM-ROLLOUT`: application release based on Open Application Model (OAM)
        # *   `MSC-CANARY`: canary release based on Microservice Engine (MSE)
        self.scenario = scenario  # type: str
        # The code of the business monitoring job. This parameter is not required when you create a business monitoring job. However, this parameter is required when you update a business monitoring job.
        self.sign = sign  # type: str
        # Specifies whether to record business parameters to the trace marked with the coloring sign.
        # 
        # *   `true`
        # *   `false`: This is the default value.
        self.sn_dump = sn_dump  # type: bool
        # Specifies whether traffic in the trace marked with the coloring sign is all collected.
        # 
        # *   `true`
        # *   `false`: This is the default value.
        self.sn_force = sn_force  # type: bool
        # Specifies whether to count traffic based on the coloring sign.
        # 
        # *   `true`
        # *   `false`: This is the default value.
        self.sn_stat = sn_stat  # type: bool
        # Specifies whether the coloring sign is transparently passed down to downstream application nodes in the trace.
        # 
        # *   `true`
        # *   `false`: This is the default value.
        self.sn_transfer = sn_transfer  # type: bool
        # Specifies whether the operation is an update operation.
        # 
        # *   `true`: update
        # *   `false`: insert
        self.update_option = update_option  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyScenarioShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.config_shrink is not None:
            result['Config'] = self.config_shrink
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.scenario is not None:
            result['Scenario'] = self.scenario
        if self.sign is not None:
            result['Sign'] = self.sign
        if self.sn_dump is not None:
            result['SnDump'] = self.sn_dump
        if self.sn_force is not None:
            result['SnForce'] = self.sn_force
        if self.sn_stat is not None:
            result['SnStat'] = self.sn_stat
        if self.sn_transfer is not None:
            result['SnTransfer'] = self.sn_transfer
        if self.update_option is not None:
            result['UpdateOption'] = self.update_option
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Config') is not None:
            self.config_shrink = m.get('Config')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Scenario') is not None:
            self.scenario = m.get('Scenario')
        if m.get('Sign') is not None:
            self.sign = m.get('Sign')
        if m.get('SnDump') is not None:
            self.sn_dump = m.get('SnDump')
        if m.get('SnForce') is not None:
            self.sn_force = m.get('SnForce')
        if m.get('SnStat') is not None:
            self.sn_stat = m.get('SnStat')
        if m.get('SnTransfer') is not None:
            self.sn_transfer = m.get('SnTransfer')
        if m.get('UpdateOption') is not None:
            self.update_option = m.get('UpdateOption')
        return self


class ApplyScenarioResponseBody(TeaModel):
    def __init__(self, request_id=None, result=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The code of the business monitoring job, which is the coloring sign.
        self.result = result  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyScenarioResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class ApplyScenarioResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ApplyScenarioResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ApplyScenarioResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyScenarioResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindPrometheusGrafanaInstanceRequest(TeaModel):
    def __init__(self, cluster_id=None, grafana_instance_id=None, region_id=None, resource_group_id=None):
        # The ID of the Prometheus instance.
        self.cluster_id = cluster_id  # type: str
        # The ID of the Grafana workspace.
        self.grafana_instance_id = grafana_instance_id  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str
        # Prometheus实例的资源组ID。
        self.resource_group_id = resource_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindPrometheusGrafanaInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.grafana_instance_id is not None:
            result['GrafanaInstanceId'] = self.grafana_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('GrafanaInstanceId') is not None:
            self.grafana_instance_id = m.get('GrafanaInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class BindPrometheusGrafanaInstanceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        # The status code returned. 200 indicates that the Prometheus agent was installed. Otherwise, the Prometheus agent fails to be installed.
        self.code = code  # type: int
        # Indicates whether the request was successful.
        self.data = data  # type: bool
        # The message returned.
        self.message = message  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindPrometheusGrafanaInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BindPrometheusGrafanaInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BindPrometheusGrafanaInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BindPrometheusGrafanaInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BindPrometheusGrafanaInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeResourceGroupRequest(TeaModel):
    def __init__(self, new_resource_group_id=None, region_id=None, resource_id=None, resource_type=None):
        # The ID of the new resource group. You can view the available resource groups in the Resource Management console.
        self.new_resource_group_id = new_resource_group_id  # type: str
        # The ID of the region in which the resource is deployed.
        self.region_id = region_id  # type: str
        # The ID of the Application Real-Time Monitoring Service (ARMS) resource that you want to move to a specific resource group.
        self.resource_id = resource_id  # type: str
        # The type of the ARMS resource that you want to move to a specific resource group.
        self.resource_type = resource_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ChangeResourceGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.new_resource_group_id is not None:
            result['NewResourceGroupId'] = self.new_resource_group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NewResourceGroupId') is not None:
            self.new_resource_group_id = m.get('NewResourceGroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class ChangeResourceGroupResponseBodyData(TeaModel):
    def __init__(self, resource_group_id=None, resource_id=None):
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        # The ID of the resource.
        self.resource_id = resource_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ChangeResourceGroupResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class ChangeResourceGroupResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        # Interface status or pop error code.
        self.code = code  # type: str
        # The returned struct.
        self.data = data  # type: ChangeResourceGroupResponseBodyData
        # The returned message.
        self.message = message  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ChangeResourceGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ChangeResourceGroupResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ChangeResourceGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ChangeResourceGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ChangeResourceGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ChangeResourceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckServiceStatusRequest(TeaModel):
    def __init__(self, region_id=None, svc_code=None):
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The service code of an Alibaba Cloud service. The service code of Prometheus Service is prometheus.
        self.svc_code = svc_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckServiceStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.svc_code is not None:
            result['SvcCode'] = self.svc_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SvcCode') is not None:
            self.svc_code = m.get('SvcCode')
        return self


class CheckServiceStatusResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # Indicates whether the request was successful.
        # 
        # *   true: The request was successful.
        # *   false: The request failed.
        self.data = data  # type: str
        # The ID of the request. You can query logs and troubleshoot issues based on the ID.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckServiceStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckServiceStatusResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CheckServiceStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckServiceStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckServiceStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConfigAppRequest(TeaModel):
    def __init__(self, app_ids=None, enable=None, region_id=None, type=None):
        # The process identifier (PID) of the application. Separate multiple PIDs with commas (,).
        self.app_ids = app_ids  # type: str
        # Specifies whether to turn on or turn off the main switch of the ARMS agent. The monitoring stops after the switch is turned off. If you do not specify this parameter, the main switch status of the ARMS agent is queried.
        # 
        # *   `true`: turns on the switch
        # *   `false`: turns off the switch
        self.enable = enable  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The type of the application. Set the value to **TRACE**.
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ConfigAppRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_ids is not None:
            result['AppIds'] = self.app_ids
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppIds') is not None:
            self.app_ids = m.get('AppIds')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ConfigAppResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The result of turning on or turning off the main switch of the ARMS agent or the main switch status of the ARMS agent.
        self.data = data  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ConfigAppResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ConfigAppResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ConfigAppResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ConfigAppResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ConfigAppResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAlertContactRequest(TeaModel):
    def __init__(self, contact_name=None, ding_robot_webhook_url=None, email=None, phone_num=None, region_id=None,
                 resource_group_id=None, system_noc=None):
        # The name of the alert contact.
        self.contact_name = contact_name  # type: str
        # The webhook URL of the DingTalk chatbot. For more information about how to obtain the URL, see [Configure a DingTalk chatbot to send alert notifications](https://www.alibabacloud.com/help/zh/doc-detail/106247.htm). You must specify at least one of the following parameters: PhoneNum, Email, and DingRobotWebhookUrl.
        # 
        # >  Enter `alert` in the custom keyword field of DingTalk chatbot security settings.
        self.ding_robot_webhook_url = ding_robot_webhook_url  # type: str
        # The email address of the alert contact. You must specify at least one of the following parameters: PhoneNum, Email, and DingRobotWebhookUrl.
        self.email = email  # type: str
        # The mobile number of the alert contact. You must specify at least one of the following parameters: PhoneNum, Email, and DingRobotWebhookUrl.
        self.phone_num = phone_num  # type: str
        # The ID of the region. Set the value to `cn-hangzhou`.
        self.region_id = region_id  # type: str
        # The ID of the resource group. You can obtain the resource group ID in the **Resource Management** console.
        self.resource_group_id = resource_group_id  # type: str
        # Specifies whether the alert contact receives system notifications. Valid values:
        # 
        # *   `true`: The alert contact receives system notifications.
        # *   `false`: The alert contact does not receive system notifications.
        self.system_noc = system_noc  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAlertContactRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_name is not None:
            result['ContactName'] = self.contact_name
        if self.ding_robot_webhook_url is not None:
            result['DingRobotWebhookUrl'] = self.ding_robot_webhook_url
        if self.email is not None:
            result['Email'] = self.email
        if self.phone_num is not None:
            result['PhoneNum'] = self.phone_num
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.system_noc is not None:
            result['SystemNoc'] = self.system_noc
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactName') is not None:
            self.contact_name = m.get('ContactName')
        if m.get('DingRobotWebhookUrl') is not None:
            self.ding_robot_webhook_url = m.get('DingRobotWebhookUrl')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('PhoneNum') is not None:
            self.phone_num = m.get('PhoneNum')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SystemNoc') is not None:
            self.system_noc = m.get('SystemNoc')
        return self


class CreateAlertContactResponseBody(TeaModel):
    def __init__(self, contact_id=None, request_id=None):
        # The ID of the alert contact.
        self.contact_id = contact_id  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAlertContactResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAlertContactResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateAlertContactResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateAlertContactResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAlertContactResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAlertContactGroupRequest(TeaModel):
    def __init__(self, contact_group_name=None, contact_ids=None, region_id=None):
        # The name of the alert contact group.
        self.contact_group_name = contact_group_name  # type: str
        # The IDs of contacts in the contact group. Separate multiple contact IDs with spaces. You can call the SearchAlertContact operation to query the contact IDs. For more information, see [SearchAlertContact](~~130703~~).
        self.contact_ids = contact_ids  # type: str
        # The ID of the region. Default value: `cn-hangzhou`.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAlertContactGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_name is not None:
            result['ContactGroupName'] = self.contact_group_name
        if self.contact_ids is not None:
            result['ContactIds'] = self.contact_ids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactGroupName') is not None:
            self.contact_group_name = m.get('ContactGroupName')
        if m.get('ContactIds') is not None:
            self.contact_ids = m.get('ContactIds')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateAlertContactGroupResponseBody(TeaModel):
    def __init__(self, contact_group_id=None, request_id=None):
        # The ID of the alert contact group.
        self.contact_group_id = contact_group_id  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAlertContactGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_id is not None:
            result['ContactGroupId'] = self.contact_group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactGroupId') is not None:
            self.contact_group_id = m.get('ContactGroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAlertContactGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateAlertContactGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateAlertContactGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAlertContactGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDispatchRuleRequest(TeaModel):
    def __init__(self, dispatch_rule=None, region_id=None):
        # The dispatch rule configuration. The value is a JSON string. For more information about this parameter, see the following **additional information about the DispatchRule parameter**.
        self.dispatch_rule = dispatch_rule  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDispatchRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dispatch_rule is not None:
            result['DispatchRule'] = self.dispatch_rule
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DispatchRule') is not None:
            self.dispatch_rule = m.get('DispatchRule')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateDispatchRuleResponseBody(TeaModel):
    def __init__(self, dispatch_rule_id=None, request_id=None):
        # The ID of the dispatch policy.
        self.dispatch_rule_id = dispatch_rule_id  # type: long
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDispatchRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dispatch_rule_id is not None:
            result['DispatchRuleId'] = self.dispatch_rule_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DispatchRuleId') is not None:
            self.dispatch_rule_id = m.get('DispatchRuleId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDispatchRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDispatchRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDispatchRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDispatchRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateIntegrationRequest(TeaModel):
    def __init__(self, auto_recover=None, description=None, integration_name=None, integration_product_type=None,
                 recover_time=None):
        # Specifies whether to automatically clear alert events. Valid values:
        # 
        # *   true (default)
        # *   false
        self.auto_recover = auto_recover  # type: bool
        # The description of the alert integration.
        self.description = description  # type: str
        # The name of the alert integration.
        self.integration_name = integration_name  # type: str
        # The service of the alert integration. Valid values:
        # 
        # *   CLOUD_MONITOR: CloudMonitor
        # *   LOG_SERVICE: Log Service
        self.integration_product_type = integration_product_type  # type: str
        # The time when alert events are automatically cleared. Unit: seconds. Default value: 300.
        self.recover_time = recover_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateIntegrationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_recover is not None:
            result['AutoRecover'] = self.auto_recover
        if self.description is not None:
            result['Description'] = self.description
        if self.integration_name is not None:
            result['IntegrationName'] = self.integration_name
        if self.integration_product_type is not None:
            result['IntegrationProductType'] = self.integration_product_type
        if self.recover_time is not None:
            result['RecoverTime'] = self.recover_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoRecover') is not None:
            self.auto_recover = m.get('AutoRecover')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IntegrationName') is not None:
            self.integration_name = m.get('IntegrationName')
        if m.get('IntegrationProductType') is not None:
            self.integration_product_type = m.get('IntegrationProductType')
        if m.get('RecoverTime') is not None:
            self.recover_time = m.get('RecoverTime')
        return self


class CreateIntegrationResponseBodyIntegration(TeaModel):
    def __init__(self, auto_recover=None, description=None, integration_id=None, integration_name=None,
                 integration_product_type=None, recover_time=None):
        # Indicates whether alert events are automatically cleared. Valid values:
        # 
        # *   true (default)
        # *   false
        self.auto_recover = auto_recover  # type: bool
        # The description of the alert integration.
        self.description = description  # type: str
        # The ID of the alert integration.
        self.integration_id = integration_id  # type: long
        # The name of the alert integration.
        self.integration_name = integration_name  # type: str
        # The service of the alert integration. Valid values:
        # 
        # *   CLOUD_MONITOR: CloudMonitor
        # *   LOG_SERVICE: Log Service
        self.integration_product_type = integration_product_type  # type: str
        # The time when alert events are automatically cleared. Unit: seconds. Default value: 300.
        self.recover_time = recover_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateIntegrationResponseBodyIntegration, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_recover is not None:
            result['AutoRecover'] = self.auto_recover
        if self.description is not None:
            result['Description'] = self.description
        if self.integration_id is not None:
            result['IntegrationId'] = self.integration_id
        if self.integration_name is not None:
            result['IntegrationName'] = self.integration_name
        if self.integration_product_type is not None:
            result['IntegrationProductType'] = self.integration_product_type
        if self.recover_time is not None:
            result['RecoverTime'] = self.recover_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoRecover') is not None:
            self.auto_recover = m.get('AutoRecover')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IntegrationId') is not None:
            self.integration_id = m.get('IntegrationId')
        if m.get('IntegrationName') is not None:
            self.integration_name = m.get('IntegrationName')
        if m.get('IntegrationProductType') is not None:
            self.integration_product_type = m.get('IntegrationProductType')
        if m.get('RecoverTime') is not None:
            self.recover_time = m.get('RecoverTime')
        return self


class CreateIntegrationResponseBody(TeaModel):
    def __init__(self, integration=None, request_id=None):
        # The returned information about the alert integration.
        self.integration = integration  # type: CreateIntegrationResponseBodyIntegration
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.integration:
            self.integration.validate()

    def to_map(self):
        _map = super(CreateIntegrationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.integration is not None:
            result['Integration'] = self.integration.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Integration') is not None:
            temp_model = CreateIntegrationResponseBodyIntegration()
            self.integration = temp_model.from_map(m['Integration'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateIntegrationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateIntegrationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateIntegrationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateIntegrationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOrUpdateAlertRuleRequest(TeaModel):
    def __init__(self, alert_check_type=None, alert_group=None, alert_id=None, alert_name=None,
                 alert_rule_content=None, alert_status=None, alert_type=None, annotations=None, auto_add_new_application=None,
                 cluster_id=None, duration=None, filters=None, labels=None, level=None, message=None, metrics_key=None,
                 metrics_type=None, notify_strategy=None, pids=None, prom_ql=None, region_id=None):
        # The alert check type of the Prometheus alert rule.
        # 
        # *   STATIC: a static threshold value. If you set the parameter to STATIC, you must specify the **MetricsKey** parameter. For more information, see the **Correspondence between AlertGroup and MetricsKey for Prometheus Service** table.
        # *   CUSTOM: a custom PromQL statement. If you set the parameter to CUSTOM, you must specify the **PromQL**, **Duration**, and **Message** parameters to create a Prometheus alert rule.
        self.alert_check_type = alert_check_type  # type: str
        # The alert contact group ID of the Prometheus alert rule.
        # 
        # *   \-1: custom PromQL
        # *   1: Kubernetes load
        # *   15: Kubernetes node
        self.alert_group = alert_group  # type: long
        # The ID of the alert rule.
        # 
        # *   If you do not specify this parameter, a new alert rule is created.
        # *   If you specify this parameter, the specified alert rule is modified.
        self.alert_id = alert_id  # type: long
        # The name of the alert rule.
        self.alert_name = alert_name  # type: str
        # The content of the Application Monitoring or Browser Monitoring alert rule. The following code provides an example of the **AlertRuleContent** parameter. For more information about the meaning of each field, see the supplementary description.
        # 
        # `{ "Condition": "OR", "AlertRuleItems": [ { "Operator": "CURRENT_LTE", "MetricKey": "appstat.jvm.threadcount", "Value": 1000, "Aggregate": "AVG", "N": 1 } ] }`
        # 
        # >  The conditional fields vary depending on the values of the **MetricsType** and **AlertRuleItems.MetricKey** parameters. For more information about the types of metrics supported by Application Monitoring and Browser Monitoring and the alert rule fields corresponding to each metric, see the supplementary description.
        self.alert_rule_content = alert_rule_content  # type: str
        # The status of the alert rule.
        # 
        # *   RUNNING (default)
        # *   STOPPED
        self.alert_status = alert_status  # type: str
        # The type of the alert rule. Valid values:
        # 
        # *   APPLICATION_MONITORING_ALERT_RULE: alert rule for Application Monitoring
        # *   BROWSER_MONITORING_ALERT_RULE: alert rule for Browser Monitoring
        # *   PROMETHEUS_MONITORING_ALERT_RULE: alert rule for Prometheus Service
        self.alert_type = alert_type  # type: str
        # The annotations of the Prometheus alert rule.
        self.annotations = annotations  # type: str
        # Specifies whether to apply the alert rule to new applications that are created in Application Monitoring or Browser Monitoring.
        # 
        # *   `true`: yes
        # *   `false`: no
        self.auto_add_new_application = auto_add_new_application  # type: bool
        # The cluster ID of the Prometheus alert rule.
        self.cluster_id = cluster_id  # type: str
        # The duration of the Prometheus alert rule. Unit: minutes.
        self.duration = duration  # type: long
        # The filter conditions of the Application Monitoring or Browser Monitoring alert rule.
        # 
        # Format:
        # 
        # ```
        # 
        # "DimFilters": [ 
        # { 
        #  "FilterOpt": "ALL",
        #  "FilterValues": [],         //The value of the filter condition. 
        #  "FilterKey": "rootIp"     //The Key of the filter condition. 
        # }
        # ]
        #                                 
        # ```
        # 
        # Valid values of **FilterOpt**:
        # 
        # *   STATIC: matches the value of the specified dimension.
        # *   ALL: matches the values of all dimensions.
        # *   DISABLE: aggregates the values of all dimensions.
        self.filters = filters  # type: str
        # The tags of the Prometheus alert rule.
        self.labels = labels  # type: str
        # The level of the Prometheus alert rule.
        # 
        # *   P1: Alert notifications are sent for major issues that affect the availability of core business, have huge impact, and may lead to serious consequences.
        # *   P2: Alert notifications are sent for service errors that affect the system availability with relatively limited impact.
        # *   P3: Alert notifications are sent for issues that may cause service errors or negative effects, or alert notifications for services that are relatively less important.
        # *   P4: Alert notifications are sent for low-priority issues that do not affect your business.
        # *   Default: Alert notifications are sent without distinguishing between alert levels.
        self.level = level  # type: str
        # The alert message of the Prometheus alert rule.
        self.message = message  # type: str
        # The alert metrics. If you set the **AlertCheckType** parameter to **STATIC** when you create a Prometheus alert rule, you must specify the **MetricsKey** parameter.
        # 
        # >  Alert metrics vary depending on the value of the **AlertGroup** parameter. For more information about the correspondence between **AlertGroup** and **MetricsKey**, see the supplementary description.
        self.metrics_key = metrics_key  # type: str
        # The metric type of the Application Monitoring or Browser Monitoring alert rule. For more information, see the following tables.
        self.metrics_type = metrics_type  # type: str
        # The notification policy.
        # 
        # *   If you set this parameter to null, no notification policy is specified. After you create an alert rule, you can create a notification policy and specify match rules and match conditions. For example, you can specify an alert rule name as the match condition. When the alert rule is triggered, an alert event is generated and an alert notification is sent to the contacts or contact groups that are specified in the notification policy.
        # *   To specify a notification policy, set this parameter to the ID of the notification policy. Application Real-Time Monitoring Service (ARMS) automatically adds a match rule to the notification policy and specifies the ID of the alert rule as the match condition. The name of the alert rule is also displayed. This way, the alert events that are generated based on the alert rule can be matched by the specified notification policy.
        self.notify_strategy = notify_strategy  # type: str
        # The process ID (PID) that is associated with the Application Monitoring or Browser Monitoring alert rule.
        self.pids = pids  # type: str
        # The PromQL statement of the Prometheus alert rule.
        self.prom_ql = prom_ql  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateAlertRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_check_type is not None:
            result['AlertCheckType'] = self.alert_check_type
        if self.alert_group is not None:
            result['AlertGroup'] = self.alert_group
        if self.alert_id is not None:
            result['AlertId'] = self.alert_id
        if self.alert_name is not None:
            result['AlertName'] = self.alert_name
        if self.alert_rule_content is not None:
            result['AlertRuleContent'] = self.alert_rule_content
        if self.alert_status is not None:
            result['AlertStatus'] = self.alert_status
        if self.alert_type is not None:
            result['AlertType'] = self.alert_type
        if self.annotations is not None:
            result['Annotations'] = self.annotations
        if self.auto_add_new_application is not None:
            result['AutoAddNewApplication'] = self.auto_add_new_application
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.filters is not None:
            result['Filters'] = self.filters
        if self.labels is not None:
            result['Labels'] = self.labels
        if self.level is not None:
            result['Level'] = self.level
        if self.message is not None:
            result['Message'] = self.message
        if self.metrics_key is not None:
            result['MetricsKey'] = self.metrics_key
        if self.metrics_type is not None:
            result['MetricsType'] = self.metrics_type
        if self.notify_strategy is not None:
            result['NotifyStrategy'] = self.notify_strategy
        if self.pids is not None:
            result['Pids'] = self.pids
        if self.prom_ql is not None:
            result['PromQL'] = self.prom_ql
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertCheckType') is not None:
            self.alert_check_type = m.get('AlertCheckType')
        if m.get('AlertGroup') is not None:
            self.alert_group = m.get('AlertGroup')
        if m.get('AlertId') is not None:
            self.alert_id = m.get('AlertId')
        if m.get('AlertName') is not None:
            self.alert_name = m.get('AlertName')
        if m.get('AlertRuleContent') is not None:
            self.alert_rule_content = m.get('AlertRuleContent')
        if m.get('AlertStatus') is not None:
            self.alert_status = m.get('AlertStatus')
        if m.get('AlertType') is not None:
            self.alert_type = m.get('AlertType')
        if m.get('Annotations') is not None:
            self.annotations = m.get('Annotations')
        if m.get('AutoAddNewApplication') is not None:
            self.auto_add_new_application = m.get('AutoAddNewApplication')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Filters') is not None:
            self.filters = m.get('Filters')
        if m.get('Labels') is not None:
            self.labels = m.get('Labels')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MetricsKey') is not None:
            self.metrics_key = m.get('MetricsKey')
        if m.get('MetricsType') is not None:
            self.metrics_type = m.get('MetricsType')
        if m.get('NotifyStrategy') is not None:
            self.notify_strategy = m.get('NotifyStrategy')
        if m.get('Pids') is not None:
            self.pids = m.get('Pids')
        if m.get('PromQL') is not None:
            self.prom_ql = m.get('PromQL')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateOrUpdateAlertRuleResponseBodyAlertRuleAlertRuleContentAlertRuleItems(TeaModel):
    def __init__(self, aggregate=None, metric_key=None, n=None, operator=None, value=None):
        # The aggregation method of the alert condition.
        # 
        # *   AVG: calculates the average value
        # *   SUM: calculates the total value
        # *   MAX: selects the maximum value
        # *   MIN: selects the minimum value
        self.aggregate = aggregate  # type: str
        # The metric of the alert condition.
        self.metric_key = metric_key  # type: str
        # Indicates the last N minutes.
        self.n = n  # type: float
        # The comparison operator that is used to compare the metric value with the threshold.
        # 
        # *   CURRENT_GTE: greater than or equal to
        # *   CURRENT_LTE: less than or equal to
        # *   PREVIOUS_UP: the minute-to-minute increase percentage
        # *   PREVIOUS_DOWN: the minute-to-minute decrease percentage
        # *   HOH_UP: the increase percentage compared with the previous hour
        # *   HOH_DOWN: the decrease percentage compared with the previous hour
        # *   DOD_UP: the increase percentage compared with the last day
        # *   DOD_DOWN: the decrease percentage compared with the last day
        self.operator = operator  # type: str
        # The threshold of the alert condition.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateAlertRuleResponseBodyAlertRuleAlertRuleContentAlertRuleItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregate is not None:
            result['Aggregate'] = self.aggregate
        if self.metric_key is not None:
            result['MetricKey'] = self.metric_key
        if self.n is not None:
            result['N'] = self.n
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Aggregate') is not None:
            self.aggregate = m.get('Aggregate')
        if m.get('MetricKey') is not None:
            self.metric_key = m.get('MetricKey')
        if m.get('N') is not None:
            self.n = m.get('N')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateOrUpdateAlertRuleResponseBodyAlertRuleAlertRuleContent(TeaModel):
    def __init__(self, alert_rule_items=None, condition=None):
        # The trigger conditions of the Application Monitoring or Browser Monitoring alert rule.
        self.alert_rule_items = alert_rule_items  # type: list[CreateOrUpdateAlertRuleResponseBodyAlertRuleAlertRuleContentAlertRuleItems]
        # The relationship between multiple alert conditions specified for the Application Monitoring or Browser Monitoring alert rule.
        # 
        # *   OR: meets any of the specified conditions.
        # *   AND: meets all the specified conditions.
        self.condition = condition  # type: str

    def validate(self):
        if self.alert_rule_items:
            for k in self.alert_rule_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateOrUpdateAlertRuleResponseBodyAlertRuleAlertRuleContent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertRuleItems'] = []
        if self.alert_rule_items is not None:
            for k in self.alert_rule_items:
                result['AlertRuleItems'].append(k.to_map() if k else None)
        if self.condition is not None:
            result['Condition'] = self.condition
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.alert_rule_items = []
        if m.get('AlertRuleItems') is not None:
            for k in m.get('AlertRuleItems'):
                temp_model = CreateOrUpdateAlertRuleResponseBodyAlertRuleAlertRuleContentAlertRuleItems()
                self.alert_rule_items.append(temp_model.from_map(k))
        if m.get('Condition') is not None:
            self.condition = m.get('Condition')
        return self


class CreateOrUpdateAlertRuleResponseBodyAlertRuleAnnotations(TeaModel):
    def __init__(self, name=None, value=None):
        # The key of the annotation.
        self.name = name  # type: str
        # The value of the annotation.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateAlertRuleResponseBodyAlertRuleAnnotations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateOrUpdateAlertRuleResponseBodyAlertRuleFiltersCustomSLSFilters(TeaModel):
    def __init__(self, key=None, opt=None, show=None, t=None, value=None):
        # The key of the filter condition.
        self.key = key  # type: str
        # The logical operator of the filter condition. 
        # 
        # - =: equal to
        # - not: not equal to
        self.opt = opt  # type: str
        # Indicates whether this filter condition is displayed on the frontend.
        self.show = show  # type: bool
        # This field is used only to distinguish the type of Browser Monitoring logs. Other filter conditions do not include this field.
        self.t = t  # type: str
        # The value of the filter condition.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateAlertRuleResponseBodyAlertRuleFiltersCustomSLSFilters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.opt is not None:
            result['Opt'] = self.opt
        if self.show is not None:
            result['Show'] = self.show
        if self.t is not None:
            result['T'] = self.t
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Opt') is not None:
            self.opt = m.get('Opt')
        if m.get('Show') is not None:
            self.show = m.get('Show')
        if m.get('T') is not None:
            self.t = m.get('T')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateOrUpdateAlertRuleResponseBodyAlertRuleFiltersDimFilters(TeaModel):
    def __init__(self, filter_key=None, filter_opt=None, filter_values=None):
        # The key of the filter condition.
        self.filter_key = filter_key  # type: str
        # The logical operator of the filter condition.
        self.filter_opt = filter_opt  # type: str
        # The value of the filter condition.
        self.filter_values = filter_values  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateAlertRuleResponseBodyAlertRuleFiltersDimFilters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.filter_key is not None:
            result['FilterKey'] = self.filter_key
        if self.filter_opt is not None:
            result['FilterOpt'] = self.filter_opt
        if self.filter_values is not None:
            result['FilterValues'] = self.filter_values
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FilterKey') is not None:
            self.filter_key = m.get('FilterKey')
        if m.get('FilterOpt') is not None:
            self.filter_opt = m.get('FilterOpt')
        if m.get('FilterValues') is not None:
            self.filter_values = m.get('FilterValues')
        return self


class CreateOrUpdateAlertRuleResponseBodyAlertRuleFilters(TeaModel):
    def __init__(self, custom_slsfilters=None, custom_slsgroup_by_dimensions=None, custom_slswheres=None,
                 dim_filters=None):
        # The custom filter condition of the Browser Monitoring alert rule.
        self.custom_slsfilters = custom_slsfilters  # type: list[CreateOrUpdateAlertRuleResponseBodyAlertRuleFiltersCustomSLSFilters]
        # The value of the aggregation dimension.
        self.custom_slsgroup_by_dimensions = custom_slsgroup_by_dimensions  # type: list[str]
        # The value of the custom filter condition.
        self.custom_slswheres = custom_slswheres  # type: list[str]
        # The information about each filter condition of the Application Monitoring or Browser Monitoring alert rule.
        self.dim_filters = dim_filters  # type: list[CreateOrUpdateAlertRuleResponseBodyAlertRuleFiltersDimFilters]

    def validate(self):
        if self.custom_slsfilters:
            for k in self.custom_slsfilters:
                if k:
                    k.validate()
        if self.dim_filters:
            for k in self.dim_filters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateOrUpdateAlertRuleResponseBodyAlertRuleFilters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CustomSLSFilters'] = []
        if self.custom_slsfilters is not None:
            for k in self.custom_slsfilters:
                result['CustomSLSFilters'].append(k.to_map() if k else None)
        if self.custom_slsgroup_by_dimensions is not None:
            result['CustomSLSGroupByDimensions'] = self.custom_slsgroup_by_dimensions
        if self.custom_slswheres is not None:
            result['CustomSLSWheres'] = self.custom_slswheres
        result['DimFilters'] = []
        if self.dim_filters is not None:
            for k in self.dim_filters:
                result['DimFilters'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.custom_slsfilters = []
        if m.get('CustomSLSFilters') is not None:
            for k in m.get('CustomSLSFilters'):
                temp_model = CreateOrUpdateAlertRuleResponseBodyAlertRuleFiltersCustomSLSFilters()
                self.custom_slsfilters.append(temp_model.from_map(k))
        if m.get('CustomSLSGroupByDimensions') is not None:
            self.custom_slsgroup_by_dimensions = m.get('CustomSLSGroupByDimensions')
        if m.get('CustomSLSWheres') is not None:
            self.custom_slswheres = m.get('CustomSLSWheres')
        self.dim_filters = []
        if m.get('DimFilters') is not None:
            for k in m.get('DimFilters'):
                temp_model = CreateOrUpdateAlertRuleResponseBodyAlertRuleFiltersDimFilters()
                self.dim_filters.append(temp_model.from_map(k))
        return self


class CreateOrUpdateAlertRuleResponseBodyAlertRuleLabels(TeaModel):
    def __init__(self, name=None, value=None):
        # The key of the tag.
        self.name = name  # type: str
        # The value of the tag.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateAlertRuleResponseBodyAlertRuleLabels, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateOrUpdateAlertRuleResponseBodyAlertRule(TeaModel):
    def __init__(self, alert_check_type=None, alert_group=None, alert_id=None, alert_name=None,
                 alert_rule_content=None, alert_status=None, alert_type=None, annotations=None, auto_add_new_application=None,
                 cluster_id=None, created_time=None, duration=None, extend=None, filters=None, labels=None, level=None,
                 message=None, metrics_type=None, notify_strategy=None, pids=None, prom_ql=None, region_id=None,
                 updated_time=None, user_id=None):
        # The alert check type of the Prometheus alert rule. 
        # 
        # - STATIC: a static threshold value.
        # - CUSTOM: a custom PromQL statement.
        self.alert_check_type = alert_check_type  # type: str
        # The alert contact group ID of the Prometheus alert rule. 
        # 
        # - -1: custom PromQL
        # - 1: Kubernetes load
        # - 15: Kubernetes node
        self.alert_group = alert_group  # type: long
        # The ID of the alert rule.
        self.alert_id = alert_id  # type: float
        # The name of the alert rule.
        self.alert_name = alert_name  # type: str
        # The content of the Application Monitoring or Browser Monitoring alert rule.
        self.alert_rule_content = alert_rule_content  # type: CreateOrUpdateAlertRuleResponseBodyAlertRuleAlertRuleContent
        # The status of the alert rule.
        # 
        # *   RUNNING
        # *   STOPPED
        # *   PAUSED
        # 
        # >  The **PAUSED** status indicates that the alert rule is abnormal and is actively paused by the system. The alert rule may be paused because that it is not unique or the associated cluster has been deleted.
        self.alert_status = alert_status  # type: str
        # The type of the alert rule. Valid values:
        # 
        # *   APPLICATION_MONITORING_ALERT_RULE: alert rule for Application Monitoring
        # *   BROWSER_MONITORING_ALERT_RULE: alert rule for Browser Monitoring
        # *   PROMETHEUS_MONITORING_ALERT_RULE: alert rule for Prometheus Service
        self.alert_type = alert_type  # type: str
        # The annotations of the Prometheus alert rule.
        self.annotations = annotations  # type: list[CreateOrUpdateAlertRuleResponseBodyAlertRuleAnnotations]
        # Indicates whether the alert rule is applied to new applications that are created in Application Monitoring or Browser Monitoring.
        # 
        # *   `true`: yes
        # *   `false`: no
        self.auto_add_new_application = auto_add_new_application  # type: bool
        # The cluster ID of the Prometheus alert rule.
        self.cluster_id = cluster_id  # type: str
        # The time when the alert rule was created.
        self.created_time = created_time  # type: long
        # The duration of the Prometheus alert rule. Unit: minutes.
        self.duration = duration  # type: str
        # The extended field.
        self.extend = extend  # type: str
        # The filter conditions of the Application Monitoring or Browser Monitoring alert rule.
        self.filters = filters  # type: CreateOrUpdateAlertRuleResponseBodyAlertRuleFilters
        # The tags of the Prometheus alert rule.
        self.labels = labels  # type: list[CreateOrUpdateAlertRuleResponseBodyAlertRuleLabels]
        # The level of the Prometheus alert rule. 
        # 
        # - P1: Alert notifications are sent for major issues that affect the availability of core business, have huge impact, and may lead to serious consequences.
        # - P2: Alert notifications are sent for service errors that affect the system availability with relatively limited impact.
        # - P3: Alert notifications are sent for issues that may cause service errors or negative effects, or alert notifications for services that are relatively less important.
        # - P4: Alert notifications are sent for low-priority issues that do not affect your business.
        # - Default: Alert notifications are sent without distinguishing between alert levels.
        self.level = level  # type: str
        # The alert message of the Prometheus alert rule.
        self.message = message  # type: str
        # The metric type of the Application Monitoring or Browser Monitoring alert rule.
        self.metrics_type = metrics_type  # type: str
        # The name of the notification policy.
        self.notify_strategy = notify_strategy  # type: str
        # The PID of the application.
        self.pids = pids  # type: list[str]
        # The PromQL statement of the Prometheus alert rule.
        self.prom_ql = prom_ql  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The time when the alert rule was updated.
        self.updated_time = updated_time  # type: long
        # The ID of the Alibaba Cloud account.
        self.user_id = user_id  # type: str

    def validate(self):
        if self.alert_rule_content:
            self.alert_rule_content.validate()
        if self.annotations:
            for k in self.annotations:
                if k:
                    k.validate()
        if self.filters:
            self.filters.validate()
        if self.labels:
            for k in self.labels:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateOrUpdateAlertRuleResponseBodyAlertRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_check_type is not None:
            result['AlertCheckType'] = self.alert_check_type
        if self.alert_group is not None:
            result['AlertGroup'] = self.alert_group
        if self.alert_id is not None:
            result['AlertId'] = self.alert_id
        if self.alert_name is not None:
            result['AlertName'] = self.alert_name
        if self.alert_rule_content is not None:
            result['AlertRuleContent'] = self.alert_rule_content.to_map()
        if self.alert_status is not None:
            result['AlertStatus'] = self.alert_status
        if self.alert_type is not None:
            result['AlertType'] = self.alert_type
        result['Annotations'] = []
        if self.annotations is not None:
            for k in self.annotations:
                result['Annotations'].append(k.to_map() if k else None)
        if self.auto_add_new_application is not None:
            result['AutoAddNewApplication'] = self.auto_add_new_application
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.extend is not None:
            result['Extend'] = self.extend
        if self.filters is not None:
            result['Filters'] = self.filters.to_map()
        result['Labels'] = []
        if self.labels is not None:
            for k in self.labels:
                result['Labels'].append(k.to_map() if k else None)
        if self.level is not None:
            result['Level'] = self.level
        if self.message is not None:
            result['Message'] = self.message
        if self.metrics_type is not None:
            result['MetricsType'] = self.metrics_type
        if self.notify_strategy is not None:
            result['NotifyStrategy'] = self.notify_strategy
        if self.pids is not None:
            result['Pids'] = self.pids
        if self.prom_ql is not None:
            result['PromQL'] = self.prom_ql
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.updated_time is not None:
            result['UpdatedTime'] = self.updated_time
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertCheckType') is not None:
            self.alert_check_type = m.get('AlertCheckType')
        if m.get('AlertGroup') is not None:
            self.alert_group = m.get('AlertGroup')
        if m.get('AlertId') is not None:
            self.alert_id = m.get('AlertId')
        if m.get('AlertName') is not None:
            self.alert_name = m.get('AlertName')
        if m.get('AlertRuleContent') is not None:
            temp_model = CreateOrUpdateAlertRuleResponseBodyAlertRuleAlertRuleContent()
            self.alert_rule_content = temp_model.from_map(m['AlertRuleContent'])
        if m.get('AlertStatus') is not None:
            self.alert_status = m.get('AlertStatus')
        if m.get('AlertType') is not None:
            self.alert_type = m.get('AlertType')
        self.annotations = []
        if m.get('Annotations') is not None:
            for k in m.get('Annotations'):
                temp_model = CreateOrUpdateAlertRuleResponseBodyAlertRuleAnnotations()
                self.annotations.append(temp_model.from_map(k))
        if m.get('AutoAddNewApplication') is not None:
            self.auto_add_new_application = m.get('AutoAddNewApplication')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Extend') is not None:
            self.extend = m.get('Extend')
        if m.get('Filters') is not None:
            temp_model = CreateOrUpdateAlertRuleResponseBodyAlertRuleFilters()
            self.filters = temp_model.from_map(m['Filters'])
        self.labels = []
        if m.get('Labels') is not None:
            for k in m.get('Labels'):
                temp_model = CreateOrUpdateAlertRuleResponseBodyAlertRuleLabels()
                self.labels.append(temp_model.from_map(k))
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MetricsType') is not None:
            self.metrics_type = m.get('MetricsType')
        if m.get('NotifyStrategy') is not None:
            self.notify_strategy = m.get('NotifyStrategy')
        if m.get('Pids') is not None:
            self.pids = m.get('Pids')
        if m.get('PromQL') is not None:
            self.prom_ql = m.get('PromQL')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('UpdatedTime') is not None:
            self.updated_time = m.get('UpdatedTime')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class CreateOrUpdateAlertRuleResponseBody(TeaModel):
    def __init__(self, alert_rule=None, request_id=None):
        # The object of the alert rule.
        self.alert_rule = alert_rule  # type: CreateOrUpdateAlertRuleResponseBodyAlertRule
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.alert_rule:
            self.alert_rule.validate()

    def to_map(self):
        _map = super(CreateOrUpdateAlertRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_rule is not None:
            result['AlertRule'] = self.alert_rule.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertRule') is not None:
            temp_model = CreateOrUpdateAlertRuleResponseBodyAlertRule()
            self.alert_rule = temp_model.from_map(m['AlertRule'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateOrUpdateAlertRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateOrUpdateAlertRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateOrUpdateAlertRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOrUpdateAlertRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOrUpdateContactRequest(TeaModel):
    def __init__(self, contact_id=None, contact_name=None, ding_robot_url=None, email=None, is_email_verify=None,
                 phone=None, reissue_send_notice=None, resource_group_id=None):
        # The ID of the alert contact.
        # 
        # *   If you do not specify this parameter, a new alert contact is created.
        # *   If you specify this parameter, the specified alert contact is modified.
        self.contact_id = contact_id  # type: long
        # The name of the alert contact.
        self.contact_name = contact_name  # type: str
        # The webhook URL of the DingTalk chatbot.
        self.ding_robot_url = ding_robot_url  # type: str
        # The email address of the alert contact.
        # 
        # > You must specify at least one of the **Phone** and **Email** parameters. Each mobile number or email address can be used for only one alert contact.
        self.email = email  # type: str
        # Specifies whether the email address is verified.
        self.is_email_verify = is_email_verify  # type: bool
        # The mobile number of the alert contact.
        # 
        # > You must specify at least one of the **Phone** and **Email** parameters. Each mobile number or email address can be used for only one alert contact.
        self.phone = phone  # type: str
        # The operation that you want to perform if phone calls fail to be answered. Valid values:
        # 
        # *   0: No operation is performed.
        # *   1: A phone call is made again.
        # *   2: A text message is sent.
        # *   3 (default value): The global default value is used.
        self.reissue_send_notice = reissue_send_notice  # type: long
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateContactRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.contact_name is not None:
            result['ContactName'] = self.contact_name
        if self.ding_robot_url is not None:
            result['DingRobotUrl'] = self.ding_robot_url
        if self.email is not None:
            result['Email'] = self.email
        if self.is_email_verify is not None:
            result['IsEmailVerify'] = self.is_email_verify
        if self.phone is not None:
            result['Phone'] = self.phone
        if self.reissue_send_notice is not None:
            result['ReissueSendNotice'] = self.reissue_send_notice
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('ContactName') is not None:
            self.contact_name = m.get('ContactName')
        if m.get('DingRobotUrl') is not None:
            self.ding_robot_url = m.get('DingRobotUrl')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('IsEmailVerify') is not None:
            self.is_email_verify = m.get('IsEmailVerify')
        if m.get('Phone') is not None:
            self.phone = m.get('Phone')
        if m.get('ReissueSendNotice') is not None:
            self.reissue_send_notice = m.get('ReissueSendNotice')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class CreateOrUpdateContactResponseBodyAlertContact(TeaModel):
    def __init__(self, contact_id=None, contact_name=None, ding_robot_url=None, email=None, is_verify=None,
                 phone=None, reissue_send_notice=None, is_email_verify=None):
        # The ID of the alert contact.
        self.contact_id = contact_id  # type: float
        # The name of the alert contact.
        self.contact_name = contact_name  # type: str
        # The webhook URL of the DingTalk chatbot.
        self.ding_robot_url = ding_robot_url  # type: str
        # The email address of the alert contact.
        self.email = email  # type: str
        # Indicates whether the mobile number was verified. Valid values:
        # 
        # *   `false` (default value): No
        # *   `true`: Yes
        # 
        # You can call the **SendTTSVerifyLink** operation to verify the mobile number of an alert contact. Only verified mobile numbers can be specified in a notification policy to receive phone calls.
        self.is_verify = is_verify  # type: bool
        # The mobile number of the alert contact.
        self.phone = phone  # type: str
        # The operation that you want to perform if phone calls fail to be answered. Valid values: 0: No operation is performed. 1: A phone call is made again. 2: A text message is sent. 3 (default value): The global default value is used.
        self.reissue_send_notice = reissue_send_notice  # type: long
        # Indicates whether the email address was verified.
        self.is_email_verify = is_email_verify  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateContactResponseBodyAlertContact, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.contact_name is not None:
            result['ContactName'] = self.contact_name
        if self.ding_robot_url is not None:
            result['DingRobotUrl'] = self.ding_robot_url
        if self.email is not None:
            result['Email'] = self.email
        if self.is_verify is not None:
            result['IsVerify'] = self.is_verify
        if self.phone is not None:
            result['Phone'] = self.phone
        if self.reissue_send_notice is not None:
            result['ReissueSendNotice'] = self.reissue_send_notice
        if self.is_email_verify is not None:
            result['isEmailVerify'] = self.is_email_verify
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('ContactName') is not None:
            self.contact_name = m.get('ContactName')
        if m.get('DingRobotUrl') is not None:
            self.ding_robot_url = m.get('DingRobotUrl')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('IsVerify') is not None:
            self.is_verify = m.get('IsVerify')
        if m.get('Phone') is not None:
            self.phone = m.get('Phone')
        if m.get('ReissueSendNotice') is not None:
            self.reissue_send_notice = m.get('ReissueSendNotice')
        if m.get('isEmailVerify') is not None:
            self.is_email_verify = m.get('isEmailVerify')
        return self


class CreateOrUpdateContactResponseBody(TeaModel):
    def __init__(self, alert_contact=None, request_id=None):
        # The object of the alert contact.
        self.alert_contact = alert_contact  # type: CreateOrUpdateContactResponseBodyAlertContact
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.alert_contact:
            self.alert_contact.validate()

    def to_map(self):
        _map = super(CreateOrUpdateContactResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_contact is not None:
            result['AlertContact'] = self.alert_contact.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertContact') is not None:
            temp_model = CreateOrUpdateContactResponseBodyAlertContact()
            self.alert_contact = temp_model.from_map(m['AlertContact'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateOrUpdateContactResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateOrUpdateContactResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateOrUpdateContactResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOrUpdateContactResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOrUpdateContactGroupRequest(TeaModel):
    def __init__(self, contact_group_id=None, contact_group_name=None, contact_ids=None):
        # The ID of the alert contact group.
        # 
        # *   If you do not specify this parameter, an alert contact group is created.
        # *   If you specify this parameter, the specified alert contact group is modified.
        self.contact_group_id = contact_group_id  # type: long
        # The name of the alert contact group.
        self.contact_group_name = contact_group_name  # type: str
        # The ID of the contact that you want to add to the contact group. Separate multiple IDs with commas (,).
        self.contact_ids = contact_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateContactGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_id is not None:
            result['ContactGroupId'] = self.contact_group_id
        if self.contact_group_name is not None:
            result['ContactGroupName'] = self.contact_group_name
        if self.contact_ids is not None:
            result['ContactIds'] = self.contact_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactGroupId') is not None:
            self.contact_group_id = m.get('ContactGroupId')
        if m.get('ContactGroupName') is not None:
            self.contact_group_name = m.get('ContactGroupName')
        if m.get('ContactIds') is not None:
            self.contact_ids = m.get('ContactIds')
        return self


class CreateOrUpdateContactGroupResponseBodyAlertContactGroup(TeaModel):
    def __init__(self, contact_group_id=None, contact_group_name=None, contact_ids=None):
        # The ID of the alert contact group.
        self.contact_group_id = contact_group_id  # type: float
        # The name of the alert contact group.
        self.contact_group_name = contact_group_name  # type: str
        # The IDs of the contacts that are included in the alert contact group.
        self.contact_ids = contact_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateContactGroupResponseBodyAlertContactGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_id is not None:
            result['ContactGroupId'] = self.contact_group_id
        if self.contact_group_name is not None:
            result['ContactGroupName'] = self.contact_group_name
        if self.contact_ids is not None:
            result['ContactIds'] = self.contact_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactGroupId') is not None:
            self.contact_group_id = m.get('ContactGroupId')
        if m.get('ContactGroupName') is not None:
            self.contact_group_name = m.get('ContactGroupName')
        if m.get('ContactIds') is not None:
            self.contact_ids = m.get('ContactIds')
        return self


class CreateOrUpdateContactGroupResponseBody(TeaModel):
    def __init__(self, alert_contact_group=None, request_id=None):
        # The object.
        self.alert_contact_group = alert_contact_group  # type: CreateOrUpdateContactGroupResponseBodyAlertContactGroup
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.alert_contact_group:
            self.alert_contact_group.validate()

    def to_map(self):
        _map = super(CreateOrUpdateContactGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_contact_group is not None:
            result['AlertContactGroup'] = self.alert_contact_group.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertContactGroup') is not None:
            temp_model = CreateOrUpdateContactGroupResponseBodyAlertContactGroup()
            self.alert_contact_group = temp_model.from_map(m['AlertContactGroup'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateOrUpdateContactGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateOrUpdateContactGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateOrUpdateContactGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOrUpdateContactGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOrUpdateEventBridgeIntegrationRequest(TeaModel):
    def __init__(self, access_key=None, access_secret=None, description=None, endpoint=None, event_bus_name=None,
                 event_bus_region_id=None, id=None, name=None, source=None):
        # The AccessKey ID that is used to connect to EventBridge.
        self.access_key = access_key  # type: str
        # The AccessKey secret that is used to connect to EventBridge.
        self.access_secret = access_secret  # type: str
        # The description of the EventBridge integration.
        self.description = description  # type: str
        # The public endpoint of EventBridge.
        self.endpoint = endpoint  # type: str
        # The name of the event bus.
        self.event_bus_name = event_bus_name  # type: str
        # The region ID of the event bus.
        self.event_bus_region_id = event_bus_region_id  # type: str
        # The ID of the EventBridge integration.
        # 
        # *   If you do not specify this parameter, an EventBridge integration is created.
        # *   If you specify this parameter, the specified EventBridge integration is modified.
        self.id = id  # type: long
        # The name of the EventBridge integration.
        self.name = name  # type: str
        # The event source.
        self.source = source  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateEventBridgeIntegrationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_key is not None:
            result['AccessKey'] = self.access_key
        if self.access_secret is not None:
            result['AccessSecret'] = self.access_secret
        if self.description is not None:
            result['Description'] = self.description
        if self.endpoint is not None:
            result['Endpoint'] = self.endpoint
        if self.event_bus_name is not None:
            result['EventBusName'] = self.event_bus_name
        if self.event_bus_region_id is not None:
            result['EventBusRegionId'] = self.event_bus_region_id
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.source is not None:
            result['Source'] = self.source
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccessKey') is not None:
            self.access_key = m.get('AccessKey')
        if m.get('AccessSecret') is not None:
            self.access_secret = m.get('AccessSecret')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Endpoint') is not None:
            self.endpoint = m.get('Endpoint')
        if m.get('EventBusName') is not None:
            self.event_bus_name = m.get('EventBusName')
        if m.get('EventBusRegionId') is not None:
            self.event_bus_region_id = m.get('EventBusRegionId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        return self


class CreateOrUpdateEventBridgeIntegrationResponseBodyEventBridgeIntegration(TeaModel):
    def __init__(self, access_key=None, access_secret=None, description=None, endpoint=None, event_bus_name=None,
                 event_bus_region_id=None, id=None, name=None, source=None):
        # The AccessKey ID that is used to connect to EventBridge.
        self.access_key = access_key  # type: str
        # The AccessKey secret that is used to connect to EventBridge.
        self.access_secret = access_secret  # type: str
        # The description of the EventBridge integration.
        self.description = description  # type: str
        # The public endpoint of EventBridge.
        self.endpoint = endpoint  # type: str
        # The name of the event bus.
        self.event_bus_name = event_bus_name  # type: str
        # The region ID of the event bus.
        self.event_bus_region_id = event_bus_region_id  # type: str
        # The ID of the EventBridge integration.
        self.id = id  # type: long
        # The name of the EventBridge integration.
        self.name = name  # type: str
        # The event source.
        self.source = source  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateEventBridgeIntegrationResponseBodyEventBridgeIntegration, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_key is not None:
            result['AccessKey'] = self.access_key
        if self.access_secret is not None:
            result['AccessSecret'] = self.access_secret
        if self.description is not None:
            result['Description'] = self.description
        if self.endpoint is not None:
            result['Endpoint'] = self.endpoint
        if self.event_bus_name is not None:
            result['EventBusName'] = self.event_bus_name
        if self.event_bus_region_id is not None:
            result['EventBusRegionId'] = self.event_bus_region_id
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.source is not None:
            result['Source'] = self.source
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccessKey') is not None:
            self.access_key = m.get('AccessKey')
        if m.get('AccessSecret') is not None:
            self.access_secret = m.get('AccessSecret')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Endpoint') is not None:
            self.endpoint = m.get('Endpoint')
        if m.get('EventBusName') is not None:
            self.event_bus_name = m.get('EventBusName')
        if m.get('EventBusRegionId') is not None:
            self.event_bus_region_id = m.get('EventBusRegionId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        return self


class CreateOrUpdateEventBridgeIntegrationResponseBody(TeaModel):
    def __init__(self, event_bridge_integration=None, request_id=None):
        # The information about the EventBridge integration.
        self.event_bridge_integration = event_bridge_integration  # type: CreateOrUpdateEventBridgeIntegrationResponseBodyEventBridgeIntegration
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.event_bridge_integration:
            self.event_bridge_integration.validate()

    def to_map(self):
        _map = super(CreateOrUpdateEventBridgeIntegrationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_bridge_integration is not None:
            result['EventBridgeIntegration'] = self.event_bridge_integration.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EventBridgeIntegration') is not None:
            temp_model = CreateOrUpdateEventBridgeIntegrationResponseBodyEventBridgeIntegration()
            self.event_bridge_integration = temp_model.from_map(m['EventBridgeIntegration'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateOrUpdateEventBridgeIntegrationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateOrUpdateEventBridgeIntegrationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateOrUpdateEventBridgeIntegrationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOrUpdateEventBridgeIntegrationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOrUpdateIMRobotRequest(TeaModel):
    def __init__(self, card_template=None, daily_noc=None, daily_noc_time=None, ding_sign_key=None,
                 enable_outgoing=None, robot_address=None, robot_id=None, robot_name=None, token=None, type=None):
        # The configurations of the alert card template.
        self.card_template = card_template  # type: str
        # Specifies whether to send daily statistics.
        # 
        # *   `false` (default): does not send statistics.
        # *   `true`: sends statistics. After you select `true`, **DailyNocTime** parameters are required.
        self.daily_noc = daily_noc  # type: bool
        # The time point at which the daily statistics are sent. Separate multiple sending time points with commas (,). The time point is in the HH:SS format. ARMS Alert Management sends the total number of alerts generated today, the number of resolved alerts, and the number of pending alerts at the specified time point.
        self.daily_noc_time = daily_noc_time  # type: str
        # The signature key of DingTalk. If you specify a signature key, DingTalk authentication is performed with the key. Otherwise, a whitelist is used for authentication by default. The keyword of the whitelist is** Alert**.
        self.ding_sign_key = ding_sign_key  # type: str
        # Specifies whether to enable the Outgoing feature.
        self.enable_outgoing = enable_outgoing  # type: bool
        # The webhook address of the IM bot.
        self.robot_address = robot_address  # type: str
        # The ID of the IM bot.
        # 
        # *   If you do not specify this parameter, a new IM bot is created.
        # *   Enter information that represents modifying the specified IM bot.
        self.robot_id = robot_id  # type: long
        # The name of the IM robot.
        self.robot_name = robot_name  # type: str
        # The token required to enable the Outgoing feature.
        self.token = token  # type: str
        # IM Robot Type:
        # 
        # *   `dingding`: DingTalk robot.
        # *   `wechat`: Enterprise WeChat Robot.
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateIMRobotRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.card_template is not None:
            result['CardTemplate'] = self.card_template
        if self.daily_noc is not None:
            result['DailyNoc'] = self.daily_noc
        if self.daily_noc_time is not None:
            result['DailyNocTime'] = self.daily_noc_time
        if self.ding_sign_key is not None:
            result['DingSignKey'] = self.ding_sign_key
        if self.enable_outgoing is not None:
            result['EnableOutgoing'] = self.enable_outgoing
        if self.robot_address is not None:
            result['RobotAddress'] = self.robot_address
        if self.robot_id is not None:
            result['RobotId'] = self.robot_id
        if self.robot_name is not None:
            result['RobotName'] = self.robot_name
        if self.token is not None:
            result['Token'] = self.token
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CardTemplate') is not None:
            self.card_template = m.get('CardTemplate')
        if m.get('DailyNoc') is not None:
            self.daily_noc = m.get('DailyNoc')
        if m.get('DailyNocTime') is not None:
            self.daily_noc_time = m.get('DailyNocTime')
        if m.get('DingSignKey') is not None:
            self.ding_sign_key = m.get('DingSignKey')
        if m.get('EnableOutgoing') is not None:
            self.enable_outgoing = m.get('EnableOutgoing')
        if m.get('RobotAddress') is not None:
            self.robot_address = m.get('RobotAddress')
        if m.get('RobotId') is not None:
            self.robot_id = m.get('RobotId')
        if m.get('RobotName') is not None:
            self.robot_name = m.get('RobotName')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateOrUpdateIMRobotResponseBodyAlertRobot(TeaModel):
    def __init__(self, card_template=None, daily_noc=None, daily_noc_time=None, enable_outgoing=None,
                 robot_address=None, robot_id=None, robot_name=None, token=None, type=None):
        # The configurations of the alert card template.
        self.card_template = card_template  # type: str
        # Specifies whether to send daily statistics.
        # 
        # *   `false` (default): does not send statistics.
        # *   `true`: sends statistics.
        self.daily_noc = daily_noc  # type: bool
        # The time when the daily statistics are sent. ARMS Alert Management sends the total number of alerts generated today, the number of resolved alerts, and the number of pending alerts at the specified time point.
        self.daily_noc_time = daily_noc_time  # type: str
        # Indicates whether the Outgoing feature is enabled.
        self.enable_outgoing = enable_outgoing  # type: bool
        # The webhook address of the IM bot.
        self.robot_address = robot_address  # type: str
        # The ID of the IM bot.
        self.robot_id = robot_id  # type: float
        # The name of the IM robot.
        self.robot_name = robot_name  # type: str
        # The token required to enable the Outgoing feature.
        self.token = token  # type: str
        # IM Robot Type:
        # 
        # *   `dingding`: DingTalk robot.
        # *   `wechat`: Enterprise WeChat Robot.
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateIMRobotResponseBodyAlertRobot, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.card_template is not None:
            result['CardTemplate'] = self.card_template
        if self.daily_noc is not None:
            result['DailyNoc'] = self.daily_noc
        if self.daily_noc_time is not None:
            result['DailyNocTime'] = self.daily_noc_time
        if self.enable_outgoing is not None:
            result['EnableOutgoing'] = self.enable_outgoing
        if self.robot_address is not None:
            result['RobotAddress'] = self.robot_address
        if self.robot_id is not None:
            result['RobotId'] = self.robot_id
        if self.robot_name is not None:
            result['RobotName'] = self.robot_name
        if self.token is not None:
            result['Token'] = self.token
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CardTemplate') is not None:
            self.card_template = m.get('CardTemplate')
        if m.get('DailyNoc') is not None:
            self.daily_noc = m.get('DailyNoc')
        if m.get('DailyNocTime') is not None:
            self.daily_noc_time = m.get('DailyNocTime')
        if m.get('EnableOutgoing') is not None:
            self.enable_outgoing = m.get('EnableOutgoing')
        if m.get('RobotAddress') is not None:
            self.robot_address = m.get('RobotAddress')
        if m.get('RobotId') is not None:
            self.robot_id = m.get('RobotId')
        if m.get('RobotName') is not None:
            self.robot_name = m.get('RobotName')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateOrUpdateIMRobotResponseBody(TeaModel):
    def __init__(self, alert_robot=None, request_id=None):
        # Returns an AlertRobot object.
        self.alert_robot = alert_robot  # type: CreateOrUpdateIMRobotResponseBodyAlertRobot
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.alert_robot:
            self.alert_robot.validate()

    def to_map(self):
        _map = super(CreateOrUpdateIMRobotResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_robot is not None:
            result['AlertRobot'] = self.alert_robot.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertRobot') is not None:
            temp_model = CreateOrUpdateIMRobotResponseBodyAlertRobot()
            self.alert_robot = temp_model.from_map(m['AlertRobot'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateOrUpdateIMRobotResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateOrUpdateIMRobotResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateOrUpdateIMRobotResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOrUpdateIMRobotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOrUpdateNotificationPolicyRequest(TeaModel):
    def __init__(self, escalation_policy_id=None, group_rule=None, id=None, integration_id=None,
                 matching_rules=None, name=None, notify_rule=None, notify_template=None, region_id=None, repeat=None,
                 repeat_interval=None, send_recover_message=None):
        # The ID of the escalation policy.
        self.escalation_policy_id = escalation_policy_id  # type: long
        # An array of alert event group objects.
        # 
        # *   If you do not specify the groupingFields field, all alerts will be sent to contacts based on `alertname`.
        # 
        # *   If you specify the groupingFields field, alerts with the same field will be sent to contacts in one notification.
        # 
        #     Sample statement:
        # 
        # ```
        # 
        # { 
        # "groupWait":5,    // The waiting time for grouping. 
        # "groupInterval":30,     // The time interval of grouping. 
        # "groupingFields":["alertname"]       // The field that is used to group alert events. 
        # }
        # ```
        self.group_rule = group_rule  # type: str
        # The ID of the notification policy.
        # 
        # *   If you do not specify this parameter, a new notification policy is created.
        # *   If you specify this parameter, the specified notification policy is modified.
        self.id = id  # type: long
        # The integration ID of the ticket system to which alerts are pushed.
        self.integration_id = integration_id  # type: long
        # The matching rules. Sample statement:
        # 
        # ```
        # 
        # [
        #  {
        #  "matchingConditions": [
        #  { 
        #  "value": "test",    // The value of the matching condition. 
        #  "key": "alertname",     // The key of the matching condition. 
        #  "operator": "eq"   // The logical operator of the matching condition, including eq (equal to), neq (not equal to), in (contains), nin (does not contain), re (regular expression match), and nre (regular expression mismatch).   
        #  }
        #  ]
        #  } 
        #  ]
        # ```
        self.matching_rules = matching_rules  # type: str
        # The name of the notification policy.
        self.name = name  # type: str
        # An array of notification rule objects. Sample statement:
        # 
        # ```
        # 
        # { 
        #  "notifyStartTime":"00:00",      // The start time of the notification window. 
        #  "notifyEndTime":"23:59",       // The end time of the notification window. 
        #  "notifyChannels":["dingTalk", "email", "sms", "tts", "webhook"],       // The notification methods. Valid values: dingTalk, email, sms, tts, and webhook. 
        #  "notifyObjects":[{       // An array of notification contact objects. 
        #  "notifyObjectType":"CONTACT",       // The type of the notification contact. Valid values: CONTACT (individual contacts), CONTACT_GROUP (contact groups), DING_ROBOT (the instant message robot), and CONTACT_SCHEDULE (the person on duty based on an established schedule). 
        #  "notifyObjectId":123,       // The ID of the notification contact. 
        #  "notifyObjectName":"test"       // The name of the notification contact. 
        #  }]
        # ```
        self.notify_rule = notify_rule  # type: str
        # The notification template. The default notification template is provided below the table.
        self.notify_template = notify_template  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str
        # Specifies whether to resend a notification for a long-lasting unresolved alert. Default value: true. Valid values:
        # 
        # *   `true`: If you set this parameter to `true`, you must set **RepeatInterval**.
        # *   `false`: If you set this parameter to `false`, you must set **EscalationPolicyId**.
        self.repeat = repeat  # type: bool
        # The time interval at which a notification is resent for a long-lasting unresolved alert. Unit: seconds.
        self.repeat_interval = repeat_interval  # type: long
        # Indicates whether the system sends a notification to the contacts when the status of an alert changes to Resolved. Default value: true. Valid values:
        # 
        # *   `true`: The system sends a notification.
        # *   `false`: The system does not send a notification.
        self.send_recover_message = send_recover_message  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateNotificationPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.escalation_policy_id is not None:
            result['EscalationPolicyId'] = self.escalation_policy_id
        if self.group_rule is not None:
            result['GroupRule'] = self.group_rule
        if self.id is not None:
            result['Id'] = self.id
        if self.integration_id is not None:
            result['IntegrationId'] = self.integration_id
        if self.matching_rules is not None:
            result['MatchingRules'] = self.matching_rules
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_rule is not None:
            result['NotifyRule'] = self.notify_rule
        if self.notify_template is not None:
            result['NotifyTemplate'] = self.notify_template
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.repeat is not None:
            result['Repeat'] = self.repeat
        if self.repeat_interval is not None:
            result['RepeatInterval'] = self.repeat_interval
        if self.send_recover_message is not None:
            result['SendRecoverMessage'] = self.send_recover_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EscalationPolicyId') is not None:
            self.escalation_policy_id = m.get('EscalationPolicyId')
        if m.get('GroupRule') is not None:
            self.group_rule = m.get('GroupRule')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IntegrationId') is not None:
            self.integration_id = m.get('IntegrationId')
        if m.get('MatchingRules') is not None:
            self.matching_rules = m.get('MatchingRules')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyRule') is not None:
            self.notify_rule = m.get('NotifyRule')
        if m.get('NotifyTemplate') is not None:
            self.notify_template = m.get('NotifyTemplate')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Repeat') is not None:
            self.repeat = m.get('Repeat')
        if m.get('RepeatInterval') is not None:
            self.repeat_interval = m.get('RepeatInterval')
        if m.get('SendRecoverMessage') is not None:
            self.send_recover_message = m.get('SendRecoverMessage')
        return self


class CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicyGroupRule(TeaModel):
    def __init__(self, group_interval=None, group_wait=None, grouping_fields=None):
        # The time interval of grouping. Unit: seconds. Default value: 30.
        self.group_interval = group_interval  # type: long
        # The waiting time for grouping. Unit: seconds. Default value: 5.
        self.group_wait = group_wait  # type: long
        # The field that is used for grouping.
        self.grouping_fields = grouping_fields  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicyGroupRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_interval is not None:
            result['GroupInterval'] = self.group_interval
        if self.group_wait is not None:
            result['GroupWait'] = self.group_wait
        if self.grouping_fields is not None:
            result['GroupingFields'] = self.grouping_fields
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupInterval') is not None:
            self.group_interval = m.get('GroupInterval')
        if m.get('GroupWait') is not None:
            self.group_wait = m.get('GroupWait')
        if m.get('GroupingFields') is not None:
            self.grouping_fields = m.get('GroupingFields')
        return self


class CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicyMatchingRulesMatchingConditions(TeaModel):
    def __init__(self, key=None, operator=None, value=None):
        # The key of the matching condition.
        self.key = key  # type: str
        # The logical operator of the matching condition. Valid values:
        # 
        # *   `eq`: equal to
        # *   `neq`: not equal to
        # *   `in`: contains
        # *   `nin`: does not contain
        # *   `re`: regular expression match
        # *   `nre`: regular expression mismatch
        self.operator = operator  # type: str
        # The value of the matching condition.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicyMatchingRulesMatchingConditions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicyMatchingRules(TeaModel):
    def __init__(self, matching_conditions=None):
        # An array of alert event matching condition objects.
        self.matching_conditions = matching_conditions  # type: list[CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicyMatchingRulesMatchingConditions]

    def validate(self):
        if self.matching_conditions:
            for k in self.matching_conditions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicyMatchingRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MatchingConditions'] = []
        if self.matching_conditions is not None:
            for k in self.matching_conditions:
                result['MatchingConditions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.matching_conditions = []
        if m.get('MatchingConditions') is not None:
            for k in m.get('MatchingConditions'):
                temp_model = CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicyMatchingRulesMatchingConditions()
                self.matching_conditions.append(temp_model.from_map(k))
        return self


class CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicyNotifyRuleNotifyObjects(TeaModel):
    def __init__(self, notify_object_id=None, notify_object_name=None, notify_object_type=None):
        # The ID of the notification contact.
        self.notify_object_id = notify_object_id  # type: long
        # The name of the notification contact.
        self.notify_object_name = notify_object_name  # type: str
        # The type of the notification contact. Valid values: 
        # 
        # - CONTACT: an individual contact
        # - CONTACT_GROUP: a contact group
        # - DING_ROBOT: an instant messaging (IM) robot
        # - CONTACT_SCHEDULE: a person on duty based on an established schedule
        self.notify_object_type = notify_object_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicyNotifyRuleNotifyObjects, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.notify_object_id is not None:
            result['NotifyObjectId'] = self.notify_object_id
        if self.notify_object_name is not None:
            result['NotifyObjectName'] = self.notify_object_name
        if self.notify_object_type is not None:
            result['NotifyObjectType'] = self.notify_object_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NotifyObjectId') is not None:
            self.notify_object_id = m.get('NotifyObjectId')
        if m.get('NotifyObjectName') is not None:
            self.notify_object_name = m.get('NotifyObjectName')
        if m.get('NotifyObjectType') is not None:
            self.notify_object_type = m.get('NotifyObjectType')
        return self


class CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicyNotifyRule(TeaModel):
    def __init__(self, notify_channels=None, notify_end_time=None, notify_objects=None, notify_start_time=None):
        # The notification methods. Valid values: 
        # 
        # - `dingTalk`: DingTalk
        # - `email`: email
        # - `sms`: text message
        # - `tts`: phone call
        # - `webhook`: webhook
        self.notify_channels = notify_channels  # type: list[str]
        # The end time of the notification window.
        self.notify_end_time = notify_end_time  # type: str
        # An array of notification contact objects.
        self.notify_objects = notify_objects  # type: list[CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicyNotifyRuleNotifyObjects]
        # The start time of the notification window.
        self.notify_start_time = notify_start_time  # type: str

    def validate(self):
        if self.notify_objects:
            for k in self.notify_objects:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicyNotifyRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.notify_channels is not None:
            result['NotifyChannels'] = self.notify_channels
        if self.notify_end_time is not None:
            result['NotifyEndTime'] = self.notify_end_time
        result['NotifyObjects'] = []
        if self.notify_objects is not None:
            for k in self.notify_objects:
                result['NotifyObjects'].append(k.to_map() if k else None)
        if self.notify_start_time is not None:
            result['NotifyStartTime'] = self.notify_start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NotifyChannels') is not None:
            self.notify_channels = m.get('NotifyChannels')
        if m.get('NotifyEndTime') is not None:
            self.notify_end_time = m.get('NotifyEndTime')
        self.notify_objects = []
        if m.get('NotifyObjects') is not None:
            for k in m.get('NotifyObjects'):
                temp_model = CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicyNotifyRuleNotifyObjects()
                self.notify_objects.append(temp_model.from_map(k))
        if m.get('NotifyStartTime') is not None:
            self.notify_start_time = m.get('NotifyStartTime')
        return self


class CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicyNotifyTemplate(TeaModel):
    def __init__(self, email_content=None, email_recover_content=None, email_recover_title=None, email_title=None,
                 robot_content=None, sms_content=None, sms_recover_content=None, tts_content=None, tts_recover_content=None):
        # The content of the alert notification sent through email.
        self.email_content = email_content  # type: str
        # The content of the alert resolution notification sent through email.
        self.email_recover_content = email_recover_content  # type: str
        # The title of the alert resolution notification sent through email.
        self.email_recover_title = email_recover_title  # type: str
        # The title of the alert notification sent through email.
        self.email_title = email_title  # type: str
        # The content of the alert notification sent by the IM robot.
        self.robot_content = robot_content  # type: str
        # The content of the alert notification sent through text message.
        self.sms_content = sms_content  # type: str
        # The content of the alert resolution notification sent through text message.
        self.sms_recover_content = sms_recover_content  # type: str
        # The content of the alert notification by phone.
        self.tts_content = tts_content  # type: str
        # The content of the alert resolution notification by phone.
        self.tts_recover_content = tts_recover_content  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicyNotifyTemplate, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.email_content is not None:
            result['EmailContent'] = self.email_content
        if self.email_recover_content is not None:
            result['EmailRecoverContent'] = self.email_recover_content
        if self.email_recover_title is not None:
            result['EmailRecoverTitle'] = self.email_recover_title
        if self.email_title is not None:
            result['EmailTitle'] = self.email_title
        if self.robot_content is not None:
            result['RobotContent'] = self.robot_content
        if self.sms_content is not None:
            result['SmsContent'] = self.sms_content
        if self.sms_recover_content is not None:
            result['SmsRecoverContent'] = self.sms_recover_content
        if self.tts_content is not None:
            result['TtsContent'] = self.tts_content
        if self.tts_recover_content is not None:
            result['TtsRecoverContent'] = self.tts_recover_content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EmailContent') is not None:
            self.email_content = m.get('EmailContent')
        if m.get('EmailRecoverContent') is not None:
            self.email_recover_content = m.get('EmailRecoverContent')
        if m.get('EmailRecoverTitle') is not None:
            self.email_recover_title = m.get('EmailRecoverTitle')
        if m.get('EmailTitle') is not None:
            self.email_title = m.get('EmailTitle')
        if m.get('RobotContent') is not None:
            self.robot_content = m.get('RobotContent')
        if m.get('SmsContent') is not None:
            self.sms_content = m.get('SmsContent')
        if m.get('SmsRecoverContent') is not None:
            self.sms_recover_content = m.get('SmsRecoverContent')
        if m.get('TtsContent') is not None:
            self.tts_content = m.get('TtsContent')
        if m.get('TtsRecoverContent') is not None:
            self.tts_recover_content = m.get('TtsRecoverContent')
        return self


class CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicy(TeaModel):
    def __init__(self, escalation_policy_id=None, group_rule=None, id=None, integration_id=None,
                 matching_rules=None, name=None, notify_rule=None, notify_template=None, repeat=None, repeat_interval=None,
                 send_recover_message=None):
        # The ID of the escalation policy.
        self.escalation_policy_id = escalation_policy_id  # type: long
        # An array of alert event group objects.
        self.group_rule = group_rule  # type: CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicyGroupRule
        # The ID of the notification policy.
        self.id = id  # type: long
        # The integration ID of the ticket system to which alerts are pushed.
        self.integration_id = integration_id  # type: long
        # An array of alert event matching rule objects.
        self.matching_rules = matching_rules  # type: list[CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicyMatchingRules]
        # The name of the notification policy.
        self.name = name  # type: str
        # An array of notification rule objects.
        self.notify_rule = notify_rule  # type: CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicyNotifyRule
        # An array of notification template objects.
        self.notify_template = notify_template  # type: CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicyNotifyTemplate
        # Indicates whether a notification is resent for a long-lasting unresolved alert. Default value: true. Valid values:  
        # 
        # - `true`: The system resends a notification for a long-lasting unresolved alert at a specified time interval.
        # - `false`: The system sends a notification for a long-lasting unresolved alert based on an escalation policy.
        self.repeat = repeat  # type: bool
        # The time interval at which a notification is resent for a long-lasting unresolved alert. Unit: seconds.
        self.repeat_interval = repeat_interval  # type: long
        # Indicates whether the system sends a notification to the contacts when the status of an alert changes to Resolved. Default value: true. Valid values:   
        # 
        # - `true`: The system sends a notification.
        # - `false`: The system does not send a notification.
        self.send_recover_message = send_recover_message  # type: bool

    def validate(self):
        if self.group_rule:
            self.group_rule.validate()
        if self.matching_rules:
            for k in self.matching_rules:
                if k:
                    k.validate()
        if self.notify_rule:
            self.notify_rule.validate()
        if self.notify_template:
            self.notify_template.validate()

    def to_map(self):
        _map = super(CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicy, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.escalation_policy_id is not None:
            result['EscalationPolicyId'] = self.escalation_policy_id
        if self.group_rule is not None:
            result['GroupRule'] = self.group_rule.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.integration_id is not None:
            result['IntegrationId'] = self.integration_id
        result['MatchingRules'] = []
        if self.matching_rules is not None:
            for k in self.matching_rules:
                result['MatchingRules'].append(k.to_map() if k else None)
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_rule is not None:
            result['NotifyRule'] = self.notify_rule.to_map()
        if self.notify_template is not None:
            result['NotifyTemplate'] = self.notify_template.to_map()
        if self.repeat is not None:
            result['Repeat'] = self.repeat
        if self.repeat_interval is not None:
            result['RepeatInterval'] = self.repeat_interval
        if self.send_recover_message is not None:
            result['SendRecoverMessage'] = self.send_recover_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EscalationPolicyId') is not None:
            self.escalation_policy_id = m.get('EscalationPolicyId')
        if m.get('GroupRule') is not None:
            temp_model = CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicyGroupRule()
            self.group_rule = temp_model.from_map(m['GroupRule'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IntegrationId') is not None:
            self.integration_id = m.get('IntegrationId')
        self.matching_rules = []
        if m.get('MatchingRules') is not None:
            for k in m.get('MatchingRules'):
                temp_model = CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicyMatchingRules()
                self.matching_rules.append(temp_model.from_map(k))
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyRule') is not None:
            temp_model = CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicyNotifyRule()
            self.notify_rule = temp_model.from_map(m['NotifyRule'])
        if m.get('NotifyTemplate') is not None:
            temp_model = CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicyNotifyTemplate()
            self.notify_template = temp_model.from_map(m['NotifyTemplate'])
        if m.get('Repeat') is not None:
            self.repeat = m.get('Repeat')
        if m.get('RepeatInterval') is not None:
            self.repeat_interval = m.get('RepeatInterval')
        if m.get('SendRecoverMessage') is not None:
            self.send_recover_message = m.get('SendRecoverMessage')
        return self


class CreateOrUpdateNotificationPolicyResponseBody(TeaModel):
    def __init__(self, notification_policy=None, request_id=None):
        # An array of notification policy objects.
        self.notification_policy = notification_policy  # type: CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicy
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.notification_policy:
            self.notification_policy.validate()

    def to_map(self):
        _map = super(CreateOrUpdateNotificationPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.notification_policy is not None:
            result['NotificationPolicy'] = self.notification_policy.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NotificationPolicy') is not None:
            temp_model = CreateOrUpdateNotificationPolicyResponseBodyNotificationPolicy()
            self.notification_policy = temp_model.from_map(m['NotificationPolicy'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateOrUpdateNotificationPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateOrUpdateNotificationPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateOrUpdateNotificationPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOrUpdateNotificationPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOrUpdateSilencePolicyRequest(TeaModel):
    def __init__(self, id=None, matching_rules=None, name=None, region_id=None):
        # The ID of the silence policy.
        # 
        # *   If you do not specify this parameter, a new silence policy is created.
        # *   If you specify this parameter, the specified silence policy is modified.
        self.id = id  # type: long
        # The matching rules. Sample statement:
        # 
        # ```
        # 
        # [
        #      {
        # 	 "matchingConditions": [
        # 	 {
        # 	 "value": "test", // The value of the matching condition. 
        # 	 "key": "altertname", // The key of the matching condition. 
        # 	 "operator": "eq" // The logical operator of the matching condition, including eq (equal to), neq (not equal to), in (contains), nin (does not contain), re (regular expression match), and nre (regular expression mismatch).   
        # 	 }
        # 	 ]
        #      }
        # 	 ]
        # ```
        self.matching_rules = matching_rules  # type: str
        # The name of the silence policy.
        self.name = name  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateSilencePolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.matching_rules is not None:
            result['MatchingRules'] = self.matching_rules
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MatchingRules') is not None:
            self.matching_rules = m.get('MatchingRules')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateOrUpdateSilencePolicyResponseBodySilencePolicyMatchingRulesMatchingConditions(TeaModel):
    def __init__(self, key=None, operator=None, value=None):
        # The key of the matching condition.
        self.key = key  # type: str
        # The logical operator of the matching condition. Valid values:
        # 
        # *   `eq`: equal to.
        # *   `neq`: not equal to.
        # *   `in`: contains.
        # *   `nin`: does not contain.
        # *   `re`: regular expression match.
        # *   `nre`: regular expression mismatch.
        self.operator = operator  # type: str
        # The value of the matching condition.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateSilencePolicyResponseBodySilencePolicyMatchingRulesMatchingConditions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateOrUpdateSilencePolicyResponseBodySilencePolicyMatchingRules(TeaModel):
    def __init__(self, matching_conditions=None):
        # An array of matching condition objects.
        self.matching_conditions = matching_conditions  # type: list[CreateOrUpdateSilencePolicyResponseBodySilencePolicyMatchingRulesMatchingConditions]

    def validate(self):
        if self.matching_conditions:
            for k in self.matching_conditions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateOrUpdateSilencePolicyResponseBodySilencePolicyMatchingRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MatchingConditions'] = []
        if self.matching_conditions is not None:
            for k in self.matching_conditions:
                result['MatchingConditions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.matching_conditions = []
        if m.get('MatchingConditions') is not None:
            for k in m.get('MatchingConditions'):
                temp_model = CreateOrUpdateSilencePolicyResponseBodySilencePolicyMatchingRulesMatchingConditions()
                self.matching_conditions.append(temp_model.from_map(k))
        return self


class CreateOrUpdateSilencePolicyResponseBodySilencePolicy(TeaModel):
    def __init__(self, id=None, matching_rules=None, name=None):
        # The ID of the silence policy.
        self.id = id  # type: long
        # An array of matching rule objects.
        self.matching_rules = matching_rules  # type: list[CreateOrUpdateSilencePolicyResponseBodySilencePolicyMatchingRules]
        # The name of the silence policy.
        self.name = name  # type: str

    def validate(self):
        if self.matching_rules:
            for k in self.matching_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateOrUpdateSilencePolicyResponseBodySilencePolicy, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        result['MatchingRules'] = []
        if self.matching_rules is not None:
            for k in self.matching_rules:
                result['MatchingRules'].append(k.to_map() if k else None)
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        self.matching_rules = []
        if m.get('MatchingRules') is not None:
            for k in m.get('MatchingRules'):
                temp_model = CreateOrUpdateSilencePolicyResponseBodySilencePolicyMatchingRules()
                self.matching_rules.append(temp_model.from_map(k))
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateOrUpdateSilencePolicyResponseBody(TeaModel):
    def __init__(self, request_id=None, silence_policy=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # An array of silence policy objects.
        self.silence_policy = silence_policy  # type: CreateOrUpdateSilencePolicyResponseBodySilencePolicy

    def validate(self):
        if self.silence_policy:
            self.silence_policy.validate()

    def to_map(self):
        _map = super(CreateOrUpdateSilencePolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.silence_policy is not None:
            result['SilencePolicy'] = self.silence_policy.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SilencePolicy') is not None:
            temp_model = CreateOrUpdateSilencePolicyResponseBodySilencePolicy()
            self.silence_policy = temp_model.from_map(m['SilencePolicy'])
        return self


class CreateOrUpdateSilencePolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateOrUpdateSilencePolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateOrUpdateSilencePolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOrUpdateSilencePolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOrUpdateWebhookContactRequest(TeaModel):
    def __init__(self, biz_headers=None, biz_params=None, body=None, method=None, recover_body=None, url=None,
                 webhook_id=None, webhook_name=None):
        # The header of the HTTP request.
        self.biz_headers = biz_headers  # type: str
        # The parameters in the HTTP request.
        self.biz_params = biz_params  # type: str
        # The notification template that is sent when an alert is triggered. This parameter is required when the **Method** is set to **Post**. You can use `$content` placeholders to output the notification content. The notification content cannot exceed 500 characters in length. For more information, see [Notification template variables](~~251834~~).
        self.body = body  # type: str
        # The HTTP request method. Valid values:
        # 
        # *   Post
        # *   Get
        self.method = method  # type: str
        # The notification template that is sent when the alert resumes. This parameter is required when the **Method** is set to **Post**. You can use `$content` placeholders to output the notification content. The notification content cannot exceed 500 characters in length. For more information, see [Notification template variables](~~251834~~).
        self.recover_body = recover_body  # type: str
        # The URL of the request method.
        self.url = url  # type: str
        # The ID of the contact for webhook alerts.
        # 
        # *   If you do not specify this parameter, a new webhook alert contact is created.
        # *   Enter information that represents modifying the contact information of the specified Webhook alert.
        self.webhook_id = webhook_id  # type: long
        # The name of the webhook alert contact.
        self.webhook_name = webhook_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateWebhookContactRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_headers is not None:
            result['BizHeaders'] = self.biz_headers
        if self.biz_params is not None:
            result['BizParams'] = self.biz_params
        if self.body is not None:
            result['Body'] = self.body
        if self.method is not None:
            result['Method'] = self.method
        if self.recover_body is not None:
            result['RecoverBody'] = self.recover_body
        if self.url is not None:
            result['Url'] = self.url
        if self.webhook_id is not None:
            result['WebhookId'] = self.webhook_id
        if self.webhook_name is not None:
            result['WebhookName'] = self.webhook_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizHeaders') is not None:
            self.biz_headers = m.get('BizHeaders')
        if m.get('BizParams') is not None:
            self.biz_params = m.get('BizParams')
        if m.get('Body') is not None:
            self.body = m.get('Body')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('RecoverBody') is not None:
            self.recover_body = m.get('RecoverBody')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('WebhookId') is not None:
            self.webhook_id = m.get('WebhookId')
        if m.get('WebhookName') is not None:
            self.webhook_name = m.get('WebhookName')
        return self


class CreateOrUpdateWebhookContactResponseBodyWebhookContactWebhook(TeaModel):
    def __init__(self, biz_headers=None, biz_params=None, body=None, method=None, recover_body=None, url=None):
        # The header of the HTTP request.
        self.biz_headers = biz_headers  # type: str
        # The parameters in the HTTP request.
        self.biz_params = biz_params  # type: str
        # The alert notification template.
        self.body = body  # type: str
        # The HTTP request method. Valid values:
        # 
        # *   Post
        # *   Get
        self.method = method  # type: str
        # The alert recovery template.
        self.recover_body = recover_body  # type: str
        # The URL of the request method.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateWebhookContactResponseBodyWebhookContactWebhook, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_headers is not None:
            result['BizHeaders'] = self.biz_headers
        if self.biz_params is not None:
            result['BizParams'] = self.biz_params
        if self.body is not None:
            result['Body'] = self.body
        if self.method is not None:
            result['Method'] = self.method
        if self.recover_body is not None:
            result['RecoverBody'] = self.recover_body
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizHeaders') is not None:
            self.biz_headers = m.get('BizHeaders')
        if m.get('BizParams') is not None:
            self.biz_params = m.get('BizParams')
        if m.get('Body') is not None:
            self.body = m.get('Body')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('RecoverBody') is not None:
            self.recover_body = m.get('RecoverBody')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class CreateOrUpdateWebhookContactResponseBodyWebhookContact(TeaModel):
    def __init__(self, webhook=None, webhook_id=None, webhook_name=None):
        # The returned Webhook object.
        self.webhook = webhook  # type: CreateOrUpdateWebhookContactResponseBodyWebhookContactWebhook
        # The ID of the contact for webhook alerts.
        self.webhook_id = webhook_id  # type: float
        # The name of the webhook alert contact.
        self.webhook_name = webhook_name  # type: str

    def validate(self):
        if self.webhook:
            self.webhook.validate()

    def to_map(self):
        _map = super(CreateOrUpdateWebhookContactResponseBodyWebhookContact, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.webhook is not None:
            result['Webhook'] = self.webhook.to_map()
        if self.webhook_id is not None:
            result['WebhookId'] = self.webhook_id
        if self.webhook_name is not None:
            result['WebhookName'] = self.webhook_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Webhook') is not None:
            temp_model = CreateOrUpdateWebhookContactResponseBodyWebhookContactWebhook()
            self.webhook = temp_model.from_map(m['Webhook'])
        if m.get('WebhookId') is not None:
            self.webhook_id = m.get('WebhookId')
        if m.get('WebhookName') is not None:
            self.webhook_name = m.get('WebhookName')
        return self


class CreateOrUpdateWebhookContactResponseBody(TeaModel):
    def __init__(self, request_id=None, webhook_contact=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The returned WebhookContact object.
        self.webhook_contact = webhook_contact  # type: CreateOrUpdateWebhookContactResponseBodyWebhookContact

    def validate(self):
        if self.webhook_contact:
            self.webhook_contact.validate()

    def to_map(self):
        _map = super(CreateOrUpdateWebhookContactResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.webhook_contact is not None:
            result['WebhookContact'] = self.webhook_contact.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('WebhookContact') is not None:
            temp_model = CreateOrUpdateWebhookContactResponseBodyWebhookContact()
            self.webhook_contact = temp_model.from_map(m['WebhookContact'])
        return self


class CreateOrUpdateWebhookContactResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateOrUpdateWebhookContactResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateOrUpdateWebhookContactResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOrUpdateWebhookContactResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePrometheusAlertRuleRequest(TeaModel):
    def __init__(self, alert_name=None, annotations=None, cluster_id=None, dispatch_rule_id=None, duration=None,
                 expression=None, labels=None, message=None, notify_type=None, region_id=None, type=None):
        # The name of the alert rule.
        self.alert_name = alert_name  # type: str
        # The annotations that are described in a JSON string. You must specify the name and value of each annotation.
        self.annotations = annotations  # type: str
        # The ID of the cluster.
        self.cluster_id = cluster_id  # type: str
        # The ID of the notification policy. This parameter is required if the **NotifyType** parameter is set to `DISPATCH_RULE`.
        self.dispatch_rule_id = dispatch_rule_id  # type: long
        # The duration of the alert. Valid values: 1 to 1440. Unit: minutes.
        self.duration = duration  # type: str
        # The expression of the alert rule. The expression must follow the PromQL syntax.
        self.expression = expression  # type: str
        # The tags that are described in a JSON string. You must specify the name and value of each tag.
        self.labels = labels  # type: str
        # The content of the alert notification. Tags can be referenced in the {{$labels.xxx}} format.
        self.message = message  # type: str
        # The method that is used to send alert notifications. Valid values:
        # 
        # *   `ALERT_MANAGER`: Alert notifications are sent by Operation Center. This is the default value.
        # *   `DISPATCH_RULE`: Alert notifications are sent based on the specified notification policy.
        self.notify_type = notify_type  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The type of the alert rule. Valid values:
        # 
        # *   99: custom alert
        # *   101: Prometheus Service alert
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreatePrometheusAlertRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_name is not None:
            result['AlertName'] = self.alert_name
        if self.annotations is not None:
            result['Annotations'] = self.annotations
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.dispatch_rule_id is not None:
            result['DispatchRuleId'] = self.dispatch_rule_id
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.labels is not None:
            result['Labels'] = self.labels
        if self.message is not None:
            result['Message'] = self.message
        if self.notify_type is not None:
            result['NotifyType'] = self.notify_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertName') is not None:
            self.alert_name = m.get('AlertName')
        if m.get('Annotations') is not None:
            self.annotations = m.get('Annotations')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DispatchRuleId') is not None:
            self.dispatch_rule_id = m.get('DispatchRuleId')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('Labels') is not None:
            self.labels = m.get('Labels')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NotifyType') is not None:
            self.notify_type = m.get('NotifyType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreatePrometheusAlertRuleResponseBodyPrometheusAlertRuleAnnotations(TeaModel):
    def __init__(self, name=None, value=None):
        # The name of the annotation.
        self.name = name  # type: str
        # The value of the annotation.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreatePrometheusAlertRuleResponseBodyPrometheusAlertRuleAnnotations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreatePrometheusAlertRuleResponseBodyPrometheusAlertRuleLabels(TeaModel):
    def __init__(self, name=None, value=None):
        # The name of the tag.
        self.name = name  # type: str
        # The value of the tag.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreatePrometheusAlertRuleResponseBodyPrometheusAlertRuleLabels, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreatePrometheusAlertRuleResponseBodyPrometheusAlertRule(TeaModel):
    def __init__(self, alert_id=None, alert_name=None, annotations=None, cluster_id=None, dispatch_rule_id=None,
                 duration=None, expression=None, labels=None, message=None, notify_type=None, status=None, type=None):
        # The ID of the alert rule.
        self.alert_id = alert_id  # type: long
        # The name of the alert rule.
        self.alert_name = alert_name  # type: str
        # The annotations of the alert rule.
        self.annotations = annotations  # type: list[CreatePrometheusAlertRuleResponseBodyPrometheusAlertRuleAnnotations]
        # The ID of the cluster.
        self.cluster_id = cluster_id  # type: str
        # The ID of the notification policy.
        self.dispatch_rule_id = dispatch_rule_id  # type: long
        # The duration of the alert. Valid values: 1 to 1440. Unit: minutes.
        self.duration = duration  # type: str
        # The expression of the alert rule.
        self.expression = expression  # type: str
        # The tags of the alert rule.
        self.labels = labels  # type: list[CreatePrometheusAlertRuleResponseBodyPrometheusAlertRuleLabels]
        # The content of the alert notification. Tags can be referenced in the {{$labels.xxx}} format.
        self.message = message  # type: str
        # The method that is used to send alert notifications. Valid values:
        # 
        # *   `ALERT_MANAGER`: Alert notifications are sent by Operation Center.
        # *   `DISPATCH_RULE`: Alert notifications are sent based on the specified notification policy.
        self.notify_type = notify_type  # type: str
        # Indicates whether the alert rule is enabled. Valid values:
        # 
        # *   `1`: The alert rule is enabled.
        # *   `0`: The alert rule is disabled.
        self.status = status  # type: int
        # The type of the alert rule.
        self.type = type  # type: str

    def validate(self):
        if self.annotations:
            for k in self.annotations:
                if k:
                    k.validate()
        if self.labels:
            for k in self.labels:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreatePrometheusAlertRuleResponseBodyPrometheusAlertRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_id is not None:
            result['AlertId'] = self.alert_id
        if self.alert_name is not None:
            result['AlertName'] = self.alert_name
        result['Annotations'] = []
        if self.annotations is not None:
            for k in self.annotations:
                result['Annotations'].append(k.to_map() if k else None)
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.dispatch_rule_id is not None:
            result['DispatchRuleId'] = self.dispatch_rule_id
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.expression is not None:
            result['Expression'] = self.expression
        result['Labels'] = []
        if self.labels is not None:
            for k in self.labels:
                result['Labels'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.notify_type is not None:
            result['NotifyType'] = self.notify_type
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertId') is not None:
            self.alert_id = m.get('AlertId')
        if m.get('AlertName') is not None:
            self.alert_name = m.get('AlertName')
        self.annotations = []
        if m.get('Annotations') is not None:
            for k in m.get('Annotations'):
                temp_model = CreatePrometheusAlertRuleResponseBodyPrometheusAlertRuleAnnotations()
                self.annotations.append(temp_model.from_map(k))
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DispatchRuleId') is not None:
            self.dispatch_rule_id = m.get('DispatchRuleId')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        self.labels = []
        if m.get('Labels') is not None:
            for k in m.get('Labels'):
                temp_model = CreatePrometheusAlertRuleResponseBodyPrometheusAlertRuleLabels()
                self.labels.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NotifyType') is not None:
            self.notify_type = m.get('NotifyType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreatePrometheusAlertRuleResponseBody(TeaModel):
    def __init__(self, prometheus_alert_rule=None, request_id=None):
        # The returned struct.
        self.prometheus_alert_rule = prometheus_alert_rule  # type: CreatePrometheusAlertRuleResponseBodyPrometheusAlertRule
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.prometheus_alert_rule:
            self.prometheus_alert_rule.validate()

    def to_map(self):
        _map = super(CreatePrometheusAlertRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.prometheus_alert_rule is not None:
            result['PrometheusAlertRule'] = self.prometheus_alert_rule.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PrometheusAlertRule') is not None:
            temp_model = CreatePrometheusAlertRuleResponseBodyPrometheusAlertRule()
            self.prometheus_alert_rule = temp_model.from_map(m['PrometheusAlertRule'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreatePrometheusAlertRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreatePrometheusAlertRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreatePrometheusAlertRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreatePrometheusAlertRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePrometheusInstanceRequestTags(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreatePrometheusInstanceRequestTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreatePrometheusInstanceRequest(TeaModel):
    def __init__(self, cluster_id=None, cluster_name=None, cluster_type=None, grafana_instance_id=None,
                 region_id=None, resource_group_id=None, security_group_id=None, sub_clusters_json=None, tags=None,
                 v_switch_id=None, vpc_id=None):
        # The ID of the Kubernetes cluster. This parameter is required if you set the ClusterType parameter to aliyun-cs��.
        self.cluster_id = cluster_id  # type: str
        # The name of the created cluster. This parameter is required if you set the ClusterType parameter to remote-write or ecs.
        self.cluster_name = cluster_name  # type: str
        # The type of the Prometheus instance. The following types are provided: remote-write (Prometheus instance for Remote Write) ecs (Prometheus instance for ECS) cloud-monitor� (Prometheus instance for cloud services in China) cloud-product (Prometheus instance for Alibaba Cloud services outside China) global-view (Prometheus instance for GlobalView) aliyun-cs�� (Prometheus instances for Container Service)
        self.cluster_type = cluster_type  # type: str
        # The ID of the Grafana dedicated instance. This parameter is available if you set the ClusterType parameter to ecs.
        self.grafana_instance_id = grafana_instance_id  # type: str
        # The ID of the region. If you create a Prometheus instance for Cloud service in China, set the value to cn-shanghai.
        self.region_id = region_id  # type: str
        # The ID of the custom resource group. You can configure this parameter to bind the instance to the resource group.
        self.resource_group_id = resource_group_id  # type: str
        # The security group. This parameter is required if you set the ClusterType parameter to ecs.
        self.security_group_id = security_group_id  # type: str
        # globalView实例的子实例json串。
        self.sub_clusters_json = sub_clusters_json  # type: str
        # The tags of the instance. You can configure this parameter to manage tags for the instance.
        self.tags = tags  # type: list[CreatePrometheusInstanceRequestTags]
        # The vSwitch. This parameter is required if you set the ClusterType parameter to ecs.
        self.v_switch_id = v_switch_id  # type: str
        # The virtual private cloud (VPC). This parameter is required if you set the ClusterType parameter to ecs.
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreatePrometheusInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.grafana_instance_id is not None:
            result['GrafanaInstanceId'] = self.grafana_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.sub_clusters_json is not None:
            result['SubClustersJson'] = self.sub_clusters_json
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('GrafanaInstanceId') is not None:
            self.grafana_instance_id = m.get('GrafanaInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('SubClustersJson') is not None:
            self.sub_clusters_json = m.get('SubClustersJson')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = CreatePrometheusInstanceRequestTags()
                self.tags.append(temp_model.from_map(k))
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class CreatePrometheusInstanceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        # 接口状态码：
        # 
        # - `2XX`：成功
        # - `3XX`：重定向
        # - `4XX`：请求错误
        # - `5XX`：服务器错误
        self.code = code  # type: int
        # The ID of the Prometheus instance.
        self.data = data  # type: str
        # 调用失败时返回的信息。
        self.message = message  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreatePrometheusInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreatePrometheusInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreatePrometheusInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreatePrometheusInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreatePrometheusInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRetcodeAppRequestTags(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag key.
        self.key = key  # type: str
        # The tag value.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateRetcodeAppRequestTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateRetcodeAppRequest(TeaModel):
    def __init__(self, region_id=None, resource_group_id=None, retcode_app_name=None, retcode_app_type=None,
                 tags=None):
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The ID of the resource group. You can obtain the resource group ID in the **Resource Management** console.
        self.resource_group_id = resource_group_id  # type: str
        # The name of the application.
        self.retcode_app_name = retcode_app_name  # type: str
        # The type of the application. Valid values:
        # 
        # *   `web`: web application
        # *   `weex`: Weex mobile app
        # *   `mini_dd`: DingTalk mini program
        # *   `mini_alipay`: Alipay mini program
        # *   `mini_wx`: WeChat mini program
        # *   `mini_common`: mini program on other platforms
        self.retcode_app_type = retcode_app_type  # type: str
        # The list of tags.
        self.tags = tags  # type: list[CreateRetcodeAppRequestTags]

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateRetcodeAppRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.retcode_app_name is not None:
            result['RetcodeAppName'] = self.retcode_app_name
        if self.retcode_app_type is not None:
            result['RetcodeAppType'] = self.retcode_app_type
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('RetcodeAppName') is not None:
            self.retcode_app_name = m.get('RetcodeAppName')
        if m.get('RetcodeAppType') is not None:
            self.retcode_app_type = m.get('RetcodeAppType')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = CreateRetcodeAppRequestTags()
                self.tags.append(temp_model.from_map(k))
        return self


class CreateRetcodeAppResponseBodyRetcodeAppDataBeanTagsTags(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag key.
        self.key = key  # type: str
        # The tag value.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateRetcodeAppResponseBodyRetcodeAppDataBeanTagsTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateRetcodeAppResponseBodyRetcodeAppDataBeanTags(TeaModel):
    def __init__(self, tags=None):
        self.tags = tags  # type: list[CreateRetcodeAppResponseBodyRetcodeAppDataBeanTagsTags]

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateRetcodeAppResponseBodyRetcodeAppDataBeanTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = CreateRetcodeAppResponseBodyRetcodeAppDataBeanTagsTags()
                self.tags.append(temp_model.from_map(k))
        return self


class CreateRetcodeAppResponseBodyRetcodeAppDataBean(TeaModel):
    def __init__(self, app_id=None, pid=None, resource_group_id=None, tags=None):
        # The ID of the application.
        self.app_id = app_id  # type: long
        # The process identifier (PID) of the application.
        self.pid = pid  # type: str
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        # The list of tags.
        self.tags = tags  # type: CreateRetcodeAppResponseBodyRetcodeAppDataBeanTags

    def validate(self):
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super(CreateRetcodeAppResponseBodyRetcodeAppDataBean, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Tags') is not None:
            temp_model = CreateRetcodeAppResponseBodyRetcodeAppDataBeanTags()
            self.tags = temp_model.from_map(m['Tags'])
        return self


class CreateRetcodeAppResponseBody(TeaModel):
    def __init__(self, request_id=None, retcode_app_data_bean=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The information of the browser monitoring task.
        self.retcode_app_data_bean = retcode_app_data_bean  # type: CreateRetcodeAppResponseBodyRetcodeAppDataBean

    def validate(self):
        if self.retcode_app_data_bean:
            self.retcode_app_data_bean.validate()

    def to_map(self):
        _map = super(CreateRetcodeAppResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.retcode_app_data_bean is not None:
            result['RetcodeAppDataBean'] = self.retcode_app_data_bean.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RetcodeAppDataBean') is not None:
            temp_model = CreateRetcodeAppResponseBodyRetcodeAppDataBean()
            self.retcode_app_data_bean = temp_model.from_map(m['RetcodeAppDataBean'])
        return self


class CreateRetcodeAppResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateRetcodeAppResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateRetcodeAppResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRetcodeAppResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSyntheticTaskRequestCommonParamAlertList(TeaModel):
    def __init__(self, is_critical=None, name=None, symbols=None):
        # Specifies whether the condition must be met.
        self.is_critical = is_critical  # type: long
        # The name of the alert rule.
        # 
        # For network synthetic monitoring, use the following names:
        # 
        # *   Latency: PING_SET
        # *   Packet loss rate: PING_LOST_RATE
        # *   Hijacking: HIJACKPER
        self.name = name  # type: str
        # Specifies how the condition is evaluated. Valid values:
        # 
        # *   1: greater than
        # *   0: less than
        self.symbols = symbols  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSyntheticTaskRequestCommonParamAlertList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_critical is not None:
            result['IsCritical'] = self.is_critical
        if self.name is not None:
            result['Name'] = self.name
        if self.symbols is not None:
            result['Symbols'] = self.symbols
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsCritical') is not None:
            self.is_critical = m.get('IsCritical')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Symbols') is not None:
            self.symbols = m.get('Symbols')
        return self


class CreateSyntheticTaskRequestCommonParam(TeaModel):
    def __init__(self, alarm_flag=None, alert_list=None, alert_notifier_id=None, alert_policy_id=None,
                 monitor_samples=None, start_execution_time=None):
        # Specifies whether to create an alert rule.
        # 
        # *   1: creates an alert.
        # *   0: does not create an alert.
        self.alarm_flag = alarm_flag  # type: str
        # The alert parameters.
        self.alert_list = alert_list  # type: list[CreateSyntheticTaskRequestCommonParamAlertList]
        # The ID of the alert recipient. Separate multiple recipients with commas (,).
        self.alert_notifier_id = alert_notifier_id  # type: str
        # The ID of the notification policy.
        self.alert_policy_id = alert_policy_id  # type: str
        # Specifies whether to evenly distribute monitoring samples. Valid values:
        # 
        # *   0: no
        # *   1: yes
        self.monitor_samples = monitor_samples  # type: long
        # The time when execution starts.
        self.start_execution_time = start_execution_time  # type: long

    def validate(self):
        if self.alert_list:
            for k in self.alert_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateSyntheticTaskRequestCommonParam, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_flag is not None:
            result['AlarmFlag'] = self.alarm_flag
        result['AlertList'] = []
        if self.alert_list is not None:
            for k in self.alert_list:
                result['AlertList'].append(k.to_map() if k else None)
        if self.alert_notifier_id is not None:
            result['AlertNotifierId'] = self.alert_notifier_id
        if self.alert_policy_id is not None:
            result['AlertPolicyId'] = self.alert_policy_id
        if self.monitor_samples is not None:
            result['MonitorSamples'] = self.monitor_samples
        if self.start_execution_time is not None:
            result['StartExecutionTime'] = self.start_execution_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlarmFlag') is not None:
            self.alarm_flag = m.get('AlarmFlag')
        self.alert_list = []
        if m.get('AlertList') is not None:
            for k in m.get('AlertList'):
                temp_model = CreateSyntheticTaskRequestCommonParamAlertList()
                self.alert_list.append(temp_model.from_map(k))
        if m.get('AlertNotifierId') is not None:
            self.alert_notifier_id = m.get('AlertNotifierId')
        if m.get('AlertPolicyId') is not None:
            self.alert_policy_id = m.get('AlertPolicyId')
        if m.get('MonitorSamples') is not None:
            self.monitor_samples = m.get('MonitorSamples')
        if m.get('StartExecutionTime') is not None:
            self.start_execution_time = m.get('StartExecutionTime')
        return self


class CreateSyntheticTaskRequestDownload(TeaModel):
    def __init__(self, connection_timeout=None, download_custom_header_content=None, download_custom_host=None,
                 download_custom_host_ip=None, download_ignore_certificate_error=None, download_kernel=None, download_redirection=None,
                 download_transmission_size=None, monitor_timeout=None, quick_protocol=None, validate_keywords=None, verify_way=None,
                 white_list=None):
        # The connection timeout period.
        self.connection_timeout = connection_timeout  # type: float
        # The items to be ignored in a certificate error. Pass the values of the check boxes that are separated with vertical bars (|).
        self.download_custom_header_content = download_custom_header_content  # type: str
        # The custom host mode.
        # 
        # *   1: round robin
        # *   0: random
        self.download_custom_host = download_custom_host  # type: long
        # The custom host IP address. You can enter multiple IP addresses. Separate the IP addresses with commas (,).
        self.download_custom_host_ip = download_custom_host_ip  # type: str
        # The items to be ignored in a certificate error. Pass the values of the check boxes that are separated with vertical bars (|).
        self.download_ignore_certificate_error = download_ignore_certificate_error  # type: str
        # The kernel type.
        # 
        # *   1: curl
        # *   0: WinInet
        self.download_kernel = download_kernel  # type: long
        # Specifies whether to support redirection.
        self.download_redirection = download_redirection  # type: long
        # The size of the download file. Unit: KB.
        self.download_transmission_size = download_transmission_size  # type: long
        # The monitoring duration.
        self.monitor_timeout = monitor_timeout  # type: long
        # The QUIC protocol type.
        # 
        # *   1: http1
        # *   2: http2
        # *   3: http3
        self.quick_protocol = quick_protocol  # type: str
        # The keyword that is used in verification.
        self.validate_keywords = validate_keywords  # type: str
        # The verification method.
        # 
        # *   0: no verification
        # *   1: string verification
        # *   2: MD5 verification
        self.verify_way = verify_way  # type: long
        # The whitelist for DNS hijacking.
        self.white_list = white_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSyntheticTaskRequestDownload, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_timeout is not None:
            result['ConnectionTimeout'] = self.connection_timeout
        if self.download_custom_header_content is not None:
            result['DownloadCustomHeaderContent'] = self.download_custom_header_content
        if self.download_custom_host is not None:
            result['DownloadCustomHost'] = self.download_custom_host
        if self.download_custom_host_ip is not None:
            result['DownloadCustomHostIp'] = self.download_custom_host_ip
        if self.download_ignore_certificate_error is not None:
            result['DownloadIgnoreCertificateError'] = self.download_ignore_certificate_error
        if self.download_kernel is not None:
            result['DownloadKernel'] = self.download_kernel
        if self.download_redirection is not None:
            result['DownloadRedirection'] = self.download_redirection
        if self.download_transmission_size is not None:
            result['DownloadTransmissionSize'] = self.download_transmission_size
        if self.monitor_timeout is not None:
            result['MonitorTimeout'] = self.monitor_timeout
        if self.quick_protocol is not None:
            result['QuickProtocol'] = self.quick_protocol
        if self.validate_keywords is not None:
            result['ValidateKeywords'] = self.validate_keywords
        if self.verify_way is not None:
            result['VerifyWay'] = self.verify_way
        if self.white_list is not None:
            result['WhiteList'] = self.white_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConnectionTimeout') is not None:
            self.connection_timeout = m.get('ConnectionTimeout')
        if m.get('DownloadCustomHeaderContent') is not None:
            self.download_custom_header_content = m.get('DownloadCustomHeaderContent')
        if m.get('DownloadCustomHost') is not None:
            self.download_custom_host = m.get('DownloadCustomHost')
        if m.get('DownloadCustomHostIp') is not None:
            self.download_custom_host_ip = m.get('DownloadCustomHostIp')
        if m.get('DownloadIgnoreCertificateError') is not None:
            self.download_ignore_certificate_error = m.get('DownloadIgnoreCertificateError')
        if m.get('DownloadKernel') is not None:
            self.download_kernel = m.get('DownloadKernel')
        if m.get('DownloadRedirection') is not None:
            self.download_redirection = m.get('DownloadRedirection')
        if m.get('DownloadTransmissionSize') is not None:
            self.download_transmission_size = m.get('DownloadTransmissionSize')
        if m.get('MonitorTimeout') is not None:
            self.monitor_timeout = m.get('MonitorTimeout')
        if m.get('QuickProtocol') is not None:
            self.quick_protocol = m.get('QuickProtocol')
        if m.get('ValidateKeywords') is not None:
            self.validate_keywords = m.get('ValidateKeywords')
        if m.get('VerifyWay') is not None:
            self.verify_way = m.get('VerifyWay')
        if m.get('WhiteList') is not None:
            self.white_list = m.get('WhiteList')
        return self


class CreateSyntheticTaskRequestExtendInterval(TeaModel):
    def __init__(self, days=None, end_hour=None, end_minute=None, end_time=None, start_hour=None, start_minute=None,
                 start_time=None):
        # The day on which synthetic monitoring is performed.
        self.days = days  # type: list[long]
        # The hour at which synthetic monitoring ends.
        self.end_hour = end_hour  # type: long
        # The minute at which synthetic monitoring ends.
        self.end_minute = end_minute  # type: long
        # The time when synthetic monitoring ends. The format is `yyyy-MM-dd HH`.
        self.end_time = end_time  # type: str
        # The hour at which synthetic monitoring starts.
        self.start_hour = start_hour  # type: long
        # The minute at which synthetic monitoring starts.
        self.start_minute = start_minute  # type: long
        # The time when synthetic monitoring starts. The format is `yyyy-MM-dd HH`.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSyntheticTaskRequestExtendInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.days is not None:
            result['Days'] = self.days
        if self.end_hour is not None:
            result['EndHour'] = self.end_hour
        if self.end_minute is not None:
            result['EndMinute'] = self.end_minute
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_hour is not None:
            result['StartHour'] = self.start_hour
        if self.start_minute is not None:
            result['StartMinute'] = self.start_minute
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Days') is not None:
            self.days = m.get('Days')
        if m.get('EndHour') is not None:
            self.end_hour = m.get('EndHour')
        if m.get('EndMinute') is not None:
            self.end_minute = m.get('EndMinute')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartHour') is not None:
            self.start_hour = m.get('StartHour')
        if m.get('StartMinute') is not None:
            self.start_minute = m.get('StartMinute')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class CreateSyntheticTaskRequestMonitorList(TeaModel):
    def __init__(self, city_code=None, monitor_type=None, net_service_id=None):
        # The ID of the city to which the monitoring point belongs.
        self.city_code = city_code  # type: long
        # The carrier type:
        # 
        # *   IDC
        # *   LastMilie
        self.monitor_type = monitor_type  # type: long
        # The ID of the carrier.
        self.net_service_id = net_service_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSyntheticTaskRequestMonitorList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['CityCode'] = self.city_code
        if self.monitor_type is not None:
            result['MonitorType'] = self.monitor_type
        if self.net_service_id is not None:
            result['NetServiceId'] = self.net_service_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CityCode') is not None:
            self.city_code = m.get('CityCode')
        if m.get('MonitorType') is not None:
            self.monitor_type = m.get('MonitorType')
        if m.get('NetServiceId') is not None:
            self.net_service_id = m.get('NetServiceId')
        return self


class CreateSyntheticTaskRequestNavigation(TeaModel):
    def __init__(self, dnshijack_white_list=None, element_blacklist=None, execute_active_x=None,
                 execute_application=None, execute_script=None, filter_invalid_ip=None, flow_hijack_jump_times=None,
                 flow_hijack_logo=None, monitor_timeout=None, nav_automatic_scrolling=None, nav_custom_header=None,
                 nav_custom_header_content=None, nav_custom_host=None, nav_custom_host_ip=None, nav_disable_cache=None,
                 nav_disable_compression=None, nav_ignore_certificate_error=None, nav_redirection=None, nav_return_element=None,
                 page_tamper=None, process_name=None, quicdomain=None, quicversion=None, request_header=None,
                 response_header=None, slow_element_threshold=None, verify_string_blacklist=None, verify_string_white_list=None,
                 wait_completion_time=None):
        # The whitelist for DNS hijacking.
        self.dnshijack_white_list = dnshijack_white_list  # type: str
        # The element blacklist.
        self.element_blacklist = element_blacklist  # type: str
        # Specifies whether to execute ActiveX.
        # 
        # *   3: yes
        # *   0: no
        # 
        # >  This parameter is supported only by IE Full Elements.
        self.execute_active_x = execute_active_x  # type: long
        # Specifies whether to run applets.
        # 
        # *   1: yes
        # *   0: no
        # 
        # >  This parameter is supported only by IE Full Elements.
        self.execute_application = execute_application  # type: long
        # Specifies whether to execute scripts.
        # 
        # *   1: yes
        # *   0: no
        # 
        # >  This parameter is supported only by IE Full Elements.
        self.execute_script = execute_script  # type: long
        # Specifies whether to filter invalid IP addresses.
        # 
        # *   1: no
        # *   0: yes
        self.filter_invalid_ip = filter_invalid_ip  # type: long
        # The element that is used in DNS hijacking.
        self.flow_hijack_jump_times = flow_hijack_jump_times  # type: long
        # The tag that is used in DNS hijacking.
        self.flow_hijack_logo = flow_hijack_logo  # type: str
        # The timeout period of monitoring. Unit: seconds.
        self.monitor_timeout = monitor_timeout  # type: str
        # Specifies whether to automatically scroll up and down the screen to load a page.
        # 
        # *   1: yes
        # *   0: no
        self.nav_automatic_scrolling = nav_automatic_scrolling  # type: str
        # The method that is used to customize the header. Valid values:
        # 
        # *   0: disables the customer header.
        # *   1: modifies the first package.
        # *   2: modifies all packages.
        self.nav_custom_header = nav_custom_header  # type: str
        # The format of the custom header. You can specify multiple fields. Separate the fields with vertical bars (|).
        self.nav_custom_header_content = nav_custom_header_content  # type: str
        # The custom host mode.
        # 
        # *   1: round robin
        # *   0: random
        self.nav_custom_host = nav_custom_host  # type: long
        # The custom host IP address. You can enter multiple IP addresses. Separate the IP addresses with commas (,).
        self.nav_custom_host_ip = nav_custom_host_ip  # type: str
        # Specifies whether to disable caching.
        # 
        # *   1: disable
        # *   0: enable
        self.nav_disable_cache = nav_disable_cache  # type: long
        # Specifies whether to enable the feature of using the Accept-Encoding field to determine whether to accept compressed files.
        # 
        # *   1: disable
        # *   0: enable
        self.nav_disable_compression = nav_disable_compression  # type: str
        # Specifies whether to ignore certificate errors during certificate verification in the SSL handshake and continue browsing.
        # 
        # *   1: ignore
        # *   0: does not ignore
        self.nav_ignore_certificate_error = nav_ignore_certificate_error  # type: long
        # Specifies whether to continue browsing after a redirection occurs.
        # 
        # *   1: yes
        # *   0: no
        self.nav_redirection = nav_redirection  # type: long
        # Specifies whether to return the elements on the page.
        # 
        # *   1: no. Returns the basic document data.
        # *   2: yes. Returns all document data.
        self.nav_return_element = nav_return_element  # type: long
        # The web page defacement.
        self.page_tamper = page_tamper  # type: str
        # The process ID.
        self.process_name = process_name  # type: str
        # The domain name of the QUIC request element.
        # 
        # >  This parameter is supported by all elements of only Chrome
        self.quicdomain = quicdomain  # type: str
        # The Quick UDP Internet Connections (QUIC) protocol version. Default value: 0. Valid values:
        # 
        # *\
        # *   35
        # *   39
        # *   43
        # *   44
        # 
        # >  This parameter is supported by all elements of only Chrome
        self.quicversion = quicversion  # type: long
        # Specifies whether to return the request header.
        # 
        # *   0: does not return the response header.
        # *   1: returns the basic document header.
        # *   2: returns all headers.
        self.request_header = request_header  # type: long
        # The method that is used to return the response header. Valid values:
        # 
        # *   0: does not return the response header.
        # *   1: returns the basic document header.
        # *   2: returns all headers.
        self.response_header = response_header  # type: long
        # The time threshold that is used to define a slow element. Unit: seconds.
        self.slow_element_threshold = slow_element_threshold  # type: float
        # The blacklist for string verification.
        self.verify_string_blacklist = verify_string_blacklist  # type: str
        # The whitelist for string verification.
        self.verify_string_white_list = verify_string_white_list  # type: str
        # The timeout period of waiting for the monitoring to complete.
        self.wait_completion_time = wait_completion_time  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSyntheticTaskRequestNavigation, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dnshijack_white_list is not None:
            result['DNSHijackWhiteList'] = self.dnshijack_white_list
        if self.element_blacklist is not None:
            result['ElementBlacklist'] = self.element_blacklist
        if self.execute_active_x is not None:
            result['ExecuteActiveX'] = self.execute_active_x
        if self.execute_application is not None:
            result['ExecuteApplication'] = self.execute_application
        if self.execute_script is not None:
            result['ExecuteScript'] = self.execute_script
        if self.filter_invalid_ip is not None:
            result['FilterInvalidIP'] = self.filter_invalid_ip
        if self.flow_hijack_jump_times is not None:
            result['FlowHijackJumpTimes'] = self.flow_hijack_jump_times
        if self.flow_hijack_logo is not None:
            result['FlowHijackLogo'] = self.flow_hijack_logo
        if self.monitor_timeout is not None:
            result['MonitorTimeout'] = self.monitor_timeout
        if self.nav_automatic_scrolling is not None:
            result['NavAutomaticScrolling'] = self.nav_automatic_scrolling
        if self.nav_custom_header is not None:
            result['NavCustomHeader'] = self.nav_custom_header
        if self.nav_custom_header_content is not None:
            result['NavCustomHeaderContent'] = self.nav_custom_header_content
        if self.nav_custom_host is not None:
            result['NavCustomHost'] = self.nav_custom_host
        if self.nav_custom_host_ip is not None:
            result['NavCustomHostIp'] = self.nav_custom_host_ip
        if self.nav_disable_cache is not None:
            result['NavDisableCache'] = self.nav_disable_cache
        if self.nav_disable_compression is not None:
            result['NavDisableCompression'] = self.nav_disable_compression
        if self.nav_ignore_certificate_error is not None:
            result['NavIgnoreCertificateError'] = self.nav_ignore_certificate_error
        if self.nav_redirection is not None:
            result['NavRedirection'] = self.nav_redirection
        if self.nav_return_element is not None:
            result['NavReturnElement'] = self.nav_return_element
        if self.page_tamper is not None:
            result['PageTamper'] = self.page_tamper
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.quicdomain is not None:
            result['QUICDomain'] = self.quicdomain
        if self.quicversion is not None:
            result['QUICVersion'] = self.quicversion
        if self.request_header is not None:
            result['RequestHeader'] = self.request_header
        if self.response_header is not None:
            result['ResponseHeader'] = self.response_header
        if self.slow_element_threshold is not None:
            result['SlowElementThreshold'] = self.slow_element_threshold
        if self.verify_string_blacklist is not None:
            result['VerifyStringBlacklist'] = self.verify_string_blacklist
        if self.verify_string_white_list is not None:
            result['VerifyStringWhiteList'] = self.verify_string_white_list
        if self.wait_completion_time is not None:
            result['WaitCompletionTime'] = self.wait_completion_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DNSHijackWhiteList') is not None:
            self.dnshijack_white_list = m.get('DNSHijackWhiteList')
        if m.get('ElementBlacklist') is not None:
            self.element_blacklist = m.get('ElementBlacklist')
        if m.get('ExecuteActiveX') is not None:
            self.execute_active_x = m.get('ExecuteActiveX')
        if m.get('ExecuteApplication') is not None:
            self.execute_application = m.get('ExecuteApplication')
        if m.get('ExecuteScript') is not None:
            self.execute_script = m.get('ExecuteScript')
        if m.get('FilterInvalidIP') is not None:
            self.filter_invalid_ip = m.get('FilterInvalidIP')
        if m.get('FlowHijackJumpTimes') is not None:
            self.flow_hijack_jump_times = m.get('FlowHijackJumpTimes')
        if m.get('FlowHijackLogo') is not None:
            self.flow_hijack_logo = m.get('FlowHijackLogo')
        if m.get('MonitorTimeout') is not None:
            self.monitor_timeout = m.get('MonitorTimeout')
        if m.get('NavAutomaticScrolling') is not None:
            self.nav_automatic_scrolling = m.get('NavAutomaticScrolling')
        if m.get('NavCustomHeader') is not None:
            self.nav_custom_header = m.get('NavCustomHeader')
        if m.get('NavCustomHeaderContent') is not None:
            self.nav_custom_header_content = m.get('NavCustomHeaderContent')
        if m.get('NavCustomHost') is not None:
            self.nav_custom_host = m.get('NavCustomHost')
        if m.get('NavCustomHostIp') is not None:
            self.nav_custom_host_ip = m.get('NavCustomHostIp')
        if m.get('NavDisableCache') is not None:
            self.nav_disable_cache = m.get('NavDisableCache')
        if m.get('NavDisableCompression') is not None:
            self.nav_disable_compression = m.get('NavDisableCompression')
        if m.get('NavIgnoreCertificateError') is not None:
            self.nav_ignore_certificate_error = m.get('NavIgnoreCertificateError')
        if m.get('NavRedirection') is not None:
            self.nav_redirection = m.get('NavRedirection')
        if m.get('NavReturnElement') is not None:
            self.nav_return_element = m.get('NavReturnElement')
        if m.get('PageTamper') is not None:
            self.page_tamper = m.get('PageTamper')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('QUICDomain') is not None:
            self.quicdomain = m.get('QUICDomain')
        if m.get('QUICVersion') is not None:
            self.quicversion = m.get('QUICVersion')
        if m.get('RequestHeader') is not None:
            self.request_header = m.get('RequestHeader')
        if m.get('ResponseHeader') is not None:
            self.response_header = m.get('ResponseHeader')
        if m.get('SlowElementThreshold') is not None:
            self.slow_element_threshold = m.get('SlowElementThreshold')
        if m.get('VerifyStringBlacklist') is not None:
            self.verify_string_blacklist = m.get('VerifyStringBlacklist')
        if m.get('VerifyStringWhiteList') is not None:
            self.verify_string_white_list = m.get('VerifyStringWhiteList')
        if m.get('WaitCompletionTime') is not None:
            self.wait_completion_time = m.get('WaitCompletionTime')
        return self


class CreateSyntheticTaskRequestNet(TeaModel):
    def __init__(self, net_dnsns=None, net_dnsquery_method=None, net_dnsserver=None, net_dnsswitch=None,
                 net_dnstimeout=None, net_dig_switch=None, net_icmpactive=None, net_icmpdata_cut=None, net_icmpinterval=None,
                 net_icmpnum=None, net_icmpsize=None, net_icmpswitch=None, net_icmptimeout=None, net_trace_route_num=None,
                 net_trace_route_switch=None, net_trace_route_timeout=None, white_list=None):
        # The DNS server.
        self.net_dnsns = net_dnsns  # type: str
        # The DNS query method. Valid values:
        # 
        # *   1: recursion
        # *   2: iteration
        self.net_dnsquery_method = net_dnsquery_method  # type: long
        # The IP address type of the DNS server.
        # 
        # *   0: IPv4
        # *   1: IPv6
        # *   2: an automatic IP address
        self.net_dnsserver = net_dnsserver  # type: long
        # Specifies whether to enable domain name system (DNS) monitoring.
        # 
        # *   0: Off.
        # *   1: On. You must set DNS parameters if you want to enable DNS monitoring.
        self.net_dnsswitch = net_dnsswitch  # type: long
        # The timeout period of DNS monitoring. Default value: 5 seconds. Valid values: 0 to 45 seconds.
        self.net_dnstimeout = net_dnstimeout  # type: long
        # Specifies whether to display the data in the DIG format. Valid values:
        # 
        # *   0: no
        # *   1: yes
        self.net_dig_switch = net_dig_switch  # type: long
        # The protocol type. Valid values:
        # 
        # *   0: ICMP
        # *   1: TCP
        self.net_icmpactive = net_icmpactive  # type: long
        # Specifies whether to split packages.
        # 
        # *   0: no
        # *   1: yes
        self.net_icmpdata_cut = net_icmpdata_cut  # type: long
        # The interval at which the network synthetic monitoring task is executed. Unit: seconds.
        self.net_icmpinterval = net_icmpinterval  # type: long
        # The number of packages.
        self.net_icmpnum = net_icmpnum  # type: long
        # The package size.
        self.net_icmpsize = net_icmpsize  # type: long
        # Specifies whether to enable ping monitoring.
        # 
        # *   0: Off.
        # *   1: On. You must set Internet control message protocol (ICMP) parameters if you want to enable ping monitoring.
        self.net_icmpswitch = net_icmpswitch  # type: long
        # The timeout period of Ping monitoring.
        self.net_icmptimeout = net_icmptimeout  # type: long
        # The maximum number of active monitoring points.
        self.net_trace_route_num = net_trace_route_num  # type: long
        # Specifies whether to enable tracert monitoring.
        # 
        # *   0: Off.
        # *   1: On. You must set the tracert parameters if you want to enable tracert monitoring.
        self.net_trace_route_switch = net_trace_route_switch  # type: long
        # The timeout period of tracert monitoring. Valid values: 0 to 300 seconds.
        self.net_trace_route_timeout = net_trace_route_timeout  # type: long
        # The whitelist for DNS hijacking. The format is `Domain name: Matching rule`.
        # 
        # >  Wireless application protocol (WAP) networks do not support DNS hijacking.
        self.white_list = white_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSyntheticTaskRequestNet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.net_dnsns is not None:
            result['NetDNSNs'] = self.net_dnsns
        if self.net_dnsquery_method is not None:
            result['NetDNSQueryMethod'] = self.net_dnsquery_method
        if self.net_dnsserver is not None:
            result['NetDNSServer'] = self.net_dnsserver
        if self.net_dnsswitch is not None:
            result['NetDNSSwitch'] = self.net_dnsswitch
        if self.net_dnstimeout is not None:
            result['NetDNSTimeout'] = self.net_dnstimeout
        if self.net_dig_switch is not None:
            result['NetDigSwitch'] = self.net_dig_switch
        if self.net_icmpactive is not None:
            result['NetICMPActive'] = self.net_icmpactive
        if self.net_icmpdata_cut is not None:
            result['NetICMPDataCut'] = self.net_icmpdata_cut
        if self.net_icmpinterval is not None:
            result['NetICMPInterval'] = self.net_icmpinterval
        if self.net_icmpnum is not None:
            result['NetICMPNum'] = self.net_icmpnum
        if self.net_icmpsize is not None:
            result['NetICMPSize'] = self.net_icmpsize
        if self.net_icmpswitch is not None:
            result['NetICMPSwitch'] = self.net_icmpswitch
        if self.net_icmptimeout is not None:
            result['NetICMPTimeout'] = self.net_icmptimeout
        if self.net_trace_route_num is not None:
            result['NetTraceRouteNum'] = self.net_trace_route_num
        if self.net_trace_route_switch is not None:
            result['NetTraceRouteSwitch'] = self.net_trace_route_switch
        if self.net_trace_route_timeout is not None:
            result['NetTraceRouteTimeout'] = self.net_trace_route_timeout
        if self.white_list is not None:
            result['WhiteList'] = self.white_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NetDNSNs') is not None:
            self.net_dnsns = m.get('NetDNSNs')
        if m.get('NetDNSQueryMethod') is not None:
            self.net_dnsquery_method = m.get('NetDNSQueryMethod')
        if m.get('NetDNSServer') is not None:
            self.net_dnsserver = m.get('NetDNSServer')
        if m.get('NetDNSSwitch') is not None:
            self.net_dnsswitch = m.get('NetDNSSwitch')
        if m.get('NetDNSTimeout') is not None:
            self.net_dnstimeout = m.get('NetDNSTimeout')
        if m.get('NetDigSwitch') is not None:
            self.net_dig_switch = m.get('NetDigSwitch')
        if m.get('NetICMPActive') is not None:
            self.net_icmpactive = m.get('NetICMPActive')
        if m.get('NetICMPDataCut') is not None:
            self.net_icmpdata_cut = m.get('NetICMPDataCut')
        if m.get('NetICMPInterval') is not None:
            self.net_icmpinterval = m.get('NetICMPInterval')
        if m.get('NetICMPNum') is not None:
            self.net_icmpnum = m.get('NetICMPNum')
        if m.get('NetICMPSize') is not None:
            self.net_icmpsize = m.get('NetICMPSize')
        if m.get('NetICMPSwitch') is not None:
            self.net_icmpswitch = m.get('NetICMPSwitch')
        if m.get('NetICMPTimeout') is not None:
            self.net_icmptimeout = m.get('NetICMPTimeout')
        if m.get('NetTraceRouteNum') is not None:
            self.net_trace_route_num = m.get('NetTraceRouteNum')
        if m.get('NetTraceRouteSwitch') is not None:
            self.net_trace_route_switch = m.get('NetTraceRouteSwitch')
        if m.get('NetTraceRouteTimeout') is not None:
            self.net_trace_route_timeout = m.get('NetTraceRouteTimeout')
        if m.get('WhiteList') is not None:
            self.white_list = m.get('WhiteList')
        return self


class CreateSyntheticTaskRequestProtocolRequestContentBodyFormData(TeaModel):
    def __init__(self, key=None, value=None):
        # The key of **form-data**.
        self.key = key  # type: str
        # The value of **form-data**.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSyntheticTaskRequestProtocolRequestContentBodyFormData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateSyntheticTaskRequestProtocolRequestContentBodyUrlEncoding(TeaModel):
    def __init__(self, key=None, value=None):
        # The key of **x-www-form-urlencoded**.
        self.key = key  # type: str
        # The value of **x-www-form-urlencoded**.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSyntheticTaskRequestProtocolRequestContentBodyUrlEncoding, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateSyntheticTaskRequestProtocolRequestContentBody(TeaModel):
    def __init__(self, form_data=None, language=None, mode=None, raw=None, url_encoding=None):
        # The data that is passed when the **Mode** parameter is set to **form-data**.
        self.form_data = form_data  # type: list[CreateSyntheticTaskRequestProtocolRequestContentBodyFormData]
        # The language that is selected when the Mode parameter is set to raw.
        # 
        # *   json
        # *   xml
        # *   javascript
        # *   html
        # *   text
        self.language = language  # type: str
        # The data type of the content.
        # 
        # *   form-data
        # *   x-www-form-urlencoded
        # *   raw
        self.mode = mode  # type: str
        # The data that is passed when the **Mode** parameter is set to **raw**.
        self.raw = raw  # type: str
        # The data that is passed when the **Mode** parameter is set to **x-www-form-urlencoded**.
        self.url_encoding = url_encoding  # type: list[CreateSyntheticTaskRequestProtocolRequestContentBodyUrlEncoding]

    def validate(self):
        if self.form_data:
            for k in self.form_data:
                if k:
                    k.validate()
        if self.url_encoding:
            for k in self.url_encoding:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateSyntheticTaskRequestProtocolRequestContentBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FormData'] = []
        if self.form_data is not None:
            for k in self.form_data:
                result['FormData'].append(k.to_map() if k else None)
        if self.language is not None:
            result['Language'] = self.language
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.raw is not None:
            result['Raw'] = self.raw
        result['UrlEncoding'] = []
        if self.url_encoding is not None:
            for k in self.url_encoding:
                result['UrlEncoding'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.form_data = []
        if m.get('FormData') is not None:
            for k in m.get('FormData'):
                temp_model = CreateSyntheticTaskRequestProtocolRequestContentBodyFormData()
                self.form_data.append(temp_model.from_map(k))
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Raw') is not None:
            self.raw = m.get('Raw')
        self.url_encoding = []
        if m.get('UrlEncoding') is not None:
            for k in m.get('UrlEncoding'):
                temp_model = CreateSyntheticTaskRequestProtocolRequestContentBodyUrlEncoding()
                self.url_encoding.append(temp_model.from_map(k))
        return self


class CreateSyntheticTaskRequestProtocolRequestContentHeader(TeaModel):
    def __init__(self, key=None, value=None):
        # The key of the request header.
        self.key = key  # type: str
        # The value of the request header.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSyntheticTaskRequestProtocolRequestContentHeader, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateSyntheticTaskRequestProtocolRequestContent(TeaModel):
    def __init__(self, body=None, header=None, method=None):
        # The custom body of a request to initiate an API performance synthetic monitoring task.
        self.body = body  # type: CreateSyntheticTaskRequestProtocolRequestContentBody
        # The custom header of a request to initiate an API performance synthetic monitoring task.
        self.header = header  # type: list[CreateSyntheticTaskRequestProtocolRequestContentHeader]
        # The request method.
        # 
        # *   POST
        # *   GET
        self.method = method  # type: str

    def validate(self):
        if self.body:
            self.body.validate()
        if self.header:
            for k in self.header:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateSyntheticTaskRequestProtocolRequestContent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.body is not None:
            result['Body'] = self.body.to_map()
        result['Header'] = []
        if self.header is not None:
            for k in self.header:
                result['Header'].append(k.to_map() if k else None)
        if self.method is not None:
            result['Method'] = self.method
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Body') is not None:
            temp_model = CreateSyntheticTaskRequestProtocolRequestContentBody()
            self.body = temp_model.from_map(m['Body'])
        self.header = []
        if m.get('Header') is not None:
            for k in m.get('Header'):
                temp_model = CreateSyntheticTaskRequestProtocolRequestContentHeader()
                self.header.append(temp_model.from_map(k))
        if m.get('Method') is not None:
            self.method = m.get('Method')
        return self


class CreateSyntheticTaskRequestProtocol(TeaModel):
    def __init__(self, character_encoding=None, custom_host=None, custom_host_ip=None,
                 protocol_connection_time=None, protocol_monitor_timeout=None, received_data_size=None, request_content=None,
                 verify_content=None, verify_way=None):
        # The encoding format.
        # 
        # *   0: UTF-8
        # *   1: GBK
        # *   2: GB2312
        # *   3: Unicode
        self.character_encoding = character_encoding  # type: long
        # The custom host mode.
        # 
        # *   1: round robin
        # *   0: random
        self.custom_host = custom_host  # type: long
        # The custom host IP address. You can enter multiple IP addresses. Separate the IP addresses with commas (,).
        self.custom_host_ip = custom_host_ip  # type: str
        # The connection timeout period of the protocol. Unit: seconds.
        self.protocol_connection_time = protocol_connection_time  # type: long
        # The timeout period of API performance synthetic monitoring. Unit: seconds.
        self.protocol_monitor_timeout = protocol_monitor_timeout  # type: str
        # The size of the received data. This parameter is required when you set the value of the VerifyWay parameter to 2.
        self.received_data_size = received_data_size  # type: long
        # The request content, including the request header and request body.
        self.request_content = request_content  # type: CreateSyntheticTaskRequestProtocolRequestContent
        # The verification string.
        self.verify_content = verify_content  # type: str
        # The method that is used to verify the response content.
        # 
        # *   0: no verification.
        # *   1: exact match with the verification string.
        # *   2: partial match with the verification string.
        # *   3: MD5 verification.
        self.verify_way = verify_way  # type: long

    def validate(self):
        if self.request_content:
            self.request_content.validate()

    def to_map(self):
        _map = super(CreateSyntheticTaskRequestProtocol, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.character_encoding is not None:
            result['CharacterEncoding'] = self.character_encoding
        if self.custom_host is not None:
            result['CustomHost'] = self.custom_host
        if self.custom_host_ip is not None:
            result['CustomHostIp'] = self.custom_host_ip
        if self.protocol_connection_time is not None:
            result['ProtocolConnectionTime'] = self.protocol_connection_time
        if self.protocol_monitor_timeout is not None:
            result['ProtocolMonitorTimeout'] = self.protocol_monitor_timeout
        if self.received_data_size is not None:
            result['ReceivedDataSize'] = self.received_data_size
        if self.request_content is not None:
            result['RequestContent'] = self.request_content.to_map()
        if self.verify_content is not None:
            result['VerifyContent'] = self.verify_content
        if self.verify_way is not None:
            result['VerifyWay'] = self.verify_way
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CharacterEncoding') is not None:
            self.character_encoding = m.get('CharacterEncoding')
        if m.get('CustomHost') is not None:
            self.custom_host = m.get('CustomHost')
        if m.get('CustomHostIp') is not None:
            self.custom_host_ip = m.get('CustomHostIp')
        if m.get('ProtocolConnectionTime') is not None:
            self.protocol_connection_time = m.get('ProtocolConnectionTime')
        if m.get('ProtocolMonitorTimeout') is not None:
            self.protocol_monitor_timeout = m.get('ProtocolMonitorTimeout')
        if m.get('ReceivedDataSize') is not None:
            self.received_data_size = m.get('ReceivedDataSize')
        if m.get('RequestContent') is not None:
            temp_model = CreateSyntheticTaskRequestProtocolRequestContent()
            self.request_content = temp_model.from_map(m['RequestContent'])
        if m.get('VerifyContent') is not None:
            self.verify_content = m.get('VerifyContent')
        if m.get('VerifyWay') is not None:
            self.verify_way = m.get('VerifyWay')
        return self


class CreateSyntheticTaskRequest(TeaModel):
    def __init__(self, common_param=None, download=None, extend_interval=None, interval_time=None,
                 interval_type=None, ip_type=None, monitor_list=None, navigation=None, net=None, protocol=None, region_id=None,
                 task_name=None, task_type=None, update_task=None, url=None):
        # The common parameters.
        self.common_param = common_param  # type: CreateSyntheticTaskRequestCommonParam
        # The file download task.
        self.download = download  # type: CreateSyntheticTaskRequestDownload
        # The frequency.
        self.extend_interval = extend_interval  # type: CreateSyntheticTaskRequestExtendInterval
        # The interval at which synthetic monitoring is performed. Unit: minutes. Valid values:
        # 
        # *   1
        # *   5
        # *   10
        # *   15
        # *   20
        # *   30
        # *   60
        # *   120
        # *   180
        # *   240
        # *   360
        # *   480
        # *   720
        # *   1440
        self.interval_time = interval_time  # type: str
        # The interval type.
        # 
        # *   0: daily
        # *   1: custom frequency
        self.interval_type = interval_type  # type: str
        # The IP address type:
        # 
        # *   0: an automatic IP address
        # *   1: IPv4
        # *   2: IPv6
        self.ip_type = ip_type  # type: long
        # The list of monitoring points.
        self.monitor_list = monitor_list  # type: list[CreateSyntheticTaskRequestMonitorList]
        # The monitoring items that are associated with the browse tasks.
        self.navigation = navigation  # type: CreateSyntheticTaskRequestNavigation
        # The network synthetic monitoring task.
        self.net = net  # type: CreateSyntheticTaskRequestNet
        # The API performance synthetic monitoring task.
        self.protocol = protocol  # type: CreateSyntheticTaskRequestProtocol
        # The ID of the region in which the application is located.
        self.region_id = region_id  # type: str
        # The name of the task. To update a synthetic monitoring task, enter the task name and set the **UpdateTask** parameter to **true**.
        self.task_name = task_name  # type: str
        # The type of the monitoring task. Valid values:
        # 
        # 1.  3: web page performance - IE
        # 2.  34: web Page Performance - Chrome
        # 3.  0: network quality
        # 4.  40: file download
        # 5.  7:API performance
        self.task_type = task_type  # type: long
        # Specifies whether to update existing synthetic monitoring tasks.
        # 
        # *   true: updates existing synthetic monitoring tasks.
        # *   false: creates new synthetic monitoring tasks.
        self.update_task = update_task  # type: bool
        # The URL for synthetic monitoring.
        self.url = url  # type: str

    def validate(self):
        if self.common_param:
            self.common_param.validate()
        if self.download:
            self.download.validate()
        if self.extend_interval:
            self.extend_interval.validate()
        if self.monitor_list:
            for k in self.monitor_list:
                if k:
                    k.validate()
        if self.navigation:
            self.navigation.validate()
        if self.net:
            self.net.validate()
        if self.protocol:
            self.protocol.validate()

    def to_map(self):
        _map = super(CreateSyntheticTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_param is not None:
            result['CommonParam'] = self.common_param.to_map()
        if self.download is not None:
            result['Download'] = self.download.to_map()
        if self.extend_interval is not None:
            result['ExtendInterval'] = self.extend_interval.to_map()
        if self.interval_time is not None:
            result['IntervalTime'] = self.interval_time
        if self.interval_type is not None:
            result['IntervalType'] = self.interval_type
        if self.ip_type is not None:
            result['IpType'] = self.ip_type
        result['MonitorList'] = []
        if self.monitor_list is not None:
            for k in self.monitor_list:
                result['MonitorList'].append(k.to_map() if k else None)
        if self.navigation is not None:
            result['Navigation'] = self.navigation.to_map()
        if self.net is not None:
            result['Net'] = self.net.to_map()
        if self.protocol is not None:
            result['Protocol'] = self.protocol.to_map()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.update_task is not None:
            result['UpdateTask'] = self.update_task
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CommonParam') is not None:
            temp_model = CreateSyntheticTaskRequestCommonParam()
            self.common_param = temp_model.from_map(m['CommonParam'])
        if m.get('Download') is not None:
            temp_model = CreateSyntheticTaskRequestDownload()
            self.download = temp_model.from_map(m['Download'])
        if m.get('ExtendInterval') is not None:
            temp_model = CreateSyntheticTaskRequestExtendInterval()
            self.extend_interval = temp_model.from_map(m['ExtendInterval'])
        if m.get('IntervalTime') is not None:
            self.interval_time = m.get('IntervalTime')
        if m.get('IntervalType') is not None:
            self.interval_type = m.get('IntervalType')
        if m.get('IpType') is not None:
            self.ip_type = m.get('IpType')
        self.monitor_list = []
        if m.get('MonitorList') is not None:
            for k in m.get('MonitorList'):
                temp_model = CreateSyntheticTaskRequestMonitorList()
                self.monitor_list.append(temp_model.from_map(k))
        if m.get('Navigation') is not None:
            temp_model = CreateSyntheticTaskRequestNavigation()
            self.navigation = temp_model.from_map(m['Navigation'])
        if m.get('Net') is not None:
            temp_model = CreateSyntheticTaskRequestNet()
            self.net = temp_model.from_map(m['Net'])
        if m.get('Protocol') is not None:
            temp_model = CreateSyntheticTaskRequestProtocol()
            self.protocol = temp_model.from_map(m['Protocol'])
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('UpdateTask') is not None:
            self.update_task = m.get('UpdateTask')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class CreateSyntheticTaskShrinkRequest(TeaModel):
    def __init__(self, common_param_shrink=None, download_shrink=None, extend_interval_shrink=None,
                 interval_time=None, interval_type=None, ip_type=None, monitor_list_shrink=None, navigation_shrink=None,
                 net_shrink=None, protocol_shrink=None, region_id=None, task_name=None, task_type=None, update_task=None,
                 url=None):
        # The common parameters.
        self.common_param_shrink = common_param_shrink  # type: str
        # The file download task.
        self.download_shrink = download_shrink  # type: str
        # The frequency.
        self.extend_interval_shrink = extend_interval_shrink  # type: str
        # The interval at which synthetic monitoring is performed. Unit: minutes. Valid values:
        # 
        # *   1
        # *   5
        # *   10
        # *   15
        # *   20
        # *   30
        # *   60
        # *   120
        # *   180
        # *   240
        # *   360
        # *   480
        # *   720
        # *   1440
        self.interval_time = interval_time  # type: str
        # The interval type.
        # 
        # *   0: daily
        # *   1: custom frequency
        self.interval_type = interval_type  # type: str
        # The IP address type:
        # 
        # *   0: an automatic IP address
        # *   1: IPv4
        # *   2: IPv6
        self.ip_type = ip_type  # type: long
        # The list of monitoring points.
        self.monitor_list_shrink = monitor_list_shrink  # type: str
        # The monitoring items that are associated with the browse tasks.
        self.navigation_shrink = navigation_shrink  # type: str
        # The network synthetic monitoring task.
        self.net_shrink = net_shrink  # type: str
        # The API performance synthetic monitoring task.
        self.protocol_shrink = protocol_shrink  # type: str
        # The ID of the region in which the application is located.
        self.region_id = region_id  # type: str
        # The name of the task. To update a synthetic monitoring task, enter the task name and set the **UpdateTask** parameter to **true**.
        self.task_name = task_name  # type: str
        # The type of the monitoring task. Valid values:
        # 
        # 1.  3: web page performance - IE
        # 2.  34: web Page Performance - Chrome
        # 3.  0: network quality
        # 4.  40: file download
        # 5.  7:API performance
        self.task_type = task_type  # type: long
        # Specifies whether to update existing synthetic monitoring tasks.
        # 
        # *   true: updates existing synthetic monitoring tasks.
        # *   false: creates new synthetic monitoring tasks.
        self.update_task = update_task  # type: bool
        # The URL for synthetic monitoring.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSyntheticTaskShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_param_shrink is not None:
            result['CommonParam'] = self.common_param_shrink
        if self.download_shrink is not None:
            result['Download'] = self.download_shrink
        if self.extend_interval_shrink is not None:
            result['ExtendInterval'] = self.extend_interval_shrink
        if self.interval_time is not None:
            result['IntervalTime'] = self.interval_time
        if self.interval_type is not None:
            result['IntervalType'] = self.interval_type
        if self.ip_type is not None:
            result['IpType'] = self.ip_type
        if self.monitor_list_shrink is not None:
            result['MonitorList'] = self.monitor_list_shrink
        if self.navigation_shrink is not None:
            result['Navigation'] = self.navigation_shrink
        if self.net_shrink is not None:
            result['Net'] = self.net_shrink
        if self.protocol_shrink is not None:
            result['Protocol'] = self.protocol_shrink
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.update_task is not None:
            result['UpdateTask'] = self.update_task
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CommonParam') is not None:
            self.common_param_shrink = m.get('CommonParam')
        if m.get('Download') is not None:
            self.download_shrink = m.get('Download')
        if m.get('ExtendInterval') is not None:
            self.extend_interval_shrink = m.get('ExtendInterval')
        if m.get('IntervalTime') is not None:
            self.interval_time = m.get('IntervalTime')
        if m.get('IntervalType') is not None:
            self.interval_type = m.get('IntervalType')
        if m.get('IpType') is not None:
            self.ip_type = m.get('IpType')
        if m.get('MonitorList') is not None:
            self.monitor_list_shrink = m.get('MonitorList')
        if m.get('Navigation') is not None:
            self.navigation_shrink = m.get('Navigation')
        if m.get('Net') is not None:
            self.net_shrink = m.get('Net')
        if m.get('Protocol') is not None:
            self.protocol_shrink = m.get('Protocol')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('UpdateTask') is not None:
            self.update_task = m.get('UpdateTask')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class CreateSyntheticTaskResponseBodyData(TeaModel):
    def __init__(self, task_id=None):
        # The ID of the synthetic monitoring task.
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSyntheticTaskResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateSyntheticTaskResponseBody(TeaModel):
    def __init__(self, code=None, data=None, msg=None, request_id=None):
        # The status code returned.
        # 
        # *   1001: The request was successful.
        # *   1002: The request failed.
        # *   1003: Parameter errors occurred.
        # *   1004: Authentication failed.
        # *   1006: The task does not exist.
        # *   1099: Internal errors occurred.
        self.code = code  # type: str
        # The information about the synthetic monitoring task.
        self.data = data  # type: CreateSyntheticTaskResponseBodyData
        # The message that is returned when the task failed to be created.
        self.msg = msg  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateSyntheticTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.msg is not None:
            result['Msg'] = self.msg
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateSyntheticTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Msg') is not None:
            self.msg = m.get('Msg')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateSyntheticTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateSyntheticTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateSyntheticTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSyntheticTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateWebhookRequest(TeaModel):
    def __init__(self, body=None, contact_name=None, http_headers=None, http_params=None, method=None,
                 recover_body=None, region_id=None, url=None):
        # The notification template that is sent when an alert is triggered. This parameter is required if the **Method** parameter is set to **Post**. You can use the $content placeholder to specify the notification content. The content cannot exceed 500 characters in length.
        self.body = body  # type: str
        # The name of the contact.
        self.contact_name = contact_name  # type: str
        # The HTTP request header.
        self.http_headers = http_headers  # type: str
        # The parameters in the HTTP request.
        self.http_params = http_params  # type: str
        # The HTTP request method.
        # 
        # *   `Get`
        # *   `Post`
        self.method = method  # type: str
        # The notification template that is sent when an alert is resolved. This parameter is required if the **Method** parameter is set to **Post**. You can use the $content placeholder to specify the notification content. The content cannot exceed 500 characters in length.
        self.recover_body = recover_body  # type: str
        # The region ID.
        self.region_id = region_id  # type: str
        # The URL of the request **method**.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateWebhookRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.body is not None:
            result['Body'] = self.body
        if self.contact_name is not None:
            result['ContactName'] = self.contact_name
        if self.http_headers is not None:
            result['HttpHeaders'] = self.http_headers
        if self.http_params is not None:
            result['HttpParams'] = self.http_params
        if self.method is not None:
            result['Method'] = self.method
        if self.recover_body is not None:
            result['RecoverBody'] = self.recover_body
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Body') is not None:
            self.body = m.get('Body')
        if m.get('ContactName') is not None:
            self.contact_name = m.get('ContactName')
        if m.get('HttpHeaders') is not None:
            self.http_headers = m.get('HttpHeaders')
        if m.get('HttpParams') is not None:
            self.http_params = m.get('HttpParams')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('RecoverBody') is not None:
            self.recover_body = m.get('RecoverBody')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class CreateWebhookResponseBody(TeaModel):
    def __init__(self, contact_id=None, request_id=None):
        # The ID of the contact for webhook alerts.
        self.contact_id = contact_id  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateWebhookResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateWebhookResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateWebhookResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateWebhookResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateWebhookResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DelAuthTokenRequest(TeaModel):
    def __init__(self, cluster_id=None, region_id=None):
        # The ID of the cluster.
        self.cluster_id = cluster_id  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DelAuthTokenRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DelAuthTokenResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # Indicates whether the request was successful.
        self.data = data  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DelAuthTokenResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DelAuthTokenResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DelAuthTokenResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DelAuthTokenResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DelAuthTokenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAlertContactRequest(TeaModel):
    def __init__(self, contact_id=None, region_id=None):
        self.contact_id = contact_id  # type: long
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAlertContactRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteAlertContactResponseBody(TeaModel):
    def __init__(self, is_success=None, request_id=None):
        self.is_success = is_success  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAlertContactResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_success is not None:
            result['IsSuccess'] = self.is_success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsSuccess') is not None:
            self.is_success = m.get('IsSuccess')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAlertContactResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteAlertContactResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteAlertContactResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAlertContactResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAlertContactGroupRequest(TeaModel):
    def __init__(self, contact_group_id=None, region_id=None):
        self.contact_group_id = contact_group_id  # type: long
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAlertContactGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_id is not None:
            result['ContactGroupId'] = self.contact_group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactGroupId') is not None:
            self.contact_group_id = m.get('ContactGroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteAlertContactGroupResponseBody(TeaModel):
    def __init__(self, is_success=None, request_id=None):
        self.is_success = is_success  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAlertContactGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_success is not None:
            result['IsSuccess'] = self.is_success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsSuccess') is not None:
            self.is_success = m.get('IsSuccess')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAlertContactGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteAlertContactGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteAlertContactGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAlertContactGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAlertRuleRequest(TeaModel):
    def __init__(self, alert_id=None):
        # The ID of the alert rule.
        self.alert_id = alert_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAlertRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_id is not None:
            result['AlertId'] = self.alert_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertId') is not None:
            self.alert_id = m.get('AlertId')
        return self


class DeleteAlertRuleResponseBody(TeaModel):
    def __init__(self, is_success=None, request_id=None):
        # Indicates whether the alert rule was successfully deleted.
        # 
        # *   `true`: The specified data is deleted.
        # *   `false`: The specified data fails to be deleted.
        self.is_success = is_success  # type: bool
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAlertRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_success is not None:
            result['IsSuccess'] = self.is_success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsSuccess') is not None:
            self.is_success = m.get('IsSuccess')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAlertRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteAlertRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteAlertRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAlertRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAlertRulesRequest(TeaModel):
    def __init__(self, alert_ids=None, region_id=None):
        # The IDs of the alert rules that you want to delete. The value is a JSON array, for example, `[123, 234]`. You can call the SearchAlertRules operation and view the `Id` parameter in the response to obtain the alert rule ID. For more information, see [SearchAlertRules](~~175825~~).
        self.alert_ids = alert_ids  # type: str
        # The region ID. Default value: `cn-hangzhou`.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAlertRulesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_ids is not None:
            result['AlertIds'] = self.alert_ids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertIds') is not None:
            self.alert_ids = m.get('AlertIds')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteAlertRulesResponseBody(TeaModel):
    def __init__(self, is_success=None, request_id=None):
        # Indicates whether the alert rule was deleted.
        # 
        # *   `true`: The alert rule was deleted.
        # *   `false`: The alert rule failed to be deleted.
        self.is_success = is_success  # type: bool
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAlertRulesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_success is not None:
            result['IsSuccess'] = self.is_success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsSuccess') is not None:
            self.is_success = m.get('IsSuccess')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAlertRulesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteAlertRulesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteAlertRulesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAlertRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCmsExporterRequest(TeaModel):
    def __init__(self, cluster_id=None, region_id=None):
        # The ID of the cluster.
        self.cluster_id = cluster_id  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCmsExporterRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteCmsExporterResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCmsExporterResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCmsExporterResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCmsExporterResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCmsExporterResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCmsExporterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteContactRequest(TeaModel):
    def __init__(self, contact_id=None):
        # The ID of the alert contact.
        self.contact_id = contact_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteContactRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        return self


class DeleteContactResponseBody(TeaModel):
    def __init__(self, is_success=None, request_id=None):
        # Indicates whether the alert contact was successfully deleted.
        # 
        # *   `true`: The specified data is deleted.
        # *   `false`: The specified data fails to be deleted.
        self.is_success = is_success  # type: bool
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteContactResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_success is not None:
            result['IsSuccess'] = self.is_success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsSuccess') is not None:
            self.is_success = m.get('IsSuccess')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteContactResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteContactResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteContactResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteContactResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteContactGroupRequest(TeaModel):
    def __init__(self, contact_group_id=None):
        # The ID of the alert contact group.
        self.contact_group_id = contact_group_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteContactGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_id is not None:
            result['ContactGroupId'] = self.contact_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactGroupId') is not None:
            self.contact_group_id = m.get('ContactGroupId')
        return self


class DeleteContactGroupResponseBody(TeaModel):
    def __init__(self, is_success=None, request_id=None):
        # Indicates whether the alert contact group was deleted.
        # 
        # *   `true`: yes
        # *   `false`: no
        self.is_success = is_success  # type: bool
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteContactGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_success is not None:
            result['IsSuccess'] = self.is_success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsSuccess') is not None:
            self.is_success = m.get('IsSuccess')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteContactGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteContactGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteContactGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteContactGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDispatchRuleRequest(TeaModel):
    def __init__(self, id=None, region_id=None):
        # The ID of the dispatch policy.
        self.id = id  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDispatchRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteDispatchRuleResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Indicates whether the request is successful.
        # 
        # *   `true`: successful
        # *   `false`: failed
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDispatchRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDispatchRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDispatchRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDispatchRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDispatchRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEventBridgeIntegrationRequest(TeaModel):
    def __init__(self, id=None):
        # The ID of the EventBridge integration.
        self.id = id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEventBridgeIntegrationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeleteEventBridgeIntegrationResponseBody(TeaModel):
    def __init__(self, is_success=None, request_id=None):
        # Indicates whether the EventBridge integration is deleted.
        # 
        # *   `true`: The EventBridge integration is deleted.
        # *   `false`: The EventBridge integration fails to be deleted.
        self.is_success = is_success  # type: bool
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEventBridgeIntegrationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_success is not None:
            result['IsSuccess'] = self.is_success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsSuccess') is not None:
            self.is_success = m.get('IsSuccess')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEventBridgeIntegrationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteEventBridgeIntegrationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteEventBridgeIntegrationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEventBridgeIntegrationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGrafanaResourceRequest(TeaModel):
    def __init__(self, cluster_id=None, cluster_name=None, region_id=None):
        # The ID of the cluster.
        self.cluster_id = cluster_id  # type: str
        # The name of the cluster.
        self.cluster_name = cluster_name  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteGrafanaResourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteGrafanaResourceResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The data returned.
        self.data = data  # type: str
        # The ID of the request. You can use the ID to query logs and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteGrafanaResourceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteGrafanaResourceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteGrafanaResourceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteGrafanaResourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteGrafanaResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteIMRobotRequest(TeaModel):
    def __init__(self, robot_id=None):
        # The ID of the IM bot.
        self.robot_id = robot_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteIMRobotRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.robot_id is not None:
            result['RobotId'] = self.robot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RobotId') is not None:
            self.robot_id = m.get('RobotId')
        return self


class DeleteIMRobotResponseBody(TeaModel):
    def __init__(self, is_success=None, request_id=None):
        # Indicates whether the IM bot was successfully deleted.
        # 
        # *   `true`: The specified data is deleted.
        # *   `false`: The specified data fails to be deleted.
        self.is_success = is_success  # type: bool
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteIMRobotResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_success is not None:
            result['IsSuccess'] = self.is_success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsSuccess') is not None:
            self.is_success = m.get('IsSuccess')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteIMRobotResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteIMRobotResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteIMRobotResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteIMRobotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteIntegrationRequest(TeaModel):
    def __init__(self, cluster_id=None, integration=None, region_id=None):
        # The ID of the Container Service for Kubernetes cluster.
        self.cluster_id = cluster_id  # type: str
        # The abbreviation of the software that is supported by Application Real-Time Monitoring Service (ARMS). Valid values (case-insensitive): `ASM`, `IoT`, and `Flink`.
        self.integration = integration  # type: str
        # The region ID of the ARMS instance.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteIntegrationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.integration is not None:
            result['Integration'] = self.integration
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Integration') is not None:
            self.integration = m.get('Integration')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteIntegrationResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # Indicates whether the call was successful.
        self.data = data  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteIntegrationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteIntegrationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteIntegrationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteIntegrationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteIntegrationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteIntegrationsRequest(TeaModel):
    def __init__(self, integration_id=None):
        # The ID of the alert integration.
        self.integration_id = integration_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteIntegrationsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.integration_id is not None:
            result['IntegrationId'] = self.integration_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IntegrationId') is not None:
            self.integration_id = m.get('IntegrationId')
        return self


class DeleteIntegrationsResponseBody(TeaModel):
    def __init__(self, is_success=None, request_id=None):
        # Indicates whether the alert integration was deleted. Valid values:
        # 
        # *   true
        # *   false
        self.is_success = is_success  # type: bool
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteIntegrationsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_success is not None:
            result['IsSuccess'] = self.is_success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsSuccess') is not None:
            self.is_success = m.get('IsSuccess')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteIntegrationsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteIntegrationsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteIntegrationsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteIntegrationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNotificationPolicyRequest(TeaModel):
    def __init__(self, id=None):
        # The ID of the notification policy.
        self.id = id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteNotificationPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeleteNotificationPolicyResponseBody(TeaModel):
    def __init__(self, is_success=None, request_id=None):
        # Indicates whether the notification policy was deleted successfully. Valid values:
        # 
        # *   `true`: The notification policy was deleted successfully.
        # *   `false`: The notification policy failed to be deleted.
        self.is_success = is_success  # type: bool
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteNotificationPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_success is not None:
            result['IsSuccess'] = self.is_success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsSuccess') is not None:
            self.is_success = m.get('IsSuccess')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteNotificationPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteNotificationPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteNotificationPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNotificationPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePrometheusAlertRuleRequest(TeaModel):
    def __init__(self, alert_id=None):
        # The ID of the alert rule. You can call the ListPrometheusAlertRules operation to query the ID of the alert rule.
        self.alert_id = alert_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeletePrometheusAlertRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_id is not None:
            result['AlertId'] = self.alert_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertId') is not None:
            self.alert_id = m.get('AlertId')
        return self


class DeletePrometheusAlertRuleResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Indicates whether the alert rule was deleted. Valid values:
        # 
        # *   `true`: The alert rule was deleted.
        # *   `false`: The alert rule failed to be deleted.
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeletePrometheusAlertRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeletePrometheusAlertRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeletePrometheusAlertRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeletePrometheusAlertRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePrometheusAlertRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePrometheusGlobalViewRequest(TeaModel):
    def __init__(self, global_view_cluster_id=None, region_id=None):
        # The ID of the aggregation instance.
        self.global_view_cluster_id = global_view_cluster_id  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeletePrometheusGlobalViewRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.global_view_cluster_id is not None:
            result['GlobalViewClusterId'] = self.global_view_cluster_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GlobalViewClusterId') is not None:
            self.global_view_cluster_id = m.get('GlobalViewClusterId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeletePrometheusGlobalViewResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The response parameters in the JSON format.
        self.data = data  # type: str
        # The ID of the request. You can use the ID to query logs and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeletePrometheusGlobalViewResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePrometheusGlobalViewResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeletePrometheusGlobalViewResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeletePrometheusGlobalViewResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePrometheusGlobalViewResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePrometheusIntegrationRequest(TeaModel):
    def __init__(self, cluster_id=None, instance_id=None, integration_type=None, region_id=None):
        self.cluster_id = cluster_id  # type: str
        self.instance_id = instance_id  # type: long
        self.integration_type = integration_type  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeletePrometheusIntegrationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.integration_type is not None:
            result['IntegrationType'] = self.integration_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IntegrationType') is not None:
            self.integration_type = m.get('IntegrationType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeletePrometheusIntegrationResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: int
        self.data = data  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeletePrometheusIntegrationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePrometheusIntegrationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeletePrometheusIntegrationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeletePrometheusIntegrationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePrometheusIntegrationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePrometheusRemoteWriteRequest(TeaModel):
    def __init__(self, cluster_id=None, region_id=None, remote_write_names=None):
        # The ID of the Prometheus instance.
        self.cluster_id = cluster_id  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The names of the Remote Write configuration items that you want to delete. Separate configuration items with commas (,).
        self.remote_write_names = remote_write_names  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeletePrometheusRemoteWriteRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.remote_write_names is not None:
            result['RemoteWriteNames'] = self.remote_write_names
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RemoteWriteNames') is not None:
            self.remote_write_names = m.get('RemoteWriteNames')
        return self


class DeletePrometheusRemoteWriteResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        # The status code or the error code that is returned from OpenAPI Explorer.
        self.code = code  # type: int
        # If the call is successful, the number of Remote Write configuration items that are deleted is returned. If the call fails, an error message is returned.
        self.data = data  # type: str
        # The message that is returned.
        self.message = message  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Indicates whether the call was successful. Valid values: true and false.
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeletePrometheusRemoteWriteResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeletePrometheusRemoteWriteResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeletePrometheusRemoteWriteResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeletePrometheusRemoteWriteResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePrometheusRemoteWriteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRetcodeAppRequest(TeaModel):
    def __init__(self, app_id=None, app_name=None, pid=None, region_id=None):
        # The ID of the primary key.
        self.app_id = app_id  # type: str
        # The name of the application that is monitored by Browser Monitoring.
        self.app_name = app_name  # type: str
        # The process identifier (PID) of the application.
        self.pid = pid  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRetcodeAppRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteRetcodeAppResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # Indicates whether the browser monitoring task was deleted. Valid values:
        # 
        # *   `true`: The browser monitoring task was deleted.
        # *   `false`: The browser monitoring task failed to be deleted.
        self.data = data  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRetcodeAppResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteRetcodeAppResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteRetcodeAppResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteRetcodeAppResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRetcodeAppResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteScenarioRequest(TeaModel):
    def __init__(self, region_id=None, scenario_id=None):
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The ID of the business monitoring job. You can obtain the ID by calling the ListScenario operation.
        self.scenario_id = scenario_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteScenarioRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.scenario_id is not None:
            result['ScenarioId'] = self.scenario_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ScenarioId') is not None:
            self.scenario_id = m.get('ScenarioId')
        return self


class DeleteScenarioResponseBody(TeaModel):
    def __init__(self, request_id=None, result=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Indicates whether the request is successful.
        # 
        # *   `true`: successful
        # *   `false`: failed
        self.result = result  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteScenarioResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class DeleteScenarioResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteScenarioResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteScenarioResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteScenarioResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSilencePolicyRequest(TeaModel):
    def __init__(self, id=None):
        # The ID of the silence policy.
        self.id = id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSilencePolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeleteSilencePolicyResponseBody(TeaModel):
    def __init__(self, is_success=None, request_id=None):
        # Indicates whether the silence policy was deleted successfully. Valid values:
        # 
        # *   `true`: The silence policy was deleted successfully.
        # *   `false`: The silence policy failed to be deleted.
        self.is_success = is_success  # type: bool
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSilencePolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_success is not None:
            result['IsSuccess'] = self.is_success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsSuccess') is not None:
            self.is_success = m.get('IsSuccess')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSilencePolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteSilencePolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSilencePolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSilencePolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSourceMapRequest(TeaModel):
    def __init__(self, fid_list=None, pid=None, region_id=None):
        # The IDs of the SourceMap files.
        self.fid_list = fid_list  # type: list[str]
        # The process identifier (PID) of the application.
        self.pid = pid  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSourceMapRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fid_list is not None:
            result['FidList'] = self.fid_list
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FidList') is not None:
            self.fid_list = m.get('FidList')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteSourceMapShrinkRequest(TeaModel):
    def __init__(self, fid_list_shrink=None, pid=None, region_id=None):
        # The IDs of the SourceMap files.
        self.fid_list_shrink = fid_list_shrink  # type: str
        # The process identifier (PID) of the application.
        self.pid = pid  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSourceMapShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fid_list_shrink is not None:
            result['FidList'] = self.fid_list_shrink
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FidList') is not None:
            self.fid_list_shrink = m.get('FidList')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteSourceMapResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # Indicates whether the SourceMap files are deleted. Valid values:
        # 
        # *   success: The SourceMap files are deleted.
        # *   false: The SourceMap files fail to be deleted.
        self.data = data  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSourceMapResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSourceMapResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteSourceMapResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSourceMapResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSourceMapResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSyntheticTaskRequest(TeaModel):
    def __init__(self, region_id=None, task_ids=None):
        self.region_id = region_id  # type: str
        self.task_ids = task_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSyntheticTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_ids is not None:
            result['TaskIds'] = self.task_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskIds') is not None:
            self.task_ids = m.get('TaskIds')
        return self


class DeleteSyntheticTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, result=None):
        # Id of the request
        self.request_id = request_id  # type: str
        self.result = result  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSyntheticTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class DeleteSyntheticTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteSyntheticTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSyntheticTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSyntheticTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTraceAppRequest(TeaModel):
    def __init__(self, app_id=None, pid=None, region_id=None, type=None):
        # The ID of the application that you want to delete. You can call the SearchTraceAppByName operation to query the application ID. For more information, see [SearchTraceAppByName](~~130676~~).
        self.app_id = app_id  # type: str
        # The PID of the application that you want to delete. For more information about how to obtain the PID, see [Obtain the PID of an application](https://www.alibabacloud.com/help/zh/doc-detail/186100.htm?spm=a2cdw.13409063.0.0.7a72281f0bkTfx#title-imy-7gj-qhr).
        self.pid = pid  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The type of the application that you want to delete. You can call the SearchTraceAppByName operation to query the application type. For more information, see [SearchTraceAppByName](~~130676~~). Valid values:
        # 
        # *   `TRACE`: application monitoring
        # *   `RETCODE`: frontend monitoring
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTraceAppRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DeleteTraceAppResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The response in JSON format, including the HTTP status code, error code, response message, and trace ID.
        self.data = data  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTraceAppResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTraceAppResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteTraceAppResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteTraceAppResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTraceAppResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteWebhookContactRequest(TeaModel):
    def __init__(self, webhook_id=None):
        # The ID of the contact for webhook alerts.
        self.webhook_id = webhook_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteWebhookContactRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.webhook_id is not None:
            result['WebhookId'] = self.webhook_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('WebhookId') is not None:
            self.webhook_id = m.get('WebhookId')
        return self


class DeleteWebhookContactResponseBody(TeaModel):
    def __init__(self, is_success=None, request_id=None):
        # Indicates whether the webhook alert contact was successfully deleted.
        # 
        # *   `true`: The specified data is deleted.
        # *   `false`: The specified data fails to be deleted.
        self.is_success = is_success  # type: bool
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteWebhookContactResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_success is not None:
            result['IsSuccess'] = self.is_success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsSuccess') is not None:
            self.is_success = m.get('IsSuccess')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteWebhookContactResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteWebhookContactResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteWebhookContactResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteWebhookContactResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeContactGroupsRequest(TeaModel):
    def __init__(self, contact_group_name=None, group_ids=None, is_detail=None, page=None, size=None):
        # The name of the alert contact group.
        self.contact_group_name = contact_group_name  # type: str
        # The ID of the alert contact group.
        self.group_ids = group_ids  # type: str
        # Specifies whether to return all the alert contacts in the queried alert contact group. Valid values:
        # 
        # *   `false`: does not return all alert contacts.
        # *   `true`: returns all alert contacts.
        self.is_detail = is_detail  # type: bool
        # The number of the page to return.
        self.page = page  # type: long
        # The number of contact groups displayed on each page.
        self.size = size  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeContactGroupsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_name is not None:
            result['ContactGroupName'] = self.contact_group_name
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.is_detail is not None:
            result['IsDetail'] = self.is_detail
        if self.page is not None:
            result['Page'] = self.page
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactGroupName') is not None:
            self.contact_group_name = m.get('ContactGroupName')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('IsDetail') is not None:
            self.is_detail = m.get('IsDetail')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class DescribeContactGroupsResponseBodyPageBeanAlertContactGroupsContacts(TeaModel):
    def __init__(self, arms_contact_id=None, contact_id=None, contact_name=None, email=None, phone=None):
        # The ID of the alert contact.
        self.arms_contact_id = arms_contact_id  # type: long
        # The ID of the alert contact.
        self.contact_id = contact_id  # type: float
        # The name of the alert contact.
        self.contact_name = contact_name  # type: str
        # The email address of the alert contact.
        self.email = email  # type: str
        # The mobile number of the alert contact.
        self.phone = phone  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeContactGroupsResponseBodyPageBeanAlertContactGroupsContacts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arms_contact_id is not None:
            result['ArmsContactId'] = self.arms_contact_id
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.contact_name is not None:
            result['ContactName'] = self.contact_name
        if self.email is not None:
            result['Email'] = self.email
        if self.phone is not None:
            result['Phone'] = self.phone
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ArmsContactId') is not None:
            self.arms_contact_id = m.get('ArmsContactId')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('ContactName') is not None:
            self.contact_name = m.get('ContactName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('Phone') is not None:
            self.phone = m.get('Phone')
        return self


class DescribeContactGroupsResponseBodyPageBeanAlertContactGroups(TeaModel):
    def __init__(self, arms_contact_group_id=None, contact_group_id=None, contact_group_name=None, contacts=None):
        # The ID of the alert contact group.
        self.arms_contact_group_id = arms_contact_group_id  # type: long
        # The ID of the alert contact group.
        self.contact_group_id = contact_group_id  # type: float
        # The name of the alert contact group.
        self.contact_group_name = contact_group_name  # type: str
        # The contact information. Contact information is not displayed if the **IsDetail** parameter is set to `false`.
        self.contacts = contacts  # type: list[DescribeContactGroupsResponseBodyPageBeanAlertContactGroupsContacts]

    def validate(self):
        if self.contacts:
            for k in self.contacts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeContactGroupsResponseBodyPageBeanAlertContactGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arms_contact_group_id is not None:
            result['ArmsContactGroupId'] = self.arms_contact_group_id
        if self.contact_group_id is not None:
            result['ContactGroupId'] = self.contact_group_id
        if self.contact_group_name is not None:
            result['ContactGroupName'] = self.contact_group_name
        result['Contacts'] = []
        if self.contacts is not None:
            for k in self.contacts:
                result['Contacts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ArmsContactGroupId') is not None:
            self.arms_contact_group_id = m.get('ArmsContactGroupId')
        if m.get('ContactGroupId') is not None:
            self.contact_group_id = m.get('ContactGroupId')
        if m.get('ContactGroupName') is not None:
            self.contact_group_name = m.get('ContactGroupName')
        self.contacts = []
        if m.get('Contacts') is not None:
            for k in m.get('Contacts'):
                temp_model = DescribeContactGroupsResponseBodyPageBeanAlertContactGroupsContacts()
                self.contacts.append(temp_model.from_map(k))
        return self


class DescribeContactGroupsResponseBodyPageBean(TeaModel):
    def __init__(self, alert_contact_groups=None, page=None, size=None, total=None):
        # The list of alert contact groups.
        self.alert_contact_groups = alert_contact_groups  # type: list[DescribeContactGroupsResponseBodyPageBeanAlertContactGroups]
        # The number of pages returned.
        self.page = page  # type: long
        # The number of alert contact groups per page.
        self.size = size  # type: long
        # The number of alert contact groups returned.
        self.total = total  # type: long

    def validate(self):
        if self.alert_contact_groups:
            for k in self.alert_contact_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeContactGroupsResponseBodyPageBean, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertContactGroups'] = []
        if self.alert_contact_groups is not None:
            for k in self.alert_contact_groups:
                result['AlertContactGroups'].append(k.to_map() if k else None)
        if self.page is not None:
            result['Page'] = self.page
        if self.size is not None:
            result['Size'] = self.size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.alert_contact_groups = []
        if m.get('AlertContactGroups') is not None:
            for k in m.get('AlertContactGroups'):
                temp_model = DescribeContactGroupsResponseBodyPageBeanAlertContactGroups()
                self.alert_contact_groups.append(temp_model.from_map(k))
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeContactGroupsResponseBody(TeaModel):
    def __init__(self, page_bean=None, request_id=None):
        # The pages returned.
        self.page_bean = page_bean  # type: DescribeContactGroupsResponseBodyPageBean
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_bean:
            self.page_bean.validate()

    def to_map(self):
        _map = super(DescribeContactGroupsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_bean is not None:
            result['PageBean'] = self.page_bean.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageBean') is not None:
            temp_model = DescribeContactGroupsResponseBodyPageBean()
            self.page_bean = temp_model.from_map(m['PageBean'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeContactGroupsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeContactGroupsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeContactGroupsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeContactGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeContactsRequest(TeaModel):
    def __init__(self, contact_ids=None, contact_name=None, email=None, page=None, phone=None, size=None,
                 verbose=None):
        # The ID of the alert contact that you want to query. Separate multiple contact IDs with spaces.
        self.contact_ids = contact_ids  # type: str
        # The name of the alert contact.
        self.contact_name = contact_name  # type: str
        # The email address of the alert contact.
        self.email = email  # type: str
        # The number of the page to return.
        self.page = page  # type: long
        # The mobile number of the alert contact.
        self.phone = phone  # type: str
        # The number of alert contacts to return on each page.
        self.size = size  # type: long
        # Specifies whether to return redundant information.
        self.verbose = verbose  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeContactsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_ids is not None:
            result['ContactIds'] = self.contact_ids
        if self.contact_name is not None:
            result['ContactName'] = self.contact_name
        if self.email is not None:
            result['Email'] = self.email
        if self.page is not None:
            result['Page'] = self.page
        if self.phone is not None:
            result['Phone'] = self.phone
        if self.size is not None:
            result['Size'] = self.size
        if self.verbose is not None:
            result['Verbose'] = self.verbose
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactIds') is not None:
            self.contact_ids = m.get('ContactIds')
        if m.get('ContactName') is not None:
            self.contact_name = m.get('ContactName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Phone') is not None:
            self.phone = m.get('Phone')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Verbose') is not None:
            self.verbose = m.get('Verbose')
        return self


class DescribeContactsResponseBodyPageBeanAlertContacts(TeaModel):
    def __init__(self, arms_contact_id=None, contact_id=None, contact_name=None, email=None, is_email_verify=None,
                 is_verify=None, phone=None, reissue_send_notice=None):
        # The ID of the alert contact.
        self.arms_contact_id = arms_contact_id  # type: long
        # The ID of the alert contact.
        self.contact_id = contact_id  # type: float
        # The name of the alert contact.
        self.contact_name = contact_name  # type: str
        # The email address of the alert contact.
        self.email = email  # type: str
        # Indicates whether the email address was verified.
        self.is_email_verify = is_email_verify  # type: bool
        # Indicates whether the mobile number was verified. Valid values:
        # 
        # *   `false`: no
        # *   `true`: yes
        self.is_verify = is_verify  # type: bool
        # The mobile number of the alert contact.
        self.phone = phone  # type: str
        # The method to resend notifications if phone notifications fail. Valid values:
        # 
        # *   0: do not resend notifications
        # *   1: make a phone call again
        # *   2: send a text message
        # *   3 (default value): use the global default value
        self.reissue_send_notice = reissue_send_notice  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeContactsResponseBodyPageBeanAlertContacts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arms_contact_id is not None:
            result['ArmsContactId'] = self.arms_contact_id
        if self.contact_id is not None:
            result['ContactId'] = self.contact_id
        if self.contact_name is not None:
            result['ContactName'] = self.contact_name
        if self.email is not None:
            result['Email'] = self.email
        if self.is_email_verify is not None:
            result['IsEmailVerify'] = self.is_email_verify
        if self.is_verify is not None:
            result['IsVerify'] = self.is_verify
        if self.phone is not None:
            result['Phone'] = self.phone
        if self.reissue_send_notice is not None:
            result['ReissueSendNotice'] = self.reissue_send_notice
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ArmsContactId') is not None:
            self.arms_contact_id = m.get('ArmsContactId')
        if m.get('ContactId') is not None:
            self.contact_id = m.get('ContactId')
        if m.get('ContactName') is not None:
            self.contact_name = m.get('ContactName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('IsEmailVerify') is not None:
            self.is_email_verify = m.get('IsEmailVerify')
        if m.get('IsVerify') is not None:
            self.is_verify = m.get('IsVerify')
        if m.get('Phone') is not None:
            self.phone = m.get('Phone')
        if m.get('ReissueSendNotice') is not None:
            self.reissue_send_notice = m.get('ReissueSendNotice')
        return self


class DescribeContactsResponseBodyPageBean(TeaModel):
    def __init__(self, alert_contacts=None, page=None, size=None, total=None):
        # The alert contacts.
        self.alert_contacts = alert_contacts  # type: list[DescribeContactsResponseBodyPageBeanAlertContacts]
        # The page number of the returned page.
        self.page = page  # type: long
        # The number of alert contacts returned per page.
        self.size = size  # type: long
        # The total number of alert contacts.
        self.total = total  # type: long

    def validate(self):
        if self.alert_contacts:
            for k in self.alert_contacts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeContactsResponseBodyPageBean, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertContacts'] = []
        if self.alert_contacts is not None:
            for k in self.alert_contacts:
                result['AlertContacts'].append(k.to_map() if k else None)
        if self.page is not None:
            result['Page'] = self.page
        if self.size is not None:
            result['Size'] = self.size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.alert_contacts = []
        if m.get('AlertContacts') is not None:
            for k in m.get('AlertContacts'):
                temp_model = DescribeContactsResponseBodyPageBeanAlertContacts()
                self.alert_contacts.append(temp_model.from_map(k))
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeContactsResponseBody(TeaModel):
    def __init__(self, page_bean=None, request_id=None):
        # The objects that were returned.
        self.page_bean = page_bean  # type: DescribeContactsResponseBodyPageBean
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_bean:
            self.page_bean.validate()

    def to_map(self):
        _map = super(DescribeContactsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_bean is not None:
            result['PageBean'] = self.page_bean.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageBean') is not None:
            temp_model = DescribeContactsResponseBodyPageBean()
            self.page_bean = temp_model.from_map(m['PageBean'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeContactsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeContactsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeContactsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeContactsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDispatchRuleRequest(TeaModel):
    def __init__(self, id=None, region_id=None):
        # The ID of the dispatch policy.
        self.id = id  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDispatchRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeDispatchRuleResponseBodyDispatchRuleGroupRules(TeaModel):
    def __init__(self, group_id=None, group_interval=None, group_wait_time=None, grouping_fields=None,
                 repeat_interval=None):
        # The ID of the group.
        self.group_id = group_id  # type: long
        # The grouping interval.
        self.group_interval = group_interval  # type: long
        # The waiting time for grouping.
        self.group_wait_time = group_wait_time  # type: long
        # The grouping fields.
        self.grouping_fields = grouping_fields  # type: list[str]
        self.repeat_interval = repeat_interval  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDispatchRuleResponseBodyDispatchRuleGroupRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_interval is not None:
            result['GroupInterval'] = self.group_interval
        if self.group_wait_time is not None:
            result['GroupWaitTime'] = self.group_wait_time
        if self.grouping_fields is not None:
            result['GroupingFields'] = self.grouping_fields
        if self.repeat_interval is not None:
            result['RepeatInterval'] = self.repeat_interval
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupInterval') is not None:
            self.group_interval = m.get('GroupInterval')
        if m.get('GroupWaitTime') is not None:
            self.group_wait_time = m.get('GroupWaitTime')
        if m.get('GroupingFields') is not None:
            self.grouping_fields = m.get('GroupingFields')
        if m.get('RepeatInterval') is not None:
            self.repeat_interval = m.get('RepeatInterval')
        return self


class DescribeDispatchRuleResponseBodyDispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupsLabelMatchExpressions(TeaModel):
    def __init__(self, key=None, operator=None, value=None):
        # The key of the tag of the dispatch rule. Valid values:
        # 
        # *   `_aliyun_arms_userid`: user ID
        # *   `_aliyun_arms_involvedObject_kind`: type of the associated object
        # *   `_aliyun_arms_involvedObject_id`: ID of the associated object
        # *   `_aliyun_arms_involvedObject_name`: name of the associated object
        # *   `_aliyun_arms_alert_name`: alert name
        # *   `_aliyun_arms_alert_rule_id`: alert rule ID
        # *   `_aliyun_arms_alert_type`: alert type
        # *   `_aliyun_arms_alert_level`: alert severity
        self.key = key  # type: str
        # The operator used in the dispatch rule. Valid values:
        # 
        # *   `eq`: equals to.
        # *   `re`: matches a regular expression.
        self.operator = operator  # type: str
        # The value of the tag.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDispatchRuleResponseBodyDispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupsLabelMatchExpressions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDispatchRuleResponseBodyDispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroups(TeaModel):
    def __init__(self, label_match_expressions=None):
        # The collection of conditions of the dispatch rule.
        self.label_match_expressions = label_match_expressions  # type: list[DescribeDispatchRuleResponseBodyDispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupsLabelMatchExpressions]

    def validate(self):
        if self.label_match_expressions:
            for k in self.label_match_expressions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDispatchRuleResponseBodyDispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LabelMatchExpressions'] = []
        if self.label_match_expressions is not None:
            for k in self.label_match_expressions:
                result['LabelMatchExpressions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.label_match_expressions = []
        if m.get('LabelMatchExpressions') is not None:
            for k in m.get('LabelMatchExpressions'):
                temp_model = DescribeDispatchRuleResponseBodyDispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroupsLabelMatchExpressions()
                self.label_match_expressions.append(temp_model.from_map(k))
        return self


class DescribeDispatchRuleResponseBodyDispatchRuleLabelMatchExpressionGrid(TeaModel):
    def __init__(self, label_match_expression_groups=None):
        # The collection of dispatch rules.
        self.label_match_expression_groups = label_match_expression_groups  # type: list[DescribeDispatchRuleResponseBodyDispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroups]

    def validate(self):
        if self.label_match_expression_groups:
            for k in self.label_match_expression_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDispatchRuleResponseBodyDispatchRuleLabelMatchExpressionGrid, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LabelMatchExpressionGroups'] = []
        if self.label_match_expression_groups is not None:
            for k in self.label_match_expression_groups:
                result['LabelMatchExpressionGroups'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.label_match_expression_groups = []
        if m.get('LabelMatchExpressionGroups') is not None:
            for k in m.get('LabelMatchExpressionGroups'):
                temp_model = DescribeDispatchRuleResponseBodyDispatchRuleLabelMatchExpressionGridLabelMatchExpressionGroups()
                self.label_match_expression_groups.append(temp_model.from_map(k))
        return self


class DescribeDispatchRuleResponseBodyDispatchRuleNotifyRulesNotifyObjects(TeaModel):
    def __init__(self, name=None, notify_object_id=None, notify_type=None):
        # The name of the contact or contact group.
        self.name = name  # type: str
        # The ID of the contact or contact group.
        self.notify_object_id = notify_object_id  # type: str
        # The type of the alert contact. Valid values:
        # 
        # - `CONTACT`: contact
        # - `CONTACT_GROUP`: contact group
        self.notify_type = notify_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDispatchRuleResponseBodyDispatchRuleNotifyRulesNotifyObjects, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_object_id is not None:
            result['NotifyObjectId'] = self.notify_object_id
        if self.notify_type is not None:
            result['NotifyType'] = self.notify_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyObjectId') is not None:
            self.notify_object_id = m.get('NotifyObjectId')
        if m.get('NotifyType') is not None:
            self.notify_type = m.get('NotifyType')
        return self


class DescribeDispatchRuleResponseBodyDispatchRuleNotifyRules(TeaModel):
    def __init__(self, notify_channels=None, notify_objects=None):
        # The notification method. Valid values:
        # 
        # - `dingTalk`
        # - `sms`
        # - `webhook`
        # - `email`
        # - `wechat`
        self.notify_channels = notify_channels  # type: list[str]
        # The collection of alert contacts.
        self.notify_objects = notify_objects  # type: list[DescribeDispatchRuleResponseBodyDispatchRuleNotifyRulesNotifyObjects]

    def validate(self):
        if self.notify_objects:
            for k in self.notify_objects:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDispatchRuleResponseBodyDispatchRuleNotifyRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.notify_channels is not None:
            result['NotifyChannels'] = self.notify_channels
        result['NotifyObjects'] = []
        if self.notify_objects is not None:
            for k in self.notify_objects:
                result['NotifyObjects'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NotifyChannels') is not None:
            self.notify_channels = m.get('NotifyChannels')
        self.notify_objects = []
        if m.get('NotifyObjects') is not None:
            for k in m.get('NotifyObjects'):
                temp_model = DescribeDispatchRuleResponseBodyDispatchRuleNotifyRulesNotifyObjects()
                self.notify_objects.append(temp_model.from_map(k))
        return self


class DescribeDispatchRuleResponseBodyDispatchRule(TeaModel):
    def __init__(self, dispatch_type=None, group_rules=None, is_recover=None, label_match_expression_grid=None,
                 name=None, notify_rules=None, rule_id=None, state=None):
        self.dispatch_type = dispatch_type  # type: str
        # The information about groups.
        self.group_rules = group_rules  # type: list[DescribeDispatchRuleResponseBodyDispatchRuleGroupRules]
        self.is_recover = is_recover  # type: bool
        # The information about the dispatch rule.
        self.label_match_expression_grid = label_match_expression_grid  # type: DescribeDispatchRuleResponseBodyDispatchRuleLabelMatchExpressionGrid
        # The name of the dispatch policy.
        self.name = name  # type: str
        # The collection of notification methods.
        self.notify_rules = notify_rules  # type: list[DescribeDispatchRuleResponseBodyDispatchRuleNotifyRules]
        # The ID of the dispatch rule.
        self.rule_id = rule_id  # type: long
        # Indicates whether the dispatch policy is enabled. Valid values: 
        # 
        # - `true`: enabled
        # - `false`: disabled
        self.state = state  # type: str

    def validate(self):
        if self.group_rules:
            for k in self.group_rules:
                if k:
                    k.validate()
        if self.label_match_expression_grid:
            self.label_match_expression_grid.validate()
        if self.notify_rules:
            for k in self.notify_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDispatchRuleResponseBodyDispatchRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dispatch_type is not None:
            result['DispatchType'] = self.dispatch_type
        result['GroupRules'] = []
        if self.group_rules is not None:
            for k in self.group_rules:
                result['GroupRules'].append(k.to_map() if k else None)
        if self.is_recover is not None:
            result['IsRecover'] = self.is_recover
        if self.label_match_expression_grid is not None:
            result['LabelMatchExpressionGrid'] = self.label_match_expression_grid.to_map()
        if self.name is not None:
            result['Name'] = self.name
        result['NotifyRules'] = []
        if self.notify_rules is not None:
            for k in self.notify_rules:
                result['NotifyRules'].append(k.to_map() if k else None)
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DispatchType') is not None:
            self.dispatch_type = m.get('DispatchType')
        self.group_rules = []
        if m.get('GroupRules') is not None:
            for k in m.get('GroupRules'):
                temp_model = DescribeDispatchRuleResponseBodyDispatchRuleGroupRules()
                self.group_rules.append(temp_model.from_map(k))
        if m.get('IsRecover') is not None:
            self.is_recover = m.get('IsRecover')
        if m.get('LabelMatchExpressionGrid') is not None:
            temp_model = DescribeDispatchRuleResponseBodyDispatchRuleLabelMatchExpressionGrid()
            self.label_match_expression_grid = temp_model.from_map(m['LabelMatchExpressionGrid'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.notify_rules = []
        if m.get('NotifyRules') is not None:
            for k in m.get('NotifyRules'):
                temp_model = DescribeDispatchRuleResponseBodyDispatchRuleNotifyRules()
                self.notify_rules.append(temp_model.from_map(k))
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeDispatchRuleResponseBody(TeaModel):
    def __init__(self, dispatch_rule=None, request_id=None):
        # The struct returned.
        self.dispatch_rule = dispatch_rule  # type: DescribeDispatchRuleResponseBodyDispatchRule
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.dispatch_rule:
            self.dispatch_rule.validate()

    def to_map(self):
        _map = super(DescribeDispatchRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dispatch_rule is not None:
            result['DispatchRule'] = self.dispatch_rule.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DispatchRule') is not None:
            temp_model = DescribeDispatchRuleResponseBodyDispatchRule()
            self.dispatch_rule = temp_model.from_map(m['DispatchRule'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDispatchRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDispatchRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDispatchRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDispatchRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeIMRobotsRequest(TeaModel):
    def __init__(self, page=None, robot_ids=None, robot_name=None, size=None):
        # The number of pages to query.
        self.page = page  # type: long
        # The ID of the IM bot.
        self.robot_ids = robot_ids  # type: str
        # The name of the IM robot.
        self.robot_name = robot_name  # type: str
        # The number of IM robots displayed on each page.
        self.size = size  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeIMRobotsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page is not None:
            result['Page'] = self.page
        if self.robot_ids is not None:
            result['RobotIds'] = self.robot_ids
        if self.robot_name is not None:
            result['RobotName'] = self.robot_name
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('RobotIds') is not None:
            self.robot_ids = m.get('RobotIds')
        if m.get('RobotName') is not None:
            self.robot_name = m.get('RobotName')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class DescribeIMRobotsResponseBodyPageBeanAlertIMRobotsDispatchRules(TeaModel):
    def __init__(self, id=None, name=None):
        self.id = id  # type: long
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeIMRobotsResponseBodyPageBeanAlertIMRobotsDispatchRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class DescribeIMRobotsResponseBodyPageBeanAlertIMRobots(TeaModel):
    def __init__(self, create_time=None, daily_noc=None, daily_noc_time=None, ding_sign_key=None,
                 dispatch_rules=None, robot_addr=None, robot_id=None, robot_name=None, type=None):
        self.create_time = create_time  # type: str
        # Specifies whether to send daily statistics.
        # 
        # *   `false` (default): does not send statistics.
        # *   `true`: sends statistics.
        self.daily_noc = daily_noc  # type: bool
        # The time when the daily statistics are sent. ARMS Alert Management sends the total number of alerts generated today, the number of resolved alerts, and the number of pending alerts at the specified time point.
        self.daily_noc_time = daily_noc_time  # type: str
        # The signature key of DingTalk. If you specify a signature key, DingTalk authentication is performed with the key. Otherwise, a whitelist is used for authentication by default. The keyword of the whitelist is **Alert**.
        self.ding_sign_key = ding_sign_key  # type: str
        self.dispatch_rules = dispatch_rules  # type: list[DescribeIMRobotsResponseBodyPageBeanAlertIMRobotsDispatchRules]
        # The webhook address of the IM bot.
        self.robot_addr = robot_addr  # type: str
        # The ID of the IM bot.
        self.robot_id = robot_id  # type: float
        # The name of the IM robot.
        self.robot_name = robot_name  # type: str
        # IM Robot Type:
        # 
        # *   `dingding`: DingTalk robot.
        # *   `wechat`: Enterprise WeChat Robot.
        self.type = type  # type: str

    def validate(self):
        if self.dispatch_rules:
            for k in self.dispatch_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeIMRobotsResponseBodyPageBeanAlertIMRobots, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.daily_noc is not None:
            result['DailyNoc'] = self.daily_noc
        if self.daily_noc_time is not None:
            result['DailyNocTime'] = self.daily_noc_time
        if self.ding_sign_key is not None:
            result['DingSignKey'] = self.ding_sign_key
        result['DispatchRules'] = []
        if self.dispatch_rules is not None:
            for k in self.dispatch_rules:
                result['DispatchRules'].append(k.to_map() if k else None)
        if self.robot_addr is not None:
            result['RobotAddr'] = self.robot_addr
        if self.robot_id is not None:
            result['RobotId'] = self.robot_id
        if self.robot_name is not None:
            result['RobotName'] = self.robot_name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DailyNoc') is not None:
            self.daily_noc = m.get('DailyNoc')
        if m.get('DailyNocTime') is not None:
            self.daily_noc_time = m.get('DailyNocTime')
        if m.get('DingSignKey') is not None:
            self.ding_sign_key = m.get('DingSignKey')
        self.dispatch_rules = []
        if m.get('DispatchRules') is not None:
            for k in m.get('DispatchRules'):
                temp_model = DescribeIMRobotsResponseBodyPageBeanAlertIMRobotsDispatchRules()
                self.dispatch_rules.append(temp_model.from_map(k))
        if m.get('RobotAddr') is not None:
            self.robot_addr = m.get('RobotAddr')
        if m.get('RobotId') is not None:
            self.robot_id = m.get('RobotId')
        if m.get('RobotName') is not None:
            self.robot_name = m.get('RobotName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeIMRobotsResponseBodyPageBean(TeaModel):
    def __init__(self, alert_imrobots=None, page=None, size=None, total=None):
        # The details of the IM robot.
        self.alert_imrobots = alert_imrobots  # type: list[DescribeIMRobotsResponseBodyPageBeanAlertIMRobots]
        # The number of pages to query.
        self.page = page  # type: long
        # Number of IM robots per page.
        self.size = size  # type: long
        # The total number of IM robots queried.
        self.total = total  # type: long

    def validate(self):
        if self.alert_imrobots:
            for k in self.alert_imrobots:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeIMRobotsResponseBodyPageBean, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertIMRobots'] = []
        if self.alert_imrobots is not None:
            for k in self.alert_imrobots:
                result['AlertIMRobots'].append(k.to_map() if k else None)
        if self.page is not None:
            result['Page'] = self.page
        if self.size is not None:
            result['Size'] = self.size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.alert_imrobots = []
        if m.get('AlertIMRobots') is not None:
            for k in m.get('AlertIMRobots'):
                temp_model = DescribeIMRobotsResponseBodyPageBeanAlertIMRobots()
                self.alert_imrobots.append(temp_model.from_map(k))
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeIMRobotsResponseBody(TeaModel):
    def __init__(self, page_bean=None, request_id=None):
        # Paging object.
        self.page_bean = page_bean  # type: DescribeIMRobotsResponseBodyPageBean
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_bean:
            self.page_bean.validate()

    def to_map(self):
        _map = super(DescribeIMRobotsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_bean is not None:
            result['PageBean'] = self.page_bean.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageBean') is not None:
            temp_model = DescribeIMRobotsResponseBodyPageBean()
            self.page_bean = temp_model.from_map(m['PageBean'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeIMRobotsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeIMRobotsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeIMRobotsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeIMRobotsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePrometheusAlertRuleRequest(TeaModel):
    def __init__(self, alert_id=None):
        # The ID of the alert rule. You can call the ListPrometheusAlertRules operation to query the ID of the alert rule.
        self.alert_id = alert_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePrometheusAlertRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_id is not None:
            result['AlertId'] = self.alert_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertId') is not None:
            self.alert_id = m.get('AlertId')
        return self


class DescribePrometheusAlertRuleResponseBodyPrometheusAlertRuleAnnotations(TeaModel):
    def __init__(self, name=None, value=None):
        # The name of the annotation.
        self.name = name  # type: str
        # The value of the annotation.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePrometheusAlertRuleResponseBodyPrometheusAlertRuleAnnotations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribePrometheusAlertRuleResponseBodyPrometheusAlertRuleLabels(TeaModel):
    def __init__(self, name=None, value=None):
        # The name of the tag.
        self.name = name  # type: str
        # The value of the tag.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePrometheusAlertRuleResponseBodyPrometheusAlertRuleLabels, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribePrometheusAlertRuleResponseBodyPrometheusAlertRule(TeaModel):
    def __init__(self, alert_id=None, alert_name=None, annotations=None, cluster_id=None, dispatch_rule_id=None,
                 duration=None, expression=None, labels=None, message=None, notify_type=None, status=None, type=None):
        # The ID of the alert rule.
        self.alert_id = alert_id  # type: long
        # The name of the alert rule.
        self.alert_name = alert_name  # type: str
        # The annotations of the alert rule.
        self.annotations = annotations  # type: list[DescribePrometheusAlertRuleResponseBodyPrometheusAlertRuleAnnotations]
        # The ID of the cluster.
        self.cluster_id = cluster_id  # type: str
        # The ID of the notification policy. This parameter is returned if the **NotifyType** parameter is set to `DISPATCH_RULE`.
        self.dispatch_rule_id = dispatch_rule_id  # type: long
        # The duration of the alert. Valid values: 1 to 1440. Unit: minutes.
        self.duration = duration  # type: str
        # The expression of the alert rule.
        self.expression = expression  # type: str
        # The tags of the alert rule.
        self.labels = labels  # type: list[DescribePrometheusAlertRuleResponseBodyPrometheusAlertRuleLabels]
        # The alert message. Tags can be referenced in the {{$labels.xxx}} format.
        self.message = message  # type: str
        # The method of that is used to send alert notifications. Valid values:
        # 
        # *   `ALERT_MANAGER`: Alert notifications are sent by Operation Center.
        # *   `DISPATCH_RULE`: Alert notifications are sent based on the specified notification policy.
        self.notify_type = notify_type  # type: str
        # Indicates whether the alert rule is enabled. Valid values:
        # 
        # *   `1`: The alert rule is enabled.
        # *   `0`: The alert rule is disabled.
        self.status = status  # type: int
        # The type of the alert rule.
        self.type = type  # type: str

    def validate(self):
        if self.annotations:
            for k in self.annotations:
                if k:
                    k.validate()
        if self.labels:
            for k in self.labels:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePrometheusAlertRuleResponseBodyPrometheusAlertRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_id is not None:
            result['AlertId'] = self.alert_id
        if self.alert_name is not None:
            result['AlertName'] = self.alert_name
        result['Annotations'] = []
        if self.annotations is not None:
            for k in self.annotations:
                result['Annotations'].append(k.to_map() if k else None)
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.dispatch_rule_id is not None:
            result['DispatchRuleId'] = self.dispatch_rule_id
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.expression is not None:
            result['Expression'] = self.expression
        result['Labels'] = []
        if self.labels is not None:
            for k in self.labels:
                result['Labels'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.notify_type is not None:
            result['NotifyType'] = self.notify_type
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertId') is not None:
            self.alert_id = m.get('AlertId')
        if m.get('AlertName') is not None:
            self.alert_name = m.get('AlertName')
        self.annotations = []
        if m.get('Annotations') is not None:
            for k in m.get('Annotations'):
                temp_model = DescribePrometheusAlertRuleResponseBodyPrometheusAlertRuleAnnotations()
                self.annotations.append(temp_model.from_map(k))
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DispatchRuleId') is not None:
            self.dispatch_rule_id = m.get('DispatchRuleId')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        self.labels = []
        if m.get('Labels') is not None:
            for k in m.get('Labels'):
                temp_model = DescribePrometheusAlertRuleResponseBodyPrometheusAlertRuleLabels()
                self.labels.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NotifyType') is not None:
            self.notify_type = m.get('NotifyType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribePrometheusAlertRuleResponseBody(TeaModel):
    def __init__(self, prometheus_alert_rule=None, request_id=None):
        # The returned struct.
        self.prometheus_alert_rule = prometheus_alert_rule  # type: DescribePrometheusAlertRuleResponseBodyPrometheusAlertRule
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.prometheus_alert_rule:
            self.prometheus_alert_rule.validate()

    def to_map(self):
        _map = super(DescribePrometheusAlertRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.prometheus_alert_rule is not None:
            result['PrometheusAlertRule'] = self.prometheus_alert_rule.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PrometheusAlertRule') is not None:
            temp_model = DescribePrometheusAlertRuleResponseBodyPrometheusAlertRule()
            self.prometheus_alert_rule = temp_model.from_map(m['PrometheusAlertRule'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePrometheusAlertRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribePrometheusAlertRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePrometheusAlertRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePrometheusAlertRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeTraceLicenseKeyRequest(TeaModel):
    def __init__(self, region_id=None):
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeTraceLicenseKeyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeTraceLicenseKeyResponseBody(TeaModel):
    def __init__(self, license_key=None, request_id=None):
        # The license key for the application.
        self.license_key = license_key  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeTraceLicenseKeyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.license_key is not None:
            result['LicenseKey'] = self.license_key
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LicenseKey') is not None:
            self.license_key = m.get('LicenseKey')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeTraceLicenseKeyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeTraceLicenseKeyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeTraceLicenseKeyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeTraceLicenseKeyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeWebhookContactsRequest(TeaModel):
    def __init__(self, contact_ids=None, page=None, size=None, webhook_name=None):
        # The ID of the contact for webhook alerts.
        self.contact_ids = contact_ids  # type: str
        # The number of pages to query.
        self.page = page  # type: long
        # The number of webhook alert contacts displayed on each page.
        self.size = size  # type: long
        # The name of the webhook alert contact.
        self.webhook_name = webhook_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeWebhookContactsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_ids is not None:
            result['ContactIds'] = self.contact_ids
        if self.page is not None:
            result['Page'] = self.page
        if self.size is not None:
            result['Size'] = self.size
        if self.webhook_name is not None:
            result['WebhookName'] = self.webhook_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactIds') is not None:
            self.contact_ids = m.get('ContactIds')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('WebhookName') is not None:
            self.webhook_name = m.get('WebhookName')
        return self


class DescribeWebhookContactsResponseBodyPageBeanWebhookContactsWebhook(TeaModel):
    def __init__(self, biz_headers=None, biz_params=None, body=None, method=None, recover_body=None, url=None):
        # The header of the HTTP request.
        self.biz_headers = biz_headers  # type: dict[str, any]
        # The parameters in the HTTP request.
        self.biz_params = biz_params  # type: dict[str, any]
        # The alert notification template.
        self.body = body  # type: str
        # The HTTP request method. Valid values:
        # 
        # *   Get
        # *   Post
        self.method = method  # type: str
        # The alert recovery template.
        self.recover_body = recover_body  # type: str
        # The URL of the request method.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeWebhookContactsResponseBodyPageBeanWebhookContactsWebhook, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_headers is not None:
            result['BizHeaders'] = self.biz_headers
        if self.biz_params is not None:
            result['BizParams'] = self.biz_params
        if self.body is not None:
            result['Body'] = self.body
        if self.method is not None:
            result['Method'] = self.method
        if self.recover_body is not None:
            result['RecoverBody'] = self.recover_body
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizHeaders') is not None:
            self.biz_headers = m.get('BizHeaders')
        if m.get('BizParams') is not None:
            self.biz_params = m.get('BizParams')
        if m.get('Body') is not None:
            self.body = m.get('Body')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('RecoverBody') is not None:
            self.recover_body = m.get('RecoverBody')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class DescribeWebhookContactsResponseBodyPageBeanWebhookContacts(TeaModel):
    def __init__(self, webhook=None, webhook_id=None, webhook_name=None):
        # Webhook alert contact details.
        self.webhook = webhook  # type: DescribeWebhookContactsResponseBodyPageBeanWebhookContactsWebhook
        # The ID of the contact for webhook alerts.
        self.webhook_id = webhook_id  # type: float
        # The name of the webhook alert contact.
        self.webhook_name = webhook_name  # type: str

    def validate(self):
        if self.webhook:
            self.webhook.validate()

    def to_map(self):
        _map = super(DescribeWebhookContactsResponseBodyPageBeanWebhookContacts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.webhook is not None:
            result['Webhook'] = self.webhook.to_map()
        if self.webhook_id is not None:
            result['WebhookId'] = self.webhook_id
        if self.webhook_name is not None:
            result['WebhookName'] = self.webhook_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Webhook') is not None:
            temp_model = DescribeWebhookContactsResponseBodyPageBeanWebhookContactsWebhook()
            self.webhook = temp_model.from_map(m['Webhook'])
        if m.get('WebhookId') is not None:
            self.webhook_id = m.get('WebhookId')
        if m.get('WebhookName') is not None:
            self.webhook_name = m.get('WebhookName')
        return self


class DescribeWebhookContactsResponseBodyPageBean(TeaModel):
    def __init__(self, page=None, size=None, total=None, webhook_contacts=None):
        # The number of pages to query.
        self.page = page  # type: long
        # The number of webhook alert contacts on each page.
        self.size = size  # type: long
        # The total number of webhook alert contacts that were queried.
        self.total = total  # type: long
        # Webhook alert contacts.
        self.webhook_contacts = webhook_contacts  # type: list[DescribeWebhookContactsResponseBodyPageBeanWebhookContacts]

    def validate(self):
        if self.webhook_contacts:
            for k in self.webhook_contacts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeWebhookContactsResponseBodyPageBean, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page is not None:
            result['Page'] = self.page
        if self.size is not None:
            result['Size'] = self.size
        if self.total is not None:
            result['Total'] = self.total
        result['WebhookContacts'] = []
        if self.webhook_contacts is not None:
            for k in self.webhook_contacts:
                result['WebhookContacts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        self.webhook_contacts = []
        if m.get('WebhookContacts') is not None:
            for k in m.get('WebhookContacts'):
                temp_model = DescribeWebhookContactsResponseBodyPageBeanWebhookContacts()
                self.webhook_contacts.append(temp_model.from_map(k))
        return self


class DescribeWebhookContactsResponseBody(TeaModel):
    def __init__(self, page_bean=None, request_id=None):
        # Paging object.
        self.page_bean = page_bean  # type: DescribeWebhookContactsResponseBodyPageBean
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_bean:
            self.page_bean.validate()

    def to_map(self):
        _map = super(DescribeWebhookContactsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_bean is not None:
            result['PageBean'] = self.page_bean.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageBean') is not None:
            temp_model = DescribeWebhookContactsResponseBodyPageBean()
            self.page_bean = temp_model.from_map(m['PageBean'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeWebhookContactsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeWebhookContactsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeWebhookContactsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeWebhookContactsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAgentDownloadUrlRequest(TeaModel):
    def __init__(self, region_id=None):
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAgentDownloadUrlRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class GetAgentDownloadUrlResponseBody(TeaModel):
    def __init__(self, arms_agent_download_url=None, request_id=None):
        # The download URL of the ARMS agent.
        self.arms_agent_download_url = arms_agent_download_url  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAgentDownloadUrlResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arms_agent_download_url is not None:
            result['ArmsAgentDownloadUrl'] = self.arms_agent_download_url
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ArmsAgentDownloadUrl') is not None:
            self.arms_agent_download_url = m.get('ArmsAgentDownloadUrl')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAgentDownloadUrlResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAgentDownloadUrlResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAgentDownloadUrlResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAgentDownloadUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAlertRulesRequest(TeaModel):
    def __init__(self, alert_ids=None, alert_names=None, alert_status=None, alert_type=None, cluster_id=None,
                 page=None, product_code=None, region_id=None, size=None):
        # The unique identifiers (IDs) of alert rules.
        # 
        # *   If you do not specify this parameter, the API operation does not filter alert rules based on their IDs.
        # *   If you specify this parameter, the API operation returns only the information of the specified alert rules. Other filter conditions also take effect.
        # 
        # > When you call the GetAlertRules operation, you can specify other request parameters to obtain the AlertIds parameter from the response. Then, you can specify the AlertIds parameter to query the specified alert rules.
        self.alert_ids = alert_ids  # type: str
        # The names of alert rules. When you create alert rules of the new version, you cannot specify duplicate names. However, existing alert rules may have duplicate names. Therefore, the **AlertName** parameter does not uniquely identify an alert rule.
        # 
        # *   If you do not specify this parameter, the API operation does not filter alert rules based on their names.
        # *   If you specify this parameter, the API operation returns only the information of the specified alert rules. Other filter conditions also take effect.
        self.alert_names = alert_names  # type: str
        # The status of the alert rule. Valid values:
        # 
        # *   RUNNING
        # *   STOPPED
        # *   PAUSED
        # 
        # > The **PAUSED** status indicates that the alert rule was abnormal and was paused by the system. The alert rule might be paused because it was not unique or the associated cluster was deleted.
        self.alert_status = alert_status  # type: str
        # The type of the alert rule. Valid values:
        # 
        # *   APPLICATION_MONITORING_ALERT_RULE: an alert rule of Application Monitoring
        # *   BROWSER_MONITORING_ALERT_RULE: an alert rule of Browser Monitoring
        # *   PROMETHEUS_MONITORING_ALERT_RULE: an alert rule of Prometheus Service
        self.alert_type = alert_type  # type: str
        # The cluster ID of the Prometheus alert rule.
        self.cluster_id = cluster_id  # type: str
        # The number of the page to return.
        self.page = page  # type: long
        # You do not need to configure this parameter.
        self.product_code = product_code  # type: str
        # The region ID.
        self.region_id = region_id  # type: str
        # The number of alert rules to return on each page.
        self.size = size  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAlertRulesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_ids is not None:
            result['AlertIds'] = self.alert_ids
        if self.alert_names is not None:
            result['AlertNames'] = self.alert_names
        if self.alert_status is not None:
            result['AlertStatus'] = self.alert_status
        if self.alert_type is not None:
            result['AlertType'] = self.alert_type
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.page is not None:
            result['Page'] = self.page
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertIds') is not None:
            self.alert_ids = m.get('AlertIds')
        if m.get('AlertNames') is not None:
            self.alert_names = m.get('AlertNames')
        if m.get('AlertStatus') is not None:
            self.alert_status = m.get('AlertStatus')
        if m.get('AlertType') is not None:
            self.alert_type = m.get('AlertType')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class GetAlertRulesResponseBodyPageBeanAlertRulesAlertRuleContentAlertRuleItems(TeaModel):
    def __init__(self, aggregate=None, metric_key=None, n=None, operator=None, value=None):
        # The aggregation method of the alert condition. Valid values:
        # 
        # *   AVG: calculates the average value
        # *   SUM: calculates the total value
        # *   MAX: selects the maximum value
        # *   MIN: selects the minimum value
        self.aggregate = aggregate  # type: str
        # The metric of the alert condition.
        self.metric_key = metric_key  # type: str
        # Indicates the last N minutes.
        self.n = n  # type: float
        # The comparison operator that was used to compare the metric value with the threshold. Valid values:
        # 
        # *   CURRENT_GTE: greater than or equal to
        # *   CURRENT_LTE: less than or equal to
        # *   PREVIOUS_UP: the increase percentage compared with the previous period
        # *   PREVIOUS_DOWN: the decrease percentage compared with the previous period
        # *   HOH_UP: the increase percentage compared with the previous hour
        # *   HOH_DOWN: the decrease percentage compared with the previous hour
        # *   DOD_UP: the increase percentage compared with the last day
        # *   DOD_DOWN: the decrease percentage compared with the last day
        self.operator = operator  # type: str
        # The threshold of the alert condition.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAlertRulesResponseBodyPageBeanAlertRulesAlertRuleContentAlertRuleItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregate is not None:
            result['Aggregate'] = self.aggregate
        if self.metric_key is not None:
            result['MetricKey'] = self.metric_key
        if self.n is not None:
            result['N'] = self.n
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Aggregate') is not None:
            self.aggregate = m.get('Aggregate')
        if m.get('MetricKey') is not None:
            self.metric_key = m.get('MetricKey')
        if m.get('N') is not None:
            self.n = m.get('N')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetAlertRulesResponseBodyPageBeanAlertRulesAlertRuleContent(TeaModel):
    def __init__(self, alert_rule_items=None, condition=None):
        # The trigger conditions of the Application Monitoring or Browser Monitoring alert rule.
        self.alert_rule_items = alert_rule_items  # type: list[GetAlertRulesResponseBodyPageBeanAlertRulesAlertRuleContentAlertRuleItems]
        # The relationship between multiple alert conditions that were specified for the Application Monitoring or Browser Monitoring alert rule. Valid values:
        # 
        # *   OR: meets any of the specified conditions.
        # *   AND: meets all the specified conditions.
        self.condition = condition  # type: str

    def validate(self):
        if self.alert_rule_items:
            for k in self.alert_rule_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetAlertRulesResponseBodyPageBeanAlertRulesAlertRuleContent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertRuleItems'] = []
        if self.alert_rule_items is not None:
            for k in self.alert_rule_items:
                result['AlertRuleItems'].append(k.to_map() if k else None)
        if self.condition is not None:
            result['Condition'] = self.condition
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.alert_rule_items = []
        if m.get('AlertRuleItems') is not None:
            for k in m.get('AlertRuleItems'):
                temp_model = GetAlertRulesResponseBodyPageBeanAlertRulesAlertRuleContentAlertRuleItems()
                self.alert_rule_items.append(temp_model.from_map(k))
        if m.get('Condition') is not None:
            self.condition = m.get('Condition')
        return self


class GetAlertRulesResponseBodyPageBeanAlertRulesAnnotations(TeaModel):
    def __init__(self, name=None, value=None):
        # The key of the annotation.
        self.name = name  # type: str
        # The value of the annotation.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAlertRulesResponseBodyPageBeanAlertRulesAnnotations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetAlertRulesResponseBodyPageBeanAlertRulesFiltersCustomSLSFilters(TeaModel):
    def __init__(self, key=None, opt=None, show=None, t=None, value=None):
        # The key of the filter condition.
        self.key = key  # type: str
        # The logical operator of the filter condition. Valid values:
        # 
        # *   \=: equal to
        # *   not: not equal to
        self.opt = opt  # type: str
        # Indicates whether this filter condition was displayed on the frontend.
        self.show = show  # type: bool
        # The log type of Browser Monitoring. This field was not included in other filter conditions.
        self.t = t  # type: str
        # The value of the filter condition.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAlertRulesResponseBodyPageBeanAlertRulesFiltersCustomSLSFilters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.opt is not None:
            result['Opt'] = self.opt
        if self.show is not None:
            result['Show'] = self.show
        if self.t is not None:
            result['T'] = self.t
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Opt') is not None:
            self.opt = m.get('Opt')
        if m.get('Show') is not None:
            self.show = m.get('Show')
        if m.get('T') is not None:
            self.t = m.get('T')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetAlertRulesResponseBodyPageBeanAlertRulesFiltersDimFilters(TeaModel):
    def __init__(self, filter_key=None, filter_opt=None, filter_values=None):
        # The key of the filter condition.
        self.filter_key = filter_key  # type: str
        # The logical operator of the filter condition.
        self.filter_opt = filter_opt  # type: str
        # The details of the filter condition.
        self.filter_values = filter_values  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAlertRulesResponseBodyPageBeanAlertRulesFiltersDimFilters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.filter_key is not None:
            result['FilterKey'] = self.filter_key
        if self.filter_opt is not None:
            result['FilterOpt'] = self.filter_opt
        if self.filter_values is not None:
            result['FilterValues'] = self.filter_values
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FilterKey') is not None:
            self.filter_key = m.get('FilterKey')
        if m.get('FilterOpt') is not None:
            self.filter_opt = m.get('FilterOpt')
        if m.get('FilterValues') is not None:
            self.filter_values = m.get('FilterValues')
        return self


class GetAlertRulesResponseBodyPageBeanAlertRulesFilters(TeaModel):
    def __init__(self, custom_slsfilters=None, custom_slsgroup_by_dimensions=None, custom_slswheres=None,
                 dim_filters=None):
        # The custom filter condition of the Browser Monitoring alert rule.
        self.custom_slsfilters = custom_slsfilters  # type: list[GetAlertRulesResponseBodyPageBeanAlertRulesFiltersCustomSLSFilters]
        # The information of the aggregation dimension.
        self.custom_slsgroup_by_dimensions = custom_slsgroup_by_dimensions  # type: list[str]
        # The details of the custom filter condition.
        self.custom_slswheres = custom_slswheres  # type: list[str]
        # The information about each filter condition of the Application Monitoring or Browser Monitoring alert rule.
        self.dim_filters = dim_filters  # type: list[GetAlertRulesResponseBodyPageBeanAlertRulesFiltersDimFilters]

    def validate(self):
        if self.custom_slsfilters:
            for k in self.custom_slsfilters:
                if k:
                    k.validate()
        if self.dim_filters:
            for k in self.dim_filters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetAlertRulesResponseBodyPageBeanAlertRulesFilters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CustomSLSFilters'] = []
        if self.custom_slsfilters is not None:
            for k in self.custom_slsfilters:
                result['CustomSLSFilters'].append(k.to_map() if k else None)
        if self.custom_slsgroup_by_dimensions is not None:
            result['CustomSLSGroupByDimensions'] = self.custom_slsgroup_by_dimensions
        if self.custom_slswheres is not None:
            result['CustomSLSWheres'] = self.custom_slswheres
        result['DimFilters'] = []
        if self.dim_filters is not None:
            for k in self.dim_filters:
                result['DimFilters'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.custom_slsfilters = []
        if m.get('CustomSLSFilters') is not None:
            for k in m.get('CustomSLSFilters'):
                temp_model = GetAlertRulesResponseBodyPageBeanAlertRulesFiltersCustomSLSFilters()
                self.custom_slsfilters.append(temp_model.from_map(k))
        if m.get('CustomSLSGroupByDimensions') is not None:
            self.custom_slsgroup_by_dimensions = m.get('CustomSLSGroupByDimensions')
        if m.get('CustomSLSWheres') is not None:
            self.custom_slswheres = m.get('CustomSLSWheres')
        self.dim_filters = []
        if m.get('DimFilters') is not None:
            for k in m.get('DimFilters'):
                temp_model = GetAlertRulesResponseBodyPageBeanAlertRulesFiltersDimFilters()
                self.dim_filters.append(temp_model.from_map(k))
        return self


class GetAlertRulesResponseBodyPageBeanAlertRulesLabels(TeaModel):
    def __init__(self, name=None, value=None):
        # The tag key.
        self.name = name  # type: str
        # The tag value.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAlertRulesResponseBodyPageBeanAlertRulesLabels, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetAlertRulesResponseBodyPageBeanAlertRules(TeaModel):
    def __init__(self, alert_check_type=None, alert_group=None, alert_id=None, alert_name=None,
                 alert_rule_content=None, alert_status=None, alert_type=None, annotations=None, auto_add_new_application=None,
                 cluster_id=None, created_time=None, duration=None, extend=None, filters=None, labels=None, level=None,
                 message=None, metrics_type=None, notify_strategy=None, pids=None, prom_ql=None, region_id=None,
                 updated_time=None, user_id=None):
        # The alert check type of the Prometheus alert rule. Valid values:
        # 
        # *   STATIC: a static threshold value.
        # *   CUSTOM: a custom PromQL statement.
        self.alert_check_type = alert_check_type  # type: str
        # The alert contact group ID of the Prometheus alert rule. Valid values:
        # 
        # *   \-1: custom PromQL
        # *   1: Kubernetes load
        # *   15: Kubernetes node
        self.alert_group = alert_group  # type: long
        # The ID of the alert rule.
        self.alert_id = alert_id  # type: float
        # The name of the alert rule.
        self.alert_name = alert_name  # type: str
        # The content of the Application Monitoring or Browser Monitoring alert rule.
        self.alert_rule_content = alert_rule_content  # type: GetAlertRulesResponseBodyPageBeanAlertRulesAlertRuleContent
        # The status of the alert rule. Valid values:
        # 
        # *   RUNNING
        # *   STOPPED
        # *   PAUSED
        # 
        # > The **PAUSED** status indicates that the alert rule was abnormal and was paused by the system. The alert rule might be paused because it was not unique or the associated cluster was deleted.
        self.alert_status = alert_status  # type: str
        # The type of the alert rule.
        # 
        # *   APPLICATION_MONITORING_ALERT_RULE: an alert rule of Application Monitoring
        # *   BROWSER_MONITORING_ALERT_RULE: an alert rule of Browser Monitoring
        # *   PROMETHEUS_MONITORING_ALERT_RULE: an alert rule of Prometheus Service
        self.alert_type = alert_type  # type: str
        # The annotations of the Prometheus alert rule.
        self.annotations = annotations  # type: list[GetAlertRulesResponseBodyPageBeanAlertRulesAnnotations]
        # Indicates whether the alert rule was applied to new applications that were created in Application Monitoring or Browser Monitoring. Valid values:
        # 
        # *   `true`: yes
        # *   `false`: no
        self.auto_add_new_application = auto_add_new_application  # type: bool
        # The cluster ID of the Prometheus alert rule.
        self.cluster_id = cluster_id  # type: str
        # The time when the alert rule was created. The value is a timestamp. Unit: milliseconds.
        self.created_time = created_time  # type: long
        # The duration of the Prometheus alert rule.
        self.duration = duration  # type: str
        # The extended fields.
        # 
        # > For existing Application Monitoring alert rules, the fields contain information such as contacts, alert template, and notification content.
        self.extend = extend  # type: str
        # The filter conditions of the Application Monitoring or Browser Monitoring alert rule.
        self.filters = filters  # type: GetAlertRulesResponseBodyPageBeanAlertRulesFilters
        # The tags of the Prometheus alert rule.
        self.labels = labels  # type: list[GetAlertRulesResponseBodyPageBeanAlertRulesLabels]
        # The severity level of the Prometheus alert rule.
        # 
        # *   P1: Alert notifications are sent for major issues that affect the availability of core business, have a huge impact, and may lead to serious consequences.
        # *   P2: Alert notifications are sent for service errors that affect the system availability with relatively limited impact.
        # *   P3: Alert notifications are sent for issues that may cause service errors or negative effects, or alert notifications for services that are relatively less important.
        # *   P4: Alert notifications are sent for low-priority issues that do not affect your business.
        # *   Default: Alert notifications are sent regardless of alert levels.
        self.level = level  # type: str
        # The alert message of the Prometheus alert rule.
        self.message = message  # type: str
        # The metric type of the Application Monitoring or Browser Monitoring alert rule.
        self.metrics_type = metrics_type  # type: str
        # The name of the notification policy.
        self.notify_strategy = notify_strategy  # type: str
        # The process ID (PID) that was associated with the Application Monitoring or Browser Monitoring alert rule.
        self.pids = pids  # type: list[str]
        # The PromQL statement of the Prometheus alert rule.
        self.prom_ql = prom_ql  # type: str
        # The region ID.
        self.region_id = region_id  # type: str
        # The time when the alert rule was updated. The value is a timestamp. Unit: milliseconds.
        self.updated_time = updated_time  # type: long
        # The ID of the Alibaba Cloud account.
        self.user_id = user_id  # type: str

    def validate(self):
        if self.alert_rule_content:
            self.alert_rule_content.validate()
        if self.annotations:
            for k in self.annotations:
                if k:
                    k.validate()
        if self.filters:
            self.filters.validate()
        if self.labels:
            for k in self.labels:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetAlertRulesResponseBodyPageBeanAlertRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_check_type is not None:
            result['AlertCheckType'] = self.alert_check_type
        if self.alert_group is not None:
            result['AlertGroup'] = self.alert_group
        if self.alert_id is not None:
            result['AlertId'] = self.alert_id
        if self.alert_name is not None:
            result['AlertName'] = self.alert_name
        if self.alert_rule_content is not None:
            result['AlertRuleContent'] = self.alert_rule_content.to_map()
        if self.alert_status is not None:
            result['AlertStatus'] = self.alert_status
        if self.alert_type is not None:
            result['AlertType'] = self.alert_type
        result['Annotations'] = []
        if self.annotations is not None:
            for k in self.annotations:
                result['Annotations'].append(k.to_map() if k else None)
        if self.auto_add_new_application is not None:
            result['AutoAddNewApplication'] = self.auto_add_new_application
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.extend is not None:
            result['Extend'] = self.extend
        if self.filters is not None:
            result['Filters'] = self.filters.to_map()
        result['Labels'] = []
        if self.labels is not None:
            for k in self.labels:
                result['Labels'].append(k.to_map() if k else None)
        if self.level is not None:
            result['Level'] = self.level
        if self.message is not None:
            result['Message'] = self.message
        if self.metrics_type is not None:
            result['MetricsType'] = self.metrics_type
        if self.notify_strategy is not None:
            result['NotifyStrategy'] = self.notify_strategy
        if self.pids is not None:
            result['Pids'] = self.pids
        if self.prom_ql is not None:
            result['PromQL'] = self.prom_ql
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.updated_time is not None:
            result['UpdatedTime'] = self.updated_time
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertCheckType') is not None:
            self.alert_check_type = m.get('AlertCheckType')
        if m.get('AlertGroup') is not None:
            self.alert_group = m.get('AlertGroup')
        if m.get('AlertId') is not None:
            self.alert_id = m.get('AlertId')
        if m.get('AlertName') is not None:
            self.alert_name = m.get('AlertName')
        if m.get('AlertRuleContent') is not None:
            temp_model = GetAlertRulesResponseBodyPageBeanAlertRulesAlertRuleContent()
            self.alert_rule_content = temp_model.from_map(m['AlertRuleContent'])
        if m.get('AlertStatus') is not None:
            self.alert_status = m.get('AlertStatus')
        if m.get('AlertType') is not None:
            self.alert_type = m.get('AlertType')
        self.annotations = []
        if m.get('Annotations') is not None:
            for k in m.get('Annotations'):
                temp_model = GetAlertRulesResponseBodyPageBeanAlertRulesAnnotations()
                self.annotations.append(temp_model.from_map(k))
        if m.get('AutoAddNewApplication') is not None:
            self.auto_add_new_application = m.get('AutoAddNewApplication')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Extend') is not None:
            self.extend = m.get('Extend')
        if m.get('Filters') is not None:
            temp_model = GetAlertRulesResponseBodyPageBeanAlertRulesFilters()
            self.filters = temp_model.from_map(m['Filters'])
        self.labels = []
        if m.get('Labels') is not None:
            for k in m.get('Labels'):
                temp_model = GetAlertRulesResponseBodyPageBeanAlertRulesLabels()
                self.labels.append(temp_model.from_map(k))
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MetricsType') is not None:
            self.metrics_type = m.get('MetricsType')
        if m.get('NotifyStrategy') is not None:
            self.notify_strategy = m.get('NotifyStrategy')
        if m.get('Pids') is not None:
            self.pids = m.get('Pids')
        if m.get('PromQL') is not None:
            self.prom_ql = m.get('PromQL')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('UpdatedTime') is not None:
            self.updated_time = m.get('UpdatedTime')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetAlertRulesResponseBodyPageBean(TeaModel):
    def __init__(self, alert_rules=None, page=None, size=None, total=None):
        # The list of alert rules.
        self.alert_rules = alert_rules  # type: list[GetAlertRulesResponseBodyPageBeanAlertRules]
        # The page number of the returned page.
        self.page = page  # type: long
        # The number of alert rules returned per page.
        self.size = size  # type: long
        # The total number of queried alert rules.
        self.total = total  # type: long

    def validate(self):
        if self.alert_rules:
            for k in self.alert_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetAlertRulesResponseBodyPageBean, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertRules'] = []
        if self.alert_rules is not None:
            for k in self.alert_rules:
                result['AlertRules'].append(k.to_map() if k else None)
        if self.page is not None:
            result['Page'] = self.page
        if self.size is not None:
            result['Size'] = self.size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.alert_rules = []
        if m.get('AlertRules') is not None:
            for k in m.get('AlertRules'):
                temp_model = GetAlertRulesResponseBodyPageBeanAlertRules()
                self.alert_rules.append(temp_model.from_map(k))
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetAlertRulesResponseBody(TeaModel):
    def __init__(self, page_bean=None, request_id=None):
        # The objects that were returned.
        self.page_bean = page_bean  # type: GetAlertRulesResponseBodyPageBean
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_bean:
            self.page_bean.validate()

    def to_map(self):
        _map = super(GetAlertRulesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_bean is not None:
            result['PageBean'] = self.page_bean.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageBean') is not None:
            temp_model = GetAlertRulesResponseBodyPageBean()
            self.page_bean = temp_model.from_map(m['PageBean'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAlertRulesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAlertRulesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAlertRulesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAlertRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAppApiByPageRequest(TeaModel):
    def __init__(self, current_page=None, end_time=None, interval_mills=None, pid=None, page_size=None,
                 region_id=None, start_time=None):
        # The number of the page to return.
        self.current_page = current_page  # type: int
        # The end of the time range to query. Unit: milliseconds.
        self.end_time = end_time  # type: long
        # The time interval between the data shards to be queried. Unit: milliseconds. Minimum value: 60000.
        self.interval_mills = interval_mills  # type: int
        # The process identifier (PID) of the application. For more information about how to obtain the PID, see [Obtain the PID of an application](https://www.alibabacloud.com/help/zh/doc-detail/186100.htm?spm=a2cdw.13409063.0.0.7a72281f0bkTfx#title-imy-7gj-qhr).
        self.pid = pid  # type: str
        # The number of entries to return on each page.
        self.page_size = page_size  # type: int
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The beginning of the time range to query. Unit: milliseconds.
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAppApiByPageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval_mills is not None:
            result['IntervalMills'] = self.interval_mills
        if self.pid is not None:
            result['PId'] = self.pid
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IntervalMills') is not None:
            self.interval_mills = m.get('IntervalMills')
        if m.get('PId') is not None:
            self.pid = m.get('PId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetAppApiByPageResponseBodyData(TeaModel):
    def __init__(self, items=None, page=None, page_size=None, total=None):
        # The information about the API operation.
        self.items = items  # type: list[dict[str, any]]
        # The page number of the returned page.
        self.page = page  # type: int
        # The number of entries returned per page.
        self.page_size = page_size  # type: int
        # The total number of entries returned.
        self.total = total  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAppApiByPageResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['Items'] = self.items
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Items') is not None:
            self.items = m.get('Items')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetAppApiByPageResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        # The HTTP status code returned for the request. Valid values:
        # 
        # *   2XX: The request is successful.
        # *   3XX: A redirection message is returned.
        # *   4XX: The request is invalid.
        # *   5XX: A server error occurs.
        self.code = code  # type: int
        # The struct returned.
        self.data = data  # type: GetAppApiByPageResponseBodyData
        # The message returned.
        self.message = message  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Indicates whether the call is successful. Valid values:
        # 
        # *   `true`: The call is successful.
        # *   `false`: The call fails.
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetAppApiByPageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAppApiByPageResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAppApiByPageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAppApiByPageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAppApiByPageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAppApiByPageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAuthTokenRequest(TeaModel):
    def __init__(self, cluster_id=None, region_id=None):
        # The ID of the ACK cluster.
        self.cluster_id = cluster_id  # type: str
        # The region ID of the cluster.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAuthTokenRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class GetAuthTokenResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The returned authentication token.
        self.data = data  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAuthTokenResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAuthTokenResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAuthTokenResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAuthTokenResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAuthTokenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCloudClusterAllUrlRequest(TeaModel):
    def __init__(self, cluster_id=None, region_id=None):
        self.cluster_id = cluster_id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCloudClusterAllUrlRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class GetCloudClusterAllUrlResponseBodyDataRemoteUrl(TeaModel):
    def __init__(self, auth_token=None, grafana_url=None, internet_grafana_url=None,
                 internet_push_gateway_url=None, internet_remote_read_url=None, internet_remote_write_url=None, push_gateway_url=None,
                 remote_read_url=None, remote_write_url=None, token=None):
        self.auth_token = auth_token  # type: bool
        self.grafana_url = grafana_url  # type: str
        self.internet_grafana_url = internet_grafana_url  # type: str
        self.internet_push_gateway_url = internet_push_gateway_url  # type: str
        self.internet_remote_read_url = internet_remote_read_url  # type: str
        self.internet_remote_write_url = internet_remote_write_url  # type: str
        self.push_gateway_url = push_gateway_url  # type: str
        self.remote_read_url = remote_read_url  # type: str
        self.remote_write_url = remote_write_url  # type: str
        self.token = token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCloudClusterAllUrlResponseBodyDataRemoteUrl, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_token is not None:
            result['AuthToken'] = self.auth_token
        if self.grafana_url is not None:
            result['GrafanaUrl'] = self.grafana_url
        if self.internet_grafana_url is not None:
            result['InternetGrafanaUrl'] = self.internet_grafana_url
        if self.internet_push_gateway_url is not None:
            result['InternetPushGatewayUrl'] = self.internet_push_gateway_url
        if self.internet_remote_read_url is not None:
            result['InternetRemoteReadUrl'] = self.internet_remote_read_url
        if self.internet_remote_write_url is not None:
            result['InternetRemoteWriteUrl'] = self.internet_remote_write_url
        if self.push_gateway_url is not None:
            result['PushGatewayUrl'] = self.push_gateway_url
        if self.remote_read_url is not None:
            result['RemoteReadUrl'] = self.remote_read_url
        if self.remote_write_url is not None:
            result['RemoteWriteUrl'] = self.remote_write_url
        if self.token is not None:
            result['Token'] = self.token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AuthToken') is not None:
            self.auth_token = m.get('AuthToken')
        if m.get('GrafanaUrl') is not None:
            self.grafana_url = m.get('GrafanaUrl')
        if m.get('InternetGrafanaUrl') is not None:
            self.internet_grafana_url = m.get('InternetGrafanaUrl')
        if m.get('InternetPushGatewayUrl') is not None:
            self.internet_push_gateway_url = m.get('InternetPushGatewayUrl')
        if m.get('InternetRemoteReadUrl') is not None:
            self.internet_remote_read_url = m.get('InternetRemoteReadUrl')
        if m.get('InternetRemoteWriteUrl') is not None:
            self.internet_remote_write_url = m.get('InternetRemoteWriteUrl')
        if m.get('PushGatewayUrl') is not None:
            self.push_gateway_url = m.get('PushGatewayUrl')
        if m.get('RemoteReadUrl') is not None:
            self.remote_read_url = m.get('RemoteReadUrl')
        if m.get('RemoteWriteUrl') is not None:
            self.remote_write_url = m.get('RemoteWriteUrl')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        return self


class GetCloudClusterAllUrlResponseBodyData(TeaModel):
    def __init__(self, product_code=None, region=None, remote_url=None):
        self.product_code = product_code  # type: str
        self.region = region  # type: str
        self.remote_url = remote_url  # type: GetCloudClusterAllUrlResponseBodyDataRemoteUrl

    def validate(self):
        if self.remote_url:
            self.remote_url.validate()

    def to_map(self):
        _map = super(GetCloudClusterAllUrlResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.region is not None:
            result['Region'] = self.region
        if self.remote_url is not None:
            result['RemoteUrl'] = self.remote_url.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RemoteUrl') is not None:
            temp_model = GetCloudClusterAllUrlResponseBodyDataRemoteUrl()
            self.remote_url = temp_model.from_map(m['RemoteUrl'])
        return self


class GetCloudClusterAllUrlResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: list[GetCloudClusterAllUrlResponseBodyData]
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetCloudClusterAllUrlResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetCloudClusterAllUrlResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetCloudClusterAllUrlResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetCloudClusterAllUrlResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetCloudClusterAllUrlResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCloudClusterAllUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetClusterAllUrlRequest(TeaModel):
    def __init__(self, cluster_id=None, region_id=None):
        # The ID of the cluster.
        self.cluster_id = cluster_id  # type: str
        # The ID of the region. Default value: cn-hangzhou.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetClusterAllUrlRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class GetClusterAllUrlResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The response parameters in the JSON format.
        self.data = data  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetClusterAllUrlResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetClusterAllUrlResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetClusterAllUrlResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetClusterAllUrlResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetClusterAllUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetExploreUrlRequest(TeaModel):
    def __init__(self, cluster_id=None, expression=None, region_id=None, type=None):
        # The ID of the cluster.
        self.cluster_id = cluster_id  # type: str
        # The query language corresponding to the data source.
        self.expression = expression  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The type of the Grafana data source.
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetExploreUrlRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetExploreUrlResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # Response parameters
        self.data = data  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetExploreUrlResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetExploreUrlResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetExploreUrlResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetExploreUrlResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetExploreUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetIntegrationStateRequest(TeaModel):
    def __init__(self, cluster_id=None, integration=None, region_id=None):
        # The abbreviation of the software that is supported by Application Real-Time Monitoring Service (ARMS). Valid values (case-insensitive): `ASM`, `IoT`, and `Flink`.
        self.cluster_id = cluster_id  # type: str
        # The integration state of Prometheus dashboards and collection rules. Valid values:
        # 
        # *   `true`: Prometheus dashboards and collection rules are integrated.
        # *   `false`: Prometheus dashboards and collection rules are not integrated.
        self.integration = integration  # type: str
        # The ID of the request.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetIntegrationStateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.integration is not None:
            result['Integration'] = self.integration
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Integration') is not None:
            self.integration = m.get('Integration')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class GetIntegrationStateResponseBody(TeaModel):
    def __init__(self, request_id=None, state=None):
        # auditing
        self.request_id = request_id  # type: str
        # Queries the integration state of Prometheus dashboards and collection rules for a Container Service for Kubernetes (ACK) cluster.
        self.state = state  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetIntegrationStateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class GetIntegrationStateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetIntegrationStateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetIntegrationStateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetIntegrationStateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetManagedPrometheusStatusRequest(TeaModel):
    def __init__(self, cluster_id=None, cluster_type=None, region_id=None, resource_group_id=None, vpc_id=None):
        # The ID of the cluster.
        self.cluster_id = cluster_id  # type: str
        # The type of the cluster. Set the value to ask.
        self.cluster_type = cluster_type  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        # ClusterType为“ecs”时，必填。
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetManagedPrometheusStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class GetManagedPrometheusStatusResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        # The HTTP status code returned.
        self.code = code  # type: int
        # The status of the Prometheus instance. Installing: The Prometheus agent is installed and no registration information is available. Success: The Prometheus agent is installed and registered. Failure: The Prometheus agent failed to be installed or registered. Unknow: The status of the Prometheus agent is unknown.
        self.data = data  # type: str
        # The returned message.
        self.message = message  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Indicates whether the query was successful.
        # 
        # *   `true`
        # *   `false`
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetManagedPrometheusStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetManagedPrometheusStatusResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetManagedPrometheusStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetManagedPrometheusStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetManagedPrometheusStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMultipleTraceRequest(TeaModel):
    def __init__(self, end_time=None, region_id=None, start_time=None, trace_ids=None):
        # The end time of the trace. The value is a timestamp. Unit: milliseconds.
        self.end_time = end_time  # type: long
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The start time of the trace. The value is a timestamp. Unit: milliseconds.
        self.start_time = start_time  # type: long
        # The lists of trace IDs.
        self.trace_ids = trace_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMultipleTraceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.trace_ids is not None:
            result['TraceIDs'] = self.trace_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TraceIDs') is not None:
            self.trace_ids = m.get('TraceIDs')
        return self


class GetMultipleTraceResponseBodyMultiCallChainInfosSpansLogEventListTagEntryList(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag key.
        self.key = key  # type: str
        # The tag value.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMultipleTraceResponseBodyMultiCallChainInfosSpansLogEventListTagEntryList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetMultipleTraceResponseBodyMultiCallChainInfosSpansLogEventList(TeaModel):
    def __init__(self, tag_entry_list=None, timestamp=None):
        # The tags of the trace.
        self.tag_entry_list = tag_entry_list  # type: list[GetMultipleTraceResponseBodyMultiCallChainInfosSpansLogEventListTagEntryList]
        # The time when the log was generated. The value is a timestamp.
        self.timestamp = timestamp  # type: long

    def validate(self):
        if self.tag_entry_list:
            for k in self.tag_entry_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMultipleTraceResponseBodyMultiCallChainInfosSpansLogEventList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TagEntryList'] = []
        if self.tag_entry_list is not None:
            for k in self.tag_entry_list:
                result['TagEntryList'].append(k.to_map() if k else None)
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tag_entry_list = []
        if m.get('TagEntryList') is not None:
            for k in m.get('TagEntryList'):
                temp_model = GetMultipleTraceResponseBodyMultiCallChainInfosSpansLogEventListTagEntryList()
                self.tag_entry_list.append(temp_model.from_map(k))
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class GetMultipleTraceResponseBodyMultiCallChainInfosSpansTagEntryList(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag key.
        self.key = key  # type: str
        # The tag value.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMultipleTraceResponseBodyMultiCallChainInfosSpansTagEntryList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetMultipleTraceResponseBodyMultiCallChainInfosSpans(TeaModel):
    def __init__(self, duration=None, have_stack=None, log_event_list=None, operation_name=None,
                 parent_span_id=None, result_code=None, rpc_id=None, rpc_type=None, service_ip=None, service_name=None,
                 span_id=None, tag_entry_list=None, timestamp=None, trace_id=None):
        # The amount of time consumed by the trace. Unit: milliseconds.
        self.duration = duration  # type: long
        # Indicates whether a method stack was provided.
        # 
        # *   `true`: A method stack was provided.
        # *   `false`: No method stack was provided.
        self.have_stack = have_stack  # type: bool
        # The log events in the trace.
        self.log_event_list = log_event_list  # type: list[GetMultipleTraceResponseBodyMultiCallChainInfosSpansLogEventList]
        # The name of the traced span.
        self.operation_name = operation_name  # type: str
        # The ID of the parent span.
        self.parent_span_id = parent_span_id  # type: str
        # The status code returned.
        self.result_code = result_code  # type: str
        # The ID of the RPC mode.
        self.rpc_id = rpc_id  # type: str
        # The type of the remote procedure call (RPC) mode.
        # 
        # *   0: HTTP entry
        # *   25: HTTP call
        # *   1: High-speed Service Framework (HSF) call
        # *   2: HSF provision
        # *   40: on-premises API call
        # *   60: MySQL call
        # *   62: Oracle call
        # *   63: PostgreSQL call
        # *   70: Redis call
        # *   4: Taobao Distributed Data Layer (TDDL) call
        # *   5: Tair call
        # *   13: MetaQ message sending
        # *   252: MetaQ message receiving
        # *   3: notification sending
        # *   254: notification receiving
        # *   7: Apache Dubbo call
        # *   8: Apache Dubbo provision
        # *   19: SOFARPC call
        # *   18: SOFARPC provision
        # *   11: Distributed Service Framework (DSF) call
        # *   12: DSF provision
        # *   \-1: unknown call
        self.rpc_type = rpc_type  # type: int
        # The IP address of the host where the application resides.
        self.service_ip = service_ip  # type: str
        # The name of the application.
        self.service_name = service_name  # type: str
        # The ID of the span.
        self.span_id = span_id  # type: str
        # The tags of the trace.
        self.tag_entry_list = tag_entry_list  # type: list[GetMultipleTraceResponseBodyMultiCallChainInfosSpansTagEntryList]
        # The timestamp.
        self.timestamp = timestamp  # type: long
        # The ID of the trace.
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.log_event_list:
            for k in self.log_event_list:
                if k:
                    k.validate()
        if self.tag_entry_list:
            for k in self.tag_entry_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMultipleTraceResponseBodyMultiCallChainInfosSpans, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.have_stack is not None:
            result['HaveStack'] = self.have_stack
        result['LogEventList'] = []
        if self.log_event_list is not None:
            for k in self.log_event_list:
                result['LogEventList'].append(k.to_map() if k else None)
        if self.operation_name is not None:
            result['OperationName'] = self.operation_name
        if self.parent_span_id is not None:
            result['ParentSpanId'] = self.parent_span_id
        if self.result_code is not None:
            result['ResultCode'] = self.result_code
        if self.rpc_id is not None:
            result['RpcId'] = self.rpc_id
        if self.rpc_type is not None:
            result['RpcType'] = self.rpc_type
        if self.service_ip is not None:
            result['ServiceIp'] = self.service_ip
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.span_id is not None:
            result['SpanId'] = self.span_id
        result['TagEntryList'] = []
        if self.tag_entry_list is not None:
            for k in self.tag_entry_list:
                result['TagEntryList'].append(k.to_map() if k else None)
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.trace_id is not None:
            result['TraceID'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('HaveStack') is not None:
            self.have_stack = m.get('HaveStack')
        self.log_event_list = []
        if m.get('LogEventList') is not None:
            for k in m.get('LogEventList'):
                temp_model = GetMultipleTraceResponseBodyMultiCallChainInfosSpansLogEventList()
                self.log_event_list.append(temp_model.from_map(k))
        if m.get('OperationName') is not None:
            self.operation_name = m.get('OperationName')
        if m.get('ParentSpanId') is not None:
            self.parent_span_id = m.get('ParentSpanId')
        if m.get('ResultCode') is not None:
            self.result_code = m.get('ResultCode')
        if m.get('RpcId') is not None:
            self.rpc_id = m.get('RpcId')
        if m.get('RpcType') is not None:
            self.rpc_type = m.get('RpcType')
        if m.get('ServiceIp') is not None:
            self.service_ip = m.get('ServiceIp')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('SpanId') is not None:
            self.span_id = m.get('SpanId')
        self.tag_entry_list = []
        if m.get('TagEntryList') is not None:
            for k in m.get('TagEntryList'):
                temp_model = GetMultipleTraceResponseBodyMultiCallChainInfosSpansTagEntryList()
                self.tag_entry_list.append(temp_model.from_map(k))
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('TraceID') is not None:
            self.trace_id = m.get('TraceID')
        return self


class GetMultipleTraceResponseBodyMultiCallChainInfos(TeaModel):
    def __init__(self, spans=None, trace_id=None):
        # The details of the trace.
        self.spans = spans  # type: list[GetMultipleTraceResponseBodyMultiCallChainInfosSpans]
        # The ID of the trace.
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.spans:
            for k in self.spans:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMultipleTraceResponseBodyMultiCallChainInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Spans'] = []
        if self.spans is not None:
            for k in self.spans:
                result['Spans'].append(k.to_map() if k else None)
        if self.trace_id is not None:
            result['TraceID'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.spans = []
        if m.get('Spans') is not None:
            for k in m.get('Spans'):
                temp_model = GetMultipleTraceResponseBodyMultiCallChainInfosSpans()
                self.spans.append(temp_model.from_map(k))
        if m.get('TraceID') is not None:
            self.trace_id = m.get('TraceID')
        return self


class GetMultipleTraceResponseBody(TeaModel):
    def __init__(self, multi_call_chain_infos=None, request_id=None):
        # The details of traces.
        self.multi_call_chain_infos = multi_call_chain_infos  # type: list[GetMultipleTraceResponseBodyMultiCallChainInfos]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.multi_call_chain_infos:
            for k in self.multi_call_chain_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMultipleTraceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MultiCallChainInfos'] = []
        if self.multi_call_chain_infos is not None:
            for k in self.multi_call_chain_infos:
                result['MultiCallChainInfos'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.multi_call_chain_infos = []
        if m.get('MultiCallChainInfos') is not None:
            for k in m.get('MultiCallChainInfos'):
                temp_model = GetMultipleTraceResponseBodyMultiCallChainInfos()
                self.multi_call_chain_infos.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMultipleTraceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetMultipleTraceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMultipleTraceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMultipleTraceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOnCallSchedulesDetailRequest(TeaModel):
    def __init__(self, end_time=None, id=None, start_time=None):
        # The date on which the shift ends. Format: `yyyy-MM-dd`.
        self.end_time = end_time  # type: str
        # The ID of the scheduling policy.
        self.id = id  # type: long
        # The date from which the shift starts. Format: `yyyy-MM-dd`.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetOnCallSchedulesDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.id is not None:
            result['Id'] = self.id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetOnCallSchedulesDetailResponseBodyDataRenderedFinnalEntriesSimpleContact(TeaModel):
    def __init__(self, id=None, name=None):
        # The ID of the user on duty.
        self.id = id  # type: long
        # The name of the user on duty.
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetOnCallSchedulesDetailResponseBodyDataRenderedFinnalEntriesSimpleContact, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetOnCallSchedulesDetailResponseBodyDataRenderedFinnalEntries(TeaModel):
    def __init__(self, end=None, simple_contact=None, start=None):
        # The date on which the user completed shift work.
        self.end = end  # type: str
        # The information about the user on duty.
        self.simple_contact = simple_contact  # type: GetOnCallSchedulesDetailResponseBodyDataRenderedFinnalEntriesSimpleContact
        # The date from which the user started shift work.
        self.start = start  # type: str

    def validate(self):
        if self.simple_contact:
            self.simple_contact.validate()

    def to_map(self):
        _map = super(GetOnCallSchedulesDetailResponseBodyDataRenderedFinnalEntries, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end is not None:
            result['End'] = self.end
        if self.simple_contact is not None:
            result['SimpleContact'] = self.simple_contact.to_map()
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('SimpleContact') is not None:
            temp_model = GetOnCallSchedulesDetailResponseBodyDataRenderedFinnalEntriesSimpleContact()
            self.simple_contact = temp_model.from_map(m['SimpleContact'])
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class GetOnCallSchedulesDetailResponseBodyDataRenderedLayerEntriesSimpleContact(TeaModel):
    def __init__(self, id=None, name=None):
        # The ID of the scheduled user.
        self.id = id  # type: long
        # The name of the scheduled user.
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetOnCallSchedulesDetailResponseBodyDataRenderedLayerEntriesSimpleContact, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetOnCallSchedulesDetailResponseBodyDataRenderedLayerEntries(TeaModel):
    def __init__(self, start=None, end=None, simple_contact=None):
        # The date from which the scheduled user was supposed to start shift work.
        self.start = start  # type: str
        # The date on which the scheduled user was supposed to complete shift work.
        self.end = end  # type: str
        # The information about the scheduled user.
        self.simple_contact = simple_contact  # type: GetOnCallSchedulesDetailResponseBodyDataRenderedLayerEntriesSimpleContact

    def validate(self):
        if self.simple_contact:
            self.simple_contact.validate()

    def to_map(self):
        _map = super(GetOnCallSchedulesDetailResponseBodyDataRenderedLayerEntries, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start is not None:
            result['Start'] = self.start
        if self.end is not None:
            result['End'] = self.end
        if self.simple_contact is not None:
            result['SimpleContact'] = self.simple_contact.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('SimpleContact') is not None:
            temp_model = GetOnCallSchedulesDetailResponseBodyDataRenderedLayerEntriesSimpleContact()
            self.simple_contact = temp_model.from_map(m['SimpleContact'])
        return self


class GetOnCallSchedulesDetailResponseBodyDataRenderedSubstitudeEntriesSimpleContact(TeaModel):
    def __init__(self, id=None, name=None):
        # The ID of the substitute.
        self.id = id  # type: long
        # The name of the substitute.
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetOnCallSchedulesDetailResponseBodyDataRenderedSubstitudeEntriesSimpleContact, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetOnCallSchedulesDetailResponseBodyDataRenderedSubstitudeEntries(TeaModel):
    def __init__(self, end=None, simple_contact=None, start=None):
        # The date on which the substitute was supposed to complete shift work.
        self.end = end  # type: str
        # The information about the substitute.
        self.simple_contact = simple_contact  # type: GetOnCallSchedulesDetailResponseBodyDataRenderedSubstitudeEntriesSimpleContact
        # The date from which the substitute was supposed to start shift work.
        self.start = start  # type: str

    def validate(self):
        if self.simple_contact:
            self.simple_contact.validate()

    def to_map(self):
        _map = super(GetOnCallSchedulesDetailResponseBodyDataRenderedSubstitudeEntries, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end is not None:
            result['End'] = self.end
        if self.simple_contact is not None:
            result['SimpleContact'] = self.simple_contact.to_map()
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('SimpleContact') is not None:
            temp_model = GetOnCallSchedulesDetailResponseBodyDataRenderedSubstitudeEntriesSimpleContact()
            self.simple_contact = temp_model.from_map(m['SimpleContact'])
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class GetOnCallSchedulesDetailResponseBodyDataScheduleLayersRestrictions(TeaModel):
    def __init__(self, end_time_of_day=None, restriction_type=None, start_time_of_day=None):
        # The end time of the shift per day.
        self.end_time_of_day = end_time_of_day  # type: str
        # The type of the limit. Valid values:
        # 
        # *   daily_restriction
        # *   weekly_restriction
        self.restriction_type = restriction_type  # type: str
        # The start time of the shift per day.
        self.start_time_of_day = start_time_of_day  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetOnCallSchedulesDetailResponseBodyDataScheduleLayersRestrictions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time_of_day is not None:
            result['EndTimeOfDay'] = self.end_time_of_day
        if self.restriction_type is not None:
            result['RestrictionType'] = self.restriction_type
        if self.start_time_of_day is not None:
            result['StartTimeOfDay'] = self.start_time_of_day
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTimeOfDay') is not None:
            self.end_time_of_day = m.get('EndTimeOfDay')
        if m.get('RestrictionType') is not None:
            self.restriction_type = m.get('RestrictionType')
        if m.get('StartTimeOfDay') is not None:
            self.start_time_of_day = m.get('StartTimeOfDay')
        return self


class GetOnCallSchedulesDetailResponseBodyDataScheduleLayers(TeaModel):
    def __init__(self, contact_ids=None, restrictions=None, rotation_type=None, shift_length=None, start_time=None):
        # The ID list of users on duty.
        self.contact_ids = contact_ids  # type: list[long]
        # The limit on the time of the shift.
        self.restrictions = restrictions  # type: list[GetOnCallSchedulesDetailResponseBodyDataScheduleLayersRestrictions]
        # The type of the shift. Valid values:
        # 
        # *   DAY
        # *   WEEK
        # *   CUSTOM
        self.rotation_type = rotation_type  # type: str
        # The shift cycle. Unit: hours.
        self.shift_length = shift_length  # type: long
        # The date on which the shift change took effect.
        self.start_time = start_time  # type: str

    def validate(self):
        if self.restrictions:
            for k in self.restrictions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetOnCallSchedulesDetailResponseBodyDataScheduleLayers, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_ids is not None:
            result['ContactIds'] = self.contact_ids
        result['Restrictions'] = []
        if self.restrictions is not None:
            for k in self.restrictions:
                result['Restrictions'].append(k.to_map() if k else None)
        if self.rotation_type is not None:
            result['RotationType'] = self.rotation_type
        if self.shift_length is not None:
            result['ShiftLength'] = self.shift_length
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactIds') is not None:
            self.contact_ids = m.get('ContactIds')
        self.restrictions = []
        if m.get('Restrictions') is not None:
            for k in m.get('Restrictions'):
                temp_model = GetOnCallSchedulesDetailResponseBodyDataScheduleLayersRestrictions()
                self.restrictions.append(temp_model.from_map(k))
        if m.get('RotationType') is not None:
            self.rotation_type = m.get('RotationType')
        if m.get('ShiftLength') is not None:
            self.shift_length = m.get('ShiftLength')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetOnCallSchedulesDetailResponseBodyData(TeaModel):
    def __init__(self, alert_robot_id=None, description=None, id=None, name=None, rendered_finnal_entries=None,
                 rendered_layer_entries=None, rendered_substitude_entries=None, schedule_layers=None):
        # The URL of the DingTalk chatbot, which is used to receive notifications about shift changes.
        self.alert_robot_id = alert_robot_id  # type: long
        # The description of the scheduling policy.
        self.description = description  # type: str
        # The ID of the scheduling policy.
        self.id = id  # type: long
        # The name of the scheduling policy.
        self.name = name  # type: str
        # The information about the final user on duty.
        self.rendered_finnal_entries = rendered_finnal_entries  # type: list[GetOnCallSchedulesDetailResponseBodyDataRenderedFinnalEntries]
        # The scheduled users on duty within a time range.
        self.rendered_layer_entries = rendered_layer_entries  # type: list[list[GetOnCallSchedulesDetailResponseBodyDataRenderedLayerEntries]]
        # The information about the substitutes within a time range.
        self.rendered_substitude_entries = rendered_substitude_entries  # type: list[GetOnCallSchedulesDetailResponseBodyDataRenderedSubstitudeEntries]
        # The information about the shift.
        self.schedule_layers = schedule_layers  # type: list[GetOnCallSchedulesDetailResponseBodyDataScheduleLayers]

    def validate(self):
        if self.rendered_finnal_entries:
            for k in self.rendered_finnal_entries:
                if k:
                    k.validate()
        if self.rendered_layer_entries:
            for k in self.rendered_layer_entries:
                for k1 in k:
                    if k1:
                        k1.validate()
        if self.rendered_substitude_entries:
            for k in self.rendered_substitude_entries:
                if k:
                    k.validate()
        if self.schedule_layers:
            for k in self.schedule_layers:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetOnCallSchedulesDetailResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_robot_id is not None:
            result['AlertRobotId'] = self.alert_robot_id
        if self.description is not None:
            result['Description'] = self.description
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        result['RenderedFinnalEntries'] = []
        if self.rendered_finnal_entries is not None:
            for k in self.rendered_finnal_entries:
                result['RenderedFinnalEntries'].append(k.to_map() if k else None)
        result['RenderedLayerEntries'] = []
        if self.rendered_layer_entries is not None:
            for k in self.rendered_layer_entries:
                l1 = []
                for k1 in k:
                    l1.append(k1.to_map() if k1 else None)
                result['renderedLayerEntries'].append(l1)
        result['RenderedSubstitudeEntries'] = []
        if self.rendered_substitude_entries is not None:
            for k in self.rendered_substitude_entries:
                result['RenderedSubstitudeEntries'].append(k.to_map() if k else None)
        result['ScheduleLayers'] = []
        if self.schedule_layers is not None:
            for k in self.schedule_layers:
                result['ScheduleLayers'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertRobotId') is not None:
            self.alert_robot_id = m.get('AlertRobotId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.rendered_finnal_entries = []
        if m.get('RenderedFinnalEntries') is not None:
            for k in m.get('RenderedFinnalEntries'):
                temp_model = GetOnCallSchedulesDetailResponseBodyDataRenderedFinnalEntries()
                self.rendered_finnal_entries.append(temp_model.from_map(k))
        self.rendered_layer_entries = []
        if m.get('RenderedLayerEntries') is not None:
            for k in m.get('RenderedLayerEntries'):
                l1 = []
                for k1 in k:
                    temp_model = GetOnCallSchedulesDetailResponseBodyDataRenderedLayerEntries()
                    l1.append(temp_model.from_map(k1))
                self.rendered_layer_entries.append(l1)
        self.rendered_substitude_entries = []
        if m.get('RenderedSubstitudeEntries') is not None:
            for k in m.get('RenderedSubstitudeEntries'):
                temp_model = GetOnCallSchedulesDetailResponseBodyDataRenderedSubstitudeEntries()
                self.rendered_substitude_entries.append(temp_model.from_map(k))
        self.schedule_layers = []
        if m.get('ScheduleLayers') is not None:
            for k in m.get('ScheduleLayers'):
                temp_model = GetOnCallSchedulesDetailResponseBodyDataScheduleLayers()
                self.schedule_layers.append(temp_model.from_map(k))
        return self


class GetOnCallSchedulesDetailResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The information about the scheduling policy.
        self.data = data  # type: GetOnCallSchedulesDetailResponseBodyData
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetOnCallSchedulesDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetOnCallSchedulesDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetOnCallSchedulesDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetOnCallSchedulesDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetOnCallSchedulesDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetOnCallSchedulesDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPrometheusApiTokenRequest(TeaModel):
    def __init__(self, region_id=None):
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPrometheusApiTokenRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class GetPrometheusApiTokenResponseBody(TeaModel):
    def __init__(self, request_id=None, token=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The token required for integrating Prometheus Service.
        self.token = token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPrometheusApiTokenResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.token is not None:
            result['Token'] = self.token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        return self


class GetPrometheusApiTokenResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetPrometheusApiTokenResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetPrometheusApiTokenResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPrometheusApiTokenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPrometheusGlobalViewRequest(TeaModel):
    def __init__(self, global_view_cluster_id=None, region_id=None):
        self.global_view_cluster_id = global_view_cluster_id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPrometheusGlobalViewRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.global_view_cluster_id is not None:
            result['GlobalViewClusterId'] = self.global_view_cluster_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GlobalViewClusterId') is not None:
            self.global_view_cluster_id = m.get('GlobalViewClusterId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class GetPrometheusGlobalViewResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPrometheusGlobalViewResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetPrometheusGlobalViewResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetPrometheusGlobalViewResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetPrometheusGlobalViewResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPrometheusGlobalViewResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPrometheusInstanceRequest(TeaModel):
    def __init__(self, cluster_id=None, region_id=None):
        self.cluster_id = cluster_id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPrometheusInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class GetPrometheusInstanceResponseBodyDataTags(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPrometheusInstanceResponseBodyDataTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class GetPrometheusInstanceResponseBodyData(TeaModel):
    def __init__(self, cluster_id=None, cluster_name=None, cluster_type=None, grafana_instance_id=None,
                 payment_type=None, region_id=None, resource_group_id=None, resource_type=None, security_group_id=None,
                 sub_clusters_json=None, tags=None, user_id=None, v_switch_id=None, vpc_id=None):
        self.cluster_id = cluster_id  # type: str
        self.cluster_name = cluster_name  # type: str
        self.cluster_type = cluster_type  # type: str
        self.grafana_instance_id = grafana_instance_id  # type: str
        self.payment_type = payment_type  # type: str
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_type = resource_type  # type: str
        self.security_group_id = security_group_id  # type: str
        self.sub_clusters_json = sub_clusters_json  # type: str
        self.tags = tags  # type: list[GetPrometheusInstanceResponseBodyDataTags]
        self.user_id = user_id  # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetPrometheusInstanceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.grafana_instance_id is not None:
            result['GrafanaInstanceId'] = self.grafana_instance_id
        if self.payment_type is not None:
            result['PaymentType'] = self.payment_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.sub_clusters_json is not None:
            result['SubClustersJson'] = self.sub_clusters_json
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('GrafanaInstanceId') is not None:
            self.grafana_instance_id = m.get('GrafanaInstanceId')
        if m.get('PaymentType') is not None:
            self.payment_type = m.get('PaymentType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('SubClustersJson') is not None:
            self.sub_clusters_json = m.get('SubClustersJson')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = GetPrometheusInstanceResponseBodyDataTags()
                self.tags.append(temp_model.from_map(k))
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class GetPrometheusInstanceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: int
        self.data = data  # type: GetPrometheusInstanceResponseBodyData
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetPrometheusInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetPrometheusInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetPrometheusInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetPrometheusInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetPrometheusInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPrometheusInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPrometheusIntegrationRequest(TeaModel):
    def __init__(self, cluster_id=None, instance_id=None, integration_type=None, region_id=None):
        self.cluster_id = cluster_id  # type: str
        self.instance_id = instance_id  # type: long
        self.integration_type = integration_type  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPrometheusIntegrationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.integration_type is not None:
            result['IntegrationType'] = self.integration_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IntegrationType') is not None:
            self.integration_type = m.get('IntegrationType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class GetPrometheusIntegrationResponseBodyData(TeaModel):
    def __init__(self, can_delete=None, can_editor=None, cluster_id=None, container_name=None, describe=None,
                 exporter_type=None, instance_id=None, instance_name=None, integration_type=None, namespace=None,
                 need_upgrade=None, param=None, show_describe=None, show_log=None, status=None, target=None, version=None):
        self.can_delete = can_delete  # type: bool
        self.can_editor = can_editor  # type: bool
        self.cluster_id = cluster_id  # type: str
        self.container_name = container_name  # type: str
        self.describe = describe  # type: str
        self.exporter_type = exporter_type  # type: str
        self.instance_id = instance_id  # type: long
        self.instance_name = instance_name  # type: str
        self.integration_type = integration_type  # type: str
        self.namespace = namespace  # type: str
        self.need_upgrade = need_upgrade  # type: bool
        self.param = param  # type: str
        self.show_describe = show_describe  # type: bool
        self.show_log = show_log  # type: str
        self.status = status  # type: str
        self.target = target  # type: str
        self.version = version  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPrometheusIntegrationResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.can_delete is not None:
            result['CanDelete'] = self.can_delete
        if self.can_editor is not None:
            result['CanEditor'] = self.can_editor
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.container_name is not None:
            result['ContainerName'] = self.container_name
        if self.describe is not None:
            result['Describe'] = self.describe
        if self.exporter_type is not None:
            result['ExporterType'] = self.exporter_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.integration_type is not None:
            result['IntegrationType'] = self.integration_type
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.need_upgrade is not None:
            result['NeedUpgrade'] = self.need_upgrade
        if self.param is not None:
            result['Param'] = self.param
        if self.show_describe is not None:
            result['ShowDescribe'] = self.show_describe
        if self.show_log is not None:
            result['ShowLog'] = self.show_log
        if self.status is not None:
            result['Status'] = self.status
        if self.target is not None:
            result['Target'] = self.target
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CanDelete') is not None:
            self.can_delete = m.get('CanDelete')
        if m.get('CanEditor') is not None:
            self.can_editor = m.get('CanEditor')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ContainerName') is not None:
            self.container_name = m.get('ContainerName')
        if m.get('Describe') is not None:
            self.describe = m.get('Describe')
        if m.get('ExporterType') is not None:
            self.exporter_type = m.get('ExporterType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('IntegrationType') is not None:
            self.integration_type = m.get('IntegrationType')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NeedUpgrade') is not None:
            self.need_upgrade = m.get('NeedUpgrade')
        if m.get('Param') is not None:
            self.param = m.get('Param')
        if m.get('ShowDescribe') is not None:
            self.show_describe = m.get('ShowDescribe')
        if m.get('ShowLog') is not None:
            self.show_log = m.get('ShowLog')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class GetPrometheusIntegrationResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: int
        self.data = data  # type: GetPrometheusIntegrationResponseBodyData
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetPrometheusIntegrationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetPrometheusIntegrationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetPrometheusIntegrationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetPrometheusIntegrationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetPrometheusIntegrationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPrometheusIntegrationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPrometheusRemoteWriteRequest(TeaModel):
    def __init__(self, cluster_id=None, region_id=None, remote_write_name=None):
        # The ID of the Prometheus instance.
        self.cluster_id = cluster_id  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The name of the Remote Write configuration item.
        self.remote_write_name = remote_write_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPrometheusRemoteWriteRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.remote_write_name is not None:
            result['RemoteWriteName'] = self.remote_write_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RemoteWriteName') is not None:
            self.remote_write_name = m.get('RemoteWriteName')
        return self


class GetPrometheusRemoteWriteResponseBodyData(TeaModel):
    def __init__(self, cluster_id=None, remote_write_name=None, remote_write_yaml=None):
        # The ID of the Prometheus instance.
        self.cluster_id = cluster_id  # type: str
        # The name of the Remote Write configuration item.
        self.remote_write_name = remote_write_name  # type: str
        # The details of the Remote Write configuration item. The value is in the YAML format.
        self.remote_write_yaml = remote_write_yaml  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPrometheusRemoteWriteResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.remote_write_name is not None:
            result['RemoteWriteName'] = self.remote_write_name
        if self.remote_write_yaml is not None:
            result['RemoteWriteYaml'] = self.remote_write_yaml
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('RemoteWriteName') is not None:
            self.remote_write_name = m.get('RemoteWriteName')
        if m.get('RemoteWriteYaml') is not None:
            self.remote_write_yaml = m.get('RemoteWriteYaml')
        return self


class GetPrometheusRemoteWriteResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        # The HTTP status code that is returned. The HTTP 200 status code indicates that the call is successful.
        self.code = code  # type: int
        # The details of the Remote Write configuration item.
        self.data = data  # type: GetPrometheusRemoteWriteResponseBodyData
        # The message that is returned.
        self.message = message  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Indicates whether the call was successful. Valid values:
        # 
        # *   `true`
        # *   `false`
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetPrometheusRemoteWriteResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetPrometheusRemoteWriteResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetPrometheusRemoteWriteResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetPrometheusRemoteWriteResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetPrometheusRemoteWriteResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPrometheusRemoteWriteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRecordingRuleRequest(TeaModel):
    def __init__(self, cluster_id=None, region_id=None):
        # The ID of the cluster.
        self.cluster_id = cluster_id  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRecordingRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class GetRecordingRuleResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The recording rule.
        self.data = data  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRecordingRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetRecordingRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetRecordingRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetRecordingRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRecordingRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRetcodeAppByPidRequest(TeaModel):
    def __init__(self, pid=None, region_id=None):
        # The PID of the application. To obtain the PID of an application, perform the following steps: Log on to the Application Real-Time Monitoring Service (ARMS) console. In the left-side navigation pane, choose **Browser Monitoring** > **Browser Monitoring**. On the Browser Monitoring page, click the name of an application. The URL in the address bar contains the PID of the application. The PID is indicated in the pid=xxx format. The PID is usually percent encoded as xxx%40xxx. You must modify this value to remove the percent encoding. For example, if the PID in the URL is xxx%4074xxx, you must replace %40 with the at sign (@). The actual PID is xxx@74xxx.
        self.pid = pid  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRetcodeAppByPidRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class GetRetcodeAppByPidResponseBodyRetcodeAppTags(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag key.
        self.key = key  # type: str
        # The tag value.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRetcodeAppByPidResponseBodyRetcodeAppTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetRetcodeAppByPidResponseBodyRetcodeApp(TeaModel):
    def __init__(self, app_id=None, app_name=None, pid=None, resource_group_id=None, retcode_app_type=None,
                 tags=None):
        # The ID of the application. The parameter is an auto-increment parameter.
        self.app_id = app_id  # type: str
        # The name of the application that you want to monitor by using Browser Monitoring.
        self.app_name = app_name  # type: str
        # The ID of the application.
        self.pid = pid  # type: str
        # The ID of the resource group. You can obtain the resource group ID in the **Resource Management** console.
        self.resource_group_id = resource_group_id  # type: str
        # The type of the application. Valid values:
        # 
        # *   `web`: web application
        # *   `weex`: Weex mobile app
        # *   `mini_dd`: DingTalk mini program
        # *   `mini_alipay`: Alipay mini program
        # *   `mini_wx`: WeChat mini program
        # *   `mini_common`: mini program on other platforms
        self.retcode_app_type = retcode_app_type  # type: str
        # The tags.
        self.tags = tags  # type: list[GetRetcodeAppByPidResponseBodyRetcodeAppTags]

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetRetcodeAppByPidResponseBodyRetcodeApp, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.retcode_app_type is not None:
            result['RetcodeAppType'] = self.retcode_app_type
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('RetcodeAppType') is not None:
            self.retcode_app_type = m.get('RetcodeAppType')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = GetRetcodeAppByPidResponseBodyRetcodeAppTags()
                self.tags.append(temp_model.from_map(k))
        return self


class GetRetcodeAppByPidResponseBody(TeaModel):
    def __init__(self, request_id=None, retcode_app=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The returned application data.
        self.retcode_app = retcode_app  # type: GetRetcodeAppByPidResponseBodyRetcodeApp

    def validate(self):
        if self.retcode_app:
            self.retcode_app.validate()

    def to_map(self):
        _map = super(GetRetcodeAppByPidResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.retcode_app is not None:
            result['RetcodeApp'] = self.retcode_app.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RetcodeApp') is not None:
            temp_model = GetRetcodeAppByPidResponseBodyRetcodeApp()
            self.retcode_app = temp_model.from_map(m['RetcodeApp'])
        return self


class GetRetcodeAppByPidResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetRetcodeAppByPidResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetRetcodeAppByPidResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRetcodeAppByPidResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRetcodeDataByQueryRequest(TeaModel):
    def __init__(self, from_=None, pid=None, query=None, region_id=None, to=None):
        # The time when the query starts. This value is a UNIX timestamp representing the number of seconds that have elapsed since the epoch time January 1, 1970, 00:00:00 UTC.
        self.from_ = from_  # type: long
        # The ID of the application.
        # 
        # Log on to the **ARMS console**. In the left-side navigation pane, choose **Browser Monitoring** > **Browser Monitoring**. On the Browser Monitoring page, click the name of an application. The URL in the address bar contains the process ID (PID) of the application. The PID is indicated in the pid=xxx format. The PID is usually percent encoded as xxx%40xxx. You must modify this value to remove the percent encoding. For example, if the PID in the URL is eb4zdose6v%409781be0f44d\*\*\*\*, you must replace %40 with an at sign (@) to obtain eb4zdose6v@9781be0f44d\*\*\*\*.
        self.pid = pid  # type: str
        # The query statement that conforms to the query syntax of the Log Service Logstore.
        self.query = query  # type: str
        # The ID of the region in which the application is located.
        self.region_id = region_id  # type: str
        # The time when the query ends. This value is a UNIX timestamp representing the number of seconds that have elapsed since the epoch time January 1, 1970, 00:00:00 UTC.
        self.to = to  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRetcodeDataByQueryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.from_ is not None:
            result['From'] = self.from_
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.query is not None:
            result['Query'] = self.query
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.to is not None:
            result['To'] = self.to
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('Query') is not None:
            self.query = m.get('Query')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('To') is not None:
            self.to = m.get('To')
        return self


class GetRetcodeDataByQueryResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        # The HTTP status code returned for the request. Valid values:
        # 
        # *   2XX: The request was successful.
        # *   3XX: A redirection message was returned.
        # *   4XX: The request was invalid.
        # *   5XX: A server error occurred.
        self.code = code  # type: str
        # The browser monitoring data returned for a successful call.
        self.data = data  # type: str
        # The error message returned if the call fails.
        self.message = message  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Indicates whether the call was successful. Valid values:
        # 
        # *   true: The call was successful.
        # *   false: The call failed.
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRetcodeDataByQueryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetRetcodeDataByQueryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetRetcodeDataByQueryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetRetcodeDataByQueryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRetcodeDataByQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRetcodeLogstoreRequest(TeaModel):
    def __init__(self, pid=None, region_id=None):
        # The ID of the application. Log on to the ARMS console. In the left-side navigation pane, choose **Browser Monitoring** > **Browser Monitoring**. On the Browser Monitoring page, click the name of an application. The URL in the address bar contains the process ID (PID) of the application. The PID is indicated in the pid=xxx format. The PID is usually percent encoded as xxx%40xxx. You must modify this value to remove the percent encoding. For example, if the PID in the URL is xxx%4074xxx, you must replace %40 with the at sign (@) to obtain xxx@74xxx.
        self.pid = pid  # type: str
        # The ID of the region where Log Service resides.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRetcodeLogstoreRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class GetRetcodeLogstoreResponseBodyDataRetcodeSLSConfig(TeaModel):
    def __init__(self, logstore=None, project=None, region_id=None):
        # The Log Service Logstore.
        self.logstore = logstore  # type: str
        # The Log Service project.
        self.project = project  # type: str
        # The ID of the region where Log Service resides.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRetcodeLogstoreResponseBodyDataRetcodeSLSConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.logstore is not None:
            result['Logstore'] = self.logstore
        if self.project is not None:
            result['Project'] = self.project
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Logstore') is not None:
            self.logstore = m.get('Logstore')
        if m.get('Project') is not None:
            self.project = m.get('Project')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class GetRetcodeLogstoreResponseBodyData(TeaModel):
    def __init__(self, message=None, retcode_slsconfig=None, status=None):
        # The content of the log.
        self.message = message  # type: str
        # The information about Log Service.
        self.retcode_slsconfig = retcode_slsconfig  # type: GetRetcodeLogstoreResponseBodyDataRetcodeSLSConfig
        # Indicates the status of the request.
        self.status = status  # type: str

    def validate(self):
        if self.retcode_slsconfig:
            self.retcode_slsconfig.validate()

    def to_map(self):
        _map = super(GetRetcodeLogstoreResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.retcode_slsconfig is not None:
            result['RetcodeSLSConfig'] = self.retcode_slsconfig.to_map()
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RetcodeSLSConfig') is not None:
            temp_model = GetRetcodeLogstoreResponseBodyDataRetcodeSLSConfig()
            self.retcode_slsconfig = temp_model.from_map(m['RetcodeSLSConfig'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetRetcodeLogstoreResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The returned struct.
        self.data = data  # type: GetRetcodeLogstoreResponseBodyData
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetRetcodeLogstoreResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetRetcodeLogstoreResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetRetcodeLogstoreResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetRetcodeLogstoreResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetRetcodeLogstoreResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRetcodeLogstoreResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRetcodeShareUrlRequest(TeaModel):
    def __init__(self, pid=None):
        # The process identifier (PID) of the application. For more information about how to obtain the PID, see [Obtain the PID of an application](~~186100~~#title-imy-7gj-qhr).
        self.pid = pid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRetcodeShareUrlRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pid is not None:
            result['Pid'] = self.pid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        return self


class GetRetcodeShareUrlResponseBody(TeaModel):
    def __init__(self, request_id=None, url=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The logon-free URL of the application.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRetcodeShareUrlResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetRetcodeShareUrlResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetRetcodeShareUrlResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetRetcodeShareUrlResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRetcodeShareUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSourceMapInfoRequest(TeaModel):
    def __init__(self, ascending_sequence=None, edition=None, id=None, keyword=None, order_field=None,
                 region_id=None):
        # The order in which the files are sorted. Valid values:
        # 
        # *   true: ascending order
        # *   false: descending order
        self.ascending_sequence = ascending_sequence  # type: bool
        # The version of the SourceMap file.
        self.edition = edition  # type: str
        # The IDs of the SourceMap files.
        self.id = id  # type: str
        # The keyword in the file name. The files are searched by keyword.
        self.keyword = keyword  # type: str
        # The criterion by which the files are sorted. Valid values:
        # 
        # *   version: The files are sorted by version.
        # *   uploadTime: The files are sorted by upload time.
        self.order_field = order_field  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSourceMapInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ascending_sequence is not None:
            result['AscendingSequence'] = self.ascending_sequence
        if self.edition is not None:
            result['Edition'] = self.edition
        if self.id is not None:
            result['ID'] = self.id
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.order_field is not None:
            result['OrderField'] = self.order_field
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AscendingSequence') is not None:
            self.ascending_sequence = m.get('AscendingSequence')
        if m.get('Edition') is not None:
            self.edition = m.get('Edition')
        if m.get('ID') is not None:
            self.id = m.get('ID')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('OrderField') is not None:
            self.order_field = m.get('OrderField')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class GetSourceMapInfoResponseBodySourceMapList(TeaModel):
    def __init__(self, fid=None, file_name=None, size=None, upload_time=None, version=None):
        # The ID of the SourceMap file.
        self.fid = fid  # type: str
        # The name of the SourceMap file.
        self.file_name = file_name  # type: str
        # The size of the file. Unit: KB.
        self.size = size  # type: str
        # The timestamp when the file was uploaded.
        self.upload_time = upload_time  # type: str
        # The version of the file.
        self.version = version  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSourceMapInfoResponseBodySourceMapList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fid is not None:
            result['Fid'] = self.fid
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.size is not None:
            result['Size'] = self.size
        if self.upload_time is not None:
            result['UploadTime'] = self.upload_time
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Fid') is not None:
            self.fid = m.get('Fid')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('UploadTime') is not None:
            self.upload_time = m.get('UploadTime')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class GetSourceMapInfoResponseBody(TeaModel):
    def __init__(self, request_id=None, source_map_list=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The details of the SourceMap files.
        self.source_map_list = source_map_list  # type: list[GetSourceMapInfoResponseBodySourceMapList]

    def validate(self):
        if self.source_map_list:
            for k in self.source_map_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetSourceMapInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SourceMapList'] = []
        if self.source_map_list is not None:
            for k in self.source_map_list:
                result['SourceMapList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.source_map_list = []
        if m.get('SourceMapList') is not None:
            for k in m.get('SourceMapList'):
                temp_model = GetSourceMapInfoResponseBodySourceMapList()
                self.source_map_list.append(temp_model.from_map(k))
        return self


class GetSourceMapInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetSourceMapInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSourceMapInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSourceMapInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetStackRequest(TeaModel):
    def __init__(self, end_time=None, pid=None, region_id=None, rpc_id=None, start_time=None, trace_id=None):
        # The end time of the call method.
        self.end_time = end_time  # type: long
        # The process identifier (PID) of the application. For more information about how to obtain the PID, see [Obtain the PID of an application](https://help.aliyun.com/document_detail/186100.html?spm=a2c4g.11186623.6.792.1b50654cqcDPyk#title-imy-7gj-qhr).
        self.pid = pid  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The ID of the remote procedure call (RPC) mode. You can obtain the ID by calling the **GetTrace** operation.
        self.rpc_id = rpc_id  # type: str
        # The start time of the call method.
        self.start_time = start_time  # type: long
        # The ID of the trace. You can log on to the Application Real-Time Monitoring Service (ARMS) console and obtain the trace ID on the **Trace Query** page.
        self.trace_id = trace_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetStackRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rpc_id is not None:
            result['RpcID'] = self.rpc_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.trace_id is not None:
            result['TraceID'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RpcID') is not None:
            self.rpc_id = m.get('RpcID')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TraceID') is not None:
            self.trace_id = m.get('TraceID')
        return self


class GetStackResponseBodyStackInfoExtInfo(TeaModel):
    def __init__(self, info=None, type=None):
        # The content of the custom parameter.
        self.info = info  # type: str
        # The type of the custom parameter.
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetStackResponseBodyStackInfoExtInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.info is not None:
            result['Info'] = self.info
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Info') is not None:
            self.info = m.get('Info')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetStackResponseBodyStackInfo(TeaModel):
    def __init__(self, api=None, duration=None, exception=None, ext_info=None, line=None, rpc_id=None,
                 service_name=None, start_time=None):
        # The name of the operation.
        self.api = api  # type: str
        # The duration. Unit: milliseconds.
        self.duration = duration  # type: long
        # The error message.
        self.exception = exception  # type: str
        # The extended information.
        self.ext_info = ext_info  # type: GetStackResponseBodyStackInfoExtInfo
        # The number of rows in the method stack information.
        self.line = line  # type: str
        # RPC ID。
        self.rpc_id = rpc_id  # type: str
        # The name of the service.
        self.service_name = service_name  # type: str
        # The start time of the call method.
        self.start_time = start_time  # type: long

    def validate(self):
        if self.ext_info:
            self.ext_info.validate()

    def to_map(self):
        _map = super(GetStackResponseBodyStackInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api is not None:
            result['Api'] = self.api
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.exception is not None:
            result['Exception'] = self.exception
        if self.ext_info is not None:
            result['ExtInfo'] = self.ext_info.to_map()
        if self.line is not None:
            result['Line'] = self.line
        if self.rpc_id is not None:
            result['RpcId'] = self.rpc_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Api') is not None:
            self.api = m.get('Api')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Exception') is not None:
            self.exception = m.get('Exception')
        if m.get('ExtInfo') is not None:
            temp_model = GetStackResponseBodyStackInfoExtInfo()
            self.ext_info = temp_model.from_map(m['ExtInfo'])
        if m.get('Line') is not None:
            self.line = m.get('Line')
        if m.get('RpcId') is not None:
            self.rpc_id = m.get('RpcId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetStackResponseBody(TeaModel):
    def __init__(self, request_id=None, stack_info=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The information of the method stack.
        self.stack_info = stack_info  # type: list[GetStackResponseBodyStackInfo]

    def validate(self):
        if self.stack_info:
            for k in self.stack_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetStackResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['StackInfo'] = []
        if self.stack_info is not None:
            for k in self.stack_info:
                result['StackInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.stack_info = []
        if m.get('StackInfo') is not None:
            for k in m.get('StackInfo'):
                temp_model = GetStackResponseBodyStackInfo()
                self.stack_info.append(temp_model.from_map(k))
        return self


class GetStackResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetStackResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetStackResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetStackResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSyntheticTaskDetailRequest(TeaModel):
    def __init__(self, region_id=None, task_id=None):
        self.region_id = region_id  # type: str
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSyntheticTaskDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetSyntheticTaskDetailResponseBodyTaskDetailCommonParamAlertList(TeaModel):
    def __init__(self, general_alert=None, is_critical=None, name=None, serious_alert=None, symbols=None):
        self.general_alert = general_alert  # type: str
        self.is_critical = is_critical  # type: str
        self.name = name  # type: str
        self.serious_alert = serious_alert  # type: str
        self.symbols = symbols  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSyntheticTaskDetailResponseBodyTaskDetailCommonParamAlertList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.general_alert is not None:
            result['GeneralAlert'] = self.general_alert
        if self.is_critical is not None:
            result['IsCritical'] = self.is_critical
        if self.name is not None:
            result['Name'] = self.name
        if self.serious_alert is not None:
            result['SeriousAlert'] = self.serious_alert
        if self.symbols is not None:
            result['Symbols'] = self.symbols
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GeneralAlert') is not None:
            self.general_alert = m.get('GeneralAlert')
        if m.get('IsCritical') is not None:
            self.is_critical = m.get('IsCritical')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SeriousAlert') is not None:
            self.serious_alert = m.get('SeriousAlert')
        if m.get('Symbols') is not None:
            self.symbols = m.get('Symbols')
        return self


class GetSyntheticTaskDetailResponseBodyTaskDetailCommonParam(TeaModel):
    def __init__(self, alarm_flag=None, alert_list=None, alert_notifier_id=None, alert_policy_id=None,
                 monitor_samples=None, start_execution_time=None):
        self.alarm_flag = alarm_flag  # type: long
        self.alert_list = alert_list  # type: list[GetSyntheticTaskDetailResponseBodyTaskDetailCommonParamAlertList]
        self.alert_notifier_id = alert_notifier_id  # type: str
        self.alert_policy_id = alert_policy_id  # type: str
        self.monitor_samples = monitor_samples  # type: str
        self.start_execution_time = start_execution_time  # type: str

    def validate(self):
        if self.alert_list:
            for k in self.alert_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetSyntheticTaskDetailResponseBodyTaskDetailCommonParam, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_flag is not None:
            result['AlarmFlag'] = self.alarm_flag
        result['AlertList'] = []
        if self.alert_list is not None:
            for k in self.alert_list:
                result['AlertList'].append(k.to_map() if k else None)
        if self.alert_notifier_id is not None:
            result['AlertNotifierId'] = self.alert_notifier_id
        if self.alert_policy_id is not None:
            result['AlertPolicyId'] = self.alert_policy_id
        if self.monitor_samples is not None:
            result['MonitorSamples'] = self.monitor_samples
        if self.start_execution_time is not None:
            result['StartExecutionTime'] = self.start_execution_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlarmFlag') is not None:
            self.alarm_flag = m.get('AlarmFlag')
        self.alert_list = []
        if m.get('AlertList') is not None:
            for k in m.get('AlertList'):
                temp_model = GetSyntheticTaskDetailResponseBodyTaskDetailCommonParamAlertList()
                self.alert_list.append(temp_model.from_map(k))
        if m.get('AlertNotifierId') is not None:
            self.alert_notifier_id = m.get('AlertNotifierId')
        if m.get('AlertPolicyId') is not None:
            self.alert_policy_id = m.get('AlertPolicyId')
        if m.get('MonitorSamples') is not None:
            self.monitor_samples = m.get('MonitorSamples')
        if m.get('StartExecutionTime') is not None:
            self.start_execution_time = m.get('StartExecutionTime')
        return self


class GetSyntheticTaskDetailResponseBodyTaskDetailDownload(TeaModel):
    def __init__(self, connection_timeout=None, download_custom_header_content=None, download_custom_host=None,
                 download_custom_host_ip=None, download_kernel=None, download_redirect=None, download_transmission_size=None,
                 monitor_timeout=None, quick_protocol=None, validate_keywords=None, verify_way=None, white_list=None):
        self.connection_timeout = connection_timeout  # type: long
        self.download_custom_header_content = download_custom_header_content  # type: str
        self.download_custom_host = download_custom_host  # type: long
        self.download_custom_host_ip = download_custom_host_ip  # type: str
        self.download_kernel = download_kernel  # type: long
        self.download_redirect = download_redirect  # type: long
        self.download_transmission_size = download_transmission_size  # type: long
        self.monitor_timeout = monitor_timeout  # type: long
        self.quick_protocol = quick_protocol  # type: str
        self.validate_keywords = validate_keywords  # type: str
        self.verify_way = verify_way  # type: long
        self.white_list = white_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSyntheticTaskDetailResponseBodyTaskDetailDownload, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_timeout is not None:
            result['ConnectionTimeout'] = self.connection_timeout
        if self.download_custom_header_content is not None:
            result['DownloadCustomHeaderContent'] = self.download_custom_header_content
        if self.download_custom_host is not None:
            result['DownloadCustomHost'] = self.download_custom_host
        if self.download_custom_host_ip is not None:
            result['DownloadCustomHostIp'] = self.download_custom_host_ip
        if self.download_kernel is not None:
            result['DownloadKernel'] = self.download_kernel
        if self.download_redirect is not None:
            result['DownloadRedirect'] = self.download_redirect
        if self.download_transmission_size is not None:
            result['DownloadTransmissionSize'] = self.download_transmission_size
        if self.monitor_timeout is not None:
            result['MonitorTimeout'] = self.monitor_timeout
        if self.quick_protocol is not None:
            result['QuickProtocol'] = self.quick_protocol
        if self.validate_keywords is not None:
            result['ValidateKeywords'] = self.validate_keywords
        if self.verify_way is not None:
            result['VerifyWay'] = self.verify_way
        if self.white_list is not None:
            result['WhiteList'] = self.white_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConnectionTimeout') is not None:
            self.connection_timeout = m.get('ConnectionTimeout')
        if m.get('DownloadCustomHeaderContent') is not None:
            self.download_custom_header_content = m.get('DownloadCustomHeaderContent')
        if m.get('DownloadCustomHost') is not None:
            self.download_custom_host = m.get('DownloadCustomHost')
        if m.get('DownloadCustomHostIp') is not None:
            self.download_custom_host_ip = m.get('DownloadCustomHostIp')
        if m.get('DownloadKernel') is not None:
            self.download_kernel = m.get('DownloadKernel')
        if m.get('DownloadRedirect') is not None:
            self.download_redirect = m.get('DownloadRedirect')
        if m.get('DownloadTransmissionSize') is not None:
            self.download_transmission_size = m.get('DownloadTransmissionSize')
        if m.get('MonitorTimeout') is not None:
            self.monitor_timeout = m.get('MonitorTimeout')
        if m.get('QuickProtocol') is not None:
            self.quick_protocol = m.get('QuickProtocol')
        if m.get('ValidateKeywords') is not None:
            self.validate_keywords = m.get('ValidateKeywords')
        if m.get('VerifyWay') is not None:
            self.verify_way = m.get('VerifyWay')
        if m.get('WhiteList') is not None:
            self.white_list = m.get('WhiteList')
        return self


class GetSyntheticTaskDetailResponseBodyTaskDetailExtendInterval(TeaModel):
    def __init__(self, days=None, end_minute=None, end_time=None, endhour=None, start_hour=None, start_minute=None,
                 start_time=None):
        self.days = days  # type: list[long]
        self.end_minute = end_minute  # type: long
        self.end_time = end_time  # type: str
        self.endhour = endhour  # type: long
        self.start_hour = start_hour  # type: long
        self.start_minute = start_minute  # type: long
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSyntheticTaskDetailResponseBodyTaskDetailExtendInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.days is not None:
            result['Days'] = self.days
        if self.end_minute is not None:
            result['EndMinute'] = self.end_minute
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.endhour is not None:
            result['Endhour'] = self.endhour
        if self.start_hour is not None:
            result['StartHour'] = self.start_hour
        if self.start_minute is not None:
            result['StartMinute'] = self.start_minute
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Days') is not None:
            self.days = m.get('Days')
        if m.get('EndMinute') is not None:
            self.end_minute = m.get('EndMinute')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Endhour') is not None:
            self.endhour = m.get('Endhour')
        if m.get('StartHour') is not None:
            self.start_hour = m.get('StartHour')
        if m.get('StartMinute') is not None:
            self.start_minute = m.get('StartMinute')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetSyntheticTaskDetailResponseBodyTaskDetailMonitorList(TeaModel):
    def __init__(self, city_code=None, monitor_type=None, net_service_id=None, send_count=None):
        self.city_code = city_code  # type: long
        self.monitor_type = monitor_type  # type: long
        self.net_service_id = net_service_id  # type: long
        self.send_count = send_count  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSyntheticTaskDetailResponseBodyTaskDetailMonitorList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['CityCode'] = self.city_code
        if self.monitor_type is not None:
            result['MonitorType'] = self.monitor_type
        if self.net_service_id is not None:
            result['NetServiceId'] = self.net_service_id
        if self.send_count is not None:
            result['SendCount'] = self.send_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CityCode') is not None:
            self.city_code = m.get('CityCode')
        if m.get('MonitorType') is not None:
            self.monitor_type = m.get('MonitorType')
        if m.get('NetServiceId') is not None:
            self.net_service_id = m.get('NetServiceId')
        if m.get('SendCount') is not None:
            self.send_count = m.get('SendCount')
        return self


class GetSyntheticTaskDetailResponseBodyTaskDetailNav(TeaModel):
    def __init__(self, dns_hijack_whitelist=None, element_blacklist=None, execute_active_x=None,
                 execute_applet=None, execute_script=None, filter_invalid_ip=None, flow_hijack_jump_times=None,
                 flow_hijack_logo=None, monitor_timeout=None, nav_automatic_scrolling=None, nav_custom_header=None,
                 nav_custom_header_content=None, nav_custom_host=None, nav_custom_host_ip=None, nav_disable_cache=None,
                 nav_disable_compression=None, nav_ignore_certificate_error=None, nav_redirect=None, nav_return_element=None,
                 page_tampering=None, process_name=None, quic_domain=None, quic_version=None, request_header=None,
                 slow_element_threshold=None, verify_string_blacklist=None, verify_string_whitelist=None, wait_completion_time=None):
        self.dns_hijack_whitelist = dns_hijack_whitelist  # type: str
        self.element_blacklist = element_blacklist  # type: str
        self.execute_active_x = execute_active_x  # type: long
        self.execute_applet = execute_applet  # type: long
        self.execute_script = execute_script  # type: long
        self.filter_invalid_ip = filter_invalid_ip  # type: long
        self.flow_hijack_jump_times = flow_hijack_jump_times  # type: long
        self.flow_hijack_logo = flow_hijack_logo  # type: str
        self.monitor_timeout = monitor_timeout  # type: long
        self.nav_automatic_scrolling = nav_automatic_scrolling  # type: long
        self.nav_custom_header = nav_custom_header  # type: str
        self.nav_custom_header_content = nav_custom_header_content  # type: str
        self.nav_custom_host = nav_custom_host  # type: long
        self.nav_custom_host_ip = nav_custom_host_ip  # type: str
        self.nav_disable_cache = nav_disable_cache  # type: long
        self.nav_disable_compression = nav_disable_compression  # type: long
        self.nav_ignore_certificate_error = nav_ignore_certificate_error  # type: long
        self.nav_redirect = nav_redirect  # type: long
        self.nav_return_element = nav_return_element  # type: long
        self.page_tampering = page_tampering  # type: str
        self.process_name = process_name  # type: str
        self.quic_domain = quic_domain  # type: str
        self.quic_version = quic_version  # type: long
        self.request_header = request_header  # type: long
        self.slow_element_threshold = slow_element_threshold  # type: long
        self.verify_string_blacklist = verify_string_blacklist  # type: str
        self.verify_string_whitelist = verify_string_whitelist  # type: str
        self.wait_completion_time = wait_completion_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSyntheticTaskDetailResponseBodyTaskDetailNav, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dns_hijack_whitelist is not None:
            result['DnsHijackWhitelist'] = self.dns_hijack_whitelist
        if self.element_blacklist is not None:
            result['ElementBlacklist'] = self.element_blacklist
        if self.execute_active_x is not None:
            result['ExecuteActiveX'] = self.execute_active_x
        if self.execute_applet is not None:
            result['ExecuteApplet'] = self.execute_applet
        if self.execute_script is not None:
            result['ExecuteScript'] = self.execute_script
        if self.filter_invalid_ip is not None:
            result['FilterInvalidIP'] = self.filter_invalid_ip
        if self.flow_hijack_jump_times is not None:
            result['FlowHijackJumpTimes'] = self.flow_hijack_jump_times
        if self.flow_hijack_logo is not None:
            result['FlowHijackLogo'] = self.flow_hijack_logo
        if self.monitor_timeout is not None:
            result['MonitorTimeout'] = self.monitor_timeout
        if self.nav_automatic_scrolling is not None:
            result['NavAutomaticScrolling'] = self.nav_automatic_scrolling
        if self.nav_custom_header is not None:
            result['NavCustomHeader'] = self.nav_custom_header
        if self.nav_custom_header_content is not None:
            result['NavCustomHeaderContent'] = self.nav_custom_header_content
        if self.nav_custom_host is not None:
            result['NavCustomHost'] = self.nav_custom_host
        if self.nav_custom_host_ip is not None:
            result['NavCustomHostIp'] = self.nav_custom_host_ip
        if self.nav_disable_cache is not None:
            result['NavDisableCache'] = self.nav_disable_cache
        if self.nav_disable_compression is not None:
            result['NavDisableCompression'] = self.nav_disable_compression
        if self.nav_ignore_certificate_error is not None:
            result['NavIgnoreCertificateError'] = self.nav_ignore_certificate_error
        if self.nav_redirect is not None:
            result['NavRedirect'] = self.nav_redirect
        if self.nav_return_element is not None:
            result['NavReturnElement'] = self.nav_return_element
        if self.page_tampering is not None:
            result['PageTampering'] = self.page_tampering
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.quic_domain is not None:
            result['QuicDomain'] = self.quic_domain
        if self.quic_version is not None:
            result['QuicVersion'] = self.quic_version
        if self.request_header is not None:
            result['RequestHeader'] = self.request_header
        if self.slow_element_threshold is not None:
            result['SlowElementThreshold'] = self.slow_element_threshold
        if self.verify_string_blacklist is not None:
            result['VerifyStringBlacklist'] = self.verify_string_blacklist
        if self.verify_string_whitelist is not None:
            result['VerifyStringWhitelist'] = self.verify_string_whitelist
        if self.wait_completion_time is not None:
            result['WaitCompletionTime'] = self.wait_completion_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DnsHijackWhitelist') is not None:
            self.dns_hijack_whitelist = m.get('DnsHijackWhitelist')
        if m.get('ElementBlacklist') is not None:
            self.element_blacklist = m.get('ElementBlacklist')
        if m.get('ExecuteActiveX') is not None:
            self.execute_active_x = m.get('ExecuteActiveX')
        if m.get('ExecuteApplet') is not None:
            self.execute_applet = m.get('ExecuteApplet')
        if m.get('ExecuteScript') is not None:
            self.execute_script = m.get('ExecuteScript')
        if m.get('FilterInvalidIP') is not None:
            self.filter_invalid_ip = m.get('FilterInvalidIP')
        if m.get('FlowHijackJumpTimes') is not None:
            self.flow_hijack_jump_times = m.get('FlowHijackJumpTimes')
        if m.get('FlowHijackLogo') is not None:
            self.flow_hijack_logo = m.get('FlowHijackLogo')
        if m.get('MonitorTimeout') is not None:
            self.monitor_timeout = m.get('MonitorTimeout')
        if m.get('NavAutomaticScrolling') is not None:
            self.nav_automatic_scrolling = m.get('NavAutomaticScrolling')
        if m.get('NavCustomHeader') is not None:
            self.nav_custom_header = m.get('NavCustomHeader')
        if m.get('NavCustomHeaderContent') is not None:
            self.nav_custom_header_content = m.get('NavCustomHeaderContent')
        if m.get('NavCustomHost') is not None:
            self.nav_custom_host = m.get('NavCustomHost')
        if m.get('NavCustomHostIp') is not None:
            self.nav_custom_host_ip = m.get('NavCustomHostIp')
        if m.get('NavDisableCache') is not None:
            self.nav_disable_cache = m.get('NavDisableCache')
        if m.get('NavDisableCompression') is not None:
            self.nav_disable_compression = m.get('NavDisableCompression')
        if m.get('NavIgnoreCertificateError') is not None:
            self.nav_ignore_certificate_error = m.get('NavIgnoreCertificateError')
        if m.get('NavRedirect') is not None:
            self.nav_redirect = m.get('NavRedirect')
        if m.get('NavReturnElement') is not None:
            self.nav_return_element = m.get('NavReturnElement')
        if m.get('PageTampering') is not None:
            self.page_tampering = m.get('PageTampering')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('QuicDomain') is not None:
            self.quic_domain = m.get('QuicDomain')
        if m.get('QuicVersion') is not None:
            self.quic_version = m.get('QuicVersion')
        if m.get('RequestHeader') is not None:
            self.request_header = m.get('RequestHeader')
        if m.get('SlowElementThreshold') is not None:
            self.slow_element_threshold = m.get('SlowElementThreshold')
        if m.get('VerifyStringBlacklist') is not None:
            self.verify_string_blacklist = m.get('VerifyStringBlacklist')
        if m.get('VerifyStringWhitelist') is not None:
            self.verify_string_whitelist = m.get('VerifyStringWhitelist')
        if m.get('WaitCompletionTime') is not None:
            self.wait_completion_time = m.get('WaitCompletionTime')
        return self


class GetSyntheticTaskDetailResponseBodyTaskDetailNet(TeaModel):
    def __init__(self, net_dig_switch=None, net_dns_ns=None, net_dns_query_method=None, net_dns_server=None,
                 net_dns_switch=None, net_dns_timeout=None, net_icmp_active=None, net_icmp_data_cut=None, net_icmp_interval=None,
                 net_icmp_num=None, net_icmp_size=None, net_icmp_switch=None, net_icmp_timeout=None, net_trace_route_num=None,
                 net_trace_route_switch=None, net_trace_route_timeout=None, white_list=None):
        self.net_dig_switch = net_dig_switch  # type: long
        self.net_dns_ns = net_dns_ns  # type: str
        self.net_dns_query_method = net_dns_query_method  # type: str
        self.net_dns_server = net_dns_server  # type: long
        self.net_dns_switch = net_dns_switch  # type: long
        self.net_dns_timeout = net_dns_timeout  # type: str
        self.net_icmp_active = net_icmp_active  # type: long
        self.net_icmp_data_cut = net_icmp_data_cut  # type: long
        self.net_icmp_interval = net_icmp_interval  # type: long
        self.net_icmp_num = net_icmp_num  # type: long
        self.net_icmp_size = net_icmp_size  # type: long
        self.net_icmp_switch = net_icmp_switch  # type: long
        self.net_icmp_timeout = net_icmp_timeout  # type: long
        self.net_trace_route_num = net_trace_route_num  # type: long
        self.net_trace_route_switch = net_trace_route_switch  # type: long
        self.net_trace_route_timeout = net_trace_route_timeout  # type: long
        self.white_list = white_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSyntheticTaskDetailResponseBodyTaskDetailNet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.net_dig_switch is not None:
            result['NetDigSwitch'] = self.net_dig_switch
        if self.net_dns_ns is not None:
            result['NetDnsNs'] = self.net_dns_ns
        if self.net_dns_query_method is not None:
            result['NetDnsQueryMethod'] = self.net_dns_query_method
        if self.net_dns_server is not None:
            result['NetDnsServer'] = self.net_dns_server
        if self.net_dns_switch is not None:
            result['NetDnsSwitch'] = self.net_dns_switch
        if self.net_dns_timeout is not None:
            result['NetDnsTimeout'] = self.net_dns_timeout
        if self.net_icmp_active is not None:
            result['NetIcmpActive'] = self.net_icmp_active
        if self.net_icmp_data_cut is not None:
            result['NetIcmpDataCut'] = self.net_icmp_data_cut
        if self.net_icmp_interval is not None:
            result['NetIcmpInterval'] = self.net_icmp_interval
        if self.net_icmp_num is not None:
            result['NetIcmpNum'] = self.net_icmp_num
        if self.net_icmp_size is not None:
            result['NetIcmpSize'] = self.net_icmp_size
        if self.net_icmp_switch is not None:
            result['NetIcmpSwitch'] = self.net_icmp_switch
        if self.net_icmp_timeout is not None:
            result['NetIcmpTimeout'] = self.net_icmp_timeout
        if self.net_trace_route_num is not None:
            result['NetTraceRouteNum'] = self.net_trace_route_num
        if self.net_trace_route_switch is not None:
            result['NetTraceRouteSwitch'] = self.net_trace_route_switch
        if self.net_trace_route_timeout is not None:
            result['NetTraceRouteTimeout'] = self.net_trace_route_timeout
        if self.white_list is not None:
            result['WhiteList'] = self.white_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NetDigSwitch') is not None:
            self.net_dig_switch = m.get('NetDigSwitch')
        if m.get('NetDnsNs') is not None:
            self.net_dns_ns = m.get('NetDnsNs')
        if m.get('NetDnsQueryMethod') is not None:
            self.net_dns_query_method = m.get('NetDnsQueryMethod')
        if m.get('NetDnsServer') is not None:
            self.net_dns_server = m.get('NetDnsServer')
        if m.get('NetDnsSwitch') is not None:
            self.net_dns_switch = m.get('NetDnsSwitch')
        if m.get('NetDnsTimeout') is not None:
            self.net_dns_timeout = m.get('NetDnsTimeout')
        if m.get('NetIcmpActive') is not None:
            self.net_icmp_active = m.get('NetIcmpActive')
        if m.get('NetIcmpDataCut') is not None:
            self.net_icmp_data_cut = m.get('NetIcmpDataCut')
        if m.get('NetIcmpInterval') is not None:
            self.net_icmp_interval = m.get('NetIcmpInterval')
        if m.get('NetIcmpNum') is not None:
            self.net_icmp_num = m.get('NetIcmpNum')
        if m.get('NetIcmpSize') is not None:
            self.net_icmp_size = m.get('NetIcmpSize')
        if m.get('NetIcmpSwitch') is not None:
            self.net_icmp_switch = m.get('NetIcmpSwitch')
        if m.get('NetIcmpTimeout') is not None:
            self.net_icmp_timeout = m.get('NetIcmpTimeout')
        if m.get('NetTraceRouteNum') is not None:
            self.net_trace_route_num = m.get('NetTraceRouteNum')
        if m.get('NetTraceRouteSwitch') is not None:
            self.net_trace_route_switch = m.get('NetTraceRouteSwitch')
        if m.get('NetTraceRouteTimeout') is not None:
            self.net_trace_route_timeout = m.get('NetTraceRouteTimeout')
        if m.get('WhiteList') is not None:
            self.white_list = m.get('WhiteList')
        return self


class GetSyntheticTaskDetailResponseBodyTaskDetailProtocolRequestContentBodyFormdata(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSyntheticTaskDetailResponseBodyTaskDetailProtocolRequestContentBodyFormdata, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetSyntheticTaskDetailResponseBodyTaskDetailProtocolRequestContentBodyUrlencoded(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSyntheticTaskDetailResponseBodyTaskDetailProtocolRequestContentBodyUrlencoded, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetSyntheticTaskDetailResponseBodyTaskDetailProtocolRequestContentBody(TeaModel):
    def __init__(self, formdata=None, language=None, mode=None, raw=None, urlencoded=None):
        self.formdata = formdata  # type: GetSyntheticTaskDetailResponseBodyTaskDetailProtocolRequestContentBodyFormdata
        self.language = language  # type: str
        self.mode = mode  # type: str
        self.raw = raw  # type: str
        self.urlencoded = urlencoded  # type: GetSyntheticTaskDetailResponseBodyTaskDetailProtocolRequestContentBodyUrlencoded

    def validate(self):
        if self.formdata:
            self.formdata.validate()
        if self.urlencoded:
            self.urlencoded.validate()

    def to_map(self):
        _map = super(GetSyntheticTaskDetailResponseBodyTaskDetailProtocolRequestContentBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.formdata is not None:
            result['Formdata'] = self.formdata.to_map()
        if self.language is not None:
            result['Language'] = self.language
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.raw is not None:
            result['Raw'] = self.raw
        if self.urlencoded is not None:
            result['Urlencoded'] = self.urlencoded.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Formdata') is not None:
            temp_model = GetSyntheticTaskDetailResponseBodyTaskDetailProtocolRequestContentBodyFormdata()
            self.formdata = temp_model.from_map(m['Formdata'])
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Raw') is not None:
            self.raw = m.get('Raw')
        if m.get('Urlencoded') is not None:
            temp_model = GetSyntheticTaskDetailResponseBodyTaskDetailProtocolRequestContentBodyUrlencoded()
            self.urlencoded = temp_model.from_map(m['Urlencoded'])
        return self


class GetSyntheticTaskDetailResponseBodyTaskDetailProtocolRequestContentHeader(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSyntheticTaskDetailResponseBodyTaskDetailProtocolRequestContentHeader, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetSyntheticTaskDetailResponseBodyTaskDetailProtocolRequestContent(TeaModel):
    def __init__(self, body=None, header=None, method=None):
        self.body = body  # type: GetSyntheticTaskDetailResponseBodyTaskDetailProtocolRequestContentBody
        self.header = header  # type: list[GetSyntheticTaskDetailResponseBodyTaskDetailProtocolRequestContentHeader]
        self.method = method  # type: str

    def validate(self):
        if self.body:
            self.body.validate()
        if self.header:
            for k in self.header:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetSyntheticTaskDetailResponseBodyTaskDetailProtocolRequestContent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.body is not None:
            result['Body'] = self.body.to_map()
        result['Header'] = []
        if self.header is not None:
            for k in self.header:
                result['Header'].append(k.to_map() if k else None)
        if self.method is not None:
            result['Method'] = self.method
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Body') is not None:
            temp_model = GetSyntheticTaskDetailResponseBodyTaskDetailProtocolRequestContentBody()
            self.body = temp_model.from_map(m['Body'])
        self.header = []
        if m.get('Header') is not None:
            for k in m.get('Header'):
                temp_model = GetSyntheticTaskDetailResponseBodyTaskDetailProtocolRequestContentHeader()
                self.header.append(temp_model.from_map(k))
        if m.get('Method') is not None:
            self.method = m.get('Method')
        return self


class GetSyntheticTaskDetailResponseBodyTaskDetailProtocol(TeaModel):
    def __init__(self, character_encoding=None, custom_host=None, custom_host_ip=None,
                 protocol_connection_timeout=None, protocol_monitor_timeout=None, received_data_size=None, request_content=None,
                 verify_content=None, verify_way=None):
        self.character_encoding = character_encoding  # type: long
        self.custom_host = custom_host  # type: long
        self.custom_host_ip = custom_host_ip  # type: str
        self.protocol_connection_timeout = protocol_connection_timeout  # type: long
        self.protocol_monitor_timeout = protocol_monitor_timeout  # type: long
        self.received_data_size = received_data_size  # type: long
        self.request_content = request_content  # type: GetSyntheticTaskDetailResponseBodyTaskDetailProtocolRequestContent
        self.verify_content = verify_content  # type: str
        self.verify_way = verify_way  # type: long

    def validate(self):
        if self.request_content:
            self.request_content.validate()

    def to_map(self):
        _map = super(GetSyntheticTaskDetailResponseBodyTaskDetailProtocol, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.character_encoding is not None:
            result['CharacterEncoding'] = self.character_encoding
        if self.custom_host is not None:
            result['CustomHost'] = self.custom_host
        if self.custom_host_ip is not None:
            result['CustomHostIp'] = self.custom_host_ip
        if self.protocol_connection_timeout is not None:
            result['ProtocolConnectionTimeout'] = self.protocol_connection_timeout
        if self.protocol_monitor_timeout is not None:
            result['ProtocolMonitorTimeout'] = self.protocol_monitor_timeout
        if self.received_data_size is not None:
            result['ReceivedDataSize'] = self.received_data_size
        if self.request_content is not None:
            result['RequestContent'] = self.request_content.to_map()
        if self.verify_content is not None:
            result['VerifyContent'] = self.verify_content
        if self.verify_way is not None:
            result['VerifyWay'] = self.verify_way
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CharacterEncoding') is not None:
            self.character_encoding = m.get('CharacterEncoding')
        if m.get('CustomHost') is not None:
            self.custom_host = m.get('CustomHost')
        if m.get('CustomHostIp') is not None:
            self.custom_host_ip = m.get('CustomHostIp')
        if m.get('ProtocolConnectionTimeout') is not None:
            self.protocol_connection_timeout = m.get('ProtocolConnectionTimeout')
        if m.get('ProtocolMonitorTimeout') is not None:
            self.protocol_monitor_timeout = m.get('ProtocolMonitorTimeout')
        if m.get('ReceivedDataSize') is not None:
            self.received_data_size = m.get('ReceivedDataSize')
        if m.get('RequestContent') is not None:
            temp_model = GetSyntheticTaskDetailResponseBodyTaskDetailProtocolRequestContent()
            self.request_content = temp_model.from_map(m['RequestContent'])
        if m.get('VerifyContent') is not None:
            self.verify_content = m.get('VerifyContent')
        if m.get('VerifyWay') is not None:
            self.verify_way = m.get('VerifyWay')
        return self


class GetSyntheticTaskDetailResponseBodyTaskDetail(TeaModel):
    def __init__(self, common_param=None, download=None, extend_interval=None, interval_time=None,
                 interval_type=None, ip_type=None, monitor_list=None, monitor_list_string=None, nav=None, net=None, protocol=None,
                 task_id=None, task_name=None, task_type=None, url=None):
        self.common_param = common_param  # type: GetSyntheticTaskDetailResponseBodyTaskDetailCommonParam
        self.download = download  # type: GetSyntheticTaskDetailResponseBodyTaskDetailDownload
        self.extend_interval = extend_interval  # type: GetSyntheticTaskDetailResponseBodyTaskDetailExtendInterval
        self.interval_time = interval_time  # type: long
        self.interval_type = interval_type  # type: long
        self.ip_type = ip_type  # type: long
        self.monitor_list = monitor_list  # type: list[GetSyntheticTaskDetailResponseBodyTaskDetailMonitorList]
        self.monitor_list_string = monitor_list_string  # type: str
        self.nav = nav  # type: GetSyntheticTaskDetailResponseBodyTaskDetailNav
        self.net = net  # type: GetSyntheticTaskDetailResponseBodyTaskDetailNet
        self.protocol = protocol  # type: GetSyntheticTaskDetailResponseBodyTaskDetailProtocol
        self.task_id = task_id  # type: long
        self.task_name = task_name  # type: str
        self.task_type = task_type  # type: long
        self.url = url  # type: str

    def validate(self):
        if self.common_param:
            self.common_param.validate()
        if self.download:
            self.download.validate()
        if self.extend_interval:
            self.extend_interval.validate()
        if self.monitor_list:
            for k in self.monitor_list:
                if k:
                    k.validate()
        if self.nav:
            self.nav.validate()
        if self.net:
            self.net.validate()
        if self.protocol:
            self.protocol.validate()

    def to_map(self):
        _map = super(GetSyntheticTaskDetailResponseBodyTaskDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_param is not None:
            result['CommonParam'] = self.common_param.to_map()
        if self.download is not None:
            result['Download'] = self.download.to_map()
        if self.extend_interval is not None:
            result['ExtendInterval'] = self.extend_interval.to_map()
        if self.interval_time is not None:
            result['IntervalTime'] = self.interval_time
        if self.interval_type is not None:
            result['IntervalType'] = self.interval_type
        if self.ip_type is not None:
            result['IpType'] = self.ip_type
        result['MonitorList'] = []
        if self.monitor_list is not None:
            for k in self.monitor_list:
                result['MonitorList'].append(k.to_map() if k else None)
        if self.monitor_list_string is not None:
            result['MonitorListString'] = self.monitor_list_string
        if self.nav is not None:
            result['Nav'] = self.nav.to_map()
        if self.net is not None:
            result['Net'] = self.net.to_map()
        if self.protocol is not None:
            result['Protocol'] = self.protocol.to_map()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CommonParam') is not None:
            temp_model = GetSyntheticTaskDetailResponseBodyTaskDetailCommonParam()
            self.common_param = temp_model.from_map(m['CommonParam'])
        if m.get('Download') is not None:
            temp_model = GetSyntheticTaskDetailResponseBodyTaskDetailDownload()
            self.download = temp_model.from_map(m['Download'])
        if m.get('ExtendInterval') is not None:
            temp_model = GetSyntheticTaskDetailResponseBodyTaskDetailExtendInterval()
            self.extend_interval = temp_model.from_map(m['ExtendInterval'])
        if m.get('IntervalTime') is not None:
            self.interval_time = m.get('IntervalTime')
        if m.get('IntervalType') is not None:
            self.interval_type = m.get('IntervalType')
        if m.get('IpType') is not None:
            self.ip_type = m.get('IpType')
        self.monitor_list = []
        if m.get('MonitorList') is not None:
            for k in m.get('MonitorList'):
                temp_model = GetSyntheticTaskDetailResponseBodyTaskDetailMonitorList()
                self.monitor_list.append(temp_model.from_map(k))
        if m.get('MonitorListString') is not None:
            self.monitor_list_string = m.get('MonitorListString')
        if m.get('Nav') is not None:
            temp_model = GetSyntheticTaskDetailResponseBodyTaskDetailNav()
            self.nav = temp_model.from_map(m['Nav'])
        if m.get('Net') is not None:
            temp_model = GetSyntheticTaskDetailResponseBodyTaskDetailNet()
            self.net = temp_model.from_map(m['Net'])
        if m.get('Protocol') is not None:
            temp_model = GetSyntheticTaskDetailResponseBodyTaskDetailProtocol()
            self.protocol = temp_model.from_map(m['Protocol'])
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetSyntheticTaskDetailResponseBody(TeaModel):
    def __init__(self, request_id=None, task_detail=None):
        self.request_id = request_id  # type: str
        self.task_detail = task_detail  # type: GetSyntheticTaskDetailResponseBodyTaskDetail

    def validate(self):
        if self.task_detail:
            self.task_detail.validate()

    def to_map(self):
        _map = super(GetSyntheticTaskDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_detail is not None:
            result['TaskDetail'] = self.task_detail.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskDetail') is not None:
            temp_model = GetSyntheticTaskDetailResponseBodyTaskDetail()
            self.task_detail = temp_model.from_map(m['TaskDetail'])
        return self


class GetSyntheticTaskDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetSyntheticTaskDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSyntheticTaskDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSyntheticTaskDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSyntheticTaskListRequest(TeaModel):
    def __init__(self, direction=None, order=None, page_num=None, page_size=None, region_id=None, task_name=None,
                 task_status=None, task_type=None, url=None):
        self.direction = direction  # type: str
        self.order = order  # type: str
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long
        self.region_id = region_id  # type: str
        self.task_name = task_name  # type: str
        self.task_status = task_status  # type: str
        self.task_type = task_type  # type: str
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSyntheticTaskListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.order is not None:
            result['Order'] = self.order
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetSyntheticTaskListResponseBodyPageInfoList(TeaModel):
    def __init__(self, create_time=None, monitor_number=None, task_id=None, task_name=None, task_status=None,
                 task_type=None, task_type_name=None, url=None, usable=None):
        self.create_time = create_time  # type: str
        self.monitor_number = monitor_number  # type: long
        self.task_id = task_id  # type: str
        self.task_name = task_name  # type: str
        self.task_status = task_status  # type: str
        self.task_type = task_type  # type: long
        self.task_type_name = task_type_name  # type: str
        self.url = url  # type: str
        self.usable = usable  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSyntheticTaskListResponseBodyPageInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.monitor_number is not None:
            result['MonitorNumber'] = self.monitor_number
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.task_type_name is not None:
            result['TaskTypeName'] = self.task_type_name
        if self.url is not None:
            result['Url'] = self.url
        if self.usable is not None:
            result['Usable'] = self.usable
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('MonitorNumber') is not None:
            self.monitor_number = m.get('MonitorNumber')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('TaskTypeName') is not None:
            self.task_type_name = m.get('TaskTypeName')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('Usable') is not None:
            self.usable = m.get('Usable')
        return self


class GetSyntheticTaskListResponseBodyPageInfo(TeaModel):
    def __init__(self, has_next_page=None, has_previous_page=None, is_first_page=None, is_last_page=None, list=None,
                 navigate_first_page=None, navigate_last_page=None, navigate_page_nums=None, next_page=None, pages=None, prepage=None,
                 size=None, total=None):
        self.has_next_page = has_next_page  # type: str
        self.has_previous_page = has_previous_page  # type: bool
        self.is_first_page = is_first_page  # type: bool
        self.is_last_page = is_last_page  # type: bool
        self.list = list  # type: list[GetSyntheticTaskListResponseBodyPageInfoList]
        self.navigate_first_page = navigate_first_page  # type: str
        self.navigate_last_page = navigate_last_page  # type: str
        self.navigate_page_nums = navigate_page_nums  # type: str
        self.next_page = next_page  # type: str
        self.pages = pages  # type: str
        self.prepage = prepage  # type: str
        self.size = size  # type: long
        self.total = total  # type: long

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetSyntheticTaskListResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.has_next_page is not None:
            result['HasNextPage'] = self.has_next_page
        if self.has_previous_page is not None:
            result['HasPreviousPage'] = self.has_previous_page
        if self.is_first_page is not None:
            result['IsFirstPage'] = self.is_first_page
        if self.is_last_page is not None:
            result['IsLastPage'] = self.is_last_page
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.navigate_first_page is not None:
            result['NavigateFirstPage'] = self.navigate_first_page
        if self.navigate_last_page is not None:
            result['NavigateLastPage'] = self.navigate_last_page
        if self.navigate_page_nums is not None:
            result['NavigatePageNums'] = self.navigate_page_nums
        if self.next_page is not None:
            result['NextPage'] = self.next_page
        if self.pages is not None:
            result['Pages'] = self.pages
        if self.prepage is not None:
            result['Prepage'] = self.prepage
        if self.size is not None:
            result['Size'] = self.size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HasNextPage') is not None:
            self.has_next_page = m.get('HasNextPage')
        if m.get('HasPreviousPage') is not None:
            self.has_previous_page = m.get('HasPreviousPage')
        if m.get('IsFirstPage') is not None:
            self.is_first_page = m.get('IsFirstPage')
        if m.get('IsLastPage') is not None:
            self.is_last_page = m.get('IsLastPage')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = GetSyntheticTaskListResponseBodyPageInfoList()
                self.list.append(temp_model.from_map(k))
        if m.get('NavigateFirstPage') is not None:
            self.navigate_first_page = m.get('NavigateFirstPage')
        if m.get('NavigateLastPage') is not None:
            self.navigate_last_page = m.get('NavigateLastPage')
        if m.get('NavigatePageNums') is not None:
            self.navigate_page_nums = m.get('NavigatePageNums')
        if m.get('NextPage') is not None:
            self.next_page = m.get('NextPage')
        if m.get('Pages') is not None:
            self.pages = m.get('Pages')
        if m.get('Prepage') is not None:
            self.prepage = m.get('Prepage')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSyntheticTaskListResponseBody(TeaModel):
    def __init__(self, page_info=None, request_id=None):
        self.page_info = page_info  # type: GetSyntheticTaskListResponseBodyPageInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(GetSyntheticTaskListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = GetSyntheticTaskListResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetSyntheticTaskListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetSyntheticTaskListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSyntheticTaskListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSyntheticTaskListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSyntheticTaskMonitorsRequest(TeaModel):
    def __init__(self, region_id=None):
        # The ID of the region in which the application is located.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSyntheticTaskMonitorsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class GetSyntheticTaskMonitorsResponseBodyData(TeaModel):
    def __init__(self, busy=None, city=None, city_code=None, client_type=None, district=None, net_service_id=None,
                 net_service_name=None):
        # The task status.
        # 
        # *   0: active
        # *   1: busy
        self.busy = busy  # type: long
        # The name of the city to which the monitoring point belongs.
        self.city = city  # type: str
        # The ID of the city to which the monitoring point belongs.
        self.city_code = city_code  # type: long
        # The client type:
        # 
        # *   1: IDC
        # *   2: Last mile
        self.client_type = client_type  # type: long
        # The region to which the monitoring point belongs.
        self.district = district  # type: str
        # The ID of the carrier.
        self.net_service_id = net_service_id  # type: long
        # The name of the carrier.
        self.net_service_name = net_service_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSyntheticTaskMonitorsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.busy is not None:
            result['Busy'] = self.busy
        if self.city is not None:
            result['City'] = self.city
        if self.city_code is not None:
            result['CityCode'] = self.city_code
        if self.client_type is not None:
            result['ClientType'] = self.client_type
        if self.district is not None:
            result['District'] = self.district
        if self.net_service_id is not None:
            result['NetServiceId'] = self.net_service_id
        if self.net_service_name is not None:
            result['NetServiceName'] = self.net_service_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Busy') is not None:
            self.busy = m.get('Busy')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('CityCode') is not None:
            self.city_code = m.get('CityCode')
        if m.get('ClientType') is not None:
            self.client_type = m.get('ClientType')
        if m.get('District') is not None:
            self.district = m.get('District')
        if m.get('NetServiceId') is not None:
            self.net_service_id = m.get('NetServiceId')
        if m.get('NetServiceName') is not None:
            self.net_service_name = m.get('NetServiceName')
        return self


class GetSyntheticTaskMonitorsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, msg=None, request_id=None):
        # The status code returned.
        # 
        # *   1001: The request was successful.
        # *   1002: The request failed.
        # *   1003: Parameter errors occurred.
        # *   1004: Authentication failed.
        # *   1006: The task does not exist.
        # *   1099: Internal errors occurred.
        self.code = code  # type: str
        # The details of the monitoring point.
        self.data = data  # type: list[GetSyntheticTaskMonitorsResponseBodyData]
        # The message that is returned when the request failed.
        self.msg = msg  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetSyntheticTaskMonitorsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.msg is not None:
            result['Msg'] = self.msg
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetSyntheticTaskMonitorsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Msg') is not None:
            self.msg = m.get('Msg')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetSyntheticTaskMonitorsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetSyntheticTaskMonitorsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSyntheticTaskMonitorsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSyntheticTaskMonitorsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTraceRequest(TeaModel):
    def __init__(self, end_time=None, region_id=None, start_time=None, trace_id=None):
        # The end of the time range to query. Unit: milliseconds.
        # 
        # > If the ID of the trace is 30 characters in length, this parameter is optional. Otherwise, this parameter is required.
        self.end_time = end_time  # type: long
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The beginning of the time range to query. Unit: milliseconds.
        # 
        # > If the ID of the trace is 30 characters in length, this parameter is optional. Otherwise, this parameter is required.
        self.start_time = start_time  # type: long
        # The ID of the trace. You can log on to the ARMS console and obtain the trace ID on the **Trace Query** page or **Interface Snapshot** tab.
        self.trace_id = trace_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTraceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.trace_id is not None:
            result['TraceID'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TraceID') is not None:
            self.trace_id = m.get('TraceID')
        return self


class GetTraceResponseBodySpansLogEventListTagEntryList(TeaModel):
    def __init__(self, key=None, value=None):
        # The key of the tag.
        self.key = key  # type: str
        # The value of the tag.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTraceResponseBodySpansLogEventListTagEntryList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetTraceResponseBodySpansLogEventList(TeaModel):
    def __init__(self, tag_entry_list=None, timestamp=None):
        # The tags of the trace.
        self.tag_entry_list = tag_entry_list  # type: list[GetTraceResponseBodySpansLogEventListTagEntryList]
        # The timestamp when the log event was generated.
        self.timestamp = timestamp  # type: long

    def validate(self):
        if self.tag_entry_list:
            for k in self.tag_entry_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetTraceResponseBodySpansLogEventList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TagEntryList'] = []
        if self.tag_entry_list is not None:
            for k in self.tag_entry_list:
                result['TagEntryList'].append(k.to_map() if k else None)
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tag_entry_list = []
        if m.get('TagEntryList') is not None:
            for k in m.get('TagEntryList'):
                temp_model = GetTraceResponseBodySpansLogEventListTagEntryList()
                self.tag_entry_list.append(temp_model.from_map(k))
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class GetTraceResponseBodySpansTagEntryList(TeaModel):
    def __init__(self, key=None, value=None):
        # The key of the tag.
        self.key = key  # type: str
        # The value of the tag.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTraceResponseBodySpansTagEntryList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetTraceResponseBodySpans(TeaModel):
    def __init__(self, children=None, duration=None, have_stack=None, log_event_list=None, operation_name=None,
                 parent_span_id=None, result_code=None, rpc_id=None, rpc_type=None, service_ip=None, service_name=None,
                 span_id=None, tag_entry_list=None, timestamp=None, trace_id=None):
        # The child spans of the current span.
        self.children = children  # type: list[dict[str, any]]
        # The amount of time consumed by the trace. Unit: milliseconds.
        self.duration = duration  # type: long
        # Indicates whether a method stack was provided.
        # 
        # - `true`: A method stack was provided.
        # - `false` : No method stack was provided.
        self.have_stack = have_stack  # type: bool
        # The log events in the trace.
        self.log_event_list = log_event_list  # type: list[GetTraceResponseBodySpansLogEventList]
        # The name of the traced span.
        self.operation_name = operation_name  # type: str
        # The ID of the parent span.
        self.parent_span_id = parent_span_id  # type: str
        # The returned code.
        self.result_code = result_code  # type: str
        # The ID of the remote procedure call (RPC) mode.
        self.rpc_id = rpc_id  # type: str
        # The type of the remote procedure call (RPC) mode.
        self.rpc_type = rpc_type  # type: int
        # The IP address of the host where the application resides.
        self.service_ip = service_ip  # type: str
        # The name of the application.
        self.service_name = service_name  # type: str
        # Span ID。
        self.span_id = span_id  # type: str
        # The tags of the trace.
        self.tag_entry_list = tag_entry_list  # type: list[GetTraceResponseBodySpansTagEntryList]
        # The timestamp when the span was generated.
        self.timestamp = timestamp  # type: long
        # The ID of the trace.
        self.trace_id = trace_id  # type: str

    def validate(self):
        if self.log_event_list:
            for k in self.log_event_list:
                if k:
                    k.validate()
        if self.tag_entry_list:
            for k in self.tag_entry_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetTraceResponseBodySpans, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.children is not None:
            result['Children'] = self.children
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.have_stack is not None:
            result['HaveStack'] = self.have_stack
        result['LogEventList'] = []
        if self.log_event_list is not None:
            for k in self.log_event_list:
                result['LogEventList'].append(k.to_map() if k else None)
        if self.operation_name is not None:
            result['OperationName'] = self.operation_name
        if self.parent_span_id is not None:
            result['ParentSpanId'] = self.parent_span_id
        if self.result_code is not None:
            result['ResultCode'] = self.result_code
        if self.rpc_id is not None:
            result['RpcId'] = self.rpc_id
        if self.rpc_type is not None:
            result['RpcType'] = self.rpc_type
        if self.service_ip is not None:
            result['ServiceIp'] = self.service_ip
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.span_id is not None:
            result['SpanId'] = self.span_id
        result['TagEntryList'] = []
        if self.tag_entry_list is not None:
            for k in self.tag_entry_list:
                result['TagEntryList'].append(k.to_map() if k else None)
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.trace_id is not None:
            result['TraceID'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Children') is not None:
            self.children = m.get('Children')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('HaveStack') is not None:
            self.have_stack = m.get('HaveStack')
        self.log_event_list = []
        if m.get('LogEventList') is not None:
            for k in m.get('LogEventList'):
                temp_model = GetTraceResponseBodySpansLogEventList()
                self.log_event_list.append(temp_model.from_map(k))
        if m.get('OperationName') is not None:
            self.operation_name = m.get('OperationName')
        if m.get('ParentSpanId') is not None:
            self.parent_span_id = m.get('ParentSpanId')
        if m.get('ResultCode') is not None:
            self.result_code = m.get('ResultCode')
        if m.get('RpcId') is not None:
            self.rpc_id = m.get('RpcId')
        if m.get('RpcType') is not None:
            self.rpc_type = m.get('RpcType')
        if m.get('ServiceIp') is not None:
            self.service_ip = m.get('ServiceIp')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('SpanId') is not None:
            self.span_id = m.get('SpanId')
        self.tag_entry_list = []
        if m.get('TagEntryList') is not None:
            for k in m.get('TagEntryList'):
                temp_model = GetTraceResponseBodySpansTagEntryList()
                self.tag_entry_list.append(temp_model.from_map(k))
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('TraceID') is not None:
            self.trace_id = m.get('TraceID')
        return self


class GetTraceResponseBody(TeaModel):
    def __init__(self, request_id=None, spans=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The details of the trace.
        self.spans = spans  # type: list[GetTraceResponseBodySpans]

    def validate(self):
        if self.spans:
            for k in self.spans:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetTraceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Spans'] = []
        if self.spans is not None:
            for k in self.spans:
                result['Spans'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.spans = []
        if m.get('Spans') is not None:
            for k in m.get('Spans'):
                temp_model = GetTraceResponseBodySpans()
                self.spans.append(temp_model.from_map(k))
        return self


class GetTraceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetTraceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetTraceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetTraceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTraceAppRequest(TeaModel):
    def __init__(self, pid=None, region_id=None):
        # The process identifier (PID) of the application. For more information about how to obtain the PID, see [Obtain the PID of an application](https://help.aliyun.com/document_detail/186100.html?spm=a2c4g.11186623.6.792.1b50654cqcDPyk#title-imy-7gj-qhr).
        self.pid = pid  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTraceAppRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class GetTraceAppResponseBodyTraceAppTags(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag key.
        self.key = key  # type: str
        # The tag value.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTraceAppResponseBodyTraceAppTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetTraceAppResponseBodyTraceApp(TeaModel):
    def __init__(self, app_id=None, app_name=None, create_time=None, labels=None, pid=None, region_id=None,
                 resource_group_id=None, show=None, source=None, tags=None, type=None, update_time=None, user_id=None):
        # The ID of the application.
        self.app_id = app_id  # type: long
        # The name of the application.
        self.app_name = app_name  # type: str
        # The timestamp generated when the monitoring task was created.
        self.create_time = create_time  # type: long
        # The aliases of the application.
        self.labels = labels  # type: list[str]
        # The PID of the application.
        self.pid = pid  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        # Indicates whether the application was displayed in the Application Real-Time Monitoring Service (ARMS) console. Valid values:
        # 
        # *   `true`: The application was displayed in the ARMS console.
        # *   `false`: The application was not displayed in the ARMS console.
        self.show = show  # type: bool
        # The source of the application.
        self.source = source  # type: str
        # The list of tags.
        self.tags = tags  # type: list[GetTraceAppResponseBodyTraceAppTags]
        # The type of the monitoring task. Valid values:
        # 
        # *   `TRACE`: Application Monitoring
        # *   `RETCODE`: Browser Monitoring
        self.type = type  # type: str
        # The timestamp generated when the monitoring task was updated.
        self.update_time = update_time  # type: long
        # The ID of the user.
        self.user_id = user_id  # type: str

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetTraceAppResponseBodyTraceApp, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.labels is not None:
            result['Labels'] = self.labels
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.show is not None:
            result['Show'] = self.show
        if self.source is not None:
            result['Source'] = self.source
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        if self.type is not None:
            result['Type'] = self.type
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Labels') is not None:
            self.labels = m.get('Labels')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Show') is not None:
            self.show = m.get('Show')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = GetTraceAppResponseBodyTraceAppTags()
                self.tags.append(temp_model.from_map(k))
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetTraceAppResponseBody(TeaModel):
    def __init__(self, request_id=None, trace_app=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The returned struct.
        self.trace_app = trace_app  # type: GetTraceAppResponseBodyTraceApp

    def validate(self):
        if self.trace_app:
            self.trace_app.validate()

    def to_map(self):
        _map = super(GetTraceAppResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.trace_app is not None:
            result['TraceApp'] = self.trace_app.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TraceApp') is not None:
            temp_model = GetTraceAppResponseBodyTraceApp()
            self.trace_app = temp_model.from_map(m['TraceApp'])
        return self


class GetTraceAppResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetTraceAppResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetTraceAppResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetTraceAppResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ImportAppAlertRulesRequest(TeaModel):
    def __init__(self, contact_group_ids=None, is_auto_start=None, pids=None, region_id=None,
                 templage_alert_config=None, template_alert_id=None):
        # The IDs of the alert contact groups. The value must be a JSON array.
        self.contact_group_ids = contact_group_ids  # type: str
        # Specifies whether to enable the alert rule after it is created. Default value: `false`.
        # 
        # *   `true`: enables the alert rule.
        # *   `false`: disables the alert rule.
        self.is_auto_start = is_auto_start  # type: bool
        # The process identifiers (PIDs) of the applications associated with the alert rule. The value must be a JSON array. For more information about how to obtain the PID, see [Obtain the PID of an application](~~186100#section-bkl-3j6-ezg~~).
        self.pids = pids  # type: str
        # The ID of the region where the associated applications reside.
        self.region_id = region_id  # type: str
        # The configurations of the alert template based on which you want to create an alert rule. The value must be a JSON string. You must set at least one of the **TemplateAlertId** and **TemplageAlertConfig** parameters. If you set both parameters, the **TemplateAlertId** parameter prevails. For more information about the TemplageAlertConfig parameter, see the following **additional information about the TemplageAlertConfig parameter**.
        self.templage_alert_config = templage_alert_config  # type: str
        # The ID of the alert template. You must set at least one of the **TemplateAlertId** and **TemplageAlertConfig** parameters. If you set both parameters, the **TemplateAlertId** parameter prevails.
        self.template_alert_id = template_alert_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImportAppAlertRulesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_ids is not None:
            result['ContactGroupIds'] = self.contact_group_ids
        if self.is_auto_start is not None:
            result['IsAutoStart'] = self.is_auto_start
        if self.pids is not None:
            result['Pids'] = self.pids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.templage_alert_config is not None:
            result['TemplageAlertConfig'] = self.templage_alert_config
        if self.template_alert_id is not None:
            result['TemplateAlertId'] = self.template_alert_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactGroupIds') is not None:
            self.contact_group_ids = m.get('ContactGroupIds')
        if m.get('IsAutoStart') is not None:
            self.is_auto_start = m.get('IsAutoStart')
        if m.get('Pids') is not None:
            self.pids = m.get('Pids')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TemplageAlertConfig') is not None:
            self.templage_alert_config = m.get('TemplageAlertConfig')
        if m.get('TemplateAlertId') is not None:
            self.template_alert_id = m.get('TemplateAlertId')
        return self


class ImportAppAlertRulesResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The ID of the alert rule.
        self.data = data  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImportAppAlertRulesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ImportAppAlertRulesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ImportAppAlertRulesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ImportAppAlertRulesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ImportAppAlertRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InstallCmsExporterRequest(TeaModel):
    def __init__(self, cluster_id=None, cms_args=None, direct_args=None, enable_tag=None, region_id=None):
        # The ID of the cluster.
        self.cluster_id = cluster_id  # type: str
        # The cloud services that you want to monitor. The CmsArgs parameter is the startup parameter of the cms-exporter collector. Separate multiple cloud services with number signs (`#`).
        self.cms_args = cms_args  # type: str
        # The recently monitored cloud services. Separate multiple cloud services with number signs (`#`).
        self.direct_args = direct_args  # type: str
        # Specifies whether to collect the aliyun tags attached to each cloud service. Default value: false.
        self.enable_tag = enable_tag  # type: bool
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InstallCmsExporterRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cms_args is not None:
            result['CmsArgs'] = self.cms_args
        if self.direct_args is not None:
            result['DirectArgs'] = self.direct_args
        if self.enable_tag is not None:
            result['EnableTag'] = self.enable_tag
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('CmsArgs') is not None:
            self.cms_args = m.get('CmsArgs')
        if m.get('DirectArgs') is not None:
            self.direct_args = m.get('DirectArgs')
        if m.get('EnableTag') is not None:
            self.enable_tag = m.get('EnableTag')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class InstallCmsExporterResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # Indicates whether the request was successful.
        self.data = data  # type: str
        # The ID of the request. You can query logs and troubleshoot issues based on the ID.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InstallCmsExporterResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class InstallCmsExporterResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: InstallCmsExporterResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(InstallCmsExporterResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InstallCmsExporterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InstallManagedPrometheusRequest(TeaModel):
    def __init__(self, cluster_id=None, cluster_name=None, cluster_type=None, grafana_instance_id=None,
                 kube_config=None, region_id=None, resource_group_id=None, security_group_id=None, v_switch_id=None,
                 vpc_id=None):
        # The ID of the ASK cluster.
        self.cluster_id = cluster_id  # type: str
        # 集群名称。ClusterType为ecs时，必填。
        self.cluster_name = cluster_name  # type: str
        # The type of the cluster. Only ASK clusters are supported.
        self.cluster_type = cluster_type  # type: str
        # 集群绑定的托管版Grafana工作区Id。为空或"free"时，绑定到共享版Grafana。
        self.grafana_instance_id = grafana_instance_id  # type: str
        # The parameter is not supported.
        self.kube_config = kube_config  # type: str
        # The region ID.
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        # The security group to which the ASK cluster belongs.
        self.security_group_id = security_group_id  # type: str
        # The vSwitch of the ASK cluster.
        self.v_switch_id = v_switch_id  # type: str
        # The VPC of the ASK cluster.
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InstallManagedPrometheusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.grafana_instance_id is not None:
            result['GrafanaInstanceId'] = self.grafana_instance_id
        if self.kube_config is not None:
            result['KubeConfig'] = self.kube_config
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('GrafanaInstanceId') is not None:
            self.grafana_instance_id = m.get('GrafanaInstanceId')
        if m.get('KubeConfig') is not None:
            self.kube_config = m.get('KubeConfig')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class InstallManagedPrometheusResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        # The status code returned. 200 indicates that the Prometheus agent was installed. Otherwise, the Prometheus agent fails to be installed.
        self.code = code  # type: int
        # The content of the response. The installation status of the Prometheus agent was returned.
        self.data = data  # type: str
        # The error message returned if the Prometheus agent fails to be installed.
        self.message = message  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Indicates whether the Prometheus agent was installed.
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(InstallManagedPrometheusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class InstallManagedPrometheusResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: InstallManagedPrometheusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(InstallManagedPrometheusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InstallManagedPrometheusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListActivatedAlertsRequest(TeaModel):
    def __init__(self, current_page=None, filter=None, page_size=None, region_id=None):
        # The number of the page to return. Default value: `1`.
        self.current_page = current_page  # type: int
        # The filter condition in the `{"key":"value"}`format. You must specify the `key` and `value` of the filter condition.
        self.filter = filter  # type: str
        # The number of entries to return on each page. Default value: `10`.
        self.page_size = page_size  # type: int
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListActivatedAlertsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.filter is not None:
            result['Filter'] = self.filter
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Filter') is not None:
            self.filter = m.get('Filter')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ListActivatedAlertsResponseBodyPageAlertsDispatchRules(TeaModel):
    def __init__(self, rule_id=None, rule_name=None):
        # The ID of the notification policy.
        self.rule_id = rule_id  # type: int
        # The name of the notification policy.
        self.rule_name = rule_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListActivatedAlertsResponseBodyPageAlertsDispatchRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        return self


class ListActivatedAlertsResponseBodyPageAlerts(TeaModel):
    def __init__(self, alert_id=None, alert_name=None, alert_type=None, count=None, create_time=None,
                 dispatch_rules=None, ends_at=None, expand_fields=None, integration_name=None, integration_type=None,
                 involved_object_kind=None, involved_object_name=None, message=None, severity=None, starts_at=None, status=None):
        # The ID of the alert rule.
        self.alert_id = alert_id  # type: str
        # The name of the alert rule.
        self.alert_name = alert_name  # type: str
        # The type of the alert.
        self.alert_type = alert_type  # type: str
        # The number of times that the alert event was received.
        self.count = count  # type: int
        # The timestamp when the alert rule was created.
        self.create_time = create_time  # type: long
        # The notification policies.
        self.dispatch_rules = dispatch_rules  # type: list[ListActivatedAlertsResponseBodyPageAlertsDispatchRules]
        # The timestamp when the alert was ended.
        self.ends_at = ends_at  # type: long
        # The extended fields that indicate the following tags:
        # 
        # *   The tags that are carried in the metrics of the alert rule expression.
        # *   The tags that are created based on the alert rule.
        # *   The default tags of Application Real-Time Monitoring Service (ARMS).
        self.expand_fields = expand_fields  # type: dict[str, any]
        # The name of the object that is associated with the alert.
        self.integration_name = integration_name  # type: str
        # The type of the service integration that generated the alert.
        self.integration_type = integration_type  # type: str
        # The type of the object that is associated with the alert.
        self.involved_object_kind = involved_object_kind  # type: str
        # The name of the service integration that generated the alert.
        self.involved_object_name = involved_object_name  # type: str
        # The description of the alert.
        self.message = message  # type: str
        # The level of the alert. Valid values:
        # 
        # *   `critical`
        # *   `error`
        # *   `warn`
        # *   `page`
        self.severity = severity  # type: str
        # The timestamp when the alert was generated.
        self.starts_at = starts_at  # type: long
        # The status of the alert. Valid values:
        # 
        # *   `Active`
        # *   `Inhibited`
        # *   `Silenced`
        # *   `Resolved`
        self.status = status  # type: str

    def validate(self):
        if self.dispatch_rules:
            for k in self.dispatch_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListActivatedAlertsResponseBodyPageAlerts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_id is not None:
            result['AlertId'] = self.alert_id
        if self.alert_name is not None:
            result['AlertName'] = self.alert_name
        if self.alert_type is not None:
            result['AlertType'] = self.alert_type
        if self.count is not None:
            result['Count'] = self.count
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        result['DispatchRules'] = []
        if self.dispatch_rules is not None:
            for k in self.dispatch_rules:
                result['DispatchRules'].append(k.to_map() if k else None)
        if self.ends_at is not None:
            result['EndsAt'] = self.ends_at
        if self.expand_fields is not None:
            result['ExpandFields'] = self.expand_fields
        if self.integration_name is not None:
            result['IntegrationName'] = self.integration_name
        if self.integration_type is not None:
            result['IntegrationType'] = self.integration_type
        if self.involved_object_kind is not None:
            result['InvolvedObjectKind'] = self.involved_object_kind
        if self.involved_object_name is not None:
            result['InvolvedObjectName'] = self.involved_object_name
        if self.message is not None:
            result['Message'] = self.message
        if self.severity is not None:
            result['Severity'] = self.severity
        if self.starts_at is not None:
            result['StartsAt'] = self.starts_at
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertId') is not None:
            self.alert_id = m.get('AlertId')
        if m.get('AlertName') is not None:
            self.alert_name = m.get('AlertName')
        if m.get('AlertType') is not None:
            self.alert_type = m.get('AlertType')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        self.dispatch_rules = []
        if m.get('DispatchRules') is not None:
            for k in m.get('DispatchRules'):
                temp_model = ListActivatedAlertsResponseBodyPageAlertsDispatchRules()
                self.dispatch_rules.append(temp_model.from_map(k))
        if m.get('EndsAt') is not None:
            self.ends_at = m.get('EndsAt')
        if m.get('ExpandFields') is not None:
            self.expand_fields = m.get('ExpandFields')
        if m.get('IntegrationName') is not None:
            self.integration_name = m.get('IntegrationName')
        if m.get('IntegrationType') is not None:
            self.integration_type = m.get('IntegrationType')
        if m.get('InvolvedObjectKind') is not None:
            self.involved_object_kind = m.get('InvolvedObjectKind')
        if m.get('InvolvedObjectName') is not None:
            self.involved_object_name = m.get('InvolvedObjectName')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Severity') is not None:
            self.severity = m.get('Severity')
        if m.get('StartsAt') is not None:
            self.starts_at = m.get('StartsAt')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListActivatedAlertsResponseBodyPage(TeaModel):
    def __init__(self, alerts=None, page=None, page_size=None, total=None):
        # The alerts that have been triggered.
        self.alerts = alerts  # type: list[ListActivatedAlertsResponseBodyPageAlerts]
        # The page number of the returned page.
        self.page = page  # type: int
        # The number of entries returned per page.
        self.page_size = page_size  # type: int
        # The total number of entries returned.
        self.total = total  # type: int

    def validate(self):
        if self.alerts:
            for k in self.alerts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListActivatedAlertsResponseBodyPage, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Alerts'] = []
        if self.alerts is not None:
            for k in self.alerts:
                result['Alerts'].append(k.to_map() if k else None)
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.alerts = []
        if m.get('Alerts') is not None:
            for k in m.get('Alerts'):
                temp_model = ListActivatedAlertsResponseBodyPageAlerts()
                self.alerts.append(temp_model.from_map(k))
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListActivatedAlertsResponseBody(TeaModel):
    def __init__(self, page=None, request_id=None):
        # The struct returned.
        self.page = page  # type: ListActivatedAlertsResponseBodyPage
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page:
            self.page.validate()

    def to_map(self):
        _map = super(ListActivatedAlertsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page is not None:
            result['Page'] = self.page.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Page') is not None:
            temp_model = ListActivatedAlertsResponseBodyPage()
            self.page = temp_model.from_map(m['Page'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListActivatedAlertsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListActivatedAlertsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListActivatedAlertsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListActivatedAlertsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAlertEventsRequest(TeaModel):
    def __init__(self, alert_name=None, end_time=None, matching_conditions=None, page=None, size=None,
                 start_time=None, status=None):
        # The name of the alert.
        self.alert_name = alert_name  # type: str
        # The end time of the alert events that you want to query. Specify the time in the YYYY-MM-DD HH:mm:ss format.
        self.end_time = end_time  # type: str
        # The list of matching conditions.
        self.matching_conditions = matching_conditions  # type: str
        # The number of the page to return.
        self.page = page  # type: long
        # The number of entries to return on each page.
        self.size = size  # type: long
        # The start time of the alert events that you want to query. Specify the time in the YYYY-MM-DD HH:mm:ss format.
        self.start_time = start_time  # type: str
        # The status of the alert events. Valid values:
        # 
        # *   Active
        # *   Silenced
        # *   Resolved
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAlertEventsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_name is not None:
            result['AlertName'] = self.alert_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.matching_conditions is not None:
            result['MatchingConditions'] = self.matching_conditions
        if self.page is not None:
            result['Page'] = self.page
        if self.size is not None:
            result['Size'] = self.size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertName') is not None:
            self.alert_name = m.get('AlertName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('MatchingConditions') is not None:
            self.matching_conditions = m.get('MatchingConditions')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListAlertEventsResponseBodyPageBeanEventsAlarms(TeaModel):
    def __init__(self, alarm_id=None, alarm_name=None, create_time=None, state=None):
        # The ID of the alert.
        self.alarm_id = alarm_id  # type: long
        # The name of the alert.
        self.alarm_name = alarm_name  # type: str
        # The time when the alert was created.
        self.create_time = create_time  # type: str
        # The status of the alert. Valid values:
        # 
        # *   0: The alert is pending.
        # *   1: The alert is being handled.
        # *   2: The alert is cleared.
        self.state = state  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAlertEventsResponseBodyPageBeanEventsAlarms, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_id is not None:
            result['AlarmId'] = self.alarm_id
        if self.alarm_name is not None:
            result['AlarmName'] = self.alarm_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlarmId') is not None:
            self.alarm_id = m.get('AlarmId')
        if m.get('AlarmName') is not None:
            self.alarm_name = m.get('AlarmName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListAlertEventsResponseBodyPageBeanEvents(TeaModel):
    def __init__(self, alarms=None, alert_name=None, annotations=None, description=None, end_time=None,
                 generator_url=None, handler_name=None, integration_name=None, integration_type=None, labels=None,
                 receive_time=None, severity=None, start_time=None, status=None):
        # The list of associated alerts.
        self.alarms = alarms  # type: list[ListAlertEventsResponseBodyPageBeanEventsAlarms]
        # The name of the alert.
        self.alert_name = alert_name  # type: str
        # The list of annotations.
        self.annotations = annotations  # type: str
        # The description of the alert event.
        self.description = description  # type: str
        # The end time of the alert event.
        self.end_time = end_time  # type: str
        # The URL of the alert event.
        self.generator_url = generator_url  # type: str
        # The user who handled the alert.
        self.handler_name = handler_name  # type: str
        # The name of the alert integration.
        self.integration_name = integration_name  # type: str
        # The type of the alert integration.
        self.integration_type = integration_type  # type: str
        # The list of tags.
        self.labels = labels  # type: str
        # The time when the alert event was received.
        self.receive_time = receive_time  # type: str
        # The severity level of the alert. Valid value:
        # 
        # *   critical: P1
        # *   error: P2
        # *   warning: P3
        # *   page: P4
        # *   default: P6
        self.severity = severity  # type: str
        # The start time of the alert event.
        self.start_time = start_time  # type: str
        # The status of the alert event. Valid values:
        # 
        # *   Active
        # *   Silenced
        # *   Resolved
        self.status = status  # type: str

    def validate(self):
        if self.alarms:
            for k in self.alarms:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAlertEventsResponseBodyPageBeanEvents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Alarms'] = []
        if self.alarms is not None:
            for k in self.alarms:
                result['Alarms'].append(k.to_map() if k else None)
        if self.alert_name is not None:
            result['AlertName'] = self.alert_name
        if self.annotations is not None:
            result['Annotations'] = self.annotations
        if self.description is not None:
            result['Description'] = self.description
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.generator_url is not None:
            result['GeneratorURL'] = self.generator_url
        if self.handler_name is not None:
            result['HandlerName'] = self.handler_name
        if self.integration_name is not None:
            result['IntegrationName'] = self.integration_name
        if self.integration_type is not None:
            result['IntegrationType'] = self.integration_type
        if self.labels is not None:
            result['Labels'] = self.labels
        if self.receive_time is not None:
            result['ReceiveTime'] = self.receive_time
        if self.severity is not None:
            result['Severity'] = self.severity
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.alarms = []
        if m.get('Alarms') is not None:
            for k in m.get('Alarms'):
                temp_model = ListAlertEventsResponseBodyPageBeanEventsAlarms()
                self.alarms.append(temp_model.from_map(k))
        if m.get('AlertName') is not None:
            self.alert_name = m.get('AlertName')
        if m.get('Annotations') is not None:
            self.annotations = m.get('Annotations')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GeneratorURL') is not None:
            self.generator_url = m.get('GeneratorURL')
        if m.get('HandlerName') is not None:
            self.handler_name = m.get('HandlerName')
        if m.get('IntegrationName') is not None:
            self.integration_name = m.get('IntegrationName')
        if m.get('IntegrationType') is not None:
            self.integration_type = m.get('IntegrationType')
        if m.get('Labels') is not None:
            self.labels = m.get('Labels')
        if m.get('ReceiveTime') is not None:
            self.receive_time = m.get('ReceiveTime')
        if m.get('Severity') is not None:
            self.severity = m.get('Severity')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListAlertEventsResponseBodyPageBean(TeaModel):
    def __init__(self, events=None, page=None, size=None, total=None):
        # The list of information about historical alert events.
        self.events = events  # type: list[ListAlertEventsResponseBodyPageBeanEvents]
        # The number of the page returned.
        self.page = page  # type: long
        # The number of entries returned per page.
        self.size = size  # type: long
        # The total number of returned entries.
        self.total = total  # type: long

    def validate(self):
        if self.events:
            for k in self.events:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAlertEventsResponseBodyPageBean, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Events'] = []
        if self.events is not None:
            for k in self.events:
                result['Events'].append(k.to_map() if k else None)
        if self.page is not None:
            result['Page'] = self.page
        if self.size is not None:
            result['Size'] = self.size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.events = []
        if m.get('Events') is not None:
            for k in m.get('Events'):
                temp_model = ListAlertEventsResponseBodyPageBeanEvents()
                self.events.append(temp_model.from_map(k))
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListAlertEventsResponseBody(TeaModel):
    def __init__(self, page_bean=None, request_id=None):
        # The struct returned.
        self.page_bean = page_bean  # type: ListAlertEventsResponseBodyPageBean
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_bean:
            self.page_bean.validate()

    def to_map(self):
        _map = super(ListAlertEventsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_bean is not None:
            result['PageBean'] = self.page_bean.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageBean') is not None:
            temp_model = ListAlertEventsResponseBodyPageBean()
            self.page_bean = temp_model.from_map(m['PageBean'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAlertEventsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListAlertEventsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListAlertEventsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAlertEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAlertsRequest(TeaModel):
    def __init__(self, alert_name=None, dispatch_rule_id=None, end_time=None, integration_type=None, page=None,
                 severity=None, show_activities=None, show_events=None, size=None, start_time=None, state=None):
        # The name of the alert rule.
        self.alert_name = alert_name  # type: str
        # The ID of the notification policy.
        self.dispatch_rule_id = dispatch_rule_id  # type: long
        # The end time of the alert sending history that you want to query. Specify the time in the `YYYY-MM-DD HH:mm:ss` format.
        self.end_time = end_time  # type: str
        # The type of the integration. Valid values:
        # 
        # *   ARMS
        # *   CLOUD_MONITOR
        # *   MSE
        # *   ARMS_CLOUD_DIALTEST
        # *   PROMETHEUS
        # *   LOG_SERVICE
        # *   CUSTOM
        # *   ARMS_PROMETHEUS
        # *   ARMS_APP_MON
        # *   ARMS_FRONT_MON
        # *   ARMS_CUSTOM
        # *   XTRACE
        # *   GRAFANA
        # *   ZABBIX
        # *   SKYWALKING
        # *   EVENT_BRIDGE
        # *   NAGIOS
        # *   OPENFALCON
        # *   ARMS_INSIGHTS
        self.integration_type = integration_type  # type: str
        # The number of the page to return.
        self.page = page  # type: long
        # The severity level of the alert. Valid values: P6, P5, P4, P3, P2, and P1. The preceding values are listed in ascending order of severity.
        self.severity = severity  # type: str
        # Specifies whether to query the activities that correspond to alerts. Valid values:
        # 
        # *   `false` (default value): The activities are not queried.
        # *   `true`: The activities in the last three days are queried.
        self.show_activities = show_activities  # type: bool
        # Specifies whether to query the events that correspond to alerts. Valid values:
        # 
        # *   `false` (default value): The events are not queried.
        # *   `true`: The events are queried.
        self.show_events = show_events  # type: bool
        # The number of alerts to return on each page.
        self.size = size  # type: long
        # The start time of the alert sending history that you want to query. Specify the time in the `YYYY-MM-DD HH:mm:ss` format.
        self.start_time = start_time  # type: str
        # The status of the alert. Valid values:
        # 
        # *   0: The alert is waiting to be handled.
        # *   1: The alert is being handled.
        # *   2: The alert is handled.
        self.state = state  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAlertsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_name is not None:
            result['AlertName'] = self.alert_name
        if self.dispatch_rule_id is not None:
            result['DispatchRuleId'] = self.dispatch_rule_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.integration_type is not None:
            result['IntegrationType'] = self.integration_type
        if self.page is not None:
            result['Page'] = self.page
        if self.severity is not None:
            result['Severity'] = self.severity
        if self.show_activities is not None:
            result['ShowActivities'] = self.show_activities
        if self.show_events is not None:
            result['ShowEvents'] = self.show_events
        if self.size is not None:
            result['Size'] = self.size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertName') is not None:
            self.alert_name = m.get('AlertName')
        if m.get('DispatchRuleId') is not None:
            self.dispatch_rule_id = m.get('DispatchRuleId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IntegrationType') is not None:
            self.integration_type = m.get('IntegrationType')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Severity') is not None:
            self.severity = m.get('Severity')
        if m.get('ShowActivities') is not None:
            self.show_activities = m.get('ShowActivities')
        if m.get('ShowEvents') is not None:
            self.show_events = m.get('ShowEvents')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListAlertsResponseBodyPageBeanListAlertsActivities(TeaModel):
    def __init__(self, content=None, description=None, handler_name=None, time=None, type=None):
        # The content of the alert notification.
        self.content = content  # type: str
        # The description of the activity.
        self.description = description  # type: str
        # The name of the handler.
        self.handler_name = handler_name  # type: str
        # The operation time of the activity.
        self.time = time  # type: str
        # The type of the activity. Valid values:
        # 
        # *   1: The alert is claimed.
        # *   2: The alert is disclaimed.
        # *   3: A comment is added for the alert.
        # *   4: The alert is disabled.
        # *   5: An alert notification is sent.
        self.type = type  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAlertsResponseBodyPageBeanListAlertsActivities, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.description is not None:
            result['Description'] = self.description
        if self.handler_name is not None:
            result['HandlerName'] = self.handler_name
        if self.time is not None:
            result['Time'] = self.time
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('HandlerName') is not None:
            self.handler_name = m.get('HandlerName')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListAlertsResponseBodyPageBeanListAlertsAlertEvents(TeaModel):
    def __init__(self, alert_name=None, annotations=None, description=None, end_time=None, generator_url=None,
                 integration_name=None, integration_type=None, labels=None, receive_time=None, severity=None, start_time=None,
                 state=None):
        # The name of the event.
        self.alert_name = alert_name  # type: str
        # The list of annotations.
        self.annotations = annotations  # type: str
        # The description of the event.
        self.description = description  # type: str
        # The time when the event ended.
        self.end_time = end_time  # type: str
        # The URL of the event.
        self.generator_url = generator_url  # type: str
        # The name of the integration that corresponds to the alert event.
        self.integration_name = integration_name  # type: str
        # The type of the integration that corresponds to the alert event. Valid values:
        # 
        # *   ARMS
        # *   CLOUD_MONITOR
        # *   MSE
        # *   ARMS_CLOUD_DIALTEST
        # *   PROMETHEUS
        # *   LOG_SERVICE
        # *   CUSTOM
        # *   ARMS_PROMETHEUS
        # *   ARMS_APP_MON
        # *   ARMS_FRONT_MON
        # *   ARMS_CUSTOM
        # *   XTRACE
        # *   GRAFANA
        # *   ZABBIX
        # *   SKYWALKING
        # *   EVENT_BRIDGE
        # *   NAGIOS
        # *   OPENFALCON
        # *   ARMS_INSIGHTS
        self.integration_type = integration_type  # type: str
        # The list of tags.
        self.labels = labels  # type: str
        # The time when the event was created.
        self.receive_time = receive_time  # type: str
        # The severity level of the event. Valid values:
        # 
        # *   critical
        # *   error
        # *   warning
        # *   info
        self.severity = severity  # type: str
        # The time when the event started.
        self.start_time = start_time  # type: str
        # The status of the event. Valid values:
        # 
        # *   Active: The event is not cleared.
        # *   Silenced: The event is silenced.
        # *   Resolved: The event is cleared.
        self.state = state  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAlertsResponseBodyPageBeanListAlertsAlertEvents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_name is not None:
            result['AlertName'] = self.alert_name
        if self.annotations is not None:
            result['Annotations'] = self.annotations
        if self.description is not None:
            result['Description'] = self.description
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.generator_url is not None:
            result['GeneratorURL'] = self.generator_url
        if self.integration_name is not None:
            result['IntegrationName'] = self.integration_name
        if self.integration_type is not None:
            result['IntegrationType'] = self.integration_type
        if self.labels is not None:
            result['Labels'] = self.labels
        if self.receive_time is not None:
            result['ReceiveTime'] = self.receive_time
        if self.severity is not None:
            result['Severity'] = self.severity
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertName') is not None:
            self.alert_name = m.get('AlertName')
        if m.get('Annotations') is not None:
            self.annotations = m.get('Annotations')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GeneratorURL') is not None:
            self.generator_url = m.get('GeneratorURL')
        if m.get('IntegrationName') is not None:
            self.integration_name = m.get('IntegrationName')
        if m.get('IntegrationType') is not None:
            self.integration_type = m.get('IntegrationType')
        if m.get('Labels') is not None:
            self.labels = m.get('Labels')
        if m.get('ReceiveTime') is not None:
            self.receive_time = m.get('ReceiveTime')
        if m.get('Severity') is not None:
            self.severity = m.get('Severity')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListAlertsResponseBodyPageBeanListAlerts(TeaModel):
    def __init__(self, activities=None, alert_events=None, alert_id=None, alert_name=None, create_time=None,
                 dispatch_rule_id=None, dispatch_rule_name=None, severity=None, state=None):
        # The list of activities.
        self.activities = activities  # type: list[ListAlertsResponseBodyPageBeanListAlertsActivities]
        # The list of events.
        self.alert_events = alert_events  # type: list[ListAlertsResponseBodyPageBeanListAlertsAlertEvents]
        # The ID of the alert.
        self.alert_id = alert_id  # type: long
        # The name of the alert.
        self.alert_name = alert_name  # type: str
        # The time when the alert was created.
        self.create_time = create_time  # type: str
        # The ID of the notification policy.
        self.dispatch_rule_id = dispatch_rule_id  # type: float
        # The name of the notification policy.
        self.dispatch_rule_name = dispatch_rule_name  # type: str
        # The severity level of the alert. Valid values: P6, P5, P4, P3, P2, and P1. The preceding values are listed in ascending order of severity.
        self.severity = severity  # type: str
        # The status of the alert. Valid values:
        # 
        # *   0: The alert is waiting to be handled.
        # *   1: The alert is being handled.
        # *   2: The alert is handled.
        self.state = state  # type: long

    def validate(self):
        if self.activities:
            for k in self.activities:
                if k:
                    k.validate()
        if self.alert_events:
            for k in self.alert_events:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAlertsResponseBodyPageBeanListAlerts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Activities'] = []
        if self.activities is not None:
            for k in self.activities:
                result['Activities'].append(k.to_map() if k else None)
        result['AlertEvents'] = []
        if self.alert_events is not None:
            for k in self.alert_events:
                result['AlertEvents'].append(k.to_map() if k else None)
        if self.alert_id is not None:
            result['AlertId'] = self.alert_id
        if self.alert_name is not None:
            result['AlertName'] = self.alert_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.dispatch_rule_id is not None:
            result['DispatchRuleId'] = self.dispatch_rule_id
        if self.dispatch_rule_name is not None:
            result['DispatchRuleName'] = self.dispatch_rule_name
        if self.severity is not None:
            result['Severity'] = self.severity
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.activities = []
        if m.get('Activities') is not None:
            for k in m.get('Activities'):
                temp_model = ListAlertsResponseBodyPageBeanListAlertsActivities()
                self.activities.append(temp_model.from_map(k))
        self.alert_events = []
        if m.get('AlertEvents') is not None:
            for k in m.get('AlertEvents'):
                temp_model = ListAlertsResponseBodyPageBeanListAlertsAlertEvents()
                self.alert_events.append(temp_model.from_map(k))
        if m.get('AlertId') is not None:
            self.alert_id = m.get('AlertId')
        if m.get('AlertName') is not None:
            self.alert_name = m.get('AlertName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DispatchRuleId') is not None:
            self.dispatch_rule_id = m.get('DispatchRuleId')
        if m.get('DispatchRuleName') is not None:
            self.dispatch_rule_name = m.get('DispatchRuleName')
        if m.get('Severity') is not None:
            self.severity = m.get('Severity')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListAlertsResponseBodyPageBean(TeaModel):
    def __init__(self, list_alerts=None, page=None, size=None, total=None):
        # The alerts for which the alert sending history is queried.
        self.list_alerts = list_alerts  # type: list[ListAlertsResponseBodyPageBeanListAlerts]
        # The page number of the returned page.
        self.page = page  # type: long
        # The number of alerts returned per page.
        self.size = size  # type: long
        # The total number of queried alerts.
        self.total = total  # type: long

    def validate(self):
        if self.list_alerts:
            for k in self.list_alerts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAlertsResponseBodyPageBean, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ListAlerts'] = []
        if self.list_alerts is not None:
            for k in self.list_alerts:
                result['ListAlerts'].append(k.to_map() if k else None)
        if self.page is not None:
            result['Page'] = self.page
        if self.size is not None:
            result['Size'] = self.size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list_alerts = []
        if m.get('ListAlerts') is not None:
            for k in m.get('ListAlerts'):
                temp_model = ListAlertsResponseBodyPageBeanListAlerts()
                self.list_alerts.append(temp_model.from_map(k))
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListAlertsResponseBody(TeaModel):
    def __init__(self, page_bean=None, request_id=None):
        # The struct returned.
        self.page_bean = page_bean  # type: ListAlertsResponseBodyPageBean
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_bean:
            self.page_bean.validate()

    def to_map(self):
        _map = super(ListAlertsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_bean is not None:
            result['PageBean'] = self.page_bean.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageBean') is not None:
            temp_model = ListAlertsResponseBodyPageBean()
            self.page_bean = temp_model.from_map(m['PageBean'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAlertsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListAlertsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListAlertsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAlertsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterFromGrafanaRequest(TeaModel):
    def __init__(self, region_id=None):
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListClusterFromGrafanaRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ListClusterFromGrafanaResponseBodyPromClusterList(TeaModel):
    def __init__(self, agent_status=None, cluster_id=None, cluster_name=None, cluster_type=None, controller_id=None,
                 create_time=None, extra=None, id=None, install_time=None, is_controller_installed=None,
                 last_heart_beat_time=None, node_num=None, options=None, plugins_json_array=None, region_id=None, state_json=None,
                 update_time=None, user_id=None):
        # The status of the Prometheus agent on the cluster.
        self.agent_status = agent_status  # type: str
        # The ID of cluster.
        self.cluster_id = cluster_id  # type: str
        # The name of the cluster.
        self.cluster_name = cluster_name  # type: str
        # The type of the instance.
        self.cluster_type = cluster_type  # type: str
        # The ID of the controller.
        self.controller_id = controller_id  # type: str
        # The time when the dashboard was created.
        self.create_time = create_time  # type: long
        # The extended fields. This parameter is a JSON string.
        self.extra = extra  # type: str
        # The ID of a database in the cluster.
        self.id = id  # type: long
        # The timestamp when the Prometheus agent was installed.
        self.install_time = install_time  # type: long
        # Indicates whether the Prometheus agent was installed. Valid values:
        # 
        # *   true: The Prometheus agent was installed.
        # *   false: The Prometheus agent was not installed.
        self.is_controller_installed = is_controller_installed  # type: bool
        # The time when the last heartbeat was reported.
        self.last_heart_beat_time = last_heart_beat_time  # type: long
        # The number of nodes.
        self.node_num = node_num  # type: int
        # The custom parameters.
        self.options = options  # type: str
        # The list of nodejsonar logs.
        self.plugins_json_array = plugins_json_array  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The information about applications deployed in the cluster.
        self.state_json = state_json  # type: str
        # The time when the dashboard was updated.
        self.update_time = update_time  # type: long
        # The ID of the Alibaba Cloud account to which the cluster belongs.
        self.user_id = user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListClusterFromGrafanaResponseBodyPromClusterList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_status is not None:
            result['AgentStatus'] = self.agent_status
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.controller_id is not None:
            result['ControllerId'] = self.controller_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.extra is not None:
            result['Extra'] = self.extra
        if self.id is not None:
            result['Id'] = self.id
        if self.install_time is not None:
            result['InstallTime'] = self.install_time
        if self.is_controller_installed is not None:
            result['IsControllerInstalled'] = self.is_controller_installed
        if self.last_heart_beat_time is not None:
            result['LastHeartBeatTime'] = self.last_heart_beat_time
        if self.node_num is not None:
            result['NodeNum'] = self.node_num
        if self.options is not None:
            result['Options'] = self.options
        if self.plugins_json_array is not None:
            result['PluginsJsonArray'] = self.plugins_json_array
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.state_json is not None:
            result['StateJson'] = self.state_json
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentStatus') is not None:
            self.agent_status = m.get('AgentStatus')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('ControllerId') is not None:
            self.controller_id = m.get('ControllerId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Extra') is not None:
            self.extra = m.get('Extra')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstallTime') is not None:
            self.install_time = m.get('InstallTime')
        if m.get('IsControllerInstalled') is not None:
            self.is_controller_installed = m.get('IsControllerInstalled')
        if m.get('LastHeartBeatTime') is not None:
            self.last_heart_beat_time = m.get('LastHeartBeatTime')
        if m.get('NodeNum') is not None:
            self.node_num = m.get('NodeNum')
        if m.get('Options') is not None:
            self.options = m.get('Options')
        if m.get('PluginsJsonArray') is not None:
            self.plugins_json_array = m.get('PluginsJsonArray')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StateJson') is not None:
            self.state_json = m.get('StateJson')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ListClusterFromGrafanaResponseBody(TeaModel):
    def __init__(self, prom_cluster_list=None, request_id=None):
        # The cluster information.
        self.prom_cluster_list = prom_cluster_list  # type: list[ListClusterFromGrafanaResponseBodyPromClusterList]
        # The ID of the request. You can query logs and troubleshoot issues based on the ID.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.prom_cluster_list:
            for k in self.prom_cluster_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListClusterFromGrafanaResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PromClusterList'] = []
        if self.prom_cluster_list is not None:
            for k in self.prom_cluster_list:
                result['PromClusterList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.prom_cluster_list = []
        if m.get('PromClusterList') is not None:
            for k in m.get('PromClusterList'):
                temp_model = ListClusterFromGrafanaResponseBodyPromClusterList()
                self.prom_cluster_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListClusterFromGrafanaResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListClusterFromGrafanaResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListClusterFromGrafanaResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListClusterFromGrafanaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCmsInstancesRequest(TeaModel):
    def __init__(self, cluster_id=None, region_id=None, type_filter=None):
        # The ID of the cluster.
        self.cluster_id = cluster_id  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The filter condition. Format: \[unk]{"key":"value"}\[unk]. You must set the \[unk]key\[unk] and \[unk]value\[unk] fields.
        self.type_filter = type_filter  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCmsInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.type_filter is not None:
            result['TypeFilter'] = self.type_filter
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TypeFilter') is not None:
            self.type_filter = m.get('TypeFilter')
        return self


class ListCmsInstancesResponseBodyDataProducts(TeaModel):
    def __init__(self, descr=None, id=None, instance=None, name=None, prod=None, source=None, state=None, time=None,
                 type=None, url=None):
        # The description of the cloud service.
        self.descr = descr  # type: str
        # The ID of the instance.
        self.id = id  # type: str
        # The name of the instance.
        self.instance = instance  # type: str
        # The name of the cloud service.
        self.name = name  # type: str
        # The code of the cloud service.
        self.prod = prod  # type: str
        # The event source.
        self.source = source  # type: str
        # The status of the integration. Valid values:
        # 
        # *   `true`: The integration was enabled.
        # *   `false`: The integration was disabled.
        self.state = state  # type: str
        # The timestamp when the Grafana dashboard was created.
        self.time = time  # type: str
        # The type of the cloud service.
        self.type = type  # type: str
        # The complete URL of the Grafana dashboard.
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCmsInstancesResponseBodyDataProducts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.descr is not None:
            result['Descr'] = self.descr
        if self.id is not None:
            result['Id'] = self.id
        if self.instance is not None:
            result['Instance'] = self.instance
        if self.name is not None:
            result['Name'] = self.name
        if self.prod is not None:
            result['Prod'] = self.prod
        if self.source is not None:
            result['Source'] = self.source
        if self.state is not None:
            result['State'] = self.state
        if self.time is not None:
            result['Time'] = self.time
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Descr') is not None:
            self.descr = m.get('Descr')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Instance') is not None:
            self.instance = m.get('Instance')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Prod') is not None:
            self.prod = m.get('Prod')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class ListCmsInstancesResponseBodyData(TeaModel):
    def __init__(self, enable_tag=None, products=None):
        # Indicates whether to collect the aliyun tags attached to each cloud service.
        self.enable_tag = enable_tag  # type: bool
        # The struct returned.
        self.products = products  # type: list[ListCmsInstancesResponseBodyDataProducts]

    def validate(self):
        if self.products:
            for k in self.products:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCmsInstancesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_tag is not None:
            result['EnableTag'] = self.enable_tag
        result['Products'] = []
        if self.products is not None:
            for k in self.products:
                result['Products'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EnableTag') is not None:
            self.enable_tag = m.get('EnableTag')
        self.products = []
        if m.get('Products') is not None:
            for k in m.get('Products'):
                temp_model = ListCmsInstancesResponseBodyDataProducts()
                self.products.append(temp_model.from_map(k))
        return self


class ListCmsInstancesResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The struct returned.
        self.data = data  # type: ListCmsInstancesResponseBodyData
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListCmsInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = ListCmsInstancesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListCmsInstancesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListCmsInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListCmsInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCmsInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDashboardsRequest(TeaModel):
    def __init__(self, cluster_id=None, cluster_type=None, dashboard_name=None, language=None, product=None,
                 recreate_switch=None, region_id=None, title=None):
        # The ID of the Container Service for Kubernetes cluster.
        self.cluster_id = cluster_id  # type: str
        # The type of the cluster. Valid values: ACK, ASK, cloud-product-prometheus, and Node. You can query the dashboards of a virtual cluster by specifying the cluster type. For InfluxDB, set this parameter to `cloud-product-prometheus`.
        self.cluster_type = cluster_type  # type: str
        # The unique names of the dashboards. You can query dashboards by specifying their names. The **dashboard title** can be changed whereas the **dashboard name** cannot. You can specify multiple names and separate them with commas (,), for example, `k8s-event,k8s-overview`. A dashboard may have multiple versions. If you want to specify a version, you can add version information after the name, for example, `k8s-event:v1,k8s-overview:latest`.
        self.dashboard_name = dashboard_name  # type: str
        # The language of the Grafana dashboards.
        self.language = language  # type: str
        # The product code. This parameter is required if you set the ClusterType parameter to `cloud-product-prometheus`. Valid values:
        # 
        # *   InfluxDB
        # *   MongoDB
        # *   DLA
        # *   SAE
        self.product = product  # type: str
        # Specifies whether to create or query a virtual cluster. This parameter provides backward compatibility.
        self.recreate_switch = recreate_switch  # type: bool
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The dashboard title. The dashboard title can be changed. We recommend that you specify the **DashboardName** parameter.
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDashboardsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.dashboard_name is not None:
            result['DashboardName'] = self.dashboard_name
        if self.language is not None:
            result['Language'] = self.language
        if self.product is not None:
            result['Product'] = self.product
        if self.recreate_switch is not None:
            result['RecreateSwitch'] = self.recreate_switch
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('DashboardName') is not None:
            self.dashboard_name = m.get('DashboardName')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RecreateSwitch') is not None:
            self.recreate_switch = m.get('RecreateSwitch')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class ListDashboardsResponseBodyDashboardVosI18nChild(TeaModel):
    def __init__(self, dashboard_type=None, exporter=None, http_url=None, https_url=None, id=None,
                 is_arms_exporter=None, kind=None, language=None, name=None, need_update=None, tags=None, time=None, title=None,
                 type=None, uid=None, url=None, version=None):
        # The type of the Grafana dashboard. This parameter has the same effect as the Exporter parameter whereas provides clearer implication.
        self.dashboard_type = dashboard_type  # type: str
        # The type of the exporter access source. Valid values:
        # 
        # *   Prometheus
        # *   Node
        # *   GPU
        # *   Redis
        # *   MySQL
        # *   Kafka
        # *   NGINX V2
        # *   Nginx
        # *   ZooKeeper
        # *   MongoDB
        # *   RabbitMQ
        # *   PostgreSQL
        # *   Kubernetes
        # *   Client Library
        # *   Elasticsearch
        # *   RocketMQ
        self.exporter = exporter  # type: str
        # The URL of the Grafana dashboard.
        self.http_url = http_url  # type: str
        # The URL of the Grafana dashboard.
        self.https_url = https_url  # type: str
        # The ID of the Grafana dashboard. The value is unique only when you install the Grafana dashboard.
        self.id = id  # type: str
        # Indicates whether the exporter was provided by ARMS. Valid values:
        # 
        # *   `true`: The exporter is provided by ARMS.
        # *   `false`: The exporter is not provided by ARMS.
        self.is_arms_exporter = is_arms_exporter  # type: bool
        # The category of the Grafana dashboard. Valid values: BASIC, THIRD, LIMIT, and CUSTOM.
        self.kind = kind  # type: str
        # The language of the Grafana dashboard.
        self.language = language  # type: str
        # The name of the Grafana dashboard. This parameter is different from the **Title** parameter as this parameter cannot be changed.
        self.name = name  # type: str
        # Indicates whether the Grafana dashboard had a new version that was available for upgrade.
        self.need_update = need_update  # type: bool
        # The tags of the Grafana dashboard.
        self.tags = tags  # type: list[str]
        # The timestamp when the Grafana dashboard was created.
        self.time = time  # type: str
        # The title of the Grafana dashboard.
        self.title = title  # type: str
        # The type of the Grafana dashboard. Valid values:
        # 
        # *   `dash-db`: a dashboard
        # *   `dash-folder`: a folder that can include a dashboard
        self.type = type  # type: str
        # The unique identifier of a dashboard when multiple Grafana dashboards were installed. It is a unique business ID displayed on the page.
        self.uid = uid  # type: str
        # The complete URL of the Grafana dashboard.
        self.url = url  # type: str
        # The version of the Grafana dashboard. The combination of version and name uniquely identifies a dashboard.
        self.version = version  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDashboardsResponseBodyDashboardVosI18nChild, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dashboard_type is not None:
            result['DashboardType'] = self.dashboard_type
        if self.exporter is not None:
            result['Exporter'] = self.exporter
        if self.http_url is not None:
            result['HttpUrl'] = self.http_url
        if self.https_url is not None:
            result['HttpsUrl'] = self.https_url
        if self.id is not None:
            result['Id'] = self.id
        if self.is_arms_exporter is not None:
            result['IsArmsExporter'] = self.is_arms_exporter
        if self.kind is not None:
            result['Kind'] = self.kind
        if self.language is not None:
            result['Language'] = self.language
        if self.name is not None:
            result['Name'] = self.name
        if self.need_update is not None:
            result['NeedUpdate'] = self.need_update
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.time is not None:
            result['Time'] = self.time
        if self.title is not None:
            result['Title'] = self.title
        if self.type is not None:
            result['Type'] = self.type
        if self.uid is not None:
            result['Uid'] = self.uid
        if self.url is not None:
            result['Url'] = self.url
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DashboardType') is not None:
            self.dashboard_type = m.get('DashboardType')
        if m.get('Exporter') is not None:
            self.exporter = m.get('Exporter')
        if m.get('HttpUrl') is not None:
            self.http_url = m.get('HttpUrl')
        if m.get('HttpsUrl') is not None:
            self.https_url = m.get('HttpsUrl')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IsArmsExporter') is not None:
            self.is_arms_exporter = m.get('IsArmsExporter')
        if m.get('Kind') is not None:
            self.kind = m.get('Kind')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NeedUpdate') is not None:
            self.need_update = m.get('NeedUpdate')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uid') is not None:
            self.uid = m.get('Uid')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class ListDashboardsResponseBodyDashboardVos(TeaModel):
    def __init__(self, dashboard_type=None, exporter=None, http_url=None, https_url=None, i_18n_child=None, id=None,
                 is_arms_exporter=None, kind=None, language=None, name=None, need_update=None, tags=None, time=None, title=None,
                 type=None, uid=None, url=None, version=None):
        # The type of the Grafana dashboard. This parameter has the same effect as the Exporter parameter whereas provides clearer implication.
        self.dashboard_type = dashboard_type  # type: str
        # The type of the exporter access source. Valid values:
        # 
        # *   Prometheus
        # *   Node
        # *   GPU
        # *   Redis
        # *   MySQL
        # *   Kafka
        # *   NGINX V2
        # *   Nginx
        # *   ZooKeeper
        # *   MongoDB
        # *   RabbitMQ
        # *   PostgreSQL
        # *   Kubernetes
        # *   Client Library
        # *   Elasticsearch
        # *   RocketMQ
        self.exporter = exporter  # type: str
        # The URL of the Grafana dashboard.
        self.http_url = http_url  # type: str
        # The URL of the Grafana dashboard.
        self.https_url = https_url  # type: str
        # The information about the Grafana dashboard.
        self.i_18n_child = i_18n_child  # type: ListDashboardsResponseBodyDashboardVosI18nChild
        # The ID of the Grafana dashboard. The value is unique only when you install the Grafana dashboard.
        self.id = id  # type: str
        # Indicates whether the exporter was provided by ARMS. Valid values:
        # 
        # *   `true`: The exporter is provided by ARMS.
        # *   `false`: The exporter is not provided by ARMS.
        self.is_arms_exporter = is_arms_exporter  # type: bool
        # The type of the dashboard. Valid values: BASIC, THIRD, LIMIT, and CUSTOM. BASIC indicates a basic dashboard. THIRD indicates a third-party dashboard. LIMIT indicates a time-limited free dashboard. CUSTOM indicates a custom dashboard.
        self.kind = kind  # type: str
        # The language of the Grafana dashboard.
        self.language = language  # type: str
        # The name of the Grafana dashboard. This parameter is different from the **Title** parameter as this parameter cannot be changed.
        self.name = name  # type: str
        # Indicates whether the Grafana dashboard had a new version that was available for upgrade.
        self.need_update = need_update  # type: bool
        # The tags of the Grafana dashboard.
        self.tags = tags  # type: list[str]
        # The timestamp when the Grafana dashboard was created.
        self.time = time  # type: str
        # The title of the Grafana dashboard.
        self.title = title  # type: str
        # The type of the Grafana dashboard. Valid values:
        # 
        # *   `dash-db`: a dashboard
        # *   `dash-folder`: a folder that can include a dashboard
        self.type = type  # type: str
        # The unique identifier of a dashboard when multiple Grafana dashboards were installed. It is a unique business ID displayed on the page.
        self.uid = uid  # type: str
        # The complete URL of the Grafana dashboard.
        self.url = url  # type: str
        # The version of the Grafana dashboard. The combination of version and name uniquely identifies a dashboard.
        self.version = version  # type: str

    def validate(self):
        if self.i_18n_child:
            self.i_18n_child.validate()

    def to_map(self):
        _map = super(ListDashboardsResponseBodyDashboardVos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dashboard_type is not None:
            result['DashboardType'] = self.dashboard_type
        if self.exporter is not None:
            result['Exporter'] = self.exporter
        if self.http_url is not None:
            result['HttpUrl'] = self.http_url
        if self.https_url is not None:
            result['HttpsUrl'] = self.https_url
        if self.i_18n_child is not None:
            result['I18nChild'] = self.i_18n_child.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.is_arms_exporter is not None:
            result['IsArmsExporter'] = self.is_arms_exporter
        if self.kind is not None:
            result['Kind'] = self.kind
        if self.language is not None:
            result['Language'] = self.language
        if self.name is not None:
            result['Name'] = self.name
        if self.need_update is not None:
            result['NeedUpdate'] = self.need_update
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.time is not None:
            result['Time'] = self.time
        if self.title is not None:
            result['Title'] = self.title
        if self.type is not None:
            result['Type'] = self.type
        if self.uid is not None:
            result['Uid'] = self.uid
        if self.url is not None:
            result['Url'] = self.url
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DashboardType') is not None:
            self.dashboard_type = m.get('DashboardType')
        if m.get('Exporter') is not None:
            self.exporter = m.get('Exporter')
        if m.get('HttpUrl') is not None:
            self.http_url = m.get('HttpUrl')
        if m.get('HttpsUrl') is not None:
            self.https_url = m.get('HttpsUrl')
        if m.get('I18nChild') is not None:
            temp_model = ListDashboardsResponseBodyDashboardVosI18nChild()
            self.i_18n_child = temp_model.from_map(m['I18nChild'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IsArmsExporter') is not None:
            self.is_arms_exporter = m.get('IsArmsExporter')
        if m.get('Kind') is not None:
            self.kind = m.get('Kind')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NeedUpdate') is not None:
            self.need_update = m.get('NeedUpdate')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uid') is not None:
            self.uid = m.get('Uid')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class ListDashboardsResponseBody(TeaModel):
    def __init__(self, dashboard_vos=None, request_id=None):
        # The information about the Grafana dashboards.
        self.dashboard_vos = dashboard_vos  # type: list[ListDashboardsResponseBodyDashboardVos]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.dashboard_vos:
            for k in self.dashboard_vos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDashboardsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DashboardVos'] = []
        if self.dashboard_vos is not None:
            for k in self.dashboard_vos:
                result['DashboardVos'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.dashboard_vos = []
        if m.get('DashboardVos') is not None:
            for k in m.get('DashboardVos'):
                temp_model = ListDashboardsResponseBodyDashboardVos()
                self.dashboard_vos.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListDashboardsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListDashboardsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListDashboardsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListDashboardsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDashboardsByNameRequest(TeaModel):
    def __init__(self, cluster_id=None, cluster_type=None, dash_board_name=None, dash_board_version=None,
                 data_source_type=None, group_name=None, only_query=None, product_code=None, region_id=None):
        # The ID of the cluster.
        self.cluster_id = cluster_id  # type: str
        # The type of the cluster.
        self.cluster_type = cluster_type  # type: str
        # The name of the dashboard.
        self.dash_board_name = dash_board_name  # type: str
        # The version of the dashboard.
        self.dash_board_version = dash_board_version  # type: str
        # The type of the data source.
        self.data_source_type = data_source_type  # type: str
        # The name of the dashboard group.
        self.group_name = group_name  # type: str
        # Specifies whether to display the Grafana dashboard only in the Application Real-Time Monitoring Service (ARMS) console.
        self.only_query = only_query  # type: bool
        # The abbreviation of the Alibaba Cloud service name.
        self.product_code = product_code  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDashboardsByNameRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.dash_board_name is not None:
            result['DashBoardName'] = self.dash_board_name
        if self.dash_board_version is not None:
            result['DashBoardVersion'] = self.dash_board_version
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.only_query is not None:
            result['OnlyQuery'] = self.only_query
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('DashBoardName') is not None:
            self.dash_board_name = m.get('DashBoardName')
        if m.get('DashBoardVersion') is not None:
            self.dash_board_version = m.get('DashBoardVersion')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('OnlyQuery') is not None:
            self.only_query = m.get('OnlyQuery')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ListDashboardsByNameResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The struct returned.
        self.data = data  # type: str
        # The ID of the request. You can query logs and troubleshoot issues based on the ID.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDashboardsByNameResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListDashboardsByNameResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListDashboardsByNameResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListDashboardsByNameResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListDashboardsByNameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDispatchRuleRequest(TeaModel):
    def __init__(self, name=None, region_id=None, system=None):
        # The name of the notification policy to be queried. Fuzzy match is supported.
        self.name = name  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str
        # *   The type of notification policies to be queried. Valid values: `false`: notification policies created in Application Real-Time Monitoring Service (ARMS). This is the default value.
        # 
        # *   `true`: notification policies created in an external system.
        # 
        # > You cannot use the ARMS console to modify the dispatch rules of a notification policy that is created in an external system.
        self.system = system  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDispatchRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.system is not None:
            result['System'] = self.system
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('System') is not None:
            self.system = m.get('System')
        return self


class ListDispatchRuleResponseBodyDispatchRules(TeaModel):
    def __init__(self, name=None, rule_id=None, state=None):
        # The name of the notification policy.
        self.name = name  # type: str
        # The ID of the notification policy.
        self.rule_id = rule_id  # type: long
        # Indicates whether the notification policy is enabled.
        # 
        # *   `true`: The notification policy is enabled.
        # *   `false`: The notification policy is disabled.
        self.state = state  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDispatchRuleResponseBodyDispatchRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListDispatchRuleResponseBody(TeaModel):
    def __init__(self, dispatch_rules=None, request_id=None):
        # The struct returned.
        self.dispatch_rules = dispatch_rules  # type: list[ListDispatchRuleResponseBodyDispatchRules]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.dispatch_rules:
            for k in self.dispatch_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDispatchRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DispatchRules'] = []
        if self.dispatch_rules is not None:
            for k in self.dispatch_rules:
                result['DispatchRules'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.dispatch_rules = []
        if m.get('DispatchRules') is not None:
            for k in m.get('DispatchRules'):
                temp_model = ListDispatchRuleResponseBodyDispatchRules()
                self.dispatch_rules.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListDispatchRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListDispatchRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListDispatchRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListDispatchRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListEscalationPoliciesRequest(TeaModel):
    def __init__(self, name=None, page=None, size=None):
        # The name of the escalation policy.
        self.name = name  # type: str
        # The number of the page to return.
        self.page = page  # type: long
        # The number of entries to return on each page.
        self.size = size  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListEscalationPoliciesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.page is not None:
            result['Page'] = self.page
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class ListEscalationPoliciesResponseBodyPageBeanEscalationPolicies(TeaModel):
    def __init__(self, id=None, name=None):
        # The ID of the escalation policy.
        self.id = id  # type: long
        # The name of the escalation policy.
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListEscalationPoliciesResponseBodyPageBeanEscalationPolicies, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class ListEscalationPoliciesResponseBodyPageBean(TeaModel):
    def __init__(self, escalation_policies=None, page=None, size=None, total=None):
        # The list of escalation policies.
        self.escalation_policies = escalation_policies  # type: list[ListEscalationPoliciesResponseBodyPageBeanEscalationPolicies]
        # The page number of the returned page.
        self.page = page  # type: long
        # The number of entries returned per page.
        self.size = size  # type: long
        # The total number of returned entries.
        self.total = total  # type: long

    def validate(self):
        if self.escalation_policies:
            for k in self.escalation_policies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListEscalationPoliciesResponseBodyPageBean, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EscalationPolicies'] = []
        if self.escalation_policies is not None:
            for k in self.escalation_policies:
                result['EscalationPolicies'].append(k.to_map() if k else None)
        if self.page is not None:
            result['Page'] = self.page
        if self.size is not None:
            result['Size'] = self.size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.escalation_policies = []
        if m.get('EscalationPolicies') is not None:
            for k in m.get('EscalationPolicies'):
                temp_model = ListEscalationPoliciesResponseBodyPageBeanEscalationPolicies()
                self.escalation_policies.append(temp_model.from_map(k))
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListEscalationPoliciesResponseBody(TeaModel):
    def __init__(self, page_bean=None, request_id=None):
        # The objects that were returned.
        self.page_bean = page_bean  # type: ListEscalationPoliciesResponseBodyPageBean
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_bean:
            self.page_bean.validate()

    def to_map(self):
        _map = super(ListEscalationPoliciesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_bean is not None:
            result['PageBean'] = self.page_bean.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageBean') is not None:
            temp_model = ListEscalationPoliciesResponseBodyPageBean()
            self.page_bean = temp_model.from_map(m['PageBean'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListEscalationPoliciesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListEscalationPoliciesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListEscalationPoliciesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListEscalationPoliciesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListEventBridgeIntegrationsRequest(TeaModel):
    def __init__(self, name=None, page=None, size=None):
        # The name of the EventBridge integration.
        self.name = name  # type: str
        # The number of the page to return.
        self.page = page  # type: long
        # The number of entries to return on each page.
        self.size = size  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListEventBridgeIntegrationsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.page is not None:
            result['Page'] = self.page
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class ListEventBridgeIntegrationsResponseBodyPageBeanEventBridgeIntegrations(TeaModel):
    def __init__(self, description=None, id=None, name=None):
        # The description of the EventBridge integration.
        self.description = description  # type: str
        # The ID of the EventBridge integration.
        self.id = id  # type: long
        # The name of the EventBridge integration.
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListEventBridgeIntegrationsResponseBodyPageBeanEventBridgeIntegrations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class ListEventBridgeIntegrationsResponseBodyPageBean(TeaModel):
    def __init__(self, event_bridge_integrations=None, page=None, size=None, total=None):
        # The EventBridge integrations.
        self.event_bridge_integrations = event_bridge_integrations  # type: list[ListEventBridgeIntegrationsResponseBodyPageBeanEventBridgeIntegrations]
        # The number of the page returned.
        self.page = page  # type: long
        # The number of entries that are returned on each page.
        self.size = size  # type: long
        # The total number of EventBridge integrations that are returned.
        self.total = total  # type: long

    def validate(self):
        if self.event_bridge_integrations:
            for k in self.event_bridge_integrations:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListEventBridgeIntegrationsResponseBodyPageBean, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EventBridgeIntegrations'] = []
        if self.event_bridge_integrations is not None:
            for k in self.event_bridge_integrations:
                result['EventBridgeIntegrations'].append(k.to_map() if k else None)
        if self.page is not None:
            result['Page'] = self.page
        if self.size is not None:
            result['Size'] = self.size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.event_bridge_integrations = []
        if m.get('EventBridgeIntegrations') is not None:
            for k in m.get('EventBridgeIntegrations'):
                temp_model = ListEventBridgeIntegrationsResponseBodyPageBeanEventBridgeIntegrations()
                self.event_bridge_integrations.append(temp_model.from_map(k))
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListEventBridgeIntegrationsResponseBody(TeaModel):
    def __init__(self, page_bean=None, request_id=None):
        # The information about EventBridge integrations on each page.
        self.page_bean = page_bean  # type: ListEventBridgeIntegrationsResponseBodyPageBean
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_bean:
            self.page_bean.validate()

    def to_map(self):
        _map = super(ListEventBridgeIntegrationsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_bean is not None:
            result['PageBean'] = self.page_bean.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageBean') is not None:
            temp_model = ListEventBridgeIntegrationsResponseBodyPageBean()
            self.page_bean = temp_model.from_map(m['PageBean'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListEventBridgeIntegrationsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListEventBridgeIntegrationsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListEventBridgeIntegrationsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListEventBridgeIntegrationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInsightsEventsRequest(TeaModel):
    def __init__(self, end_time=None, insights_types=None, pid=None, region_id=None, start_time=None):
        # The ID of the request.
        self.end_time = end_time  # type: str
        # The details of the event.
        self.insights_types = insights_types  # type: str
        # The end of the time range to query. The value is a timestamp.
        self.pid = pid  # type: str
        # The ID of the application.
        self.region_id = region_id  # type: str
        # The types of the events that you want to query. Separate multiple event types with commas (,). If you do not specify this parameter, all events are queried.
        # 
        # *   errorIncrease: API error-rate spike events. Examples: HTTP API error-rate spike events and Dubbo API error-rate spike events.
        # *   topErrorIncrease: the top five API error-rate spike events with the highest traffic.
        # *   topRtIncrease: API response-time spike events. Examples: HTTP API response-time spike events and Dubbo API response-time spike events.
        # *   rtIncrease: the top five API response-time spike events with the highest traffic.
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListInsightsEventsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.insights_types is not None:
            result['InsightsTypes'] = self.insights_types
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InsightsTypes') is not None:
            self.insights_types = m.get('InsightsTypes')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListInsightsEventsResponseBodyInsightsEvents(TeaModel):
    def __init__(self, date=None, desc=None, level=None, pid=None, title=None, type=None):
        # The time at which the event occurred. The value is a timestamp.
        self.date = date  # type: long
        # The ID of the application associated with the event.
        self.desc = desc  # type: str
        # Queries the abnormal Insights events within a specified period of time.
        self.level = level  # type: str
        # auditing
        self.pid = pid  # type: str
        # The overall response time of the \[HTTP] service of the application \[sd] spikes at \[2022-07-27 10:57:00]
        self.title = title  # type: str
        # The time at which the event occurred. The value is a timestamp.
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListInsightsEventsResponseBodyInsightsEvents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.level is not None:
            result['Level'] = self.level
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.title is not None:
            result['Title'] = self.title
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListInsightsEventsResponseBody(TeaModel):
    def __init__(self, insights_events=None, request_id=None):
        # The description of the event.
        self.insights_events = insights_events  # type: list[ListInsightsEventsResponseBodyInsightsEvents]
        # The title of the event.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.insights_events:
            for k in self.insights_events:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListInsightsEventsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InsightsEvents'] = []
        if self.insights_events is not None:
            for k in self.insights_events:
                result['InsightsEvents'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.insights_events = []
        if m.get('InsightsEvents') is not None:
            for k in m.get('InsightsEvents'):
                temp_model = ListInsightsEventsResponseBodyInsightsEvents()
                self.insights_events.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListInsightsEventsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListInsightsEventsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListInsightsEventsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListInsightsEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListIntegrationRequest(TeaModel):
    def __init__(self, integration_name=None, integration_product_type=None, is_detail=None, page=None, size=None):
        # The name of the alert integration.
        self.integration_name = integration_name  # type: str
        # The service of the alert integration. Valid values:
        # 
        # *   CLOUD_MONITOR: CloudMonitor
        # *   LOG_SERVICE: Log Service
        self.integration_product_type = integration_product_type  # type: str
        # Specifies whether to display the details of each alert integration:
        # 
        # *   true
        # *   false
        self.is_detail = is_detail  # type: bool
        # The number of the page to return.
        self.page = page  # type: long
        # The number of alert integrations to return on each page.
        self.size = size  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntegrationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.integration_name is not None:
            result['IntegrationName'] = self.integration_name
        if self.integration_product_type is not None:
            result['IntegrationProductType'] = self.integration_product_type
        if self.is_detail is not None:
            result['IsDetail'] = self.is_detail
        if self.page is not None:
            result['Page'] = self.page
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IntegrationName') is not None:
            self.integration_name = m.get('IntegrationName')
        if m.get('IntegrationProductType') is not None:
            self.integration_product_type = m.get('IntegrationProductType')
        if m.get('IsDetail') is not None:
            self.is_detail = m.get('IsDetail')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class ListIntegrationResponseBodyPageInfoIntegrationsIntegrationDetail(TeaModel):
    def __init__(self, auto_recover=None, description=None, duplicate_key=None, extended_field_redefine_rules=None,
                 field_redefine_rules=None, initiative_recover_field=None, initiative_recover_value=None, recover_time=None, stat=None):
        # Indicates whether alert events are automatically cleared. Valid values:
        # 
        # *   true (default)
        # *   false
        self.auto_recover = auto_recover  # type: bool
        # The description of the alert integration.
        self.description = description  # type: str
        # The fields whose values are deduplicated.
        self.duplicate_key = duplicate_key  # type: str
        # The extended mapped fields of the alert source.
        self.extended_field_redefine_rules = extended_field_redefine_rules  # type: list[dict[str, any]]
        # The predefined mapped fields of the alert source.
        self.field_redefine_rules = field_redefine_rules  # type: list[dict[str, any]]
        # The field for clearing alert events. The system queries alert events based on the field of alert clearing events and clears the alert events.
        # 
        # > Only the Log Service alert integration supports the parameter.
        self.initiative_recover_field = initiative_recover_field  # type: str
        # The value of the field for clearing alert events. The system queries alert events based on the field of alert clearing events and clears the alert events.
        # 
        # > Only the Log Service alert integration supports the parameter.
        self.initiative_recover_value = initiative_recover_value  # type: str
        # The time when alert events are automatically cleared. Unit: seconds. Default value: 300.
        self.recover_time = recover_time  # type: long
        # The total number of alert events and the number of abnormal alert events in the last hour.
        self.stat = stat  # type: list[long]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListIntegrationResponseBodyPageInfoIntegrationsIntegrationDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_recover is not None:
            result['AutoRecover'] = self.auto_recover
        if self.description is not None:
            result['Description'] = self.description
        if self.duplicate_key is not None:
            result['DuplicateKey'] = self.duplicate_key
        if self.extended_field_redefine_rules is not None:
            result['ExtendedFieldRedefineRules'] = self.extended_field_redefine_rules
        if self.field_redefine_rules is not None:
            result['FieldRedefineRules'] = self.field_redefine_rules
        if self.initiative_recover_field is not None:
            result['InitiativeRecoverField'] = self.initiative_recover_field
        if self.initiative_recover_value is not None:
            result['InitiativeRecoverValue'] = self.initiative_recover_value
        if self.recover_time is not None:
            result['RecoverTime'] = self.recover_time
        if self.stat is not None:
            result['Stat'] = self.stat
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoRecover') is not None:
            self.auto_recover = m.get('AutoRecover')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DuplicateKey') is not None:
            self.duplicate_key = m.get('DuplicateKey')
        if m.get('ExtendedFieldRedefineRules') is not None:
            self.extended_field_redefine_rules = m.get('ExtendedFieldRedefineRules')
        if m.get('FieldRedefineRules') is not None:
            self.field_redefine_rules = m.get('FieldRedefineRules')
        if m.get('InitiativeRecoverField') is not None:
            self.initiative_recover_field = m.get('InitiativeRecoverField')
        if m.get('InitiativeRecoverValue') is not None:
            self.initiative_recover_value = m.get('InitiativeRecoverValue')
        if m.get('RecoverTime') is not None:
            self.recover_time = m.get('RecoverTime')
        if m.get('Stat') is not None:
            self.stat = m.get('Stat')
        return self


class ListIntegrationResponseBodyPageInfoIntegrations(TeaModel):
    def __init__(self, api_endpoint=None, create_time=None, integration_detail=None, integration_id=None,
                 integration_name=None, integration_product_type=None, liveness=None, short_token=None, state=None):
        # The endpoint of the alert integration.
        self.api_endpoint = api_endpoint  # type: str
        # The time when the alert integration was created.
        self.create_time = create_time  # type: str
        # The information about the alert events.
        self.integration_detail = integration_detail  # type: ListIntegrationResponseBodyPageInfoIntegrationsIntegrationDetail
        # The ID of the alert integration.
        self.integration_id = integration_id  # type: long
        # The name of the alert integration.
        self.integration_name = integration_name  # type: str
        # The service of the alert integration. Valid values:
        # 
        # *   CLOUD_MONITOR: CloudMonitor
        # *   LOG_SERVICE: Log Service
        self.integration_product_type = integration_product_type  # type: str
        # The activity of the alert integration
        self.liveness = liveness  # type: str
        # The authentication token of the alert integration.
        self.short_token = short_token  # type: str
        # Indicates whether the alert integration was enabled. Valid values:
        # 
        # *   true
        # *   false
        self.state = state  # type: bool

    def validate(self):
        if self.integration_detail:
            self.integration_detail.validate()

    def to_map(self):
        _map = super(ListIntegrationResponseBodyPageInfoIntegrations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_endpoint is not None:
            result['ApiEndpoint'] = self.api_endpoint
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.integration_detail is not None:
            result['IntegrationDetail'] = self.integration_detail.to_map()
        if self.integration_id is not None:
            result['IntegrationId'] = self.integration_id
        if self.integration_name is not None:
            result['IntegrationName'] = self.integration_name
        if self.integration_product_type is not None:
            result['IntegrationProductType'] = self.integration_product_type
        if self.liveness is not None:
            result['Liveness'] = self.liveness
        if self.short_token is not None:
            result['ShortToken'] = self.short_token
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiEndpoint') is not None:
            self.api_endpoint = m.get('ApiEndpoint')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('IntegrationDetail') is not None:
            temp_model = ListIntegrationResponseBodyPageInfoIntegrationsIntegrationDetail()
            self.integration_detail = temp_model.from_map(m['IntegrationDetail'])
        if m.get('IntegrationId') is not None:
            self.integration_id = m.get('IntegrationId')
        if m.get('IntegrationName') is not None:
            self.integration_name = m.get('IntegrationName')
        if m.get('IntegrationProductType') is not None:
            self.integration_product_type = m.get('IntegrationProductType')
        if m.get('Liveness') is not None:
            self.liveness = m.get('Liveness')
        if m.get('ShortToken') is not None:
            self.short_token = m.get('ShortToken')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class ListIntegrationResponseBodyPageInfo(TeaModel):
    def __init__(self, integrations=None, page=None, size=None, total=None):
        # The information about each alert integration.
        self.integrations = integrations  # type: list[ListIntegrationResponseBodyPageInfoIntegrations]
        # The page number of the returned page.
        self.page = page  # type: long
        # The number of alert integrations returned per page.
        self.size = size  # type: long
        # The total number of alert integrations.
        self.total = total  # type: long

    def validate(self):
        if self.integrations:
            for k in self.integrations:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListIntegrationResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Integrations'] = []
        if self.integrations is not None:
            for k in self.integrations:
                result['Integrations'].append(k.to_map() if k else None)
        if self.page is not None:
            result['Page'] = self.page
        if self.size is not None:
            result['Size'] = self.size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.integrations = []
        if m.get('Integrations') is not None:
            for k in m.get('Integrations'):
                temp_model = ListIntegrationResponseBodyPageInfoIntegrations()
                self.integrations.append(temp_model.from_map(k))
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListIntegrationResponseBody(TeaModel):
    def __init__(self, page_info=None, request_id=None):
        # The pagination information.
        self.page_info = page_info  # type: ListIntegrationResponseBodyPageInfo
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(ListIntegrationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = ListIntegrationResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListIntegrationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListIntegrationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListIntegrationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListIntegrationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListNotificationPoliciesRequest(TeaModel):
    def __init__(self, ids=None, is_detail=None, name=None, page=None, region_id=None, size=None):
        # The ID of the notification policy.
        self.ids = ids  # type: str
        # Specifies whether to query the details about notification policies. Valid values:
        # 
        # *   `true`: Details about notification policies are queried.
        # *   `false`: Details about notification policies are not queried.
        self.is_detail = is_detail  # type: bool
        # The name of the notification policy.
        self.name = name  # type: str
        # The number of the page to return.
        self.page = page  # type: long
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The number of entries to return on each page.
        self.size = size  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListNotificationPoliciesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ids is not None:
            result['Ids'] = self.ids
        if self.is_detail is not None:
            result['IsDetail'] = self.is_detail
        if self.name is not None:
            result['Name'] = self.name
        if self.page is not None:
            result['Page'] = self.page
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        if m.get('IsDetail') is not None:
            self.is_detail = m.get('IsDetail')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class ListNotificationPoliciesResponseBodyPageBeanNotificationPoliciesGroupRule(TeaModel):
    def __init__(self, group_interval=None, group_wait=None, grouping_fields=None):
        # The time interval for grouping. Unit: seconds. Default value: 30.
        self.group_interval = group_interval  # type: long
        # The waiting time for grouping. Unit: seconds. Default value: 5.
        self.group_wait = group_wait  # type: long
        # The fields that are used to group events.
        self.grouping_fields = grouping_fields  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListNotificationPoliciesResponseBodyPageBeanNotificationPoliciesGroupRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_interval is not None:
            result['GroupInterval'] = self.group_interval
        if self.group_wait is not None:
            result['GroupWait'] = self.group_wait
        if self.grouping_fields is not None:
            result['GroupingFields'] = self.grouping_fields
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupInterval') is not None:
            self.group_interval = m.get('GroupInterval')
        if m.get('GroupWait') is not None:
            self.group_wait = m.get('GroupWait')
        if m.get('GroupingFields') is not None:
            self.grouping_fields = m.get('GroupingFields')
        return self


class ListNotificationPoliciesResponseBodyPageBeanNotificationPoliciesMatchingRulesMatchingConditions(TeaModel):
    def __init__(self, key=None, operator=None, value=None):
        # The key of the matching condition.
        self.key = key  # type: str
        # The logical operator of the matching condition. Valid values:
        # 
        # *   `eq`: equal to.
        # *   `neq`: not equal to.
        # *   `in`: contains.
        # *   `nin`: does not contain.
        # *   `re`: regular expression match.
        # *   `nre`: regular expression mismatch.
        self.operator = operator  # type: str
        # The value of the matching condition.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListNotificationPoliciesResponseBodyPageBeanNotificationPoliciesMatchingRulesMatchingConditions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListNotificationPoliciesResponseBodyPageBeanNotificationPoliciesMatchingRules(TeaModel):
    def __init__(self, matching_conditions=None):
        # The alert event matching conditions.
        self.matching_conditions = matching_conditions  # type: list[ListNotificationPoliciesResponseBodyPageBeanNotificationPoliciesMatchingRulesMatchingConditions]

    def validate(self):
        if self.matching_conditions:
            for k in self.matching_conditions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListNotificationPoliciesResponseBodyPageBeanNotificationPoliciesMatchingRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MatchingConditions'] = []
        if self.matching_conditions is not None:
            for k in self.matching_conditions:
                result['MatchingConditions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.matching_conditions = []
        if m.get('MatchingConditions') is not None:
            for k in m.get('MatchingConditions'):
                temp_model = ListNotificationPoliciesResponseBodyPageBeanNotificationPoliciesMatchingRulesMatchingConditions()
                self.matching_conditions.append(temp_model.from_map(k))
        return self


class ListNotificationPoliciesResponseBodyPageBeanNotificationPoliciesNotifyRuleNotifyObjects(TeaModel):
    def __init__(self, notify_object_id=None, notify_object_name=None, notify_object_type=None):
        # The ID of the contact.
        self.notify_object_id = notify_object_id  # type: long
        # The name of the contact.
        self.notify_object_name = notify_object_name  # type: str
        # The type of the contact. Valid values: 
        # 
        # - CONTACT: an individual contact
        # - CONTACT_GROUP: a contact group
        # - DING_ROBOT: an instant messaging (IM) robot
        # - CONTACT_SCHEDULE: a person on duty based on an established schedule
        self.notify_object_type = notify_object_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListNotificationPoliciesResponseBodyPageBeanNotificationPoliciesNotifyRuleNotifyObjects, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.notify_object_id is not None:
            result['NotifyObjectId'] = self.notify_object_id
        if self.notify_object_name is not None:
            result['NotifyObjectName'] = self.notify_object_name
        if self.notify_object_type is not None:
            result['NotifyObjectType'] = self.notify_object_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NotifyObjectId') is not None:
            self.notify_object_id = m.get('NotifyObjectId')
        if m.get('NotifyObjectName') is not None:
            self.notify_object_name = m.get('NotifyObjectName')
        if m.get('NotifyObjectType') is not None:
            self.notify_object_type = m.get('NotifyObjectType')
        return self


class ListNotificationPoliciesResponseBodyPageBeanNotificationPoliciesNotifyRule(TeaModel):
    def __init__(self, notify_channels=None, notify_end_time=None, notify_objects=None, notify_start_time=None):
        # The notification method.
        self.notify_channels = notify_channels  # type: list[str]
        # The end time of the notification window.
        self.notify_end_time = notify_end_time  # type: str
        # The contacts.
        self.notify_objects = notify_objects  # type: list[ListNotificationPoliciesResponseBodyPageBeanNotificationPoliciesNotifyRuleNotifyObjects]
        # The start time of the notification window.
        self.notify_start_time = notify_start_time  # type: str

    def validate(self):
        if self.notify_objects:
            for k in self.notify_objects:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListNotificationPoliciesResponseBodyPageBeanNotificationPoliciesNotifyRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.notify_channels is not None:
            result['NotifyChannels'] = self.notify_channels
        if self.notify_end_time is not None:
            result['NotifyEndTime'] = self.notify_end_time
        result['NotifyObjects'] = []
        if self.notify_objects is not None:
            for k in self.notify_objects:
                result['NotifyObjects'].append(k.to_map() if k else None)
        if self.notify_start_time is not None:
            result['NotifyStartTime'] = self.notify_start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NotifyChannels') is not None:
            self.notify_channels = m.get('NotifyChannels')
        if m.get('NotifyEndTime') is not None:
            self.notify_end_time = m.get('NotifyEndTime')
        self.notify_objects = []
        if m.get('NotifyObjects') is not None:
            for k in m.get('NotifyObjects'):
                temp_model = ListNotificationPoliciesResponseBodyPageBeanNotificationPoliciesNotifyRuleNotifyObjects()
                self.notify_objects.append(temp_model.from_map(k))
        if m.get('NotifyStartTime') is not None:
            self.notify_start_time = m.get('NotifyStartTime')
        return self


class ListNotificationPoliciesResponseBodyPageBeanNotificationPoliciesNotifyTemplate(TeaModel):
    def __init__(self, email_content=None, email_recover_content=None, email_recover_title=None, email_title=None,
                 robot_content=None, sms_content=None, sms_recover_content=None, tts_content=None, tts_recover_content=None):
        # The content of the alert notification sent by email.
        self.email_content = email_content  # type: str
        # The content of the alert resolution notification sent by email.
        self.email_recover_content = email_recover_content  # type: str
        # The title of the alert resolution notification sent by email.
        self.email_recover_title = email_recover_title  # type: str
        # The title of the alert notification sent by email.
        self.email_title = email_title  # type: str
        # The content of the alert notification sent by an IM robot.
        self.robot_content = robot_content  # type: str
        # The content of the alert notification sent by text message.
        self.sms_content = sms_content  # type: str
        # The content of the alert resolution notification sent by text message.
        self.sms_recover_content = sms_recover_content  # type: str
        # The content of the alert notification sent by phone.
        self.tts_content = tts_content  # type: str
        # The content of the alert resolution notification sent by phone.
        self.tts_recover_content = tts_recover_content  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListNotificationPoliciesResponseBodyPageBeanNotificationPoliciesNotifyTemplate, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.email_content is not None:
            result['EmailContent'] = self.email_content
        if self.email_recover_content is not None:
            result['EmailRecoverContent'] = self.email_recover_content
        if self.email_recover_title is not None:
            result['EmailRecoverTitle'] = self.email_recover_title
        if self.email_title is not None:
            result['EmailTitle'] = self.email_title
        if self.robot_content is not None:
            result['RobotContent'] = self.robot_content
        if self.sms_content is not None:
            result['SmsContent'] = self.sms_content
        if self.sms_recover_content is not None:
            result['SmsRecoverContent'] = self.sms_recover_content
        if self.tts_content is not None:
            result['TtsContent'] = self.tts_content
        if self.tts_recover_content is not None:
            result['TtsRecoverContent'] = self.tts_recover_content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EmailContent') is not None:
            self.email_content = m.get('EmailContent')
        if m.get('EmailRecoverContent') is not None:
            self.email_recover_content = m.get('EmailRecoverContent')
        if m.get('EmailRecoverTitle') is not None:
            self.email_recover_title = m.get('EmailRecoverTitle')
        if m.get('EmailTitle') is not None:
            self.email_title = m.get('EmailTitle')
        if m.get('RobotContent') is not None:
            self.robot_content = m.get('RobotContent')
        if m.get('SmsContent') is not None:
            self.sms_content = m.get('SmsContent')
        if m.get('SmsRecoverContent') is not None:
            self.sms_recover_content = m.get('SmsRecoverContent')
        if m.get('TtsContent') is not None:
            self.tts_content = m.get('TtsContent')
        if m.get('TtsRecoverContent') is not None:
            self.tts_recover_content = m.get('TtsRecoverContent')
        return self


class ListNotificationPoliciesResponseBodyPageBeanNotificationPolicies(TeaModel):
    def __init__(self, escalation_policy_id=None, group_rule=None, id=None, integration_id=None,
                 matching_rules=None, name=None, notify_rule=None, notify_template=None, repeat=None, repeat_interval=None,
                 send_recover_message=None):
        # The ID of the escalation rule.
        self.escalation_policy_id = escalation_policy_id  # type: long
        # The grouping rule for alert events.
        self.group_rule = group_rule  # type: ListNotificationPoliciesResponseBodyPageBeanNotificationPoliciesGroupRule
        # The ID of the notification policy.
        self.id = id  # type: long
        # The integration ID of the ticket system to which alerts are pushed.
        self.integration_id = integration_id  # type: long
        # The alert event matching rules.
        self.matching_rules = matching_rules  # type: list[ListNotificationPoliciesResponseBodyPageBeanNotificationPoliciesMatchingRules]
        # The name of the notification policy.
        self.name = name  # type: str
        # The notification rules.
        self.notify_rule = notify_rule  # type: ListNotificationPoliciesResponseBodyPageBeanNotificationPoliciesNotifyRule
        # The notification templates.
        self.notify_template = notify_template  # type: ListNotificationPoliciesResponseBodyPageBeanNotificationPoliciesNotifyTemplate
        # Indicates whether the system repeatedly sends notifications for a long-lasting unresolved alert. Default value: true. Valid values:  
        # 
        # - `true`: The system repeatedly sends notifications for a long-lasting unresolved alert at a specified time interval.
        # - `false`: The system sends a notification for a long-lasting unresolved alert based on an escalation policy.
        self.repeat = repeat  # type: bool
        # The time interval at which notifications are sent for a long-lasting unresolved alert. Unit: seconds.
        self.repeat_interval = repeat_interval  # type: long
        # Specifies whether the status of an alert automatically changes to Resolved when all events related to the alert change to the Restored state. The system notifies contacts when the alert status changes to Resolved.  
        # 
        # - `true`: The system sends a notification. This is the default value.
        # - `false`: The system does not send a notification.
        self.send_recover_message = send_recover_message  # type: bool

    def validate(self):
        if self.group_rule:
            self.group_rule.validate()
        if self.matching_rules:
            for k in self.matching_rules:
                if k:
                    k.validate()
        if self.notify_rule:
            self.notify_rule.validate()
        if self.notify_template:
            self.notify_template.validate()

    def to_map(self):
        _map = super(ListNotificationPoliciesResponseBodyPageBeanNotificationPolicies, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.escalation_policy_id is not None:
            result['EscalationPolicyId'] = self.escalation_policy_id
        if self.group_rule is not None:
            result['GroupRule'] = self.group_rule.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.integration_id is not None:
            result['IntegrationId'] = self.integration_id
        result['MatchingRules'] = []
        if self.matching_rules is not None:
            for k in self.matching_rules:
                result['MatchingRules'].append(k.to_map() if k else None)
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_rule is not None:
            result['NotifyRule'] = self.notify_rule.to_map()
        if self.notify_template is not None:
            result['NotifyTemplate'] = self.notify_template.to_map()
        if self.repeat is not None:
            result['Repeat'] = self.repeat
        if self.repeat_interval is not None:
            result['RepeatInterval'] = self.repeat_interval
        if self.send_recover_message is not None:
            result['SendRecoverMessage'] = self.send_recover_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EscalationPolicyId') is not None:
            self.escalation_policy_id = m.get('EscalationPolicyId')
        if m.get('GroupRule') is not None:
            temp_model = ListNotificationPoliciesResponseBodyPageBeanNotificationPoliciesGroupRule()
            self.group_rule = temp_model.from_map(m['GroupRule'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IntegrationId') is not None:
            self.integration_id = m.get('IntegrationId')
        self.matching_rules = []
        if m.get('MatchingRules') is not None:
            for k in m.get('MatchingRules'):
                temp_model = ListNotificationPoliciesResponseBodyPageBeanNotificationPoliciesMatchingRules()
                self.matching_rules.append(temp_model.from_map(k))
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyRule') is not None:
            temp_model = ListNotificationPoliciesResponseBodyPageBeanNotificationPoliciesNotifyRule()
            self.notify_rule = temp_model.from_map(m['NotifyRule'])
        if m.get('NotifyTemplate') is not None:
            temp_model = ListNotificationPoliciesResponseBodyPageBeanNotificationPoliciesNotifyTemplate()
            self.notify_template = temp_model.from_map(m['NotifyTemplate'])
        if m.get('Repeat') is not None:
            self.repeat = m.get('Repeat')
        if m.get('RepeatInterval') is not None:
            self.repeat_interval = m.get('RepeatInterval')
        if m.get('SendRecoverMessage') is not None:
            self.send_recover_message = m.get('SendRecoverMessage')
        return self


class ListNotificationPoliciesResponseBodyPageBean(TeaModel):
    def __init__(self, notification_policies=None, page=None, size=None, total=None):
        # The information about the notification policies.
        self.notification_policies = notification_policies  # type: list[ListNotificationPoliciesResponseBodyPageBeanNotificationPolicies]
        # The number of the page returned.
        self.page = page  # type: long
        # The number of entries that are returned on each page.
        self.size = size  # type: long
        # The number of notification policies that are returned.
        self.total = total  # type: long

    def validate(self):
        if self.notification_policies:
            for k in self.notification_policies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListNotificationPoliciesResponseBodyPageBean, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NotificationPolicies'] = []
        if self.notification_policies is not None:
            for k in self.notification_policies:
                result['NotificationPolicies'].append(k.to_map() if k else None)
        if self.page is not None:
            result['Page'] = self.page
        if self.size is not None:
            result['Size'] = self.size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.notification_policies = []
        if m.get('NotificationPolicies') is not None:
            for k in m.get('NotificationPolicies'):
                temp_model = ListNotificationPoliciesResponseBodyPageBeanNotificationPolicies()
                self.notification_policies.append(temp_model.from_map(k))
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListNotificationPoliciesResponseBody(TeaModel):
    def __init__(self, page_bean=None, request_id=None):
        # The pages that are returned.
        self.page_bean = page_bean  # type: ListNotificationPoliciesResponseBodyPageBean
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_bean:
            self.page_bean.validate()

    def to_map(self):
        _map = super(ListNotificationPoliciesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_bean is not None:
            result['PageBean'] = self.page_bean.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageBean') is not None:
            temp_model = ListNotificationPoliciesResponseBodyPageBean()
            self.page_bean = temp_model.from_map(m['PageBean'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListNotificationPoliciesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListNotificationPoliciesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListNotificationPoliciesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListNotificationPoliciesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOnCallSchedulesRequest(TeaModel):
    def __init__(self, name=None, page=None, size=None):
        # The name of the scheduling policy.
        self.name = name  # type: str
        # The number of the page to return.
        self.page = page  # type: long
        # The number of entries to return on each page.
        self.size = size  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListOnCallSchedulesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.page is not None:
            result['Page'] = self.page
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class ListOnCallSchedulesResponseBodyPageBeanOnCallSchedules(TeaModel):
    def __init__(self, description=None, id=None, name=None):
        # The description of the scheduling policy.
        self.description = description  # type: str
        # The ID of the scheduling policy.
        self.id = id  # type: long
        # The name of the scheduling policy.
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListOnCallSchedulesResponseBodyPageBeanOnCallSchedules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class ListOnCallSchedulesResponseBodyPageBean(TeaModel):
    def __init__(self, on_call_schedules=None, page=None, size=None, total=None):
        # The information about the scheduling policy.
        self.on_call_schedules = on_call_schedules  # type: list[ListOnCallSchedulesResponseBodyPageBeanOnCallSchedules]
        # The page number of the returned page.
        self.page = page  # type: long
        # The number of entries returned per page.
        self.size = size  # type: long
        # The total number of returned entries.
        self.total = total  # type: long

    def validate(self):
        if self.on_call_schedules:
            for k in self.on_call_schedules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListOnCallSchedulesResponseBodyPageBean, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OnCallSchedules'] = []
        if self.on_call_schedules is not None:
            for k in self.on_call_schedules:
                result['OnCallSchedules'].append(k.to_map() if k else None)
        if self.page is not None:
            result['Page'] = self.page
        if self.size is not None:
            result['Size'] = self.size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.on_call_schedules = []
        if m.get('OnCallSchedules') is not None:
            for k in m.get('OnCallSchedules'):
                temp_model = ListOnCallSchedulesResponseBodyPageBeanOnCallSchedules()
                self.on_call_schedules.append(temp_model.from_map(k))
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListOnCallSchedulesResponseBody(TeaModel):
    def __init__(self, page_bean=None, request_id=None):
        # The objects that were returned.
        self.page_bean = page_bean  # type: ListOnCallSchedulesResponseBodyPageBean
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_bean:
            self.page_bean.validate()

    def to_map(self):
        _map = super(ListOnCallSchedulesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_bean is not None:
            result['PageBean'] = self.page_bean.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageBean') is not None:
            temp_model = ListOnCallSchedulesResponseBodyPageBean()
            self.page_bean = temp_model.from_map(m['PageBean'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListOnCallSchedulesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListOnCallSchedulesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListOnCallSchedulesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListOnCallSchedulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPrometheusAlertRulesRequest(TeaModel):
    def __init__(self, cluster_id=None, match_expressions=None, name=None, region_id=None, status=None, type=None):
        # The ID of the cluster.
        self.cluster_id = cluster_id  # type: str
        # The tag match conditions that are described in a JSON string. For more information about this parameter, see the **Additional description of the MatchExpressions parameter** section.
        self.match_expressions = match_expressions  # type: str
        # The name of the alert rule.
        self.name = name  # type: str
        # The region ID of the instance.
        self.region_id = region_id  # type: str
        # Specifies whether the alert rule is enabled. Valid values:
        # 
        # *   `1`: enables the alert rule.
        # *   `0`: disables the alert rule.
        self.status = status  # type: int
        # The type of the alert rule.
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPrometheusAlertRulesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.match_expressions is not None:
            result['MatchExpressions'] = self.match_expressions
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('MatchExpressions') is not None:
            self.match_expressions = m.get('MatchExpressions')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListPrometheusAlertRulesResponseBodyPrometheusAlertRulesAnnotations(TeaModel):
    def __init__(self, name=None, value=None):
        # The name of the annotation.
        self.name = name  # type: str
        # The value of the annotation.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPrometheusAlertRulesResponseBodyPrometheusAlertRulesAnnotations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListPrometheusAlertRulesResponseBodyPrometheusAlertRulesLabels(TeaModel):
    def __init__(self, name=None, value=None):
        # The name of the tag.
        self.name = name  # type: str
        # The value of the tag associated with the instance.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPrometheusAlertRulesResponseBodyPrometheusAlertRulesLabels, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListPrometheusAlertRulesResponseBodyPrometheusAlertRules(TeaModel):
    def __init__(self, alert_id=None, alert_name=None, annotations=None, cluster_id=None, dispatch_rule_id=None,
                 duration=None, expression=None, labels=None, message=None, notify_type=None, status=None, type=None):
        # The ID of the alert rule.
        self.alert_id = alert_id  # type: long
        # The name of the alert rule.
        self.alert_name = alert_name  # type: str
        # The annotations of the alert rule.
        self.annotations = annotations  # type: list[ListPrometheusAlertRulesResponseBodyPrometheusAlertRulesAnnotations]
        # The ID of the cluster.
        self.cluster_id = cluster_id  # type: str
        # The ID of the notification policy. This parameter is returned if the **NotifyType** parameter is set to `DISPATCH_RULE`.
        self.dispatch_rule_id = dispatch_rule_id  # type: long
        # The duration of the alert. Valid values: 1 to 1440. Unit: minutes.
        self.duration = duration  # type: str
        # The expression of the alert rule.
        self.expression = expression  # type: str
        # The tags of the alert rule.
        self.labels = labels  # type: list[ListPrometheusAlertRulesResponseBodyPrometheusAlertRulesLabels]
        # The alert message. Tags can be referenced in the {{$labels.xxx}} format.
        self.message = message  # type: str
        # The method that is used to send alert notifications. Valid values:
        # 
        # *   `ALERT_MANAGER`: Alert notifications are sent by Operation Center.
        # *   `DISPATCH_RULE`: Alert notifications are sent based on the specified notification policy.
        self.notify_type = notify_type  # type: str
        # Indicates whether the alert rule is enabled. Valid values:
        # 
        # *   `1`: The alert rule is enabled.
        # *   `0`: The alert rule is disabled.
        self.status = status  # type: int
        # The type of the alert rule.
        self.type = type  # type: str

    def validate(self):
        if self.annotations:
            for k in self.annotations:
                if k:
                    k.validate()
        if self.labels:
            for k in self.labels:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListPrometheusAlertRulesResponseBodyPrometheusAlertRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_id is not None:
            result['AlertId'] = self.alert_id
        if self.alert_name is not None:
            result['AlertName'] = self.alert_name
        result['Annotations'] = []
        if self.annotations is not None:
            for k in self.annotations:
                result['Annotations'].append(k.to_map() if k else None)
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.dispatch_rule_id is not None:
            result['DispatchRuleId'] = self.dispatch_rule_id
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.expression is not None:
            result['Expression'] = self.expression
        result['Labels'] = []
        if self.labels is not None:
            for k in self.labels:
                result['Labels'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.notify_type is not None:
            result['NotifyType'] = self.notify_type
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertId') is not None:
            self.alert_id = m.get('AlertId')
        if m.get('AlertName') is not None:
            self.alert_name = m.get('AlertName')
        self.annotations = []
        if m.get('Annotations') is not None:
            for k in m.get('Annotations'):
                temp_model = ListPrometheusAlertRulesResponseBodyPrometheusAlertRulesAnnotations()
                self.annotations.append(temp_model.from_map(k))
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DispatchRuleId') is not None:
            self.dispatch_rule_id = m.get('DispatchRuleId')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        self.labels = []
        if m.get('Labels') is not None:
            for k in m.get('Labels'):
                temp_model = ListPrometheusAlertRulesResponseBodyPrometheusAlertRulesLabels()
                self.labels.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NotifyType') is not None:
            self.notify_type = m.get('NotifyType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListPrometheusAlertRulesResponseBody(TeaModel):
    def __init__(self, prometheus_alert_rules=None, request_id=None):
        # The struct returned.
        self.prometheus_alert_rules = prometheus_alert_rules  # type: list[ListPrometheusAlertRulesResponseBodyPrometheusAlertRules]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.prometheus_alert_rules:
            for k in self.prometheus_alert_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListPrometheusAlertRulesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PrometheusAlertRules'] = []
        if self.prometheus_alert_rules is not None:
            for k in self.prometheus_alert_rules:
                result['PrometheusAlertRules'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.prometheus_alert_rules = []
        if m.get('PrometheusAlertRules') is not None:
            for k in m.get('PrometheusAlertRules'):
                temp_model = ListPrometheusAlertRulesResponseBodyPrometheusAlertRules()
                self.prometheus_alert_rules.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListPrometheusAlertRulesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListPrometheusAlertRulesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListPrometheusAlertRulesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPrometheusAlertRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPrometheusAlertTemplatesRequest(TeaModel):
    def __init__(self, cluster_id=None, region_id=None):
        # The ID of the cluster.
        self.cluster_id = cluster_id  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPrometheusAlertTemplatesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ListPrometheusAlertTemplatesResponseBodyPrometheusAlertTemplatesAnnotations(TeaModel):
    def __init__(self, name=None, value=None):
        # The name of the annotation.
        self.name = name  # type: str
        # The value of the annotation.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPrometheusAlertTemplatesResponseBodyPrometheusAlertTemplatesAnnotations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListPrometheusAlertTemplatesResponseBodyPrometheusAlertTemplatesLabels(TeaModel):
    def __init__(self, name=None, value=None):
        # The name of the tag.
        self.name = name  # type: str
        # The value of the tag.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPrometheusAlertTemplatesResponseBodyPrometheusAlertTemplatesLabels, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListPrometheusAlertTemplatesResponseBodyPrometheusAlertTemplates(TeaModel):
    def __init__(self, alert_name=None, annotations=None, description=None, duration=None, expression=None,
                 labels=None, type=None, version=None):
        # The name of the alert rule.
        self.alert_name = alert_name  # type: str
        # The annotations of the alert rule.
        self.annotations = annotations  # type: list[ListPrometheusAlertTemplatesResponseBodyPrometheusAlertTemplatesAnnotations]
        # The content of the alert notification. Tags can be referenced in the {{$labels.xxx}} format.
        self.description = description  # type: str
        # The duration of the alert. Valid values: 1 to 1440. Unit: minutes.
        self.duration = duration  # type: str
        # The expression of the alert rule.
        self.expression = expression  # type: str
        # The tags of the alert rule.
        self.labels = labels  # type: list[ListPrometheusAlertTemplatesResponseBodyPrometheusAlertTemplatesLabels]
        # The type of the alert rule.
        self.type = type  # type: str
        # The version of the alert rule.
        self.version = version  # type: str

    def validate(self):
        if self.annotations:
            for k in self.annotations:
                if k:
                    k.validate()
        if self.labels:
            for k in self.labels:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListPrometheusAlertTemplatesResponseBodyPrometheusAlertTemplates, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_name is not None:
            result['AlertName'] = self.alert_name
        result['Annotations'] = []
        if self.annotations is not None:
            for k in self.annotations:
                result['Annotations'].append(k.to_map() if k else None)
        if self.description is not None:
            result['Description'] = self.description
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.expression is not None:
            result['Expression'] = self.expression
        result['Labels'] = []
        if self.labels is not None:
            for k in self.labels:
                result['Labels'].append(k.to_map() if k else None)
        if self.type is not None:
            result['Type'] = self.type
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertName') is not None:
            self.alert_name = m.get('AlertName')
        self.annotations = []
        if m.get('Annotations') is not None:
            for k in m.get('Annotations'):
                temp_model = ListPrometheusAlertTemplatesResponseBodyPrometheusAlertTemplatesAnnotations()
                self.annotations.append(temp_model.from_map(k))
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        self.labels = []
        if m.get('Labels') is not None:
            for k in m.get('Labels'):
                temp_model = ListPrometheusAlertTemplatesResponseBodyPrometheusAlertTemplatesLabels()
                self.labels.append(temp_model.from_map(k))
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class ListPrometheusAlertTemplatesResponseBody(TeaModel):
    def __init__(self, prometheus_alert_templates=None, request_id=None):
        # The returned struct.
        self.prometheus_alert_templates = prometheus_alert_templates  # type: list[ListPrometheusAlertTemplatesResponseBodyPrometheusAlertTemplates]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.prometheus_alert_templates:
            for k in self.prometheus_alert_templates:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListPrometheusAlertTemplatesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PrometheusAlertTemplates'] = []
        if self.prometheus_alert_templates is not None:
            for k in self.prometheus_alert_templates:
                result['PrometheusAlertTemplates'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.prometheus_alert_templates = []
        if m.get('PrometheusAlertTemplates') is not None:
            for k in m.get('PrometheusAlertTemplates'):
                temp_model = ListPrometheusAlertTemplatesResponseBodyPrometheusAlertTemplates()
                self.prometheus_alert_templates.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListPrometheusAlertTemplatesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListPrometheusAlertTemplatesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListPrometheusAlertTemplatesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPrometheusAlertTemplatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPrometheusGlobalViewRequest(TeaModel):
    def __init__(self, region_id=None):
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPrometheusGlobalViewRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ListPrometheusGlobalViewResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPrometheusGlobalViewResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListPrometheusGlobalViewResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListPrometheusGlobalViewResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListPrometheusGlobalViewResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPrometheusGlobalViewResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPrometheusInstanceByTagAndResourceGroupIdRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPrometheusInstanceByTagAndResourceGroupIdRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListPrometheusInstanceByTagAndResourceGroupIdRequest(TeaModel):
    def __init__(self, region_id=None, resource_group_id=None, tag=None):
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.tag = tag  # type: list[ListPrometheusInstanceByTagAndResourceGroupIdRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListPrometheusInstanceByTagAndResourceGroupIdRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = ListPrometheusInstanceByTagAndResourceGroupIdRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class ListPrometheusInstanceByTagAndResourceGroupIdResponseBodyDataPrometheusInstancesTags(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPrometheusInstanceByTagAndResourceGroupIdResponseBodyDataPrometheusInstancesTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class ListPrometheusInstanceByTagAndResourceGroupIdResponseBodyDataPrometheusInstances(TeaModel):
    def __init__(self, cluster_id=None, cluster_name=None, cluster_type=None, grafana_instance_id=None,
                 payment_type=None, region_id=None, resource_group_id=None, security_group_id=None, sub_clusters_json=None,
                 tags=None, user_id=None, v_switch_id=None, vpc_id=None):
        self.cluster_id = cluster_id  # type: str
        self.cluster_name = cluster_name  # type: str
        self.cluster_type = cluster_type  # type: str
        self.grafana_instance_id = grafana_instance_id  # type: str
        self.payment_type = payment_type  # type: str
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.security_group_id = security_group_id  # type: str
        self.sub_clusters_json = sub_clusters_json  # type: str
        self.tags = tags  # type: list[ListPrometheusInstanceByTagAndResourceGroupIdResponseBodyDataPrometheusInstancesTags]
        self.user_id = user_id  # type: str
        self.v_switch_id = v_switch_id  # type: str
        # VPC ID。
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListPrometheusInstanceByTagAndResourceGroupIdResponseBodyDataPrometheusInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.grafana_instance_id is not None:
            result['GrafanaInstanceId'] = self.grafana_instance_id
        if self.payment_type is not None:
            result['PaymentType'] = self.payment_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.sub_clusters_json is not None:
            result['SubClustersJson'] = self.sub_clusters_json
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('GrafanaInstanceId') is not None:
            self.grafana_instance_id = m.get('GrafanaInstanceId')
        if m.get('PaymentType') is not None:
            self.payment_type = m.get('PaymentType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('SubClustersJson') is not None:
            self.sub_clusters_json = m.get('SubClustersJson')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = ListPrometheusInstanceByTagAndResourceGroupIdResponseBodyDataPrometheusInstancesTags()
                self.tags.append(temp_model.from_map(k))
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class ListPrometheusInstanceByTagAndResourceGroupIdResponseBodyData(TeaModel):
    def __init__(self, prometheus_instances=None):
        self.prometheus_instances = prometheus_instances  # type: list[ListPrometheusInstanceByTagAndResourceGroupIdResponseBodyDataPrometheusInstances]

    def validate(self):
        if self.prometheus_instances:
            for k in self.prometheus_instances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListPrometheusInstanceByTagAndResourceGroupIdResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PrometheusInstances'] = []
        if self.prometheus_instances is not None:
            for k in self.prometheus_instances:
                result['PrometheusInstances'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.prometheus_instances = []
        if m.get('PrometheusInstances') is not None:
            for k in m.get('PrometheusInstances'):
                temp_model = ListPrometheusInstanceByTagAndResourceGroupIdResponseBodyDataPrometheusInstances()
                self.prometheus_instances.append(temp_model.from_map(k))
        return self


class ListPrometheusInstanceByTagAndResourceGroupIdResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: ListPrometheusInstanceByTagAndResourceGroupIdResponseBodyData
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListPrometheusInstanceByTagAndResourceGroupIdResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListPrometheusInstanceByTagAndResourceGroupIdResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListPrometheusInstanceByTagAndResourceGroupIdResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListPrometheusInstanceByTagAndResourceGroupIdResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListPrometheusInstanceByTagAndResourceGroupIdResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPrometheusInstanceByTagAndResourceGroupIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPrometheusInstancesRequest(TeaModel):
    def __init__(self, region_id=None, show_global_view=None):
        # The ID of the region.
        self.region_id = region_id  # type: str
        # Specifies whether to obtain global aggregation instances. Valid values:
        # 
        # *   true
        # *   false
        self.show_global_view = show_global_view  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPrometheusInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.show_global_view is not None:
            result['ShowGlobalView'] = self.show_global_view
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ShowGlobalView') is not None:
            self.show_global_view = m.get('ShowGlobalView')
        return self


class ListPrometheusInstancesResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The Prometheus instances in the region in the JSON format.
        self.data = data  # type: str
        # The ID of the request. You can use the ID to query logs and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPrometheusInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListPrometheusInstancesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListPrometheusInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListPrometheusInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPrometheusInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPrometheusIntegrationRequest(TeaModel):
    def __init__(self, cluster_id=None, integration_type=None, region_id=None):
        self.cluster_id = cluster_id  # type: str
        self.integration_type = integration_type  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPrometheusIntegrationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.integration_type is not None:
            result['IntegrationType'] = self.integration_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('IntegrationType') is not None:
            self.integration_type = m.get('IntegrationType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ListPrometheusIntegrationResponseBodyData(TeaModel):
    def __init__(self, can_delete=None, can_editor=None, cluster_id=None, container_name=None, describe=None,
                 exporter_type=None, instance_id=None, instance_name=None, integration_type=None, namespace=None,
                 need_upgrade=None, param=None, pod_name=None, show_describe=None, show_log=None, status=None, target=None,
                 version=None):
        self.can_delete = can_delete  # type: bool
        self.can_editor = can_editor  # type: bool
        self.cluster_id = cluster_id  # type: str
        self.container_name = container_name  # type: str
        self.describe = describe  # type: str
        self.exporter_type = exporter_type  # type: str
        self.instance_id = instance_id  # type: long
        self.instance_name = instance_name  # type: str
        self.integration_type = integration_type  # type: str
        self.namespace = namespace  # type: str
        self.need_upgrade = need_upgrade  # type: bool
        self.param = param  # type: str
        self.pod_name = pod_name  # type: str
        self.show_describe = show_describe  # type: bool
        self.show_log = show_log  # type: bool
        self.status = status  # type: str
        self.target = target  # type: str
        self.version = version  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPrometheusIntegrationResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.can_delete is not None:
            result['CanDelete'] = self.can_delete
        if self.can_editor is not None:
            result['CanEditor'] = self.can_editor
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.container_name is not None:
            result['ContainerName'] = self.container_name
        if self.describe is not None:
            result['Describe'] = self.describe
        if self.exporter_type is not None:
            result['ExporterType'] = self.exporter_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.integration_type is not None:
            result['IntegrationType'] = self.integration_type
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.need_upgrade is not None:
            result['NeedUpgrade'] = self.need_upgrade
        if self.param is not None:
            result['Param'] = self.param
        if self.pod_name is not None:
            result['PodName'] = self.pod_name
        if self.show_describe is not None:
            result['ShowDescribe'] = self.show_describe
        if self.show_log is not None:
            result['ShowLog'] = self.show_log
        if self.status is not None:
            result['Status'] = self.status
        if self.target is not None:
            result['Target'] = self.target
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CanDelete') is not None:
            self.can_delete = m.get('CanDelete')
        if m.get('CanEditor') is not None:
            self.can_editor = m.get('CanEditor')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ContainerName') is not None:
            self.container_name = m.get('ContainerName')
        if m.get('Describe') is not None:
            self.describe = m.get('Describe')
        if m.get('ExporterType') is not None:
            self.exporter_type = m.get('ExporterType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('IntegrationType') is not None:
            self.integration_type = m.get('IntegrationType')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NeedUpgrade') is not None:
            self.need_upgrade = m.get('NeedUpgrade')
        if m.get('Param') is not None:
            self.param = m.get('Param')
        if m.get('PodName') is not None:
            self.pod_name = m.get('PodName')
        if m.get('ShowDescribe') is not None:
            self.show_describe = m.get('ShowDescribe')
        if m.get('ShowLog') is not None:
            self.show_log = m.get('ShowLog')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class ListPrometheusIntegrationResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: int
        self.data = data  # type: list[ListPrometheusIntegrationResponseBodyData]
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListPrometheusIntegrationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListPrometheusIntegrationResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListPrometheusIntegrationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListPrometheusIntegrationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListPrometheusIntegrationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPrometheusIntegrationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPrometheusRemoteWritesRequest(TeaModel):
    def __init__(self, cluster_id=None, region_id=None):
        # The ID of the Prometheus instance.
        self.cluster_id = cluster_id  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPrometheusRemoteWritesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ListPrometheusRemoteWritesResponseBodyData(TeaModel):
    def __init__(self, cluster_id=None, remote_write_name=None, remote_write_yaml=None):
        # The ID of the Prometheus instance.
        self.cluster_id = cluster_id  # type: str
        # The name of the Remote Write configuration item.
        self.remote_write_name = remote_write_name  # type: str
        # The details of the Remote Write configuration item. The value is in the YAML format.
        self.remote_write_yaml = remote_write_yaml  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPrometheusRemoteWritesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.remote_write_name is not None:
            result['RemoteWriteName'] = self.remote_write_name
        if self.remote_write_yaml is not None:
            result['RemoteWriteYaml'] = self.remote_write_yaml
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('RemoteWriteName') is not None:
            self.remote_write_name = m.get('RemoteWriteName')
        if m.get('RemoteWriteYaml') is not None:
            self.remote_write_yaml = m.get('RemoteWriteYaml')
        return self


class ListPrometheusRemoteWritesResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        # The HTTP status code that is returned. The HTTP 200 status code indicates that the call is successful. If a different HTTP status code is returned, the call fails.
        self.code = code  # type: int
        # The list of Remote Write configuration items.
        self.data = data  # type: list[ListPrometheusRemoteWritesResponseBodyData]
        # The message that is returned.
        self.message = message  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Indicates whether the call was successful. Valid values: true and false.
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListPrometheusRemoteWritesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListPrometheusRemoteWritesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListPrometheusRemoteWritesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListPrometheusRemoteWritesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListPrometheusRemoteWritesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPrometheusRemoteWritesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRetcodeAppsRequestTags(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag key.
        self.key = key  # type: str
        # The tag value.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRetcodeAppsRequestTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListRetcodeAppsRequest(TeaModel):
    def __init__(self, region_id=None, resource_group_id=None, tags=None):
        # The ID of the region.
        self.region_id = region_id  # type: str
        # The ID of the resource group. You can obtain the resource group ID in the **Resource Management** console.
        self.resource_group_id = resource_group_id  # type: str
        # The list of tags.
        self.tags = tags  # type: list[ListRetcodeAppsRequestTags]

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListRetcodeAppsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = ListRetcodeAppsRequestTags()
                self.tags.append(temp_model.from_map(k))
        return self


class ListRetcodeAppsResponseBodyRetcodeAppsTags(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag key.
        self.key = key  # type: str
        # The tag value.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRetcodeAppsResponseBodyRetcodeAppsTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListRetcodeAppsResponseBodyRetcodeApps(TeaModel):
    def __init__(self, app_id=None, app_name=None, nick_name=None, pid=None, resource_group_id=None,
                 retcode_app_type=None, tags=None):
        # The ID of the application. The parameter is an auto-increment parameter.
        self.app_id = app_id  # type: long
        # The name of the application.
        self.app_name = app_name  # type: str
        # The alias of the application.
        self.nick_name = nick_name  # type: str
        # The PID of the application.
        self.pid = pid  # type: str
        # The ID of the resource group.
        self.resource_group_id = resource_group_id  # type: str
        # The type of the application. Valid values:
        # 
        # *   `web`: web application
        # *   `weex`: Weex mobile app
        # *   `mini_dd`: DingTalk mini program
        # *   `mini_alipay`: Alipay mini program
        # *   `mini_wx`: WeChat mini program
        # *   `mini_common`: mini program on other platforms
        self.retcode_app_type = retcode_app_type  # type: str
        # The list of tags.
        self.tags = tags  # type: list[ListRetcodeAppsResponseBodyRetcodeAppsTags]

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListRetcodeAppsResponseBodyRetcodeApps, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.nick_name is not None:
            result['NickName'] = self.nick_name
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.retcode_app_type is not None:
            result['RetcodeAppType'] = self.retcode_app_type
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('NickName') is not None:
            self.nick_name = m.get('NickName')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('RetcodeAppType') is not None:
            self.retcode_app_type = m.get('RetcodeAppType')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = ListRetcodeAppsResponseBodyRetcodeAppsTags()
                self.tags.append(temp_model.from_map(k))
        return self


class ListRetcodeAppsResponseBody(TeaModel):
    def __init__(self, request_id=None, retcode_apps=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The information about monitored applications.
        self.retcode_apps = retcode_apps  # type: list[ListRetcodeAppsResponseBodyRetcodeApps]

    def validate(self):
        if self.retcode_apps:
            for k in self.retcode_apps:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListRetcodeAppsResponseBody, self).to_map()
        if _map is not None:
            retur