| Element | Description |
| --- | --- |
| [`<area>`](/en-US/docs/Web/HTML/Element/area "The HTML <area> element defines a hot-spot region on an image, and optionally associates it with a hypertext link. This element is used only within a <map> element.") | The _HTML `<area>` element_ defines a hot-spot region on an image, and optionally associates it with a [hypertext link](/en-US/docs/Glossary/Hyperlink "hypertext link: Hyperlinks connect webpages or data items to one another. In HTML, <a> elements define hyperlinks from a spot on a webpage (like a text string or image) to another spot on some webpage (even the same page)."). This element is used only within a [`<map>`](/en-US/docs/Web/HTML/Element/map "The HTML <map> element is used with <area> elements to define an image map (a clickable link area).") element. |
| [`<audio>`](/en-US/docs/Web/HTML/Element/audio "The HTML <audio> element is used to embed sound content in documents. It may contain one or more audio sources, represented using the src attribute or the <source> element; the browser will choose the most suitable one.") | The **HTML `<audio>` element** is used to embed sound content in documents. It may contain one or more audio sources, represented using the `src` attribute or the [`<source>`](/en-US/docs/Web/HTML/Element/source "The HTML <source> element specifies multiple media resources for either the <picture>, the <audio> or the <video> element. It is an empty element. It is commonly used to serve the same media content in multiple formats supported by different browsers.") element; the browser will choose the most suitable one. |
| [`<img>`](/en-US/docs/Web/HTML/Element/img "The HTML <img> element represents an image in the document.") | The **HTML `<img>` element** represents an image in the document. |
| [`<map>`](/en-US/docs/Web/HTML/Element/map "The HTML <map> element is used with <area> elements to define an image map (a clickable link area).") | The **HTML `<map>` element** is used with [`<area>`](/en-US/docs/Web/HTML/Element/area "The HTML <area> element defines a hot-spot region on an image, and optionally associates it with a hypertext link. This element is used only within a <map> element.") elements to define an image map (a clickable link area). |
| [`<track>`](/en-US/docs/Web/HTML/Element/track "The HTML <track> element is used as a child of the media elements—<audio> and <video>. It lets you specify timed text tracks (or time-based data), for example to automatically handle subtitles. The tracks are formatted in WebVTT format (.vtt files) — Web Video Text Tracks.") | The **HTML `<track>` element** is used as a child of the media elements—[`<audio>`](/en-US/docs/Web/HTML/Element/audio "The HTML <audio> element is used to embed sound content in documents. It may contain one or more audio sources, represented using the src attribute or the <source> element; the browser will choose the most suitable one.") and [`<video>`](/en-US/docs/Web/HTML/Element/video "Use the  HTML <video> element to embed video content in a document. The video element contains one or more video sources. To specify a video source, use either the src attribute or the <source> element; the browser will choose the most suitable one."). It lets you specify timed text tracks (or time-based data), for example to automatically handle subtitles. The tracks are formatted in [WebVTT format](/en-US/docs/Web/API/Web_Video_Text_Tracks_Format) (`.vtt` files) — Web Video Text Tracks. |
| [`<video>`](/en-US/docs/Web/HTML/Element/video "Use the  HTML <video> element to embed video content in a document. The video element contains one or more video sources. To specify a video source, use either the src attribute or the <source> element; the browser will choose the most suitable one.") | Use the **HTML `<video>` element** to embed video content in a document. The video element contains one or more video sources. To specify a video source, use either the `src` attribute or the [`<source>`](/en-US/docs/Web/HTML/Element/source "The HTML <source> element specifies multiple media resources for either the <picture>, the <audio> or the <video> element. It is an empty element. It is commonly used to serve the same media content in multiple formats supported by different browsers.") element; the browser will choose the most suitable one. |
