| Element | Description |
| --- | --- |
| [`<button>`](/en-US/docs/Web/HTML/Element/button "The HTML <button> Element represents a clickable button.") | The **HTML _`<button>`_ Element** represents a clickable button. |
| [`<datalist>`](/en-US/docs/Web/HTML/Element/datalist "The HTML Datalist Element (<datalist>) contains a set of <option> elements that represent the values available for other controls.") | The _HTML Datalist Element_ (**<datalist>**) contains a set of [`<option>`](/en-US/docs/Web/HTML/Element/option "In a Web form, the HTML <option> element is used to create a control representing an item within a <select>, an <optgroup> or a <datalist> HTML5 element.") elements that represent the values available for other controls. |
| [`<fieldset>`](/en-US/docs/Web/HTML/Element/fieldset "The HTML <fieldset> element is used to group several controls as well as labels (<label>) within a web form.") | The **HTML `<fieldset>` element** is used to group several controls as well as labels ([`<label>`](/en-US/docs/Web/HTML/Element/label "The HTML Label Element (<label>) represents a caption for an item in a user interface. It can be associated with a control either by placing the control element inside the <label> element, or by using the for attribute. Such a control is called the labeled control of the label element. One input can be associated with multiple labels.")) within a web form. |
| [`<form>`](/en-US/docs/Web/HTML/Element/form "The HTML <form> element represents a document section that contains interactive controls to submit information to a web server.") | The **HTML `<form>` element** represents a document section that contains interactive controls to submit information to a web server. |
| [`<input>`](/en-US/docs/Web/HTML/Element/input "The HTML element <input> is used to create interactive controls for web-based forms in order to accept data from the user. How an <input> works varies considerably depending on the value of its type attribute.") | The HTML element `<input>` is used to create interactive controls for web-based forms in order to accept data from the user. How an `<input>` works varies considerably depending on the value of its `type` attribute. |
| [`<label>`](/en-US/docs/Web/HTML/Element/label "The HTML Label Element (<label>) represents a caption for an item in a user interface. It can be associated with a control either by placing the control element inside the <label> element, or by using the for attribute. Such a control is called the labeled control of the label element. One input can be associated with multiple labels.") | The _HTML Label Element_ (`<strong><label></strong>`) represents a caption for an item in a user interface. It can be associated with a control either by placing the control element inside the `<label>` element, or by using the `<a href="/en-US/docs/Web/HTML/Global_attributes#attr-for">for</a>` attribute. Such a control is called the _labeled control_ of the label element. One input can be associated with multiple labels. |
| [`<legend>`](/en-US/docs/Web/HTML/Element/legend "The HTML <legend> Element (or HTML Legend Field Element) represents a caption for the content of its parent <fieldset>.") | The **HTML `<legend>` Element** (or _HTML Legend Field Element_) represents a caption for the content of its parent [`<fieldset>`](/en-US/docs/Web/HTML/Element/fieldset "The HTML <fieldset> element is used to group several controls as well as labels (<label>) within a web form."). |
| [`<meter>`](/en-US/docs/Web/HTML/Element/meter "The HTML <meter> Element represents either a scalar value within a known range or a fractional value.") | The **HTML `<meter>` Element** represents either a scalar value within a known range or a fractional value. |
| [`<optgroup>`](/en-US/docs/Web/HTML/Element/optgroup "In a Web form, the HTML <optgroup> element  creates a grouping of options within a <select> element.") | In a Web form, the **HTML `<optgroup>` element** creates a grouping of options within a [`<select>`](/en-US/docs/Web/HTML/Element/select "The HTML select (<select>) element represents a control that presents a menu of options. The options within the menu are represented by <option> elements, which can be grouped by <optgroup> elements. Options can be pre-selected for the user.") element. |
| [`<option>`](/en-US/docs/Web/HTML/Element/option "In a Web form, the HTML <option> element is used to create a control representing an item within a <select>, an <optgroup> or a <datalist> HTML5 element.") | In a Web form, the **HTML `<option>` element** is used to create a control representing an item within a [`<select>`](/en-US/docs/Web/HTML/Element/select "The HTML select (<select>) element represents a control that presents a menu of options. The options within the menu are represented by <option> elements, which can be grouped by <optgroup> elements. Options can be pre-selected for the user."), an [`<optgroup>`](/en-US/docs/Web/HTML/Element/optgroup "In a Web form, the HTML <optgroup> element  creates a grouping of options within a <select> element.") or a [`<datalist>`](/en-US/docs/Web/HTML/Element/datalist "The HTML Datalist Element (<datalist>) contains a set of <option> elements that represent the values available for other controls.") HTML5 element. |
| [`<output>`](/en-US/docs/Web/HTML/Element/output "The HTML <output> element represents the result of a calculation or user action.") | The **HTML `<output>` element** represents the result of a calculation or user action. |
| [`<progress>`](/en-US/docs/Web/HTML/Element/progress "The HTML <progress> Element is used to view the completion progress of a task. While the specifics of how it's displayed is left up to the browser developer, it's typically displayed as a progress bar. Javascript can be used to manipulate the value of progress bar.") | The **HTML `<progress>` Element** is used to view the completion progress of a task. While the specifics of how it's displayed is left up to the browser developer, it's typically displayed as a progress bar. Javascript can be used to manipulate the value of progress bar. |
| [`<select>`](/en-US/docs/Web/HTML/Element/select "The HTML select (<select>) element represents a control that presents a menu of options. The options within the menu are represented by <option> elements, which can be grouped by <optgroup> elements. Options can be pre-selected for the user.") | The HTML _select_ (`<select>`) element represents a control that presents a menu of options. The options within the menu are represented by `<a href="/en-US/docs/Web/HTML/Element/option" title="In a Web form, the HTML <option> element is used to create a control representing an item within a <select>, an <optgroup> or a <datalist> HTML5 element."><code><option></code></a>` elements, which can be grouped by `<a href="/en-US/docs/Web/HTML/Element/optgroup" title="In a Web form, the HTML <optgroup> element&#xA0; creates a grouping of options within a <select> element."><code><optgroup></code></a>` elements. Options can be pre-selected for the user. |
| [`<textarea>`](/en-US/docs/Web/HTML/Element/textarea "The HTML <textarea> element represents a multi-line plain-text editing control.") | The **HTML `<textarea> ` element** represents a multi-line plain-text editing control. |
