### Attributes

Most elements need, or can have, additional information specified in order to function properly, or as intended. These details are given via special _name_="_value"_ pairs called attributes, and are included in the opening tag of the element. Each element or element-type has its own set of [allowed attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes), (See desired element for its specific list), but there are also general or ["global" attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes) that can be applied to ANY element (though some may have no effect.) Note that attribute values should be in quotes (and MUST be to properly function if value contains any whitespace -- for example, a [class-list)](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/class) but there is usually no error message generated if quotes are missing. Note also that there is usually no error generated by misspelled or undefined attributes (though they do violate the formal spec), and thus some complex HTML documents may make use of their own private attribute-names in handling their data and elements.
