# AUTOGENERATED! DO NOT EDIT! File to edit: 03_dashboards.ipynb (unless otherwise specified).

__all__ = ['STYLE', 'INITIAL_WIDGET_PARAMS', 'Dashboards', 'Alexia_patched_cells_vs_baseline', 'launch']

# Cell
from dcl_stats_n_plots import stats
from dcl_stats_n_plots import plots
from dcl_stats_n_plots import gui

import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import seaborn as sns
import pingouin as pg
import itertools
import math
import os

import ipywidgets as w
from IPython.display import display

# Cell
STYLE = {'description_width': 'initial'}

# Cell

# Initial params:
INITIAL_WIDGET_PARAMS = {'dashboards_dropdown': {'options': [('Alexia_patched_cells_vs_baseline', 0),
                                                            ('Lara_Pauline_cardiac_opto_parameter_testing', 1)],
                                                 'value': 0},
                         'customization_accordion': {'visibility': 'hidden'},
                         'xlabel_order': {'visibility': 'hidden',
                                              'value': ' '},
                         'hue_order': {'visibility': 'hidden',
                                              'value': ' '},
                         'group_colors_vbox': {'children': ()}}

# Cell
class Dashboards:
    """
    Top-level architecture of the dashboards GUI
    """
    def __init__(self):
        self.params = self.set_initial_params()

        # Widgets, Output, and Layout
        self.dashboards_dropdown = w.Dropdown(description = 'Please select a dashboard:',
                                               options = self.params['widgets']['dashboards_dropdown']['options'],
                                               value = self.params['widgets']['dashboards_dropdown']['value'],
                                               layout = {'width': '75%'},
                                               style = STYLE)
        self.dashboards_button = w.Button(description = "Launch dashboard", icon = 'rocket')
        self.dashboard_selection = w.HBox([self.dashboards_dropdown, self.dashboards_button], layout={'width': '50%'})

        self.dashboard = w.VBox([])
        self.dashboard.layout.visibility = 'hidden'

        self.out = w.Output(layout={'width': '50%'})

        self.widget = w.VBox([w.HBox([self.dashboard_selection, self.out]), self.dashboard])

        # Link buttons
        self.dashboards_button.on_click(self.on_dashboard_button_clicked)


    ## Methods to initialize or update the params, or to update the widgets accordingly
    # Initialzie params
    def set_initial_params(self):
        params = {'data': None, # will be updated when data is uploaded
                  'results': None, # will be updated when statistics are computed
                  'save_plot': False,
                  'ready_for_summary': False,
                  'summary_save_plot': False,
                  'widgets': INITIAL_WIDGET_PARAMS}
        return params


    ## Methods to define button functions
    # Stats button
    def on_dashboard_button_clicked(self, b):
        with self.out:
            if self.dashboards_dropdown.value == 0: # Alexia_patched_cells_vs_baseline
                self.dashboard.children = Alexia_patched_cells_vs_baseline(self.params).widget.children
                self.dashboard.layout.visibility = 'visible'
                print('Dashboard "Alexia_patched_cells_vs_baseline" successfully launched!')
                #self.dashboard.layout.width = '90%'

# Cell
class Alexia_patched_cells_vs_baseline:
    "Creates the dashboard for Alexias Institute-PR on the 06-10-2021"
    def __init__(self, params):
        self.params = params
        self.uploader = w.FileUpload(accept=('.xlsx, .csv'), multiple=False)

        self.preview_button = w.Button(description = "Preview")
        self.process_all_button = w.Button(description = "Process all data", layout = {'visibility': 'hidden'})
        self.show_summary_button = w.Button(description = "Show summary", layout = {'visibility': 'hidden'})

        self.customization = gui.Customization_widget()
        self.customization.widget.layout.width = '75%'

        # Adapt to what is needed here:
        ## Customize annotation widgets:
        self.customization.customize_annotations.widget.children = [self.customization.customize_annotations.set_distance_brackets_to_data,
                                                                    self.customization.customize_annotations.set_fontsize_stars,
                                                                    self.customization.customize_annotations.set_stars_fontweight_bold]
        self.customization.customize_annotations.set_distance_brackets_to_data.description = 'Distance annotations to data'
        self.customization.customize_annotations.set_distance_brackets_to_data.layout.width = '30%'
        self.customization.customize_annotations.set_fontsize_stars.layout.width = '30%'
        self.customization.annotations_accordion.children = [self.customization.customize_annotations.widget]
        self.customization.annotations_accordion.set_title(0, 'Customize annotation features')

        # Customize axes widgets:
        self.customization.yaxis.set_yaxis_label_text_measurement_a = w.Text(value='normalized frequency [Hz]', placeholder='normalized frequency [Hz]',
                                                                             description='y-axis title left subplots:', layout={'width': '45%'}, style={'description_width': 'initial'})
        self.customization.yaxis.set_yaxis_label_text_measurement_b = w.Text(value='normalized amplitude [mA]', placeholder='normalized amplitude [mA]',
                                                                             description='y-axis title right subplots:', layout={'width': '45%'}, style={'description_width': 'initial'})
        self.customization.yaxis.set_yaxis_label_color.layout.width = '45%'
        self.customization.yaxis.set_yaxis_label_fontsize.layout.width = '45%'
        self.customization.yaxis.set_yaxis_center = w.RadioButtons(description = 'Center baseline on y-axis:',
                                                              options=[('No thanks', 0), ('Yes please!', 1)],
                                                              value=0, layout={'width': '30%', 'height': '75px'}, style={'description_width': 'initial'})
        self.customization.yaxis.set_yaxis_scaling_mode.description = 'Y-axis scaling:'
        self.customization.yaxis.set_yaxis_scaling_mode.layout.width = '30%'
        self.customization.yaxis.set_yaxis_lower_lim.layout.width = '15%'
        self.customization.yaxis.set_yaxis_upper_lim.layout.width = '15%'
        self.customization.yaxis.widget.children = [w.HBox([self.customization.yaxis.set_yaxis_label_text_measurement_a, self.customization.yaxis.set_yaxis_label_text_measurement_b]),
                                                    w.HBox([self.customization.yaxis.set_yaxis_label_fontsize, self.customization.yaxis.set_yaxis_label_color]),
                                                    w.HBox([self.customization.yaxis.set_yaxis_center, self.customization.yaxis.set_yaxis_scaling_mode,
                                                            self.customization.yaxis.set_yaxis_lower_lim, self.customization.yaxis.set_yaxis_upper_lim])]


        self.set_yaxis_label_text = w.Text(value='data', placeholder='data', description='y-axis title:', layout={'width': '36%'})
        self.set_yaxis_label_fontsize = w.IntSlider(value=12, min=8, max=40, step=1, description='fontsize:', layout={'width': '28%'})
        self.set_yaxis_label_color = w.ColorPicker(concise=False, description='font color', value='#000000', layout={'width': '28%'})

        # Add new accordion for titles:
        self.customization.set_subtitle_left_color = w.ColorPicker(concise=False, description='font color', value='#000000', layout={'width': '20%'}, style={'description_width': 'initial'})
        self.customization.set_subtitle_left_fontsize = w.IntSlider(value=12, min=8, max=40, step=1, description='fontsize:', layout={'width': '20%'}, style={'description_width': 'initial'})
        self.customization.set_subtitle_left_text = w.Text(value='-70 mV', placeholder='-70 mV', description='left subtitle:', layout={'width': '30%'}, style={'description_width': 'initial'})
        self.customization.set_subtitle_left_pad = w.IntSlider(value=10, min=0, max=60, step=1, description='distance:', layout={'width': '20%'}, style={'description_width': 'initial'})

        self.customization.set_subtitle_right_color = w.ColorPicker(concise=False, description='font color', value='#000000', layout={'width': '20%'}, style={'description_width': 'initial'})
        self.customization.set_subtitle_right_fontsize = w.IntSlider(value=12, min=8, max=40, step=1, description='fontsize:', layout={'width': '20%'}, style={'description_width': 'initial'})
        self.customization.set_subtitle_right_text = w.Text(value='0 mV', placeholder='0 mV', description='right subtitle:', layout={'width': '30%'}, style={'description_width': 'initial'})
        self.customization.set_subtitle_right_pad = w.IntSlider(value=10, min=0, max=60, step=1, description='distance:', layout={'width': '20%'}, style={'description_width': 'initial'})

        self.customization.set_title_color = w.ColorPicker(concise=False, description='font color', value='#000000', layout={'width': '20%'}, style={'description_width': 'initial'})
        self.customization.set_title_fontsize = w.IntSlider(value=12, min=8, max=40, step=1, description='fontsize:', layout={'width': '20%'}, style={'description_width': 'initial'})
        self.customization.set_title_text = w.Text(value='cell_id (immutable)', placeholder='cell_id (immutable)', description='title:', layout={'width': '30%'}, style={'description_width': 'initial'})
        self.customization.set_title_pad = w.IntSlider(value=10, min=0, max=60, step=1, description='distance:', layout={'width': '20%'}, style={'description_width': 'initial'})

        self.customization.titles = w.VBox([w.HBox([self.customization.set_subtitle_left_text, self.customization.set_subtitle_left_fontsize, self.customization.set_subtitle_left_pad, self.customization.set_subtitle_left_color]),
                                            w.HBox([self.customization.set_subtitle_right_text, self.customization.set_subtitle_right_fontsize, self.customization.set_subtitle_right_pad, self.customization.set_subtitle_right_color]),
                                            w.HBox([self.customization.set_title_text, self.customization.set_title_fontsize, self.customization.set_title_pad, self.customization.set_title_color])])

        # Add new accordion for summary:
        self.customization.select_summary_hue_col = w.Dropdown(description = 'Please select what feature shall be used for subgrouping:',
                                                               options = ['to come'],
                                                               value = 'to come',
                                                               layout = {'width': '70%'},
                                                               style = STYLE)
        self.customization.set_summary_hue_order = w.Text(value='hue order',
                                                             placeholder='Specify the desired group order with individual groups separated by a comma',
                                                             description='group order (separated by comma):',
                                                             layout={'width': '70%', 'height': '75px'},
                                                             style={'description_width': 'initial'})
        self.customization.select_summary_palette_or_individual_color = w.RadioButtons(description = 'Please select a color code option and chose from the respective options below:',
                                                                                       options=[('Use a pre-defined palette', 0), ('Define colors individually', 1)],
                                                                                       value=0, layout={'width': '75%', 'height': '75px'}, style={'description_width': 'initial'})
        self.customization.select_summary_color_palettes = w.Dropdown(options=['colorblind', 'Spectral', 'viridis', 'rocket', 'cubehelix'],
                                                                      value='colorblind',
                                                                      description='Select a color palette',
                                                                      #layout={'width': '40%'},
                                                                      style={'description_width': 'initial'})
        self.customization.summary_group_colors_vbox = w.VBox([], layout={'width': '60%'})
        self.customization.summary_save_plot = w.Checkbox(value=False, description='Save summary plots', style={'description_width': 'initial'})
        self.customization.summary_show_legend = w.Checkbox(value=True, description='Show legend', style={'description_width': 'initial'})
        self.customization.summary_legend_title = w.Text(value='subgroups defined\non {}'.format(self.customization.select_summary_hue_col.value),
                                                         placeholder='use backslash n: "\\n" to create a linebreak',
                                                         description='legend title (use "\\n" to create a linebreak):',
                                                         layout={'width': '70%'},
                                                         style={'description_width': 'initial'})
        self.customization.summary = w.VBox([self.customization.select_summary_hue_col,
                                             self.customization.set_summary_hue_order,
                                             self.customization.select_summary_palette_or_individual_color,
                                             w.HBox([self.customization.select_summary_color_palettes, self.customization.summary_group_colors_vbox], layout={'width': '70%'}),
                                             self.customization.summary_legend_title,
                                             w.HBox([self.customization.summary_save_plot, self.customization.summary_show_legend])],
                                             layout={'visibility': 'hidden'})

        self.customization.customization_accordion.children = [self.customization.annotations_accordion,
                                                               self.customization.axes_accordion,
                                                               self.customization.titles,
                                                               self.customization.other_features.widget,
                                                               self.customization.summary]

        self.customization.customization_accordion.set_title(2, 'Customize titles')
        self.customization.customization_accordion.set_title(3, 'Customize other features of the plot')
        self.customization.customization_accordion.set_title(4, 'Customize the summary plots')
        self.out = w.Output()

        self.widget = w.VBox([w.HBox([self.uploader, self.preview_button, self.process_all_button, self.show_summary_button], layout={'width': '60%'}),
                              self.customization.widget,
                              self.out])

        # Link buttons
        self.preview_button.on_click(self.on_preview_button_clicked)
        self.process_all_button.on_click(self.on_process_all_button_clicked)
        self.show_summary_button.on_click(self.on_show_summary_button_clicked)

    def on_preview_button_clicked(self, b):
        if len(list(self.uploader.value.keys())) > 0:
            # Read the data that was selected using the uploader:
            if list(self.uploader.value.keys())[0].endswith('.csv'):
                with open("input.csv", "w+b") as i:
                    i.write(self.uploader.value[list(self.uploader.value.keys())[0]]['content'])
                self.params['data']  = pd.read_csv('input.csv')

            elif list(self.uploader.value.keys())[0].endswith('.xlsx'):
                with open("input.xlsx", "w+b") as i:
                    i.write(self.uploader.value[list(self.uploader.value.keys())[0]]['content'])
                self.params['data']  = pd.read_excel('input.xlsx')

            self.params['data_col'] = self.params['data'].columns[0]
            self.params['cell_id_col'] = self.params['data'].columns[1]
            self.params['sweep_id_col'] = self.params['data'].columns[2]
            self.params['stim_id_col'] = self.params['data'].columns[3]
            self.params['voltage_id_col'] = self.params['data'].columns[4]
            self.params['measurement_id_col'] = self.params['data'].columns[5]
            self.params['stim_order'] = list(self.params['data'][self.params['stim_id_col']].unique())
            self.params['l_groups'] = self.params['stim_order']

            self.params['l_summary_hue_col_options'] = []
            for measurement_id in self.params['data'][self.params['measurement_id_col']].unique():
                for voltage_id in self.params['data'][self.params['voltage_id_col']].unique():
                    for stim_id in self.params['data'][self.params['stim_id_col']].unique():
                        self.params['data']['{}_{}_{}'.format(measurement_id, str(voltage_id), str(stim_id))] = 'n.a.'
                    self.params['data']['{}_{}_all'.format(measurement_id, str(voltage_id))] = 'n.a.'
                    self.params['l_summary_hue_col_options'].append('{}_{}_all'.format(measurement_id, str(voltage_id)))
            self.process_all_button.layout.visibility = 'visible'
            self.customization.widget.layout.visibility = 'visible'
            if len(self.customization.select_summary_hue_col.options) == 1:
                self.customization.select_summary_hue_col.options = self.params['l_summary_hue_col_options']
                self.customization.select_summary_hue_col.value = self.params['l_summary_hue_col_options'][0]
                self.params['hue_col'] = self.customization.select_summary_hue_col.value
                self.params['hue_groups'] = []

            if len(self.params['widgets']['group_colors_vbox']['children']) == 0:
                for group_id in self.params['l_groups']:
                    set_group_color = w.ColorPicker(concise = False, description = str(group_id), style = {'description': 'initial'})
                    self.params['widgets']['group_colors_vbox']['children'] = self.params['widgets']['group_colors_vbox']['children'] + (set_group_color, )

            if len(self.customization.other_features.group_colors_vbox.children) == 0:
                self.customization.other_features.group_colors_vbox.children = self.params['widgets']['group_colors_vbox']['children']
                self.customization.other_features.group_colors_vbox.layout.visibility = 'visible'


        else: # no file uploaded yet
            with self.out:
                print('Please upload a file first!')
                return

        self.get_updated_params()
        with self.out:
            self.out.clear_output()
            self.all_plots_one_cell(self.params['data'][self.params['cell_id_col']].unique()[0])


    def on_process_all_button_clicked(self, b):
        self.get_updated_params()
        with self.out:
            self.out.clear_output()
            self.params['save_plot'] = True
            for cell_id in self.params['data'][self.params['cell_id_col']].unique():
                self.all_plots_one_cell(cell_id)
                for measurement_id in self.params['data'][self.params['measurement_id_col']].unique():
                    for voltage_id in self.params['data'][self.params['voltage_id_col']].unique():
                        l_changes = []
                        for stim_id in self.params['data'][self.params['stim_id_col']].unique():
                            l_changes.append(self.params['data'].loc[self.params['data'][self.params['cell_id_col']] == cell_id,
                                                                     '{}_{}_{}'.format(measurement_id, str(voltage_id), str(stim_id))].unique()[0])

                        if all([True if elem == l_changes[0] else False for elem in l_changes]):
                            self.params['data'].loc[self.params['data'][self.params['cell_id_col']] == cell_id,
                                                    '{}_{}_all'.format(measurement_id, str(voltage_id))] = l_changes[0]


                print('Done with: {}'.format(cell_id))
            self.out.clear_output()
            print('All plots are done! :-)')
            self.params['save_plot'] = False
            if len(self.params['hue_groups']) == 0:
                self.params['hue_groups'] = list(self.params['data'][self.params['hue_col']].unique())
                for elem in self.params['hue_groups']:
                    if self.params['hue_groups'].index(elem) == 0:
                        l_hue_string = elem
                    else:
                        l_hue_string = l_hue_string + ', {}'.format(elem)
                self.customization.set_summary_hue_order.value = l_hue_string
                self.params['summary_group_colors_vbox_children'] = ()
                for hue_group_id in self.params['hue_groups']:
                    set_hue_group_color = w.ColorPicker(concise = False, description = str(hue_group_id), style = {'description': 'initial'})
                    self.params['summary_group_colors_vbox_children'] = self.params['summary_group_colors_vbox_children'] + (set_hue_group_color, )
                self.customization.summary_group_colors_vbox.children = self.params['summary_group_colors_vbox_children']
                self.customization.summary_legend_title.value = 'subgroups defined on\n{}'.format(self.customization.select_summary_hue_col.value)
            self.params['ready_for_summary'] = True
            self.customization.summary.layout.visibility = 'visible'
            self.show_summary_button.layout.visibility = 'visible'


    def on_show_summary_button_clicked(self, b):
        self.get_updated_params()
        with self.out:
            self.out.clear_output()
            self.summary_piecharts()

            l_dfs = []
            for cell_id in self.params['data'][self.params['cell_id_col']].unique():
                df_cell_id = self.params['data'].loc[self.params['data'][self.params['cell_id_col']] == cell_id].copy()

                d_means = {'mean': [],
                          self.params['cell_id_col']: [],
                          self.params['stim_id_col']: [],
                          self.params['voltage_id_col']: [],
                          self.params['measurement_id_col']: [],
                          self.params['hue_col']: []}

                for voltage_id in df_cell_id[self.params['voltage_id_col']].unique():
                    for measurement_id in df_cell_id.loc[df_cell_id[self.params['voltage_id_col']] == voltage_id, self.params['measurement_id_col']].unique():
                        for stim_id in df_cell_id.loc[(df_cell_id[self.params['voltage_id_col']] == voltage_id) &
                                                      (df_cell_id[self.params['measurement_id_col']] == measurement_id), self.params['stim_id_col']].unique():

                            d_means['mean'].append(df_cell_id.loc[(df_cell_id[self.params['stim_id_col']] == stim_id) &
                                                                  (df_cell_id[self.params['voltage_id_col']] == voltage_id) &
                                                                  (df_cell_id[self.params['measurement_id_col']] == measurement_id), self.params['data_col']].mean())
                            d_means[self.params['cell_id_col']].append(cell_id)
                            d_means[self.params['stim_id_col']].append(stim_id)
                            d_means[self.params['voltage_id_col']].append(voltage_id)
                            d_means[self.params['measurement_id_col']].append(measurement_id)
                            d_means[self.params['hue_col']].append(df_cell_id.loc[(df_cell_id[self.params['stim_id_col']] == stim_id) &
                                                                      (df_cell_id[self.params['voltage_id_col']] == voltage_id) &
                                                                      (df_cell_id[self.params['measurement_id_col']] == measurement_id),
                                                                      self.params['hue_col']].iloc[0])
                l_dfs.append(pd.DataFrame(data=d_means))
            summary_df = pd.concat(l_dfs, axis=0)

            self.summary_overview(summary_df)


            #display(summary_df.head(20))


    def get_updated_params(self):

        # Customization
        self.params['fig_width'] = self.customization.other_features.set_fig_width.value
        self.params['fig_height'] = self.customization.other_features.set_fig_height.value
        self.params['marker_size'] = self.customization.other_features.set_marker_size.value
        self.params['show_legend'] = self.customization.other_features.set_show_legend.value

        self.params['axes_linewidth'] = self.customization.both_axes.set_axes_linewidth.value
        self.params['axes_color'] = self.customization.both_axes.set_axes_color.value
        self.params['axes_tick_size'] = self.customization.both_axes.set_axes_tick_size.value

        self.params['yaxis_label_text_a'] = self.customization.yaxis.set_yaxis_label_text_measurement_a.value
        self.params['yaxis_label_text_b'] = self.customization.yaxis.set_yaxis_label_text_measurement_b.value
        self.params['yaxis_label_fontsize'] = self.customization.yaxis.set_yaxis_label_fontsize.value
        self.params['yaxis_label_color'] = self.customization.yaxis.set_yaxis_label_color.value
        self.params['yaxis_centered'] = self.customization.yaxis.set_yaxis_center.value
        self.params['yaxis_scaling_mode'] = self.customization.yaxis.set_yaxis_scaling_mode.value
        self.params['yaxis_lower_lim_value'] = self.customization.yaxis.set_yaxis_lower_lim.value
        self.params['yaxis_upper_lim_value'] = self.customization.yaxis.set_yaxis_upper_lim.value

        self.params['xaxis_label_color'] = self.customization.xaxis.set_xaxis_label_color.value
        self.params['xaxis_label_fontsize'] = self.customization.xaxis.set_xaxis_label_fontsize.value
        self.params['xaxis_label_text'] = self.customization.xaxis.set_xaxis_label_text.value

        self.params['subtitle_left_color'] = self.customization.set_subtitle_left_color.value
        self.params['subtitle_left_fontsize'] = self.customization.set_subtitle_left_fontsize.value
        self.params['subtitle_left_text'] = self.customization.set_subtitle_left_text.value
        self.params['subtitle_left_pad'] = self.customization.set_subtitle_left_pad.value

        self.params['subtitle_right_color'] = self.customization.set_subtitle_right_color.value
        self.params['subtitle_right_fontsize'] = self.customization.set_subtitle_right_fontsize.value
        self.params['subtitle_right_text'] = self.customization.set_subtitle_right_text.value
        self.params['subtitle_right_pad'] = self.customization.set_subtitle_left_pad.value

        self.params['title_color'] = self.customization.set_title_color.value
        self.params['title_fontsize'] = self.customization.set_title_fontsize.value
        self.params['title_text'] = self.customization.set_title_text.value
        self.params['title_pad'] = self.customization.set_subtitle_left_pad.value

        if self.params['ready_for_summary']:
            self.params['summary_save_plot'] = self.customization.summary_save_plot.value
            self.params['summary_legend_title'] = self.customization.summary_legend_title.value
            self.params['summary_show_legend'] = self.customization.summary_show_legend.value
            if self.params['hue_col'] != self.customization.select_summary_hue_col.value: #Basically check, whether a new hue_col was chosen
                self.params['hue_col'] = self.customization.select_summary_hue_col.value
                self.params['hue_groups'] = list(self.params['data'][self.params['hue_col']].unique())
                self.params['summary_group_colors_vbox_children'] = ()
                for hue_group_id in self.params['hue_groups']:
                    set_hue_group_color = w.ColorPicker(concise = False, description = str(hue_group_id), style = {'description': 'initial'})
                    self.params['summary_group_colors_vbox_children'] = self.params['summary_group_colors_vbox_children'] + (set_hue_group_color, )
                self.customization.summary_group_colors_vbox.children = self.params['summary_group_colors_vbox_children']
                for elem in self.params['hue_groups']:
                    if self.params['hue_groups'].index(elem) == 0:
                        l_hue_string = elem
                    else:
                        l_hue_string = l_hue_string + ', {}'.format(elem)
                self.customization.set_summary_hue_order.value = l_hue_string
                self.customization.summary_legend_title.value = 'subgroups defined on\n{}'.format(self.customization.select_summary_hue_col.value)

            l_hue_order = []
            l_hue_string = self.customization.set_summary_hue_order.value

            while ', ' in l_hue_string:
                l_hue_order.append(l_hue_string[:l_hue_string.index(', ')])
                l_hue_string = l_hue_string[l_hue_string.index(', ')+2:]

            l_hue_order.append(l_hue_string)
            self.params['hue_order'] = l_hue_order

            if self.customization.select_summary_palette_or_individual_color.value == 0:
                self.params['summary_color_palette'] = self.customization.select_summary_color_palettes.value
            else:
                summary_color_palette = {}
                for hue_id in self.params['hue_groups']:
                    summary_color_palette[hue_id] = self.customization.summary_group_colors_vbox.children[self.params['hue_groups'].index(hue_id)].value
                self.params['summary_color_palette'] = summary_color_palette

        self.params['annotate_all'] = self.customization.select_annotations.set_annotate_all.value

        self.params['distance_stars_to_brackets'] = self.customization.customize_annotations.set_distance_stars_to_brackets.value
        self.params['distance_brackets_to_data'] = self.customization.customize_annotations.set_distance_brackets_to_data.value
        self.params['fontsize_stars'] = self.customization.customize_annotations.set_fontsize_stars.value
        self.params['linewidth_annotations'] = self.customization.customize_annotations.set_linewidth_annotations.value
        if self.customization.customize_annotations.select_bracket_no_bracket.value == 'brackets':
            self.params['annotation_brackets_factor'] = 1
        else:
            self.params['annotation_brackets_factor'] = 0
        if self.customization.customize_annotations.set_stars_fontweight_bold.value == True:
            self.params['fontweight_stars'] = 'bold'
        else:
            self.params['fontweight_stars'] = 'normal'

        if self.customization.other_features.select_palette_or_individual_color.value == 0:
            self.params['color_palette'] = self.customization.other_features.select_color_palettes.value
        else:
            color_palette = {}
            for group_id in self.params['l_groups']:
                color_palette[group_id] = self.customization.other_features.group_colors_vbox.children[self.params['l_groups'].index(group_id)].value
            self.params['color_palette'] = color_palette

        l_xlabel_order = []
        l_xlabel_string = self.customization.xaxis.set_xlabel_order.value
        while ', ' in l_xlabel_string:
            l_xlabel_order.append(l_xlabel_string[:l_xlabel_string.index(', ')])
            l_xlabel_string = l_xlabel_string[l_xlabel_string.index(', ')+2:]
        l_xlabel_order.append(l_xlabel_string)
        self.params['l_xlabel_order'] = l_xlabel_order

        l_hue_order = []
        l_hue_string = self.customization.xaxis.set_hue_order.value

        while ', ' in l_hue_string:
            l_hue_order.append(l_hue_string[:l_hue_string.index(', ')])
            l_hue_string = l_hue_string[l_hue_string.index(', ')+2:]

        l_hue_order.append(l_hue_string)
        self.params['l_hue_order'] = l_hue_order


    def all_plots_one_cell(self, cell_id):
        df, cell_id_col, voltage_id_col, measurement_id_col = self.params['data'], self.params['cell_id_col'], self.params['voltage_id_col'], self.params['measurement_id_col']

        fig = plt.figure(figsize=(self.params['fig_width']/2.54 , self.params['fig_height']/2.54), facecolor='white')
        gs = fig.add_gridspec(1,9)

        ax1 = fig.add_subplot(gs[0, 0:4])
        for axis in ['top', 'right', 'bottom', 'left']:
            ax1.spines[axis].set_visible(False)
        ax1.tick_params(labelleft=False, left=False, labelbottom=False, bottom=False)
        plt.title(self.params['subtitle_left_text'], fontsize=self.params['subtitle_left_fontsize'], color=self.params['subtitle_left_color'], pad=self.params['subtitle_left_pad'])

        ax2 = fig.add_subplot(gs[0, 5:])
        for axis in ['top', 'right', 'bottom', 'left']:
            ax2.spines[axis].set_visible(False)
        ax2.tick_params(labelleft=False, left=False, labelbottom=False, bottom=False)
        plt.title(self.params['subtitle_right_text'], fontsize=self.params['subtitle_right_fontsize'], color=self.params['subtitle_right_color'], pad=self.params['subtitle_right_pad'])

        gs_col = 0
        for voltage_id in df.loc[df[cell_id_col] == cell_id, voltage_id_col].unique():
            for measurement_id in df.loc[(df[cell_id_col] == cell_id) & (df[voltage_id_col] == voltage_id), measurement_id_col].unique():
                df_temp = df.loc[(df[cell_id_col] == cell_id)
                                 & (df[voltage_id_col] == voltage_id)
                                 & (df[measurement_id_col] == measurement_id)].copy()
                if df_temp[self.params['data_col']].shape[0] > 0:
                    self.individual_plot_with_stats(df_temp, cell_id, voltage_id, measurement_id, fig.add_subplot(gs[0, gs_col:gs_col+2]))
                gs_col = gs_col + 2
                if gs_col == 4:
                    gs_col = gs_col + 1

        fig.suptitle(cell_id, fontsize=self.params['title_fontsize'], color=self.params['title_color'])
        plt.tight_layout()
        if self.params['save_plot'] == True:
            if os.path.isdir('results') == False:
                os.mkdir('results')
            plt.savefig('results/' + cell_id + '.png', dpi=300)
            plt.close()
        else:
            plt.show()


    def individual_plot_with_stats(self, df_tmp, cell_id, voltage_id, measurement_id, ax):
        for axis in ['top', 'right']:
            ax.spines[axis].set_visible(False)

        for axis in ['bottom','left']:
            ax.spines[axis].set_linewidth(self.params['axes_linewidth'])
            ax.spines[axis].set_color(self.params['axes_color'])

        ax.tick_params(labelsize=self.params['axes_tick_size'], colors=self.params['axes_color'])

        data_col, stim_id_col = self.params['data_col'], self.params['stim_id_col']

        stim_id_count = 0
        d_stims = {'l_stim_ids': []}
        for stim_id in self.params['stim_order']:
            d_stims['stim_id_{}'.format(str(stim_id_count))] = {'data':  df_tmp.loc[df_tmp[stim_id_col] == stim_id].copy()}
            if d_stims['stim_id_{}'.format(str(stim_id_count))]['data'].shape[0] > 3:
                d_stims['l_stim_ids'].append('stim_id_{}'.format(str(stim_id_count)))
                d_stims['stim_id_{}'.format(str(stim_id_count))]['x_pos'] = self.params['stim_order'].index(stim_id)
                d_stims['stim_id_{}'.format(str(stim_id_count))]['stats'] = pg.wilcoxon(d_stims['stim_id_{}'.format(str(stim_id_count))]['data'][data_col].values,
                                                                                            correction = 'auto')
                d_stims['stim_id_{}'.format(str(stim_id_count))]['pval'] = d_stims['stim_id_{}'.format(str(stim_id_count))]['stats'].loc['Wilcoxon', 'p-val']
                d_stims['stim_id_{}'.format(str(stim_id_count))]['stars'] = self.get_stars(d_stims['stim_id_{}'.format(str(stim_id_count))]['pval'])

                if d_stims['stim_id_{}'.format(str(stim_id_count))]['pval'] <= 0.5:
                    if d_stims['stim_id_{}'.format(str(stim_id_count))]['data'][data_col].mean() > 0:
                        direction = 'increase'
                    elif d_stims['stim_id_{}'.format(str(stim_id_count))]['data'][data_col].mean() < 0:
                        direction = 'decrease'
                else:
                    direction = 'constant'
                self.params['data'].loc[self.params['data'][self.params['cell_id_col']] == cell_id, '{}_{}_{}'.format(measurement_id, str(voltage_id), str(stim_id))] = direction

            stim_id_count = stim_id_count + 1

        sns.stripplot(data = df_tmp, x = stim_id_col, y = data_col, order = self.params['stim_order'], palette = self.params['color_palette'], s=self.params['marker_size'])

        ylim_lower, ylim_upper = ax.get_ylim()

        if self.params['yaxis_centered'] == 1:
            if (ylim_lower < 0) & (ylim_upper > 0):
                abs_max = max(abs(ylim_lower), ylim_upper)
                ylim_lower = -abs_max
                ylim_upper = abs_max

            elif (ylim_lower >= 0):
                ylim_lower = -ylim_upper

            elif (ylim_upper <= 0):
                ylim_upper = abs(ylim_lower)

        y_axis_span = ylim_upper - ylim_lower
        y_stars = df_tmp[data_col].max() + y_axis_span*self.params['distance_brackets_to_data']
        ylim_upper_new = ylim_upper + y_axis_span*self.params['distance_brackets_to_data']*1.5


        for stim_id in d_stims['l_stim_ids']:
            plt.text(d_stims['l_stim_ids'].index(stim_id), y_stars, d_stims[stim_id]['stars'], ha='center', va='bottom', color='k',
                    fontsize=self.params['fontsize_stars'], fontweight=self.params['fontweight_stars'])

        xlim_lower, xlim_upper = ax.get_xlim()
        plt.hlines(0, xlim_lower, xlim_upper, colors='grey', linestyle='dashed')
        plt.ylim(ylim_lower, ylim_upper_new)

        if df_tmp[self.params['measurement_id_col']].unique()[0] == 'Frequency':
            ylabel = self.params['yaxis_label_text_a']
        else:
            ylabel = self.params['yaxis_label_text_b']


        ax.set_ylabel(ylabel, fontsize=self.params['yaxis_label_fontsize'], color=self.params['yaxis_label_color'])
        ax.set_xlabel(self.params['xaxis_label_text'], fontsize=self.params['xaxis_label_fontsize'], color=self.params['xaxis_label_color'])

        if self.params['yaxis_scaling_mode'] in [1, 'manual']: #1 for GUI, manual for API
            ax.set_ylim(self.params['yaxis_lower_lim_value'], self.params['yaxis_upper_lim_value'])

    def get_stars(self, p):
        if p <= 0.001:
            s = '***'
        elif p <= 0.01:
            s = '**'
        elif p <= 0.05:
            s = '*'
        else:
            s = 'n.s.'
        return s

    def summary_piecharts(self):
        df, cell_id_col, voltage_id_col, measurement_id_col, stim_id_col = self.params['data'], self.params['cell_id_col'], self.params['voltage_id_col'], self.params['measurement_id_col'], self.params['stim_id_col']

        fig = plt.figure(figsize=(self.params['fig_width']*1.5/2.54 , self.params['fig_height']*0.8/2.54), facecolor='white')
        gs = fig.add_gridspec(1,9)

        ax1 = fig.add_subplot(gs[0, 0:4])
        for axis in ['top', 'right', 'bottom', 'left']:
            ax1.spines[axis].set_visible(False)
        ax1.tick_params(labelleft=False, left=False, labelbottom=False, bottom=False)
        plt.title(self.params['subtitle_left_text'], fontsize=self.params['subtitle_left_fontsize'], color=self.params['subtitle_left_color'], pad=self.params['subtitle_left_pad'])

        ax2 = fig.add_subplot(gs[0, 5:])
        for axis in ['top', 'right', 'bottom', 'left']:
            ax2.spines[axis].set_visible(False)
        ax2.tick_params(labelleft=False, left=False, labelbottom=False, bottom=False)
        plt.title(self.params['subtitle_right_text'], fontsize=self.params['subtitle_right_fontsize'], color=self.params['subtitle_right_color'], pad=self.params['subtitle_right_pad'])

        gs_col = 0
        l_change_ids = ['increase', 'decrease', 'constant / mixed / n.a.']
        for voltage_id in df[voltage_id_col].unique():
            for measurement_id in df[measurement_id_col].unique():
                l_cell_counts = []
                for change_id in l_change_ids:
                    if change_id == 'constant / mixed / n.a.':
                        l_cell_counts.append(len(df.loc[(df[voltage_id_col] == voltage_id) &
                                                        (df[measurement_id_col] == measurement_id) &
                                                        (df['{}_{}_all'.format(measurement_id, str(voltage_id))].isin(['constant', 'n.a.'])), cell_id_col].unique()))
                    else:
                        l_cell_counts.append(len(df.loc[(df[voltage_id_col] == voltage_id) &
                                                        (df[measurement_id_col] == measurement_id) &
                                                        (df['{}_{}_all'.format(measurement_id, str(voltage_id))] == change_id), cell_id_col].unique()))
                fig.add_subplot(gs[0, gs_col:gs_col+2])

                self.params['hue_order']

                if self.customization.select_summary_palette_or_individual_color.value == 0:
                    colors = sns.color_palette(self.params['summary_color_palette'])[0:len(l_change_ids)]
                else:
                    colors = []
                    for change_id in l_change_ids:
                        if change_id == 'constant / mixed / n.a.':
                            if 'n.a.' in self.params['summary_color_palette'].keys():
                                colors.append(self.params['summary_color_palette']['n.a.'])
                            elif 'constant' in self.params['summary_color_palette'].keys():
                                colors.append(self.params['summary_color_palette']['constant'])
                        else:
                            colors.append(self.params['summary_color_palette'][change_id])

                plt.pie(l_cell_counts, labels=l_change_ids, colors = colors, autopct='%.0f%%', textprops={'fontsize': self.params['axes_tick_size'],
                                                                                                          'color': self.params['axes_color']})
                if gs_col < 4:
                    plt.title(measurement_id, fontsize=self.params['subtitle_left_fontsize']-1, color=self.params['subtitle_left_color'], pad=self.params['subtitle_left_pad'])
                else:
                    plt.title(measurement_id, fontsize=self.params['subtitle_right_fontsize']-1, color=self.params['subtitle_right_color'], pad=self.params['subtitle_right_pad'])

                gs_col = gs_col + 2
                if gs_col == 4:
                    gs_col = gs_col + 1
        plt.tight_layout()
        if self.params['summary_save_plot'] == True:
            if os.path.isdir('results') == False:
                os.mkdir('results')
            plt.savefig('results/summary_pie_charts.png', dpi=300)
            plt.close()
        else:
            plt.show()
        plt.show()



    def summary_overview(self, df_summary):
        cell_id_col, voltage_id_col, measurement_id_col, hue_col = self.params['cell_id_col'], self.params['voltage_id_col'], self.params['measurement_id_col'], self.params['hue_col']

        fig = plt.figure(figsize=(self.params['fig_width']/2.54 , self.params['fig_height']/2.54), facecolor='white')
        gs = fig.add_gridspec(1,9)

        ax1 = fig.add_subplot(gs[0, 0:4])
        for axis in ['top', 'right', 'bottom', 'left']:
            ax1.spines[axis].set_visible(False)
        ax1.tick_params(labelleft=False, left=False, labelbottom=False, bottom=False)
        plt.title(self.params['subtitle_left_text'], fontsize=self.params['subtitle_left_fontsize'], color=self.params['subtitle_left_color'], pad=self.params['subtitle_left_pad'])

        ax2 = fig.add_subplot(gs[0, 5:])
        for axis in ['top', 'right', 'bottom', 'left']:
            ax2.spines[axis].set_visible(False)
        ax2.tick_params(labelleft=False, left=False, labelbottom=False, bottom=False)
        plt.title(self.params['subtitle_right_text'], fontsize=self.params['subtitle_right_fontsize'], color=self.params['subtitle_right_color'], pad=self.params['subtitle_right_pad'])

        gs_col = 0
        for voltage_id in df_summary[voltage_id_col].unique():
            for measurement_id in df_summary[measurement_id_col].unique():
                df_temp = df_summary.loc[(df_summary[voltage_id_col] == voltage_id) &
                                         (df_summary[measurement_id_col] == measurement_id)].copy()
                self.individual_plots_summary(df_temp, voltage_id, measurement_id, fig.add_subplot(gs[0, gs_col:gs_col+2]), gs_col)
                gs_col = gs_col + 2
                if gs_col == 4:
                    gs_col = gs_col + 1

        fig.suptitle('summary', fontsize=self.params['title_fontsize'], color=self.params['title_color'])
        plt.tight_layout()
        if self.params['summary_save_plot'] == True:
            if os.path.isdir('results') == False:
                os.mkdir('results')
            plt.savefig('results/summary_mean_per_cell_with_hue_col_{}.png'.format(self.params['hue_col']), dpi=300)
            plt.close()
        else:
            plt.show()


    def individual_plots_summary(self, df_tmp, voltage_id, measurement_id, ax, gs_col):
        for axis in ['top', 'right']:
            ax.spines[axis].set_visible(False)

        for axis in ['bottom','left']:
            ax.spines[axis].set_linewidth(self.params['axes_linewidth'])
            ax.spines[axis].set_color(self.params['axes_color'])

        ax.tick_params(labelsize=self.params['axes_tick_size'], colors=self.params['axes_color'])

        data_col, stim_id_col = 'mean', self.params['stim_id_col']

        sns.stripplot(data = df_tmp, x = stim_id_col, y = data_col, order = self.params['stim_order'], hue = self.params['hue_col'],
                      hue_order = self.params['hue_order'],
                      palette = self.params['summary_color_palette'], s=self.params['marker_size'])


        if (self.params['summary_show_legend'] == True) & (gs_col == 7):
            ax.legend(title = self.params['summary_legend_title'], fontsize=self.params['axes_tick_size'], loc='center left', bbox_to_anchor=(1, 0.5), frameon=False)
        else:
            ax.get_legend().remove()

        ylim_lower, ylim_upper = ax.get_ylim()

        if self.params['yaxis_centered'] == 1:
            if (ylim_lower < 0) & (ylim_upper > 0):
                abs_max = max(abs(ylim_lower), ylim_upper)
                ylim_lower = -abs_max
                ylim_upper = abs_max

            elif (ylim_lower >= 0):
                ylim_lower = -ylim_upper

            elif (ylim_upper <= 0):
                ylim_upper = abs(ylim_lower)

        xlim_lower, xlim_upper = ax.get_xlim()
        plt.hlines(0, xlim_lower, xlim_upper, colors='grey', linestyle='dashed')
        plt.ylim(ylim_lower, ylim_upper)

        if df_tmp[self.params['measurement_id_col']].unique()[0] == 'Frequency':
            ylabel = self.params['yaxis_label_text_a']
        else:
            ylabel = self.params['yaxis_label_text_b']

        ax.set_ylabel(ylabel, fontsize=self.params['yaxis_label_fontsize'], color=self.params['yaxis_label_color'])
        ax.set_xlabel(self.params['xaxis_label_text'], fontsize=self.params['xaxis_label_fontsize'], color=self.params['xaxis_label_color'])

        if self.params['yaxis_scaling_mode'] in [1, 'manual']: #1 for GUI, manual for API
            ax.set_ylim(self.params['yaxis_lower_lim_value'], self.params['yaxis_upper_lim_value'])

# Cell
def launch():
    display(Dashboards().widget)
