<p align="center">
  <h1 align="center">BotCity Maestro SDK - Python</h1>

  <p align="center">
    <strong>« Explore Framework <a href="https://botcity-dev.github.io/botcity-maestro-sdk-python/">docs</a> »</strong>
  </p>
</p>

<br>

## Summary  <!-- omit in toc -->

- [🤖 Computer-vision based UI Automation](#-computer-vision-based-ui-automation)
- [🐍 Generate Python Code while Interacting with your UI](#-generate-python-code-while-interacting-with-your-ui)
- [🚀 Getting Started](#-getting-started)
  - [📦 Prerequisites](#-prerequisites)
  - [💫 Installing](#-installing)
  - [⭐ Orchestrating with BotCity Maestro](#-orchestrating-with-botcity-maestro)
- [📚 Documentation](#-documentation)
- [💻 Developers Portal](#-developers-portal)
- [💬 Forum](#-forum)
- [🌎 BotCity Automation Platform](#-botcity-automation-platform)
  - [1️⃣  All in One Platform](#1️⃣--all-in-one-platform)
  - [2️⃣  Deploy with a Single Line](#2️⃣--deploy-with-a-single-line)
  - [3️⃣  Manage your Task Queue](#3️⃣--manage-your-task-queue)
  - [4️⃣  Manage your Runtime Environments](#4️⃣--manage-your-runtime-environments)
  - [5️⃣  Create Alerts and Reports from the Automation Execution](#5️⃣--create-alerts-and-reports-from-the-automation-execution)
  - [6️⃣  Create Google Data Studio Dashboards](#6️⃣--create-google-data-studio-dashboards)
  - [7️⃣  Create your Community Account](#7️⃣--create-your-community-account)
- [🤝 Contributing to BotCity Framework](#-contributing-to-botcity-framework)
- [⛑ Support](#-support)
  - [🐛 Bug reports and 💎 Feature requests](#-bug-reports-and--feature-requests)
  - [📢 Contact us](#-contact-us)
- [💡 Related Projects](#-related-projects)


## 🤖 Computer-vision based UI Automation

Recognize and interact with UI elements using state-of-art computer vision module.

Operate any UI interface independent of the technology or platform (desktop, web, terminal).

## 🐍 Generate Python Code while Interacting with your UI

Use our Development Tool alongside your favorite IDE to select UI components and generate python code.

[![BotCity Studio](https://developers.botcity.dev/github/readme/studio/studio.gif)](https://botcity.atlassian.net/l/c/eBJ6bLLV)

[SIGN UP](https://developers.botcity.dev/app/signup) and download our tools.


## 🚀 Getting Started

### 📦 Prerequisites
* Python 3.7+
* requests

### 💫 Installing

```bash
pip install botcity-maestro-sdk
```

### ⭐ Orchestrating with BotCity Maestro

[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/botcity-dev/botcity-maestro-sdk-python/HEAD?filepath=examples%2Fmaestro-sdk-demo.ipynb)

Explore the Maestro SDK now without installing anything. [Click Here to Start.](https://mybinder.org/v2/gh/botcity-dev/botcity-maestro-sdk-python/HEAD?filepath=examples%2Fmaestro-sdk-demo.ipynb) 


## 📚 Documentation

Documentation is available at https://botcity-dev.github.io/botcity-maestro-sdk-python.

## 💻 Developers Portal

[![Developers Portal](https://developers.botcity.dev/github/readme/portal.png)](https://botcity.atlassian.net/l/c/boMU4TX9)

## 💬 Forum

[![Forum](https://developers.botcity.dev/github/readme/forum.png)](https://community.botcity.dev/)

## 🌎 BotCity Automation Platform
BotCity is a platform to develop, deploy, manage and maintain automations. Automations can be developed in Python or Java using open-source libraries that are market standard.

### 1️⃣  All in One Platform
Develop, deploy, manage and scale your Automation Ops using All in One platform that provides task queue, runtime environment management, reports, alerts, logs and much more.

[![BotCity Maestro](https://developers.botcity.dev/github/readme/maestro/maestro.png)](https://botcity.atlassian.net/l/c/WWGswYRX)

### 2️⃣  Deploy with a Single Line

Use BotCity command-line interface (CLI) to deploy your bot into a runtime environment with a single line:

[![BotCity CLI](https://developers.botcity.dev/github/readme/cli/botcli.gif)](https://botcity.atlassian.net/l/c/hJHE1ZFv)

### 3️⃣  Manage your Task Queue

[![BotCity Maestro Task Queue](https://developers.botcity.dev/github/readme/maestro/tasks.png)](https://botcity.atlassian.net/l/c/gR3AAd2a)

### 4️⃣  Manage your Runtime Environments

[![BotCity Maestro Machines](https://developers.botcity.dev/github/readme/maestro/machines.png)](https://botcity.atlassian.net/l/c/uDB087nK)

### 5️⃣  Create Alerts and Reports from the Automation Execution

[![BotCity Maestro Alerts](https://developers.botcity.dev/github/readme/maestro/alerts.png)](https://botcity.atlassian.net/l/c/McH09qYw)

### 6️⃣  Create Google Data Studio Dashboards

[![BotCity Maestro Dashboards](https://developers.botcity.dev/github/readme/maestro/dashboard.png)](https://botcity.atlassian.net/l/c/Z1uMY1vX)

### 7️⃣  Create your Community Account

We have a community account for hobbyists and students. Just signup and start automating.

[![Sign Up](https://developers.botcity.dev/github/readme/signup.png)](https://developers.botcity.dev/app/signup)


## 🤝 Contributing to BotCity Framework

- [Guidelines](https://github.com/botcity-dev/botcity-maestro-sdk-python/blob/main/.github/CONTRIBUTING.md)
- [Documentation](https://botcity-dev.github.io/botcity-maestro-sdk-python)

## ⛑ Support

### 🐛 Bug reports and 💎 Feature requests

If you spot a problem, please let us know by following the template in
here: [Report a bug](https://github.com/botcity-dev/botcity-maestro-sdk-python/issues/new?template=bug-report.md).

Ideas or suggestions for enhancements are more than welcome. Please use the following
template in here: [Request feature](https://github.com/botcity-dev/botcity-maestro-sdk-python/issues/new?template=feature-request.md&labels=request).

### 📢 Contact us

If you have questions or comments in general about the framework, we want to know.

You can choose between the channels the one that best fit you:

- [BotCity Community](<https://community.botcity.dev>) (Public)

or you can [file a bug](https://github.com/botcity-dev/botcity-maestro-sdk-python/issues/new?template=bug-report.md) and let us know where our documentation could be improved.

## 💡 Related Projects

<a href="https://github.com/botcity-dev/botcity-framework-core-python">
  <img align="center" src="https://github-readme-stats.vercel.app/api/pin/?username=botcity-dev&repo=botcity-framework-core-python" />
</a>
<a href="https://github.com/botcity-dev/botcity-framework-web-python">
  <img align="center" src="https://github-readme-stats.vercel.app/api/pin/?username=botcity-dev&repo=botcity-framework-web-python" />
</a>