import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Construct } from 'constructs';
/**
 * Properties for EmrSetClusterTerminationProtection.
 *
 * @stability stable
 */
export interface EmrSetClusterTerminationProtectionProps extends sfn.TaskStateBaseProps {
    /**
     * The ClusterId to update.
     *
     * @stability stable
     */
    readonly clusterId: string;
    /**
     * Termination protection indicator.
     *
     * @stability stable
     */
    readonly terminationProtected: boolean;
}
/**
 * A Step Functions Task to to set Termination Protection on an EMR Cluster.
 *
 * @stability stable
 */
export declare class EmrSetClusterTerminationProtection extends sfn.TaskStateBase {
    private readonly props;
    /**
     * @stability stable
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    /**
     * @stability stable
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: EmrSetClusterTerminationProtectionProps);
    /**
     * @internal
     */
    protected _renderTask(): any;
}
