# -*- coding: utf-8 -*-
# Generated by Django 1.11.15 on 2018-09-19 06:34
from __future__ import unicode_literals

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion

from django_webix_sender.settings import CONF


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = []

    if any(_recipients['model'] == 'django_webix_sender.Customer' for _recipients in CONF['recipients']):
        operations.append(migrations.CreateModel(
            name='Customer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=255, null=True, verbose_name='Name')),
                ('vat_number', models.CharField(blank=True, max_length=255, null=True, verbose_name='Vat number')),
                ('fiscal_code', models.CharField(blank=True, max_length=32, null=True, verbose_name='Fiscal code')),
                ('sms', models.CharField(blank=True, max_length=32, null=True, verbose_name='Sms')),
                ('email', models.EmailField(blank=True, max_length=255, null=True, verbose_name='Email')),
                ('note', models.TextField(blank=True, null=True, verbose_name='Note')),
                ('extra', django.contrib.postgres.fields.jsonb.JSONField(blank=True, null=True, verbose_name='Extra')),
            ],
            options={
                'verbose_name': 'Customer',
                'verbose_name_plural': 'Customers',
            },
        ))
        operations.append(migrations.CreateModel(
            name='CustomerTypology',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('typology', models.CharField(max_length=255, unique=True, verbose_name='Typology')),
            ],
            options={
                'verbose_name': 'Customer typology',
                'verbose_name_plural': 'Customer typologies',
            },
        ))

    if any(_recipients['model'] == 'django_webix_sender.ExternalSubject' for _recipients in CONF['recipients']):
        operations.append(migrations.CreateModel(
            name='ExternalSubject',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=255, null=True, verbose_name='Name')),
                ('vat_number', models.CharField(blank=True, max_length=255, null=True, verbose_name='Vat number')),
                ('fiscal_code', models.CharField(blank=True, max_length=32, null=True, verbose_name='Fiscal code')),
                ('sms', models.CharField(blank=True, max_length=32, null=True, verbose_name='Sms')),
                ('email', models.EmailField(blank=True, max_length=255, null=True, verbose_name='Email')),
                ('note', models.TextField(blank=True, null=True, verbose_name='Note')),
                ('extra', django.contrib.postgres.fields.jsonb.JSONField(blank=True, null=True, verbose_name='Extra')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'verbose_name': 'External subject',
                'verbose_name_plural': 'External subjects',
            },
        ))
        operations.append(migrations.CreateModel(
            name='ExternalSubjectTypology',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('typology', models.CharField(max_length=255, unique=True, verbose_name='Typology')),
            ],
            options={
                'verbose_name': 'External subject typology',
                'verbose_name_plural': 'External subject typologies',
            },
        ))

    if CONF['attachments']['model'] == 'django_webix_sender.MessageAttachment':
        operations.append(migrations.CreateModel(
            name='MessageAttachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file', models.FileField(upload_to=CONF['attachments']['upload_folder'], verbose_name='Document')),
                ('insert_date', models.DateTimeField(auto_now_add=True, verbose_name='Insert date')),
            ],
            options={
                'verbose_name': 'Attachment',
                'verbose_name_plural': 'Attachments',
            },
        ))

    operations.append(migrations.CreateModel(
        name='MessageRecipient',
        fields=[
            ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ('object_id', models.PositiveIntegerField()),
            ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
        ],
        options={
            'verbose_name': 'Recipient',
            'verbose_name_plural': 'Recipients',
        },
    ))

    operations.append(migrations.CreateModel(
        name='MessageSent',
        fields=[
            ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ('send_method', models.CharField(max_length=255, verbose_name='Send method')),
            ('subject', models.TextField(blank=True, null=True, verbose_name='Subject')),
            ('body', models.TextField(blank=True, null=True, verbose_name='Body')),
            ('extra', django.contrib.postgres.fields.jsonb.JSONField(blank=True, null=True, verbose_name='Extra')),
            ('attachments', models.ManyToManyField(blank=True, db_constraint=False, to=CONF['attachments']['model'], verbose_name='Attachments')),
        ],
        options={
            'verbose_name': 'Sent message',
            'verbose_name_plural': 'Sent messages',
        },
    ))

    if CONF['typology_model']['enabled']:
        operations.append(migrations.CreateModel(
            name='MessageTypology',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('typology', models.CharField(max_length=255, unique=True, verbose_name='Typology')),
            ],
            options={
                'verbose_name': 'Message typology',
                'verbose_name_plural': 'Message typologies',
            },
        ))

    if CONF['typology_model']['enabled']:
        operations.append(migrations.AddField(
            model_name='messagesent',
            name='typology',
            field=models.ForeignKey(blank=not CONF['typology_model']['required'], null=not CONF['typology_model']['required'], on_delete=django.db.models.deletion.CASCADE, to='django_webix_sender.MessageTypology', verbose_name='Typology'),
        ))

    operations.append(migrations.AddField(
        model_name='messagerecipient',
        name='message_sent',
        field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_webix_sender.MessageSent', verbose_name='Message sent'),
    ))

    if any(_recipients['model'] == 'django_webix_sender.Customer' for _recipients in CONF['recipients']):
        operations.append(migrations.AddField(
            model_name='customer',
            name='typology',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='django_webix_sender.CustomerTypology', verbose_name='Typology'),
        ))
        operations.append(migrations.AddField(
            model_name='customer',
            name='user',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User'),
        ))

    if any(_recipients['model'] == 'django_webix_sender.ExternalSubject' for _recipients in CONF['recipients']):
        operations.append(migrations.AddField(
            model_name='externalsubject',
            name='typology',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='django_webix_sender.ExternalSubjectTypology', verbose_name='Typology'),
        ))
