"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StaticRunnerImage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codebuild_1 = require("./codebuild");
const codebuild_2 = require("../codebuild");
const common_1 = require("../common");
/**
 * Helper class with methods to use static images that are built outside the context of this project.
 */
class StaticRunnerImage {
    /**
     * Create a builder (that doesn't actually build anything) from an existing image in an existing repository. The image must already have GitHub Actions runner installed. You are responsible to update it and remove it when done.
     *
     * @param repository ECR repository
     * @param tag image tag
     * @param architecture image architecture
     * @param os image OS
     */
    static fromEcrRepository(repository, tag = 'latest', architecture = common_1.Architecture.X86_64, os = common_1.Os.LINUX) {
        return {
            bind() {
                return {
                    imageRepository: repository,
                    imageTag: tag,
                    architecture,
                    os,
                    runnerVersion: common_1.RunnerVersion.latest(),
                };
            },
        };
    }
    /**
     * Create a builder from an existing Docker Hub image. The image must already have GitHub Actions runner installed. You are responsible to update it and remove it when done.
     *
     * We create a CodeBuild image builder behind the scenes to copy the image over to ECR. This helps avoid Docker Hub rate limits and prevent failures.
     *
     * @param scope
     * @param id
     * @param image Docker Hub image with optional tag
     * @param architecture image architecture
     * @param os image OS
     */
    static fromDockerHub(scope, id, image, architecture = common_1.Architecture.X86_64, os = common_1.Os.LINUX) {
        const builder = new codebuild_1.CodeBuildImageBuilder(scope, id, {
            dockerfilePath: codebuild_2.CodeBuildRunnerProvider.LINUX_X64_DOCKERFILE_PATH,
            architecture,
            os,
        });
        builder.addPreBuildCommand(`echo "FROM ${image}" > Dockerfile`);
        return builder;
    }
}
exports.StaticRunnerImage = StaticRunnerImage;
_a = JSII_RTTI_SYMBOL_1;
StaticRunnerImage[_a] = { fqn: "@cloudsnorkel/cdk-github-runners.StaticRunnerImage", version: "0.8.2" };
//# sourceMappingURL=data:application/json;base64,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