"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
/* eslint-disable import/no-extraneous-dependencies */
const AWS = require("aws-sdk");
const semver_1 = require("semver");
const helpers_1 = require("./helpers");
const ib = new AWS.Imagebuilder();
/* eslint-disable @typescript-eslint/no-require-imports, import/no-extraneous-dependencies */
async function handler(event, context) {
    console.log(JSON.stringify({ ...event, ResponseURL: '...' }));
    try {
        const objectType = event.ResourceProperties.ObjectType;
        const objectName = event.ResourceProperties.ObjectName;
        switch (event.RequestType) {
            case 'Create':
            case 'Update':
                let version = '1.0.0';
                let allVersions = [];
                try {
                    switch (objectType) {
                        case 'Component': {
                            const result = await ib.listComponents({
                                filters: [{
                                        name: 'name',
                                        values: [objectName],
                                    }],
                            }).promise();
                            allVersions = result.componentVersionList.map(i => i.version || '1.0.0');
                            break;
                        }
                        case 'ImageRecipe': {
                            const result = await ib.listImageRecipes({
                                filters: [{
                                        name: 'name',
                                        values: [objectName],
                                    }],
                            }).promise();
                            allVersions = result.imageRecipeSummaryList.map(i => i.arn?.split('/').pop() || '1.0.0');
                            break;
                        }
                        case 'ContainerRecipe': {
                            const result = await ib.listContainerRecipes({
                                filters: [{
                                        name: 'name',
                                        values: [objectName],
                                    }],
                            }).promise();
                            allVersions = result.containerRecipeSummaryList.map(i => i.arn?.split('/').pop() || '1.0.0');
                            break;
                        }
                    }
                }
                catch (e) {
                    if (e.code !== 'ResourceNotFoundException') {
                        throw e;
                    }
                }
                version = semver_1.maxSatisfying(allVersions, '>=0.0.0');
                if (version === null) {
                    version = '1.0.0';
                }
                version = semver_1.inc(version, 'patch');
                if (version === null) {
                    throw new Error('Unable to bump version');
                }
                await helpers_1.customResourceRespond(event, 'SUCCESS', 'OK', version, {});
                break;
            case 'Delete':
                await helpers_1.customResourceRespond(event, 'SUCCESS', 'OK', event.PhysicalResourceId, {});
                break;
        }
    }
    catch (e) {
        console.log(e);
        await helpers_1.customResourceRespond(event, 'FAILED', e.message || 'Internal Error', context.logStreamName, {});
    }
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzLWltYWdlLWJ1aWxkZXItdmVyc2lvbmVyLmxhbWJkYS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9sYW1iZGFzL2F3cy1pbWFnZS1idWlsZGVyLXZlcnNpb25lci5sYW1iZGEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBRUEsc0RBQXNEO0FBQ3RELCtCQUErQjtBQUMvQixtQ0FBNEM7QUFDNUMsdUNBQWtEO0FBRWxELE1BQU0sRUFBRSxHQUFHLElBQUksR0FBRyxDQUFDLFlBQVksRUFBRSxDQUFDO0FBRWxDLDZGQUE2RjtBQUN0RixLQUFLLFVBQVUsT0FBTyxDQUFDLEtBQWtELEVBQUUsT0FBMEI7SUFDMUcsT0FBTyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLEVBQUUsR0FBRyxLQUFLLEVBQUUsV0FBVyxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUMsQ0FBQztJQUU5RCxJQUFJO1FBQ0YsTUFBTSxVQUFVLEdBQUcsS0FBSyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQztRQUN2RCxNQUFNLFVBQVUsR0FBRyxLQUFLLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDO1FBRXZELFFBQVEsS0FBSyxDQUFDLFdBQVcsRUFBRTtZQUN6QixLQUFLLFFBQVEsQ0FBQztZQUNkLEtBQUssUUFBUTtnQkFDWCxJQUFJLE9BQU8sR0FBa0IsT0FBTyxDQUFDO2dCQUNyQyxJQUFJLFdBQVcsR0FBYSxFQUFFLENBQUM7Z0JBQy9CLElBQUk7b0JBQ0YsUUFBUSxVQUFVLEVBQUU7d0JBQ2xCLEtBQUssV0FBVyxDQUFDLENBQUM7NEJBQ2hCLE1BQU0sTUFBTSxHQUFHLE1BQU0sRUFBRSxDQUFDLGNBQWMsQ0FBQztnQ0FDckMsT0FBTyxFQUFFLENBQUM7d0NBQ1IsSUFBSSxFQUFFLE1BQU07d0NBQ1osTUFBTSxFQUFFLENBQUMsVUFBVSxDQUFDO3FDQUNyQixDQUFDOzZCQUNILENBQUMsQ0FBQyxPQUFPLEVBQUUsQ0FBQzs0QkFDYixXQUFXLEdBQUcsTUFBTSxDQUFDLG9CQUFxQixDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxPQUFPLElBQUksT0FBTyxDQUFDLENBQUM7NEJBQzFFLE1BQU07eUJBQ1A7d0JBQ0QsS0FBSyxhQUFhLENBQUMsQ0FBQzs0QkFDbEIsTUFBTSxNQUFNLEdBQUcsTUFBTSxFQUFFLENBQUMsZ0JBQWdCLENBQUM7Z0NBQ3ZDLE9BQU8sRUFBRSxDQUFDO3dDQUNSLElBQUksRUFBRSxNQUFNO3dDQUNaLE1BQU0sRUFBRSxDQUFDLFVBQVUsQ0FBQztxQ0FDckIsQ0FBQzs2QkFDSCxDQUFDLENBQUMsT0FBTyxFQUFFLENBQUM7NEJBQ2IsV0FBVyxHQUFHLE1BQU0sQ0FBQyxzQkFBdUIsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsR0FBRyxFQUFFLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxHQUFHLEVBQUUsSUFBSSxPQUFPLENBQUMsQ0FBQzs0QkFDMUYsTUFBTTt5QkFDUDt3QkFDRCxLQUFLLGlCQUFpQixDQUFDLENBQUM7NEJBQ3RCLE1BQU0sTUFBTSxHQUFHLE1BQU0sRUFBRSxDQUFDLG9CQUFvQixDQUFDO2dDQUMzQyxPQUFPLEVBQUUsQ0FBQzt3Q0FDUixJQUFJLEVBQUUsTUFBTTt3Q0FDWixNQUFNLEVBQUUsQ0FBQyxVQUFVLENBQUM7cUNBQ3JCLENBQUM7NkJBQ0gsQ0FBQyxDQUFDLE9BQU8sRUFBRSxDQUFDOzRCQUNiLFdBQVcsR0FBRyxNQUFNLENBQUMsMEJBQTJCLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEdBQUcsRUFBRSxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUMsR0FBRyxFQUFFLElBQUksT0FBTyxDQUFDLENBQUM7NEJBQzlGLE1BQU07eUJBQ1A7cUJBQ0Y7aUJBQ0Y7Z0JBQUMsT0FBTyxDQUFDLEVBQUU7b0JBQ1YsSUFBSyxDQUFTLENBQUMsSUFBSSxLQUFLLDJCQUEyQixFQUFFO3dCQUNuRCxNQUFNLENBQUMsQ0FBQztxQkFDVDtpQkFDRjtnQkFFRCxPQUFPLEdBQUcsc0JBQWEsQ0FBQyxXQUFXLEVBQUUsU0FBUyxDQUFDLENBQUM7Z0JBQ2hELElBQUksT0FBTyxLQUFLLElBQUksRUFBRTtvQkFDcEIsT0FBTyxHQUFHLE9BQU8sQ0FBQztpQkFDbkI7Z0JBQ0QsT0FBTyxHQUFHLFlBQUcsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7Z0JBQ2hDLElBQUksT0FBTyxLQUFLLElBQUksRUFBRTtvQkFDcEIsTUFBTSxJQUFJLEtBQUssQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDO2lCQUMzQztnQkFDRCxNQUFNLCtCQUFxQixDQUFDLEtBQUssRUFBRSxTQUFTLEVBQUUsSUFBSSxFQUFFLE9BQU8sRUFBRSxFQUFFLENBQUMsQ0FBQztnQkFFakUsTUFBTTtZQUNSLEtBQUssUUFBUTtnQkFDWCxNQUFNLCtCQUFxQixDQUFDLEtBQUssRUFBRSxTQUFTLEVBQUUsSUFBSSxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsRUFBRSxFQUFFLENBQUMsQ0FBQztnQkFDbEYsTUFBTTtTQUNUO0tBQ0Y7SUFBQyxPQUFPLENBQUMsRUFBRTtRQUNWLE9BQU8sQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDZixNQUFNLCtCQUFxQixDQUFDLEtBQUssRUFBRSxRQUFRLEVBQUcsQ0FBVyxDQUFDLE9BQU8sSUFBSSxnQkFBZ0IsRUFBRSxPQUFPLENBQUMsYUFBYSxFQUFFLEVBQUUsQ0FBQyxDQUFDO0tBQ25IO0FBQ0gsQ0FBQztBQXRFRCwwQkFzRUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKiBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgaW1wb3J0L25vLWV4dHJhbmVvdXMtZGVwZW5kZW5jaWVzLGltcG9ydC9uby11bnJlc29sdmVkICovXG5pbXBvcnQgKiBhcyBBV1NMYW1iZGEgZnJvbSAnYXdzLWxhbWJkYSc7XG4vKiBlc2xpbnQtZGlzYWJsZSBpbXBvcnQvbm8tZXh0cmFuZW91cy1kZXBlbmRlbmNpZXMgKi9cbmltcG9ydCAqIGFzIEFXUyBmcm9tICdhd3Mtc2RrJztcbmltcG9ydCB7IGluYywgbWF4U2F0aXNmeWluZyB9IGZyb20gJ3NlbXZlcic7XG5pbXBvcnQgeyBjdXN0b21SZXNvdXJjZVJlc3BvbmQgfSBmcm9tICcuL2hlbHBlcnMnO1xuXG5jb25zdCBpYiA9IG5ldyBBV1MuSW1hZ2VidWlsZGVyKCk7XG5cbi8qIGVzbGludC1kaXNhYmxlIEB0eXBlc2NyaXB0LWVzbGludC9uby1yZXF1aXJlLWltcG9ydHMsIGltcG9ydC9uby1leHRyYW5lb3VzLWRlcGVuZGVuY2llcyAqL1xuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIGhhbmRsZXIoZXZlbnQ6IEFXU0xhbWJkYS5DbG91ZEZvcm1hdGlvbkN1c3RvbVJlc291cmNlRXZlbnQsIGNvbnRleHQ6IEFXU0xhbWJkYS5Db250ZXh0KSB7XG4gIGNvbnNvbGUubG9nKEpTT04uc3RyaW5naWZ5KHsgLi4uZXZlbnQsIFJlc3BvbnNlVVJMOiAnLi4uJyB9KSk7XG5cbiAgdHJ5IHtcbiAgICBjb25zdCBvYmplY3RUeXBlID0gZXZlbnQuUmVzb3VyY2VQcm9wZXJ0aWVzLk9iamVjdFR5cGU7XG4gICAgY29uc3Qgb2JqZWN0TmFtZSA9IGV2ZW50LlJlc291cmNlUHJvcGVydGllcy5PYmplY3ROYW1lO1xuXG4gICAgc3dpdGNoIChldmVudC5SZXF1ZXN0VHlwZSkge1xuICAgICAgY2FzZSAnQ3JlYXRlJzpcbiAgICAgIGNhc2UgJ1VwZGF0ZSc6XG4gICAgICAgIGxldCB2ZXJzaW9uOiBzdHJpbmcgfCBudWxsID0gJzEuMC4wJztcbiAgICAgICAgbGV0IGFsbFZlcnNpb25zOiBzdHJpbmdbXSA9IFtdO1xuICAgICAgICB0cnkge1xuICAgICAgICAgIHN3aXRjaCAob2JqZWN0VHlwZSkge1xuICAgICAgICAgICAgY2FzZSAnQ29tcG9uZW50Jzoge1xuICAgICAgICAgICAgICBjb25zdCByZXN1bHQgPSBhd2FpdCBpYi5saXN0Q29tcG9uZW50cyh7XG4gICAgICAgICAgICAgICAgZmlsdGVyczogW3tcbiAgICAgICAgICAgICAgICAgIG5hbWU6ICduYW1lJyxcbiAgICAgICAgICAgICAgICAgIHZhbHVlczogW29iamVjdE5hbWVdLFxuICAgICAgICAgICAgICAgIH1dLFxuICAgICAgICAgICAgICB9KS5wcm9taXNlKCk7XG4gICAgICAgICAgICAgIGFsbFZlcnNpb25zID0gcmVzdWx0LmNvbXBvbmVudFZlcnNpb25MaXN0IS5tYXAoaSA9PiBpLnZlcnNpb24gfHwgJzEuMC4wJyk7XG4gICAgICAgICAgICAgIGJyZWFrO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgY2FzZSAnSW1hZ2VSZWNpcGUnOiB7XG4gICAgICAgICAgICAgIGNvbnN0IHJlc3VsdCA9IGF3YWl0IGliLmxpc3RJbWFnZVJlY2lwZXMoe1xuICAgICAgICAgICAgICAgIGZpbHRlcnM6IFt7XG4gICAgICAgICAgICAgICAgICBuYW1lOiAnbmFtZScsXG4gICAgICAgICAgICAgICAgICB2YWx1ZXM6IFtvYmplY3ROYW1lXSxcbiAgICAgICAgICAgICAgICB9XSxcbiAgICAgICAgICAgICAgfSkucHJvbWlzZSgpO1xuICAgICAgICAgICAgICBhbGxWZXJzaW9ucyA9IHJlc3VsdC5pbWFnZVJlY2lwZVN1bW1hcnlMaXN0IS5tYXAoaSA9PiBpLmFybj8uc3BsaXQoJy8nKS5wb3AoKSB8fCAnMS4wLjAnKTtcbiAgICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBjYXNlICdDb250YWluZXJSZWNpcGUnOiB7XG4gICAgICAgICAgICAgIGNvbnN0IHJlc3VsdCA9IGF3YWl0IGliLmxpc3RDb250YWluZXJSZWNpcGVzKHtcbiAgICAgICAgICAgICAgICBmaWx0ZXJzOiBbe1xuICAgICAgICAgICAgICAgICAgbmFtZTogJ25hbWUnLFxuICAgICAgICAgICAgICAgICAgdmFsdWVzOiBbb2JqZWN0TmFtZV0sXG4gICAgICAgICAgICAgICAgfV0sXG4gICAgICAgICAgICAgIH0pLnByb21pc2UoKTtcbiAgICAgICAgICAgICAgYWxsVmVyc2lvbnMgPSByZXN1bHQuY29udGFpbmVyUmVjaXBlU3VtbWFyeUxpc3QhLm1hcChpID0+IGkuYXJuPy5zcGxpdCgnLycpLnBvcCgpIHx8ICcxLjAuMCcpO1xuICAgICAgICAgICAgICBicmVhaztcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9XG4gICAgICAgIH0gY2F0Y2ggKGUpIHtcbiAgICAgICAgICBpZiAoKGUgYXMgYW55KS5jb2RlICE9PSAnUmVzb3VyY2VOb3RGb3VuZEV4Y2VwdGlvbicpIHtcbiAgICAgICAgICAgIHRocm93IGU7XG4gICAgICAgICAgfVxuICAgICAgICB9XG5cbiAgICAgICAgdmVyc2lvbiA9IG1heFNhdGlzZnlpbmcoYWxsVmVyc2lvbnMsICc+PTAuMC4wJyk7XG4gICAgICAgIGlmICh2ZXJzaW9uID09PSBudWxsKSB7XG4gICAgICAgICAgdmVyc2lvbiA9ICcxLjAuMCc7XG4gICAgICAgIH1cbiAgICAgICAgdmVyc2lvbiA9IGluYyh2ZXJzaW9uLCAncGF0Y2gnKTtcbiAgICAgICAgaWYgKHZlcnNpb24gPT09IG51bGwpIHtcbiAgICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ1VuYWJsZSB0byBidW1wIHZlcnNpb24nKTtcbiAgICAgICAgfVxuICAgICAgICBhd2FpdCBjdXN0b21SZXNvdXJjZVJlc3BvbmQoZXZlbnQsICdTVUNDRVNTJywgJ09LJywgdmVyc2lvbiwge30pO1xuXG4gICAgICAgIGJyZWFrO1xuICAgICAgY2FzZSAnRGVsZXRlJzpcbiAgICAgICAgYXdhaXQgY3VzdG9tUmVzb3VyY2VSZXNwb25kKGV2ZW50LCAnU1VDQ0VTUycsICdPSycsIGV2ZW50LlBoeXNpY2FsUmVzb3VyY2VJZCwge30pO1xuICAgICAgICBicmVhaztcbiAgICB9XG4gIH0gY2F0Y2ggKGUpIHtcbiAgICBjb25zb2xlLmxvZyhlKTtcbiAgICBhd2FpdCBjdXN0b21SZXNvdXJjZVJlc3BvbmQoZXZlbnQsICdGQUlMRUQnLCAoZSBhcyBFcnJvcikubWVzc2FnZSB8fCAnSW50ZXJuYWwgRXJyb3InLCBjb250ZXh0LmxvZ1N0cmVhbU5hbWUsIHt9KTtcbiAgfVxufVxuIl19