"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));

// src/lambdas/delete-ami.lambda.ts
var AWS2 = __toESM(require("aws-sdk"));

// src/lambdas/helpers.ts
var AWS = __toESM(require("aws-sdk"));
var sm = new AWS.SecretsManager();
async function customResourceRespond(event, responseStatus, reason, physicalResourceId, data) {
  const responseBody = JSON.stringify({
    Status: responseStatus,
    Reason: reason,
    PhysicalResourceId: physicalResourceId,
    StackId: event.StackId,
    RequestId: event.RequestId,
    LogicalResourceId: event.LogicalResourceId,
    NoEcho: false,
    Data: data
  });
  console.log("Responding", responseBody);
  const parsedUrl = require("url").parse(event.ResponseURL);
  const requestOptions = {
    hostname: parsedUrl.hostname,
    path: parsedUrl.path,
    method: "PUT",
    headers: {
      "content-type": "",
      "content-length": responseBody.length
    }
  };
  return new Promise((resolve, reject) => {
    try {
      const request = require("https").request(requestOptions, resolve);
      request.on("error", reject);
      request.write(responseBody);
      request.end();
    } catch (e) {
      reject(e);
    }
  });
}

// src/lambdas/delete-ami.lambda.ts
var ec2 = new AWS2.EC2();
async function deleteAmis(launchTemplateId, stackName, builderName, deleteAll) {
  var _a;
  const images = await ec2.describeImages({
    Owners: ["self"],
    Filters: [
      {
        Name: "tag:GitHubRunners:Stack",
        Values: [stackName]
      },
      {
        Name: "tag:GitHubRunners:Builder",
        Values: [builderName]
      }
    ]
  }).promise();
  let imagesToDelete = images.Images ?? [];
  console.log(`Found ${imagesToDelete.length} AMIs`);
  console.log(JSON.stringify(imagesToDelete.map((i) => i.ImageId)));
  if (!deleteAll) {
    const launchTemplates = await ec2.describeLaunchTemplateVersions({
      LaunchTemplateId: launchTemplateId,
      Versions: ["$Default"]
    }).promise();
    if (!launchTemplates.LaunchTemplateVersions) {
      console.error(`Unable to describe launch template ${launchTemplateId}`);
      return;
    }
    const launchTemplate = launchTemplates.LaunchTemplateVersions[0];
    imagesToDelete = imagesToDelete.filter((i) => {
      var _a2;
      return i.ImageId != ((_a2 = launchTemplate.LaunchTemplateData) == null ? void 0 : _a2.ImageId);
    });
    imagesToDelete = imagesToDelete.filter((i) => i.CreationDate && Date.parse(i.CreationDate) < Date.now() - 1e3 * 60 * 60 * 48);
    console.log(`${imagesToDelete.length} AMIs left after filtering by date and excluding AMI used by launch template`);
  }
  for (const image of imagesToDelete) {
    if (!image.ImageId) {
      console.warn(`No image id? ${JSON.stringify(image)}`);
      continue;
    }
    console.log(`Deregistering ${image.ImageId}`);
    await ec2.deregisterImage({
      ImageId: image.ImageId
    }).promise();
    for (const blockMapping of image.BlockDeviceMappings ?? []) {
      if ((_a = blockMapping.Ebs) == null ? void 0 : _a.SnapshotId) {
        console.log(`Deleting ${blockMapping.Ebs.SnapshotId}`);
        await ec2.deleteSnapshot({
          SnapshotId: blockMapping.Ebs.SnapshotId
        }).promise();
      }
    }
  }
}
exports.handler = async function(event, context) {
  try {
    console.log(JSON.stringify({ ...event, ResponseURL: "..." }));
    switch (event.RequestType) {
      case "Scheduled":
        await deleteAmis(event.LaunchTemplateId, event.StackName, event.BuilderName, false);
        return;
      case "Create":
      case "Update":
        await customResourceRespond(event, "SUCCESS", "OK", "DeleteAmis", {});
        break;
      case "Delete":
        await deleteAmis("", event.ResourceProperties.StackName, event.ResourceProperties.BuilderName, true);
        await customResourceRespond(event, "SUCCESS", "OK", event.PhysicalResourceId, {});
        break;
    }
  } catch (e) {
    console.error(e);
    if (event.RequestType != "Scheduled") {
      await customResourceRespond(event, "FAILED", e.message || "Internal Error", context.logStreamName, {});
    }
  }
};
