/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import java.util.List;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.nc2.units.SimpleUnit;

public class Geostationary
extends AbstractCoordTransBuilder {
    private static double defaultScaleFactor = -1.0;

    @Override
    public String getTransformName() {
        return "geostationary";
    }

    @Override
    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    private double checkMapCoordinateUnits(CoordinateAxis ca) {
        double scaleFactor = defaultScaleFactor;
        String neededMapCoordinateUnit = "radian";
        String mapCoordinateUnit = ca.getUnitsString();
        if (SimpleUnit.isCompatible(mapCoordinateUnit, neededMapCoordinateUnit)) {
            scaleFactor = SimpleUnit.getConversionFactor(mapCoordinateUnit, neededMapCoordinateUnit);
        }
        return scaleFactor;
    }

    @Override
    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        double flattening;
        this.readStandardParams(ds, ctv);
        double subLonDegrees = this.readAttributeDouble(ctv, "longitude_of_projection_origin", Double.NaN);
        if (Double.isNaN(subLonDegrees)) {
            throw new IllegalArgumentException("Must specify longitude_of_projection_origin");
        }
        double perspective_point_height = this.readAttributeDouble(ctv, "perspective_point_height", Double.NaN);
        if (Double.isNaN(perspective_point_height)) {
            throw new IllegalArgumentException("Must specify perspective_point_height");
        }
        double semi_major_axis = this.readAttributeDouble(ctv, "semi_major_axis", Double.NaN);
        if (Double.isNaN(semi_major_axis)) {
            throw new IllegalArgumentException("Must specify semi_major_axis");
        }
        double semi_minor_axis = this.readAttributeDouble(ctv, "semi_minor_axis", Double.NaN);
        double inv_flattening = this.readAttributeDouble(ctv, "inverse_flattening", Double.NaN);
        if (Double.isNaN(semi_minor_axis) && Double.isNaN(inv_flattening)) {
            throw new IllegalArgumentException("Must specify semi_minor_axis and/or inverse_flattening");
        }
        if (Double.isNaN(semi_minor_axis)) {
            flattening = 1.0 / inv_flattening;
            semi_minor_axis = semi_major_axis * (1.0 - flattening);
        } else if (Double.isNaN(inv_flattening)) {
            if (semi_minor_axis != semi_major_axis) {
                flattening = (semi_major_axis - semi_minor_axis) / semi_major_axis;
                inv_flattening = 1.0 / flattening;
            }
        } else assert (!Double.isNaN(semi_minor_axis) && !Double.isNaN(inv_flattening));
        String sweep_angle = this.readAttribute(ctv, "sweep_angle_axis", null);
        String fixed_angle = this.readAttribute(ctv, "fixed_angle_axis", null);
        if (sweep_angle == null && fixed_angle == null) {
            throw new IllegalArgumentException("Must specify sweep_angle_axis or fixed_angle_axis");
        }
        boolean isSweepX = sweep_angle != null ? sweep_angle.equals("x") : fixed_angle.equals("y");
        double xScaleFactor = defaultScaleFactor;
        double yScaleFactor = defaultScaleFactor;
        List<CoordinateAxis> cas = ds.getCoordinateAxes();
        for (CoordinateAxis ca : cas) {
            AxisType axisType = ca.getAxisType();
            if (axisType == null) continue;
            if (ca.getAxisType().equals((Object)AxisType.GeoX)) {
                xScaleFactor = this.checkMapCoordinateUnits(ca);
                continue;
            }
            if (!ca.getAxisType().equals((Object)AxisType.GeoY)) continue;
            yScaleFactor = this.checkMapCoordinateUnits(ca);
        }
        ucar.unidata.geoloc.projection.sat.Geostationary proj = new ucar.unidata.geoloc.projection.sat.Geostationary(subLonDegrees, perspective_point_height, semi_minor_axis, semi_major_axis, inv_flattening, isSweepX, xScaleFactor, yScaleFactor);
        return new ProjectionCT(ctv.getShortName(), "FGDC", proj);
    }
}

