/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.cataloggen.DatasetEnhancer1;
import thredds.cataloggen.config.CatalogRefInfo;
import thredds.cataloggen.config.DatasetFilter;
import thredds.cataloggen.config.DatasetNamer;
import thredds.cataloggen.config.DatasetSorter;
import thredds.cataloggen.config.DatasetSourceStructure;
import thredds.cataloggen.config.DatasetSourceType;
import thredds.cataloggen.config.DodsDirDatasetSource;
import thredds.cataloggen.config.DodsFileServerDatasetSource;
import thredds.cataloggen.config.GrADSDataServerDatasetSource;
import thredds.cataloggen.config.LocalDatasetSource;
import thredds.cataloggen.config.ResultService;

public abstract class DatasetSource {
    private static Logger logger = LoggerFactory.getLogger(DatasetSource.class);
    protected InvCatalog resultingCatalog;
    protected InvDataset accessPointDataset;
    protected List catalogRefInfoList = new ArrayList();
    private String name;
    protected DatasetSourceType type;
    private DatasetSourceStructure structure;
    private boolean flatten = false;
    private String accessPoint;
    private String prefixUrlPath;
    protected boolean createCatalogRefs = false;
    private ResultService resultService;
    protected List datasetNamerList = new ArrayList();
    protected List datasetFilterList = new ArrayList();
    protected DatasetSorter datasetSorter = null;
    protected List datasetEnhancerList = new ArrayList();
    protected boolean addDatasetSize;
    protected boolean isValid = true;
    protected StringBuffer msgLog = new StringBuffer();
    private volatile int hashCode = 0;

    protected DatasetSource() {
    }

    public static final DatasetSource newDatasetSource(String name, DatasetSourceType type, DatasetSourceStructure structure, String accessPoint, ResultService resultService) {
        if (type == null) {
            String tmpMsg = "DatasetSource type cannot be null";
            logger.error("newDatasetSource(): " + tmpMsg);
            throw new IllegalArgumentException(tmpMsg);
        }
        DatasetSource tmpDsSource = null;
        if (type == DatasetSourceType.getType("Local")) {
            tmpDsSource = new LocalDatasetSource();
        } else if (type == DatasetSourceType.getType("DodsDir")) {
            tmpDsSource = new DodsDirDatasetSource();
        } else if (type == DatasetSourceType.getType("DodsFileServer")) {
            tmpDsSource = new DodsFileServerDatasetSource();
        } else if (type == DatasetSourceType.getType("GrADSDataServer")) {
            tmpDsSource = new GrADSDataServerDatasetSource();
        } else {
            String tmpMsg = "Unsupported DatasetSource type <" + type.toString() + ">.";
            logger.error("newDatasetSource(): " + tmpMsg);
            throw new IllegalArgumentException(tmpMsg);
        }
        tmpDsSource.setName(name);
        tmpDsSource.setStructure(structure);
        tmpDsSource.setAccessPoint(accessPoint);
        tmpDsSource.setResultService(resultService);
        logger.debug("DatasetSource(): constructor done.");
        StringBuilder log = new StringBuilder();
        if (tmpDsSource.validate(log)) {
            logger.debug("DatasetSource(): new DatasetSource is valid: {}", (Object)log.toString());
        } else {
            logger.debug("DatasetSource(): new DatasetSource is invalid: {}", (Object)log.toString());
        }
        return tmpDsSource;
    }

    public InvCatalog getResultingCatalog() {
        return this.resultingCatalog;
    }

    public List getCatalogRefInfoList() {
        return this.catalogRefInfoList;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DatasetSourceType getType() {
        return this.type;
    }

    public DatasetSourceStructure getStructure() {
        return this.structure;
    }

    public void setStructure(DatasetSourceStructure structure) {
        this.structure = structure;
        this.flatten = this.structure == DatasetSourceStructure.FLAT;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public String getAccessPoint() {
        return this.accessPoint;
    }

    public void setAccessPoint(String accessPoint) {
        this.accessPoint = accessPoint;
    }

    public String getPrefixUrlPath() {
        return this.prefixUrlPath;
    }

    public void setPrefixUrlPath(String prefixUrlPath) {
        this.prefixUrlPath = prefixUrlPath;
    }

    public ResultService getResultService() {
        return this.resultService;
    }

    public void setResultService(ResultService resultService) {
        this.resultService = resultService;
    }

    public boolean isCreateCatalogRefs() {
        return this.createCatalogRefs;
    }

    public void setCreateCatalogRefs(boolean createCatalogRefs) {
        this.createCatalogRefs = createCatalogRefs;
    }

    public List getDatasetNamerList() {
        return this.datasetNamerList;
    }

    public void addDatasetNamer(DatasetNamer datasetNamer) {
        this.datasetNamerList.add(datasetNamer);
    }

    public List getDatasetFilterList() {
        return this.datasetFilterList;
    }

    public void addDatasetFilter(DatasetFilter datasetFilter) {
        this.datasetFilterList.add(datasetFilter);
    }

    public DatasetSorter getDatasetSorter() {
        return this.datasetSorter;
    }

    public void setDatasetSorter(DatasetSorter datasetSorter) {
        this.datasetSorter = datasetSorter;
    }

    public List getDatasetEnhancerList() {
        return this.datasetEnhancerList;
    }

    public void addDatasetEnhancer(DatasetEnhancer1 dsEnhancer) {
        if (this.datasetEnhancerList == null) {
            this.datasetEnhancerList = new ArrayList();
        }
        this.datasetEnhancerList.add(dsEnhancer);
    }

    public boolean isAddDatasetSize() {
        return this.addDatasetSize;
    }

    public void setAddDatasetSize(boolean addDatasetSize) {
        this.addDatasetSize = addDatasetSize;
    }

    public boolean validate(StringBuilder out) {
        this.isValid = true;
        if (this.msgLog.length() > 0) {
            out.append(this.msgLog);
        }
        if (this.getName() == null) {
            this.isValid = false;
            out.append(" ** DatasetSource (5): null value for name is not valid.");
        }
        if (this.getType() == null) {
            this.isValid = false;
            out.append(" ** DatasetSource (6): null value for type is not valid (set with bad string?).");
        }
        if (this.getStructure() == null) {
            this.isValid = false;
            out.append(" ** DatasetSource (7): null value for structure is not valid (set with bad string?).");
        }
        if (this.getResultService() != null) {
            this.isValid &= this.getResultService().validate(out);
        }
        Iterator dsnIter = this.getDatasetNamerList().iterator();
        while (dsnIter.hasNext()) {
            this.isValid &= ((DatasetNamer)dsnIter.next()).validate(out);
        }
        Iterator dsfIter = this.getDatasetFilterList().iterator();
        while (dsfIter.hasNext()) {
            this.isValid &= ((DatasetFilter)dsfIter.next()).validate(out);
        }
        return this.isValid;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        tmp.append("DatasetSource[name:<" + this.getName() + "> type:<" + this.getType() + "> structure:<" + this.getStructure() + "> accessPoint:<" + this.getAccessPoint() + "> and children - ResultService(" + this.getResultService().getName() + ") - DatasetNamer(" + this.getDatasetNamerList().size() + ") - DatasetFilter(" + this.getDatasetFilterList().size() + ")]");
        return tmp.toString();
    }

    public InvDataset expand() throws IOException {
        this.resultingCatalog = this.createSkeletonCatalog(this.prefixUrlPath);
        this.accessPointDataset = this.resultingCatalog.getDatasets().get(0);
        if (!this.isCollection(this.accessPointDataset)) {
            String tmpMsg = "The access point dataset <" + this.accessPointDataset.getName() + "> must be a collection dataset.";
            logger.warn("expand(): {}", (Object)tmpMsg);
            throw new IOException(tmpMsg);
        }
        this.expandRecursive(this.accessPointDataset);
        ((InvCatalogImpl)this.resultingCatalog).finish();
        this.recursivelyRemoveEmptyCollectionDatasets(this.accessPointDataset);
        return this.accessPointDataset;
    }

    public InvDataset expand(List accessPoints) throws IOException {
        this.resultingCatalog = this.createSkeletonCatalog(this.prefixUrlPath);
        this.accessPointDataset = this.resultingCatalog.getDatasets().get(0);
        Iterator it = accessPoints.iterator();
        while (it.hasNext()) {
            InvDataset curDs = this.createDataset((String)it.next(), this.prefixUrlPath);
            this.expandRecursiveCollection(this.accessPointDataset, curDs);
        }
        ((InvCatalogImpl)this.resultingCatalog).finish();
        this.recursivelyRemoveEmptyCollectionDatasets(this.accessPointDataset);
        return this.accessPointDataset;
    }

    private void expandRecursive(InvDataset collectionDataset) {
        List listAllDatasets = this.expandThisLevel(collectionDataset, this.prefixUrlPath);
        InvDataset curChildDs2 = null;
        for (InvDataset curChildDs2 : listAllDatasets) {
            if (!DatasetFilter.acceptDatasetByFilterGroup(this.getDatasetFilterList(), curChildDs2, this.isCollection(curChildDs2))) continue;
            if (this.isCollection(curChildDs2)) {
                this.expandRecursiveCollection(collectionDataset, curChildDs2);
                continue;
            }
            if (!this.isFlatten()) {
                ((InvDatasetImpl)collectionDataset).addDataset((InvDatasetImpl)curChildDs2);
                continue;
            }
            ((InvDatasetImpl)this.accessPointDataset).addDataset((InvDatasetImpl)curChildDs2);
        }
    }

    private void expandRecursiveCollection(InvDataset collectionDataset, InvDataset childDs) {
        if (!this.createCatalogRefs) {
            if (!this.isFlatten()) {
                ((InvDatasetImpl)collectionDataset).addDataset((InvDatasetImpl)childDs);
            }
            this.expandRecursive(childDs);
        } else {
            String title = childDs.getName();
            String docName = childDs.getName() == null || childDs.getName().equals("") ? "catalog.xml" : childDs.getName() + "/catalog.xml";
            InvCatalogRef curCatRef = new InvCatalogRef((InvDatasetImpl)collectionDataset, title, docName);
            ((InvDatasetImpl)collectionDataset).addDataset(curCatRef);
            DatasetSource catRefDsSrc = DatasetSource.newDatasetSource(childDs.getName(), this.getType(), this.getStructure(), childDs.getName(), new ResultService(this.getResultService()));
            this.catalogRefInfoList.add(new CatalogRefInfo(title, docName, childDs, catRefDsSrc));
        }
    }

    public InvCatalog fullExpand() throws IOException {
        logger.debug("fullExpand(): expanding DatasetSource named \"{}\"", (Object)this.getName());
        InvDataset topDs = this.expand();
        InvCatalog generatedCat = topDs.getParentCatalog();
        for (DatasetEnhancer1 dsE : this.getDatasetEnhancerList()) {
            dsE.addMetadata(topDs);
        }
        logger.debug("fullExpand(): naming the datasets.");
        this.nameDatasets((InvDatasetImpl)topDs);
        logger.debug("fullExpand(): sorting the datasets.");
        this.sortDatasets(topDs);
        ((InvCatalogImpl)generatedCat).finish();
        return generatedCat;
    }

    protected abstract InvDataset createDataset(String var1, String var2) throws IOException;

    protected abstract boolean isCollection(InvDataset var1);

    protected abstract InvCatalog createSkeletonCatalog(String var1) throws IOException;

    protected abstract List expandThisLevel(InvDataset var1, String var2);

    private void nameDatasets(InvDatasetImpl datasetContainer) {
        if (this.getDatasetNamerList().isEmpty()) {
            return;
        }
        if (this.isFlatten()) {
            logger.debug("nameDatasets(): structure is FLAT calling nameDatasetList()");
            this.nameDatasetList(datasetContainer);
        } else {
            logger.debug("nameDatasets(): structure is DIRECTORY_TREE calling nameDatasetTree() on each dataset in dataset container");
            InvDatasetImpl curDs = null;
            for (int j = 0; j < datasetContainer.getDatasets().size(); ++j) {
                curDs = (InvDatasetImpl)datasetContainer.getDatasets().get(j);
                this.nameDatasetTree(curDs);
            }
        }
    }

    private void nameDatasetList(InvDatasetImpl dataset) {
        int i;
        InvDatasetImpl namedDs = new InvDatasetImpl(dataset, "nameDatastList() temp dataset", null, null, null);
        dataset.addDataset(namedDs);
        DatasetNamer curNamer = null;
        for (i = 0; i < this.datasetNamerList.size(); ++i) {
            curNamer = (DatasetNamer)this.datasetNamerList.get(i);
            logger.debug("nameDatasetList(): trying namer ({})", (Object)curNamer.getName());
            InvDatasetImpl addLevelDs = null;
            if (curNamer.getAddLevel()) {
                addLevelDs = new InvDatasetImpl(null, curNamer.getName(), null, null, null);
            }
            InvDatasetImpl curDs = null;
            Iterator<InvDataset> dsIter = dataset.getDatasets().iterator();
            while (dsIter.hasNext()) {
                curDs = (InvDatasetImpl)dsIter.next();
                logger.debug("nameDatasetList(): try namer on this ds ({}-{})", (Object)curDs.getName(), (Object)curDs.getUrlPath());
                if (!curNamer.nameDataset(curDs)) continue;
                logger.debug("nameDatasetList(): ds named ({})", (Object)curDs.getName());
                if (curNamer.getAddLevel()) {
                    addLevelDs.addDataset(curDs);
                } else {
                    namedDs.addDataset(curDs);
                }
                dsIter.remove();
            }
            if (!curNamer.getAddLevel() || !addLevelDs.hasNestedDatasets()) continue;
            namedDs.addDataset(addLevelDs);
        }
        namedDs.finish();
        if (logger.isDebugEnabled()) {
            logger.debug("nameDatasetList(): number of unnamed datasets is " + dataset.getDatasets().size() + ".");
            logger.debug("nameDatasetList(): add named datasets back to container.");
        }
        for (i = 0; i < namedDs.getDatasets().size(); ++i) {
            dataset.addDataset((InvDatasetImpl)namedDs.getDatasets().get(i));
        }
        dataset.removeDataset(namedDs);
    }

    private void nameDatasetTree(InvDatasetImpl dataset) {
        if (dataset.getName().equals("") || !dataset.hasAccess()) {
            logger.debug("nameDatasetTree(): naming dataset ({})...", (Object)dataset.getUrlPath());
            DatasetNamer dsN = null;
            for (int i = 0; i < this.datasetNamerList.size(); ++i) {
                dsN = (DatasetNamer)this.datasetNamerList.get(i);
                if (!dsN.nameDataset(dataset)) continue;
                logger.debug("nameDatasetTree(): ... used namer ({})", (Object)dsN.getName());
                break;
            }
        }
        InvDatasetImpl curDs = null;
        for (int j = 0; j < dataset.getDatasets().size(); ++j) {
            curDs = (InvDatasetImpl)dataset.getDatasets().get(j);
            logger.debug("nameDatasetTree(): recurse to name child dataset ({})", (Object)curDs.getUrlPath());
            this.nameDatasetTree(curDs);
        }
    }

    private void sortDatasets(InvDataset dataset) {
        if (this.getDatasetSorter() == null) {
            DatasetSorter defaultSorter = new DatasetSorter(new Comparator(){

                public int compare(Object obj1, Object obj2) {
                    InvDataset ds1 = (InvDataset)obj1;
                    InvDataset ds2 = (InvDataset)obj2;
                    return -ds1.getName().compareTo(ds2.getName());
                }
            });
            defaultSorter.sortNestedDatasets(dataset);
        } else {
            this.getDatasetSorter().sortNestedDatasets(dataset);
        }
    }

    private void recursivelyRemoveEmptyCollectionDatasets(InvDataset parentDataset) {
        InvDataset curDs = null;
        Iterator<InvDataset> it = parentDataset.getDatasets().iterator();
        while (it.hasNext()) {
            curDs = it.next();
            if (curDs.hasAccess() || curDs instanceof InvCatalogRef) continue;
            if (curDs.hasNestedDatasets()) {
                this.recursivelyRemoveEmptyCollectionDatasets(curDs);
                continue;
            }
            it.remove();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatasetSource)) {
            return false;
        }
        DatasetSource datasetSource = (DatasetSource)o;
        if (this.createCatalogRefs != datasetSource.createCatalogRefs) {
            return false;
        }
        if (this.flatten != datasetSource.flatten) {
            return false;
        }
        if (this.accessPoint != null ? !this.accessPoint.equals(datasetSource.accessPoint) : datasetSource.accessPoint != null) {
            return false;
        }
        if (this.datasetFilterList != null ? !this.datasetFilterList.equals(datasetSource.datasetFilterList) : datasetSource.datasetFilterList != null) {
            return false;
        }
        if (this.datasetNamerList != null ? !this.datasetNamerList.equals(datasetSource.datasetNamerList) : datasetSource.datasetNamerList != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(datasetSource.name) : datasetSource.name != null) {
            return false;
        }
        if (this.resultService != null ? !this.resultService.equals(datasetSource.resultService) : datasetSource.resultService != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(datasetSource.type) : datasetSource.type != null);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = this.name != null ? this.name.hashCode() : 0;
            result = 29 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 29 * result + (this.flatten ? 1 : 0);
            result = 29 * result + (this.accessPoint != null ? this.accessPoint.hashCode() : 0);
            result = 29 * result + (this.createCatalogRefs ? 1 : 0);
            result = 29 * result + (this.resultService != null ? this.resultService.hashCode() : 0);
            result = 29 * result + (this.datasetNamerList != null ? this.datasetNamerList.hashCode() : 0);
            this.hashCode = result = 29 * result + (this.datasetFilterList != null ? this.datasetFilterList.hashCode() : 0);
        }
        return this.hashCode;
    }
}

