/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Visitor;

public abstract class Constant
implements Cloneable,
Node {
    protected byte tag;

    Constant(byte tag) {
        this.tag = tag;
    }

    public abstract void accept(Visitor var1);

    public abstract void dump(DataOutputStream var1) throws IOException;

    public final byte getTag() {
        return this.tag;
    }

    public String toString() {
        return Constants.CONSTANT_NAMES[this.tag] + "[" + this.tag + "]";
    }

    public Constant copy() {
        try {
            return (Constant)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    static final Constant readConstant(DataInputStream file2) throws IOException, ClassFormatError {
        byte b = file2.readByte();
        switch (b) {
            case 7: {
                return new ConstantClass(file2);
            }
            case 9: {
                return new ConstantFieldref(file2);
            }
            case 10: {
                return new ConstantMethodref(file2);
            }
            case 11: {
                return new ConstantInterfaceMethodref(file2);
            }
            case 8: {
                return new ConstantString(file2);
            }
            case 3: {
                return new ConstantInteger(file2);
            }
            case 4: {
                return new ConstantFloat(file2);
            }
            case 5: {
                return new ConstantLong(file2);
            }
            case 6: {
                return new ConstantDouble(file2);
            }
            case 12: {
                return new ConstantNameAndType(file2);
            }
            case 1: {
                return new ConstantUtf8(file2);
            }
        }
        throw new ClassFormatError("Invalid byte tag in constant pool: " + b);
    }
}

