# micromagnetictests
Marijan Beg<sup>1,2</sup> and Hans Fangohr<sup>2,1</sup>

<sup>1</sup> *Faculty of Engineering and Physical Sciences, University of Southampton, Southampton SO17 1BJ, United Kingdom*  
<sup>2</sup> *European XFEL GmbH, Holzkoppel 4, 22869 Schenefeld, Germany*  

| Description | Badge |
| --- | --- |
| Releases | [![PyPI version](https://badge.fury.io/py/micromagnetictests.svg)](https://badge.fury.io/py/micromagnetictests) |
|          | [![Anaconda-Server Badge](https://anaconda.org/conda-forge/micromagnetictests/badges/version.svg)](https://anaconda.org/conda-forge/micromagnetictests) |
| Builds | [![Build Status](https://travis-ci.org/ubermag/micromagnetictests.svg?branch=master)](https://travis-ci.org/ubermag/micromagnetictests) |
|       | [![Build status](https://ci.appveyor.com/api/projects/status/qhi1comhtaja0073?svg=true)](https://ci.appveyor.com/project/marijanbeg/micromagnetictests) |
| Coverage | [![codecov](https://codecov.io/gh/ubermag/micromagnetictests/branch/master/graph/badge.svg)](https://codecov.io/gh/ubermag/micromagnetictests) |
| Documentation | [![Documentation Status](https://readthedocs.org/projects/micromagnetictests/badge/?version=latest)](https://micromagnetictests.readthedocs.io/en/latest/?badge=latest) |
| Binder | [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/ubermag/micromagnetictests/master?urlpath=lab/tree/docs/ipynb/index.ipynb) |
| Platforms | [![Platforms](https://anaconda.org/conda-forge/micromagnetictests/badges/platforms.svg)](https://anaconda.org/conda-forge/micromagnetictests) |
| Downloads | [![Downloads](https://anaconda.org/conda-forge/micromagnetictests/badges/downloads.svg)](https://anaconda.org/conda-forge/micromagnetictests) |
| License | [![License](https://img.shields.io/badge/License-BSD%203--Clause-blue.svg)](https://opensource.org/licenses/BSD-3-Clause) |
| DOI | [![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.3539480.svg)](https://doi.org/10.5281/zenodo.3539480) |

## About

`micromagnetictests` is a Python package that provides:

- A collection of micromagnetic tests for Ubermag calculators

It is available on all major operating systems (Windows, MacOS, and Linux) and requires Python 3.6 or higher.

## Documentation

APIs and tutorials as Jupyter notebooks are available as a part of documentation.

## Installation, testing, and upgrade

We support installation using `conda` and `pip` package managers. Instructions can be found in the documentation.

## Binder

This package can be used in the cloud via Binder. This does not require to have anything installed and no files will be created on your machine. To access Binder, use the Binder badge in the table above.

## Support

If you require support, have questions, want to report a bug, or want to suggest an improvement, please raise an issue in [ubermag/help](https://github.com/ubermag/help) repository.

## License

Licensed under the BSD 3-Clause "New" or "Revised" License. For details, please refer to the [LICENSE](LICENSE) file.

## How to cite

If you use this package, please cite it as:

1. M. Beg, R. A. Pepper, and H. Fangohr. User interfaces for computational science: A domain specific language for OOMMF embedded in Python. [*AIP Advances* **7**, 56025 (2017)](http://aip.scitation.org/doi/10.1063/1.4977225).

2. COMING SOON... (M. Beg and H. Fangohr. ubermag/micromagnetictests: Python domain-specific language for defining micromagnetic models. Zenodo. DOI: [10.5281/zenodo.3539480](http://doi.org/10.5281/zenodo.3539480) (2020).)

## Acknowledgements

Developed as a part of:

- [OpenDreamKit](http://opendreamkit.org/) – Horizon 2020 European Research Infrastructure project (676541)

- EPSRC Programme grant on [Skyrmionics](http://www.skyrmions.ac.uk) (EP/N032128/1).
