# This package will contain the spiders of your Scrapy project
#
# Please refer to the documentation for information on how to create and manage
# your spiders.

import scrapy

from os_scrapy_httpproxy_middleware.items import ExampleItem


class ExampleSpider(scrapy.Spider):
    """ ExampleSpider
    Auto generated by os-scrapy-cookiecuter

    Run:
        scrapy crawl example
    """

    name = "example"

    def start_requests(self):
        yield scrapy.Request(
            "https://example.com/", meta={"proxy": "localhost:8080"},
        )

    def parse(self, response):
        request = response.request
        yield ExampleItem(
            request={
                "url": request.url,
                "method": request.method,
                "headers": request.headers,
                "body": request.body,
            },
            response={
                "status": response.status,
                "headers": response.headers,
                "body": response.body,
            },
            meta=response.meta,
        )
