import datetime
from typing import Any, Callable, Sequence

from celery.app.base import Celery
from celery.app.task import Task
from celery.concurrency.base import TaskPool
from celery.result import AsyncResult
from typing_extensions import Literal, TypedDict

class _DeliveryInfo(TypedDict, total=False):
    exchange: str | None
    routing_key: str | None
    priority: int | None
    redelivered: bool | None

class _InfoDict(TypedDict):
    id: str
    name: str
    args: Any
    kwargs: Any
    type: str
    hostname: str
    time_start: float
    acknowledged: bool
    delivery_info: _DeliveryInfo

class Request:
    acknowledged: bool
    time_start: float | None
    worker_pid: str | None
    time_limits: tuple[float | None, float | None]
    id: str
    def __init__(
        self,
        message: Any,
        on_ack: Callable[..., Any] = ...,
        hostname: str | None = ...,
        eventer: Any | None = ...,
        app: Celery | None = ...,
        connection_errors: Sequence[Any] | None = ...,
        request_dict: object = ...,
        task: Task | None = ...,
        on_reject: Callable[..., Any] = ...,
        body: Any | None = ...,
        headers: dict[str, str] | None = ...,
        decoded: bool = ...,
        utc: bool = ...,
        maybe_make_aware: Callable[[datetime.datetime], datetime.datetime] = ...,
        maybe_iso8601: Callable[[datetime.datetime | str], datetime.datetime] = ...,
        **opts: Any,
    ) -> None: ...
    @property
    def delivery_info(self) -> _DeliveryInfo: ...
    @property
    def message(self) -> Any: ...
    @property
    def request_dict(self) -> dict[str, Any]: ...
    @property
    def body(self) -> Any: ...
    @property
    def app(self) -> Celery | None: ...
    @property
    def utc(self) -> bool: ...
    @property
    def content_type(self) -> str: ...
    @property
    def content_encoding(self) -> str: ...
    @property
    def type(self) -> str: ...
    @property
    def root_id(self) -> str | None: ...
    @property
    def parent_id(self) -> str | None: ...
    @property
    def argsrepr(self) -> str: ...
    @property
    def args(self) -> Any: ...
    @property
    def kwargs(self) -> Any: ...
    @property
    def kwargsrepr(self) -> str: ...
    @property
    def on_ack(self) -> Callable[..., Any]: ...
    @property
    def on_reject(self) -> Callable[..., Any]: ...
    @on_reject.setter
    def on_reject(self, value: Callable[..., Any]) -> None: ...
    @property
    def hostname(self) -> str: ...
    @property
    def eventer(self) -> Any: ...
    @eventer.setter
    def eventer(self, eventer: Any) -> None: ...
    @property
    def connection_errors(self) -> Sequence[Any]: ...
    @property
    def task(self) -> Task: ...
    @property
    def eta(self) -> datetime.datetime | None: ...
    @property
    def expires(self) -> datetime.datetime: ...
    @expires.setter
    def expires(self, value: datetime.datetime) -> None: ...
    @property
    def tzlocal(self) -> Any: ...
    @property
    def store_errors(self) -> bool: ...
    @property
    def task_id(self) -> str: ...
    @task_id.setter
    def task_id(self, value: str) -> None: ...
    @property
    def task_name(self) -> str: ...
    @task_name.setter
    def task_name(self, value: str) -> None: ...
    @property
    def reply_to(self) -> Any: ...
    @property
    def correlation_id(self) -> Any: ...
    def execute_using_pool(self, pool: TaskPool, **kwargs: Any) -> AsyncResult: ...
    def execute(self, loglevel: int | None = ..., logfile: str | None = ...) -> Any: ...
    def maybe_expire(self) -> None | Literal[True]: ...
    def terminate(self, pool: TaskPool, signal: int | None = ...) -> None: ...
    def revoked(self) -> bool: ...
    def send_event(self, type: str, **fields: Any) -> None: ...
    def on_accepted(self, pid: str, time_accepted: float) -> None: ...
    def on_success(
        self, failed__retval__runtime: tuple[Any, Any, Any], **kwargs: Any
    ) -> None: ...
    def on_retry(self, exc_info: Any) -> None: ...
    def on_failure(
        self, exc_info: Any, send_failed_event: bool = ..., return_ok: bool = ...
    ) -> None: ...
    def acknowledge(self) -> None: ...
    def reject(self, requeue: bool = ...) -> None: ...
    def info(self, safe: bool = ...) -> _InfoDict: ...
    def humaninfo(self) -> str: ...
    def chord(self) -> Any | None: ...
    def errbacks(self) -> Any | None: ...
    def group(self) -> Any | None: ...
    def group_index(self) -> Any | None: ...
