---
layout: post
permalink: /libraries/
title: Library documentation
---

Complete list of the librairies included in asciidots, grouped by categories:

#### Simple operations on dots
- **[neg.dots](../libs/neg)** - Change the value of a dot to the opposite
- **[negate_id.dots](../libs/negate_id)** - Change the id of a dot to the opposite
- **[val_to_id.dots](../libs/val_to_id)** - Set the id to the value
- **[bool_not.dots](../libs/bool_not)**	- Operation NOT on booleans


#### Loops
- **[for_in_range.dots](../libs/for_in_range)** - Generate a range of numbers between to values
- **[clone.dots](../libs/clone)** - Generate the same dot *x* times

#### Data structures
- **[list.dots](../libs/list)** - Simulate a list with get, set, append, etc methods
- **[storage.dots](../libs/storage)** - Simulates a queue that can be used to store a single value

#### Time
- **[wait.dots](../libs/wait)** - Make a dot wait

#### (De)compression
- **[compress.dots](../libs/compress)** - Compress dots so they go in the same path
- **[decompress.dots](../libs/decompress)** - Separate dots that go in the same path
