"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnS3BucketObject = exports.toJson_TagsAllDefinition = exports.toJson_TagsDefinition = exports.toJson_MetadataDefinition = exports.toJson_CfnS3BucketObjectProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnS3BucketObjectProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnS3BucketObjectProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Acl': obj.acl,
        'Bucket': obj.bucket,
        'BucketKeyEnabled': obj.bucketKeyEnabled,
        'CacheControl': obj.cacheControl,
        'Content': obj.content,
        'ContentBase64': obj.contentBase64,
        'ContentDisposition': obj.contentDisposition,
        'ContentEncoding': obj.contentEncoding,
        'ContentLanguage': obj.contentLanguage,
        'ContentType': obj.contentType,
        'Etag': obj.etag,
        'ForceDestroy': obj.forceDestroy,
        'Key': obj.key,
        'KmsKeyId': obj.kmsKeyId,
        'Metadata': obj.metadata?.map(y => toJson_MetadataDefinition(y)),
        'ObjectLockLegalHoldStatus': obj.objectLockLegalHoldStatus,
        'ObjectLockMode': obj.objectLockMode,
        'ObjectLockRetainUntilDate': obj.objectLockRetainUntilDate,
        'ServerSideEncryption': obj.serverSideEncryption,
        'Source': obj.source,
        'StorageClass': obj.storageClass,
        'Tags': obj.tags?.map(y => toJson_TagsDefinition(y)),
        'TagsAll': obj.tagsAll?.map(y => toJson_TagsAllDefinition(y)),
        'WebsiteRedirect': obj.websiteRedirect,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnS3BucketObjectProps = toJson_CfnS3BucketObjectProps;
/**
 * Converts an object of type 'MetadataDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_MetadataDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'MapKey': obj.mapKey,
        'MapValue': obj.mapValue,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_MetadataDefinition = toJson_MetadataDefinition;
/**
 * Converts an object of type 'TagsDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_TagsDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'MapKey': obj.mapKey,
        'MapValue': obj.mapValue,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_TagsDefinition = toJson_TagsDefinition;
/**
 * Converts an object of type 'TagsAllDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_TagsAllDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'MapKey': obj.mapKey,
        'MapValue': obj.mapValue,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_TagsAllDefinition = toJson_TagsAllDefinition;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `TF::AWS::S3BucketObject`
 *
 * @cloudformationResource TF::AWS::S3BucketObject
 * @stability external
 * @link https://github.com/iann0036/cfn-tf-custom-types.git
 */
class CfnS3BucketObject extends cdk.CfnResource {
    /**
     * Create a new `TF::AWS::S3BucketObject`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnS3BucketObject.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnS3BucketObjectProps(props) });
        this.props = props;
        this.attrTfcfnid = cdk.Token.asString(this.getAtt('tfcfnid'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.attrVersionId = cdk.Token.asString(this.getAtt('VersionId'));
    }
}
exports.CfnS3BucketObject = CfnS3BucketObject;
_a = JSII_RTTI_SYMBOL_1;
CfnS3BucketObject[_a] = { fqn: "@cdk-cloudformation/tf-aws-s3bucketobject.CfnS3BucketObject", version: "1.0.0-alpha.6" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnS3BucketObject.CFN_RESOURCE_TYPE_NAME = "TF::AWS::S3BucketObject";
//# sourceMappingURL=data:application/json;base64,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