/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.sparksdk.protobuf;

import com.amazonaws.services.sagemaker.sparksdk.protobuf.ProtobufConverter;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class RecordIOOutputFormat
extends FileOutputFormat<NullWritable, BytesWritable> {
    public RecordWriter<NullWritable, BytesWritable> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        Path path = this.getDefaultWorkFile(taskAttemptContext, "sagemaker");
        FileSystem fileSystem = path.getFileSystem(taskAttemptContext.getConfiguration());
        FSDataOutputStream fSDataOutputStream = fileSystem.create(path, true);
        return new SageMakerProtobufRecordWriter((OutputStream)fSDataOutputStream);
    }

    public static class SageMakerProtobufRecordWriter
    extends RecordWriter<NullWritable, BytesWritable> {
        private OutputStream out;

        public SageMakerProtobufRecordWriter(OutputStream outputStream) {
            this.out = outputStream;
        }

        public void write(NullWritable nullWritable, BytesWritable bytesWritable) throws IOException, InterruptedException {
            byte[] byArray = ProtobufConverter.byteArrayToRecordIOEncodedByteArray(bytesWritable.getBytes());
            this.out.write(byArray, 0, byArray.length);
        }

        public void close(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            this.out.close();
        }
    }
}

