/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.sparksdk;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemaker.AmazonSageMaker;
import com.amazonaws.services.sagemaker.AmazonSageMakerClientBuilder;
import com.amazonaws.services.sagemaker.model.DescribeEndpointRequest;
import com.amazonaws.services.sagemaker.model.DescribeEndpointResult;
import com.amazonaws.services.sagemaker.model.DescribeTrainingJobRequest;
import com.amazonaws.services.sagemaker.model.EndpointStatus;
import com.amazonaws.services.sagemaker.model.TrainingJobStatus;
import com.amazonaws.services.sagemaker.sparksdk.EndpointCreationPolicy$;
import com.amazonaws.services.sagemaker.sparksdk.NamePolicy;
import com.amazonaws.services.sagemaker.sparksdk.RandomNamePolicy;
import com.amazonaws.services.sagemaker.sparksdk.RandomNamePolicy$;
import com.amazonaws.services.sagemaker.sparksdk.S3DataPath;
import com.amazonaws.services.sagemaker.sparksdk.S3DataPath$;
import com.amazonaws.services.sagemaker.sparksdk.SageMakerModel;
import com.amazonaws.services.sagemaker.sparksdk.internal.InternalUtils$;
import com.amazonaws.services.sagemaker.sparksdk.transformation.RequestRowSerializer;
import com.amazonaws.services.sagemaker.sparksdk.transformation.ResponseRowDeserializer;
import java.time.Duration;
import org.apache.spark.ml.util.Identifiable$;
import scala.Enumeration;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class SageMakerModel$
implements Serializable {
    public static final SageMakerModel$ MODULE$;
    private Duration EndpointCreationTimeout;
    private Duration EndpointPollInterval;

    static {
        new SageMakerModel$();
    }

    public Duration EndpointCreationTimeout() {
        return this.EndpointCreationTimeout;
    }

    public void EndpointCreationTimeout_$eq(Duration x$1) {
        this.EndpointCreationTimeout = x$1;
    }

    public Duration EndpointPollInterval() {
        return this.EndpointPollInterval;
    }

    public void EndpointPollInterval_$eq(Duration x$1) {
        this.EndpointPollInterval = x$1;
    }

    /*
     * Unable to fully structure code
     */
    public SageMakerModel fromTrainingJob(String trainingJobName, String modelImage, String modelExecutionRoleARN, String endpointInstanceType, int endpointInitialInstanceCount, RequestRowSerializer requestRowSerializer, ResponseRowDeserializer responseRowDeserializer, Map<String, String> modelEnvironmentVariables, Enumeration.Value endpointCreationPolicy, AmazonSageMaker sagemakerClient, boolean prependResultRows, NamePolicy namePolicy, String uid) {
        v0 = endpointCreationPolicy;
        var14_14 = EndpointCreationPolicy$.MODULE$.DO_NOT_CREATE();
        Predef$.MODULE$.require(v0 != null ? v0.equals(var14_14) == false : var14_14 != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Endpoint creation policy must not be DO_NOT_CREATE to create an endpoint from a training job name.";
            }
        });
        describeTrainingJobRequest = new DescribeTrainingJobRequest().withTrainingJobName(trainingJobName);
        InternalUtils$.MODULE$.applyUserAgent((AmazonWebServiceRequest)describeTrainingJobRequest);
        response = sagemakerClient.describeTrainingJob(describeTrainingJobRequest);
        v1 = status = TrainingJobStatus.fromValue((String)response.getTrainingJobStatus());
        var18_18 = TrainingJobStatus.Completed;
        if (!(v1 == null ? var18_18 != null : v1.equals(var18_18) == false)) ** GOTO lbl-1000
        v2 = status;
        var19_19 = TrainingJobStatus.Stopped;
        if (!(v2 != null ? v2.equals(var19_19) == false : var19_19 != null)) lbl-1000:
        // 2 sources

        {
            v3 = true;
        } else {
            v3 = false;
        }
        Predef$.MODULE$.require(v3, (Function0)new Serializable(status){
            public static final long serialVersionUID = 0L;
            private final TrainingJobStatus status$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Can only create a SageMakerModel from a training job with status Completed or Stopped, not status ").append((Object)this.status$1.toString()).toString();
            }
            {
                this.status$1 = status$1;
            }
        });
        modelPath = response.getModelArtifacts().getS3ModelArtifacts();
        x$1 = new Some((Object)modelImage);
        x$2 = new Some((Object)S3DataPath$.MODULE$.fromS3URI(modelPath));
        x$3 = requestRowSerializer;
        x$4 = responseRowDeserializer;
        x$5 = modelEnvironmentVariables;
        x$6 = new Some((Object)modelExecutionRoleARN);
        x$7 = endpointCreationPolicy;
        x$8 = new Some((Object)endpointInstanceType);
        x$9 = new Some((Object)BoxesRunTime.boxToInteger((int)endpointInitialInstanceCount));
        x$10 = sagemakerClient;
        x$11 = prependResultRows;
        x$12 = namePolicy;
        x$13 = uid;
        x$14 = this.$lessinit$greater$default$5();
        return new SageMakerModel((Option<String>)x$8, (Option<Object>)x$9, x$3, x$4, x$14, (Option<String>)x$1, (Option<S3DataPath>)x$2, x$5, (Option<String>)x$6, x$7, x$10, x$11, x$12, x$13);
    }

    public Map<String, String> fromTrainingJob$default$8() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public Enumeration.Value fromTrainingJob$default$9() {
        return EndpointCreationPolicy$.MODULE$.CREATE_ON_CONSTRUCT();
    }

    public AmazonSageMaker fromTrainingJob$default$10() {
        return AmazonSageMakerClientBuilder.defaultClient();
    }

    public boolean fromTrainingJob$default$11() {
        return true;
    }

    public NamePolicy fromTrainingJob$default$12() {
        return new RandomNamePolicy(RandomNamePolicy$.MODULE$.$lessinit$greater$default$1());
    }

    public String fromTrainingJob$default$13() {
        return Identifiable$.MODULE$.randomUID("sagemaker");
    }

    public SageMakerModel fromModelS3Path(String modelPath, String modelImage, String modelExecutionRoleARN, String endpointInstanceType, int endpointInitialInstanceCount, RequestRowSerializer requestRowSerializer, ResponseRowDeserializer responseRowDeserializer, Map<String, String> modelEnvironmentVariables, Enumeration.Value endpointCreationPolicy, AmazonSageMaker sagemakerClient, boolean prependResultRows, NamePolicy namePolicy, String uid) {
        Enumeration.Value value = endpointCreationPolicy;
        Enumeration.Value value2 = EndpointCreationPolicy$.MODULE$.DO_NOT_CREATE();
        Predef$.MODULE$.require(value != null ? !value.equals(value2) : value2 != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Endpoint creation policy must not be DO_NOT_CREATE to create an endpoint from a model path.";
            }
        });
        Some x$15 = new Some((Object)modelImage);
        Some x$16 = new Some((Object)S3DataPath$.MODULE$.fromS3URI(modelPath));
        RequestRowSerializer x$17 = requestRowSerializer;
        ResponseRowDeserializer x$18 = responseRowDeserializer;
        Map<String, String> x$19 = modelEnvironmentVariables;
        Some x$20 = new Some((Object)modelExecutionRoleARN);
        Enumeration.Value x$21 = endpointCreationPolicy;
        Some x$22 = new Some((Object)endpointInstanceType);
        Some x$23 = new Some((Object)BoxesRunTime.boxToInteger((int)endpointInitialInstanceCount));
        AmazonSageMaker x$24 = sagemakerClient;
        boolean x$25 = prependResultRows;
        NamePolicy x$26 = namePolicy;
        String x$27 = uid;
        Option<String> x$28 = this.$lessinit$greater$default$5();
        return new SageMakerModel((Option<String>)x$22, (Option<Object>)x$23, x$17, x$18, x$28, (Option<String>)x$15, (Option<S3DataPath>)x$16, x$19, (Option<String>)x$20, x$21, x$24, x$25, x$26, x$27);
    }

    public Map<String, String> fromModelS3Path$default$8() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public Enumeration.Value fromModelS3Path$default$9() {
        return EndpointCreationPolicy$.MODULE$.CREATE_ON_CONSTRUCT();
    }

    public AmazonSageMaker fromModelS3Path$default$10() {
        return AmazonSageMakerClientBuilder.defaultClient();
    }

    public boolean fromModelS3Path$default$11() {
        return true;
    }

    public NamePolicy fromModelS3Path$default$12() {
        return new RandomNamePolicy(RandomNamePolicy$.MODULE$.$lessinit$greater$default$1());
    }

    public String fromModelS3Path$default$13() {
        return Identifiable$.MODULE$.randomUID("sagemaker");
    }

    public SageMakerModel fromEndpoint(String endpointName2, RequestRowSerializer requestRowSerializer, ResponseRowDeserializer responseRowDeserializer, Map<String, String> modelEnvironmentVariables, AmazonSageMaker sagemakerClient, boolean prependResultRows, NamePolicy namePolicy, String uid) {
        String status;
        DescribeEndpointRequest describeEndpointRequest = new DescribeEndpointRequest().withEndpointName(endpointName2);
        InternalUtils$.MODULE$.applyUserAgent((AmazonWebServiceRequest)describeEndpointRequest);
        DescribeEndpointResult result = sagemakerClient.describeEndpoint(describeEndpointRequest);
        String string = status = result.getEndpointStatus();
        String string2 = EndpointStatus.InService.toString();
        Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0)new Serializable(status){
            public static final long serialVersionUID = 0L;
            private final String status$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Endpoint status must be In Service, not ").append((Object)this.status$2).toString();
            }
            {
                this.status$2 = status$2;
            }
        });
        Some x$29 = new Some((Object)endpointName2);
        RequestRowSerializer x$30 = requestRowSerializer;
        ResponseRowDeserializer x$31 = responseRowDeserializer;
        Map<String, String> x$32 = modelEnvironmentVariables;
        Enumeration.Value x$33 = EndpointCreationPolicy$.MODULE$.DO_NOT_CREATE();
        None$ x$34 = None$.MODULE$;
        None$ x$35 = None$.MODULE$;
        AmazonSageMaker x$36 = sagemakerClient;
        boolean x$37 = prependResultRows;
        NamePolicy x$38 = namePolicy;
        String x$39 = uid;
        Option<String> x$40 = this.$lessinit$greater$default$6();
        Option<S3DataPath> x$41 = this.$lessinit$greater$default$7();
        Option<String> x$42 = this.$lessinit$greater$default$9();
        return new SageMakerModel((Option<String>)x$34, (Option<Object>)x$35, x$30, x$31, (Option<String>)x$29, x$40, x$41, x$32, x$42, x$33, x$36, x$37, x$38, x$39);
    }

    public Map<String, String> fromEndpoint$default$4() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public AmazonSageMaker fromEndpoint$default$5() {
        return AmazonSageMakerClientBuilder.defaultClient();
    }

    public boolean fromEndpoint$default$6() {
        return true;
    }

    public NamePolicy fromEndpoint$default$7() {
        return new RandomNamePolicy(RandomNamePolicy$.MODULE$.$lessinit$greater$default$1());
    }

    public String fromEndpoint$default$8() {
        return Identifiable$.MODULE$.randomUID("sagemaker");
    }

    public Option<String> $lessinit$greater$default$5() {
        return Option$.MODULE$.empty();
    }

    public Option<String> $lessinit$greater$default$6() {
        return Option$.MODULE$.empty();
    }

    public Option<S3DataPath> $lessinit$greater$default$7() {
        return Option$.MODULE$.empty();
    }

    public Map<String, String> $lessinit$greater$default$8() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public Option<String> $lessinit$greater$default$9() {
        return Option$.MODULE$.empty();
    }

    public Enumeration.Value $lessinit$greater$default$10() {
        return EndpointCreationPolicy$.MODULE$.CREATE_ON_CONSTRUCT();
    }

    public AmazonSageMaker $lessinit$greater$default$11() {
        return AmazonSageMakerClientBuilder.defaultClient();
    }

    public boolean $lessinit$greater$default$12() {
        return true;
    }

    public NamePolicy $lessinit$greater$default$13() {
        return new RandomNamePolicy(RandomNamePolicy$.MODULE$.$lessinit$greater$default$1());
    }

    public String $lessinit$greater$default$14() {
        return Identifiable$.MODULE$.randomUID("sagemaker");
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SageMakerModel$() {
        MODULE$ = this;
        this.EndpointCreationTimeout = Duration.ofMinutes(30L);
        this.EndpointPollInterval = Duration.ofSeconds(5L);
    }
}

