"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const iam = require("@aws-cdk/aws-iam");
const ec2 = require("@aws-cdk/aws-ec2");
class GitlabContainerRunner extends cdk.Construct {
    constructor(scope, id, props) {
        var _a, _b, _c, _d;
        super(scope, id);
        const vpc = new ec2.Vpc(this, 'VPC', {
            cidr: '10.0.0.0/16',
            maxAzs: 2,
            subnetConfiguration: [{
                    cidrMask: 26,
                    name: 'RunnerVPC',
                    subnetType: ec2.SubnetType.PUBLIC,
                }],
            natGateways: 0,
        });
        var token = props.gitlabtoken;
        var tag1 = (_a = props.tag1) !== null && _a !== void 0 ? _a : 'gitlab';
        var tag2 = (_b = props.tag2) !== null && _b !== void 0 ? _b : 'awscdk';
        var tag3 = (_c = props.tag3) !== null && _c !== void 0 ? _c : 'runner';
        const shell = ec2.UserData.forLinux();
        shell.addCommands('yum update -y');
        shell.addCommands('yum install docker -y');
        shell.addCommands('service docker start');
        shell.addCommands('usermod -aG docker ec2-user');
        shell.addCommands('chmod +x /var/run/docker.sock');
        shell.addCommands('service docker restart &&  chkconfig docker on');
        shell.addCommands('docker run -d -v /home/ec2-user/.gitlab-runner:/etc/gitlab-runner -v /var/run/docker.sock:/var/run/docker.sock --name gitlab-runner-register gitlab/gitlab-runner:alpine register --non-interactive --url https://gitlab.com./ --registration-token ' + token + '  --docker-volumes \"/var/run/docker.sock:/var/run/docker.sock\" --executor docker --docker-image \"alpine:latest\" --description \"Docker Runner\" --tag-list \"' + tag1 + ',' + tag2 + ',' + tag3 + '\" --docker-privileged');
        shell.addCommands('sleep 2 && docker run --restart always -d -v /home/ec2-user/.gitlab-runner:/etc/gitlab-runner -v /var/run/docker.sock:/var/run/docker.sock --name gitlab-runner gitlab/gitlab-runner:alpine');
        shell.addCommands('usermod -aG docker ssm-user');
        const runner = new ec2.Instance(this, 'GitlabRunner', {
            instanceType: (_d = props.ec2type) !== null && _d !== void 0 ? _d : ec2.InstanceType.of(ec2.InstanceClass.T3, ec2.InstanceSize.LARGE),
            instanceName: 'Gitlab-Runner',
            vpc,
            machineImage: new ec2.AmazonLinuxImage,
            userData: shell,
            blockDevices: [({ deviceName: '/dev/xvda', volume: ec2.BlockDeviceVolume.ebs(60) })],
        });
        runner.role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        new cdk.CfnOutput(this, 'Runner-ID', { value: runner.instanceId });
    }
}
exports.GitlabContainerRunner = GitlabContainerRunner;
//# sourceMappingURL=data:application/json;base64,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