"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Version = void 0;
/**
 * Utility class for validating and converting the version number to or from a version string
 */
class Version {
    static validateVersionString(versionString) {
        if (null === this.parseFromVersionString(versionString)) {
            return false;
        }
        return true;
    }
    static parseFromVersionString(versionString) {
        return Version.VALID_VERSION_REGEX.exec(versionString);
    }
    static convertToFullVersionString(major, minor, release, patch) {
        const majorNumber = Number(major);
        const minorNumber = Number(minor);
        const releaseNumber = Number(release);
        const patchNumber = Number(patch);
        if (isNaN(majorNumber) || majorNumber < 0
            || isNaN(minorNumber) || minorNumber < 0
            || isNaN(releaseNumber) || releaseNumber < 0
            || isNaN(patchNumber) || patchNumber < 0) {
            throw new Error(`A component of the version was not in the correct format: ${major}.${minor}.${release}.${patch}`);
        }
        return `${major}.${minor}.${release}.${patch}`;
    }
}
exports.Version = Version;
Version.VALID_VERSION_REGEX = /^(0|[1-9]\d*)(?:\.(0|[1-9]\d*))?(?:\.(0|[1-9]\d*))?(?:\.(0|[1-9]\d*))?$/;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmVyc2lvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInZlcnNpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7R0FHRzs7O0FBRUg7O0dBRUc7QUFDSCxNQUFhLE9BQU87SUFDWCxNQUFNLENBQUMscUJBQXFCLENBQUMsYUFBcUI7UUFDdkQsSUFBSSxJQUFJLEtBQUssSUFBSSxDQUFDLHNCQUFzQixDQUFDLGFBQWEsQ0FBQyxFQUFHO1lBQUUsT0FBTyxLQUFLLENBQUM7U0FBRTtRQUMzRSxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFTSxNQUFNLENBQUMsc0JBQXNCLENBQUMsYUFBcUI7UUFDeEQsT0FBTyxPQUFPLENBQUMsbUJBQW1CLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ3pELENBQUM7SUFFTSxNQUFNLENBQUMsMEJBQTBCLENBQUMsS0FBYSxFQUFFLEtBQWEsRUFBRSxPQUFlLEVBQUUsS0FBYTtRQUNuRyxNQUFNLFdBQVcsR0FBRyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDbEMsTUFBTSxXQUFXLEdBQUcsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ2xDLE1BQU0sYUFBYSxHQUFHLE1BQU0sQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUN0QyxNQUFNLFdBQVcsR0FBRyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUM7UUFFbEMsSUFBSSxLQUFLLENBQUMsV0FBVyxDQUFDLElBQUksV0FBVyxHQUFHLENBQUM7ZUFDcEMsS0FBSyxDQUFDLFdBQVcsQ0FBQyxJQUFJLFdBQVcsR0FBRyxDQUFDO2VBQ3JDLEtBQUssQ0FBQyxhQUFhLENBQUMsSUFBSSxhQUFhLEdBQUcsQ0FBQztlQUN6QyxLQUFLLENBQUMsV0FBVyxDQUFDLElBQUksV0FBVyxHQUFHLENBQUMsRUFBRTtZQUMxQyxNQUFNLElBQUksS0FBSyxDQUFDLDZEQUE2RCxLQUFLLElBQUksS0FBSyxJQUFJLE9BQU8sSUFBSSxLQUFLLEVBQUUsQ0FBQyxDQUFDO1NBQ3BIO1FBQ0QsT0FBTyxHQUFHLEtBQUssSUFBSSxLQUFLLElBQUksT0FBTyxJQUFJLEtBQUssRUFBRSxDQUFDO0lBQ2pELENBQUM7O0FBdkJILDBCQTBCQztBQUR5QiwyQkFBbUIsR0FBRyx5RUFBeUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbi8qKlxuICogVXRpbGl0eSBjbGFzcyBmb3IgdmFsaWRhdGluZyBhbmQgY29udmVydGluZyB0aGUgdmVyc2lvbiBudW1iZXIgdG8gb3IgZnJvbSBhIHZlcnNpb24gc3RyaW5nXG4gKi9cbmV4cG9ydCBjbGFzcyBWZXJzaW9uIHtcbiAgcHVibGljIHN0YXRpYyB2YWxpZGF0ZVZlcnNpb25TdHJpbmcodmVyc2lvblN0cmluZzogc3RyaW5nKTogYm9vbGVhbiB7XG4gICAgaWYgKG51bGwgPT09IHRoaXMucGFyc2VGcm9tVmVyc2lvblN0cmluZyh2ZXJzaW9uU3RyaW5nKSkgIHsgcmV0dXJuIGZhbHNlOyB9XG4gICAgcmV0dXJuIHRydWU7XG4gIH1cblxuICBwdWJsaWMgc3RhdGljIHBhcnNlRnJvbVZlcnNpb25TdHJpbmcodmVyc2lvblN0cmluZzogc3RyaW5nKTogUmVnRXhwRXhlY0FycmF5IHwgbnVsbCB7XG4gICAgcmV0dXJuIFZlcnNpb24uVkFMSURfVkVSU0lPTl9SRUdFWC5leGVjKHZlcnNpb25TdHJpbmcpO1xuICB9XG5cbiAgcHVibGljIHN0YXRpYyBjb252ZXJ0VG9GdWxsVmVyc2lvblN0cmluZyhtYWpvcjogc3RyaW5nLCBtaW5vcjogc3RyaW5nLCByZWxlYXNlOiBzdHJpbmcsIHBhdGNoOiBzdHJpbmcpOiBzdHJpbmcge1xuICAgIGNvbnN0IG1ham9yTnVtYmVyID0gTnVtYmVyKG1ham9yKTtcbiAgICBjb25zdCBtaW5vck51bWJlciA9IE51bWJlcihtaW5vcik7XG4gICAgY29uc3QgcmVsZWFzZU51bWJlciA9IE51bWJlcihyZWxlYXNlKTtcbiAgICBjb25zdCBwYXRjaE51bWJlciA9IE51bWJlcihwYXRjaCk7XG5cbiAgICBpZiAoaXNOYU4obWFqb3JOdW1iZXIpIHx8IG1ham9yTnVtYmVyIDwgMFxuICAgICAgfHwgaXNOYU4obWlub3JOdW1iZXIpIHx8IG1pbm9yTnVtYmVyIDwgMFxuICAgICAgfHwgaXNOYU4ocmVsZWFzZU51bWJlcikgfHwgcmVsZWFzZU51bWJlciA8IDBcbiAgICAgIHx8IGlzTmFOKHBhdGNoTnVtYmVyKSB8fCBwYXRjaE51bWJlciA8IDApIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgQSBjb21wb25lbnQgb2YgdGhlIHZlcnNpb24gd2FzIG5vdCBpbiB0aGUgY29ycmVjdCBmb3JtYXQ6ICR7bWFqb3J9LiR7bWlub3J9LiR7cmVsZWFzZX0uJHtwYXRjaH1gKTtcbiAgICB9XG4gICAgcmV0dXJuIGAke21ham9yfS4ke21pbm9yfS4ke3JlbGVhc2V9LiR7cGF0Y2h9YDtcbiAgfVxuXG4gIHByaXZhdGUgc3RhdGljIHJlYWRvbmx5IFZBTElEX1ZFUlNJT05fUkVHRVggPSAvXigwfFsxLTldXFxkKikoPzpcXC4oMHxbMS05XVxcZCopKT8oPzpcXC4oMHxbMS05XVxcZCopKT8oPzpcXC4oMHxbMS05XVxcZCopKT8kLztcbn1cbiJdfQ==