/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
import { DeadlineClient } from '../deadline-client';
/**
 * Provides a simple interface to send requests to the Render Queue API related to the Deadline Spot Event Plugin.
 */
export declare class SpotEventPluginClient {
    private static readonly EVENT_PLUGIN_ID;
    private readonly deadlineClient;
    constructor(client: DeadlineClient);
    saveServerData(config: string): Promise<boolean>;
    configureSpotEventPlugin(configs: Array<{
        Key: string;
        Value: any;
    }>): Promise<boolean>;
    private describeServerData;
    /**
     * Requests a concurrencyToken required to save spot fleet request configuration.
     * If data already exists under the ID, an existing ConcurrencyToken has to be used.
     * First obtain the token and then save the data with the same ConcurrencyToken.
     * If there is no data under the ID, then real token is not required,
     * but the ConcurrencyToken property still has to be set.
     * NOTE:
     * saveServerData() will have a ConcurrencyToken in its response but we do not use it,
     * instead we always call this function to get a latest token.
     */
    private concurrencyToken;
}
