/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
import { BlockDeviceMappingProperty, BlockDeviceProperty, PluginSettings, SpotFleetInstanceProfile, SpotFleetRequestConfiguration, LaunchSpecification, SpotFleetSecurityGroupId, SpotFleetTagSpecification } from './types';
/**
 * Convert the configuration we received from ConfigureSpotEventPlugin construct to the fromat expected by the Spot Event Plugin.
 * boolean and number properties get converted into strings when passed to the Lambda,
 * so we need to restore the original types.
 */
export declare function convertSpotFleetRequestConfiguration(spotFleetRequestConfigs: SpotFleetRequestConfiguration): SpotFleetRequestConfiguration;
/**
 * Convert the configuration we received from ConfigureSpotEventPlugin construct to the fromat expected by the Spot Event Plugin.
 * boolean and number properties get converted into strings when passed to the Lambda,
 * so we need to restore the original types.
 */
export declare function convertSpotEventPluginSettings(pluginOptions: PluginSettings): PluginSettings;
export declare function validateArray(input: any, propertyName: string): void;
export declare function validateProperty(isValid: (input: any) => boolean, property: any, propertyName: string): void;
export declare function isValidSecurityGroup(securityGroup: SpotFleetSecurityGroupId): boolean;
export declare function convertSecurityGroups(securityGroups: SpotFleetSecurityGroupId[], propertyName: string): SpotFleetSecurityGroupId[];
export declare function isValidTagSpecification(tagSpecification: SpotFleetTagSpecification): boolean;
export declare function convertTagSpecifications(tagSpecifications: SpotFleetTagSpecification[], propertyName: string): SpotFleetTagSpecification[];
export declare function isValidDeviceMapping(deviceMapping: BlockDeviceMappingProperty): boolean;
export declare function convertEbs(ebs: BlockDeviceProperty, propertyName: string): BlockDeviceProperty;
export declare function convertBlockDeviceMapping(blockDeviceMappings: BlockDeviceMappingProperty[], propertyName: string): BlockDeviceMappingProperty[];
export declare function isValidInstanceProfile(instanceProfile: SpotFleetInstanceProfile): boolean;
export declare function convertInstanceProfile(instanceProfile: SpotFleetInstanceProfile, propertyName: string): SpotFleetInstanceProfile;
export declare function convertLaunchSpecifications(launchSpecifications: LaunchSpecification[], propertyName: string): LaunchSpecification[];
export declare function convertToInt(value: any, propertyName: string): number;
export declare function convertToIntOptional(value: any, propertyName: string): number | undefined;
export declare function convertToBoolean(value: any, propertyName: string): boolean;
export declare function convertToBooleanOptional(value: any, propertyName: string): boolean | undefined;
export declare function validateString(value: any, propertyName: string): string;
export declare function validateStringOptional(value: any, propertyName: string): string | undefined;
