"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.windowsCloudWatchScriptBoilerplate = exports.windowsConfigureWorkerScriptBoilerplate = exports.linuxCloudWatchScriptBoilerplate = exports.linuxConfigureWorkerScriptBoilerplate = exports.RQ_CONNECTION_ASSET = exports.REPO_DC_ASSET = exports.TEST_ASSET = exports.INSTALL_REPOSITORY_ASSET_LINUX = exports.CONFIG_WORKER_PORT_ASSET_WINDOWS = exports.CONFIG_WORKER_ASSET_WINDOWS = exports.CONFIG_WORKER_ASSET_LINUX = exports.CWA_ASSET_WINDOWS = exports.CWA_ASSET_LINUX = void 0;
// TODO: Properly import from aws-rfdk. Not ideal
// to use a relative path here.
const assert_1 = require("@aws-cdk/assert");
const asset_constants_1 = require("../../core/test/asset-constants");
Object.defineProperty(exports, "CWA_ASSET_LINUX", { enumerable: true, get: function () { return asset_constants_1.CWA_ASSET_LINUX; } });
Object.defineProperty(exports, "CWA_ASSET_WINDOWS", { enumerable: true, get: function () { return asset_constants_1.CWA_ASSET_WINDOWS; } });
// configureWorker.sh
exports.CONFIG_WORKER_ASSET_LINUX = {
    Bucket: 'AssetParameters21c2af3bc1d4fd78061765b059dcc8e32568828e5cf479b08115489651491c8fS3BucketF10C60A7',
    Key: 'AssetParameters21c2af3bc1d4fd78061765b059dcc8e32568828e5cf479b08115489651491c8fS3VersionKey7FDCC89A',
};
// configureWorker.ps1
exports.CONFIG_WORKER_ASSET_WINDOWS = {
    Bucket: 'AssetParametersa10d67420c8758e35d8dae5fa406c7acb92b1bd40924167d5564aa0037b4a980S3Bucket953E30DC',
    Key: 'AssetParametersa10d67420c8758e35d8dae5fa406c7acb92b1bd40924167d5564aa0037b4a980S3VersionKeyAFB97BD6',
};
exports.CONFIG_WORKER_PORT_ASSET_WINDOWS = {
    Bucket: 'AssetParameters0b4fe3ffb7177773bb2781f92b37d9b01b3bd37ee60ea1715c0ad407f141005dS3BucketE7B32C3E',
    Key: 'AssetParameters0b4fe3ffb7177773bb2781f92b37d9b01b3bd37ee60ea1715c0ad407f141005dS3VersionKey843794E3',
};
// installDeadlineRepository.sh
exports.INSTALL_REPOSITORY_ASSET_LINUX = {
    Bucket: assert_1.stringLike('AssetParameters*S3Bucket8EB24E17'),
};
// test.file
exports.TEST_ASSET = {
    Bucket: assert_1.stringLike('AssetParameters*S3Bucket5D5509D9'),
    Key: assert_1.stringLike('AssetParameters*S3VersionKeyF19FF080'),
};
// installRepostitoryDirectConnection
exports.REPO_DC_ASSET = {
    Bucket: assert_1.stringLike('AssetParameters*S3Bucket87338EBD'),
    Key: assert_1.stringLike('AssetParameters*S3VersionKeyB7FF7B3C'),
};
exports.RQ_CONNECTION_ASSET = {
    Bucket: 'AssetParameters74fd6cba5cebe5a13738b535ab6b010a0fe1154689bad4df3ef49ed7bddc1075S3Bucket0337801D',
    Key: 'AssetParameters74fd6cba5cebe5a13738b535ab6b010a0fe1154689bad4df3ef49ed7bddc1075S3VersionKey144181B5',
};
function linuxConfigureWorkerScriptBoilerplate(scriptParams) {
    return [
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        "')\naws s3 cp 's3://",
        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Bucket },
        '/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        "' '/tmp/",
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        "'\nmkdir -p $(dirname '/tmp/",
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        '\')\naws s3 cp \'s3://',
        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Bucket },
        '/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        '\' \'/tmp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        '\'\n' +
            'set -e\n' +
            'chmod +x \'/tmp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        '\'\n\'/tmp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        scriptParams,
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
    ];
}
exports.linuxConfigureWorkerScriptBoilerplate = linuxConfigureWorkerScriptBoilerplate;
function linuxCloudWatchScriptBoilerplate() {
    return [
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        '\')\naws s3 cp \'s3://',
        { Ref: asset_constants_1.CWA_ASSET_LINUX.Bucket },
        '/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        '\' \'/tmp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        '\'\n' +
            'set -e\n' +
            'chmod +x \'/tmp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        '\'\n\'/tmp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
    ];
}
exports.linuxCloudWatchScriptBoilerplate = linuxCloudWatchScriptBoilerplate;
function windowsConfigureWorkerScriptBoilerplate(scriptParams) {
    return [
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        '\' ) -ea 0\nRead-S3Object -BucketName \'',
        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Bucket },
        '\' -key \'',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        '\' -file \'C:/temp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        "' -ErrorAction Stop\nmkdir (Split-Path -Path 'C:/temp/",
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        "' ) -ea 0\nRead-S3Object -BucketName '",
        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Bucket },
        "' -key '",
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        "' -file 'C:/temp/",
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        '\' -ErrorAction Stop\n&\'C:/temp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        scriptParams,
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        {
                            Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key,
                        },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        {
                            Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key,
                        },
                    ],
                },
            ],
        },
        '\nif (!$?) { Write-Error \'Failed to execute the file \"C:/temp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
    ];
}
exports.windowsConfigureWorkerScriptBoilerplate = windowsConfigureWorkerScriptBoilerplate;
function windowsCloudWatchScriptBoilerplate() {
    return [
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        '\' ) -ea 0\nRead-S3Object -BucketName \'',
        { Ref: asset_constants_1.CWA_ASSET_WINDOWS.Bucket },
        '\' -key \'',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        '\' -file \'C:/temp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        '\' -ErrorAction Stop\n&\'C:/temp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
    ];
}
exports.windowsCloudWatchScriptBoilerplate = windowsCloudWatchScriptBoilerplate;
//# sourceMappingURL=data:application/json;base64,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