"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SpotFleetRequestType = exports.SpotFleetResourceType = exports.SpotFleetAllocationStrategy = void 0;
/**
 * The allocation strategy for the Spot Instances in your Spot Fleet determines how it fulfills your Spot Fleet request from the possible Spot Instance pools represented by its launch specifications.
 *
 * See https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-allocation-strategy
 *
 * @stability stable
 */
var SpotFleetAllocationStrategy;
(function (SpotFleetAllocationStrategy) {
    SpotFleetAllocationStrategy["LOWEST_PRICE"] = "lowestPrice";
    SpotFleetAllocationStrategy["DIVERSIFIED"] = "diversified";
    SpotFleetAllocationStrategy["CAPACITY_OPTIMIZED"] = "capacityOptimized";
})(SpotFleetAllocationStrategy = exports.SpotFleetAllocationStrategy || (exports.SpotFleetAllocationStrategy = {}));
/**
 * Resource types that presently support tag on create.
 *
 * @stability stable
 */
var SpotFleetResourceType;
(function (SpotFleetResourceType) {
    SpotFleetResourceType["INSTANCE"] = "instance";
    SpotFleetResourceType["SPOT_FLEET_REQUEST"] = "spot-fleet-request";
})(SpotFleetResourceType = exports.SpotFleetResourceType || (exports.SpotFleetResourceType = {}));
/**
 * The type of request. Indicates whether the Spot Fleet only requests the target capacity or also attempts to maintain it.
 * Only 'maintain' is currently supported.
 */
var SpotFleetRequestType;
(function (SpotFleetRequestType) {
    SpotFleetRequestType["MAINTAIN"] = "maintain";
})(SpotFleetRequestType = exports.SpotFleetRequestType || (exports.SpotFleetRequestType = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3BvdC1ldmVudC1wbHVnaW4tZmxlZXQtcmVmLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic3BvdC1ldmVudC1wbHVnaW4tZmxlZXQtcmVmLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7QUFXQSxJQUFZLDJCQWFYO0FBYkQsV0FBWSwyQkFBMkI7SUFJckMsMkRBQTRCLENBQUE7SUFJNUIsMERBQTJCLENBQUE7SUFJM0IsdUVBQXdDLENBQUE7QUFDMUMsQ0FBQyxFQWJXLDJCQUEyQixHQUEzQixtQ0FBMkIsS0FBM0IsbUNBQTJCLFFBYXRDOzs7Ozs7QUFLRCxJQUFZLHFCQVVYO0FBVkQsV0FBWSxxQkFBcUI7SUFJL0IsOENBQXFCLENBQUE7SUFLckIsa0VBQXlDLENBQUE7QUFDM0MsQ0FBQyxFQVZXLHFCQUFxQixHQUFyQiw2QkFBcUIsS0FBckIsNkJBQXFCLFFBVWhDO0FBRUQ7OztHQUdHO0FBQ0gsSUFBWSxvQkFNWDtBQU5ELFdBQVksb0JBQW9CO0lBSzlCLDZDQUFxQixDQUFBO0FBQ3ZCLENBQUMsRUFOVyxvQkFBb0IsR0FBcEIsNEJBQW9CLEtBQXBCLDRCQUFvQixRQU0vQiIsInNvdXJjZXNDb250ZW50IjpbIiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGVudW0gU3BvdEZsZWV0QWxsb2NhdGlvblN0cmF0ZWd5IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIExPV0VTVF9QUklDRSA9ICdsb3dlc3RQcmljZScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIERJVkVSU0lGSUVEID0gJ2RpdmVyc2lmaWVkJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBDQVBBQ0lUWV9PUFRJTUlaRUQgPSAnY2FwYWNpdHlPcHRpbWl6ZWQnLFxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBlbnVtIFNwb3RGbGVldFJlc291cmNlVHlwZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIElOU1RBTkNFID0gJ2luc3RhbmNlJyxcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBTUE9UX0ZMRUVUX1JFUVVFU1QgPSAnc3BvdC1mbGVldC1yZXF1ZXN0Jyxcbn1cblxuLyoqXG4gKiBUaGUgdHlwZSBvZiByZXF1ZXN0LiBJbmRpY2F0ZXMgd2hldGhlciB0aGUgU3BvdCBGbGVldCBvbmx5IHJlcXVlc3RzIHRoZSB0YXJnZXQgY2FwYWNpdHkgb3IgYWxzbyBhdHRlbXB0cyB0byBtYWludGFpbiBpdC5cbiAqIE9ubHkgJ21haW50YWluJyBpcyBjdXJyZW50bHkgc3VwcG9ydGVkLlxuICovXG5leHBvcnQgZW51bSBTcG90RmxlZXRSZXF1ZXN0VHlwZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBNQUlOVEFJTiA9ICdtYWludGFpbicsXG59XG4iXX0=