"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const lib_1 = require("../lib");
const mount_permissions_helper_1 = require("../lib/mount-permissions-helper");
test.each([
    [lib_1.MountPermissions.READONLY, 'ro'],
    [lib_1.MountPermissions.READWRITE, 'rw'],
    [undefined, 'rw'],
])('toLinuxMountOption test: %p', (permission, expected) => {
    expect(mount_permissions_helper_1.MountPermissionsHelper.toLinuxMountOption(permission)).toBe(expected);
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibW91bnQtcGVybWlzc2lvbnMtaGVscGVyLnRlc3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJtb3VudC1wZXJtaXNzaW9ucy1oZWxwZXIudGVzdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7OztHQUdHOztBQUVILGdDQUVnQjtBQUNoQiw4RUFFeUM7QUFFekMsSUFBSSxDQUFDLElBQUksQ0FBQztJQUNSLENBQUMsc0JBQWdCLENBQUMsUUFBUSxFQUFFLElBQUksQ0FBQztJQUNqQyxDQUFDLHNCQUFnQixDQUFDLFNBQVMsRUFBRSxJQUFJLENBQUM7SUFDbEMsQ0FBQyxTQUFTLEVBQUUsSUFBSSxDQUFDO0NBQ2xCLENBQUMsQ0FBQyw2QkFBNkIsRUFBRSxDQUFDLFVBQVUsRUFBRSxRQUFRLEVBQUUsRUFBRTtJQUN6RCxNQUFNLENBQUMsaURBQXNCLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUM7QUFDL0UsQ0FBQyxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIENvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQge1xuICBNb3VudFBlcm1pc3Npb25zLFxufSBmcm9tICcuLi9saWInO1xuaW1wb3J0IHtcbiAgTW91bnRQZXJtaXNzaW9uc0hlbHBlcixcbn0gZnJvbSAnLi4vbGliL21vdW50LXBlcm1pc3Npb25zLWhlbHBlcic7XG5cbnRlc3QuZWFjaChbXG4gIFtNb3VudFBlcm1pc3Npb25zLlJFQURPTkxZLCAncm8nXSxcbiAgW01vdW50UGVybWlzc2lvbnMuUkVBRFdSSVRFLCAncncnXSxcbiAgW3VuZGVmaW5lZCwgJ3J3J10sXG5dKSgndG9MaW51eE1vdW50T3B0aW9uIHRlc3Q6ICVwJywgKHBlcm1pc3Npb24sIGV4cGVjdGVkKSA9PiB7XG4gIGV4cGVjdChNb3VudFBlcm1pc3Npb25zSGVscGVyLnRvTGludXhNb3VudE9wdGlvbihwZXJtaXNzaW9uKSkudG9CZShleHBlY3RlZCk7XG59KTtcbiJdfQ==