"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchConfigBuilder = exports.TimeZone = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
const core_1 = require("@aws-cdk/core");
/**
 * Enum to describe the time zone property.
 *
 * @stability stable
 */
var TimeZone;
(function (TimeZone) {
    TimeZone["LOCAL"] = "Local";
    TimeZone["UTC"] = "UTC";
})(TimeZone = exports.TimeZone || (exports.TimeZone = {}));
/**
 * Class that can build a CloudWatch Agent configuration.
 *
 * @stability stable
 */
class CloudWatchConfigBuilder {
    /**
     * Constructs.
     *
     * @stability stable
     */
    constructor(logFlushInterval = CloudWatchConfigBuilder.DEFAULT_FLUSH_INTERVAL) {
        this.cloudWatchFileList = [];
        this.logFlushInterval = logFlushInterval;
    }
    /**
     * This method adds the log file path and its associated log group and log stream properties to the list of files which needs to be streamed to cloud watch logs.
     *
     * @param logGroupName - string for the log group name.
     * @param logStreamPrefix - string for the log stream prefix.
     * @param logFilePath - local file path which needs to be streamed.
     * @param timeZone -  the time zone to use when putting timestamps on log events.
     * @stability stable
     */
    addLogsCollectList(logGroupName, logStreamPrefix, logFilePath, timeZone = CloudWatchConfigBuilder.DEFAULT_LOG_TIMEZONE) {
        this.cloudWatchFileList.push({
            log_group_name: logGroupName,
            log_stream_name: logStreamPrefix + '-' + CloudWatchConfigBuilder.CLOUDWATCH_CONFIG_INSTANCE_ID_VARIABLE,
            file_path: logFilePath,
            timezone: timeZone,
        });
    }
    /**
     * The method generates the configuration for log file streaming to be added to CloudWatch Agent Configuration File.
     *
     * @stability stable
     */
    generateCloudWatchConfiguration() {
        const cloudWatchConfig = {
            logs: {
                logs_collected: {
                    files: {
                        collect_list: this.cloudWatchFileList,
                    },
                },
                log_stream_name: CloudWatchConfigBuilder.DEFAULT_STREAM_NAME
                    + '-'
                    + CloudWatchConfigBuilder.CLOUDWATCH_CONFIG_INSTANCE_ID_VARIABLE,
                force_flush_interval: this.logFlushInterval.toSeconds(),
            },
        };
        return JSON.stringify(cloudWatchConfig);
    }
}
exports.CloudWatchConfigBuilder = CloudWatchConfigBuilder;
_a = JSII_RTTI_SYMBOL_1;
CloudWatchConfigBuilder[_a] = { fqn: "aws-rfdk.CloudWatchConfigBuilder", version: "0.26.0" };
CloudWatchConfigBuilder.DEFAULT_STREAM_NAME = 'DefaultLogStream';
CloudWatchConfigBuilder.DEFAULT_FLUSH_INTERVAL = core_1.Duration.seconds(60);
CloudWatchConfigBuilder.DEFAULT_LOG_TIMEZONE = TimeZone.LOCAL;
CloudWatchConfigBuilder.CLOUDWATCH_CONFIG_INSTANCE_ID_VARIABLE = '{instance_id}';
//# sourceMappingURL=data:application/json;base64,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