# React-ui template

This is a full react template ready to use in a component

This UI was automatically generated with:

```commandline
lightning_app init react-ui
```

### Delete files

This template has 3 main files/folders:

- README.md
- example_app.py
- ui

The README.md and example_app.py are here to help you get started. However, they should be deleted.
All you need is the `ui` folder when you connect this react UI to your component.

### Run the example_app

This template comes with `example_app.py` to show how to integrate the UI into a component.

run it with:

```bash
lightning_app run app react-ui/example_app.py
```

### Connect React to your component

To connect the react UI to your component, simply point the `StaticWebFrontend` to the `dist/` folder generated by yarn after building your react website.

```python
import lightning as L


class YourComponent(L.LightningFlow):
    def configure_layout(self):
        return Lapp.frontend.StaticWebFrontend(Path(__file__).parent / "react-ui/src/dist")
```

### Set up interactions between React and the component

To communicate bi-directionally between react and the component, use the `useLightningState` module:

```js
// App.tsx

import { useLightningState } from "./hooks/useLightningState";
import cloneDeep from "lodash/cloneDeep";

function App() {
  const { lightningState, updateLightningState } = useLightningState();

  const modify_and_send_back_the_state = async (event: ChangeEvent<HTMLInputElement>) => {
    if (lightningState) {
      const newLightningState = cloneDeep(lightningState);
      // Update the state and send it back.
      newLightningState.flows.counter += 1

      updateLightningState(newLightningState);
    }
  };

  return (
    <div className="App">
    </div>
  );
}

export default App;
```

#### Application Folder Structure

You would find the following structure in the folder `/react`.

```
react
├── dist
├── index.html
├── node_modules
├── package.json
├── src
│   ├── App.css
│   ├── App.tsx
│   ├── hooks
│   ├── index.css
│   ├── main.tsx
│   ├── types
│   └── vite-env.d.ts
├── tsconfig.json
├── tsconfig.node.json
├── vite.config.ts
└── yarn.lock
```

### Read the docs

For more features and information, [read the documentation](https://ideal-bassoon-5313f557.pages.github.io/workflows/add_web_ui/react/index.html).
