import math


def 첫달이자(원금_원: float = 100_000_000.0, 이자율: float = 3.0, ceil=True):
    if 원금_원 <= 0 or 이자율 <= 0:
        raise Exception("invalid args")
    년_이자 = 원금_원 * (이자율 / 100)
    return float(math.ceil(년_이자 / 12)) if ceil else 년_이자 / 12


월_상환액_리스트 = lambda 월별이자_리스트, 월별원금_리스트: [
    월별이자 + 월별원금 for 월별이자, 월별원금 in zip(월별이자_리스트, 월별원금_리스트)
]


def 만기일시(원금_만원: float = 10000.0, 이자율: float = 3.0, 개월수: int = 24):
    if 원금_만원 <= 0 or 이자율 <= 0 or 개월수 <= 0:
        raise Exception("invalid args")
    원금_원 = 원금_만원 * 10000
    월별이자_리스트 = [첫달이자(원금_원, 이자율)] * 개월수
    총_대출이자 = sum(월별이자_리스트)
    월별원금_리스트 = [0] * (개월수 - 1) + [원금_원]
    return 총_대출이자, 월별이자_리스트, 월별원금_리스트, 월_상환액_리스트(월별이자_리스트, 월별원금_리스트)


def 원금균등_월별이자_리스트(원금_원: float = 100_000_000.0, 이자율: float = 3.0, 개월수: int = 24):
    if 원금_원 <= 0 or 이자율 <= 0 or 개월수 <= 0:
        raise Exception("invalid args")
    첫달원금 = float(math.floor(원금_원 / 개월수))
    if 개월수 <= 1:
        return [첫달이자(원금_원, 이자율)]
    남은원금 = 원금_원 - 첫달원금
    return [첫달이자(원금_원, 이자율)] + 원금균등_월별이자_리스트(남은원금, 이자율, 개월수 - 1)


def 원금균등(원금_만원: float = 10000.0, 이자율: float = 3.0, 개월수: int = 24):
    if 원금_만원 <= 0 or 이자율 <= 0 or 개월수 <= 0:
        raise Exception("invalid args")
    원금_원 = 원금_만원 * 10000
    월별이자_리스트 = 원금균등_월별이자_리스트(원금_원, 이자율, 개월수)
    총_대출이자 = sum(월별이자_리스트)
    월별원금_리스트 = [float(math.floor(원금_원 / 개월수))] * 개월수
    return 총_대출이자, 월별이자_리스트, 월별원금_리스트, 월_상환액_리스트(월별이자_리스트, 월별원금_리스트)


def 원리금균등_월상환액(원금_원: float = 100_000_000.0, 이자율: float = 3.0, 개월수: int = 24):
    if 원금_원 <= 0 or 이자율 <= 0 or 개월수 <= 0:
        raise Exception("invalid args")
    R = (이자율 / 100) / 12
    return float(math.floor(원금_원 * (1 / ((1 + R) ** 개월수 - 1) + 1) * R))


def 원리금균등_월별상환액_리스트(
    원금_원: float = 100_000_000.0, 이자율: float = 3.0, 개월수: int = 24, 월_상환액=None
):
    if 원금_원 <= 0 or 이자율 <= 0 or 개월수 <= 0:
        raise Exception("invalid args")

    if not 월_상환액:
        월_상환액 = 원리금균등_월상환액(원금_원, 이자율, 개월수)

    첫달원금 = float(math.ceil(월_상환액 - 첫달이자(원금_원, 이자율, False)))
    남은원금 = 원금_원 - 첫달원금
    if 개월수 <= 1:
        return [월_상환액 - 첫달원금], [첫달원금], [월_상환액]

    다음_이자_리스트, 다음_원금_리스트, 다음_상환액_리스트 = 원리금균등_월별상환액_리스트(남은원금, 이자율, 개월수 - 1, 월_상환액)
    return [월_상환액 - 첫달원금] + 다음_이자_리스트, [첫달원금] + 다음_원금_리스트, [월_상환액] + 다음_상환액_리스트


def 원리금균등(원금_만원: float = 10000.0, 이자율: float = 3.0, 개월수: int = 24):
    if 원금_만원 <= 0 or 이자율 <= 0 or 개월수 <= 0:
        raise Exception("invalid args")
    원금_원 = 원금_만원 * 10000
    월별이자_리스트, 월별원금_리스트, 월별_상환액_리스트 = 원리금균등_월별상환액_리스트(원금_원, 이자율, 개월수)
    총_대출이자 = sum(월별이자_리스트)
    return 총_대출이자, 월별이자_리스트, 월별원금_리스트, 월별_상환액_리스트
