// Copyright (c) Mito
import React from 'react';
import { getDisplayColumnHeader } from '../../../utils/columnHeaders';
import DropdownItem from '../../elements/DropdownItem';
import Select from '../../elements/Select';
import XIcon from '../../icons/XIcon';
import Col from '../../spacing/Col';
import Row from '../../spacing/Row';
/*
  A custom component that displays the column headers chosen as the key for the pivot table.
*/
const PivotTableColumnHeaderCard = (props) => {
    return (React.createElement(Row, { justify: 'space-between', align: 'center' },
        React.createElement(Col, { flex: '1' },
            React.createElement(Select, { value: props.columnID, onChange: (columnID) => {
                    props.editKey(props.keyIndex, columnID);
                }, searchable: true }, Object.entries(props.columnIDsMap).map(([columnID, columnHeader]) => {
                return (React.createElement(DropdownItem, { key: columnID, id: columnID, title: getDisplayColumnHeader(columnHeader) }));
            }))),
        React.createElement(Col, { offset: 1, offsetRight: 1 },
            React.createElement(XIcon, { onClick: () => props.removeKey(props.keyIndex) }))));
};
export default PivotTableColumnHeaderCard;
//# sourceMappingURL=PivotTableColumnHeaderCard.js.map