// Copyright (c) Mito
import React, { useEffect, useState } from 'react';
import { ModalEnum } from './modals';
import DefaultModal from '../DefaultModal';
import TextButton from '../elements/TextButton';
import RadioButtons from '../elements/RadioButtons';
import TextArea from '../elements/TextArea';
const UsageTriggeredFeedbackTitleMapping = {
    ["pivot_usage_triggered" /* PIVOT_USAGE_TRIGGERED */]: 'Creating a Pivot Table Feedback',
    ["add_column_usage_triggered" /* ADD_COLUMN_USAGE_TRIGGERED */]: 'Adding a Column Feedback',
    ["delete_column_usage_triggered" /* DELETE_COLUMN_USAGE_TRIGGERED */]: 'Deleting a Column Feedback',
    ["rename_column_usage_triggered" /* RENAME_COLUMN_USAGE_TRIGGERED */]: 'Renaming a Column Feedback',
    ["reorder_column_usage_triggered" /* REORDER_COLUMN_USAGE_TRIGGERED */]: 'Reordering a Column Feedback',
    ["filter_column_usage_triggered" /* FILTER_COLUMN_USAGE_TRIGGERED */]: 'Filtering a Column Feedback',
    ["set_column_formula_usage_triggered" /* SET_COLUMN_FORMULA_USAGE_TRIGGERED */]: 'Setting a Column Formula Feedback',
    ["set_cell_value_usage_triggered" /* SET_CELL_VALUE_USAGE_TRIGGERED */]: 'Setting Cell Value Feedback',
    ["dataframe_delete_usage_triggered" /* DATAFRAME_DELETE_USAGE_TRIGGERED */]: 'Deleting Dataframe Feedback',
    ["dataframe_duplicate_usage_triggered" /* DATAFRAME_DUPLICATE_USAGE_TRIGGERED */]: 'Duplicating Dataframe Feedback',
    ["dataframe_rename_usage_triggered" /* DATAFRAME_RENAME_USAGE_TRIGGERED */]: 'Renaming a Dataframe Feedback',
    ["sort_usage_triggered" /* SORT_USAGE_TRIGGERED */]: 'Sorting a Column Feedback',
    ["merge_usage_triggered" /* MERGE_USAGE_TRIGGERED */]: 'Merging Dataframes Feedback',
    ["change_column_dtype_usage_triggered" /* CHANGE_COLUMN_DTYPE_USAGE_TRIGGERED */]: 'Changing Column Dtype Feedback',
    ["change_column_format_usage_triggered" /* CHANGE_COLUMN_FORMAT_USAGE_TRIGGERED */]: 'Changing Column Format Feedback',
    ["simple_import_usage_triggered" /* SIMPLE_IMPORT_USAGE_TRIGGERED */]: 'Importing CSV Feedback',
    ["excel_import_usage_triggered" /* EXCEL_IMPORT_USAGE_TRIGGERED */]: 'Importing Excel File Feedback',
    ["drop_duplicates_usage_triggered" /* DROP_DUPLICATES_USAGE_TRIGGERED */]: 'Drop Duplicated Feedback'
};
const UsageTriggeredFeedbackQuestionMapping = {
    ["pivot_usage_triggered" /* PIVOT_USAGE_TRIGGERED */]: 'created a pivot table',
    ["add_column_usage_triggered" /* ADD_COLUMN_USAGE_TRIGGERED */]: 'added a column',
    ["delete_column_usage_triggered" /* DELETE_COLUMN_USAGE_TRIGGERED */]: 'deleted a column',
    ["rename_column_usage_triggered" /* RENAME_COLUMN_USAGE_TRIGGERED */]: 'renamed a column',
    ["reorder_column_usage_triggered" /* REORDER_COLUMN_USAGE_TRIGGERED */]: 'reordered a column',
    ["filter_column_usage_triggered" /* FILTER_COLUMN_USAGE_TRIGGERED */]: 'filtered a column',
    ["set_column_formula_usage_triggered" /* SET_COLUMN_FORMULA_USAGE_TRIGGERED */]: 'set a column formula',
    ["set_cell_value_usage_triggered" /* SET_CELL_VALUE_USAGE_TRIGGERED */]: 'set a cell value',
    ["dataframe_delete_usage_triggered" /* DATAFRAME_DELETE_USAGE_TRIGGERED */]: 'deleted a dataframe',
    ["dataframe_duplicate_usage_triggered" /* DATAFRAME_DUPLICATE_USAGE_TRIGGERED */]: 'duplicated a dataframe',
    ["dataframe_rename_usage_triggered" /* DATAFRAME_RENAME_USAGE_TRIGGERED */]: 'renamed a dataframe',
    ["sort_usage_triggered" /* SORT_USAGE_TRIGGERED */]: 'sorted a column',
    ["merge_usage_triggered" /* MERGE_USAGE_TRIGGERED */]: 'merged dataframes together',
    ["change_column_dtype_usage_triggered" /* CHANGE_COLUMN_DTYPE_USAGE_TRIGGERED */]: 'changed a column dtype',
    ["change_column_format_usage_triggered" /* CHANGE_COLUMN_FORMAT_USAGE_TRIGGERED */]: 'changed a column format',
    ["simple_import_usage_triggered" /* SIMPLE_IMPORT_USAGE_TRIGGERED */]: 'imported a CSV',
    ["excel_import_usage_triggered" /* EXCEL_IMPORT_USAGE_TRIGGERED */]: 'imported an Excel file',
    ["drop_duplicates_usage_triggered" /* DROP_DUPLICATES_USAGE_TRIGGERED */]: 'dropped duplicates'
};
/*
  A modal that confirms with the user that they want to clear
  the entire analysis export for simple import steps
*/
const FeedbackModal = (props) => {
    const questionOne = `How successful was it on a scale from 1-5?`;
    const questionTwo = 'Tell us about your experience.';
    const [firstResponse, setFirstResponse] = useState('');
    const [secondResponse, setSecondResponse] = useState('');
    const [submitted, setSubmitted] = useState(false);
    // Log when this opens
    useEffect(() => {
        void props.mitoAPI.sendLogMessage('usage_triggered_feedback_opened');
    }, []);
    return (React.createElement(DefaultModal, { header: UsageTriggeredFeedbackTitleMapping[props.usageTriggereeFeedbackID], modalType: ModalEnum.Feedback, setUIState: props.setUIState, overlay: true, viewComponent: React.createElement("div", { className: 'text-align-left' },
            React.createElement("label", null,
                React.createElement("h3", { className: 'text-body-1 mt-5px mb-5px' },
                    "You recently ",
                    React.createElement("b", null, UsageTriggeredFeedbackQuestionMapping[props.usageTriggereeFeedbackID]),
                    ". ",
                    questionOne),
                React.createElement("p", { className: 'text-subtext-1' }, "1 = Not useful"),
                React.createElement("p", { className: 'text-subtext-1 mb-5px' }, "5 = Exactly what I wanted")),
            React.createElement(RadioButtons, { values: ['1', '2', '3', '4', '5'], selectedValue: firstResponse, onChange: (e) => setFirstResponse(e), highlight: submitted && firstResponse === '', orientation: 'horizontal' }),
            React.createElement("label", null,
                React.createElement("h3", { className: 'text-body-1 mt-20px mb-5px' }, questionTwo)),
            React.createElement(TextArea, { value: secondResponse, className: (submitted && secondResponse === '') ? 'border-red-important' : undefined, placeholder: 'I could not figure out how to ...', onChange: (e) => setSecondResponse(e.target.value), height: 'small' })), buttons: React.createElement(React.Fragment, null,
            React.createElement(TextButton, { variant: 'dark', width: 'small', onClick: () => {
                    // Make sure it's filled out
                    if (firstResponse === '' || secondResponse === '') {
                        setSubmitted(true);
                        return;
                    }
                    void props.mitoAPI.sendFeedback(props.usageTriggereeFeedbackID, props.numUsages, [
                        { 'question': questionOne, 'answer': firstResponse },
                        { 'question': questionTwo, 'answer': secondResponse }
                    ]);
                    // And then close the modal
                    props.setUIState(prevUIState => {
                        return Object.assign(Object.assign({}, prevUIState), { currOpenModal: { type: ModalEnum.None } });
                    });
                } }, "Submit")) }));
};
export default FeedbackModal;
//# sourceMappingURL=FeedbackModal.js.map