#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""This file was automatically generated by fhq-server
Version: v0.2.35
Date: 08 Jan 2021
"""
import asyncio
import time
import select
import json
import traceback
import websocket

class FreeHackQuestClient:
    """Client Api for fhq-server"""
    __ws = None
    __url = None
    __cli_version = 'v0.2.35'
    __loop = None
    __connecting = False
    __message_id_counter = 0
    __incoming_messsages = []

    def __init__(self, url):
        self.__url = url
        self.__loop = asyncio.get_event_loop()
        try:
            self.__ws = websocket.create_connection(self.__url)
            self.__connecting = True
        except Exception as err:
            print('Failed connect to ' + self.__url)
            print('Error: ' + str(err))
            traceback.print_exc()
            self.__ws = None
            self.__connecting = False
            return

    def __enter__(self):
        return self

    def __exit__(self, exc_type, exc_value, exc_tracebalc):
        self.close()

    def has_connection(self):
        """Check the exists connection"""
        return self.__ws is not None

    def close(self):
        """Close connection"""
        if self.__ws is not None:
            self.__ws.close()
            self.__ws = None

    def receive_incoming_messsages(self):
        """Recieve incoming messages and handle it"""
        if self.__ws is None:
            return
        while True:
            if self.__ws is None:
                return
            ready = select.select([self.__ws], [], [], 1)
            if ready[0]:
                response_text = self.__ws.recv()
                response_json = json.loads(response_text)
                # print('response_text: ' + response_text)
                # incomeMessageId = response_json['m']
                self.__incoming_messsages.append(response_json)
            else:
                return
            time.sleep(0.2)

    def get_incoming_messsages(self):
        """Return incoming messages list (for example: notifications)"""
        return self.__incoming_messsages

    def clean_incoming_messsages(self):
        """Clear list of incoming messages (like a notifications)"""
        self.__incoming_messsages = []

    @asyncio.coroutine
    async def __looper(self, message_id):
        """Infinty looper for handling income messages"""
        max_time = 5*10 # 5 seconds
        counter_time = 0
        while True:
            if self.__ws is None:
                return None
            for inmsg in self.__incoming_messsages:
                if inmsg['m'] == message_id:
                    response_json = inmsg
                    self.__incoming_messsages.remove(response_json)
                    return response_json
            counter_time = counter_time + 1
            ready = select.select([self.__ws], [], [], 0.1)
            if ready[0]:
                response_text = self.__ws.recv()
                response_json = json.loads(response_text)
                # print('response_text: ' + response_text)
                if 'm' in response_json:
                    income_message_id = response_json['m']
                    if income_message_id == message_id:
                        return response_json
                    self.__incoming_messsages.append(response_json)
                else:
                    print('What is it? {' + response_text + '}')
            else:
                print('wait...')
            if counter_time > max_time:
                return None
            await asyncio.sleep(0.2)

    def generate_base_command(self, method):
        """Prepare basic command"""
        request_json = {}
        self.__message_id_counter = self.__message_id_counter + 1
        msg_id = 'm' + str(self.__message_id_counter)
        request_json['m'] = msg_id
        request_json['cmd'] = method
        request_json['jsonrpc'] = '2.0'
        request_json['method'] = method
        return request_json

    def __send_command(self, req):
        """Send request"""
        request_text = json.dumps(req)
        message_id = req['m']
        # print('request_text: ' + request_text)
        self.__ws.send(request_text)
        result = self.__loop.run_until_complete(asyncio.gather(self.__looper(message_id)))
        return result[0]

    def addhint(self, req):
        """Method add hint to quest
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                questid (integer,required):
                    quest id
                hint (string,required):
                    hint text
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('addhint')
        allowed_params = [
            'questid',
            'hint',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'questid' not in req:
            raise Exception('Parameter "questid" expected (lib)')
        if 'hint' not in req:
            raise Exception('Parameter "hint" expected (lib)')
        if 'questid' in req:
            request_json['questid'] = req['questid']
        if 'hint' in req:
            request_json['hint'] = req['hint']
        return self.__send_command(request_json)

    def answerlist(self, req):
        """Return user answers list
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                page (integer,required):
                    Number of page
                onpage (integer,required):
                    How much rows on page
                questid (integer,optional):
                    Filter for questid
                userid (integer,optional):
                    Filter for userid
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('answerlist')
        allowed_params = [
            'page',
            'onpage',
            'questid',
            'userid',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'page' not in req:
            raise Exception('Parameter "page" expected (lib)')
        if 'onpage' not in req:
            raise Exception('Parameter "onpage" expected (lib)')
        if 'page' in req:
            request_json['page'] = req['page']
        if 'onpage' in req:
            request_json['onpage'] = req['onpage']
        if 'questid' in req:
            request_json['questid'] = req['questid']
        if 'userid' in req:
            request_json['userid'] = req['userid']
        return self.__send_command(request_json)

    def chat_latest_messages(self, req):
        """Method will be send chat message and it sent to another users
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('chat_latest_messages')
        allowed_params = []
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        return self.__send_command(request_json)

    def chat_send_message(self, req):
        """Method will be send chat message and it sent to another users
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                type (string,required):
                    Type
                message (string,required):
                    Message
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('chat_send_message')
        allowed_params = [
            'type',
            'message',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'type' not in req:
            raise Exception('Parameter "type" expected (lib)')
        if 'message' not in req:
            raise Exception('Parameter "message" expected (lib)')
        if 'type' in req:
            request_json['type'] = req['type']
        if 'message' in req:
            request_json['message'] = req['message']
        return self.__send_command(request_json)

    def chats_add_to_black_list(self, req):
        """Add user to black list
            Activated From Version: 0.2.24
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('chats_add_to_black_list')
        allowed_params = []
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        return self.__send_command(request_json)

    def chats_add_to_chat(self, req):
        """Add user to some chat
            Activated From Version: 0.2.24
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('chats_add_to_chat')
        allowed_params = []
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        return self.__send_command(request_json)

    def chats_change_owner(self, req):
        """Change owner of the chat
            Activated From Version: 0.2.24
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('chats_change_owner')
        allowed_params = []
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        return self.__send_command(request_json)

    def chats_create_group_chat(self, req):
        """Create group chat
            Activated From Version: 0.2.24
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('chats_create_group_chat')
        allowed_params = []
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        return self.__send_command(request_json)

    def chats_delete_from_black_list(self, req):
        """Delete user from black list
            Activated From Version: 0.2.24
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('chats_delete_from_black_list')
        allowed_params = []
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        return self.__send_command(request_json)

    def chats_delete_from_chat(self, req):
        """Delete user from chat
            Activated From Version: 0.2.24
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('chats_delete_from_chat')
        allowed_params = []
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        return self.__send_command(request_json)

    def chats_dialogs_list(self, req):
        """Show list of dialogs
            Activated From Version: 0.2.24
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('chats_dialogs_list')
        allowed_params = []
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        return self.__send_command(request_json)

    def chats_message_delete(self, req):
        """Delete message from chat
            Activated From Version: 0.2.24
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                message_id (integer,required):
                    Message id for remove
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('chats_message_delete')
        allowed_params = [
            'message_id',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'message_id' not in req:
            raise Exception('Parameter "message_id" expected (lib)')
        if 'message_id' in req:
            request_json['message_id'] = req['message_id']
        return self.__send_command(request_json)

    def chats_message_edit(self, req):
        """Edit message
            Activated From Version: 0.2.24
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                message_id (integer,required):
                    Message id
                message_new (string,required):
                    New message
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('chats_message_edit')
        allowed_params = [
            'message_id',
            'message_new',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'message_id' not in req:
            raise Exception('Parameter "message_id" expected (lib)')
        if 'message_new' not in req:
            raise Exception('Parameter "message_new" expected (lib)')
        if 'message_id' in req:
            request_json['message_id'] = req['message_id']
        if 'message_new' in req:
            request_json['message_new'] = req['message_new']
        return self.__send_command(request_json)

    def chats_message_read(self, req):
        """Get all messages in chat
            Activated From Version: 0.2.24
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                chat (string,required):
                    Chat for reading messages
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('chats_message_read')
        allowed_params = [
            'chat',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'chat' not in req:
            raise Exception('Parameter "chat" expected (lib)')
        if 'chat' in req:
            request_json['chat'] = req['chat']
        return self.__send_command(request_json)

    def chats_message_send(self, req):
        """Method will be send chat message and it sent to another users
            Activated From Version: 0.2.24
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                chat (string,required):
                    Chat for sending a message
                message (string,required):
                    Message
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('chats_message_send')
        allowed_params = [
            'chat',
            'message',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'chat' not in req:
            raise Exception('Parameter "chat" expected (lib)')
        if 'message' not in req:
            raise Exception('Parameter "message" expected (lib)')
        if 'chat' in req:
            request_json['chat'] = req['chat']
        if 'message' in req:
            request_json['message'] = req['message']
        return self.__send_command(request_json)

    def classbook_add_record(self, req):
        """Adds a new article with the specified name, content, and id.
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                parentid (integer,required):
                    pareintid for classbook article
                name (string,required):
                    name of article
                content (string,required):
                    content of article
                uuid (string,optional):
                    uuid of article
                ordered (integer,optional):
                    order of article
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('classbook_add_record')
        allowed_params = [
            'parentid',
            'name',
            'content',
            'uuid',
            'ordered',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'parentid' not in req:
            raise Exception('Parameter "parentid" expected (lib)')
        if 'name' not in req:
            raise Exception('Parameter "name" expected (lib)')
        if 'content' not in req:
            raise Exception('Parameter "content" expected (lib)')
        if 'parentid' in req:
            request_json['parentid'] = req['parentid']
        if 'name' in req:
            request_json['name'] = req['name']
        if 'content' in req:
            request_json['content'] = req['content']
        if 'uuid' in req:
            request_json['uuid'] = req['uuid']
        if 'ordered' in req:
            request_json['ordered'] = req['ordered']
        return self.__send_command(request_json)

    def classbook_delete_record(self, req):
        """Delete a article with a given classbookid
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                classbookid (integer,required):
                    id for classbook article
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('classbook_delete_record')
        allowed_params = [
            'classbookid',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'classbookid' not in req:
            raise Exception('Parameter "classbookid" expected (lib)')
        if 'classbookid' in req:
            request_json['classbookid'] = req['classbookid']
        return self.__send_command(request_json)

    def classbook_export(self, req):
        """Export classbook's articles to html or markdown, optionally in zip archive.
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                output (string,required):
                    The output file format
                lang (string,required):
                    The output file format
                zip (boolean,optional):
                    Zipping the output
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('classbook_export')
        allowed_params = [
            'output',
            'lang',
            'zip',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'output' not in req:
            raise Exception('Parameter "output" expected (lib)')
        if 'lang' not in req:
            raise Exception('Parameter "lang" expected (lib)')
        if 'output' in req:
            request_json['output'] = req['output']
        if 'lang' in req:
            request_json['lang'] = req['lang']
        if 'zip' in req:
            request_json['zip'] = req['zip']
        return self.__send_command(request_json)

    def classbook_info(self, req):
        """Return name and content, langs, path classbook article with a given id
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                classbookid (integer,required):
                    id for the classbook article
                lang (string,optional):
                    Set lang for the article
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('classbook_info')
        allowed_params = [
            'classbookid',
            'lang',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'classbookid' not in req:
            raise Exception('Parameter "classbookid" expected (lib)')
        if 'classbookid' in req:
            request_json['classbookid'] = req['classbookid']
        if 'lang' in req:
            request_json['lang'] = req['lang']
        return self.__send_command(request_json)

    def classbook_list(self, req):
        """Return list of classbook articles
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                parentid (integer,required):
                    parentid for classbook articles
                lang (string,optional):
                    lang for classbook articles
                search (string,optional):
                    Search string for classbook articles
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('classbook_list')
        allowed_params = [
            'parentid',
            'lang',
            'search',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'parentid' not in req:
            raise Exception('Parameter "parentid" expected (lib)')
        if 'parentid' in req:
            request_json['parentid'] = req['parentid']
        if 'lang' in req:
            request_json['lang'] = req['lang']
        if 'search' in req:
            request_json['search'] = req['search']
        return self.__send_command(request_json)

    def classbook_localization_add_record(self, req):
        """Add a new article localization for the English version
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                classbookid (integer,required):
                    Classbookid for article localization
                lang (string,required):
                    Language
                name (string,required):
                    Article name
                content (string,required):
                    The content of the article
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('classbook_localization_add_record')
        allowed_params = [
            'classbookid',
            'lang',
            'name',
            'content',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'classbookid' not in req:
            raise Exception('Parameter "classbookid" expected (lib)')
        if 'lang' not in req:
            raise Exception('Parameter "lang" expected (lib)')
        if 'name' not in req:
            raise Exception('Parameter "name" expected (lib)')
        if 'content' not in req:
            raise Exception('Parameter "content" expected (lib)')
        if 'classbookid' in req:
            request_json['classbookid'] = req['classbookid']
        if 'lang' in req:
            request_json['lang'] = req['lang']
        if 'name' in req:
            request_json['name'] = req['name']
        if 'content' in req:
            request_json['content'] = req['content']
        return self.__send_command(request_json)

    def classbook_localization_delete_record(self, req):
        """Delete an article localization
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                classbook_localizationid (integer,required):
                    Localization id
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('classbook_localization_delete_record')
        allowed_params = [
            'classbook_localizationid',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'classbook_localizationid' not in req:
            raise Exception('Parameter "classbook_localizationid" expected (lib)')
        if 'classbook_localizationid' in req:
            request_json['classbook_localizationid'] = req['classbook_localizationid']
        return self.__send_command(request_json)

    def classbook_localization_info(self, req):
        """Find and display localization for an article by classbookid
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                classbook_localizationid (integer,required):
                    Localization id
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('classbook_localization_info')
        allowed_params = [
            'classbook_localizationid',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'classbook_localizationid' not in req:
            raise Exception('Parameter "classbook_localizationid" expected (lib)')
        if 'classbook_localizationid' in req:
            request_json['classbook_localizationid'] = req['classbook_localizationid']
        return self.__send_command(request_json)

    def classbook_localization_update_record(self, req):
        """Update table with localization by classbookid
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                classbook_localizationid (integer,required):
                    Localization id
                name (string,required):
                    Article name
                content (string,required):
                    The content of the article
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('classbook_localization_update_record')
        allowed_params = [
            'classbook_localizationid',
            'name',
            'content',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'classbook_localizationid' not in req:
            raise Exception('Parameter "classbook_localizationid" expected (lib)')
        if 'name' not in req:
            raise Exception('Parameter "name" expected (lib)')
        if 'content' not in req:
            raise Exception('Parameter "content" expected (lib)')
        if 'classbook_localizationid' in req:
            request_json['classbook_localizationid'] = req['classbook_localizationid']
        if 'name' in req:
            request_json['name'] = req['name']
        if 'content' in req:
            request_json['content'] = req['content']
        return self.__send_command(request_json)

    def classbook_propasal_approve(self, req):
        """Approve updating requests
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                classbook_proposal_id (integer,required):
                    Proposal id
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('classbook_propasal_approve')
        allowed_params = [
            'classbook_proposal_id',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'classbook_proposal_id' not in req:
            raise Exception('Parameter "classbook_proposal_id" expected (lib)')
        if 'classbook_proposal_id' in req:
            request_json['classbook_proposal_id'] = req['classbook_proposal_id']
        return self.__send_command(request_json)

    def classbook_propasal_prepare_merge_record(self, req):
        """Prepare to merge updating requests
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                classbook_proposal_id (integer,required):
                    Proposal id
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('classbook_propasal_prepare_merge_record')
        allowed_params = [
            'classbook_proposal_id',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'classbook_proposal_id' not in req:
            raise Exception('Parameter "classbook_proposal_id" expected (lib)')
        if 'classbook_proposal_id' in req:
            request_json['classbook_proposal_id'] = req['classbook_proposal_id']
        return self.__send_command(request_json)

    def classbook_propasal_update(self, req):
        """Approve updating requests
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                classbook_proposal_id (integer,required):
                    Proposal id
                content (string,required):
                    new content
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('classbook_propasal_update')
        allowed_params = [
            'classbook_proposal_id',
            'content',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'classbook_proposal_id' not in req:
            raise Exception('Parameter "classbook_proposal_id" expected (lib)')
        if 'content' not in req:
            raise Exception('Parameter "content" expected (lib)')
        if 'classbook_proposal_id' in req:
            request_json['classbook_proposal_id'] = req['classbook_proposal_id']
        if 'content' in req:
            request_json['content'] = req['content']
        return self.__send_command(request_json)

    def classbook_proposal_add_record(self, req):
        """Propose an update of article
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                classbookid (integer,required):
                    Classbookid for an article
                lang (string,required):
                    Language
                name (string,required):
                    Article name
                content (string,required):
                    The content of the article
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('classbook_proposal_add_record')
        allowed_params = [
            'classbookid',
            'lang',
            'name',
            'content',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'classbookid' not in req:
            raise Exception('Parameter "classbookid" expected (lib)')
        if 'lang' not in req:
            raise Exception('Parameter "lang" expected (lib)')
        if 'name' not in req:
            raise Exception('Parameter "name" expected (lib)')
        if 'content' not in req:
            raise Exception('Parameter "content" expected (lib)')
        if 'classbookid' in req:
            request_json['classbookid'] = req['classbookid']
        if 'lang' in req:
            request_json['lang'] = req['lang']
        if 'name' in req:
            request_json['name'] = req['name']
        if 'content' in req:
            request_json['content'] = req['content']
        return self.__send_command(request_json)

    def classbook_proposal_delete_record(self, req):
        """Delete a proposal of updating an article
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                classbook_proposal_id (integer,required):
                    Proposal id
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('classbook_proposal_delete_record')
        allowed_params = [
            'classbook_proposal_id',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'classbook_proposal_id' not in req:
            raise Exception('Parameter "classbook_proposal_id" expected (lib)')
        if 'classbook_proposal_id' in req:
            request_json['classbook_proposal_id'] = req['classbook_proposal_id']
        return self.__send_command(request_json)

    def classbook_proposal_info(self, req):
        """Find and display all proposal data by id
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                classbook_proposal_id (integer,required):
                    Proposal id
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('classbook_proposal_info')
        allowed_params = [
            'classbook_proposal_id',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'classbook_proposal_id' not in req:
            raise Exception('Parameter "classbook_proposal_id" expected (lib)')
        if 'classbook_proposal_id' in req:
            request_json['classbook_proposal_id'] = req['classbook_proposal_id']
        return self.__send_command(request_json)

    def classbook_proposal_list(self, req):
        """Display list of proposals by classbookid
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                classbookid (integer,required):
                    Classbookid for an article
                lang (string,optional):
                    Language
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('classbook_proposal_list')
        allowed_params = [
            'classbookid',
            'lang',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'classbookid' not in req:
            raise Exception('Parameter "classbookid" expected (lib)')
        if 'classbookid' in req:
            request_json['classbookid'] = req['classbookid']
        if 'lang' in req:
            request_json['lang'] = req['lang']
        return self.__send_command(request_json)

    def classbook_update_record(self, req):
        """Update a article with a given classbookid
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                classbookid (integer,required):
                    id for classbook article
                name (string,optional):
                    name for classbook article
                content (string,optional):
                    content for classbook article
                ordered (integer,optional):
                    ordered for classbook article
                parentid (integer,optional):
                    parentid for classbook article
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('classbook_update_record')
        allowed_params = [
            'classbookid',
            'name',
            'content',
            'ordered',
            'parentid',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'classbookid' not in req:
            raise Exception('Parameter "classbookid" expected (lib)')
        if 'classbookid' in req:
            request_json['classbookid'] = req['classbookid']
        if 'name' in req:
            request_json['name'] = req['name']
        if 'content' in req:
            request_json['content'] = req['content']
        if 'ordered' in req:
            request_json['ordered'] = req['ordered']
        if 'parentid' in req:
            request_json['parentid'] = req['parentid']
        return self.__send_command(request_json)

    def createpublicevent(self, req):
        """Create the public event
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                type (string,required):
                    Type of event
                message (string,required):
                    Message
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('createpublicevent')
        allowed_params = [
            'type',
            'message',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'type' not in req:
            raise Exception('Parameter "type" expected (lib)')
        if 'message' not in req:
            raise Exception('Parameter "message" expected (lib)')
        if 'type' in req:
            request_json['type'] = req['type']
        if 'message' in req:
            request_json['message'] = req['message']
        return self.__send_command(request_json)

    def createquest(self, req):
        """Method will be create new quest
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                uuid (string,required):
                    Global Identificator of the quest
                gameid (integer,required):
                    Which game included this quest
                name (string,required):
                    Name of the quest
                text (string,required):
                    Description of the quest
                score (integer,required):
                    How much append to user score after solve quest by them
                author (string,required):
                    Author of the quest
                subject (string,required):
                    Subject must be one from types
                answer (string,required):
                    Answer for the quest
                answer_format (string,required):
                    Answer format for the quest
                state (string,required):
                    State of the quest
                description_state (string,required):
                    You can add some descriptions for quest state
                copyright (string,optional):
                    You can add some copyright information
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('createquest')
        allowed_params = [
            'uuid',
            'gameid',
            'name',
            'text',
            'score',
            'author',
            'subject',
            'answer',
            'answer_format',
            'state',
            'description_state',
            'copyright',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'uuid' not in req:
            raise Exception('Parameter "uuid" expected (lib)')
        if 'gameid' not in req:
            raise Exception('Parameter "gameid" expected (lib)')
        if 'name' not in req:
            raise Exception('Parameter "name" expected (lib)')
        if 'text' not in req:
            raise Exception('Parameter "text" expected (lib)')
        if 'score' not in req:
            raise Exception('Parameter "score" expected (lib)')
        if 'author' not in req:
            raise Exception('Parameter "author" expected (lib)')
        if 'subject' not in req:
            raise Exception('Parameter "subject" expected (lib)')
        if 'answer' not in req:
            raise Exception('Parameter "answer" expected (lib)')
        if 'answer_format' not in req:
            raise Exception('Parameter "answer_format" expected (lib)')
        if 'state' not in req:
            raise Exception('Parameter "state" expected (lib)')
        if 'description_state' not in req:
            raise Exception('Parameter "description_state" expected (lib)')
        if 'uuid' in req:
            request_json['uuid'] = req['uuid']
        if 'gameid' in req:
            request_json['gameid'] = req['gameid']
        if 'name' in req:
            request_json['name'] = req['name']
        if 'text' in req:
            request_json['text'] = req['text']
        if 'score' in req:
            request_json['score'] = req['score']
        if 'author' in req:
            request_json['author'] = req['author']
        if 'subject' in req:
            request_json['subject'] = req['subject']
        if 'answer' in req:
            request_json['answer'] = req['answer']
        if 'answer_format' in req:
            request_json['answer_format'] = req['answer_format']
        if 'state' in req:
            request_json['state'] = req['state']
        if 'description_state' in req:
            request_json['description_state'] = req['description_state']
        if 'copyright' in req:
            request_json['copyright'] = req['copyright']
        return self.__send_command(request_json)

    def deletehint(self, req):
        """Method for delete hint from quest
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                hintid (integer,required):
                    hint id
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('deletehint')
        allowed_params = [
            'hintid',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'hintid' not in req:
            raise Exception('Parameter "hintid" expected (lib)')
        if 'hintid' in req:
            request_json['hintid'] = req['hintid']
        return self.__send_command(request_json)

    def deletepublicevent(self, req):
        """Delete public event
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                eventid (integer,required):
                    Event ID
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('deletepublicevent')
        allowed_params = [
            'eventid',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'eventid' not in req:
            raise Exception('Parameter "eventid" expected (lib)')
        if 'eventid' in req:
            request_json['eventid'] = req['eventid']
        return self.__send_command(request_json)

    def feedback_add(self, req):
        """Create the feedback
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                from (string,required):
                    From user
                text (string,required):
                    Text of feedback
                type (string,required):
                    Type of feedback
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('feedback_add')
        allowed_params = [
            'from',
            'text',
            'type',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'from' not in req:
            raise Exception('Parameter "from" expected (lib)')
        if 'text' not in req:
            raise Exception('Parameter "text" expected (lib)')
        if 'type' not in req:
            raise Exception('Parameter "type" expected (lib)')
        if 'from' in req:
            request_json['from'] = req['from']
        if 'text' in req:
            request_json['text'] = req['text']
        if 'type' in req:
            request_json['type'] = req['type']
        return self.__send_command(request_json)

    def game_create(self, req):
        """Create the game
            Activated From Version: 0.2.0
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                uuid (string,required):
                    Global Identificator of the Game
                name (string,required):
                    Name of the Game
                description (string,required):
                    Description of the Game
                state (string,required):
                    State of the game
                form (string,required):
                    Form of the game
                type (string,required):
                    Type of the game
                date_start (string,required):
                    Date start
                date_stop (string,required):
                    Date stop
                date_restart (string,required):
                    Date restart
                organizators (string,required):
                    Organizators
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('game_create')
        allowed_params = [
            'uuid',
            'name',
            'description',
            'state',
            'form',
            'type',
            'date_start',
            'date_stop',
            'date_restart',
            'organizators',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'uuid' not in req:
            raise Exception('Parameter "uuid" expected (lib)')
        if 'name' not in req:
            raise Exception('Parameter "name" expected (lib)')
        if 'description' not in req:
            raise Exception('Parameter "description" expected (lib)')
        if 'state' not in req:
            raise Exception('Parameter "state" expected (lib)')
        if 'form' not in req:
            raise Exception('Parameter "form" expected (lib)')
        if 'type' not in req:
            raise Exception('Parameter "type" expected (lib)')
        if 'date_start' not in req:
            raise Exception('Parameter "date_start" expected (lib)')
        if 'date_stop' not in req:
            raise Exception('Parameter "date_stop" expected (lib)')
        if 'date_restart' not in req:
            raise Exception('Parameter "date_restart" expected (lib)')
        if 'organizators' not in req:
            raise Exception('Parameter "organizators" expected (lib)')
        if 'uuid' in req:
            request_json['uuid'] = req['uuid']
        if 'name' in req:
            request_json['name'] = req['name']
        if 'description' in req:
            request_json['description'] = req['description']
        if 'state' in req:
            request_json['state'] = req['state']
        if 'form' in req:
            request_json['form'] = req['form']
        if 'type' in req:
            request_json['type'] = req['type']
        if 'date_start' in req:
            request_json['date_start'] = req['date_start']
        if 'date_stop' in req:
            request_json['date_stop'] = req['date_stop']
        if 'date_restart' in req:
            request_json['date_restart'] = req['date_restart']
        if 'organizators' in req:
            request_json['organizators'] = req['organizators']
        return self.__send_command(request_json)

    def game_delete(self, req):
        """Remove game and all quests
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                uuid (string,required):
                    Global Identificator of the Game
                admin_password (string,required):
                    Admin Password
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('game_delete')
        allowed_params = [
            'uuid',
            'admin_password',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'uuid' not in req:
            raise Exception('Parameter "uuid" expected (lib)')
        if 'admin_password' not in req:
            raise Exception('Parameter "admin_password" expected (lib)')
        if 'uuid' in req:
            request_json['uuid'] = req['uuid']
        if 'admin_password' in req:
            request_json['admin_password'] = req['admin_password']
        return self.__send_command(request_json)

    def game_export(self, req):
        """Export the game
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                uuid (string,required):
                    Global Identificator of the Game
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('game_export')
        allowed_params = [
            'uuid',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'uuid' not in req:
            raise Exception('Parameter "uuid" expected (lib)')
        if 'uuid' in req:
            request_json['uuid'] = req['uuid']
        return self.__send_command(request_json)

    def game_import(self, req):
        """Import game
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                uuid (string,required):
                    Global Identificator of the Game
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('game_import')
        allowed_params = [
            'uuid',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'uuid' not in req:
            raise Exception('Parameter "uuid" expected (lib)')
        if 'uuid' in req:
            request_json['uuid'] = req['uuid']
        return self.__send_command(request_json)

    def game_info(self, req):
        """Return game info
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                uuid (string,required):
                    Global Identificator of the Game
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('game_info')
        allowed_params = [
            'uuid',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'uuid' not in req:
            raise Exception('Parameter "uuid" expected (lib)')
        if 'uuid' in req:
            request_json['uuid'] = req['uuid']
        return self.__send_command(request_json)

    def game_update(self, req):
        """Update game info
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                uuid (string,required):
                    Global Identificator of the Game
                name (string,optional):
                    Name of the Game
                description (string,optional):
                    Description of the Game
                state (string,optional):
                    State of the game
                form (string,optional):
                    Form of the game
                type (string,optional):
                    Type of the game
                date_start (string,optional):
                    Date start
                date_stop (string,optional):
                    Date stop
                date_restart (string,optional):
                    Date restart
                organizators (string,optional):
                    Organizators
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('game_update')
        allowed_params = [
            'uuid',
            'name',
            'description',
            'state',
            'form',
            'type',
            'date_start',
            'date_stop',
            'date_restart',
            'organizators',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'uuid' not in req:
            raise Exception('Parameter "uuid" expected (lib)')
        if 'uuid' in req:
            request_json['uuid'] = req['uuid']
        if 'name' in req:
            request_json['name'] = req['name']
        if 'description' in req:
            request_json['description'] = req['description']
        if 'state' in req:
            request_json['state'] = req['state']
        if 'form' in req:
            request_json['form'] = req['form']
        if 'type' in req:
            request_json['type'] = req['type']
        if 'date_start' in req:
            request_json['date_start'] = req['date_start']
        if 'date_stop' in req:
            request_json['date_stop'] = req['date_stop']
        if 'date_restart' in req:
            request_json['date_restart'] = req['date_restart']
        if 'organizators' in req:
            request_json['organizators'] = req['organizators']
        return self.__send_command(request_json)

    def game_update_logo(self, req):
        """Update game logo
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                uuid (string,required):
                    Global Identificator of the Game
                image_png_base64 (string,required):
                    Image PNG in Base64
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('game_update_logo')
        allowed_params = [
            'uuid',
            'image_png_base64',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'uuid' not in req:
            raise Exception('Parameter "uuid" expected (lib)')
        if 'image_png_base64' not in req:
            raise Exception('Parameter "image_png_base64" expected (lib)')
        if 'uuid' in req:
            request_json['uuid'] = req['uuid']
        if 'image_png_base64' in req:
            request_json['image_png_base64'] = req['image_png_base64']
        return self.__send_command(request_json)

    def games(self, req):
        """Method returned list of games
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('games')
        allowed_params = []
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        return self.__send_command(request_json)

    def getmap(self, req):
        """Returned coordinate list
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('getmap')
        allowed_params = []
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        return self.__send_command(request_json)

    def getpublicevent(self, req):
        """Return public event info by id
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                eventid (integer,required):
                    Event id
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('getpublicevent')
        allowed_params = [
            'eventid',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'eventid' not in req:
            raise Exception('Parameter "eventid" expected (lib)')
        if 'eventid' in req:
            request_json['eventid'] = req['eventid']
        return self.__send_command(request_json)

    def hints(self, req):
        """Return list of hints
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                questid (integer,required):
                    Quest id
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('hints')
        allowed_params = [
            'questid',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'questid' not in req:
            raise Exception('Parameter "questid" expected (lib)')
        if 'questid' in req:
            request_json['questid'] = req['questid']
        return self.__send_command(request_json)

    def leaks_add(self, req):
        """Method adds a leak
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                uuid (string,required):
                    UUID of the leak
                game_uuid (string,required):
                    UUID of the game
                name (string,required):
                    Visible part of the content
                content (string,required):
                    Content of the leak
                score (integer,required):
                    Price of the leak
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('leaks_add')
        allowed_params = [
            'uuid',
            'game_uuid',
            'name',
            'content',
            'score',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'uuid' not in req:
            raise Exception('Parameter "uuid" expected (lib)')
        if 'game_uuid' not in req:
            raise Exception('Parameter "game_uuid" expected (lib)')
        if 'name' not in req:
            raise Exception('Parameter "name" expected (lib)')
        if 'content' not in req:
            raise Exception('Parameter "content" expected (lib)')
        if 'score' not in req:
            raise Exception('Parameter "score" expected (lib)')
        if 'uuid' in req:
            request_json['uuid'] = req['uuid']
        if 'game_uuid' in req:
            request_json['game_uuid'] = req['game_uuid']
        if 'name' in req:
            request_json['name'] = req['name']
        if 'content' in req:
            request_json['content'] = req['content']
        if 'score' in req:
            request_json['score'] = req['score']
        return self.__send_command(request_json)

    def leaks_buy(self, req):
        """Method buys a leak
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                id (integer,required):
                    Leak id
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('leaks_buy')
        allowed_params = [
            'id',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'id' not in req:
            raise Exception('Parameter "id" expected (lib)')
        if 'id' in req:
            request_json['id'] = req['id']
        return self.__send_command(request_json)

    def leaks_delete(self, req):
        """Method deletes a leak
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                id (integer,required):
                    Leak id
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('leaks_delete')
        allowed_params = [
            'id',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'id' not in req:
            raise Exception('Parameter "id" expected (lib)')
        if 'id' in req:
            request_json['id'] = req['id']
        return self.__send_command(request_json)

    def leaks_list(self, req):
        """Method returns list of leaks
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                page (integer,required):
                    Number of page
                onpage (integer,required):
                    How much rows in one page
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('leaks_list')
        allowed_params = [
            'page',
            'onpage',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'page' not in req:
            raise Exception('Parameter "page" expected (lib)')
        if 'onpage' not in req:
            raise Exception('Parameter "onpage" expected (lib)')
        if 'page' in req:
            request_json['page'] = req['page']
        if 'onpage' in req:
            request_json['onpage'] = req['onpage']
        return self.__send_command(request_json)

    def leaks_update(self, req):
        """Method updates a leak
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                id (integer,required):
                    Leak id
                name (string,optional):
                    Visible part of the content
                content (string,optional):
                    Content of the leak
                score (integer,optional):
                    Price of the leak
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('leaks_update')
        allowed_params = [
            'id',
            'name',
            'content',
            'score',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'id' not in req:
            raise Exception('Parameter "id" expected (lib)')
        if 'id' in req:
            request_json['id'] = req['id']
        if 'name' in req:
            request_json['name'] = req['name']
        if 'content' in req:
            request_json['content'] = req['content']
        if 'score' in req:
            request_json['score'] = req['score']
        return self.__send_command(request_json)

    def login(self, req):
        """Method for login
            Permissins:
                Allowed access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                email (string,required):
                    E-mail
                password (string,required):
                    Password
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('login')
        allowed_params = [
            'email',
            'password',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'email' not in req:
            raise Exception('Parameter "email" expected (lib)')
        if 'password' not in req:
            raise Exception('Parameter "password" expected (lib)')
        if 'email' in req:
            request_json['email'] = req['email']
        if 'password' in req:
            request_json['password'] = req['password']
        return self.__send_command(request_json)

    def lxd_containers(self, req):
        """Any actions with the container. Actions: create, start, stop and delete container
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                name (string,required):
                    Container name
                action (string,required):
                    Actions: create, start, stop and delete container
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('lxd_containers')
        allowed_params = [
            'name',
            'action',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'name' not in req:
            raise Exception('Parameter "name" expected (lib)')
        if 'action' not in req:
            raise Exception('Parameter "action" expected (lib)')
        if 'name' in req:
            request_json['name'] = req['name']
        if 'action' in req:
            request_json['action'] = req['action']
        return self.__send_command(request_json)

    def lxd_exec(self, req):
        """Exec command in the container with name.
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                name (string,required):
                    Container name
                command (string,required):
                    Name of execution command
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('lxd_exec')
        allowed_params = [
            'name',
            'command',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'name' not in req:
            raise Exception('Parameter "name" expected (lib)')
        if 'command' not in req:
            raise Exception('Parameter "command" expected (lib)')
        if 'name' in req:
            request_json['name'] = req['name']
        if 'command' in req:
            request_json['command'] = req['command']
        return self.__send_command(request_json)

    def lxd_file(self, req):
        """Pull, push, delete file inside the container.
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                name (string,required):
                    Container name
                action (string,required):
                    Action with files: pull, push or delete
                path (string,required):
                    Path to file inside the container
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('lxd_file')
        allowed_params = [
            'name',
            'action',
            'path',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'name' not in req:
            raise Exception('Parameter "name" expected (lib)')
        if 'action' not in req:
            raise Exception('Parameter "action" expected (lib)')
        if 'path' not in req:
            raise Exception('Parameter "path" expected (lib)')
        if 'name' in req:
            request_json['name'] = req['name']
        if 'action' in req:
            request_json['action'] = req['action']
        if 'path' in req:
            request_json['path'] = req['path']
        return self.__send_command(request_json)

    def lxd_import_container(self, req):
        """Import container from json configuration.
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                config (string,required):
                    Container's configuration in json dumped string.
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('lxd_import_container')
        allowed_params = [
            'config',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'config' not in req:
            raise Exception('Parameter "config" expected (lib)')
        if 'config' in req:
            request_json['config'] = req['config']
        return self.__send_command(request_json)

    def lxd_import_service_from_zip(self, req):
        """Import Service from zip.
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                zip_file (string,required):
                    Service's configuration in Base64 zip archive.
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('lxd_import_service_from_zip')
        allowed_params = [
            'zip_file',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'zip_file' not in req:
            raise Exception('Parameter "zip_file" expected (lib)')
        if 'zip_file' in req:
            request_json['zip_file'] = req['zip_file']
        return self.__send_command(request_json)

    def lxd_info(self, req):
        """Get information about the orhestra, containers.
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                name (string,required):
                    Container name
                get (string,optional):
                    Requested information
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('lxd_info')
        allowed_params = [
            'name',
            'get',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'name' not in req:
            raise Exception('Parameter "name" expected (lib)')
        if 'name' in req:
            request_json['name'] = req['name']
        if 'get' in req:
            request_json['get'] = req['get']
        return self.__send_command(request_json)

    def lxd_list(self, req):
        """Get information about all containers.
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('lxd_list')
        allowed_params = []
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        return self.__send_command(request_json)

    def lxd_open_port(self, req):
        """Opens the container port.
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                name (string,required):
                    Container name
                port (integer,required):
                    Number container port
                protocol (string,required):
                    Protocol
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('lxd_open_port')
        allowed_params = [
            'name',
            'port',
            'protocol',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'name' not in req:
            raise Exception('Parameter "name" expected (lib)')
        if 'port' not in req:
            raise Exception('Parameter "port" expected (lib)')
        if 'protocol' not in req:
            raise Exception('Parameter "protocol" expected (lib)')
        if 'name' in req:
            request_json['name'] = req['name']
        if 'port' in req:
            request_json['port'] = req['port']
        if 'protocol' in req:
            request_json['protocol'] = req['protocol']
        return self.__send_command(request_json)

    def lxd_start_service(self, req):
        """Start service.
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                name (string,required):
                    Service's name.
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('lxd_start_service')
        allowed_params = [
            'name',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'name' not in req:
            raise Exception('Parameter "name" expected (lib)')
        if 'name' in req:
            request_json['name'] = req['name']
        return self.__send_command(request_json)

    def mail_info(self, req):
        """This method Will be return info of mail
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('mail_info')
        allowed_params = []
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        return self.__send_command(request_json)

    def mail_send(self, req):
        """Mail Send
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                to (string,required):
                    E-mail of the recipient
                subject (string,required):
                    Subject of the message
                body (string,required):
                    Body of the message
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('mail_send')
        allowed_params = [
            'to',
            'subject',
            'body',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'to' not in req:
            raise Exception('Parameter "to" expected (lib)')
        if 'subject' not in req:
            raise Exception('Parameter "subject" expected (lib)')
        if 'body' not in req:
            raise Exception('Parameter "body" expected (lib)')
        if 'to' in req:
            request_json['to'] = req['to']
        if 'subject' in req:
            request_json['subject'] = req['subject']
        if 'body' in req:
            request_json['body'] = req['body']
        return self.__send_command(request_json)

    def mails_list(self, req):
        """Mails list
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                filter_email (string,optional):
                    Filter by email
                filter_subject (string,optional):
                    Filter by subject
                filter_message (string,optional):
                    Filter by message
                onpage (integer,optional):
                    On page
                page (integer,optional):
                    page
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('mails_list')
        allowed_params = [
            'filter_email',
            'filter_subject',
            'filter_message',
            'onpage',
            'page',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'filter_email' in req:
            request_json['filter_email'] = req['filter_email']
        if 'filter_subject' in req:
            request_json['filter_subject'] = req['filter_subject']
        if 'filter_message' in req:
            request_json['filter_message'] = req['filter_message']
        if 'onpage' in req:
            request_json['onpage'] = req['onpage']
        if 'page' in req:
            request_json['page'] = req['page']
        return self.__send_command(request_json)

    def public_info(self, req):
        """Method return public information about server
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('public_info')
        allowed_params = []
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        return self.__send_command(request_json)

    def publiceventslist(self, req):
        """Return list of public events
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                page (integer,required):
                    Number of page
                onpage (integer,required):
                    How much rows in one page
                type (string,optional):
                    Filter by type events
                search (string,optional):
                    Filter by message event
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('publiceventslist')
        allowed_params = [
            'page',
            'onpage',
            'type',
            'search',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'page' not in req:
            raise Exception('Parameter "page" expected (lib)')
        if 'onpage' not in req:
            raise Exception('Parameter "onpage" expected (lib)')
        if 'page' in req:
            request_json['page'] = req['page']
        if 'onpage' in req:
            request_json['onpage'] = req['onpage']
        if 'type' in req:
            request_json['type'] = req['type']
        if 'search' in req:
            request_json['search'] = req['search']
        return self.__send_command(request_json)

    def quest(self, req):
        """Update the quest info
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                questid (integer,required):
                    Quest ID
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('quest')
        allowed_params = [
            'questid',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'questid' not in req:
            raise Exception('Parameter "questid" expected (lib)')
        if 'questid' in req:
            request_json['questid'] = req['questid']
        return self.__send_command(request_json)

    def quest_delete(self, req):
        """Method for delete quest
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                questid (integer,required):
                    Quest ID
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('quest_delete')
        allowed_params = [
            'questid',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'questid' not in req:
            raise Exception('Parameter "questid" expected (lib)')
        if 'questid' in req:
            request_json['questid'] = req['questid']
        return self.__send_command(request_json)

    def quest_pass(self, req):
        """Quest pass
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                questid (integer,required):
                    Quest ID
                answer (string,required):
                    Answer
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('quest_pass')
        allowed_params = [
            'questid',
            'answer',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'questid' not in req:
            raise Exception('Parameter "questid" expected (lib)')
        if 'answer' not in req:
            raise Exception('Parameter "answer" expected (lib)')
        if 'questid' in req:
            request_json['questid'] = req['questid']
        if 'answer' in req:
            request_json['answer'] = req['answer']
        return self.__send_command(request_json)

    def quest_proposal(self, req):
        """Add quest proposal
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                gameid (integer,required):
                    Which game included this quest
                name (string,required):
                    Name of the quest
                text (string,required):
                    Description of the quest
                score (integer,required):
                    How much append to user score after solve quest by them
                author (string,required):
                    Author of the quest
                subject (string,required):
                    Subject must be one from types (look types)
                answer (string,required):
                    Answer for the quest
                answer_format (string,required):
                    Answer format for the quest
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('quest_proposal')
        allowed_params = [
            'gameid',
            'name',
            'text',
            'score',
            'author',
            'subject',
            'answer',
            'answer_format',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'gameid' not in req:
            raise Exception('Parameter "gameid" expected (lib)')
        if 'name' not in req:
            raise Exception('Parameter "name" expected (lib)')
        if 'text' not in req:
            raise Exception('Parameter "text" expected (lib)')
        if 'score' not in req:
            raise Exception('Parameter "score" expected (lib)')
        if 'author' not in req:
            raise Exception('Parameter "author" expected (lib)')
        if 'subject' not in req:
            raise Exception('Parameter "subject" expected (lib)')
        if 'answer' not in req:
            raise Exception('Parameter "answer" expected (lib)')
        if 'answer_format' not in req:
            raise Exception('Parameter "answer_format" expected (lib)')
        if 'gameid' in req:
            request_json['gameid'] = req['gameid']
        if 'name' in req:
            request_json['name'] = req['name']
        if 'text' in req:
            request_json['text'] = req['text']
        if 'score' in req:
            request_json['score'] = req['score']
        if 'author' in req:
            request_json['author'] = req['author']
        if 'subject' in req:
            request_json['subject'] = req['subject']
        if 'answer' in req:
            request_json['answer'] = req['answer']
        if 'answer_format' in req:
            request_json['answer_format'] = req['answer_format']
        return self.__send_command(request_json)

    def quest_statistics(self, req):
        """Mehtod will be return quest public statistics
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                questid (integer,required):
                    Quest ID
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('quest_statistics')
        allowed_params = [
            'questid',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'questid' not in req:
            raise Exception('Parameter "questid" expected (lib)')
        if 'questid' in req:
            request_json['questid'] = req['questid']
        return self.__send_command(request_json)

    def quest_update(self, req):
        """Update the quest info
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                questid (integer,required):
                    Quest ID
                name (string,optional):
                    Name of the quest
                gameid (integer,optional):
                    Which game included this quest
                text (string,optional):
                    Description of the quest
                score (integer,optional):
                    How much append to user score after solve quest by them
                subject (string,optional):
                    Subject must be one from types
                author (string,optional):
                    Author of the quest
                answer (string,optional):
                    Answer for the quest
                answer_format (string,optional):
                    Answer format for the quest
                state (string,optional):
                    State of the quest
                description_state (string,optional):
                    You can update some descriptions for quest state
                copyright (string,optional):
                    You can update copyright
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('quest_update')
        allowed_params = [
            'questid',
            'name',
            'gameid',
            'text',
            'score',
            'subject',
            'author',
            'answer',
            'answer_format',
            'state',
            'description_state',
            'copyright',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'questid' not in req:
            raise Exception('Parameter "questid" expected (lib)')
        if 'questid' in req:
            request_json['questid'] = req['questid']
        if 'name' in req:
            request_json['name'] = req['name']
        if 'gameid' in req:
            request_json['gameid'] = req['gameid']
        if 'text' in req:
            request_json['text'] = req['text']
        if 'score' in req:
            request_json['score'] = req['score']
        if 'subject' in req:
            request_json['subject'] = req['subject']
        if 'author' in req:
            request_json['author'] = req['author']
        if 'answer' in req:
            request_json['answer'] = req['answer']
        if 'answer_format' in req:
            request_json['answer_format'] = req['answer_format']
        if 'state' in req:
            request_json['state'] = req['state']
        if 'description_state' in req:
            request_json['description_state'] = req['description_state']
        if 'copyright' in req:
            request_json['copyright'] = req['copyright']
        return self.__send_command(request_json)

    def quests(self, req):
        """Method will be returned quest list
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                subject (string,optional):
                    Filter by subject
                gameid (integer,optional):
                    Filter by local gameid
                filter (string,optional):
                    Filter by some text
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('quests')
        allowed_params = [
            'subject',
            'gameid',
            'filter',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'subject' in req:
            request_json['subject'] = req['subject']
        if 'gameid' in req:
            request_json['gameid'] = req['gameid']
        if 'filter' in req:
            request_json['filter'] = req['filter']
        return self.__send_command(request_json)

    def quests_files_upload(self, req):
        """Update the quest
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                quest_uuid (string,required):
                    Quest UUID
                file_base64 (string,required):
                    Byte-array encoded in base64
                file_name (string,required):
                    File name
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('quests_files_upload')
        allowed_params = [
            'quest_uuid',
            'file_base64',
            'file_name',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'quest_uuid' not in req:
            raise Exception('Parameter "quest_uuid" expected (lib)')
        if 'file_base64' not in req:
            raise Exception('Parameter "file_base64" expected (lib)')
        if 'file_name' not in req:
            raise Exception('Parameter "file_name" expected (lib)')
        if 'quest_uuid' in req:
            request_json['quest_uuid'] = req['quest_uuid']
        if 'file_base64' in req:
            request_json['file_base64'] = req['file_base64']
        if 'file_name' in req:
            request_json['file_name'] = req['file_name']
        return self.__send_command(request_json)

    def quests_proposal_list(self, req):
        """Quests proposal list
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                page_size (integer,optional):
                    Page size
                page_index (integer,optional):
                    Page index
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('quests_proposal_list')
        allowed_params = [
            'page_size',
            'page_index',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'page_size' in req:
            request_json['page_size'] = req['page_size']
        if 'page_index' in req:
            request_json['page_index'] = req['page_index']
        return self.__send_command(request_json)

    def quests_subjects(self, req):
        """Method returned list of quests by subjects
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('quests_subjects')
        allowed_params = []
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        return self.__send_command(request_json)

    def quests_user_answer_list(self, req):
        """Return user answers list
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                questid (integer,required):
                    Filter for questid
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('quests_user_answer_list')
        allowed_params = [
            'questid',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'questid' not in req:
            raise Exception('Parameter "questid" expected (lib)')
        if 'questid' in req:
            request_json['questid'] = req['questid']
        return self.__send_command(request_json)

    def quests_writeups_delete(self, req):
        """This method will be remove writeup
            Activated From Version: 0.2.18
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                writeupid (integer,required):
                    WriteUp ID
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('quests_writeups_delete')
        allowed_params = [
            'writeupid',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'writeupid' not in req:
            raise Exception('Parameter "writeupid" expected (lib)')
        if 'writeupid' in req:
            request_json['writeupid'] = req['writeupid']
        return self.__send_command(request_json)

    def quests_writeups_list(self, req):
        """This method will be returned list of writeups by questid
            Activated From Version: 0.2.18
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                questid (integer,required):
                    Quest ID
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('quests_writeups_list')
        allowed_params = [
            'questid',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'questid' not in req:
            raise Exception('Parameter "questid" expected (lib)')
        if 'questid' in req:
            request_json['questid'] = req['questid']
        return self.__send_command(request_json)

    def quests_writeups_proposal(self, req):
        """This method will be add writeup from authorized user
            Activated From Version: 0.2.18
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                questid (integer,required):
                    Quest ID
                writeup_link (string,required):
                    Link to writeup (Must be start from https://www.youtube.com/watch?v=)
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('quests_writeups_proposal')
        allowed_params = [
            'questid',
            'writeup_link',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'questid' not in req:
            raise Exception('Parameter "questid" expected (lib)')
        if 'writeup_link' not in req:
            raise Exception('Parameter "writeup_link" expected (lib)')
        if 'questid' in req:
            request_json['questid'] = req['questid']
        if 'writeup_link' in req:
            request_json['writeup_link'] = req['writeup_link']
        return self.__send_command(request_json)

    def quests_writeups_update(self, req):
        """This method will be update writeup approve now
            Activated From Version: 0.2.18
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                writeupid (integer,required):
                    WriteUp ID
                approve (string,required):
                    Approve value 1 or 0
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('quests_writeups_update')
        allowed_params = [
            'writeupid',
            'approve',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'writeupid' not in req:
            raise Exception('Parameter "writeupid" expected (lib)')
        if 'approve' not in req:
            raise Exception('Parameter "approve" expected (lib)')
        if 'writeupid' in req:
            request_json['writeupid'] = req['writeupid']
        if 'approve' in req:
            request_json['approve'] = req['approve']
        return self.__send_command(request_json)

    def registration(self, req):
        """Method for registration
            Permissins:
                Allowed access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                email (string,required):
                    E-mail
                university (string,required):
                    University
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('registration')
        allowed_params = [
            'email',
            'university',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'email' not in req:
            raise Exception('Parameter "email" expected (lib)')
        if 'university' not in req:
            raise Exception('Parameter "university" expected (lib)')
        if 'email' in req:
            request_json['email'] = req['email']
        if 'university' in req:
            request_json['university'] = req['university']
        return self.__send_command(request_json)

    def scoreboard(self, req):
        """Method return scoreboard
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                page (integer,required):
                    Number of page
                onpage (integer,required):
                    How much rows in one page
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('scoreboard')
        allowed_params = [
            'page',
            'onpage',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'page' not in req:
            raise Exception('Parameter "page" expected (lib)')
        if 'onpage' not in req:
            raise Exception('Parameter "onpage" expected (lib)')
        if 'page' in req:
            request_json['page'] = req['page']
        if 'onpage' in req:
            request_json['onpage'] = req['onpage']
        return self.__send_command(request_json)

    def server_api(self, req):
        """This method Will be return list of all handlers
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('server_api')
        allowed_params = []
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        return self.__send_command(request_json)

    def server_info(self, req):
        """Return server private information
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('server_info')
        allowed_params = []
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        return self.__send_command(request_json)

    def server_settings(self, req):
        """Return server settings
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('server_settings')
        allowed_params = []
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        return self.__send_command(request_json)

    def server_settings_update(self, req):
        """Update server settings
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                name (string,required):
                    name of setting
                value (string,required):
                    value of setting
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('server_settings_update')
        allowed_params = [
            'name',
            'value',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'name' not in req:
            raise Exception('Parameter "name" expected (lib)')
        if 'value' not in req:
            raise Exception('Parameter "value" expected (lib)')
        if 'name' in req:
            request_json['name'] = req['name']
        if 'value' in req:
            request_json['value'] = req['value']
        return self.__send_command(request_json)

    def token(self, req):
        """Method for login by token
            Permissins:
                Allowed access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                token (string,required):
                    Authorization token
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('token')
        allowed_params = [
            'token',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'token' not in req:
            raise Exception('Parameter "token" expected (lib)')
        if 'token' in req:
            request_json['token'] = req['token']
        return self.__send_command(request_json)

    def updateuserlocation(self, req):
        """This method will be try update user location by lastip
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                userid (integer,required):
                    User ID
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('updateuserlocation')
        allowed_params = [
            'userid',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'userid' not in req:
            raise Exception('Parameter "userid" expected (lib)')
        if 'userid' in req:
            request_json['userid'] = req['userid']
        return self.__send_command(request_json)

    def useful_links_add(self, req):
        """Method for add new useful link
            Activated From Version: 0.2.21
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                url (string,required):
                    URL
                description (string,required):
                    Description
                author (string,required):
                    Author
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('useful_links_add')
        allowed_params = [
            'url',
            'description',
            'author',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'url' not in req:
            raise Exception('Parameter "url" expected (lib)')
        if 'description' not in req:
            raise Exception('Parameter "description" expected (lib)')
        if 'author' not in req:
            raise Exception('Parameter "author" expected (lib)')
        if 'url' in req:
            request_json['url'] = req['url']
        if 'description' in req:
            request_json['description'] = req['description']
        if 'author' in req:
            request_json['author'] = req['author']
        return self.__send_command(request_json)

    def useful_links_clicked(self, req):
        """Useful Links removed from favorite
            Activated From Version: 0.2.29
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                useful_link_id (integer,required):
                    Id of useful link
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('useful_links_clicked')
        allowed_params = [
            'useful_link_id',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'useful_link_id' not in req:
            raise Exception('Parameter "useful_link_id" expected (lib)')
        if 'useful_link_id' in req:
            request_json['useful_link_id'] = req['useful_link_id']
        return self.__send_command(request_json)

    def useful_links_comment_add(self, req):
        """Useful Links add comment
            Activated From Version: 0.2.29
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                useful_link_id (integer,required):
                    Id of useful link
                comment (string,required):
                    Comment
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('useful_links_comment_add')
        allowed_params = [
            'useful_link_id',
            'comment',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'useful_link_id' not in req:
            raise Exception('Parameter "useful_link_id" expected (lib)')
        if 'comment' not in req:
            raise Exception('Parameter "comment" expected (lib)')
        if 'useful_link_id' in req:
            request_json['useful_link_id'] = req['useful_link_id']
        if 'comment' in req:
            request_json['comment'] = req['comment']
        return self.__send_command(request_json)

    def useful_links_comment_delete(self, req):
        """Useful Links remove comment
            Activated From Version: 0.2.29
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                useful_link_comment_id (integer,required):
                    Comment Id for useful link
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('useful_links_comment_delete')
        allowed_params = [
            'useful_link_comment_id',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'useful_link_comment_id' not in req:
            raise Exception('Parameter "useful_link_comment_id" expected (lib)')
        if 'useful_link_comment_id' in req:
            request_json['useful_link_comment_id'] = req['useful_link_comment_id']
        return self.__send_command(request_json)

    def useful_links_comment_list(self, req):
        """Useful Links list of comments
            Activated From Version: 0.2.29
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                useful_link_id (integer,required):
                    Id of useful link
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('useful_links_comment_list')
        allowed_params = [
            'useful_link_id',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'useful_link_id' not in req:
            raise Exception('Parameter "useful_link_id" expected (lib)')
        if 'useful_link_id' in req:
            request_json['useful_link_id'] = req['useful_link_id']
        return self.__send_command(request_json)

    def useful_links_delete(self, req):
        """Method for delete link by admin
            Activated From Version: 0.2.21
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                useful_link_id (integer,required):
                    Id of useful link
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('useful_links_delete')
        allowed_params = [
            'useful_link_id',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'useful_link_id' not in req:
            raise Exception('Parameter "useful_link_id" expected (lib)')
        if 'useful_link_id' in req:
            request_json['useful_link_id'] = req['useful_link_id']
        return self.__send_command(request_json)

    def useful_links_list(self, req):
        """Method will be return list of useful links
            Activated From Version: 0.2.21
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                filter (string,optional):
                    Filter by word
                filter_by_tag (string,optional):
                    Filter by tag
                page_index (integer,optional):
                    Page Index
                page_size (integer,optional):
                    Page Size (default 10)
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('useful_links_list')
        allowed_params = [
            'filter',
            'filter_by_tag',
            'page_index',
            'page_size',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'filter' in req:
            request_json['filter'] = req['filter']
        if 'filter_by_tag' in req:
            request_json['filter_by_tag'] = req['filter_by_tag']
        if 'page_index' in req:
            request_json['page_index'] = req['page_index']
        if 'page_size' in req:
            request_json['page_size'] = req['page_size']
        return self.__send_command(request_json)

    def useful_links_retrieve(self, req):
        """Method for retrieve useful link
            Activated From Version: 0.2.28
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                useful_link_id (integer,required):
                    Id of useful link
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('useful_links_retrieve')
        allowed_params = [
            'useful_link_id',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'useful_link_id' not in req:
            raise Exception('Parameter "useful_link_id" expected (lib)')
        if 'useful_link_id' in req:
            request_json['useful_link_id'] = req['useful_link_id']
        return self.__send_command(request_json)

    def useful_links_tag_add(self, req):
        """Useful Links add tag
            Activated From Version: 0.2.29
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                useful_link_id (integer,required):
                    Id of useful link
                tag (string,required):
                    Tag Value
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('useful_links_tag_add')
        allowed_params = [
            'useful_link_id',
            'tag',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'useful_link_id' not in req:
            raise Exception('Parameter "useful_link_id" expected (lib)')
        if 'tag' not in req:
            raise Exception('Parameter "tag" expected (lib)')
        if 'useful_link_id' in req:
            request_json['useful_link_id'] = req['useful_link_id']
        if 'tag' in req:
            request_json['tag'] = req['tag']
        return self.__send_command(request_json)

    def useful_links_tag_delete(self, req):
        """Useful Links remove tag
            Activated From Version: 0.2.29
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                useful_link_id (integer,required):
                    Useful Link Id
                tag (string,required):
                    Tag Value
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('useful_links_tag_delete')
        allowed_params = [
            'useful_link_id',
            'tag',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'useful_link_id' not in req:
            raise Exception('Parameter "useful_link_id" expected (lib)')
        if 'tag' not in req:
            raise Exception('Parameter "tag" expected (lib)')
        if 'useful_link_id' in req:
            request_json['useful_link_id'] = req['useful_link_id']
        if 'tag' in req:
            request_json['tag'] = req['tag']
        return self.__send_command(request_json)

    def useful_links_tag_list(self, req):
        """Useful Links - List of tags
            Activated From Version: 0.2.29
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('useful_links_tag_list')
        allowed_params = []
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        return self.__send_command(request_json)

    def useful_links_update(self, req):
        """Method for update useful link
            Activated From Version: 0.2.21
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                useful_link_id (integer,required):
                    Id of useful link
                url (string,required):
                    URL
                description (string,required):
                    Description
                author (string,required):
                    Author
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('useful_links_update')
        allowed_params = [
            'useful_link_id',
            'url',
            'description',
            'author',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'useful_link_id' not in req:
            raise Exception('Parameter "useful_link_id" expected (lib)')
        if 'url' not in req:
            raise Exception('Parameter "url" expected (lib)')
        if 'description' not in req:
            raise Exception('Parameter "description" expected (lib)')
        if 'author' not in req:
            raise Exception('Parameter "author" expected (lib)')
        if 'useful_link_id' in req:
            request_json['useful_link_id'] = req['useful_link_id']
        if 'url' in req:
            request_json['url'] = req['url']
        if 'description' in req:
            request_json['description'] = req['description']
        if 'author' in req:
            request_json['author'] = req['author']
        return self.__send_command(request_json)

    def useful_links_user_favorite(self, req):
        """Useful Links add to favorite
            Activated From Version: 0.2.29
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                useful_link_id (integer,required):
                    Id of useful link
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('useful_links_user_favorite')
        allowed_params = [
            'useful_link_id',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'useful_link_id' not in req:
            raise Exception('Parameter "useful_link_id" expected (lib)')
        if 'useful_link_id' in req:
            request_json['useful_link_id'] = req['useful_link_id']
        return self.__send_command(request_json)

    def useful_links_user_favorite_list(self, req):
        """Useful Links list of favorite
            Activated From Version: 0.2.29
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('useful_links_user_favorite_list')
        allowed_params = []
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        return self.__send_command(request_json)

    def useful_links_user_propose(self, req):
        """Useful Links propose link by user
            Activated From Version: 0.2.29
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                url (string,required):
                    Url
                description (string,required):
                    Description
                tags (string,required):
                    tags
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('useful_links_user_propose')
        allowed_params = [
            'url',
            'description',
            'tags',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'url' not in req:
            raise Exception('Parameter "url" expected (lib)')
        if 'description' not in req:
            raise Exception('Parameter "description" expected (lib)')
        if 'tags' not in req:
            raise Exception('Parameter "tags" expected (lib)')
        if 'url' in req:
            request_json['url'] = req['url']
        if 'description' in req:
            request_json['description'] = req['description']
        if 'tags' in req:
            request_json['tags'] = req['tags']
        return self.__send_command(request_json)

    def useful_links_user_propose_approve(self, req):
        """Useful Links Approve propose link by admin
            Activated From Version: 0.2.29
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                useful_links_propose_id (integer,required):
                    Id of propose for useful_links
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('useful_links_user_propose_approve')
        allowed_params = [
            'useful_links_propose_id',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'useful_links_propose_id' not in req:
            raise Exception('Parameter "useful_links_propose_id" expected (lib)')
        if 'useful_links_propose_id' in req:
            request_json['useful_links_propose_id'] = req['useful_links_propose_id']
        return self.__send_command(request_json)

    def useful_links_user_unfavorite(self, req):
        """Useful Links removed from favorite
            Activated From Version: 0.2.29
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                useful_link_id (integer,required):
                    Id of useful link
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('useful_links_user_unfavorite')
        allowed_params = [
            'useful_link_id',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'useful_link_id' not in req:
            raise Exception('Parameter "useful_link_id" expected (lib)')
        if 'useful_link_id' in req:
            request_json['useful_link_id'] = req['useful_link_id']
        return self.__send_command(request_json)

    def user(self, req):
        """Return user info
            Deprecated From Version: 0.2.17
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                userid (integer,optional):
                    Id of user
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('user')
        allowed_params = [
            'userid',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'userid' in req:
            request_json['userid'] = req['userid']
        return self.__send_command(request_json)

    def user_change_password(self, req):
        """This method for change user password
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                password_old (string,required):
                    Old password
                password_new (string,required):
                    New password
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('user_change_password')
        allowed_params = [
            'password_old',
            'password_new',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'password_old' not in req:
            raise Exception('Parameter "password_old" expected (lib)')
        if 'password_new' not in req:
            raise Exception('Parameter "password_new" expected (lib)')
        if 'password_old' in req:
            request_json['password_old'] = req['password_old']
        if 'password_new' in req:
            request_json['password_new'] = req['password_new']
        return self.__send_command(request_json)

    def user_reset_password(self, req):
        """Method for reset password
            Permissins:
                Allowed access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                email (string,required):
                    E-mail
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('user_reset_password')
        allowed_params = [
            'email',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'email' not in req:
            raise Exception('Parameter "email" expected (lib)')
        if 'email' in req:
            request_json['email'] = req['email']
        return self.__send_command(request_json)

    def user_skills(self, req):
        """Return user skills info
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                userid (integer,required):
                    Id of user
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('user_skills')
        allowed_params = [
            'userid',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'userid' not in req:
            raise Exception('Parameter "userid" expected (lib)')
        if 'userid' in req:
            request_json['userid'] = req['userid']
        return self.__send_command(request_json)

    def user_update(self, req):
        """Update user info
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                userid (integer,required):
                    Id of user
                nick (string,optional):
                    Nick of user
                university (string,optional):
                    University of user
                about (string,optional):
                    About of user
                country (string,optional):
                    Country of user
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('user_update')
        allowed_params = [
            'userid',
            'nick',
            'university',
            'about',
            'country',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'userid' not in req:
            raise Exception('Parameter "userid" expected (lib)')
        if 'userid' in req:
            request_json['userid'] = req['userid']
        if 'nick' in req:
            request_json['nick'] = req['nick']
        if 'university' in req:
            request_json['university'] = req['university']
        if 'about' in req:
            request_json['about'] = req['about']
        if 'country' in req:
            request_json['country'] = req['country']
        return self.__send_command(request_json)

    def users(self, req):
        """Method return list of users
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                filter_text (string,optional):
                    Filter by user email or nick
                filter_role (string,optional):
                    Filter by user role
                onpage (integer,optional):
                    On Page
                page (integer,optional):
                    Number of page
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('users')
        allowed_params = [
            'filter_text',
            'filter_role',
            'onpage',
            'page',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'filter_text' in req:
            request_json['filter_text'] = req['filter_text']
        if 'filter_role' in req:
            request_json['filter_role'] = req['filter_role']
        if 'onpage' in req:
            request_json['onpage'] = req['onpage']
        if 'page' in req:
            request_json['page'] = req['page']
        return self.__send_command(request_json)

    def users_add(self, req):
        """Method for add new user
            Activated From Version: 0.2.17
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                uuid (string,required):
                    User's Global Unique Identifier
                email (string,required):
                    User's E-mail
                nick (string,required):
                    User's nick
                password (string,required):
                    Password
                role (string,required):
                    User's role
                university (string,optional):
                    University
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('users_add')
        allowed_params = [
            'uuid',
            'email',
            'nick',
            'password',
            'role',
            'university',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'uuid' not in req:
            raise Exception('Parameter "uuid" expected (lib)')
        if 'email' not in req:
            raise Exception('Parameter "email" expected (lib)')
        if 'nick' not in req:
            raise Exception('Parameter "nick" expected (lib)')
        if 'password' not in req:
            raise Exception('Parameter "password" expected (lib)')
        if 'role' not in req:
            raise Exception('Parameter "role" expected (lib)')
        if 'uuid' in req:
            request_json['uuid'] = req['uuid']
        if 'email' in req:
            request_json['email'] = req['email']
        if 'nick' in req:
            request_json['nick'] = req['nick']
        if 'password' in req:
            request_json['password'] = req['password']
        if 'role' in req:
            request_json['role'] = req['role']
        if 'university' in req:
            request_json['university'] = req['university']
        return self.__send_command(request_json)

    def users_change_email(self, req):
        """Method for email changing
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                email (string,required):
                    New E-mail
                password (string,required):
                    Password
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('users_change_email')
        allowed_params = [
            'email',
            'password',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'email' not in req:
            raise Exception('Parameter "email" expected (lib)')
        if 'password' not in req:
            raise Exception('Parameter "password" expected (lib)')
        if 'email' in req:
            request_json['email'] = req['email']
        if 'password' in req:
            request_json['password'] = req['password']
        return self.__send_command(request_json)

    def users_change_email_verification(self, req):
        """Method for email changing verification
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                code (string,required):
                    Verification code
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('users_change_email_verification')
        allowed_params = [
            'code',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'code' not in req:
            raise Exception('Parameter "code" expected (lib)')
        if 'code' in req:
            request_json['code'] = req['code']
        return self.__send_command(request_json)

    def users_delete(self, req):
        """Method for deleting a user
            Permissins:
                Denied access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                userid (integer,required):
                    User's id
                password (string,required):
                    Admin's password
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('users_delete')
        allowed_params = [
            'userid',
            'password',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'userid' not in req:
            raise Exception('Parameter "userid" expected (lib)')
        if 'password' not in req:
            raise Exception('Parameter "password" expected (lib)')
        if 'userid' in req:
            request_json['userid'] = req['userid']
        if 'password' in req:
            request_json['password'] = req['password']
        return self.__send_command(request_json)

    def users_info(self, req):
        """Return user info
            Activated From Version: 0.2.17
            Permissins:
                Allowed access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                uuid (integer,required):
                    Global unique identify of user
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('users_info')
        allowed_params = [
            'uuid',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'uuid' not in req:
            raise Exception('Parameter "uuid" expected (lib)')
        if 'uuid' in req:
            request_json['uuid'] = req['uuid']
        return self.__send_command(request_json)

    def users_registration(self, req):
        """Method for registration
            Permissins:
                Allowed access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                email (string,required):
                    E-mail
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('users_registration')
        allowed_params = [
            'email',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'email' not in req:
            raise Exception('Parameter "email" expected (lib)')
        if 'email' in req:
            request_json['email'] = req['email']
        return self.__send_command(request_json)

    def users_registration_verification(self, req):
        """Method for registration verification
            Permissins:
                Allowed access for unauthorized users
                Denied access for users
                Denied access for admins
            Args:
                code (string,required):
                    Verification code
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('users_registration_verification')
        allowed_params = [
            'code',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'code' not in req:
            raise Exception('Parameter "code" expected (lib)')
        if 'code' in req:
            request_json['code'] = req['code']
        return self.__send_command(request_json)

    def users_tokens(self, req):
        """List of active user tokens
            Activated From Version: 0.2.26
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('users_tokens')
        allowed_params = []
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        return self.__send_command(request_json)

    def users_tokens_delete(self, req):
        """Delete user tokens
            Activated From Version: 0.2.27
            Permissins:
                Denied access for unauthorized users
                Allowed access for users
                Allowed access for admins
            Args:
                tokenid (integer,required):
                    Token ID
        """
        if not self.has_connection():
            return None
        request_json = self.generate_base_command('users_tokens_delete')
        allowed_params = [
            'tokenid',
        ]
        for param_name in req:
            if param_name not in allowed_params:
                raise Exception('Excess parameter "' + param_name + '" (lib)')
        if 'tokenid' not in req:
            raise Exception('Parameter "tokenid" expected (lib)')
        if 'tokenid' in req:
            request_json['tokenid'] = req['tokenid']
        return self.__send_command(request_json)
